#charset "us-ascii"
#include <advlite.h>

// Flogg and Grabby. Also the scene involving getting the car out of the creek.

//--------------------------------------------------------------------------
// towTruckScene:
//--------------------------------------------------------------------------

towTruck: Heavy 'tow truck; bright yellow'
    "The tow truck is sturdily built and has a jaunty air thanks to its fresh
    coat of bright yellow paint. A heavy metal chain runs from the winch on
    the back of the truck down the slope to the rear axle of the Lamborghini.
    The driver is fussing around the chain, making sure it's not tangled. "
;

towTruckScene: Scene
    startsWhen = (flogg.getOutermostRoom() != worldHeadquarters)
    turnCtr = 0
    sawArrival = nil
    eachTurn() {
        ++turnCtr;
        local loc = gPlayerChar.getOutermostRoom();
        if ((turnCtr == 10) && (loc == parkingLot)) {
            "A bright yellow truck barrels into the parking lot and swerves
            off in the direction of the employee parking area. ";
            // The point of sawArrival is that if the player sees the tow truck
            // in the main parking lot and then follows it sw, we don't want
            // to show the truck's arrival a second time.
            sawArrival = true;
        }
        if (turnCtr == 11) {
            if (loc == employeeParking)
                "A bright yellow tow truck <<if (!sawArrival)>>careens into
                <<else>>has drawn up at the west side of <<end>>the
                employee parking lot. As you watch, the driver hops out and attaches a chain
                to the rear axle of the Lamborghini. ";
            towTruck.moveInto (employeeParking);
        }
        if (turnCtr == 15) {
            if (loc == employeeParking)
                "The chassis of the tow truck groans as the winch turns, dragging the
                Lamborghini up out of the creek. ";
            wreckedLamborghini.readyToTow = true;
        }
        if (turnCtr == 18) {
            if (loc == employeeParking)
                "The tow truck driver says, <q>Okay, boys, ready to roll. You want to
                ride along?</q>
                <.p>Grabby nods mutely. Flogg shrugs. They both climb into the cab of the
                truck, the truck coughs into life, and the wrecked Lamborghini is
                unceremoniously hauled away. ";
            flogg.moveInto(nil);
            grabby.moveInto(nil);
            wreckedLamborghini.moveInto(nil);
            towTruck.moveInto(nil);
        }
        if (turnCtr == 19) {
            if (loc == parkingLot) "The tow truck rumbles across the parking lot,
                towing the wrecked Lamborghini. Before it
                heads out into the street, you glimpse both Flogg and Grabby sitting in the cab
                with the driver. Grabby is sobbing into a handkerchief, and Flogg is
                patting his shoulder in a rather bored and perfunctory manner. ";
            endsWhen = true;
            
        }
        if (turnCtr == 21) "Error --- this should never print. ";
    }
;
#ifdef __DEBUG
Test 'brake' ['sw', 'x car', 'get in car', 'release brake', 'out', 'gonear metal door'];
#endif
//--------------------------------------------------------------------------
// flogg:
//--------------------------------------------------------------------------

flogg: Actor 'Phineas Flogg; tall lean skinny thin; man owner boss; him' @worldHeadquarters
    "Phineas Flogg looks as if he might come from old New England stock. He's tall and,
    as they used to say, <q>lean as a rail.</q> His nose is hooked, his eyebrows gray and
    bushy, his jaw long and square. He's wearing a dark gray suit that looks as if possibly
    an undertaker gave it to Goodwill because it had been washed so often it wasn't
    black anymore. "
;

+ floggInOffice: ActorState
    isInitState = true
    specialDesc = "<<one of>>If the brass nameplate is accurate, the tall, thin man sitting
        behind the desk on the north side of the room must be Phineas Flogg. When you
        enter, he's leaning back with his feet up on his desk, but he drops them to
        the floor and sits up straight to regard you with a somewhat flinty, predatory
        smile<<or>>Phineas Flogg is sitting behind his desk, gazing fixedly at you<<stopping>>. "
    stateDesc = "He's sitting behind his desk, favoring you with a narrow and
        predatory smile. "
;

++ AskTopic @flogg
    "<q>Me? I'm just a humble merchant.</q> "
;

++ AskTopic @tGrabby
    "<q>Oh, Grabby is my business partner. Heck of a nice guy!</q> "
;

++ AskTopic @tGuards
    "<q>They keep an eye on everything for us,</q> he explains. <q>That video monitor system
    cost a pretty penny. It\'s set up with a video feed from a
    bunch of the shops. Ten years back, we had a huge burglary. On Christmas Eve,
    if you can believe that. We\'re not taking any chances now, no way! Any burglars
    try any breaking and entering, the guards\'ll spot them and haul them off to jail.</q> "
;

++ GiveShowTopic [coin1, coin2, coin3, coin4, coin5]
    "<q>That\'s one of our brilliant marketing innovations,</q> he tells you. <q>Stuffdollars
    are as good as any
    other kind of currency, as long as you spend them here in Stufftown!</q> "
;

++ AskTopic @tPower
    "<q>Money is power,</q> he tells you with a smug little grin. <q>If you mean the
    electrical power, that\'s shut down when it\'s not needed. No sense wasting money!</q> "
;

++ AskTopic @safeDoor
    "<q>Every successful business needs a big safe,</q> he says. <q>You\'d be surprised
    at some of the things we keep in there.</q> He chuckles unpleasantly. "
;

++ AskTopic @stufftownFromParkingLot
    "<q>We\'re proud of it!</q> he proclaims. <q>And we\'ve got great <<tPlans.makeFamiliar()>>plans!</q> "
;

++ AskTopic @tPlans
    "<q>We're changing the name to Stuff World! It will be huge!</q> "
;

++ AskTellTopic [tPromDress, tSamantha]
    "<q>I need to buy a prom dress for my daughter,</q> you tell him. <q>But the fashion
    boutique is closed.</q>
    <.p><q>The stores set their own hours,</q> he replies. <q>Can\'t help you with that.</q> "
;
+++ AltTopic
    "<q>I was buying a dress downstairs in Hot Rags,</q> you tell him. <q>And ... and I know
    this may be hard to believe, but one of the mannequins stole the dress!</q>
    <.p><q>Hard to believe? You could say that.</q> He doesn\'t seem to want to pursue the
    subject. "
    isActive = (bianca.phantomBiancaDaemonID != nil)
;

++ AskTellTopic, StopEventList [lamborghini]
    [
        '<q>I noticed that bright red Lamborghini out in the parking lot,</q> you comment.
        <.p><q>That fabulous little toy belongs to him,</q> Flogg says, pointing his
        bony thumb at Grabby.<<grabbyAltCarTopic.makeActive>>
        <.p>Grabby puffs out his chest proudly. <q>Ain\'t it a honey? It\'s mine. I paid
        cash, too, <<grabby.setKnownCarOwner()>>I\'ll have you know.</q> ',
        '<q>If you want to know anything more about that car,</q> Flogg says, <q>you may
        as well ask him.</q> '
    ]
;

+++ floggAltCarTopic: AltTopic
    "<q>If you want to know anything more about that car,</q> Flogg says, <q>you may
        as well ask him.</q> "
    isActive = nil
    makeActive() { isActive = true; }
;

++ AskTellTopic [wreckedLamborghini]
    topicResponse () {
        "<q>I'm afraid something bad has happened to that red Lamborghini in the parking
        lot,</q> you inform him. <q>Maybe <<if (grabby.knownCarOwner)>>somebody<<else>>whoever
        owns it<<end>> forgot to set the brake. While
        I was just standing there watching, it started rolling downhill. It ended up in
        the creek.</q>
        <.p>As Flogg opens his mouth to respond, Eustace Grabby leaps to his feet.
        <q>What??? My car, my beautiful new car!</q> Without a word, he dashes from the room.
        <.p>Phineas Flogg shakes his head sadly. <q>That car --- he really does love that
        car. In the creek, you say? I'd best go lend a hand. If you don't mind....</q> He
        ushers you out the door into the passageway, locks the door behind him, and
        hurries away.<.p> ";
        grabby.panicButton();
    }
;

+ floggWatching: ActorState
    specialDesc = "Phineas Flogg is standing nearby, watching his distraught business
        partner and possibly struggling to keep the corners of his mouth turned down
        in a sympathetic and sorrowful expression. "
    stateDesc = "He's watching Grabby pace up and down. "
;

//--------------------------------------------------------------------------
// grabby:
//--------------------------------------------------------------------------

grabby: Actor 'Eustace Grabby; short round fat greasy smiling; man owner boss; him' @worldHeadquarters
    "Eustace Grabby is as short and round as Phineas Flogg is tall and thin. Grabby's
    broad face is wreathed in a bright smile. Beneath his nattily tailored brown suit
    is a gold brocade vest, which contrasts oddly with a garish tie whose colored stripes
    are alternately orange, green, red, and violet. "
    specialDescOrder = 150
    knownCarOwner = nil
    setKnownCarOwner () { knownCarOwner = true; }
    // The panicButton method encapsulates all the stuff that happens when he
    // learns about the car wreck:
    panicButton () {
        floggAch.awardPointsOnce();
        grabby.moveInto(employeeParking);
        flogg.moveInto(employeeParking);
        gPlayerChar.moveInto(starkPassage);
        starkPassage.lookAroundWithin();
        headquartersInteriorDoor.makeOpen(nil);
        headquartersInteriorDoor.makeLocked(true);
        headquartersExteriorDoor.makeOpen(nil);
        // Because you'll need the passkey to get back in:
        headquartersExteriorDoor.makeLocked(true);
        grabby.setState(grabbyAgonizing);
        flogg.setState(floggWatching);
    }
;

+ stripedTie: Wearable
    'striped tie; garish loud multicolored multicolored multi colored diagonal; stripes'
    "Grabby's tie has diagonal colored stripes in a repeating pattern: pink, yellow,
    green, and blue, separated by wider areas of eggshell white. "
    wornBy = grabby
;

+ grabbyInOffice: ActorState
    isInitState = true
    specialDesc = "<<one of>>When he sees you, the man behind the desk on the south side of the
        room --- evidently this is Eustace Grabby, if the nameplate is to be believed ---
        beams at you and rubs his chubby hands together. <q>Well, hello!</q> he booms<<or>>
        Eustace Grabby is sitting behind his desk, his pink cheeks inflated by his
        broad, fixed smile<<stopping>>. "
    stateDesc = "He's sitting at his desk, smiling broadly at you. "
;

++ AskTopic @grabby
    "<q>Me? I'm just a humble merchant.</q> "
;

++ AskTopic @tGuards
    "<q>They keep an eye on everything for us,</q> he explains. <q>That video monitor system,
    did you see that? Expensive, let me tell you, but it\'s set up with a video feed from a
    bunch of different shops. Any burglars break in, the guards\'ll spot \'em, you bet!</q> "
;

++ AskTopic @tFlogg
    "<q>Oh, Flogg is my business partner. Heck of a nice guy!</q> "
;

++ GiveShowTopic [coin1, coin2, coin3, coin4, coin5]
    "<q>That\'s one of our many marketing innovations,</q> he explains. <q>As good as any
    other kind of money, as long as you spend it here in Stufftown!</q> "
;

++ AskTopic @safeDoor
    "<q>Just part of how you run a successful business,</q> he says. <q>That\'s where
    we keep our important stuff.</q> "
;

++ AskTopic @stufftownFromParkingLot
    "<q>We\'re proud of it!</q> he proclaims. <q>And we\'ve got great <<tPlans.makeFamiliar()>>plans!</q> "
;

++ AskTopic @tPlans
    "<q>We're changing the name to Stuff World! It will be huge!</q> "
;

++ AskTellTopic [tPromDress, tSamantha]
    "<q>I need to buy a prom dress for my daughter,</q> you tell him. <q>But the fashion
    boutique is closed.</q>
    <.p><q>The stores set their own hours,</q> he replies. <q>Can\'t help you with that.</q> "
;
+++ AltTopic
    "<q>I was buying a dress downstairs in Hot Rags,</q> you tell him. <q>And ... and I know
    this may be hard to believe, but one of the mannequins stole the dress!</q>
    <.p><q>Hard to believe? You could say that.</q> He doesn\'t seem to want to pursue the
    subject. "
    isActive = (bianca.phantomBiancaDaemonID != nil)
;

++ AskTellTopic, StopEventList [lamborghini]
    [
        '<q>I noticed that bright red Lamborghini out in the parking lot,</q> you comment.
        <.p>Grabby <<floggAltCarTopic.makeActive()>>puffs out his chest proudly.
        <q>Ain\'t it a honey? It\'s mine.<<grabby.setKnownCarOwner()>> I paid cash,
        too, I\'ll have you know.</q> ',
        
        '<q>You must be proud of that sports car,</q> you say.
        <.p><q>Oh, I am, I am!</q> Grabby responds, practically bouncing up and down
        in his chair. <q>If anything happened to it, I just don\'t know what I\'d do.
        I\'d just about go crazy!</q> '
    ]
;

+++ grabbyAltCarTopic: AltTopic
    "<q>You must be proud of that sports car,</q> you say.
    <.p><q>Oh, I am, I am!</q> Grabby responds, practically bouncing up and down
    in his chair. <q>If anything happened to it, I just don\'t know what I\'d do.
    I\'d just about go crazy!</q> "
    isActive = nil
    makeActive () { isActive = true; }
;

++ AskTellTopic [wreckedLamborghini]
    topicResponse () {
        "<q>I'm afraid something bad has happened to that red Lamborghini in the parking
        lot,</q> you inform him. <q>Maybe whoever owns it forgot to set the brake. While
        I was just standing there watching, it started rolling downhill. It ended up in
        the creek.</q>
        <.p>Eustace Grabby leaps to his feet. <q>What??? My car, my beautiful new car!</q>
        Without a word, he dashes from the room.
        <.p>Phineas Flogg shakes his head sadly. <q>That car --- he really does love that
        car. In the creek, you say? I'd best go lend a hand. If you don't mind....</q> He
        ushers you out the door into the passageway, locks the door behind him, and
        hurries away.<.p> ";
        grabby.panicButton();
    }
;

+ grabbyAgonizing: ActorState
    specialDesc = "Eustace Grabby is pacing up and down in the parking lot, moaning and
        tearing his hair. "
    stateDesc = "He's agonizing over the demise of his beloved Lamborghini. "
;
