#charset "us-ascii"
#include <adv3.h>
#include <en_us.h>
#include "1mazes.h"

// -------------------------------------------------------------------
// TABLE OF CONTENTS
// -------------------------------------------------------------------

// FLYING STUFF: FLYINGTHING CLASS AND ITS SUBCLASSES
// FLYING STUFF: FLYINGTHING OBJECTS
// FLYING STUFF: MESSY SUBSTANCES
// FOOD/DRINK: Satiating, Quenching
// FOOD/DRINK: FLOWING STUFF: FlowingInContainer class
// FOOD/DRINK: FLOWING STUFF: FlowingInContainer subclasses
// FOOD/DRINK: FLOWING STUFF: FlowingInContainer objects: FlowingInOpenableBottle objects
// FOOD/DRINK: FLOWING STUFF: FlowingInContainer objects: FlowingInGlass objects
// FOOD/DRINK: FLOWING STUFF: FlowingInContainer objects: FlowingInOpenableBag objects
// FOOD/DRINK: FLOWING STUFF: FlowingInContainer objects: FlowingInBowl objects
// FOOD/DRINK: FLOWING STUFF: FlowingInContainer objects: FlowingInFlask objects
// FOOD/DRINK: ABLE SAL finish type
// FOOD/DRINK: FLOWING STUFF: ExFlowingContainer and subclasses
// FOOD/DRINK: FLOWING STUFF: ExFlowingContainer objects: ExFlowingFlask objects
// FOOD/DRINK: FLOWING STUFF: ExFlowingContainer objects: ExFlowingOpenableBottle objects
// FOOD/DRINK: FLOWING STUFF: ExFlowingContainer objects: ExFlowingGlass objects
// FOOD/DRINK: FLOWING STUFF: ExFlowingContainer objects: ExFlowingOpenableBag objects
// FOOD/DRINK: FLOWING STUFF: ExFlowingContainer objects: ExFlowingBowl objects
// FOOD/DRINK: WRAPPER/WRAPPABLE STUFF: Food modifications for Wrappable
// FOOD/DRINK: WRAPPER/WRAPPABLE STUFF: Wrappable listers
// FOOD/DRINK: WRAPPER/WRAPPABLE STUFF: "unwrapped" precondition
// FOOD/DRINK: WRAPPER/WRAPPABLE STUFF: Wrappable class, etc.
// FOOD/DRINK: WRAPPER/WRAPPABLE STUFF: Wrapper class, etc.
// FOOD/DRINK: WRAPPER/WRAPPABLE STUFF: Wrappable/Wrapper objects
// FOOD/DRINK: Non-wrappable food
// FOOD/DRINK: FoodCan class and objects
// TRANSFORMATIONS: TRANSFORMED THINGS: Miscellaneous things
// TRANSFORMATIONS: TRANSFORMED THINGS: Nonsense, SemiNonsense classes
// TRANSFORMATIONS: TRANSFORMED THINGS: Nonsense objects
// OBSOLETE ACHIEVEMENT STUFF
// TRANSFORMATIONS: Transformation functions
// DEBUGGING STUFF

// -------------------------------------------------------------------
// FLYING STUFF: FLYINGTHING CLASS AND ITS SUBCLASSES
// -------------------------------------------------------------------

// Note that, aside from the original flying fish objects, no flying objects
// need ever change back into anything. They will never be around for
// a full turn; they can never be interacted with.
class FlyingThing: Distant
  desc = "<<flyingDesc>>It has been launched into the air and is
    sailing south from here in a slow arc. "
  launchMsg = "A single fish shoots out of the slot and sails 
    up high into the air. You look quizzically at the fish 
    as it flies away from you. It looks like <<aName>>! "
  specialDesc = "\^<<aName>> has been launched 
    into the air and is sailing south from here in a slow arc. "
  //fallVanishMsg = "The flying bobtail snipe eel reaches the top
  //  of its arc and continues sailing south, through the skyway 
  //  and beyond, where it miraculously falls directly into a 
  //  <<glob.largeDrain>> at the bottom of the stairs. "
  specialDescBeforeContents = nil
  fallVanishMsg = "The flying <<name>> 
    <<isPlural ? 'reach' : 'reaches'>> 
    the top of <<itPossAdj>> arc and continues sailing south,
    through the skyway and 
    <<slowingField.isOn ? 'past the slowing field' : 'to the bottom of the stairs'>>,
    where <<itNom>> <<isPlural ? 'fall' : 'falls'>>
    straight into a <<glob.largeDrain>>. "
  tooDistantMsg = 'No way. It<./s>s high in the air and sailing away from you. '
  imminentlyFalling = true
  flyingSize = 2
  hitAlien(guy) {
    if (flyingSize >= 3) {
      "The flying <<name>> reach<<isPlural ? '' : 'es'>> 
        the top of <<itPossAdj>> arc and 
        fall<<isPlural ? '' : 's'>> down. You stare in amazement as
        <<ofKind(FlyingFish) ? 'the huge fish' : 'the huge ' + name>> 
        land<<isPlural ? '' : 's'>> directly on top of 
        <<guy.theName>>, knocking
        him off his feet<<guy.location == hallway6 ? '' 
        : ' and sending him careening down the hallway'>>.
        He keeps reaching for something to steady himself, but he 
        can<./s>t manage to do it, and both he and <<theName>> fall
        down into a <<glob.largeDrain>> at the bottom
        of the stairs. His scream recedes into the distance.
        <p>Well, now. That<./s>s one way to take care of a hostile alien. ";
      guy.moveInto(nil);
    }
    else {
      "The flying <<name>> reach<<isPlural ? '' : 'es'>>
        the top of <<itPossAdj>> arc and
        fall<<isPlural ? '' : 's'>> down. Amazingly, 
        <<itNom>> bounce<<isPlural ? '' : 's'>> directly off of
        <<guy.theName>><./s>s 
        <<rand('shoulder', 'forehead', 'arm')>><<bounceNoise>>,
        sail<<isPlural ? '' : 's'>> through the air, and 
        fall<<isPlural ? '' : 's'>> straight down into a 
        <<glob.largeDrain>> at the bottom of the stairs. 
        <p>";
      if (flyingSize >= 2)
        say(guy.projectileResponse3);
      else
        say(guy.projectileResponse2);
    }
  }
  //bounceNoise = ' with a loud <.q>thwack!<./q>'
  dobjFor(Read) asDobjFor(Examine)
  dobjFor(Smell) { verify() { } }
;

class FlyingFish: FlyingThing
  imminentlyFalling = nil
  bounceNoise() {
    if (flyingSize <= 1)
      return ' with a soft clap';
      //return ' with a soft <.q>thwack!<./q>';
    else
      return ' with a loud <.q>thwack!<./q>';
  }
;

class FlyingNonsense: FlyingThing
  transformText(thing1) {
    "<<thing1.nameTransformFrom>> <<thing1.verbToBe>> 
      transformed into 
      <<aName>>, whatever that is. ";
  }
  bounceNoise = ' with a loud <.q>smack!<./q>'
  isNonsense = true
  isSemiNonsense = true // i.e., yes, this is at least halfway to being nonsense
;

class FlyingPerson: FlyingThing, Actor
  flyingSize = 3
  fallVanishMsg = 
    "\^<<theName>>, 
      <<screamingInPanic>> 
      as <<itNom>> <<isPlural ? 'fly' : 'flies'>> through the air, 
      <<isPlural ? 'reach' : 'reaches'>> 
      the top of <<itPossAdj>> arc and 
      <<isPlural ? 'continue' : 'continues'>> sailing south.
      You stare in horror as <<itNom>> <<isPlural ? 'fly' : 'flies'>>
      <<slowingField.isOn ? 'through the slowing field and' : 'down the stairwell and'>>
      straight toward a <<glob.largeDrain>>. 
      Feebly, <<itNom>> <<isPlural ? 'spread' : 'spreads'>> 
      <<itPossAdj>> arms 
      to resist, but they are just deflected
      back as <<itNom>> <<isPlural ? 'fall' : 'falls'>> 
      down like a rock into the drain,
      <<itPossAdj>> screams receding into the distance.
      <<bounceFallAfterwardsMsg>>
      <p><<regretFallMsg>>"
      //<<itPossAdj>> screams receding very far into the distance
  //\^<<itPossAdj>>
  //    screams recede into the far distance. 
  //\^<<theName>>
  theFlyingName = ('The flying ' + name)
  regretFallMsg = "You hang your head in sadness. Surely, <<theName>>
    did not deserve such a fate. "
  regretFallMsg2(guy) { 
    "You stare in amazement, but you also feel sad. 
      Surely, <<theName>> did not deserve such a fate. 
      <p>Well, at least you<./s>ve
      gotten rid of <<guy.theName>>. "; 
  }
  bounceFallAfterwardsMsg = ""
  bounceFallMsg2 = ""
  hitAlien(guy) {
    "\^<<theName>>, 
      <<screamingInPanic>> 
      as <<itNom>> <<isPlural ? 'fly' : 'flies'>> through the air, 
      <<isPlural ? 'reach' : 'reaches'>> 
      the top of <<itPossAdj>> arc and falls down.
      You stare in horror as <<itNom>> land<<isPlural ? '' : 's'>>
      directly on top of <<guy.theName>>, crushing the
      alien<<guy.location == hallway6 ? ' and knocking him off his feet' 
      : ' and sending them both careening along the hallway'>>. 
      They both keep reaching for something to steady 
      themselves, but they can<./s>t manage to do it, and they
      both fall down into a <<glob.largeDrain>>
      at the bottom of the stairs,
      their screams receding into the distance. 
      <<bounceFallMsg2>>
      <p><<regretFallMsg2(guy)>> ";
    guy.moveInto(nil);
  }
  screamingInPanic = 'screaming in panic'
;

class FlyingSemiNonsense: object //mix-in class
  transformText(thing1) {
    "<<thing1.nameTransformFrom>> <<thing1.verbToBe>> 
      transformed into 
      <<aName>>, whatever that is. ";
  }
  isSemiNonsense = true
;

class FlyingPeople: FlyingPerson
  flyingSize = 3
;

class Pike: FlyingFish
  flyingSize = 3
;

class SnipeEel: FlyingFish
  flyingSize = 1
;

class Salmon: FlyingFish
  flyingSize = 3
;

modify glob
  largeDrain() {
    if (drain.getOutermostRoom != hallway6)
      return 'large but hitherto unnoticed drain';
    else
      return 'large drain';
  }
;

// -------------------------------------------------------------------
// FLYING STUFF: FLYINGTHING OBJECTS
// -------------------------------------------------------------------

minnow: FlyingFish 'minnow/fish' 'minnow'
  flyingDesc = "The minnow is a very small fish, 
    only a couple of inches long. "
  flyingSize = 1
;
trout: FlyingFish 'trout/fish' 'trout'
  flyingDesc = "The trout is about a foot long, spotted with green
    and brown. "
  flyingSize = 2
  zapT = transform(self, rou)
  zapAry = transform(self, tutor)
;
tuna: FlyingFish 'tuna fish' 'tuna'
  flyingDesc = "This tuna is a real whopper&mdash;stout, 
    silvery blue, and nearly six feet long. "
  flyingSize = 3
  zapT = transform(self, una)
  zapAry = transform(self, aunt)
;
gar: FlyingFish 'gar/fish' 'gar'
  flyingDesc = "It<./s>s not very big for a gar, perhaps only two feet long,
    with a characteristically thin snout. "
  //flyingDesc = "No small fish, this gar. It<./s>s at least three feet long,
  //  with a characteristically thin snout. "
  flyingSize = 2
  zapAry = transform(self, rag)
;
northernPike: Pike 'northern pike/fish' 'northern pike'
  flyingDesc = "It<./s>s a typical northern pike, though not huge,
    perhaps only two feet long. "
  flyingSize = 2
  zapAry = transform(self, kennethPrior)
  zapT = transform(self, norhernPike)
;
tetra: FlyingFish 'tetra/fish' 'tetra'
  flyingDesc = "The fish is only two or three inches long,
    but so distinctive in its coloration and appearance 
    that you<./s>re convinced, even from this distance, that 
    it must be a tetra. "
  flyingSize = 1
  zapT = disappear('The tetra disappears.
    <p>Unbeknownst to you, at the exact moment you 
      caused the tetra to 
      disappear, a freak wormhole opened up
      in the fabric of the space-time continuum and carried 
      your image back in time across centuries to 
      a distant galaxy, where a group of 
      squid-like creatures
      were debating how to deal with the seasonal influx
      of shark-like predatory fish.
    <p>One squid leader was just saying to another
      that he didn<./s>t agree that inviting the sharks 
      to an upcoming volleyball tournament as a
      form of appeasement was such a good idea, 
      when suddenly an image of you appeared 
      as you fired at the tetra and caused it to disappear. 
    <p>Suddenly the squid-like creatures raised 
      a tremendous cry of excitement. For the first time, 
      they conceived that they might defeat the 
      sharks by means of laser-based weaponry and thereby
      regain control of their underwater territory.
    <p>With that, they turned their laser industry,
      previously devoted entirely to light shows, into a
      booming anti-shark weapon industry, with which they
      eradicated the deadly sharks, saving themselves
      from the brink of extinction and allowing themselves 
      to flourish as never before.
    <p>But the triumphant squid-like creatures did not 
      forget their debt
      of gratitude to the strange humanoid creature
      who inspired them to transform their world. 
      For centuries to come, they would sing
      songs about him, tell stories about him, 
      and eventually erect a fifteen-mile-high statue of
      him (from the bottom of the deepest ocean trench all
      the way up to just a few feet below the ocean<./s>s 
      surface).
    <p>In every significant way, therefore, when the
      distant squid-like creatures witnessed
      you firing at the tetra, it 
      marked the beginning of a whole new era.
    <p>Not that any of this is evident to you right now,
      of course. For now, all you can see is that the tetra
      has disappeared. ', self, 'era')
  //zapT = disappear('The tetra disappears.
  //  <p>In generations to come, people will remember this moment 
  //  as The Time You Made the Tetra Disappear. They will write 
  //  songs about it and tell stories. Eventually the disappearing 
  //  tetra will cause such a huge change in society that 
  //  it will mark the beginning of a whole new era. 
  //  <p>For now, however, none of this is evident. All you 
  //  can presently see is that the tetra has disappeared. ', self)
  zapAry = transform(self, treat)
;
stickleback: FlyingFish 'stickleback/fish' 'stickleback'
  flyingDesc = "The fish is only two or three inches long,
    yet even from this distance you think you can see the 
    distinctive spines that clearly mark this fish as a 
    stickleback. "
  flyingSize = 1
  zapT = transform(self, sickleback)
;
seahorse: FlyingFish 'sea horse/seahorse/fish' 'seahorse'
  flyingDesc = "In light of recent events, this seahorse looks 
    to you almost like an alien creature from another 
    planet; certainly, it is unlike most any other type of 
    fish on Earth. "
  flyingSize = 1
  zapAry = die('The seahorse disappears, and for a moment you
    are extremely disoriented.
    Then, all of a sudden, you realize that you are underwater. 
    You struggle not to panic and try to swim upwards
    for air, but something holds you back. Now, really beginning
    to panic, you look through the water and observe that the
    entire bottom half of your body is buried in wet sand.
    You frantically dig at the sand, but
    it is useless, and you manage to gulp water into your lungs
    as you make the attempt. During the last few moments of your life, 
    you think, why did I transform that seahorse into a 
    seashore? '
    , 'seashore', self, killEverybody
  )
;
sturgeon: FlyingFish 'sturgeon/fish' 'sturgeon'
  flyingDesc = "It<./s>s very small, for a sturgeon, perhaps only 
    two feet long. It has a sleek body and a 
    characteristic tapering snout. "
  flyingSize = 2
  zapT = transform(self, surgeon)
;
oceanPerch: FlyingFish 'ocean perch/fish' 'ocean perch'
  flyingDesc = "This fish is very striking in that its whole body 
    is red. That, and its small size and general appearance, 
    naturally lead you to conclude that it must be an ocean perch. "
  flyingSize = 2
  zapAry = transform(self, nachoCrepe)
;
char: FlyingFish 'char/fish' 'char'
  flyingDesc = "It<./s>s a handsome char specimen, though not 
    particularly huge, just over a foot long. "
  flyingSize = 2
  zapAry = transform(self, arch)
;
bobtailSnipeEel: SnipeEel 'bobtail snipe eel/fish' 'bobtail snipe eel'
  flyingDesc = "From such a distance, you could be forgiven if you 
    looked at this thin, tiny fish and just called it a worm. 
    But no. To the discerning eye, this creature shows all the
    telling signs of the Cyematidae family, leaving no doubt that
    it can only be a bobtail snipe eel. "
  flyingSize = 1
  zapT = transform(self, bobailSnipeEel)
  zapAry = transform(self, alienBiblePoets)
;
bream: FlyingFish 'bream/fish' 'bream'
  flyingDesc = "A handsome bream specimen, though not particularly 
    large, perhaps a foot long. "
  flyingSize = 2
  zapAry = transform(self, amber)
;
oregonChub: FlyingFish 'oregon chub/fish' 'Oregon chub'
  flyingDesc = "This fish has the distinctive body shape of a chub, 
    and yet it is only about three inches long. This perplexes you 
    at first, but then you remember reading about the rare 
    and highly endangered Oregon chub, which is surely what this 
    fish is. "
  flyingSize = 1
  zapAry = transform(self, hugeBronco)
;
tarpon: FlyingFish 'tarpon/fish' 'tarpon'
  flyingDesc = "This tarpon is a stout and truly gigantic fish, 
    perhaps five feet long, with large, iridescent scales. "
  flyingSize = 3
  zapT = transform(self, arpon)
  zapAry = transform(self, patron)
;
carp: FlyingFish 'carp/fish' 'carp'
  flyingDesc = "This carp is only a foot or so long, hardly a 
    full-grown adult. "
  flyingSize = 2
  //askAry = question(nil,
  //  'Are you apt to be offended by toilet humor? ')
  zapAry = transform(self, crap)
;
atlanticSalmon: Salmon 'atlantic salmon/fish' 'Atlantic salmon'
  flyingDesc = "You<./s>ve seen Atlantic salmon before, but never
    one as huge as this. It must be five feet long. Astonishing. "
  flyingSize = 3
  zapT = transform(self, alanicSalmon)
  zapAry = transform(self, satanicTollman)
;
africanLungfish: FlyingFish
  'african lung lungfish/fish' 'African lungfish'
  flyingDesc = "The fish is thin and only about a foot long, with 
    the skinny pectoral and pelvic fins that surely no one could
    fail to associate with the African lungfish. "
  flyingSize = 2
  zapAry = die(
    'In an instant, the African lungfish is transformed 
    into a breathtaking series of Hungarian cliffs! Aside from the
    cliffs<./s> awesome natural beauty, the most striking thing about them 
    is the fact that they have materialized in and around 
    the building that you inhabit, with the result that your body
    has just been encased in solid granite. '
    , 'Hungarian cliffs', self, killEverybody
  )
;
oto: FlyingFish
  '(cat) (dwarf) catfish/fish/oto/sucker/otocinclus' 'oto'
  flyingDesc = "This little fish, though perhaps unremarkable to 
    the average person, is recognizable to any aquarium owner
    as a dwarf catfish of the genus <i>Otocinclus,</i> 
    affectionately known as an oto. "
  flyingSize = 1
  zapT = transform(self, oo)
;


rou: FlyingNonsense 'rou' 'rou'
;
tutor: FlyingPerson 'learned tutor' 'tutor' isHer=true
  flyingSize = 3
  nameTransformInto = 'a learned tutor'
;
oo: FlyingPerson 'oo' 'Oo'
  flyingSize = 3
  aWordName = 'an Oo'
  isHim = true
;
una: FlyingNonsense 'una' 'una'
;
aunt: FlyingPerson 'aunt' 'aunt' isHer=true
  transformText(thing1) {
    "<<thing1.nameTransformFrom>> <<thing1.verbToBe>> 
      transformed into 
      a woman who looks familiar. Oh my goodness! 
      Is that your aunt? ";
  }
  flyingSize = 3
  theName = 'your aunt'
  aName = 'your aunt'
  //fallVanishMsg = "Your aunt, screaming in panic 
  //  as she sails through the air, reaches 
  //  the top of <<itPossAdj>> arc and continues sailing south,
  //  through the skyway and 
  //  <<slowingField.isOn ? 'past the slowing field' : 'beyond'>>.
  //  You stare in horror as she falls
  //  straight into a <<glob.largeDrain>> at the bottom of
  //  the stairs. 
  //  Feebly, your aunt spreads <<itPossAdj>> arms 
  //  and legs to resist, but <<itPossAdj>> limbs are just deflected
  //  back, and <<itNom>> falls rapidly down the drain, screaming
  //  as she goes. 
  //  <p><<regretFallMsg>> "
  regretFallMsg = "You hang your head in sadness. You always liked 
    your aunt. Surely, if anyone deserved better, it was her. "
  regretFallMsg2(guy) { 
    "You stare in amazement, but you also feel sad. 
      You always liked your aunt. Certainly, she deserved
      better than this. 
      <p>Well, at least you<./s>ve
      gotten rid of <<guy.theName>>. "; 
  }
;
rag: FlyingThing 'old rag' 'rag'
  nameTransformInto = 'a flimsy rag'
  fallVanishMsg = "The flying <<name>> 
    <<isPlural ? 'reach' : 'reaches'>> 
    the top of <<itPossAdj>> arc and continues fluttering south 
    through the skyway. At the end of a long glide, it finally
    sails <<slowingField.isOn ? 
    'through the slowing field' : 'down the stairwell'>>
    and descends straight into a <<glob.largeDrain>>. "
  hitAlien(guy) {
    "The flying <<name>> reach<<isPlural ? '' : 'es'>>
      the top of <<itPossAdj>> arc and
      flutter<<isPlural ? '' : 's'>> down. It happens to gently
      brush against <<guy.theName>><./s>s 
      <<rand('shoulder', 'forehead', 'arm')>> 
      before it flutters further, eventually falling straight down 
      into a <<glob.largeDrain>> 
      at the bottom of the stairs. 
      <p>";
    say(guy.projectileResponse1);
  }
;
norhernPike: FlyingSemiNonsense, Pike 'norhern pike/fish' 'norhern pike'
  imminentlyFalling = true
  flyingSize = 2
;
kennethPrior: FlyingPerson 'kenneth prior' 'Kenneth Prior'
  isProperName = true
  isHim = true
  regretFallMsg = "You hang your head in sadness. Kenneth Prior
    was just a theologian. He never did any harm to anybody. 
    Surely, if anyone deserved better, it was him. "
  regretFallMsg2(guy) { 
    "You stare in amazement, but you also feel sad. 
      Kenneth Prior never did any harm to anybody. 
      Certainly, he deserved better than this. 
      <p>Well, at least you<./s>ve
      gotten rid of <<guy.theName>>. "; 
  }
  transformText(thing1) {
    "<<thing1.nameTransformFrom>> is transformed into 
      Kenneth Prior, author of <i>The Way of Holiness!</i> ";
  }
  flyingSize = 3
;
treat: FlyingThing '(little) dog treat' 'treat'
  nameTransformInto = 'a little dog treat'
;
sickleback: FlyingPeople 'sickle back/sickleback' 'SickleBack'
;
surgeon: FlyingPerson 'surgeon' 'surgeon'
  flyingSize = 3
  transformText(thing1) {
    "The sturgeon is transformed into a man wearing a 
      face mask and wielding a scalpel. He looks like
      a surgeon! ";
  }
  bounceFallAfterwardsMsg = "His scalpel bounces around the edge 
    of the drain, then falls down after him. "
  bounceFallMsg2 = "" // The scalpel is in the alien's chest,
                      // so it can't bounce.
  isHim = true
  hitAlien(guy) {
    "\^<<theName>>, 
      <<screamingInPanic>> 
      as <<itNom>> <<isPlural ? 'fly' : 'flies'>> through the air, 
      <<isPlural ? 'reach' : 'reaches'>> 
      the top of <<itPossAdj>> arc and falls down.
      He sails straight towards <<guy.theName>>,
      and you stare in horror as the surgeon<./s>s scalpel
      stabs <<guy.theName>> directly in the chest. 
      \^<<guy.theName>>
      goggles in disbelief as the surgeon not only stabs him,
      but also crushes him
      <<guy.location == hallway6 ? 'and knocks him off his feet' 
      : 'and sends them both careening along the hallway'>>. 
      They both keep reaching for something to steady 
      themselves, but they can<./s>t manage to do it, and they
      both fall down into a <<glob.largeDrain>> 
      at the bottom of the stairs,
      their screams receding into the distance. 
      <<bounceFallMsg2>>
      <p><<regretFallMsg2(guy)>> ";
    guy.moveInto(nil);
  }
;
nachoCrepe: FlyingThing 'nacho crepe/cr\u00EApe' 'nacho cr\u00EApe'
  flyingSize = 1
  bounceNoise = ' with a loud <.q>splat!<./q>'
  transformText(thing1) {
    "The ocean perch is transformed into something that
      looks like a crispy tortilla, except that it is in the
      shape of a rolled-up pancake, and is filled with 
      what appears to be guacamole dip. If you had to 
      give it a name, you might call it a nacho cr\u00EApe. ";
  }
  hitAlien(guy) {
    "The flying <<name>> reach<<isPlural ? '' : 'es'>>
      the top of <<itPossAdj>> arc and
      fall<<isPlural ? '' : 's'>> down. Amazingly, 
      <<itNom>> land<<isPlural ? '' : 's'>> directly on
      <<guy.theName>><./s>s forehead<<bounceNoise>>,
      covering <<guy.theName>> with a thick shower
      of guacamole dip. The nacho cr\u00EApe then bounces,
      sail<<isPlural ? '' : 's'>> through the air, and 
      fall<<isPlural ? '' : 's'>> straight down into a 
      <<glob.largeDrain>> at the bottom of the stairs. 
      <p>";
    say(guy.projectileResponse4);
    "He tries to wipe off the guacamole dip as well
      as he can, but he remains a mess. ";
    guy.hasGuacamole = true;
    guacamoleSubstance.moveInto(guy);
  }
;
arch: FlyingThing 'arch' 'arch'
  flyingSize = 3
  nameTransformInto = 'a gigantic arch'
  fallVanishMsg = "The flying <<name>> 
    <<isPlural ? 'reach' : 'reaches'>> 
    the top of <<itPossAdj>> arc and continues sailing south,
    through the skyway and 
    <<slowingField.isOn ? 'past the slowing field' : 'to the bottom of the stairs'>>,
    where <<itNom>> <<isPlural ? 'fall' : 'falls'>>
    straight towards a <<glob.largeDrain>>. 
    But instead of falling through, the arch smashes against 
    both sides of the drain, raising a thunderous clatter. 
    It is just too big. But wait. The impact has created a crack
    at the apex of the arch, and now the arch is breaking in half. 
    The two sides easily fall down into the drain, 
    clattering noisily as they go. "
  hitAlien(guy) {
    "The flying <<name>> reach<<isPlural ? '' : 'es'>> 
      the top of <<itPossAdj>> arc and 
      fall<<isPlural ? '' : 's'>> down. You stare in amazement as
      one of its legs strikes <<guy.theName>> directly
      in the face, knocking
      him off his feet<<guy.location == hallway6 ? '' 
      : ' and sending him careening down the hallway'>>.
      The arch flies on ahead, straight towards a 
      <<glob.largeDrain>> at the bottom of the stairs.
      But instead of falling through, the arch smashes against 
      both sides of the drain, raising a thunderous clatter. 
      It is just too big. 
      <p>\^<<guy.theName>>,
      meanwhile, although badly injured, keeps reaching 
      for something to steady himself, but he 
      can<./s>t manage to do it, and he falls
      down into the large drain, 
      even while the arch teeters up above.
      His screams recede into the distance. 
      <p>And now, finally, it appears that the impact
      has created a crack in the apex of the arch,
      causing its two sides to fall apart.
      Both sides easily fall down into the drain, 
      clattering noisily as they do so. 
      <p>Well, now. That<./s>s one way to take care of a hostile alien. ";
    guy.moveInto(nil);
  }
;
bobailSnipeEel: FlyingSemiNonsense, SnipeEel 'bobail snipe eel/fish' 'bobail snipe eel'
  flyingSize = 1
  imminentlyFalling = true
;
alienBiblePoets: FlyingPeople 'alien bible poet poets/aliens' 'alien bible poets'
  flyingSize = 4
  isPlural = true
  nameTransformInto = 'an assembly of alien bible poets'
  transformText(thing1) {
    "The bobtail snipe eel is transformed into a whole group of aliens. 
        On closer inspection, they appear to be alien bible poets! ";
  }
  //screaming as they <<isPlural ? 'fly' : 'flies'>> through the air
  fallVanishMsg = 
    "The alien bible poets&mdash;offering hurried prayers for 
      deliverance in iambic pentameter
      as they sail through the air&mdash;<<isPlural ? 'reach' : 'reaches'>> 
      the top of <<itPossAdj>> arc and 
      <<isPlural ? 'continue' : 'continues'>> sailing south.
      You stare in horror as they fly
      <<slowingField.isOn ? 'through the slowing field and ' : ''>>towards
      the bottom of the stairs. They hit the floor with 
      a series of jarring thuds and careen out of control. 
      They all reach out to steady themselves, but they 
      can<./s>t manage to do it, 
      and they end up falling, one by one, into a 
      <<glob.largeDrain>> at the bottom of the stairs, 
      their screams receding into the distance.
      <p>You hang your head in sadness. You may have had 
      bad experiences with aliens recently, but those alien
      bible poets did nothing to you. Surely, they deserved 
      better. "
  //transformText(thing1) {
  //  "The bobtail snipe eel is transformed into something that
  //    looks like a crispy tortilla, except that it is in the
  //    shape of a rolled-up pancake, and is filled with 
  //    guacamole sauce. If you had to give it 
  //    a name, you might call it a nacho cr\u00EApe. ";
  //}
  hitAlien(guy) {
    "The alien bible poets, screaming as they 
      <<isPlural ? 'fly' : 'flies'>> through the 
      air&mdash;and also offering hurried prayers for 
      deliverance in dactylic 
      tetrameter&mdash;<<isPlural ? 'reach' : 'reaches'>> 
      the top of <<itPossAdj>> arc and fall down.
      Most of them sail along without incident, but
      one of them lands directly on top of <<guy.theName>>, 
      crushing the 
      <<guy.genericName>><<guy.location == hallway6 
      ? ' and knocking him off his feet' 
      : ' and sending them both careening along the hallway'>>. 
      Meanwhile, the other alien bible poets sail through the air
      and hit the floor at the bottom of the stairs 
      with a series of jarring thuds,
      tumbling out of control. Both <<guy.theName>>
      and all of the alien bible poets reach out to 
      steady themselves, but they can<./s>t manage to do it,
      and they end up falling, one by one, into a 
      <<glob.largeDrain>>, their screams receding into the 
      distance.
      <p>You stare in amazement, but you also feel a little sad. 
      You may have had 
      bad experiences with aliens recently, but those alien
      bible poets did nothing to you. Surely, they deserved 
      better.
      <p>Well, at least you<./s>ve gotten rid of <<guy.theName>>. ";
    guy.moveInto(nil);
  }
;
amber: FlyingThing 'piece amber' 'amber' 
  aName = name
  nameTransformInto = 'a large piece of amber'
;
hugeBronco: FlyingPerson 'huge bronco' 'huge bronco'
  flyingSize = 3
  screamingInPanic = 'squealing in panic'
  fallVanishMsg = 
    "\^<<theName>>, 
      <<screamingInPanic>> 
      as <<itNom>> <<isPlural ? 'fly' : 'flies'>> through the air, 
      <<isPlural ? 'reach' : 'reaches'>> 
      the top of <<itPossAdj>> arc and 
      <<isPlural ? 'continue' : 'continues'>> sailing south.
      You stare in horror as <<itNom>> <<isPlural ? 'fly' : 'flies'>>
      <<slowingField.isOn ? 'through the slowing field and' : 'down the stairwell and'>>
      straight toward a <<glob.largeDrain>>. 
      Feebly, it flails its legs
      to resist, but to no avail. It falls
      head-first into the drain, plummeting down into it like a rock,
      <<itPossAdj>> squeals receding into the distance.
      <<bounceFallAfterwardsMsg>>
      <p><<regretFallMsg>>"
  hitAlien(guy) {
    "\^<<theName>>, 
      <<screamingInPanic>> 
      as <<itNom>> <<isPlural ? 'fly' : 'flies'>> through the air, 
      <<isPlural ? 'reach' : 'reaches'>> 
      the top of <<itPossAdj>> arc and falls down.
      You stare in horror as <<itNom>> land<<isPlural ? '' : 's'>>
      directly on top of <<guy.theName>>, crushing the
      alien<<guy.location == hallway6 ? ' and knocking him off his feet' 
      : ' and sending them both careening along the hallway'>>. 
      \^<<guy.theName>>
      keeps reaching for something to steady himself, but
      he can<./s>t manage to do it, and they
      both fall down into a <<glob.largeDrain>> 
      at the bottom of the stairs,
      their screams receding into the distance. 
      <<bounceFallMsg2>>
      <p><<regretFallMsg2(guy)>> ";
    guy.moveInto(nil);
  }
  regretFallMsg2(guy) { 
    "You stare in amazement. It<./s>s really too bad about the 
      huge bronco, but hey, at least you got rid of 
      <<guy.theName>>. "; 
  }
;
patron: FlyingPerson 'patron' 'patron' isHim=true
  nameTransformInto = 'a patron'
  flyingSize = 3
  transformText(thing1) {
    "The tarpon is transformed into a wealthy man
      who, from the looks of it, probably gives 
      to all sorts of charities&mdash;a
      patron, if ever there was one. ";
  }
  //regretFallMsg = "You hang your head in sadness. Surely, 
  //  the generous patron did not deserve such a fate. "
;
arpon: FlyingNonsense 'arpon' 'arpon'
;
crap: FlyingThing 'pile crap' 'crap' aName=name
  bounceNoise = ' with a loud <.q>splat!<./q>'
  nameTransformInto = 'a pile of crap'
  hitAlien(guy) {
    "The flying <<name>> reach<<isPlural ? '' : 'es'>>
      the top of <<itPossAdj>> arc and
      fall<<isPlural ? '' : 's'>> down. Amazingly, 
      <<itNom>> land<<isPlural ? '' : 's'>> directly on
      <<guy.theName>><./s>s shoulder<<bounceNoise>>,
      covering <<guy.theName>> with a substance most foul. 
      <p>";
    say(guy.projectileResponse4);
    "He tries to wipe off the foul substance as well
      as he can, but he remains a mess. ";
    guy.hasCrap = true;
    crapSubstance.moveInto(guy);
  }
;
alanicSalmon: FlyingSemiNonsense, Salmon 'alanic salmon/fish' 'alanic salmon'
  flyingSize = 3
  imminentlyFalling = true
;
satanicTollman: FlyingPerson 'satanic tollman' 'Satanic tollman'
  isHim = true
  flyingSize = 3
  transformText(thing1) {
    "You gape in astonishment as 
      the Atlantic salmon morphs into a wraithlike figure in 
      black robes, carrying a scythe and a bag of coins. 
      He looks like a Satanic tollman! ";
  }
  regretFallMsg = "Well, it may be too optimistic to think that
    that<./s>s the last you<./s>ll ever see of Death, but at least you<./s>ve
    avoided him for the time being. "
  bounceFallAfterwardsMsg = "His scythe bounces around the edge 
    of the drain, then falls down after him. "
  bounceFallMsg2 = "The Satanic tollman<./s>s scythe bounces 
    around the edge of the drain, then falls down after them. "
  screamingInPanic = 'screaming in rage'
  hitAlien(guy) {
    "\^<<theName>>, 
      <<screamingInPanic>> 
      as <<itNom>> <<isPlural ? 'fly' : 'flies'>> through the air, 
      <<isPlural ? 'reach' : 'reaches'>> 
      the top of <<itPossAdj>> arc and falls down.
      You stare in horror as <<itNom>> land<<isPlural ? '' : 's'>>
      directly on top of <<guy.theName>>.
      His scythe barely misses <<guy.theName>><./s>s head, but
      he crushes the 
      <<guy.genericName>><<guy.location == hallway6 
      ? ' and knocks him off his feet' 
      : ' and sends them both careening along the hallway'>>. 
      They both keep reaching for something to steady 
      themselves, but they can<./s>t manage to do it, and they
      both fall down into a <<glob.largeDrain>>
      at the bottom of the stairs,
      their screams receding into the distance. 
      <<bounceFallMsg2>>
      <p><<regretFallMsg2(guy)>> ";
    guy.moveInto(nil);
  }
  regretFallMsg2(guy) { 
    "You stare in amazement. Well, you certainly got rid of
      <<guy.theName>>. And although it may be too optimistic
      to think that that<./s>s the last you<./s>ll ever see of Death,
      at least you<./s>ve gotten rid of him, too, for the time 
      being. "; 
  }
;

// -------------------------------------------------------------------
// FLYING STUFF: MESSY SUBSTANCES
// -------------------------------------------------------------------

class MessySubstance: Thing
  isListed = nil
  isListedInContents = nil
  isListedInInventory = nil
  refusalMsg = 'You have no intention of touching {that dobj/him}. '
  cannotTakeComponentMsg(loc) {
    return refusalMsg;
  }
  dobjFor(Default) {
    verify() {
      if (gDobj)
        illogical(refusalMsg);
    }
  }
  dobjFor(Examine) { verify() { inherited(); } }
  dobjFor(Read) { verify() { inherited(); } }
  dobjFor(ListenTo) { verify() { inherited(); } }
  dobjFor(ShowTo) { verify() { inherited(); } }
  dobjFor(Smell) { verify() { inherited(); } }
;
guacamoleSubstance: MessySubstance '(bad) guacamole dip/sauce' 'guacamole dip'
  "Aside from the fact that the guacamole dip
    is splattered all over <<location.theName>>,
    you see nothing special about it. "
  smellDesc = "The guacamole dip doesn<./s>t smell very appetizing. "
  refusalMsg = 'The guacamole dip looks rather disgusting, and you
    have no need to deal with it. '
;
crapSubstance: MessySubstance 'foul crap/substance/feces' 'crap'
  "\^<<location.theName>>
    has been splattered with a truly foul substance. "
  smellDesc = "Unsurprisingly, the crap does not at all
    smell like magnolias in bloom. "
  refusalMsg = 'You do not need to deal with that foul substance. '
;

// -------------------------------------------------------------------
// FOOD/DRINK: Satiating, Quenching
// -------------------------------------------------------------------

class Satiating: object
  foodName = name
  aFoodName = (aNameFrom(foodName))
  theFoodName = 'the ' + foodName
  devoursPhrase = 'devours bite after bite of ' + theFoodName
    + ' until it is gone'
  scarfsPhrase = 'scarfs down ' + theFoodName + ' in short order'
  beginsToDevourPhrase = 'begins to devour it'
  finishesDevouringPhrase = 'happily devours it'
  vickiGiveResponse {
    foodOfferReaction(vicki);
  }
  dianeGiveResponse {
    foodOfferReaction(diane);
  }
  //dianeGiveResponse {
  //  if (self == melon) {
  //    "<.q>No, no,<./q> says Diane. <.q>You<./s>re not going to 
  //      pawn that off on me.<./q> ";
  //  }
  //  else if (isRaw || isUnpeeled || ofKind(FoodCan) || tastiness <= 0) {
  //    "<.q>Okay, I<./s>ll take this off your hands, 
  //        if you insist,<./q> Diane says, taking <<theFoodName>>. ";
  //    baseMoveInto(diane);
  //  }
  //  else {
  //    if (diane.isHungry) {
  //      if (tastiness >= 4)
  //        "<.q>Now that<./s>s what I call food!<./q> ";
  //      else
  //        "<.q>Excellent!<./q> ";
  //      "exclaims Diane, taking <<theFoodName>>. 
  //        With that, she <<devoursPhrase>>. 
  //        Having done this, she says, ";
  //      if (diane.foodEaten + 1 < diane.satiationLevel)
  //        "<.q>Thanks, I needed that!<./q> ";
  //      else
  //        "<.q>Thanks, that was good.<./q> ";
  //      baseMoveInto(diane);
  //      if (ofKind(FlowingInContainer))
  //        processConsumption;
  //      else
  //        eatingConsequences;
  //      moveInto(nil);
  //      diane.foodEaten++;
  //    }
  //    else if (vicki.isHungry) {
  //      "<.q>Okay, I<./s>ll take this off your hands, 
  //          if you insist,<./q> Diane says, taking <<theFoodName>>. 
  //          But then she notices the look of longing 
  //          in Vicki<./s>s eyes, and she adds, <.q>Oh, hey, Vicki, 
  //          you can have this if you want.<./q> 
  //        <p>Gratefully accepting the offer, Vicki 
  //          <<devoursPhrase>>. <.q>Thanks, Diane,<./q> she says. ";
  //      baseMoveInto(vicki);
  //      if (ofKind(FlowingInContainer))
  //        processConsumption;
  //      else
  //        eatingConsequences;
  //      moveInto(nil);
  //      vicki.foodEaten++;
  //    }
  //    else {
  //      "<.q>Okay, I<./s>ll take this off your hands, 
  //          if you insist,<./q> Diane says, taking <<theFoodName>>. ";
  //      baseMoveInto(diane);
  //    }
  //  }
  //}
;

class Quenching: object
;

modify Thing
  foodOfferReaction(actor) {
    if (self == melon) {
      if (actor == vicki)
        "<.q>Uh, no thanks,<./q> says Vicki. ";
      else // diane
        "<.q>No, no,<./q> says Diane. <.q>You<./s>re not going to 
          pawn that off on me.<./q> ";
    }
    else if (isRaw || isUnpeeled || ofKind(FoodCan) || tastiness <= 0) {
      if (actor == vicki)
        "<.q>Okay, I<./s>ll tuck this away for safekeeping,<./q> 
          Vicki says, taking <<theNameForCommentary>>. ";
      else // diane
        "<.q>All right, I<./s>ll take this off your hands, 
          if you insist,<./q> Diane says, taking <<theNameForCommentary>>. ";
      baseMoveInto(actor);
    }
    else {
      if (actor.isHungry) {
        if (actor == vicki) {
          "<.q>Mmm. Thank you very much, <<me.firstName>>,<./q> 
            says Vicki as she takes <<theFoodName>>. 
            With that, she <<devoursPhrase>>. 
            Having done this, she breathes a contented sigh. ";
        }
        else { // diane
          if (tastiness >= 4)
            "<.q>Now that<./s>s what I call food!<./q> ";
          else
            "<.q>Excellent!<./q> ";
          "exclaims Diane, taking <<theFoodName>>. 
            With that, she <<devoursPhrase>>. 
            Having done this, she says, ";
          if (diane.foodEaten + 1 < diane.satiationLevel)
            "<.q>Thanks, I needed that!<./q> ";
          else
            "<.q>Thanks, that was good.<./q> ";
        }
        baseMoveInto(actor);
        if (ofKind(FlowingInContainer))
          processConsumption;
        else
          eatingConsequences;
        moveInto(nil);
        actor.foodEaten++;
      }
      else if (actor.companion.isHungry) {
        "<.q><<actor == vicki
            ? 'Okay, I<./s>ll tuck this away for safekeeping'
            : 'Okay, I<./s>ll take this off your hands, if you insist'>>,<./q> 
            <<actor.theName>> says, taking <<theFoodName>>. 
            But then she notices the look of 
            <<actor.companion == vicki ? 'longing' : 'jealousy'>>
            in <<actor.companion.theName>><./s>s eyes, and she adds, 
            <.q>Hey, <<actor.companion.theName>>, 
            you can have this if you want.<./q> 
          <p>Gratefully accepting the offer, <<actor.companion.theName>> 
            <<devoursPhrase>>. <.q>Thanks, <<actor.theName>>,<./q> she says. ";
        baseMoveInto(actor.companion);
        if (ofKind(FlowingInContainer))
          processConsumption;
        else
          eatingConsequences;
        moveInto(nil);
        actor.companion.foodEaten++;
      }
      else {
        if (actor == vicki)
          "<.q>Okay, I<./s>ll tuck this away for safekeeping,<./q> 
            Vicki says, taking <<theNameForCommentary>>. ";
        else // diane
          "<.q>All right, I<./s>ll take this off your hands, 
            if you insist,<./q> Diane says, taking <<theNameForCommentary>>. ";
        baseMoveInto(actor);
      }
    }
  }
;

// -------------------------------------------------------------------
// FOOD/DRINK: FLOWING STUFF: FlowingInContainer class
// -------------------------------------------------------------------

enum liquid, powder, gravel;

//feel, taste will require the "open" precondition

modify Thing
  theNameForPouring = (theName)
//  // It really does make sense to pour a liquid onto a rock
//  // or some other random thing.
//  iobjFor(PourOnto) {
//    verify { }
//  }
;

//modify Container
//  iobjFor(PourInto) {
//    verify { }
//  }
//;

modify Thing
  hasAlcohol = nil
  nameForCommentary = name
  aNameForCommentary = aName
  theNameForCommentary = theName
  nameForCommentaryIsPlural = isPlural
;

class FlowingInContainer: Thing
  name {
    return containerName + ' of ' + contentsName;
  }
  containerName { return containerAdj + ' ' + containerNoun; }
  containerNoun = ''
  containerAdj = ''
  contentsName = ''
  theNameForPouring = ('the ' + contentsName)
  
  //// Messages to clarify that it's the container that's being moved,
  //// not the flowing substance inside.
  //// 2016-11-13: Recent playtesting suggests this may be doing more harm than good.
  //// Therefore, commenting this out.
  //okayTakeMsg = '{You/he} take{s} {the dobj/him}. '
  //okayDropMsg = '{You/he} put{s} down {the dobj/him}. '
  //okayPutInMsg = '{You/he} put{s} {the dobj/him} in {the iobj/him}. '
  //okayPutOnMsg = '{You/he} put{s} {the dobj/him} on ' 
  //  + gIobj.destinationForPutOn.theName + '. '
  //okayPutUnderMsg =
  //  '{You/he} put{s} {the dobj/him} under {the iobj/him}. '
  //okayPutBehindMsg =
  //  '{You/he} put{s} {the dobj/him} behind {the iobj/him}. '
  
  // Examine
  desc {
    containerDesc;
    describeContents;
  }
  containerDesc { } // override
  contentsDesc { } // override
  describeContents { "It contains <<contentsDesc>>. "; }
  // Override both any showing of contents after EXAMINE, 
  // and also avoid saying "it's open" or "it's closed".
  examineListContents { }
  
  // LookIn
  // Fortunately, all of these containers are transparent, so 
  // FlowingInOpenableContainer need not override anything we do here.
  dobjFor(LookIn) {
    // This is always a logical action.
    verify { }
    action {
      "The <<containerName>> contains <<contentsName>>. ";
    }
  }
  
  // Feel
  dobjFor(Feel) {
    preCond = [touchObj]
  }
  feelDesc {
    if (hasWideOpening)
      "You reach into the <<containerName>> 
        and dip your fingers in the <<contentsName>>. ";
    else
      "You <<splashVerb>> a few <<dropsNoun>>
        of <<contentsName>> on your hands. ";
    flowingFeelDesc;
  }
  flowingFeelDesc {
    if (flowingType == liquid)
      "<<contentsArePlural ? 'They feel' : 'It feels'>>
        wet to the touch. ";
    else
      "<<contentsArePlural ? 'They feel' : 'It feels'>>
        much as you would have expected. ";
  }
  // Taste
  dobjFor(Taste) {
    preCond = [objHeld]
  }
  tasteDesc {
    if (isSoup)
      "Having no spoon, you put the <<containerName>>
        to your lips and briefly taste the <<contentsName>>. ";
    else if (flowingType == liquid)
      "Putting the <<containerName>> to your lips,
        you briefly taste the <<contentsName>>. ";
    else if (flowingType == powder)
      "You sprinkle out a few grains of <<contentsName>>
        and give them a taste. ";
    else // flowingType == gravel, presumably
      "You grab one of the <<contentsName>>
        and slowly eat it. ";
    flowingTasteDesc;
  }
  flowingTasteDesc {
    // If flowingType==gravel and you're tasting it, then you're just 
    // eating one piece, effectively making it singular.
    "<<contentsArePlural && !(gActionIs(Taste) && flowingType == gravel) 
      ? 'They<./s>re' : 'It<./s>s'>> not bad. ";
  }
  
  // Drink/Eat
  // If somebody is holding a bowl (of class Container) that contains 
  // a (fake) flask of table salt (of kind FlowingInContainer), and 
  // then they type EAT BOX, should they then get a message about
  // trying to eat the salt? If not, FlowingInContainer.canBeEaten 
  // should be nil. If so, it should be true.
  canBeEaten = nil
  dobjFor(Drink) {
    verify {
      if (flowingType == liquid)
        logicalRank(120, 'drinkable');
      else
        illogical(&cannotDrinkMsg);
    }
    preCond = [objHeld]
    action {
      consumeDesc;
      processConsumption();
    }
  }
  dobjFor(Eat) {
    verify {
      // Allow "eat lemonade", but recognize that it's
      // not an ideal match
      if (flowingType == liquid && !isSoup)
        logicalRank(80, 'non-soup liquid');
      else
        logicalRank(120, 'solid food or soup');
    }
    preCond = [objHeld]
    action {
      consumeDesc;
      //local k=0;k=k/k;
      processConsumption();
    }
  }
  consumeDesc {
    if (isSoup) {
      "Having no spoon, you put the <<containerName>>
        to your lips and swallow down the <<contentsName>>. ";
      flowingConsumeDesc;
      say (flowingConsumePrefix);
      "you swallow down more and more, until finally
        the <<containerNoun>> is empty. ";
    }
    else if (flowingType == liquid) {
      "Putting the <<containerName>> to your lips,
        you take a long drink of the <<contentsName>>. ";
      flowingConsumeDesc;
      say (flowingConsumePrefix);
      "you drink more and more, until finally
        the <<containerNoun>> is empty. ";
    }
    // This won't ever happen.
    else if (flowingType == powder) {
      "You pour out a handful of the <<contentsName>>
        and gulp it down. ";
      flowingConsumeDesc;
      say (flowingConsumePrefix);
      "you keep gulping down handfuls until finally
        the <<containerNoun>> is empty. ";
    }
    else { // flowingType == gravel, presumably
      "You grab a handful of the <<contentsName>>
        and eat them. ";
      flowingConsumeDesc;
      say (flowingConsumePrefix);
      "you keep eating more and more, 
        until finally the <<containerNoun>>
        is empty. ";
    }
  }
  flowingConsumeDesc = (flowingTasteDesc)
  flowingConsumePrefix = '\^'
  // processConsumption must be changed later; replace the
  // consumed object with an empty container.
  processConsumption {
    if (asscThing) {
      asscThing.moveInto(location);
    }
    else {
      "ERROR! Unable to find the associated empty container! ";
    }
    moveInto(nil);
  }
  
  // iobjFor: PourInto / PourOnto / PutIn / PutOn
  iobjFor(PourInto) {
    verify {
      if (gDobj && gIobj)
        illogical('You see no reason to get '
          + gDobj.theNameForPouring
          + ' mixed up with the ' + contentsName + ' in the '
          + containerName + '. ');
    }
  }
  iobjFor(PourOnto) asIobjFor(PourInto)
  iobjFor(PutIn) asIobjFor(PourInto)
  // I guess the default handling of PutOn is okay.
  
  // dobjFor: Pour / PourInto / PourOnto / PutIn / PutOn
  dobjFor(Pour) {
    verify {
      if (gDobj) {
        // I'm abusing 'illogicalNow' because, conveniently, it's 
        // not quite so illogical as 'illogical'
        illogicalNow('You see no reason to pour the '
          + contentsName + ' out of the ' + containerName + '. ');
      }
    }
  }
  dobjFor(PourInto) asDobjFor(Pour)
  dobjFor(PourOnto) asDobjFor(Pour)
  // Allow dobjFor(PutIn) and dobjFor(PutOn) to work as normal.
  // This will move the whole container, and won't pour out the contents.
  
  // ProxyPour / ProxyPourInto / ProxyPourOnto
  okayProxyPourMsg(where, actorDirectlyHeld) {
    return okayProxyPourCarefullyMsg(where, actorDirectlyHeld);
  }
  
  // Moisten/MoistenWith
  dobjFor(Moisten) {
    verify() {
      // Don't use logicalAlready, because moistening a liquid
      // is *always* illogical, not just sometimes.
      if (flowingType == liquid)
        illogical('The ' + contentsName 
          + ' in the ' + containerName
          + (contentsArePlural 
            ? ' are already as wet as they<./s>re ' 
            : ' is already as wet as it<./s>s ')
          + 'ever going to get. ');
    }
  }
  dobjFor(MoistenWith) {
    verify() {
      if (flowingType == liquid)
        illogical('The ' + contentsName 
          + ' in the ' + containerName
          + (contentsArePlural 
            ? ' are already as wet as they<./s>re ' 
            : ' is already as wet as it<./s>s ')
          + 'ever going to get. ');
    }
  }
  iobjFor(MoistenWith) {
    // Moistening something with a liquid is perfectly logical.
    verify() {
      if (flowingType == liquid)
        logical;
      else
        inherited();
    }
  }
  
  // Throw/ThrowAt/ThrowTo
  dobjFor(Throw) {
    verify {
      if (gDobj)
        illogical('You don<./s>t want to make a mess by throwing
          {the dobj/him}. ');
    }
  }
  dobjFor(ThrowAt) { 
    verify { verifyDobjThrow; }
  }
  dobjFor(ThrowTo) { 
    verify { verifyDobjThrow; }
  }
  iobjFor(ThrowAt) {
    verify {
      if (gIobj)
        illogical('You don<./s>t want to make a mess by throwing
          anything at {the iobj/him}. ');
    }
    //check {
    //  "You don<./s>t want to make a mess by throwing
    //    anything at {the iobj/him}. ";
    //  exit;
    //}
  }
  
  // Misc.
  splashVerb {
    if (flowingType == liquid) return 'splash';
    else return 'sprinkle';
  }
  dropsNoun {
    if (flowingType == liquid) return 'drops';
    else if (flowingType == powder) return 'grains';
    else return 'pieces';
  }
  isOpen = true
  
  // Nominal stuff for transformation:
  wordName = (contentsName)
  // Without exception, the contentsName of these flowing things 
  // do not take "a" or "an."
  aWordName = (contentsName)
  theWordName = (theNameFrom(wordName))
  wordNameIsPlural = (contentsArePlural)
  
  // These can and should be varied in some cases:
  contentsArePlural = nil
  hasWideOpening = nil
  flowingType = liquid
  isSoup = nil
  // For when the prioners steal food from you:
  foodName = contentsName
  aFoodName = 'some ' + foodName
  aNameForCommentary = aFoodName
  theNameForCommentary = theWordName
  nameForCommentaryIsPlural = contentsArePlural
  //theFoodName = 'the ' + foodName
  beginsToDevourPhrase = 'begins to devour '
    + (contentsArePlural ? 'them' : 'it')
  finishesDevouringPhrase = 'happily devours '
    + (contentsArePlural ? 'them' : 'it')
  giveShowType {
    if (isSoup)
      return soupFood;
    if (flowingType != liquid)
      return flowingFood;
    if (hasAlcohol)
      return alcoholicDrink;
    return ordinaryDrink;
  }
  vickiShowResponse {
    // Most non-liquid flowing substances are good to eat. So is soup.
    // Be sure to override this otherwise -- e.g. in the case of the
    // table salt.
    if (flowingType != liquid || isSoup) {
      // initial comment
      if (vicki.foodEaten < vicki.satiationLevel)
        //"<.q>Mmm,<<tastiness >= 4 ? ' delicious' : ''>> 
        //  <<contentsName>>,<./q> says Vicki. ";
        "<.q>Mmm, <<contentsName>>,<./q> says Vicki. ";
      else if (!contentsArePlural)
        "<.q>Not a bad-looking <<contentsName>>,<./q>
          says Vicki. ";
      else //contentsArePlural, and Vicki isn't hungry
        "<.q>Some pretty good-looking <<contentsName>>,<./q>
          says Vicki. ";
      // additional comment
      if (vicki.foodEaten < vicki.satiationLevel)
        "<.q>If you<./s>re not too hungry, would you consider 
          giving <<contentsArePlural ? 'those' : 'that'>> to me? 
          I<./s>m still pretty hungry.<./q> ";
      else if (diane.foodEaten < diane.satiationLevel)
        "<.q>If you<./s>re not too hungry, you might consider 
          giving <<contentsArePlural ? 'those' : 'that'>> to Diane. 
          She still looks hungry.<./q> ";
      else
        "<.q>Another good find from our food provider.<./q> ";
    }
    else if (hasAlcohol) {
      "<.q>Hey, I hope you<./s>re not planning on getting drunk 
        just yet,<./q> says Vicki. <.q>We have a serious task 
        in front of us&mdash;namely, getting out of here.<./q> ";
    }
    else if (self == vegetableOil || self == vegeableOil) {
      "<.q>\^<<aNameForCommentary>>, huh?<./q> Well, hang on
        to that. Maybe we can use that for cooking sometime
        later.<./q> ";
    }
    // In cases not covered above (and not overridden elsewhere), 
    // we assume that the FlowingInContainer is a beverage that's good 
    // to drink.
    else {
      "<.q>That looks pretty good,<./q> says Vicki. <.q>I<./s>m not 
        thirsty right now, though.<./q> ";
    }
  }
  dianeShowResponse {
    // Most non-liquid flowing substances are good to eat. So is soup.
    // Be sure to override this otherwise -- e.g. in the case of the
    // table salt.
    if (flowingType != liquid || isSoup) {
      // initial comment
      "<.q><<tastiness >= 4 && diane.foodEaten < diane.satiationLevel
        ? 'Hey, ' : '\^'>><<contentsArePlural ? 'those look' : 'that looks'>>
        <<tastiness >= 4 && diane.foodEaten < diane.satiationLevel
        ? 'delicious' : 'pretty good'>>,<./q> says Diane. ";
      // additional comment
      if (diane.foodEaten < diane.satiationLevel)
        "<.q>If you<./s>re not too hungry, just let me know, and 
          I<./s>d be glad to take <<contentsArePlural ? 'those' : 'that'>> 
          off your hands for you.<./q> ";
      else if (vicki.foodEaten < vicki.satiationLevel)
        "<.q>If you<./s>re not too hungry, you might consider 
          giving <<contentsArePlural ? 'those' : 'that'>> to Vicki. 
          She still looks hungry.<./q> ";
      else
        "<.q>Another fine addition to our food stash.<./q> ";
    }
    else if (hasAlcohol) {
      "<.q>Hey, we could have a pretty good party with that 
        later on,<./q> says Diane. <.q>On the other hand, 
        maybe we should save it for medicinal use. Decisions, 
        decisions.<./q> ";
    }
    else if (self == vegetableOil || self == vegeableOil) {
      "<.q>Congratulations,<./q> says Diane. <.q>You<./s>ve managed 
        to snag <<aNameForCommentary>>. Maybe we can use it 
        for cooking or something later.<./q> ";
    }
    else {
      "<.q>Not a bad find,<./q> says Diane. <.q>Maybe we<./s>ll be 
        thirsty for it later on.<./q> ";
    }
  }
  vickiGiveResponse {
    foodOfferReaction(vicki);
  }
  dianeGiveResponse {
    foodOfferReaction(diane);
  }
  //vickiGiveResponse {
  //  inherited;
  //}
  //dianeGiveResponse {
  //  inherited;
  //}
;

FlowingInContainer template 
  'vocabWords'
  'containerAdj' 'containerNoun' 'contentsName'
  @asscThing
  // The following two lines can be reversed, e.g. during debugging.
  @location?
  @ignoreThis?
  "contentsDesc"?
  //"flowingTasteDesc"?
  //"flowingConsumeDesc"?
  //"smellDesc"?
;

// -------------------------------------------------------------------
// FOOD/DRINK: FLOWING STUFF: FlowingInContainer subclasses
// -------------------------------------------------------------------

class FlowingInOpenableContainer: Openable, FlowingInContainer
  //describeContents { "\^<<openStatus>>, and contains <<contentsDesc>>. "; }
  describeContents { "\^<<openStatus>>, and contains <<contentsDesc>>. "; }
  dobjFor(Feel) {
    preCond = [objOpen]
  }
  dobjFor(Taste) {
    preCond = [objHeld, objOpen]
  }
  dobjFor(Eat) {
    preCond = [objHeld, objOpen]
  }
  dobjFor(Drink) {
    preCond = [objHeld, objOpen]
  }
  // This is probably moot, but here it is anyway.
  iobjFor(PourInto) {
    preCond = [objOpen]
  }
  // Smell
  dobjFor(Smell) {
    preCond = [objOpen]
  }
  // Throw/ThrowAt/ThrowTo
  dobjFor(Throw) {
    verify {
      if (gDobj && isOpen)
        illogical('You don<./s>t want to make a mess by throwing
          {the dobj/him} while it<./s>s open. ');
    }
  }
  dobjFor(ThrowAt) { 
    verify { verifyDobjThrow; }
  }
  dobjFor(ThrowTo) { 
    verify { verifyDobjThrow; }
  }
  iobjFor(ThrowAt) {
    verify {
      if (gIobj && isOpen)
        illogical('You don<./s>t want to make a mess by throwing
          anything at {the iobj/him} while it<./s>s open. ');
    }
    //check {
    //  if (isOpen) {
    //    "You don<./s>t want to make a mess by throwing
    //      anything at {the iobj/him} while it<./s>s open. ";
    //    exit;
    //  }
    //}
  }
  
;

class FlowingInFlask: FlowingInContainer
  containerDesc =
    "The flask <<containerAdj == 'round' 
      ? 'is round' : 'has a ' + containerAdj + ' shape'>>, 
      and is made of clear plastic. "
;
class FlowingInGlass: FlowingInContainer
  containerDesc =
    "The glass is rather <<containerAdj>>, and is
      made of clear plastic. "
  hasWideOpening = true
;

class FlowingInBowl: FlowingInContainer
  containerDesc =
    "The bowl is made of <<containerAdj>> plastic. "
  hasWideOpening = true
  //aFoodName = 'some ' + foodName
  devoursPhrase = 'lifts the ' + containerName + ' to her lips 
    and quickly gulps down ' + theFoodName
  scarfsPhrase = 'lifts the ' + containerName + ' to her lips 
    and gulps down ' + theFoodName + ' in short order'
  beginsToDevourPhrase = 'lifts the bowl to her lips
    and begins to gulp it down'
  finishesDevouringPhrase = 'lifts the bowl to her lips
    and happily gulps it down'
;

class FlowingInOpenableBag: FlowingInOpenableContainer
  containerDesc = 
    "The bag is made of transparent plastic which is
      tinted <<containerAdj>>. It has a slider seal
      whereby it can be either opened or closed. "
  describeContents { 
    "\^<<openStatus>>, and contains <<contentsDesc>>. "; 
  }
  hasWideOpening = true
  dobjFor(Move) {
    verify { }
    check { }
    action {
      if (isOpen)
        replaceAction(Close, self);
      else
        replaceAction(Open, self);
    }
  }
  okayOpenMsg = 'You slide the slider seal, opening the bag. '
  okayCloseMsg = 'You slide the slider seal, closing the bag. '
;

class FlowingInOpenableBottle: FlowingInOpenableContainer
  containerDesc = 
    "The bottle is quite <<containerAdj>>, is
      made of clear plastic, and has an odd spout 
      which can be turned in order to open or close 
      the bottle. "
  describeContents {
    "\^<<openStatus>>, and contains <<contentsDesc>>. ";
  }
  dobjFor(Turn) {
    verify { }
    check { }
    action {
      if (isOpen)
        replaceAction(Close, self);
      else
        replaceAction(Open, self);
      //if (isOpen) {
      //  // close it
      //  makeOpen(nil);
      //  "You turn the spout, closing the <<containerName>>. ";
      //}
      //// if it's closed...
      //else {
      //  // open it
      //  makeOpen(true);
      //  "You turn the spout, opening the <<containerName>>. ";
      //}
    }
  }
  okayOpenMsg = 'You turn the spout, opening the bottle. '
  okayCloseMsg = 'You turn the spout, closing the bottle. '
;

// -------------------------------------------------------------------
// FOOD/DRINK: FLOWING STUFF: FlowingInContainer objects: FlowingInOpenableBottle objects
// -------------------------------------------------------------------

bitters: Quenching, FlowingInOpenableBottle
  '(clear) (transparent) (plastic) narrow bottle spout
    (dark) bitter bitters liquid -*bottles*liquids*spouts'
  'narrow' 'bottle' 'bitters'
  @narrowBottle
  @cupboard @blankRoom
  "a dark liquid that you take to be bitters"
  bulk = 18
  smellDesc = "The smell is very pungent. "
  flowingTasteDesc = "Not surprisingly, the bitters taste very bitter. "
  dobjFor(Drink) {
    verify {
      if (gDobj)
        illogical('You really have no desire to down the 
          whole bottle. ');
    }
  }
  dobjFor(Eat) {
    verify { verifyDobjDrink; }
  }
  // I guess "bitters are" is better than "bitters is."
  contentsArePlural = true
  zapT = die(
    //'The bitters disappear.
    //  <p>Then, suddenly, right beside you, there appears 
    //    an enormous collection of biers! '
    transformUnsimulated('an enormous collection of biers')
        + 'Unlike traditional biers, these are made of concrete.
        They are also very large, and
        so numerous that ' + floorCollapseMsg(true)
      + fallThroughFloorMsg
    , 'biers', 'bitters', killEverybodyInRoom
  )
  hasAlcohol = true
;

vegetableOil: FlowingInOpenableBottle 
  '(clear) (transparent) (plastic) wide bottle spout
    vegetable oily oil liquid -*bottles*liquids*spouts'
  'wide' 'bottle' 'vegetable oil'
  @wideBottle
  @cupboard @blankRoom
  "a small quantity of vegetable oil"
  bulk = 18
  smellDesc = "It gives off a kind of oily emanation. "
  flowingTasteDesc = "It tastes pretty bad, but that<./s>s 
    normal for vegetable oil. "
  dobjFor(Drink) {
    verify {
      if (gDobj) {
        if (!glob.vegetableOilFuseIsOn) {
          glob.vegetableOilFuseIsOn = true;
          ncYesNo.set(
            'After you<./s>ve dined on vegetable shortening,
              maybe then it will be time to wash it down with a
              nice bottle of vegetable oil. Not today, however. '
           ,'I didn<./s>t think so. '
          );
          illogical('What, swallow a whole bottle of vegetable oil? ');
        }
        else { // the fuse is on.
          illogical('After you<./s>ve dined on vegetable shortening,
            maybe then it will be time to wash it down with a
            nice bottle of vegetable oil. Not today, however. ');
        }
      }
    }
  }
  dobjFor(Eat) {
    verify { verifyDobjDrink; }
  }
  zapT = transform(self, vegeableOil)
  zapAry = disappear(
    transformUnsimulated('a violet beagle')
        + 'The beagle barks at you once, then quickly '
        + (doorInThisRoomMustBeOpened()
           ? 'heads for the door, pushes it open, and ' : '')
        + 'runs out of the room, far out of sight.
        Perhaps he is off hunting for violet squirrels 
        or violet rabbits. '
    , self, 'violet beagle'
  )
  zapAryCq {
    openDoorInThisRoom();
  }
  giveShowType = oil
  //////zapAry = transform(self, violetBeagle)
;

vegeableOil: SemiNonsense, FlowingInOpenableBottle
  '(clear) (transparent) (plastic) short bottle spout
    vegeable oily oil liquid -*bottles*liquids*spouts'
  'short' 'bottle' 'vegeable oil'
  @shortBottle
  @nil @blankRoom
  //"a dark green fluid that sort of looks like engine coolant,
  //  but for all the world smells like vegeable oil"
  "a small quantity of vegeable oil"
  bulk = 15
  smellDesc = "It smells like typical, average oil. "
  flowingTasteDesc = "It tastes like typical, average oil. "
  //flowingTasteDesc = "It tastes pretty bad, but that<./s>s
  //  normal for any typical, average oil. "
  dobjFor(Drink) {
    verify {
      if (gDobj) {
        if (!glob.vegeableOilFuseIsOn) {
          glob.vegeableOilFuseIsOn = true;
          ncYesNo.set(
            'After you<./s>ve dined on vegeable shortening,
              maybe then it will be time to wash it down with a
              nice bottle of vegeable oil. Not today, however. '
           ,'I didn<./s>t think so. '
          );
          illogical('What, swallow a whole bottle of vegeable oil? ');
        }
        else { // the fuse is on.
          illogical('After you<./s>ve dined on vegeable shortening,
            maybe then it will be time to wash it down with a
            nice bottle of vegeable oil. Not today, however. ');
        }
      }
    }
  }
  dobjFor(Eat) {
    verify { verifyDobjDrink; }
  }
  zapAry = disappear(
    transformUnsimulated('an olive beagle')
        + 'The beagle barks at you once, then quickly '
        + (doorInThisRoomMustBeOpened()
           ? 'heads for the door, pushes it open, and ' : '')
        + 'runs out of the room, far out of sight.
        Perhaps he is off hunting for olive squirrels 
        or olive rabbits. '
    , self, 'olive beagle'
  )
  zapAryCq {
    openDoorInThisRoom();
  }
  giveShowType = oil
  //zapAry = transform(self, oliveBeagle)
;

dietPepsi: Quenching, FlowingInOpenableBottle
  '(clear) (transparent) (plastic) tall bottle spout
    diet pepsi (light) cola coke soda pop (soft) carbonated bubbly 
    fizzy (sweet) liquid -*bottles*liquids*spouts'
  'tall' 'bottle' 'Diet Pepsi'
  @tallBottle
  @upperFridgeShelf @blankRoom
  "a dark, bubbly liquid that you take to be Diet Pepsi"
  bulk = 12
  smellDesc = "The smell is mild but sweet. "
  flowingTasteDesc = "It<./s>s sweet and very fizzy. "
  zapT = die(
    'The Diet Pepsi disappears.
      <p>Then, suddenly, a teeming
        horde of people appears, apparently running out of 
        the wall! 
        The people are angrily shouting and carrying placards that 
        say, <.q>Die, Pepsi!<./q>
      <p>Unfortunately, the demonstrators head straight for you. 
        You try to get out of the way, but they
        ignore you and run you down. Someone kicks you,
        and your head hits against the floor. 
        You lose consciousness and never wake up. '
    , 'Die Pepsi', 'Diet Pepsi', killEverybodyInRoom
  )
  zapTCq {
    openDoorInThisRoom();
  }
  zapAry = transform(self, tiedPipes)
;

// -------------------------------------------------------------------
// FOOD/DRINK: FLOWING STUFF: FlowingInContainer objects: FlowingInGlass objects
// -------------------------------------------------------------------

chocolateMilk: Quenching, FlowingInGlass
  '(clear) (transparent) (plastic) large glass 
    (sweet) chocolate liquid milk -*glasses*liquids'
  'large' 'glass' 'chocolate milk'
  @largeGlass
  @upperFridgeShelf @blankRoom
  "a good serving of chocolate milk"
  bulk = 10
  smellDesc = "The smell is mild but sweet. "
  flowingTasteDesc = "It tastes great. "
  zapT = transform(self, chocolaeMilk)
  zapAry = transform(self, milkChocolate)
;

chocolaeMilk: SemiNonsense, Quenching, FlowingInGlass
  '(clear) (transparent) (plastic) small glass 
    chocolae liquid milk -*glasses*liquids'
  'small' 'glass' 'chocolae milk'
  @smallGlass
  @nil @blankRoom
  "a good serving of chocolae milk"
  bulk = 7
  smellDesc = "It smells like typical, average milk. "
  flowingTasteDesc = "It tastes like typical, average milk. "
;

// -------------------------------------------------------------------
// FOOD/DRINK: FLOWING STUFF: FlowingInContainer objects: FlowingInOpenableBag objects
// -------------------------------------------------------------------

truffles: FlowingInOpenableBag, Satiating
  '(plastic) (clear) (transparent) green bag slider seal
    truffles (chocolate) (sweet) candies candy truffle chocolates 
    -*bags*seals'
  'green' 'bag' 'truffles'
  @greenBag
  @lowerFridgeDrawer @blankRoom
  "a collection of chocolate candies that look like truffles"
  bulk = 15
  smellDesc = "The truffles give off the rich smell of
    chocolate. "
  flowingTasteDesc = "It is rich and deliciously sweet. "
  flowingConsumeDesc = "They are rich and deliciously sweet. "
  contentsArePlural = true
  flowingType = gravel
  tastiness = 5
  isSweet = true
  devoursPhrase = 'devours ' + theFoodName + ' one by one
    until they are gone'
  scarfsPhrase = 'scarfs down ' + theFoodName + ' in short order'
  zapT = transform(self, ruffles)
;

ruffles: FlowingInOpenableBag, Satiating
  '(plastic) (clear) (transparent) blue bag slider seal
    ruffles (brand) potato potatoes chip chips crisp crisps 
    -*bags*seals'
  'blue' 'bag' 'Ruffles'
  @blueBag
  @nil @blankRoom
  "what appears to be Ruffles brand potato chips"
  bulk = 15
  smellDesc = "The potato chips don<./s>t smell bad. "
  flowingTasteDesc = "It<./s>s not bad. "
  flowingConsumeDesc = "They<./s>re not bad. "
  contentsArePlural = true
  flowingType = gravel
  tastiness = 3
  devoursPhrase = 'devours ' + theFoodName + ' one by one
    until they are gone'
;

specialK: FlowingInOpenableBag, Satiating
  '(plastic) (clear) (transparent) lavender bag slider seal
    special k breakfast cereal 
    -*bags*seals'
  'lavender' 'bag' 'Special K'
  @lavenderBag
  @cupboard @blankRoom
  "what appears to be Special K breakfast cereal"
  bulk = 15
  smellDesc = "The Special K doesn<./s>t smell bad. "
  flowingTasteDesc = "It<./s>s not bad. "
  flowingConsumeDesc = "It<./s>s not bad. "
  //contentsArePlural = true
  flowingType = gravel
  tastiness = 2
  zapAry = transform(self, silkCape)
  devoursPhrase = 'devours handful after handful of ' + theFoodName 
    + ' until it is gone'
;

taterTots: FlowingInOpenableBag, Food
  'purple violet bag tater potatoes/taters/tots/puffs*bags*seals'
  'purple' 'bag' 'tater tots'
  @purpleBag
  @(geFreezer.subContainer) @blankRoom
  "a large quantity of frozen tater tots"
  bulk = 15
  wordName = 'tater tots'
  wordNameIsPlural = true
  dobjFor(Open) {
    verify {
      if (gDobj) {
        illogical('Part of you wouldn<./s>t mind opening up the bag, just to 
          try out these tater tots. But they<./s>re frozen solid, and 
          this isn<./s>t exactly your top priority right now. ');
      }
    }
  }
  tastiness = 1
  zapT = transform(self, aeros)
;

aeros: FlowingInOpenableBag, Satiating
  '(plastic) (clear) (transparent) turquoise bag slider seal
    aeros aero chocolate candy (bar) 
    -*bags*seals'
  'turquoise' 'bag' 'Aeros'
  @turquoiseBag
  @cupboard @blankRoom
  "what appears to be a handful of Nestl&eacute; Aero brand chocolate bars"
  bulk = 15
  smellDesc = "They smell deliciously sweet. "
  flowingTasteDesc = "It tastes delicious. "
  flowingConsumeDesc = "They<./s>re delicious and addictive. "
  contentsArePlural = true
  flowingType = gravel
  tastiness = 5
  devoursPhrase = 'devours one Aero bar after another until they are gone'
  transformText(thing1) {
    "The tater tots are transformed into 
      what appears to be a bag of Aeros! (You know, the chocolate bar 
      sold by Nestl&eacute;. You haven't seen these since the 
      last time you went to Canada.) ";
  }
;


// -------------------------------------------------------------------
// FOOD/DRINK: FLOWING STUFF: FlowingInContainer objects: FlowingInBowl objects
// -------------------------------------------------------------------

minestroneSoup: FlowingInBowl, Satiating
  '(plastic) red bowl 
    minestrone soup broth vegetable vegetables liquid 
    -*bowls*soups*liquids'
  'red' 'bowl' 'minestrone soup'
  @redBowl
  @lowerFridgeShelf @blankRoom
  "a good quantity of delicious-looking minestrone soup"
  bulk = 16
  smellDesc = "The smell of the <<contentsName>> makes your 
    mouth water. "
  flowingTasteDesc = "It tastes excellent. "
  isSoup = true
  tastiness = 4
  zapT = transform(self, minesroneSoup)
  zapAry = die(
    transformUnsimulated('an ominous serpent')
        + 'The beast is fully twelve feet long.
        It certainly looks menacing, but you try to persuade
        yourself that there<./s>s no reason to be afraid. 
        This is probably one of those vegetarian 
        serpents.
      <p>Then the beast turns to face you.
        With lightning speed, it lunges and 
        swallows you whole. You die slowly of suffocation 
        as digestive acids eat through your flesh. 
      <p>As you lay dying, suddenly you remember reading that 
        there is no such thing as an herbivorous snake. '
    , 'ominous serpent', self //, 'minestrone soup' //,killEverybodyInRoom
  )
;

minesroneSoup: SemiNonsense, FlowingInBowl, Satiating
  '(plastic) pink bowl 
    minesrone soup broth liquid 
    -*bowls*soups*liquids'
  'pink' 'bowl' 'minesrone soup'
  @pinkBowl
  @nil @blankRoom
  "a good quantity of minesrone soup"
  bulk = 16
  smellDesc = "It smells like typical, average soup. "
  flowingTasteDesc = "It tastes like typical, average soup. "
  isSoup = true
  tastiness = 2
  //askAry = question(nil, 'Do you object to off-color jokes? ')
  zapAry = die(
    transformUnsimulated('a collection of supreme onions')
        + 'These onions are truly gigantic, perhaps about 
        seven feet in diameter, and they give off an overpowering
        odor that immediately sets your eyes to watering. 
        But there is an even a bigger problem than that. 
        So large are these onions that '
        + floorCollapseMsg(true)
      + fallThroughFloorMsg
    , 'supreme onions', self, killEverybodyInRoom
  )
  //zapAry2 = die(
  //  transformUnsimulated('an enormous penis')
  //      + 'So big is the penis, in fact, that it takes up almost 
  //      the entire room. Not only that, but ' 
  //      + floorCollapseMsg(nil)
  //    + fallThroughFloorMsg
  //  , 'enormous penis', self, killEverybodyInRoom
  //)
;

chickenNoodleSoup: FlowingInBowl, Satiating
  '(plastic) yellow bowl 
    chicken noodle noodles soup broth liquid 
    -*bowls*soups*liquids'
  'yellow' 'bowl' 'chicken noodle soup'
  @yellowBowl
  @lowerFridgeShelf @blankRoom
  "a good quantity of delicious-looking chicken noodle soup"
  bulk = 16
  smellDesc = "The smell of the <<contentsName>> makes your 
    mouth water. "
  flowingTasteDesc = "It tastes great. "
  isSoup = true
  tastiness = 4
  zapAry = die(
    transformUnsimulated('a squadron of armed alien officers', nil, nil)
        + 'The one in front comes up to you and says, <.q>All right,
        listen up. We<./s>re the Shunned Cook Police. We understand
        there<./s>s been a disappearance of some chicken noodle soup.
        We received a report from the lady who cooked that soup,
        and she is completely distraught that somebody caused it 
        to disappear.<./q>
      <p>A second officer says, <.q>Whoever did that violated the
        law. The soup was her property, and this whole business of 
        making stuff disappear is as bad as theft.<./q>
      <p><.q>You didn<./s>t do it,
        did you?<./q> the first officer asks. 
        <.q>Well, either way, we<./s>re gonna have to take you
        in for questioning.<./q>
      <p>You start to protest, but they grab your arms and put cuffs
        on you. They walk you outside, shove you into their 
        aircar, and haul you down to the station.
      <p>Unfortunately, these particular police officers were not
        informed that humans need food every few days at least.
        By the time they get around to interviewing you, three weeks
        later, you have died of starvation. '
    , 'Shunned Cook Police', self
  )
  zapAryCq {
    openDoorInThisRoom();
    if (!frontDoors.isOpen) {
      frontDoors.makeOpen(true);
    }
    if (me.getOutermostRoom != hallway1 && me.getOutermostRoom != hallway2
        && !hallDoors.isOpen)
      hallDoors.makeOpen(true);
  }
;

clamChowder: FlowingInBowl, Satiating
  '(plastic) orange bowl 
    clam chowder soup broth liquid 
    -*bowls*soups*liquids'
  'orange' 'bowl' 'clam chowder'
  @orangeBowl
  @lowerFridgeShelf @blankRoom
  "a good quantity of delicious-looking clam chowder"
  bulk = 16
  smellDesc = "The smell of the <<contentsName>> makes your 
    mouth water. "
  flowingTasteDesc = "It tastes terrific. "
  isSoup = true
  tastiness = 4
  zapAry = die(
    transformUnsimulated('a calm cowherd') +
        'Unfortunately, wherever there<./s>s a calm cow herd,
        there<./s>s apt to be a not-so-calm cowboy who has done a 
        very good job of beating them into submission. This is no 
        exception.
      <p>When the cowboy sees you, he shouts, 
        <.q>Dang it! I told Jake, next time I see a
        trespasser, I<./s>ll shoot <./s>im dead!<./q>
      <p>With that, he grabs his shotgun and demonstrates that when
        he tells Jake something, he really means it. '
    , 'calm cowherd', self
  )
;

// -------------------------------------------------------------------
// FOOD/DRINK: FLOWING STUFF: FlowingInContainer objects: FlowingInFlask objects
// -------------------------------------------------------------------

sake: Quenching, FlowingInFlask
  '(clear) (transparent) (plastic) round flask 
    sake liquid -*flasks*liquids'
  'round' 'flask' 'sake'
  @roundFlask
  @nil @blankRoom
  "a clear liquid that you take to be sake"
  bulk = 5
  flowingTasteDesc =
    "To be honest, you don<./s>t like the taste. "
  smellDesc =
    "The smell is not strong, but faintly resembles vodka 
      or other spirits. "
  flowingConsumePrefix = 'Nevertheless, '
  hasAlcohol = true
;

tableSalt: FlowingInFlask
  '(clear) (transparent) (plastic) conical cone cone-shaped flask 
    (table) salt grains -*flasks' 
  'conical' 'flask' 'table salt' 
  @conicalFlask
  @cupboard @blankRoom
  "a small quantity of table salt"
  bulk = 5
  smellDesc = "It gives off a very faint salty smell. "
  flowingTasteDesc = "It tastes salty, all right. "
  flowingType = powder
  dobjFor(Eat) {
    verify {
      if (gDobj) {
        if (!glob.tableSaltFuseIsOn) {
          glob.tableSaltFuseIsOn = true;
          ncYesNo.set(
            'No doubt it would be a tremendous pleasure to stuff
              yourself with table salt, but let<./s>s not go overboard. 
              You don<./s>t want to make yourself sick. '
           ,'I didn<./s>t think so. '
          );
          illogical('What, swallow a whole flask of table salt? ');
        }
        else { // the fuse is on.
          illogical('No doubt it would be a tremendous pleasure to stuff
            yourself with table salt, but let<./s>s not go overboard. 
            You don<./s>t want to make yourself sick. ');
        }
      }
    }
  }
  vickiShowResponse {
    "<.q>\^<<aNameForCommentary>>, huh?<./q> Well, hang on
      to that. Maybe we can use that for cooking sometime
      later.<./q> ";
  }
  dianeShowResponse {
    "<.q>Congratulations,<./q> says Diane. <.q>You<./s>ve managed 
      to snag <<aNameForCommentary>>. Maybe we can use it 
      for cooking or something later.<./q> ";
  }
  zapT = lose(ableSal.giveString, ftAbleSal, 'Able Sal', 'table salt')
  // This is untested; I'll just hope it works.
  zapTCq {
    // open the front doors, as well as any door in this room
    openDoorInThisRoom();
    frontDoors.makeOpen(true);
    
    if (ableSal.salGoal == unlockCell || ableSal.vickiPlace == cell) {
      cellDoor.makeLocked(nil);
      cellDoor.makeOpen(true);
    }
    
    // rule out any cases where the hallDoors don't need to be opened
    local openHallDoors = true;
    if (ableSal.salGoal == goOutside && 
         (ableSal.mePlace == hallway1 || ableSal.mePlace == hallway2))
      openHallDoors = nil;
    if (ableSal.salGoal == findPrisoners &&
         (ableSal.mePlace == hallway1 || ableSal.mePlace == hallway2) &&
         (ableSal.vickiPlace == hallway1 || ableSal.vickiPlace == hallway2))
      openHallDoors = nil;
    // open the hall doors
    if (openHallDoors)
      hallDoors.makeOpen(true);
    
    // Whatever happens, make sure Vicki and Diane exit the building
    vicki.moveInto(nil);
    diane.moveInto(nil);
  }
  zapAry = die(
    transformUnsimulated('a tall beast')
        + 'The beast looks something like a minotaur, since it
        walks upright, only its horns are much bigger and sharper
        than any bull<./s>s. 
      <p>Craning its neck, the beast turns and sees you. 
        Then, before you can react, it curls its fist and delivers
        a solid punch to your head. 
      <p>The blow knocks you unconscious, which is lucky, 
        considering what happens next. '
    , 'tall beast', self
    //,killEverybodyInRoom
  )
  giveShowType = tableSalt
  //ableSalStr {
  //  if (glob.doAryText) {
  //    "The table salt is transformed into a strapping young man whose skin-tight
  //        tank top bears the words <.q>Able Sal.<./q> 
  //      <p>Able Sal 
  //        is so able that he runs off and rescues the prisoners 
  //        and runs out of the building without you. ";
  //  }
  //  return '';
  //}
;

// -------------------------------------------------------------------
// FOOD/DRINK: ABLE SAL finish type
// -------------------------------------------------------------------

ftAbleSal: FinishType
  finishMsg = 'You can no longer win this game, <br>because Able Sal won it for you'
;
enum unlockCell, findPrisoners, goOutside;

ableSal: object
  // The following three methods/properties define the state of
  // the game for the Able Sal sequence. 
  // They will need changing when copied to 3endgame.t.
  salGoal {
    //I'm not sure yet how I'll do this for the actual game.
    if (!vicki.realLocation)
      return goOutside;
    if (vicki.getOutermostRoom == cell && cellDoor.isLocked)
      return unlockCell;
    return findPrisoners;
    
    //return unlockCell;
    //return findPrisoners;
    //return goOutside;
  }
  mePlace {
    return me.getOutermostRoom;
    
    //return breakRoom;
  }
  vickiPlace {
    return vicki.getOutermostRoom;
    
    //return cell;
    //return hallway3;
    //return nil;
  }
  
  // perhaps change this
  usesDoorUnlockingMechanism = 'slams his elbow into the door. 
    Astonishingly, this triggers a click from within the door, 
    which then glides effortlessly open'
  
  // The following convenience methods should not need changing
  prisonersSupposedlyNearby {
    if (mePlace == vickiPlace)
      return true;
    if (mePlace == hallway3 && vickiPlace == cell)
      return true;
    return nil;
  }
  fromDownTheHallway(southConscious) {
    if (salGoal == goOutside)
      return 'from outside the building';
    else if (southConscious && salGoal == unlockCell &&
          (mePlace == hallway1 || mePlace == hallway2))
      return 'from that direction';
    else
      return 'from down the hallway';
  }
  mePlaceWord {
    if (salGoal == goOutside)
      return 'in';
    else if (mePlace == hallway1 || mePlace == hallway2)
      return 'up';
    else
      return 'back';
  }
  passesBarrierAnd {
    if (!me.getOutermostRoom)
      return '';
    // TO DO: HALLWAY6, STAIRS, HALLWAY9, SKYWAY, MUSEUM
    return '';
  }
  nearDoor =
    (me.getOutermostRoom.getDoorForLeavingBuilding)
  nearDoorToCell {
    if (me.getOutermostRoom == hallway2)
      return hallDoors2;
    else if (nearDoor == hallDoors || nearDoor == frontDoors)
      return nil;
    else
      return nearDoor;
  }
  nearDoorToPrisoners {
    if (vickiPlace == nil)
      return nearDoor;
    if (vickiPlace == hallway1 || vickiPlace == hallway2) {
      if (mePlace == hallway1 || mePlace == hallway2)
        return nil;
      else
        return nearDoor;
    }
    if (vickiPlace == hallway3) {
      if (mePlace == cell)
        return cellDoor;
      if (mePlace == hallway3)
        return nil;
      return nearDoorToCell;
    }
    return nearDoorToCell;
  }
  andMaybeDeactivatesSlowingField {
    if (me.getOutermostRoom.isInFishCorridor 
        && me.absoluteYValue < 475 && slowingField.isOn) {
      slowingField.scMoveInto(nil);
      return 
        ', flicks off the slowing field, and heads west 
          through the doorway';
    }
    else {
      return '';
    }
  }
  
  // The actual text
  giveString {
    if (glob.doAryText) {
      // -----------
      // Sal appears
      say(tableSalt.transformUnsimulated(
        'a strapping young man whose skin-tight muscle shirt 
          bears the words <.q>Able Sal.<./q>', 
        nil, nil));
      "Clapping you on the shoulder, Sal says, <.q>Thanks, bud.<./q> 
        <p>";
      
      // -----------
      // Sal walks off
      if (salGoal == goOutside && mePlace == hallway1) {
        "Then, flexing his muscles, 
          he<<!frontDoors.isOpen ? ' opens the front doors and' : ''>> 
          struts off to the outside world. ";
      }
      else if (salGoal == goOutside) {
        // Previously:
        // Sal [[[[opens the door and]]]] struts 
        // hear a[[[[nother]]]] door slam
        "Then, flexing his muscles, he ";
        //local nearDoor = me.getOutermostRoom.getDoorForLeavingBuilding;
        if (nearDoor && !nearDoor.isOpen)
          "opens <<nearDoor.theName>> and ";
        "struts off down the 
            hallway<<andMaybeDeactivatesSlowingField>>. ";
        if (!frontDoors.isOpen)
          "A while later, off in the distance, you hear 
            a<<nearDoor && !nearDoor.isOpen ? 'nother' : ''>> 
            pair of doors being opened. ";
        "<p>";
      }
      else if (salGoal == findPrisoners && prisonersSupposedlyNearby) {
        if (mePlace == hallway3 && vickiPlace == cell 
            && !cellDoor.isOpen && !cellDoor.isLocked) {
          "Then, flexing his muscles, he grabs hold of the door 
            and yanks it open. ";
        }
        else
          { }
      }
      else if (salGoal == findPrisoners) {
        "Then, flexing his muscles, he ";
        if (nearDoorToPrisoners && !nearDoorToPrisoners.isOpen)
          "opens <<nearDoorToPrisoners.theName>> and ";
        "struts off down the hallway";
        if ((mePlace == hallway1 || mePlace == hallway2) &&
            (vickiPlace != hallway1 && vickiPlace != hallway2))
          " to the south";
        "<<andMaybeDeactivatesSlowingField>>. ";
      }
      else if (salGoal == unlockCell && mePlace == hallway3) {
        "Then, flexing his muscles, he turns his attention 
            to the door. After a cursory glance, he cries,
            <.q>Why, this door is easily opened!<./q> And then he 
            <<usesDoorUnlockingMechanism>>. ";
      }
      else { // presumably, salGoal == unlockCell
        "Then, flexing his muscles, he ";
        if (nearDoorToCell && !nearDoorToCell.isOpen)
          "opens <<nearDoorToCell.theName>> and ";
        "struts off down the 
            hallway<<mePlace == hallway1 || mePlace == hallway2
            ? ' to the south' : ''>>";
        "<<andMaybeDeactivatesSlowingField>>. ";
      }
      
      // -----------
      // Sal says "Hi there, ladies!"
      if (salGoal == findPrisoners && mePlace == vickiPlace)
        "Then, flexing his muscles, he turns to Vicki and Diane and says,
          <.q>Hi there, ladies!<./q> ";
      else if (prisonersSupposedlyNearby)
        "<p>With that, Vicki and Diane come running out.
          <p><.q>Hi there, ladies!<./q> says Sal with a wide grin. ";
      else {
        "Soon, <<fromDownTheHallway(true)>>, you hear him say, ";
        if (salGoal != unlockCell)
          "<.q>Hi there, ladies!<./q> ";
        else
          "<.q>Why, this door is easily opened!<./q>
            <p>There is loud thump, followed by a creaking door, 
              and then Sal says, <.q>Hi there, ladies!<./q> ";
      }
      
      // -----------
      // "Well, hello!" "Who are you?" "Sal's the name."
      "<p>You are amazed 
          <<prisonersSupposedlyNearby 
            ? 'as Diane raises her eyebrows and replies' 
            : 'to hear Diane reply'>>, 
          <.q>Well, hello, young man!<./q>
        <p>Vicki says, <.q>And who are you?<./q> 
        <p><.q>Sal<./s>s the name,<./q> he intones. ";
      
      // -----------
      // giggling, "blow this joint," "wonderful!"
      if (prisonersSupposedlyNearby)
        "<p>With that, 
            Vicki and Diane start giggling like schoolgirls. 
          <p><.q>Say, listen, ladies, whaddya say we blow this joint?<./q> 
            Sal says in his deep baritone voice. Then, lowering
            his voice, he points his thumb at you and says, 
            <.q>I don<./s>t like the look
            of this loser. Let<./s>s ditch him.<./q>
          <p><.q>Oh, that sounds wonderful!<./q> Diane cries. ";
      else
        "<p>\^<<fromDownTheHallway(nil)>>, 
            you hear Vicki and Diane giggling like schoolgirls.
          <p><.q>Say, listen, ladies,<./q> Sal says in his deep 
            baritone voice. <.q>Whaddya say we blow this joint?
            There<./s>s some loser <<mePlaceWord>> there, 
            and I<./s>d just as soon ditch him.<./q>
          <p><.q>Oh, that sounds wonderful!<./q> Diane cries. ";
      
      // -----------
      // "Lead the way!" "Biceps." "Thanks for rescuing us."
      "<p><.q>Lead the way, you big, hulking man!<./q> shouts Vicki.
        <p><.q>You wanna see hulking? Check out these biceps!<./q>
          <<prisonersSupposedlyNearby 
          ? 'And he flexes his muscles monstrously. ' : ''>>
        <p>At this, Vicki and Diane break out into squeals of delight.
        <p><.q>Ooh, Sal, you<./s>re <i>so</i> able!<./q> cries Diane.
        <p><.q>Thank you so much for rescuing us!<./q> cries Vicki. ";
      if (salGoal != unlockCell) {
        "<p>Hey, he didn<./s>t rescue them. You did! 
            Didn<./s>t you? ";
      }
      
      // -----------
      // jab to the ribs
      if (!prisonersSupposedlyNearby &&
          salGoal != goOutside && vicki.realLocation != nil &&
          me.absoluteXValue == 100 && 
          me.absoluteYValue < vicki.absoluteYValue)
        "<p>And then suddenly the three of them come walking up 
            from the south. As Sal walks past, he elbows you aside 
            with a sharp jab to the ribs. ";
      //if (salGoal == unlockCell && 
      //     (mePlace == hallway1 || mePlace == hallway2))
      //  "<p>And then suddenly the three of them come walking up 
      //      from the south. As Sal walks past, he elbows you aside 
      //      with a sharp jab to the ribs. ";
      
      // -----------
      // final words
      if (salGoal != goOutside && 
          (prisonersSupposedlyNearby || mePlace == hallway1 || mePlace == hallway2)) {
        "<p>And with that, the three of them ";
        if (mePlace == hallway1 && !frontDoors.isOpen)
          "open the doors and ";
        if (mePlace == hallway3 && !hallDoors.isOpen)
          "open the doors and ";
        if (mePlace == cell && !cellDoor.isOpen)
          "open the door and ";
        "walk ";
        if (mePlace == hallway1 || mePlace == hallway2 || mePlace == hallway3 || mePlace == cell)
          "north ";
        "off into the distance. ";
      }
      else if (salGoal == unlockCell) {
        "<p>And then you hear their footsteps trail off
            into the distance. ";
      }
      //if (salGoal == unlockCell) {
      //  if (prisonersSupposedlyNearby || mePlace == hallway1 || mePlace == hallway2) {
      //    "<p>And with that, the three of them ";
      //    if (mePlace == hallway1 && !frontDoors.isOpen)
      //      "open the doors and ";
      //    if (mePlace == hallway3 && !hallDoors.isOpen)
      //      "open the doors and ";
      //    "walk ";
      //    if (mePlace == hallway1 || mePlace == hallway2 || mePlace == hallway3)
      //      "north ";
      //    "off into the distance. ";
      //  }
      //  else {
      //    "<p>And then you hear their footsteps trail off
      //        into the distance. ";
      //  }
      //}
      //else {
      //  "<p>Hey, he didn<./s>t rescue them. You did! 
      //      Didn<./s>t you? ";
      //}
    }
    return '';
  }
;


/*
(salGoal == unlockCell && you are in hallway1 or hallway2)
  <p>Suddenly <<the doors open, and>> the three of them come walking through from the south.
    As Sal walks past, he elbows you aside with a sharp jab to the ribs.
(otherwise)
  (say nothing)



(salGoal IS NOT unlockCell)
  <p>Hey, he didn<./s>t rescue them. You did!
  <p>Didn't you?
(salGoal == unlockCell)
  <p>And with that, the three of them <<open the door and (is in hallway1)>> walk off 
    into the distance.
*/

// Token blank rooms for storing things we don't want to see:

blankRoom: Room 'room' 'room';
foodNil: Room 'room' 'room';

// -------------------------------------------------------------------
// FOOD/DRINK: FLOWING STUFF: ExFlowingContainer and subclasses
// -------------------------------------------------------------------

class ExFlowingContainer: RestrictedContainer
  location = foodNil
  bulk = (asscThing.bulk)
  desc {
    if (asscThing)
      return asscThing.containerDesc;
    else
      return nil;
  }
  // modify this as needed
  canPutIn(obj) { return true; }
  // This is covered under my container modifications. Yay.
  //iobjFor(PourInto) {
  //  verify { }
  //}
//  iobjFor(PutIn) {
//    // conditions put into verify
//    verify {
//      if (gIobj && gDobj && !canPutIn(gDobj))
//        illogical(cannotPutInMsg(gDobj));
//    }
//    // This is already part of RestrictedContainer:
//    //check() {
//    //  if (!canPutIn(gDobj)) {
//    //    reportFailure(cannotPutInMsg(gDobj));
//    //    exit;
//    //  }
//    //}
//  }
//  // A lame default, but it'll have to do till I come up with
//  // a systematic way of determining what fits into what.
//  canPutIn(obj) {
//    return nil;
//  }
//  cannotPutInMsg(obj) {
//    return 'It seems a little too awkward to put '
//      + obj.theName + ' into ' + theName + '. ';
//  }
;

class ExFlowingOpenableContainer: Openable, ExFlowingContainer
  initiallyOpen = true
;

class ExFlowingFlask: ExFlowingContainer
;

class ExFlowingGlass: ExFlowingContainer
  canPutIn(obj) {
    // madeOfPaper is our signal that even if the object has a small
    // bulk value, its length/width dimensions are such that it won't
    // fit.
    if (obj.madeOfPaper)
      return nil;
    else
      return true;
  }
  cannotPutInRestrictedMsg =
    '{The dobj/him} {is} too big to fit into {the iobj/him}. '
;

class ExFlowingBowl: ExFlowingContainer
;

class ExFlowingOpenableBottle: ExFlowingOpenableContainer
  dobjFor(Turn) {
    verify { }
    check { }
    action {
      if (isOpen)
        replaceAction(Close, self);
      else
        replaceAction(Open, self);
    }
  }
  okayOpenMsg = 'You turn the spout, opening the bottle. '
  okayCloseMsg = 'You turn the spout, closing the bottle. '
;

class ExFlowingOpenableBag: ExFlowingOpenableContainer
  dobjFor(Move) {
    verify { }
    check { }
    action {
      if (isOpen)
        replaceAction(Close, self);
      else
        replaceAction(Open, self);
    }
  }
  okayOpenMsg = 'You slide the slider seal, opening the bag. '
  okayCloseMsg = 'You slide the slider seal, closing the bag. '
;

//#ifdef __DEBUG
//
//modify ExFlowingContainer
//  dobjFor(Switch) {
//    verify { }
//    preCond = [objHeld]
//    check { }
//    action {
//      if (!asscThing) {
//        "ERROR: This cannot be switched into any other thing. ";
//      }
//      else {
//        "BAM! {The dobj/he} is transformed into <<asscThing.aName>>. ";
//        asscThing.moveInto(location);
//        self.moveInto(nil);
//      }
//    }
//  }
//;
//
//modify FlowingInContainer
//  dobjFor(Switch) {
//    verify { }
//    preCond = [objHeld]
//    check { }
//    action {
//      if (!asscThing) {
//        "ERROR: This cannot be switched into any other thing. ";
//      }
//      else {
//        "BAM! {The dobj/he} is transformed into <<asscThing.aName>>. ";
//        asscThing.moveInto(location);
//        self.moveInto(nil);
//      }
//    }
//  }
//;
//
//#endif // __DEBUG


// -------------------------------------------------------------------
// FOOD/DRINK: FLOWING STUFF: ExFlowingContainer objects: ExFlowingFlask objects
// -------------------------------------------------------------------

roundFlask: ExFlowingFlask
  '(clear) (transparent) (plastic) round flask*flasks'
  'round flask'
  //'fragrant (clear) round flask sake liquid -'
  //'round' 'flask' 'sake'
  asscThing = sake
  canFitObjThruOpening(obj) { return nil; }
  zapAry = die(
    'The round flask disappears.
      <p>Suddenly, with no warning, the building is bombarded
        with anti-aircraft gunfire! Deafening blasts come down from
        outside the building, while chunks of concrete rain down 
        as the ceiling is rent with gaping holes. 
      <p>Within a couple of seconds a chunk of concrete hits
        your head, and you fall to the floor, a tragic victim
        of the flak rounds. '
    , 'flak rounds', self, killEverybody
  )
;
conicalFlask: ExFlowingFlask
  '(clear) (transparent) (plastic) conical flask*flasks'
  'conical flask'
  //'conical flask (table) salt grains -' 
  //'conical' 'flask' 'table salt' 
  asscThing = tableSalt
  canFitObjThruOpening(obj) { return nil; }
;

// -------------------------------------------------------------------
// FOOD/DRINK: FLOWING STUFF: ExFlowingContainer objects: ExFlowingOpenableBottle objects
// -------------------------------------------------------------------

tallBottle: ExFlowingOpenableBottle
  '(clear) (transparent) (plastic) tall bottle spout -*bottles*spouts'
  'tall bottle'
  //'(dark) (aromatic) tall bottle bitters liquid -'
  //'tall' 'bottle' 'bitters'
  asscThing = dietPepsi
  canFitObjThruOpening(obj) { return nil; }
  zapT = disappear(
    'The tall bottle disappears.
      <p>This confuses you, and it will continue to confuse you
        for a long time to come. Then, years from now, you 
        will come across a magazine article on the Allbole virus
        of 18 Scorpii II. At that time, 
        the virus will be causing quite a scare, infecting all the 
        mammoth-like livestock of 18 Scorpii II and even its moon. 
        However, as you will learn,
        the virus is harmless to humanoids, including you. 
      <p>Not that you know any of this now, of course.
        Right now, all you know is that the tall bottle has 
        disappeared. '
    , self, 'Allbole'
  )
  zapAry = die(
    'The tall bottle disappears.
      <p>All of a sudden
        you are surrounded by angry combatants, some of whom are
        in the uniforms of the U.S. National Guard, while others 
        carry AK-47s and signs that say <.q>Freeways only!<./q> 
        and <.q>No more tolls!<.q> 
      <p>Gunfire erupts all around you. You duck for cover, 
        but it<./s>s too late. Just as you are crouching down,
        a bullet pierces your side.
        You fall to the ground, dead, another casualty of the toll
        battle. '
    , 'toll battle', self, killEverybodyInRoom
  )
;
wideBottle: ExFlowingOpenableBottle 
  '(clear) (transparent) (plastic) wide bottle spout -*bottles*spouts'
  'wide bottle'
  //'wide bottle vegetable oil liquid -'
  //'wide' 'bottle' 'vegetable oil'
  asscThing = vegetableOil
  canFitObjThruOpening(obj) { return nil; }
  zapT = transform(self, wideBole)
;
shortBottle: ExFlowingOpenableBottle
  '(clear) (transparent) (plastic) short bottle spout -*bottles*spouts'
  'short bottle'
  //'short bottle vegeable oil liquid -'
  //'short' 'bottle' 'vegeable oil'
  asscThing = vegeableOil
  canFitObjThruOpening(obj) { return nil; }
  zapAry = disappear(
    'Nothing happens at first.
      <p>Then, suddenly, a man materializes on the other side 
        of the room.  He is eight feet tall, with a 
        finely-combed beard and a huge hammer. It appears to be 
        Thor, the god of thunder!
      <p>He points to the bottle and says, <.q>Excuse me, 
        but that<./s>s mine.<./q> 
      <p>With that, he waves his hand. Presently 
        the short bottle fades to nothingness,
        then rematerializes in his hand.
      <p>Having done this, Thor waves his hand again, and he 
        dematerializes as quickly as he came. '
    , self, 'Thor\'s bottle'
  )
  zapT = transform(self, shorBole)
;
narrowBottle: ExFlowingOpenableBottle
  '(clear) (transparent) (plastic) narrow bottle spout -*bottles*spouts'
  'narrow bottle'
  //'narrow bottle diet pepsi liquid -'
  //'narrow' 'bottle' 'Diet Pepsi'
  asscThing = bitters
  canFitObjThruOpening(obj) { return nil; }
  zapT = transform(self, narrowBole)
;

// -------------------------------------------------------------------
// FOOD/DRINK: FLOWING STUFF: ExFlowingContainer objects: ExFlowingGlass objects
// -------------------------------------------------------------------

largeGlass: ExFlowingGlass
  '(clear) (transparent) (plastic) large glass*glasses'
  'large glass'
  //'large glass chocolate milk liquid -'
  //'large' 'glass' 'chocolate milk'
  asscThing = chocolateMilk
  bulkCapacity = 6
  maxSingleBulk = 2
;
smallGlass: ExFlowingGlass
  '(clear) (transparent) (plastic) small glass*glasses'
  'small glass'
  //'small glass chocolae milk liquid -'
  //'small' 'glass' 'chocolae milk'
  asscThing = chocolaeMilk
  bulkCapacity = 4
  maxSingleBulk = 2
;

// -------------------------------------------------------------------
// FOOD/DRINK: FLOWING STUFF: ExFlowingContainer objects: ExFlowingOpenableBag objects
// -------------------------------------------------------------------

greenBag: ExFlowingOpenableBag
  '(plastic) (clear) (transparent) green slider seal bag -*bags*seals'
  'green bag'
  //'green bag truffles -'
  //'green' 'bag' 'truffles'
  asscThing = truffles
  bulkCapacity = 15
  maxSingleBulk = 8
;
blueBag: ExFlowingOpenableBag
  '(plastic) (clear) (transparent) blue slider seal bag -*bags*seals'
  'blue bag'
  //'blue bag ruffles potato potatoes chip chips crisp crisps -'
  //'blue' 'bag' 'Ruffles'
  asscThing = ruffles
  bulkCapacity = 15
  maxSingleBulk = 8
;
lavenderBag: ExFlowingOpenableBag
  '(plastic) (clear) (transparent) lavender slider seal bag -*bags*seals'
  'lavender bag'
  //'blue bag ruffles potato potatoes chip chips crisp crisps -'
  //'blue' 'bag' 'Ruffles'
  asscThing = specialK
  bulkCapacity = 15
  maxSingleBulk = 8
;
purpleBag: ExFlowingOpenableBag
  '(plastic) (clear) (transparent) purple violet slider seal bag -*bags*seals'
  'purple bag'
  //'blue bag ruffles potato potatoes chip chips crisp crisps -'
  //'blue' 'bag' 'Ruffles'
  asscThing = taterTots
  bulkCapacity = 15
  maxSingleBulk = 8
;
turquoiseBag:  ExFlowingOpenableBag
  '(plastic) (clear) (transparent) turquoise slider seal bag -*bags*seals'
  'turquoise bag'
  //'blue bag ruffles potato potatoes chip chips crisp crisps -'
  //'blue' 'bag' 'Ruffles'
  asscThing = aeros
  bulkCapacity = 15
  maxSingleBulk = 8
;

// -------------------------------------------------------------------
// FOOD/DRINK: FLOWING STUFF: ExFlowingContainer objects: ExFlowingBowl objects
// -------------------------------------------------------------------

redBowl: ExFlowingBowl
  '(plastic) red bowl*bowls'
  'red bowl'
  //'red bowl minestrone soup broth vegetable vegetables liquid -'
  //'red' 'bowl' 'minestrone soup'
  asscThing = minestroneSoup
  bulk = 13
  bulkCapacity = 10
  maxSingleBulk = 8
;
pinkBowl: ExFlowingBowl
  '(plastic) pink bowl*bowls'
  'pink bowl'
  //'pink bowl minesrone soup liquid -'
  //'pink' 'bowl' 'minesrone soup'
  asscThing = minesroneSoup
  bulk = 13
  bulkCapacity = 10
  maxSingleBulk = 8
;
yellowBowl: ExFlowingBowl 
  '(plastic) yellow bowl*bowls'
  'yellow bowl'
  //'yellow bowl chicken noodle noodles soup broth liquid -'
  //'yellow' 'bowl' 'chicken noodle soup'
  asscThing = chickenNoodleSoup
  bulk = 13
  bulkCapacity = 10
  maxSingleBulk = 8
;
orangeBowl: ExFlowingBowl
  '(plastic) orange bowl*bowls'
  'orange bowl'
  //'orange bowl clam chowder soup liquid -'
  //'orange' 'bowl' 'clam chowder'
  asscThing = clamChowder
  bulk = 13
  bulkCapacity = 10
  maxSingleBulk = 8
;

//Wrapper location=westRoom;
//Wrapper location=westRoom;
//Wrapper location=westRoom;
//Wrapper location=westRoom;
//Wrapper location=westRoom;
//Wrapper location=westRoom;


// -------------------------------------------------------------------
// FOOD/DRINK: WRAPPER/WRAPPABLE STUFF: Food modifications for Wrappable
// -------------------------------------------------------------------

modify Food
  dobjFor(Taste) {
    verify {
      if (eatingObjection)
        illogical(eatingObjection);
    }
  }
  dobjFor(Eat) {
    verify {
      if (eatingObjection)
        illogical(eatingObjection);
    }
    action() {
      defaultReport(&okayEatMsg);
      // My addition:
      eatingConsequences;
      moveInto(nil);
    }
  }
  
  tasteDesc {
    say(foodTasteDescPrefix);
    say(foodTasteDesc);
    say(foodTasteDescSuffix);
  }
  foodTasteDescPrefix = 'You taste ' + theName + '. '
  foodTasteDesc = '\^' + itIsContraction + ' not bad. '
  foodTasteDescSuffix = nil
  
  okayEatMsg {
    return foodEatDescPrefix + foodEatDesc + foodEatDescSuffix;
  }
  foodEatDescPrefix = 'You take a bite of ' + theName + '. '
  foodEatDesc = (foodTasteDesc)
  foodEatDescSuffix = 'You keep eating more and more of the ' + nameAbbr
    + ', until finally ' + itIsContraction + ' gone. '
  // Let this be the default for nonsense food, like carro cake.
  smellDesc = "It smells okay. "
  
  isRaw = nil
  // Make this a s.q. string if you want to prohibit eating.
  eatingObjection {
    if (isRaw)
      return 'No thanks. ' + (isPlural ? 'These ' : 'This ') 
        + name + ' ' + verbToBe 
        + ' uncooked, and you<./s>re not the kind of guy who likes to
        eat raw meat. ';
    else
      return nil;
  }
  giveShowType {
    if (ofKind(FoodCan))
      return cannedFood;
    if (isUnpeeled)
      return unpeeledFood;
    if (isRaw)
      return rawFood;
    return goodFood;
  }
  vickiShowResponse {
    if (isRaw) {
      if (self == steak)
        "<.q>Not a bad-looking steak,<./q> says Vicki. ";
      else
        "<.q>Some pretty good-looking <<nameForCommentary>>,<./q>
          says Vicki. ";
      "<.q>Later, when we get a chance to cook 
        <<self == brats ? 'those, I bet they<./s>ll' : 'that, I bet it<./s>ll'>>
        be delicious.<./q> ";
    }
    else { // food is good to eat
      // initial comment
      if (vicki.foodEaten < vicki.satiationLevel)
        //"<.q>Mmm,<<tastiness >= 4 ? ' delicious' : ''>> 
        //  <<name>>,<./q> says Vicki. ";
        "<.q>Mmm, <<name>>,<./q> says Vicki. ";
      else if (!contentsArePlural)
        "<.q>Not a bad-looking <<contentsName>>,<./q>
          says Vicki. ";
      else //contentsArePlural, and Vicki isn't hungry
        "<.q>Some pretty good-looking <<name>>,<./q>
          says Vicki. ";
      // additional comment
      if (vicki.foodEaten < vicki.satiationLevel)
        "<.q>If you<./s>re not too hungry, would you consider 
          giving <<isPlural ? 'those' : 'that'>> to me? 
          I<./s>m still pretty hungry.<./q> ";
      else if (diane.foodEaten < diane.satiationLevel)
        "<.q>If you<./s>re not too hungry, you might consider 
          giving <<isPlural ? 'those' : 'that'>> to Diane. 
          She still looks hungry.<./q> ";
      else
        "<.q>Another good find from our food provider.<./q> ";
    }
  }
  dianeShowResponse {
    if (isRaw) {
      "<.q>Ah, <<nameForCommentary>>,<./q> says Diane. 
        <.q>The delight of any carnivore. <.q>Too bad
        <<self == brats ? 'they<./s>re' : 'it<./s>s'>>
        not cooked now, but we can fix that later on.<./q> ";
    }
    else { // food is good to eat
      // initial comment
      "<.q><<tastiness >= 4 && diane.foodEaten < diane.satiationLevel
        ? 'Hey, ' : '\^'>><<isPlural ? 'those look' : 'that looks'>>
        <<tastiness >= 4 && diane.foodEaten < diane.satiationLevel
        ? 'delicious' : 'pretty good'>>,<./q> says Diane. ";
      // additional comment
      if (diane.foodEaten < diane.satiationLevel)
        "<.q>If you<./s>re not too hungry, just let me know, and 
          I<./s>d be glad to take <<isPlural ? 'those' : 'that'>> 
          off your hands for you.<./q> ";
      else if (vicki.foodEaten < vicki.satiationLevel)
        "<.q>If you<./s>re not too hungry, you might consider 
          giving <<isPlural ? 'those' : 'that'>> to Vicki. 
          She still looks hungry.<./q> ";
      else
        "<.q>Another fine addition to our food stash.<./q> ";
    }
  }
;

modify Thing
  // tastiness is used to determine how much the food will tempt 
  // Vicki and Diane to steal it from you when they see it.
  tastiness = 0
  isSweet = nil
  isUnpeeled = nil
  eatingConsequences { } // modify as needed
;


// -------------------------------------------------------------------
// FOOD/DRINK: WRAPPER/WRAPPABLE STUFF: Wrappable listers
// -------------------------------------------------------------------

wrappableInlineContentsLister: inlineListingContentsLister
  showListPrefixWide(cnt, pov, parent) {
    " (in ";
  }
;

class BaseWrappableContentsLister: Lister
  showListPrefixWide(itemCount, pov, parent) {
    "\^<<parent.theNameObj>>
    <<itemCount == 1 ? 'is' : 'are'>> in ";
    //"\^<<parent.theNameObj>>
    //<<itemCount == 1 ? tSel('is', 'was')
    //                   : tSel('are', 'were')>> in ";
  }
  showListSuffixWide(itemCount, pov, parent) {
    ". ";
  }
  showListPrefixTall(itemCount, pov, parent) {
    "\^<<parent.theNameObj>>
    <<itemCount == 1 ? 'is' : 'are'>> in:";
    //"\^<<parent.theNameObj>>
    //<<itemCount == 1 ? tSel('is', 'was')
    //                 : tSel('are', 'were')>> in:";
  }
  showListContentsPrefixTall(itemCount, pov, parent) {
    "\^<<parent.aName>>, which
    <<itemCount == 1 ? 'is' : 'are'>> in:";
    //"\^<<parent.aName>>, which
    //<<itemCount == 1 ? tSel('is', 'was')
    //                 : tSel('are', 'were')>> in:";
  }
;

wrappableContentsLister: ContentsLister, BaseWrappableContentsLister
;

wrappableDescContentsLister: DescContentsLister, BaseWrappableContentsLister
;

// -------------------------------------------------------------------
// FOOD/DRINK: WRAPPER/WRAPPABLE STUFF: "unwrapped" precondition
// -------------------------------------------------------------------

unwrapped: PreCondition
  checkPreCondition(obj, allowImplicit) {
    if (obj == nil)
      return nil;
    if (!obj.ofKind(Wrappable) && !obj.ofKind(Wrapper))
      return nil;
    // if the object is already unwrapped, we're already done
    if (!obj.isWrapped)
      return nil;
    // try an implicit 'unwrap' command on the object
    if (allowImplicit && tryImplicitAction(Unwrap, obj)) {
      // we executed the command - make sure it worked, and abort
      // if it didn't 
      if (obj.isWrapped)
        exit;
      // tell the caller we executed an implied command
      return true;
    }
    // can't open it implicitly - report the failure
    conditionFailed(obj);
    exit;
  }
  // The condition failed - report the failure and give up.  We
  // separate this to allow subclasses to report failure differently
  // for specialized types of opening.  
  conditionFailed(obj) {
    // can't unwrap it implicitly - report failure and give up
    reportFailure(&mustBeUnwrappedMsg, obj);
    // make it the pronoun
    gActor.setPronounObj(obj);
  }
  // reduce the likelihood rating for anything that isn't already open
  verifyPreCondition(obj) {
    // if the object is closed, reduce its likelihood rating
    if (obj != nil && obj.isWrapped)
      logicalRankOrd(80, 'implied unwrap', 150);
  }
;

modify playerActionMessages
  mustBeUnwrappedMsg(obj) {
    gMessageParams(obj);
    return '{You/he} will have to unwrap {the obj/him}
            before {it actor/he} {can} do that. ';
  }
;

// -------------------------------------------------------------------
// FOOD/DRINK: WRAPPER/WRAPPABLE STUFF: Wrappable class, etc.
// -------------------------------------------------------------------

class Wrappable: object
  wrapperWords = (name)
  objInPrep = 'on'
  circularlyInMessage = &circularlyOnMsg
  putDestMessage = &putDestSurface
  tryMovingObjInto(obj) { return tryImplicitAction(PutOn, obj, self); }
  cannotPutInSelfMsg = &cannotPutOnSelfMsg
  alreadyPutInMsg = &alreadyPutOnMsg
  //// What does alwaysInitiallyUnwrapped mean? For example:
  //// Suppose you transform carrotCake into carroCake. Should the 
  //// latter be wrapped when it appears? Yes, but only if the
  //// former was wrapped when transformed; otherwise not.
  //// By contrast, the oatCracker should never appear wrapped
  //// when it appears as a result of a transformation. 
  //// oatCracker.alwaysInitiallyUnwrapped = true
  //alwaysInitiallyUnwrapped = nil
  wrapperVocabWords {
    local wwl = wrapperWordList;
    local str = '';
    if (!wwl) return '';
    if (wwl.length == 0) return '';
    for (local a = 1; a <= wwl.length; a++) {
      str = str + '(' + wwl[a] + ') ';
    }
    str = str + '-';
    return str;
  }
  wrapperWordList {
    local tok;
    local newtok = [];
    tok = Tokenizer.tokenize(wrapperWords);
    if (!tok)
      return [];
    if (tok.length == 0)
      return [];
    for (local a = 1; a <= tok.length; a++) {
      newtok = newtok + tok[a][1];
    }
    return newtok;
  }
  contentsLister = wrappableContentsLister
  descContentsLister = wrappableDescContentsLister
  lookInLister = thingLookInLister
  inlineContentsLister = wrappableInlineContentsLister
  isWrapped {
    if (contents.length < 1) return nil;
    for (local a = 1; a <= contents.length; a++) {
      if (contents[a].ofKind(Wrapper)) return true;
    }
    return nil;
  }
  getWrapper {
    if (!contents)
      return nil;
    if (contents.length < 1)
      return nil;
    for (local a = 1; a <= contents.length; a++) {
      if (contents[a].ofKind(Wrapper))
        return contents[a];
    }
    return nil;
  }
  examineStatus() {
    if (isWrapped)
      "\^<<itIsContraction>> wrapped in a cellophane wrapper. ";
      //"\^<<itIsContraction>> covered with a cellophane wrapper. ";
      //"The <<nameAbbr>> <<verbToBe>> wrapped in a cellophane wrapper. ";
    //examineListContents();
  }
  feelDesc {
    if (getWrapper) {
      "\^<<nameIs>> wrapped in a cellophane wrapper. ";
      getWrapper.feelDesc;
    }
    else {
      inherited;
    }
  }
  wrapperDesc = nil
  wrapperFeelDesc = nil
  dobjFor(Smell) {
    verify {
      if (gDobj && getWrapper) {
        illogical('It<./s>s hard to smell {the dobj/him}, because 
          {it\'s} wrapped in a cellophane wrapper. ');
      }
    }
  }
  //smellDesc {
  //  if (getWrapper)
  //    "It<./s>s hard to smell <<theName>>, because it<./s>s wrapped
  //      in a cellophane wrapper. ";
  //  else
  //    inherited;
  //}
  //dobjFor(Remove) {
  //  verify {
  //    if (isWrapped) logical;
  //    else inherited;
  //  }
  //  check {
  //    if (isWrapped) { }
  //    else inherited;
  //  }
  //  action {
  //    if (isWrapped)
  //  }
  //}
  dobjFor(Unwrap) {
    verify {
      if (!getWrapper)
        illogical('{The dobj/him} {is}n<./s>t wrapped in anything. ');
      if (gDobj && unwrappingObjection)
        illogical(unwrappingObjection);
      // If, e.g., a steak has a wrapper, UNWRAP STEAK is to be slightly 
      // preferred as against UNWRAP WRAPPER.
      else
        logicalRank(110, 'wrappable thing with wrapper');
    }
    // The following line makes a big difference. If you think about it,
    // you can't very well unwrap something unless you're holding it.
    preCond = [objHeld]
    // Skip the whole roomToHold precondition. It doesn't apply
    // to my game.
    //check {
    //  if (unwrappingObjection) {
    //    say(unwrappingObjection);
    //    exit;
    //  }
    //}
    action() {
      local wr = getWrapper;
      getWrapper.moveInto(gActor);
      defaultReport(playerActionMessages.okayUnwrapMsg(wr, self));
    }
  }
  // set this to be a string if you want to prohibit unwrapping.
  unwrappingObjection = nil
  rawFoodUnwrappingObjection =
    '\^' + nameIs + ' raw, and will 
      probably spoil a lot faster if ' + itIsContraction 
      + ' unwrapped. Better not to unwrap ' + itObj 
      + ' until you have a good reason to. '
  dobjFor(Wrap) {
    verify {
      if (getWrapper)
        illogicalNow('{The dobj/him} {is} already wrapped in a 
          cellophane wrapper. Putting another one around 
          {it dobj/him} wouldn<./s>t serve much purpose. ');
      // otherwise logical
    }
  }
  dobjFor(WrapIn) {
    verify {
      if (getWrapper)
        illogicalNow('{The dobj/him} is already wrapped in a 
          cellophane wrapper. Putting another one around it
          wouldn<./s>t serve much purpose. ');
    }
  }
  iobjFor(WrapAround) {
    verify {
      if (getWrapper)
        illogicalNow('{The iobj/him} is already wrapped in a 
          cellophane wrapper. Putting another one around it
          wouldn<./s>t serve much purpose. ');
    }
  }
  iobjFor(PutOn) {
    verify {
      if (gDobj && gDobj.ofKind(Wrapper))
        logical;
      else
        inherited;
    }
    action {
      replaceAction(WrapIn, gIobj, gDobj);
    }
  }
  dobjFor(TakeFrom) {
    preCond = [touchObj, objNotWorn, roomToHoldObj]
    verify() {
      if (gIobj != nil && !self.isIn(gIobj) && getWrapper != gIobj) {
        illogicalAlready(gIobj.takeFromNotInMessage);
      }
      if (gIobj != nil && self.isIn(gIobj)) {
        verifyDobjTake();
      }
    }
    check() {
      if (gIobj != nil && self.isIn(gIobj)) {
        checkDobjTake();
      }
    }
    action() {
      if (gIobj != nil && self.isIn(gIobj)) {
        actionDobjTake();
      }
      else {
        replaceAction(Unwrap, self);
      }
    }
  }
  dobjFor(Open) asDobjFor(Unwrap)
  dobjFor(Close) asDobjFor(Wrap)
  // This only matters for the sake of 
  isWrappedUponArrival = true
  
  
  //iobjFor(PutOn) {
  //  verify() { }
  //  action() {
  //    gDobj.moveInto(self);
  //    defaultReport(&okayPutOnMsg);
  //  }
  //}
  
  
  dobjFor(Taste) {
    preCond = [objHeld]
  }
  // same as Food.tasteDesc
  tasteDesc {
    say(foodTasteDescPrefix);
    say(foodTasteDesc);
    say(foodTasteDescSuffix);
  }
  foodTasteDescPrefix {
    if (getWrapper)
      return 'You unwrap ' + theName + ' and ' + tasteMsg + ' it. ';
    else
      return 'You ' + tasteMsg + ' ' + theName + '. ';
  }
  tasteMsg = 'taste'
  foodTasteDesc = '\^' + itIsContraction + ' not bad. '
  foodTasteDescSuffix {
    if (getWrapper)
      return 'After you<./s>re done, you wrap the ' + nameAbbr 
        + ' back up again. ';
    else
      return nil;
  }
  
  // With just one exception (the unwrapped precondition), 
  // can be inherited from Food or Thing as the case may be.
  dobjFor(Eat) {
    preCond = [objHeld, unwrapped]
    action() {
      defaultReport(&okayEatMsg);
      // My addition:
      eatingConsequences;
      moveInto(nil);
    }
  }
  magicallyWrap {
    // if already wrapped, do nothing.
    if (getWrapper)
      return;
    // Otherwise...
    local obj = new Wrapper;
    obj.moveInto(self);
  }
  magicallyUnwrap {
    // if already unwrapped, do nothing.
    if (!getWrapper)
      return;
    // otherwise...
    getWrapper.moveInto(nil);
  }
  dynamicWrapperForTransformation = nil
  processTransformation(otherThing) {
    if (!dynamicWrapperForTransformation)
      return;
    if (otherThing.getWrapper)
      magicallyWrap;
    else // otherThing is unwrapped
      magicallyUnwrap;
  }
  eatingConsequences {
    local myContents = contents;
    if (!myContents.length)
      return;
    for (local a = myContents.length; a >= 1; a--) {
      if (contents[a].ofKind(Wrapper))
        contents[a].moveInto(location);
    }
  }
;

modify Actor
  iobjFor(TakeFrom) {
    verify() {
      if (gDobj == nil) {
        if (gTentativeDobj.indexWhich({x: x.obj_.isIn(self)}) == nil)
          illogicalAlready(takeFromNotInMessage);
        else if (gTentativeDobj.indexWhich(
          {x: x.obj_.isDirectlyIn(self)}) != nil) {
          
            
          // Hacked to make the logicalRank not always 150.
          if (gActor == self)
            logicalRank(130, 'directly in the current actor');
          else
            logicalRank(150, 'directly in');
          // end hack
            
            
        }
      }
      else if (!gDobj.isIn(self)) {
          illogicalAlready(takeFromNotInMessage);
      }
      else if (gDobj.isDirectlyIn(self)) {
         
         
        // Hacked to make the logicalRank not always 150.
        if (gActor == self)
          logicalRank(130, 'directly in the current actor');
        else
          logicalRank(150, 'directly in');
        // end hack
         
         
      }
    }
  }
;

modify Thing
  nameAbbr = (name)
  processTransformation(obj) { }
;

//Wrappable template 'vocabWords' 'wrapperWords' 'name' @location? "desc"?;

// -------------------------------------------------------------------
// FOOD/DRINK: WRAPPER/WRAPPABLE STUFF: Wrapper class, etc.
// -------------------------------------------------------------------

#ifndef never
enum never;
#endif

#ifndef sometimes
enum sometimes;
#endif

#ifndef always
enum always;
#endif

class Wrapper: Thing
  vocabWords = 'clear cellophane plastic wrapper*wrappers'
  name = 'wrapper'
  bulk = 0
  weight = 0  
  wrapperIsListed = always
  isListed = (isListedInContents)
  isListedInContents {
    if (wrapperIsListed == always)
      return true;
    else
      return (!isWrapped);
  }
  isListedInInventory {
    if (wrapperIsListed != never)
      return true;
    else
      return (!isWrapped);
  }
  // If a wrapper is being used, hide it from, e.g., GET ALL
  hideFromAll(action) {
    if (isWrapped && 
         (action.ofKind(TakeAction)
       || action.ofKind(DropAction)
       || action.ofKind(PutInAction)
       || action.ofKind(PutOnAction)))
      return true;
    else
      return nil;
  }
  // hideFromDefault is commented out because it probably does make 
  // sense to go with the Thing default, where hideFromDefault
  // equals hideFromAll.
  //hideFromDefault(action) { return nil; }
  filterResolveList(lst, action, whichObj, np, requiredNum) { 
    if (isWrapped && 
        hideFromAll(gAction) &&
        lst.countWhich( {x: (x.obj_.ofKind(Wrapper)) 
                         && !x.obj_.isWrapped} ) >= 1 ) { 
      local idx = lst.indexWhich( {x: x.obj_ == self } ); 
      lst = lst.removeElementAt(idx); 
    } 
    return lst; 
  } 
  //isListed = (!isWrapped)
  //isListedInContents = (!isWrapped)
  //isListedInInventory = (!isWrapped)
  //basicName = 'wrapper'
  //basicVocabWords = 'clear (thingamabob) cellophane plastic wrapper'
  isEquivalent = true
  isWrapped {
    if (location && location.ofKind(Wrappable))
      return true;
    else
      return nil;
  }
  moveInto(newContainer) {
    // standard stuff:
    moveIntoNotifyPath(newContainer);
    // my hack:
    removeWrappedWords(location);
    // standard stuff:
    mainMoveInto(newContainer);
    // my hack:
    addWrappedWords(location);
  }
  //// this didn't seem to work, but whatever
  //disambigName {
  //  if (location && location.ofKind(Wrappable))
  //    return location.wrapperWords + ' ' + name;
  //  else
  //    return name;
  //}
  // Remove all words from vocabulary that have to do with
  // the thing that we're being unwrapped from.
  removeWrappedWords(loc) {
    if (loc && loc.ofKind(Wrappable) && loc.wrapperWordList 
        && loc.wrapperWordList.length > 0) {
      for (local a = 1; a <= loc.wrapperWordList.length; a++) {
        cmdDict.removeWord(self, loc.wrapperWordList[a], &adjective);
        while (self.adjective && self.adjective.indexOf(loc.wrapperWordList[a])) {
          self.adjective = 
            self.adjective.removeElementAt(self.adjective.indexOf(loc.wrapperWordList[a]));
        }
        while (self.weakTokens && self.weakTokens.indexOf(loc.wrapperWordList[a])) {
          self.weakTokens = 
            self.weakTokens.removeElementAt(self.weakTokens.indexOf(loc.wrapperWordList[a]));
        }
        if (self.weakTokens && self.weakTokens.length == 0) {
          self.weakTokens = nil;
        }
      }
    }
  }
  addWrappedWords(loc) {
    if (loc && loc.ofKind(Wrappable)) {
      self.initializeVocabWith(loc.wrapperVocabWords);
    }
  }
  construct() {
    initializeVocab();
    // Here's my little hack:
    addWrappedWords(location);
    addToDictionary(&noun);
    addToDictionary(&adjective);
    addToDictionary(&plural);
    addToDictionary(&adjApostS);
    addToDictionary(&literalAdjective);
  }
  initializeThing() {
    initializeLocation();
    if (isEquivalent)
      getSuperclassList()[1].initializeEquivalent();
    if (globalParamName != nil)
      langMessageBuilder.nameTable_[globalParamName] = self;
    // My hack:
    addWrappedWords(location);
  }
  desc {
    if (location && location.wrapperDesc)
      say(location.wrapperDesc);
    else
      "The wrapper is made of clear cellophane. ";
  }
  lookInDesc {
    if (isWrapped)
      "\^<<nameIs>> wrapped around <<location.aName>>. ";
    else
      inherited;
  }
  examineStatus() {
    if (isWrapped)
      "\^<<itIsContraction>> wrapped around <<location.aName>>. ";
    //examineListContents();
  }
  feelDesc {
    if (location && location.wrapperFeelDesc)
      say(location.wrapperFeelDesc);
    else
      "The cellophane feels much as you would expect. ";
  }
  dobjFor(Unwrap) {
    verify {
      if (!location.ofKind(Wrappable))
        illogical('{The dobj/him} {is}n<./s>t wrapped around
          anything. ');
      else if (gDobj && location.unwrappingObjection)
        illogical(location.unwrappingObjection);
    }
    //check {
    //  if (location.unwrappingObjection) {
    //    say(location.unwrappingObjection);
    //    exit;
    //  }
    //}
    // Skip the whole roomToHold precondition. It doesn't apply
    // to my game.
    action() {
      replaceAction(Unwrap, location);
      
      //local th = location;
      //moveInto(gActor);
      //defaultReport(playerActionMessages.okayUnwrapMsg(self, th));
    }
  }
  dobjFor(Wrap) {
    verify() {
      if (isWrapped)
        logicalRank(70, 'already being used');
      // otherwise logical
    }
    action {
      askForIobj(WrapAround);
    }
  }
  iobjFor(WrapIn) {
    verify {
      if (gDobj && gDobj == location)
        illogical('{The iobj/he} is already wrapped around {the dobj/him}. ');
      else if (isWrapped)
        logicalRank(70, 'already being used');
      else if (isHeldBy(gActor))
        logicalRank(120, 'held');
    }
    preCond = [objHeld, unwrapped]
    action {
      moveInto(gDobj);
      okayWrapText(gDobj, gIobj);
    }
  }
  dobjFor(WrapAround) {
    verify {
      if (gDobj && gDobj == location)
        illogical('{The dobj/he} is already wrapped around {the iobj/him}. ');
      else if (isWrapped)
        logicalRank(70, 'already being used');
    }
    preCond = [objHeld, unwrapped]
    action {
      moveInto(gIobj);
      okayWrapText(gIobj, gDobj);
    }
  }
  okayWrapText(th, wr) {
    gMessageParams(th, wr);
    "{You/he} wrap {the th/him} in {the wr/him}. ";
  }
  
  iobjFor(PutIn) {
    verify { }
    action {
      replaceAction(WrapIn, gDobj, gIobj);
    }
      
  }
  dobjFor(Take) {
    verify {
      if (isWrapped)
        logicalRank(80, 'wrapped');
      else
        inherited;
    }
    action {
      if (isWrapped)
        replaceAction(Unwrap, self);
      else
        inherited;
    }
  }
  // Hacked so as to depend upon whether gDobj.getWrapper == self,
  // rather than whether gDobj.isDirectlyIn(self).
  iobjFor(TakeFrom) {
    verify() {
      if (gDobj == nil) {
        if (gTentativeDobj.indexWhich({ x: x.obj_.getWrapper == self }) == nil)
          illogicalAlready(takeFromNotInMessage);
        else if (gTentativeDobj.indexWhich(
          {x: x.obj_.getWrapper == self}) != nil) {
          logicalRank(140, 'in wrapper');
        }
      }
      else if (gDobj.getWrapper != self) {
        illogicalAlready(takeFromNotInMessage);
      }
      else if (gDobj.getWrapper == self) {
        logicalRank(140, 'in wrapper');
      }
    }
  }
  notWearableMsg = (glob.cannotWrapSelfMsg)
  dobjFor(Open) asDobjFor(Unwrap)
  dobjFor(Close) asDobjFor(Wrap)
  // If the wrapper is wrapped around something when it's hit by the
  // ary ung or T-removing gun, it's like shooting the wrapped thing
  // rather than the wrapper.
  
  transformObj {
    if (isWrapped) return location;
    else return self;
  }
  //hitByAry() {
  //  if (isWrapped)
  //    location.hitByAry();
  //  else
  //    inherited();
  //}
  //hitByT() {
  //  if (isWrapped)
  //    location.hitByT();
  //  else
  //    inherited();
  //}
;

modify me
  uselessToWrapMsg = (glob.cannotWrapSelfMsg)
;
modify glob
  cannotWrapSelfMsg = 'Wrapping yourself would serve no purpose. '
;

//DefineIAction(Special)
//  execAction() {
//    thingObj.initializeVocabWith('(very) (special) -');
//  }
//;
//VerbRule(Special)
//  'special'
//  : SpecialAction
//  verbPhrase = 'make/making it special'
//;
//DefineIAction(Unspecial)
//  execAction() {
//    cmdDict.removeWord(thingObj, 'very', &adjective);
//    cmdDict.removeWord(thingObj, 'special', &adjective);
//    thingObj.weakTokens = nil;
//    while (thingObj.adjective.indexOf('very')) {
//      thingObj.adjective = 
//        thingObj.adjective.removeElementAt(thingObj.adjective.indexOf('very'));
//    }
//    while (thingObj.adjective.indexOf('special')) {
//      thingObj.adjective = 
//        thingObj.adjective.removeElementAt(thingObj.adjective.indexOf('special'));
//    }
//  }
//;
//VerbRule(Unspecial)
//  'unspecial'
//  : UnspecialAction
//  verbPhrase = 'make/making it unspecial'
//;
//thingObj: Thing
//  'small little thing'
//  'little thing'
//  @breakRoom
//;


// -------------------------------------------------------------------
// FOOD/DRINK: WRAPPER/WRAPPABLE STUFF: Wrappable/Wrapper objects
// -------------------------------------------------------------------

milkChocolate: Wrappable, Satiating, Food
  '(delicious) (sweet) (smooth) milk chocolate bar -'
  'bar of milk chocolate'
  @nil
  "This is a delicious-looking bar of smooth milk chocolate. "
  bulk = (chocolateMilk.bulk)
  nameAbbr = 'chocolate'
  //aName = 'a bar of milk chocolate'
  wordName = 'milk chocolate'
  aWordName = 'milk chocolate'
  smellDesc = "It smells very sweet. "
  foodTasteDesc = 'It<./s>s deliciously sweet. '
  tastiness = 5
  isSweet = true
  zapT = transform(self, milkChocolae)
  zapAry = transform(self, chocolateMilk)
  foodName = 'milk chocolate'
  aFoodName = 'some ' + foodName
  //theFoodName = 'the ' + foodName
  scarfsPhrase = 'scarfs down ' + theFoodName + ' in just seconds'
;
+ Wrapper;

torte: Wrappable, Satiating, Food
  '(delicious) (chocolate) austrian torte sachertorte cake -*cakes'
  'torte'
  @lowerFridgeDrawer
  "This torte looks delicious; in fact, it appears to be none other than 
    a Sachertorte, an Austrian chocolate cake! It is very small
    for a torte, though. Perhaps it is meant to be a single serving. "
  bulk = 5
  smellDesc = "It smells very sweet. "
  foodTasteDesc = 'The flavor is sweet and wonderfully rich. '
  tastiness = 5
  isSweet = true
  zapT = transform(self, ore)
  // Do otters bark? The San Diego Zoo says so!
  // http://www.sandiegozoo.org/animalbytes/t-otter.html
  zapAry = disappear(
    transformUnsimulated('an otter')
        + 'The otter stands up on its hind legs and barks at you. 
        Then, quickly, the little creature '
        + (doorInThisRoomMustBeOpened()
           ? 'heads for the door, pushes it open, and ' : '')
        + 'runs out of the room, far out of sight. '
    , self, 'otter'
  )
  zapAryCq {
    openDoorInThisRoom();
  }
;
+ Wrapper;

carrotCake: Wrappable, Satiating, Food
  '(orange) (vanilla) (white) (creamy) frosting carrot cake -*cakes'
  'carrot cake'
  @lowerFridgeDrawer
  "The cake is orange, and is topped
    with creamy white frosting. "
  nameAbbr = 'cake'
  bulk = 5
  smellDesc = "It smells very sweet. "
  foodTasteDesc = 'The flavor is sweet and wonderfully rich. '
  dynamicWrapperForTransformation = true
  tastiness = 5
  isSweet = true
  zapT = transform(self, carroCake)
  zapAry = transform(self, oatCracker)
;
+ Wrapper;

carroCake: SemiNonsense, Wrappable, Satiating, Food
  'carro cake*cakes'
  'carro cake'
  @nil
  "It looks like a typical, average cake. "
  nameAbbr = 'cake'
  bulk = 5
  smellDesc = "It smells like a typical, average cake. "
  foodTasteDesc = 'It tastes like a typical, average cake. '
  dynamicWrapperForTransformation = true
  tastiness = 3
  isSweet = true
;
+ Wrapper;

brats: Wrappable, Satiating, Food
  '(raw) (reddish) (red) (pink) (reddish-pink) brat bratwurst sausage 
    -*brats*bratwursts*sausages'
  'brats'
  @upperFridgeDrawer
  "The bratwursts are raw, reddish-pink sausages. They look pretty good, 
    but you<./s>d need to cook them before you could eat them. "
  bulk = 12
  isPlural = true
  isRaw = true
  unwrappingObjection = (rawFoodUnwrappingObjection)
  //wordName = 'brats'
  //aWordName = wordName
  //wordNameIsPlural = true
  zapT = transform(self, bras)
;
+ Wrapper;

bras: Wrappable, Wearable
  '(plain) (white) bras'
  'bras'
  @nil
  "The bras are white and rather plain. "
  isPlural = true
  bulk = 12
  dobjFor(Unwrap) {
    check {
      "You start to unwrap the bras, but then you ask yourself, why
        on earth am I doing this? Feeling a bit embarrassed, you 
        wrap the bras back up again. ";
      exit;
    }
  }
  dobjFor(Taste) {
    verify {
      illogical('The bras do not appear to be edible. ');
    }
  }
  dobjFor(Wear) {
    verify {
      if (gDobj)
        illogical('You<./s>ve always had a policy of not wearing
          women<./s>s undergarments, and you see no reason to 
          change that now. ');
    }
  }
  //Note that I am no longer transforming this into a bars object.
  //Iron bars would be problematic, and "bars" as sweet baked items
  //just don't feel right to me.
  zapAry = die(
    'The bras disappear. 
      <p>Suddenly, to your amazement, a taco bar appears right 
        across the room! Then, to your further surprise, 
        a snack bar appears right next to it. Finally, right in
        front of you, a salad bar appears.
      <p>Unfortunately, all these these bars seem a bit too 
        much for this location. \^' + floorCollapseMsg(true)
      + fallThroughFloorMsg
    , 'bars', self, killEverybodyInRoom
  )
  vickiShowResponse =
    "<.q>Wherever did you get these bras?<./q> Vicki asks, 
      flashing you a puzzled look. <.q>Well, never mind that. 
      Anyway, Diane and I could take them off your hands 
      if you want. I mean, it<./s>s not like you have any use 
      for them.<./q> "
  dianeShowResponse =
    "<.q>Hmm, a package of bras,<./q> says Diane. <.q>Somehow, 
      <<me.firstName>>, I never imagined you as the type. 
      But hey, to each his own.<./q> "
  vickiGiveResponse {
    "<.q>I don<./s>t know where you got these from, 
      but they<./s>ll probably come in handy 
      for Diane and me,<./q> says Vicki, taking 
      <<theNameForCommentary>>. ";
    moveInto(vicki);
  }
  dianeGiveResponse {
    "Diane shakes her head as she takes the bras. 
      <.q>Yes, I<./s>m sure Vicki and me will find these 
      more useful than you,<./q> she says with wry amusement. ";
    moveInto(diane);
  }
;
+ Wrapper;

// No more bars. The bras now turn into bars of the kind that kill you
// instead.

//bars: Wrappable, Food
//  'bars'
//  'bars'
//  @nil
//  bulk = 12
//  isPlural = true
//  wordName = 'bars'
////  //zapAry = transform(self, brasPackage)
//;
//+ Wrapper;

mutton: Wrappable, Satiating, Food
  '(red) (raw) mutton'
  'mutton'
  @upperFridgeDrawer
  "The mutton is red and raw. Being no mutton connoisseur, you 
    can<./s>t judge it much better than that. "
  aName = 'some mutton'
  aWordName = 'mutton'
  bulk = 12
  isRaw = true
  unwrappingObjection = (rawFoodUnwrappingObjection)
  // Note to self: After searching the web, I found no answer I understood
  // to the question of muon lifespan. However, from what data I did find,
  // I'm willing to go out on a limb with my "couple of microseconds"
  // figure.
  // http://www.jlab.org/~cecire/muonanalysis.html
  zapT = disappear(
    'The mutton disappears.
      <p>This perplexes you for quite some time. After you think
        about it, however, you realize that the mutton may have turned 
        into a muon, which, being only a semi-stable particle, would
        have decayed within a couple of microseconds. '
    , self, 'muon'
  )
;
+ Wrapper;

steak: Wrappable, Satiating, Food
  '(raw) steak/beef'
  'steak'
  @upperFridgeDrawer
  "The raw steak has a minimum of fat around the edges. 
    It looks really good, but of course 
    you<./s>d have to cook it before you could eat it. "
  bulk = 5
  isRaw = true
  unwrappingObjection = (rawFoodUnwrappingObjection)
  zapT = transform(self, seak)
  zapAry = transform(self, stake)
;
+ Wrapper;

taco: Wrappable, Satiating, Food
  'tortilla (soft) shell soft-shell softshell taco beef lettuce tomato tomatoes -'
  'taco'
  @upperFridgeShelf
  "This is a really big taco, consisting of a soft-shell tortilla
    filled with beef, lettuce, and tomatoes. "
  bulk = 10
  smellDesc = "The meat is cold, but it smells okay. A little spicy. "
  tasteMsg = 'grab a small bite of'
  foodTasteDescPrefix {
    if (getWrapper)
      return 'You unwrap ' + theName + ' and eat a couple pieces
        of lettuce and tomato. ';
    else
      return 'You eat a couple pieces of lettuce and tomato. ';
  }
  foodTasteDesc = 'They taste pretty good. '
  foodEatDesc = 'It<./s>s very spicy and flavorful, even though 
    the meat is cold from having been in the fridge. '
  tastiness = 5
  zapT = transform(self, aco)
  zapAry = transform(self, coat)
;
+ Wrapper;

roastBeefSandwich: Wrappable, Satiating, Food
  '(white) bread roast beef sandwich'
  'roast beef sandwich'
  @upperFridgeShelf
  "To be honest, this isn<./s>t the best-looking sandwich 
    you<./s>ve ever seen. It<./s>s just roast beef on white bread, 
    nothing more. "
  nameAbbr = 'sandwich'
  bulk = 4
  smellDesc = "The roast beef smells good. "
  tasteMsg = 'take a small bite of'
  foodTasteDesc = 'It tastes okay, although it<./s>s nothing special. '
  foodEatDesc = 'It<./s>s an okay sandwich, though hardly the
    best you<./s>ve ever eaten. '
  tastiness = 4
  zapT = transform(self, roasBeefSandwich)
  zapAry = disappear(
    'The roast beef sandwich disappears.
      <p>Then, suddenly, across the room, a group of three 
        crazed-looking people appears!
      <p>The first of them, a bearded man in a black hat, shouts,
        <.q>Down with DOS! We need better support for the Hebrew
        language!<./q>
        Then, having said this, he '
        + (doorInThisRoomMustBeOpened()
          ? 'heads for the door, opens it, and ' : '')
        + 'runs out of the room.
      <p>The next person, an angry-looking teenager in a 
        Pac-Man shirt, cries, 
        <.q>Long live CP 862!<./q> 
        With that, he runs off after his companion.
      <p>The last person, a woman in a black trenchcoat, pulls out
        a gun and shouts, <.q>We<./s>ll find you, Gates!
        Oh yes, we<./s>ll find you!<./q> Then she, too, runs out.
      <p>With all of them gone, you shake your head warily, 
        scarcely able to believe such a bizarre 
        appearance of Hebrew DOS fanatics. '
    , self, 'Hebrew DOS fanatics'
  )
  zapAryCq {
    openDoorInThisRoom();
  }
;
+ Wrapper;

roasBeefSandwich: SemiNonsense, Wrappable, Satiating, Food
  'roas beef sandwich'
  'roas beef sandwich'
  @nil
  "It looks like a typical, average beef sandwich. "
  nameAbbr = 'sandwich'
  bulk = 4
  tasteMsg = 'take a small bite of'
  smellDesc = "It smells like a typical, average beef sandwich. "
  foodTasteDesc = 'It tastes like a typical, average beef sandwich. '
  dynamicWrapperForTransformation = true
  tastiness = 2
  zapAry = die(
    transformUnsimulated('a puddle of fresh Bone-Saw acid')
        + 'From what you<./s>ve heard, this acid really lives up
        to its brand name, easily eating through even the toughest
        organic substances, including bone.
      <p>Unfortunately, the acid materialized so suddenly that
        it created an outward splash, falling onto your legs and
        feet.
      <p>Well, at least your death is quick. '
    , 'fresh Bone-Saw acid', self //,killEverybodyInRoom
  )
;
+ Wrapper;

iceCreamBar: Wrappable, Satiating, Food
  '(chocolate) ice cream wooden bar/stick'
  'ice cream bar'
  location = geFreezer.subContainer
  desc =
    "It<./s>s very cold, with a frozen chocolate coating, and, 
      you assume, ice cream inside. It<./s>s on a wooden stick. "
  nameAbbr = 'bar'
  bulk = 4
  wrapperDesc = 'The wrapper is made of clear cellophane, and feels
    unusually cold. '
  wrapperFeelDesc = 'The cellophane feels unusually cold. '
  //wrapperDesc = 'The wrapper is made of clear cellophane. Now
  //  that you look closer, you notice that it feels unusually cold. 
  //  You wonder if it might somehow be serving to keep the ice
  //  cream bar cold. '
  //wrapperFeelDesc = 'The cellophane feels unusually cold, as though
  //  it were somehow serving to keep the ice cream bar cold. '
  dobjFor(Unwrap) {
    check {
      // Prohibit unwrapping unless you are just about to eat the 
      // ice cream bar.
      if (!gAction.isImplicit 
          || gAction.parentAction == nil 
          || !gAction.parentAction.ofKind(EatAction)) {
        say('As you start to unwrap the ice cream bar, 
          you feel a surprising sensation of coldness emerge from the 
          wrapper. You surmise that the wrapper is somehow keeping the ice
          cream bar cold, so you decide not to remove the wrapper until
          you really need to. ');
        exit;
      }
    }
  }
  foodTasteDescPrefix {
    if (getWrapper)
      return 'You unwrap the ice cream bar, releasing a lot of
        cold. You taste the bar, and ';
    else
      return 'You taste ' + theName + '. \^';
  }
  foodEatDescSuffix = 'You keep eating more and more of the ' + nameAbbr
    + ', until finally all that<./s>s left is the wooden stick. '
  foodTasteDesc = 'its coating tastes very chocolatey. '
  foodEatDesc = 'It<./s>s deliciously sweet and very cold. '
  eatingConsequences {
    //woodenStick.moveInto(gActor);
    woodenStick.moveInto(location);
  }
  tastiness = 5
  isSweet = true
  scarfsPhrase = 'scarfs down ' + theFoodName + ' in just seconds'
  zapAry = transform(self, ceramicBear)
;
+ Wrapper;

// move this into PC after he eats the ice cream bar
woodenStick: Thing
  '(ice) (cream) wooden wood stick'
  'wooden stick'
  @nil
  "This is the wooden stick that the ice cream bar was on. "
  bulk = 0
  zapT = transform(self, woodenSick)
;

// Wrappable food not initially in wrappers

oatCracker: Wrappable, Satiating, Food
  'oat cracker'
  'oat cracker'
  @nil
  "It looks like an ordinary cracker, but you can tell from its
    smell that it<./s>s made of oats. "
  nameAbbr = 'cracker'
  bulk = 0
  //alwaysInitiallyUnwrapped = true
  foodEatDescPrefix = 'You gulp down ' + theName + '. '
  foodEatDescSuffix = ''
  smellDesc = "It has the hearty smell of oats. "
  foodTasteDesc = 'It has a hearty, whole-grain flavor. '
  tastiness = 1
  devoursPhrase = 'devours ' + theFoodName + ' in a single gulp'
  scarfsPhrase = 'scarfs down ' + theFoodName + ' in a single gulp'
  zapT = transform(self, oaCracker)
  zapAry = transform(self, carrotCake)
;

oaCracker: SemiNonsense, Wrappable, Satiating, Food
  'oa cracker'
  'oa cracker'
  @nil
  "It looks like a typical, average cracker. "
  bulk = 0
  nameAbbr = 'cracker'
  //alwaysInitiallyUnwrapped = true
  foodEatDescPrefix = 'You gulp down ' + theName + '. '
  foodEatDescSuffix = ''
  smellDesc = "It smells like a typical, average cracker. "
  foodTasteDesc = 'It tastes like a typical, average cracker. '
  dynamicWrapperForTransformation = true
  tastiness = 1
  devoursPhrase = 'devours ' + theFoodName + ' in a single gulp'
  scarfsPhrase = 'scarfs down ' + theFoodName + ' in a single gulp'
;

friedEgg: Wrappable, Satiating, Food
  'fried egg'
  'fried egg'
  @nil
  "It looks just like an ordinary fried egg. "
  nameAbbr = 'egg'
  bulk = 2
  isWrappedUponArrival = nil
  smellDesc = "It smells just like an ordinary fried egg. "
  foodTasteMsg = 'The fried egg tastes normal. '
  okayEatMsg = 'That was delicious! '
  tastiness = 4
  devoursPhrase = 'devours ' + theFoodName + ' in just seconds'
  scarfsPhrase = 'scarfs down ' + theFoodName + ' in just seconds'
  zapAry = die(
    'The fried egg is transformed into Fieggerd, the famous
        whale-like fish of 18 Scorpii II television! 
      <p>Unfortunately,
        although Fieggerd is extremely cute, he also weighs 
        five hundred tons
        and has materialized directly on top of you,
        crushing you and killing you instantly. '
    , 'Fieggerd', self, killEverybodyInRoom
  )
;

// -------------------------------------------------------------------
// FOOD/DRINK: Non-wrappable food
// -------------------------------------------------------------------

lemon: Satiating, Food // not wrappable
  'lemon'
  'lemon'
  @upperFridgeShelf
  "It<./s>s just an average lemon. "
  //"It<./s>s as good-looking a lemon as any. "
  bulk = 4
  eatingObjection = 
    'What, eat a lemon? I think not. '
  dobjFor(Taste) {
    verify {
      if (gDobj) 
        illogical('You don<./s>t need to peel the lemon to know that
          it<./s>ll probably taste sour. ');
    }
  }
  smellDesc = "The unpeeled lemon doesn<./s>t smell like much. "
  dobjFor(Peel) {
    verify {
      if (gDobj)
        illogical('There<./s>s no need to peel the lemon, since
          you have no intention of eating it. ');
    }
  }
  dobjFor(Open) {
    verify {
      if (gDobj)
        illogical('There<./s>s no need to slice open the lemon, since
          you have no intention of eating it. ');
    }
  }
  dobjFor(Break) asDobjFor(Open)
  dobjFor(Attack) asDobjFor(Open)
  dobjFor(AttackWith) asDobjFor(Open)
  isUnpeeled = true
  vickiShowResponse {
    "<.q>\^<<aNameForCommentary>>, huh?<./q> Well, hang on
      to that. Maybe we can use that for cooking sometime
      later.<./q> ";
  }
  dianeShowResponse {
    "<.q>Congratulations,<./q> says Diane. <.q>You<./s>ve managed 
      to snag <<aNameForCommentary>>. Maybe we can use it 
      for cooking or something later.<./q> ";
  }
  zapAry = transform(self, melon)
;

melon: Satiating, Food // not wrappable
  'purple melon'
  'melon'
  @nil
  "This melon is unlike any you<./s>ve ever seen. It is purple, and
    is about the size of a grapefruit. You gather that 
    this must be some non-Earth kind of melon. "
  bulk = (lemon.bulk)
  eatingObjection = 
    'No thanks. First of all, this appears to be from some other
      planet, and you have no idea if it<./s>s safe for humans.
      Second, you<./s>d have to get it open somehow, and it<./s>s
      not at all clear how to do that. '
  dobjFor(Open) {
    verify {
      if (gDobj)
        illogical('There<./s>s no obvious way to do that. ');
    }
  }
  dobjFor(Break) asDobjFor(Open)
  dobjFor(Attack) asDobjFor(Open)
  dobjFor(AttackWith) asDobjFor(Open)
  dobjFor(Peel) asDobjFor(Open)
  isUnpeeled = true
  vickiShowResponse {
    "<.q>That looks like no melon I<./s>ve ever seen,<./q> says Vicki. 
      <.q>Do you think it<./s>s safe to eat?<./q> ";
    ncYesNo.set(
      // YES:
      'Even if you say that, it doesn<./s>t look like you<./s>ll 
        persuade Vicki. ',
      // NO:
      'It looks like Vicki agrees with you. '
    );
  }
  dianeShowResponse =
    "<.q>Wow,<./q> says Diane. <.q>With that and eleven other melons,
      you could keep the Exotic Melon of the Month Club
      going for a whole year. If there was only had one member, 
      anyway.<./q> "
  zapAry = transform(self, lemon)
;

// -------------------------------------------------------------------
// FOOD/DRINK: FoodCan class and objects
// -------------------------------------------------------------------

class FoodCan: Thing
  bulk = 6
  cannotOpenMsg = 'You can<./s>t just open a metal ' + canNoun + ' 
    with your bare hands. '
  cannotCloseMsg = 'The ' + canNoun + ' is made of solid metal. I guess
    that means it<./s>s as closed as it<./s>s ever going to get. '
  lookInDesc = "Without being able to open the <<canNoun>>, you know it
    contains <<wordName>>, at least according to the label. "
  cannotEatMsg = (cannotConsumeMsg('eat'))
  cannotConsumeMsg(verb) {
    return 'It seems unlikely that you<./s>ll be able to ' + verb
      + ' the ' + wordName + ' as long as '
      + (wordNameIsPlural ? 'they<./s>re' : ' it<./s>s')
      + ' inside a metal ' + canNoun + '. ';
  }
  canNoun = 'can'
  giveShowType = cannedFood
  nameForCommentary = wordName
  aNameForCommentary = 'some ' + wordName
  theNameForCommentary = 'the ' + wordName
  aFoodName = 'some ' + wordName
  theFoodName = 'the ' + wordName
  contentsArePlural = true
  //cannotConsumeMsg(verb) {
  //  return 'Perhaps I didn<./s>t make myself clear. The ' 
  //    + wordName + (wordNameIsPlural ? ' are' : ' is')
  //    + ' inside a tin can. That means you can<./s>t ' 
  //    + verb + (wordNameIsPlural ? ' them. ' : ' it. ');
  //}
  
  vickiShowResponse =
    "<.q>\^<<aNameForCommentary>>, huh?<./q> says Vicki. <.q>Well, 
      <<contentsArePlural 
      ? 'those are good to have. We can eat them'
      : 'that<./s>s good to have. We can eat it'>>
      later, after we<./s>ve figured out how to open 
      the <<canNoun>>.<./q> "
  dianeShowResponse =
    "<.q>Congratulations,<./q> says Diane. <.q>You<./s>ve managed 
      to snag <<aNameForCommentary>>. Maybe we can eat 
      <<contentsArePlural ? 'them' : 'it'>> later, 
      after we<./s>ve figured out how to open the <<canNoun>>.<./q> "
;

// When you have an unopenable food container, but it makes more sense
// to call it a tin than a can.
class FoodTin: FoodCan
  canNoun = 'tin'
;

beets: Satiating, FoodCan
  '(tin) (metal) vegetable vegetables beet beets can label -'
  'can of beets'
  @cupboard
  "The can reads <.q>Beets,<./q> and shows a picture of the 
    familiar vegetable. "
  wordName = 'beets'
  wordNameIsPlural = true
  zapT = die(
    transformUnsimulated('a swarm of bees')
        + 'Your heart leaps as you look at them. These insects are
        the size of hummingbirds. In fact, they are none other than
        the killer bees of 18 Scorpii II, famous for their 
        aggressiveness.
      <p>In an instant, they look around for a target, and find you.
        When they attack you, it is like being stabbed by 
        a hundred poisoned icepicks. '
    , 'bees', 'beets', killEverybodyInRoom
  )
;

mapleSyrup: Satiating, FoodTin
  'tin (metal) maple syrup (can) -'
  'tin of maple syrup'
  @cupboard
  "The tin reads, <.q>Maple Syrup,<./q> and shows 
    a rustic scene of a country yeoman tapping a tree.
    It might be appetizing if you had any waffles 
    or pancakes to go with it. "
  wordName = 'maple syrup'
  aWordName = 'maple syrup'
  cannotDrinkMsg = (cannotConsumeMsg('drink'))
  contentsArePlural = nil
  cannotOpenMsg = 'You can<./s>t just open this kind of tin with your
    bare hands. Besides, you don<./s>t really have the 
    French toast or other confection to warrant such an action. '
  zapAry = transform(self, purpleYams)
;

purpleYams: Satiating, FoodCan
  '(tin) (metal) (sweet) can purple yam/potato/yams/potatoes'
  'can of purple yams'
  @nil
  "The can shows a picture of exactly the sort of tubers 
    you<./s>ve come to know as yams, except instead of orange, 
    they<./s>re bright purple. It<./s>s rather disconcerting. "
  wordName = 'purple yams'
  wordNameIsPlural = true
  cannotOpenMsg = 'You can<./s>t just open a tin can with your
    bare hands. Besides, although these purple yams might do in a pinch, 
    they wouldn<./s>t exactly be your first food choice. '
  zapAry = transform(self, mapleSyrup)
;

// Losing the baked beans (location = nil). While I liked the 
// "baked beans" / "naked babes" anagram in some ways, that's no 
// reason to go alienating my female players.

bakedBeans: Satiating, FoodCan
  '(tin) (metal) baked beans can label -'
  'can of baked beans'
  @nil 
  "The can reads <.q>Baked Beans,<./q> and shows a picture of the 
    familiar side dish. "
  wordName = 'baked beans'
  wordNameIsPlural = true
  askAry = question(
    nil, 'Do you object to off-color jokes? '
  )
  zapAry = die(
    transformUnsimulated('a group of ten or twelve naked babes')
      + '<p>So surprising is this, and so provocative are the 
        women<./s>s well-tanned bodies, that your pulse quickens
        uncontrollably. And then, suddenly, you are seized by an
        all-too-familiar pain in the chest. You collapse 
        to the floor in agonizing pain.
      <p>The naked women try to revive you, but it<./s>s no use. 
      <p>Some men would say this isn<./s>t a bad way to go,
        but in your final moments, you find this offers little 
        consolation. '
    , 'naked babes', self
  )
;

// Losing the chocolate syrup (location = nil).
// On second thought, the "chocolate syrup to super-cool yacht"
// transformation isn't so terribly compelling that it's worth
// the potentially frustrating vocabulary conflict with the
// milk chocolate and chocolate milk.

chocolateSyrup: Satiating, FoodCan 
  '(tin) (metal) (brown) chocolate syrup can label -'
  'can of chocolate syrup'
  @nil
  "The can reads <.q>Chocolate Syrup,<./q> and shows a picture of 
    the familiar dark brown syrup. "
  wordName = 'chocolate syrup'
  contentsArePlural = nil
  cannotDrinkMsg = (cannotConsumeMsg('drink'))
  zapT = transform(self, chocolaeSyrup)
  zapAry = die(
    transformUnsimulated('a super-cool yacht')
        + 'Unfortunately, the yacht is so big
        that ' + floorCollapseMsg(nil)
      + fallThroughFloorMsg
    , 'super-cool yacht', 'chocolate syrup', killEverybodyInRoom
  )
;

chocolaeSyrup: SemiNonsense, Satiating, FoodCan 
  '(tin) (metal) chocolae syrup can label -'
  'can of chocolae syrup'
  @nil
  "The can reads <.q>Chocolae Syrup,<./q> and shows a picture of 
    a typical, average kind of syrup. "
  wordName = 'chocolae syrup'
  contentsArePlural = nil
  cannotDrinkMsg = (cannotConsumeMsg('drink'))
//  wordName = 'chocolae syrup'
;

// -------------------------------------------------------------------
// TRANSFORMATIONS: TRANSFORMED THINGS: Miscellaneous things
// -------------------------------------------------------------------

ceramicBear: Thing 
  '(lovely) (white) ceramic polar bear/sculpture' 
  'ceramic bear'
  @nil
  "This is a small ceramic sculpture in the shape
    of a bear. "
  bulk = (iceCreamBar.bulk)
  isFragile = true
  dobjFor(Attack) {
    verify {
      if (gDobj)
        illogical('Granted, this isn<./s>t what you<./s>d call high 
          art, but there<./s>s no need to smash it. ');
    }
  }
  dobjFor(AttackWith) asDobjFor(Attack)
  dobjFor(Break) asDobjFor(Attack)
  vickiShowResponse =
    "<.q>I suppose it has a certain charm,<./q> says Vicki. 
      <.q>But now is not the time to weigh ourselves down 
      with useless knick-knacks.<./q> "
  dianeShowResponse =
    "<.q>What kitsch,<./q> says Diane dismissively. 
      <.q>Why you picked that up I<./s>ll never know.<./q> "
  zapAry = transform(self, iceCreamBar)
;

ore: Thing
  '(small) (unidentified) lump/chunk/hunk/ore'
  'ore'
  @nil
  "It<./s>s a small lump of some unidentified ore. "
  bulk = 3
  aName = 'a lump of ore'
  //aWordName = 'ore'
  zapAry = disappear(
    transformUnsimulated('a roe')
        + 'The little deer looks up at you with a startled 
        expression, then quickly '
        + (doorInThisRoomMustBeOpened()
           ? 'heads for the door, pushes it open, and ' : '')
        + 'runs out of the room, far out of sight. '
    , self, 'roe'
  )
  zapAryCq {
    openDoorInThisRoom();
  }
;

stake: Thing
  '(wooden) stake'
  'stake'
  @nil
  "It<./s>s an ordinary wooden stake. No doubt it will come in very
    handy if you run into any vampires, or any incomplete tent kits. "
  bulk = (steak.bulk)
  // Alas, it hardly seems fair to include this unless I make
  // it a valid iobj for hitting.
  iobjFor(Attack) {
    verify { }
  }
  zapAry = transform(self, steak)
  zapT = transform(self, sake)
;

tiedPipes: Thing
  '(metal) (pair) tied pipe/pipes'
  'pair of tied pipes'
  @nil
  "This is a strange artifact indeed: two metal pipes have been fused
    together, not by welding, but by having been tied in a knot. 
    How they got that way, you have no idea. "
  wordName = 'tied pipes'
  wordNameIsPlural = true
  bulk = (dietPepsi.bulk)
  //isPlural = true
  iobjFor(Attack) {
    verify {
      illogical('The tied pipes are way too awkward to be used
        to hit anything with. ');
    }
  }
  zapT = lose(
    'The tied pipes disappear, and are replaced by I<./s>ed pipes!
      <p>Uh oh. '
    , ftIedPipes, 'I\'ed pipes', 'tied pipes'
  )
  zapAry = transform(self, dietPepsi)
;

ftIedPipes: FinishType
  finishMsg = 'You have been transformed into a couple of pipes'
;

coat: Cloak, Wearable
  //'tan leather fleece fleece-lined (lined) coat'
  '(bright) orange thermal coat/parka'
  'coat'
  @nil
  "It's a bright orange thermal parka. This thing could probably
    keep you warm even in the Yukon. "
  // Commented out because untested:
  //iobjFor(PutIn) {
  //  verify {
  //    illogical('The coat doesn<./s>t have any pockets. ');
  //  }
  //}
  bulk = 40
  zapT = transform(self, coa)
  zapAry = transform(self, taco)
;

silkCape: Wearable
  'red silk cape'
  'silk cape'
  @nil
  "The cape is red and made of silk. "
  // Commented out because untested:
  //iobjFor(PutIn) {
  //  verify {
  //    illogical('The coat doesn<./s>t have any pockets. ');
  //  }
  //}
  bulk = 20
  zapAry = transform(self, specialK)
;

shogun: Thing
  'james clavell clavell\'s shogun package infocom game copy -'
  '<i>Shogun</i>'
  "It<./s>s a copy of James Clavell's <i>Shogun,</i> 
    the classic Infocom game, adapted by Dave Lebling. 
    The package says that it requires a 
    3.5-inch floppy disk drive. "
  bulk = 2
  isProperName = true
  // Very important:
  madeOfPaper = true
  dobjFor(Open) {
    verify { }
    check {
      "There<./s>s no need to open the package unless you can
        find a 3.5-inch floppy disk drive. ";
      exit;
    }
  }
  dobjFor(Play) {
    verify { }
    check {
      "You won<./s>t be able to play this game unless you can 
        find a computer with a 3.5-inch floppy disk drive. ";
      exit;
    }
  }
  dobjFor(Run) asDobjFor(Play)
  dobjFor(Execute) asDobjFor(Play)
  wordName = 'Shogun'
  aWordName = '<i>Shogun,</i> the classic Infocom game'
  vickiShowResponse =
    "<.q>Ah, <i>Shogun,<./q></i> says Vicki, nodding. 
      <.q>Not Infocom<./s>s best, or so I<./s>ve heard. 
      But hey, if that<./s>s what you like, more power to you.<./q> "
  dianeShowResponse =
    "Diane widens her eyes and makes a show of flinching back. 
      <.q>Keep that thing away from me,<./q> she says. 
      <.q>I hope I never see another computer game 
      for as long as I live.<./q> "
;

// -------------------------------------------------------------------
// TRANSFORMATIONS: TRANSFORMED THINGS: Nonsense, SemiNonsense classes
// -------------------------------------------------------------------

class Nonsense: Thing
  desc = "\^<<itNom>> look<<verbEndingS>> just like <<aName>>, 
    whatever <<isPlural ? 'those are' : 'that is'>>. "
  transformText(thing1) {
    "\^<<thing1.theWordName>> 
      <<thing1.wordNameIsPlural ? 'are' : 'is'>> 
      transformed into 
      <<aWordName>>, whatever
      <<isPlural ? 'those are' : 'that is'>>. ";
  }
  bulk = 3
  isNonsense = true
  isSemiNonsense = true // i.e., yes, this is at least halfway to being nonsense
;

// a mix-in class for things like vegeableOil, whose names contain
// adjectives that don't make sense, even though the nouns do make sense.
class SemiNonsense: object
  transformText(thing1) {
    "\^<<thing1.theWordName>> 
      <<thing1.wordNameIsPlural ? 'are' : 'is'>> 
      transformed into 
      <<aWordName>>, whatever
      <<isPlural ? 'those are' : 'that is'>>. ";
  }
  isSemiNonsense = true
;

modify Thing
  isNonsense = nil
  isSemiNonsense = nil // i.e., no, this does not rise to the level of being halfway nonsensical
;

// -------------------------------------------------------------------
// TRANSFORMATIONS: TRANSFORMED THINGS: Nonsense objects
// -------------------------------------------------------------------

crysal: Nonsense
  'crysal'
  'crysal'
;
milkChocolae: Nonsense 
  'milk chocolae'
  'milk chocolae'
;
cerificae: Nonsense
  'cerificae'
  'cerificae'
  //bulk = 3
  bulk = (certificate.bulk)
;
woodenSick: Nonsense
  'wooden wood sick'
  'wooden sick'
  // bulk is larger than that of the woodenStick, but so be it.
  bulk = (woodenStick.bulk)
  //bulk = 3
;
seak: Nonsense
  'seak'
  'seak'
  bulk = (steak.bulk)
  zapAry = transform(self, sake, 'stake or seak')
;
aco: Nonsense
  'aco'
  'aco'
;
coa: Nonsense
  'coa'
  'coa'
;

wideBole: Nonsense
  'wide bole*boles'
  'wide bole'
;
shorBole: Nonsense
  'shor bole*boles'
  'shor bole'
;
narrowBole: Nonsense
  'narrow bole*boles'
  'narrow bole'
;
elecricPisol: Nonsense
  'elecric pisol'
  'elecric pisol'
;
silencedPisol: Nonsense
  'silenced pisol'
  'silenced pisol'
;
phoonicDisruper: Nonsense
  'phoonic disruper'
  'phoonic disruper'
;
xenie: Nonsense
  'xenie'
  'xenie'
;
blaser: Nonsense
  'blaser'
  'blaser'
;

//// -------------------------------------------------------------------
//// OBSOLETE ACHIEVEMENT STUFF
//// -------------------------------------------------------------------
//
//// This is a bogus way of saving the achievement data. Won't survive an 
//// undo. But good enough, until we have a way of saving it to disk.
//modify glob
//  achievements = nil // rethink this later
//  eKey = 'asdf1234'
//;
//
//function saveAchievementProgress(thing1WordName, thing2WordName) {
//  if (glob.achievements == nil) {
//    glob.achievements = [];
//  }
//  //local encrypted = encrypt('Noof|Noof');
//  //local decrypted = decrypt(encrypted);
//  
//  glob.achievements += ['abc', 'bee'];
//  glob.achievements += ['cat', 'dog'];
//  glob.achievements += ['emu', 'fly'];
//  glob.achievements += ['gnu', 'hen'];
//  glob.achievements += ['ice', 'jay'];
//  glob.achievements += ['keg', 'leg'];
//}
//
//function writeFileExample() {
//  local f;
//  try {
//    f = File.openTextFile('mazes.m9v', FileAccessWrite);
//  }
//  catch (FileNotFoundException fnf) {
//  }
//  catch (RuntimeError rte) {
//    if (rte.errno_ == 2019) {
//      //throw new SettingsNotSupportedException();
//    }
//    //throw rte;
//  }
//  f.writeFile('asdf|asdf\n');
//  f.writeFile('zxcv|zxcv\n');
//  f.writeFile('qwer|qwer\n');
//  f.closeFile();
//}
//
//function readFileExample() {
//  local f;
//  try {
//    f = File.openTextFile('mazes.m9v', FileAccessRead);
//  }
//  catch (FileNotFoundException fnf) {
//  }
//  catch (RuntimeError rte) {
//    if (rte.errno_ == 2019) {
//      //throw new SettingsNotSupportedException();
//    }
//    //throw rte;
//  }
//  
//  local myList = [];
//  local l;
//  l = f.readFile();
//  while (l != nil) {
//    l = l.findReplace('\n', '');
//    myList += l;
//    l = f.readFile();
//  }
//  
//  f.closeFile();
//}
//
//// Gonna try using the XOR algorithm with the TADS 3 String.mapToByteArray function.
//// http://stackoverflow.com/questions/2532668/help-me-with-xor-encryption
//// http://www.tads.org/t3doc/doc/sysman/string.htm
//
//function encrypt(inputString) {
//  local inputByteArray = new ByteArray(inputString);
//  for (local i = 1; i <= inputByteArray.length; i++) {
////    figure out what to do here
//  }
//  return toString(inputByteArray);
//}
//
//function decrypt(inputString) {
//  local inputByteArray = new ByteArray(inputString);
//  for (local i = 1; i <= inputByteArray.length; i++) {
////    figure out what to do here
//  }
//  return toString(inputByteArray);
//}
//
////function OLD_encrypt(x) {
////  local y = (x ^ glob.eKey);
////  return y;
////}
////
////function OLD_decrypt(y) {
////  local x = (y ^ glob.eKey);
////  return x;
////}


// -------------------------------------------------------------------
// TRANSFORMATIONS: Transformation functions
// -------------------------------------------------------------------

// -----------------
// CONVENIENCE STUFF ADDED AUGUST 24, 2006

function doAryConsequences() {
  if (!glob.hackedToPreventAryConsequences) {
    if      (glob.curTransType==&zapT   ) (glob.curTransObj).zapTCq   ;
    else if (glob.curTransType==&zapT2  ) (glob.curTransObj).zapT2Cq  ;
    else if (glob.curTransType==&zapAry ) (glob.curTransObj).zapAryCq ;
    else if (glob.curTransType==&zapAry2) (glob.curTransObj).zapAry2Cq;
  }
}

function achieveTransformation(oldName, newName) {
  if      (glob.curTransType==&zapT   || glob.curTransType==&zapT2  ) 
  {
    achieveTransformationT(oldName, newName);
  }
  else if (glob.curTransType==&zapAry || glob.curTransType==&zapAry2) 
  {
    achieveTransformationAry(oldName, newName);
  }
}

function achieveTransformationT(oldName, newName) {
  // This isn't specific to tRemoverAchievement1 or tRemoverAchievement2;
  // both will do the same thing
  tRemoverAchievement1.addToList(oldName + '=' + newName);
}

function achieveTransformationAry(oldName, newName) {
  // This isn't specific to aryUngAchievement1 or aryUngAchievement2;
  // both will do the same thing
  aryUngAchievement1.addToList(oldName + '=' + newName);
}


function openDoorInThisRoom() {
  if (gActor && gActor.getOutermostRoom
      && gActor.getOutermostRoom.getDoorForLeavingRoom)
    gActor.getOutermostRoom.getDoorForLeavingRoom.makeOpen(true);
}
function doorInThisRoomMustBeOpened() {
  if (!gActor || !gActor.getOutermostRoom 
      || !gActor.getOutermostRoom.getDoorForLeavingRoom)
    return nil;
  return (!gActor.getOutermostRoom.getDoorForLeavingRoom.isOpen);
}


function transform(thing1, thing2, [args]) {
  // parse the arguments
  local oldName = nil;
  if (args && args.length >= 1) {
    oldName = args[1];
  }
  //// can add this later if we want more functionality:
  //for (local i = 1; i <= args.length; i++) {
  //  local arg = args[i];
  //}
  
  
  if (glob.doAryText) {
    thing2.transformText(thing1);
    // presently, processTransformation is only used to make some
    // wrappable items either gain or lose wrappers.
    thing2.processTransformation(thing1);
    thing2.baseMoveInto(thing1.location);
    if (thing1.isWorn) { thing1.makeWornBy(nil); }
    thing1.moveInto(nil);
    doAryConsequences();
    if (!thing2.isSemiNonsense) {
      if (!oldName) {
        oldName = thing1.wordName;
      }
      achieveTransformation(oldName, thing2.wordName);
    }
    //saveAchievementProgress(thing1.wordNameForAchievement, thing2.wordNameForAchievement);
  }
  return true;
}

// Perhaps change this to deal differently with liquids.
function disappear(msg, obj, newName, [args]) {
  if (glob.doAryText) {
    local oldName = obj.wordName;
    if (args && args.length) {
      oldName = args[1];
    }
    
    say(msg);
    if (obj.ofKind(ShadowCaster))
      obj.scMoveInto(nil);
    else
      obj.moveInto(nil);
    doAryConsequences();
    achieveTransformation(oldName, newName);
  }
  return true;
}

function die(msg, newName, oldObjOrName, [args]) {
  // remember a list of all the NPCs
  local npcList = [
    neton, ovan, oldGuard, youngGuard, assistant, vicki, diane
  ];
  
  // parse the optional parameters
  local killType = nil;
  local transformationType = nil;
  for (local i = 1; i <= args.length; i++) {
    local arg = args[i];
    if (arg == killEverybody || arg == killEverybodyInRoom) {
      killType = arg;
    }
    if (arg == nonsenseTransformation) {
      transformationType = arg;
    }
  }
  
  // remember the old name for purposes of giving you achievement credit
  local oldName = oldObjOrName;
  if (dataType(oldObjOrName) == TypeObject) {
    oldName = (oldObjOrName).wordName;
  }
  
  if (glob.doAryText) {
    // Say the death message and do any consequences
    say(msg);
    doAryConsequences();
    if (killType) {
      for (local a = 1; a <= npcList.length; a++) {
        if (killType == killEverybody)
          npcList[a].scMoveInto(nil);
        if (killType == killEverybodyInRoom && 
            npcList[a].getOutermostRoom == me.getOutermostRoom)
          npcList[a].scMoveInto(nil);
      }
    }
    
    // give achievement credit, unless we've been explicitly told that the 
    // thing that's killing us is nonsense
    if (transformationType != nonsenseTransformation) {
      achieveTransformation(oldName, newName);
    }
    
    // kill the player
    if (!glob.hackedToPreventAryConsequences) {
      endGame(ftDeath);
    }
  }
  return true;
}
enum killEverybody, killEverybodyInRoom;
enum nonsenseTransformation;

//// removed from die():
//#ifdef __DEBUG
//    // tremendous hack:
//    if (glob.doingWordNameInventory) {
//      say('<p><b><<ftDeath.finishMsg>></b></p>');
//    }
//    else {
//      endGame(ftDeath);
//    }
//#else
//    endGame(ftDeath);
//#endif


function lose(msg, ft, newName, oldObjOrName) {
  if (glob.doAryText) {
    local oldName = oldObjOrName;
    if (dataType(oldObjOrName) == TypeObject) {
      oldName = (oldObjOrName).wordName;
    }
    
    say(msg);
    doAryConsequences();
    achieveTransformation(oldName, newName);
    
    if (!glob.hackedToPreventAryConsequences) {
      endGame(ft);
    }
  }
  return true;
}

//// removed from lose():
//#ifdef __DEBUG
//    // tremendous hack:
//    if (glob.doingWordNameInventory) {
//      say('<p><b><<ft.finishMsg>></b></p>');
//    }
//    else {
//      endGame(ft);
//    }
//#else
//    endGame(ft);
//#endif

function question(desired, str) {
  local k, l;
  if (glob.doAryText) {
    //"<.p>";
    "Before you do this, you will need to 
      answer a question. ";
    say(str); 
    " (Please answer yes or no.) <.p>";
    for (;;) {
      ">>";
      k = inputManager.getInputLine(nil, nil);
      l = nil;
      if (k.length > 0) {
      
        for (local a = 1; a <= k.length; a++) {
          if (k.substr(a,1) != ' ') {
            l = k.substr(a,1).toLower;
            break;
          }
        }
      }
      if (l) {
        if (l == 'y' && desired != nil) {
          "<.p>";
          return true;
        }
        if (l == 'n' && desired == nil) {
          "<.p>";
          return true;
        }
        else {
          "<.p>";
          return nil;
        }
      }
    }
  }
  return true;
}

modify glob
  doAryText = nil
  curTransType = nil
  curTransObj = nil
;

modify Thing
  aryTextOn()  { glob.doAryText = true; }
  aryTextOff() { glob.doAryText = nil;  }
  handleBlast(propZap) {
    // set up appropriate property values
    local propNil, propBlastText;
    if (propZap == &zapAry || propZap == &zapAry2) {
      propNil = &nilAry;
      propBlastText = &aryBlastText;
      glob.curTransType = propZap;
      glob.curTransObj = self;
    }
    else if (propZap == &zapT || propZap == &zapT2) {
      propNil = &nilT;
      propBlastText = &tBlastText;
      glob.curTransType = propZap;
      glob.curTransObj = self;
    }
//    else if (propZap == &zapRemove) {
//      propNil = &nilRemove;
//      propBlastText = &removeBlastText;
//      glob.curTransType = propZap;
//      glob.curTransObj = self;
//    }
    else {
      "ERROR: Illegal value for propZap! ";
      return;
    }
    // propZap, propBlastText, & propNil should be set up now,
    // as should glob.curTransType
    
    aryTextOff;
    if (self.(propZap)) {
      aryTextOn;
      self.(propBlastText); // show "<GRAAMN!>" or whatever.
      self.(propZap); // give behavior for propZap
    }
    else {
      aryTextOn; // allow propZap behavior
      self.(propBlastText); // show "<GRAAMN!>" or whatever.
      self.(propNil); // say "nothing happened."
    }
    aryTextOff;
    glob.curTransType = nil;
    glob.curTransObj = nil;
    //if (gKey() =='q') { local k=0;k=k/k; }
  }
  hitByAry() {
    aryTextOff;
    // If there are questions to be asked, then...
    if (askAry) {
      aryTextOn;
      // Ask the player the question(s). If the player gives the 
      // expected/desired answer, do Plan A. Otherwise do Plan B.
      if (askAry)
        handleBlast(&zapAry);
      else
        handleBlast(&zapAry2);
    }
    // If there are no questions to be asked, then do Plan A.
    else {
      handleBlast(&zapAry);
    }
    aryTextOff;
  }
  hitByT() {
    aryTextOff;
    // If there are questions to be asked, then...
    if (askT) {
      aryTextOn;
      // Ask the player the question(s). If the player gives the 
      // expected/desired answer, do Plan A. Otherwise do Plan B.
      if (askT)
        handleBlast(&zapT);
      else
        handleBlast(&zapT2);
    }
    // If there are no questions to be asked, then do Plan A.
    else {
      handleBlast(&zapT);
    }
    aryTextOff;
  }
  askAry  = nil
  zapAry  = nil
  zapAry2 = nil
  zapAryCq { }
  zapAry2Cq { }
  nilAry  = 
    "\^<<theWordName>> seem<<wordNameIsPlural ? '' : 's'>> unaffected. "
  askT    = nil
  zapT    = nil
  zapT2   = nil
  zapTCq { }
  zapT2Cq { }
  nilT    = 
    "\^<<theWordName>> seem<<wordNameIsPlural ? '' : 's'>> unaffected. "
//  askRemove  = nil
//  // Note that zapRemove does not, by default, equal nil.
//  zapRemove = disappear(
//    '{The dobj/he} disappear{s}! '
//  )
//  zapRemove2 = nil
//  zapRemoveCq { }
//  zapRemove2Cq { }
//  nilRemove = nilT
  aryBlastText() { }
  tBlastText() { }
  removeBlastText() { }
  //aryBlastText = "<.legend>&lt;GRAAAMN!&gt; A bolt of light 
  //  shoots out of the ary ung.<./legend> "
  //tBlastText = "You blast <<theWordName>> with the T-removing gun. "
  transformText(thing1) {
    //if (self == bathtub) { local k=0; k=k/k; }
    if (name && name != '')
      "\^<<thing1.theWordName>> 
        <<thing1.wordNameIsPlural ? 'are' : 'is'>> 
        transformed into 
        <<aWordName>>! ";
  }
  transformText2(thing1) {
    //if (self == bathtub) { local k=0; k=k/k; }
    if (name && name != '') {
      "<tr><td>";
      "\^<<thing1.theWordName>> </td><td>
        <<thing1.wordNameIsPlural ? 'are' : 'is'>> 
        transformed into 
        </td><td><<aWordName>>! ";
      "</td></tr>";
      }
  }
  wordName = (name) // a default that can be overridden
  wordNameForAchievement = (wordName) // a default that can be overridden
  aWordName {
    // say "transformed into bras", not "transformed into some bras"
    if (wordName == name && isPlural)
      return name;
    else if (wordName == name)
      return aName;
    else if (wordNameIsPlural)
      return wordName;
    else
      return aNameFrom(wordName);
  }
  theWordName = (theNameFrom(wordName))
  wordNameIsPlural = (isPlural)
  // We need to allow for consequences when removing things, too.
  
  
  
  
  // Deprecated stuff: These deprecated methods/properties are 
  // required by the old-fashioned FlyingThings until I fix them.
  // These deprecated properties are not required by more recent
  // extreme things like the FlowingInContainer and Wrappable objects.
  nameTransformFrom = ('\^' + theWordName)
  nameTransformInto = (aWordName)
  // End deprecated stuff
  
;

modify Thing
  transformUnsimulated(trName, [args]) {
    local trNameIsPlural;
    local useExclamationPoint;
    local finalPunctuation;
    
    if (args && args.length > 0)
      trNameIsPlural = args[1];
    else
      trNameIsPlural = nil;
    
    if (args && args.length > 1)
      useExclamationPoint = args[2];
    else
      useExclamationPoint = true;
    
    if (trName.substr(trName.length) == '>')
      finalPunctuation = ' ';
    else if (useExclamationPoint)
      finalPunctuation = '! ';
    else
      finalPunctuation = '. ';
    
    return 
      '\^' + theWordName + ' disappear' 
          + (wordNameIsPlural ? '' : 's') + '.
        <p>Then, suddenly, right beside you, there 
          appear' + (trNameIsPlural ? ' ' : 's ') + trName 
          //+ (useExclamationPoint ? '! ' : '. ')
          + finalPunctuation;
  }
  fallThroughFloorMsg {
    return
      '<p>You try to run away, but '
          + (gActor.getOutermostRoom == stairs
              ? 'the stairs breaks open beneath you'
              : 'the floor breaks open beneath you')
          + ', and you plummet downward
          for several terrifying seconds.
        <p>Your terror comes to an abrupt end as you hit the floor,
          and your head strikes against concrete. ';
  }
  floorCollapseMsg(pluralFlag) {
    if (gActor.getOutermostRoom == stairs)
      return 'the stairs groan and strain beneath '
        + (pluralFlag ? 'their' : 'its')
        + ' weight, and finally collapse. ';
    else
      return 'the floor groans and strains beneath '
        + (pluralFlag ? 'their' : 'its')
        + ' weight, and finally collapses. ';
  }
;


// -------------------------------------------------------------------
// DEBUGGING STUFF
// -------------------------------------------------------------------

//modify oatCracker        location=northRoom;
//modify oaCracker         location=northRoom;
//modify lemon             location=northRoom;
//modify melon             location=northRoom;
//modify friedEgg          location=northRoom;
//modify iceCreamBar       location=northRoom;
//modify milkChocolate     location=northRoom;
//modify torte             location=northRoom;
//modify carrotCake        location=northRoom;
//modify carroCake         location=northRoom;
//modify mutton            location=northRoom;
//modify steak             location=northRoom;
//modify taco              location=northRoom;
//modify roastBeefSandwich location=northRoom;
//modify roasBeefSandwich  location=northRoom;
//modify brats             location=northRoom;
//modify bras              location=northRoom;
////modify bars              location=northRoom;
//
//modify ceramicBear location=northRoom;
//modify tiedPipes   location=northRoom;
//modify ore         location=northRoom;
//modify stake       location=northRoom;

//modify beets          location=northRoom;
//modify bakedBeans     location=northRoom;
//modify chocolateSyrup location=northRoom;
//modify chocolaeSyrup  location=northRoom;

//modify coat         location=northRoom;
//modify milkChocolae location=northRoom;
//modify seak         location=northRoom;
//modify aco          location=northRoom;
//modify coa          location=northRoom;


