#!/usr/bin/perl -w

# Usage: nk2inf.pl foobar.nki > nki.inf

# The Z-machine wants all of a program's data to be in the executable 
# file.  For the Inform edition of robotfindskitten, nki's are generated 
# by a very long case statement.  This script emits that case statement 
# and a constant defining MESSAGE_NUM to the number of NKIs found.  The 
# result is then added to kitten.inf with an Include statement.
#
# This script automatically takes care of '`', '\', and '@' by replacing 
# them with '@@126', '@@92', and '@@64' respectively.

foreach my $infile (@ARGV) {
	if (! -r $infile) { die "$0: Unable to read $infile\n"; }
}

my $count = 0;
my $line;

if (!$ARGV[0]) { die "Usage: $0 <files> > nki.inf\n"; }


print "! The following code was automatically generated by nki2inf.pl\n";
print "! Do not edit this file.\n";
print "! Instead, edit your raw NKI list and run nki2inf.pl again.\n";
print "!\n";
print "! Because you can't directly use double quotes, backslashes,\n";
print "! tildes, or atsigns in Inform, the following substitutions\n";
print "! are used to generate those characters:\n";
print "!    \"  -->   ~\n";
print "!    ~  --> \@\@126\n";
print "!    \\  --> \@\@92\n";
print "!    \@  --> \@\@64\n\n";

print "[ lookup_msg num;\n";
print "\tswitch(num) {\n";

foreach my $infile (@ARGV) {
	open (INFILE, "< $infile") || die "$0: Cannot open $infile\n";

	while (<INFILE>) {
		$count++;
		next if /^\s*($|#|!)/;
		chomp;
		$line = $_;
		$line =~ s/"/~/g;
		$line =~ s/@/\@\@64/g;
		$line =~ s/\\/\@\@92/g;
		print "$count:\treturn \"$line\";\n";
	}
}
print "default: return \"Unknown NKI (this should not happen)\";\n\t}\n];\n";
print "Constant MESSAGE_NUM $count;\n";
close (INFILE);
