//---------------------------------------------------------------------------

#include <vcl.h>
#include <jpeg.hpp>
#pragma hdrstop

#include "story.h"
#include "globals.h"
#include "pngimage.hpp"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TStoryForm *StoryForm;

//---------------------------------------------------------------------------
__fastcall TStoryForm::TStoryForm(TComponent* Owner)
  : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void TStoryForm::clear_metadata()
{
metadata.id.ifid="";
metadata.id.format="";
metadata.id.bafn=0;
metadata.bib.title="";
metadata.bib.author="";
metadata.bib.language="";
metadata.bib.headline="";
metadata.bib.firstpublished="";
metadata.bib.genre="";
metadata.bib.group="";
metadata.bib.description="";
metadata.bib.series="";
metadata.bib.seriesnumber=0;
metadata.bib.forgiveness="";
MainForm->StoryMenu->Enabled=false;
};
//---------------------------------------------------------------------------
void TStoryForm::load_metadata(_di_IXMLDocument xml)
{
_di_IXMLNode story_xml=xml->DocumentElement->ChildNodes->Nodes[WideString("story")];
if (story_xml->HasChildNodes){
  _di_IXMLNode node=story_xml->ChildNodes->Nodes[WideString("identification")];
  if (node->HasChildNodes){
    metadata.id.ifid=node->ChildNodes->Nodes[WideString("ifid")]->Text;
    metadata.id.format=node->ChildNodes->Nodes[WideString("format")]->Text;
    if (node->ChildNodes->Nodes[WideString("bafn")]->Text.Length())
      metadata.id.bafn=StrToInt(node->ChildNodes->Nodes[WideString("bafn")]->Text);};
  node=story_xml->ChildNodes->Nodes[WideString("bibliographic")];
  if (node->HasChildNodes){
    metadata.bib.title=node->ChildNodes->Nodes[WideString("title")]->Text;
    metadata.bib.author=node->ChildNodes->Nodes[WideString("author")]->Text;
    if (metadata.bib.author.Length()>50){
      metadata.bib.author.SetLength(50);
      metadata.bib.author+="...";};
    metadata.bib.language=node->ChildNodes->Nodes[WideString("language")]->Text;
    metadata.bib.headline=node->ChildNodes->Nodes[WideString("headline")]->Text;
    metadata.bib.firstpublished=node->ChildNodes->Nodes[WideString("firstpublished")]->Text;
    metadata.bib.genre=node->ChildNodes->Nodes[WideString("genre")]->Text;
    metadata.bib.group=node->ChildNodes->Nodes[WideString("group")]->Text;
    for (int i=0;i<node->ChildNodes->Nodes[WideString("description")]->ChildNodes->Count;i++){
      metadata.bib.description+=node->ChildNodes->Nodes[WideString("description")]->ChildNodes->Nodes[i]->Text;
      metadata.bib.description+="\n";};
    while (int pos=metadata.bib.description.Pos("\t"))
      metadata.bib.description.Delete(pos,1);
    while (int pos=metadata.bib.description.Pos("\n\n\n"))
      metadata.bib.description.Delete(pos,1);
    metadata.bib.series=node->ChildNodes->Nodes[WideString("series")]->Text;
    if (node->ChildNodes->Nodes[WideString("seriesnumber")]->Text.Length())
      metadata.bib.seriesnumber=StrToInt(node->ChildNodes->Nodes[WideString("seriesnumber")]->Text);
    metadata.bib.forgiveness=node->ChildNodes->Nodes[WideString("forgiveness")]->Text;
    MainForm->StoryMenu->Enabled=true;
    MainForm->Caption=metadata.bib.title;};};
};
//----------------------------------------------------------------------------

void TStoryForm::show_form(TFileStream *story_file)
{
if (!Visible&&metadata.bib.title!=""){

  TitleLabel->Caption=metadata.bib.title;
  TitleLabel->Caption=TitleLabel->Caption+"\nby\n";

  TitleLabel->Caption=TitleLabel->Caption+metadata.bib.author;
  TitleLabel->Left=245-(TitleLabel->Width/2);

  if (metadata.bib.headline!="")
    HeadlineLabel->Caption=metadata.bib.headline;
  else
    HeadlineLabel->Caption="An Interactive Fiction";

  if (metadata.bib.language!="")
    DetailLabel->Caption=("Language: "+metadata.bib.language);
  if (metadata.bib.firstpublished!="")
    DetailLabel->Caption=(DetailLabel->Caption+"\nYear: "+metadata.bib.firstpublished);
  if (metadata.bib.genre!="")
    DetailLabel->Caption=(DetailLabel->Caption+"\nGenre: "+metadata.bib.genre);
  if (metadata.bib.group!="")
    DetailLabel->Caption=(DetailLabel->Caption+"\nGroup: "+metadata.bib.group);
  if (metadata.bib.series!="")
    DetailLabel->Caption=(DetailLabel->Caption+"\nSeries: "+metadata.bib.series);
  if (metadata.bib.seriesnumber!=0)
    DetailLabel->Caption=(DetailLabel->Caption+"\n(#"+metadata.bib.seriesnumber+" in the series)");
  if (metadata.bib.forgiveness!="")
    DetailLabel->Caption=(DetailLabel->Caption+"\nForgiveness: "+metadata.bib.forgiveness);

  DesBevel->Top=DetailLabel->Top+DetailLabel->Height+5;
  DesLabel->Top=DesBevel->Top+10;
  DesLabel->Width=485;
  DesLabel->Caption=metadata.bib.description;

  ClientHeight=DesLabel->Top+DesLabel->Height;
  if (Height>Screen->Height)
    Height=Screen->Height;
  CoverImage->Height=ClientHeight;

  Visible=true;

  unsigned int pic_id=0;

  story_file->Position=4;
  unsigned int file_size=restore_long(story_file)+8;
  if (seek_chunk("Fspc",file_size,story_file)){
    story_file->Position+=4;
    pic_id=restore_long(story_file);};

  if (pic_id){
    Width=750;
    Left=(Screen->Width/2)-(Width/2);
    Top=(Screen->Height/2)-(Height/2);
    CoverImage->Visible=true;
    int pic_type=find_resource(PICT,pic_id,story_file);
    if (pic_type==JPEG){
      TJPEGImage *picture=new TJPEGImage();
      picture->LoadFromStream(story_file);
      CoverImage->Picture->Assign(picture);
      delete picture;
      return;};
    if (pic_type==PNG){
      TPNGObject *picture=new TPNGObject();
      picture->LoadFromStream(story_file);
      CoverImage->Picture->Assign(picture);
      delete picture;
      return;};};


  Width=500;
  Left=(Screen->Width/2)-(Width/2);
  Top=(Screen->Height/2)-(Height/2);
  CoverImage->Visible=false;};
};
