/* property.c
 *
 *  foblub -- a Z-machine for TI calculators
 *  based on pinfocom by InfoTaskForce and Paul Smith
 *  Ported and extended by Nils Gesbert, 2003
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; see the file COPYING.  If not, write to the
 *  Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include    "infocom.h"

#define numero_prop(_prop) (*(_prop) & (ENHANCED ? 63 : 31))
#define mot_ou_octet(_prop) (*(_prop) & (ENHANCED ? 64 : 32))

#define _AT __attribute__ ((pure))

static _AT property
prop_addr A1(word, obj)
{
    property        p;

    p = base_ptr + Z_TO_WORD(data(obj));
    return (p + (Z_TO_BYTE(p) << 1) + 1);
}

static _AT word offset_to_next_addr (property p)
{
  if (STANDARD) return ((*p >> 5) + 2);
  else if (*p & 128) {
    word w = p[1] & 63; return (2 + (w ? w : 64));
  }
  else return ((*p & 64) ? 3 : 2);
}

/* Attention ceci renvoie true si on ne trouve PAS la proprit... */
static _AT Bool find_prop (word obj_num, word prop_num, property *p) {
  word p_num;
  for (*p = prop_addr (obj_num);
       (p_num = numero_prop (*p)) > prop_num;
       *p += offset_to_next_addr (*p));
  return (p_num < prop_num);
}

inline void
next_prop A2(word, obj_num, word, prop_num)
{
#ifdef DEBUG2
  if (tracing) {
    char buf[50];
    sprintf (buf, "next_prop ($%02x,$%02x)", obj_num, prop_num);
    scr_putline (buf);
  }
#endif
  property p = prop_addr (obj_num);
  word p_num;

  if (prop_num != 0) do
    if ((p_num = numero_prop (p)) < prop_num)
      error("prop: Error retrieving next property ($%02x)", prop_num);      
    else p+= offset_to_next_addr(p);
  while (p_num > prop_num);
  
  store((word)numero_prop (p));

#ifdef DEBUG2
  if (tracing) {
    char buf[50];
    sprintf (buf, "rsultat : $%02x", numero_prop(p));
    scr_putline (buf);
  }
#endif
}

inline void
put_prop A3(word, obj_num, word, prop_num, word, value)
{
    property  p;

    if (find_prop (obj_num, prop_num, &p))
        error("prop: Error storing property ($%02x)", prop_num);
    else
    {
        if (mot_ou_octet (p++))
        {
            *p++ = value >> 8;
            *p = value;
        }
        else
            *p = value;
    }
}

inline void
get_prop A2(word, obj_num, word, prop_num)
{
    property p;
    word prop;

    if (find_prop (obj_num, prop_num, &p))
    {
        prop_num = (prop_num - 1) << 1;
        p = (property) objd_obj_base + prop_num;
        prop = Z_TO_WORD(p);
    }
    else
    {
        if (mot_ou_octet (p++))
            prop = Z_TO_WORD(p);
        else
            prop = Z_TO_BYTE(p);
    }
    store(prop);
}

inline void
get_prop_addr A2(word, obj_num, word, prop_num)
{
    property        p;
    if (find_prop (obj_num, prop_num, &p))
        store(0);
    else
        store((word)(p + ((ENHANCED && (*p & 128)) ? 2 : 1) - base_ptr));
}

inline void
get_prop_len A1(word, prop_addr)
{
    property        p;

    p = base_ptr + prop_addr - 1;
    if (STANDARD)
      store((word)((Z_TO_BYTE(p) >> 5) + 1));
    else if (*p & 128)
      {word w = *p & 63; store (w ? w : 64);}
    else store ((*p & 64) ? 2 : 1);
}

inline void
load_word_array A2(word, base, word, offset)
{
    store(get_word(base + (offset << 1)));
}

inline void
load_byte_array A2(word, base, word, offset)
{
  store((word)get_byte(base + offset));
}

inline void
save_word_array A3(word, base, word, offset, word, value)
{
    byte            *ptr;

    base += (offset << 1);
    ptr = base_ptr + base;
    (*ptr++) = value >> 8;
    *ptr = value;
}

inline void
save_byte_array A3(word, base, word, offset, word, value)
{
    byte            *ptr;

    base += offset;
    ptr = base_ptr + base;
    *ptr = value;
}

#undef _AT
