// ----------------------------------------------------------------------------
// DS Frotz
// ----------------------------------------------------------------------------
// data.c : 	game data and menu description
// ----------------------------------------------------------------------------
// description	:	DS version of GBA Frotz 
//					made with PAlib - www.palib.com -
//
// ----------------------------------------------------------------------------
// (c) 2006 papafuji - using PAlib
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
// PAlib include files
// ----------------------------------------------------------------------------

#include <PA9.h>

// ----------------------------------------------------------------------------
// DS Frotz include files
// ----------------------------------------------------------------------------

#include "main.h"
#include "draw.h"

// ----------------------------------------------------------------------------
// graphic include files
// ----------------------------------------------------------------------------

#include "gfx/all_gfx.h"

// ----------------------------------------------------------------------------
// include adventure data headers
// ----------------------------------------------------------------------------

#include "minizork.h"
#include "toyshop.h"
#include "freefall.h"

// ----------------------------------------------------------------------------
// some externals functions
// ----------------------------------------------------------------------------

extern void 	StartRainbow	( void );
extern void 	PlayRainbow		( void );
extern void 	EndRainbow		( void );

// ----------------------------------------------------------------------------
// global variables
// ----------------------------------------------------------------------------
// gNbMenuPages : 	number of pages in the main menu
// 					generally, gNbMenuPages = nbGames + 2
// ----------------------------------------------------------------------------

int		gNbMenuPages		= 5;		

// ----------------------------------------------------------------------------
// LoadBackgroundImageFromIndex : 
// 		load the image of the TOP screen for each
// 		page of the menu (including the FUJIforce logo)
// ----------------------------------------------------------------------------

bool LoadBackgroundImageFromIndex( int _index )
{
	switch( _index )
	{
	case  0 : StartRainbow();															return true;
	case  1 : EndRainbow(); PA_LoadTiledBg( TOP_SCREEN, TILED_BG_INDEX, title		); 	return true;
	case  2 : EndRainbow(); PA_LoadTiledBg( TOP_SCREEN, TILED_BG_INDEX, minizork	); 	return true;
	case  3 : EndRainbow(); PA_LoadTiledBg( TOP_SCREEN, TILED_BG_INDEX, toyshop	); 	return true;
	case  4 : EndRainbow(); PA_LoadTiledBg( TOP_SCREEN, TILED_BG_INDEX, freefall	); 	return true;
	}
	return false;
}

// ----------------------------------------------------------------------------
// gAdventureDescriptions : the game data table
//	 	there is an AdventureDesc for each page in the presentation screen
// 		(including the main page and the credits page with the FUJIforce logo)
// ----------------------------------------------------------------------------

AdventureDesc	gAdventureDescriptions[] =
{
	// the data for the FUJIforce logo
	{
		"",
		"- a FUJIforce production -",
		"",
		"",
		"",
		"\
    - NDS version : papafuji 2007 -\n\n\
   - dev tools : PAlib & DevKitPro -\n\n\
- libFAT & DLDI : Chism/DrunkenCoders -\n\n\n\
     - game engine : GBA Frotz -\n\n\
        - by Thomas Minnberg -\n\n\
          - based on Frotz -\n\n\
 - by Stefan Jokisch & Jim Dunleavy -\n",
		NULL,
		NULL,
		0
	}
	,
	// the data for the main page
	{
		"",
		"- DS-Frotz demo -",
		"",
		"",
		"",
		"\
    - NDS version : papafuji 2007 -\n\n\
   - dev tools : PAlib & DevKitPro -\n\n\
- libFAT & DLDI : Chism/DrunkenCoders -\n\n\n\
     - game engine : GBA Frotz -\n\n\
        - by Thomas Minnberg -\n\n\
          - based on Frotz -\n\n\
 - by Stefan Jokisch & Jim Dunleavy -\n",
		NULL,
		NULL,
		0
	}
	,
	// the data for the 1st game
	{
		"- DS Frotz samples #1 -",
		"- Mini Zork -",
		"anonymous",
		"- (c) Infocom - 1988 -",
		"",
		"    This is a free demo of Zork I. Although substantially smaller than the full game, \
it contains all the memorable bits - kind of like a Reader's Digest Condensed Zork. \
See Dungeon for a larger dose and more commentary.\n\n\
Rating : ***",
		"MiniZork",
		(void*)minizork,
		(int)minizork_size
	}
	,
	// the data for the 2nd game
	{
		"- DS Frotz samples #2 -",
		"- The Magic Toyshop -",
		"by Gareth Rees",
		"- 1995 -",
		"",
		"    A one-room puzzle feast. No plot to speak of, a modicum of atmosphere, one interesting \
character: Catharine, the toyshop's owner's daughter. She plays nine games with you, some traditional, \
some based on puzzles from other adventure games, a few requiring bending of the rules. Contains references \
to Trinity and Curses!, but the only puzzle that requires knowledge of either is optional. The final \
puzzle is very hard unless you're familiar with the works of Raymond Smullyan. Has an in-plot hint system \
(ask Catharine for help). Contains good examples of how to include board games in a text adventure.\n\n\
Rating : ****\n\n\
Awards:	[33]rec.arts.IF comp.\n\
        19953rd place, Inform\n\n\
Source: Baf's Guide to the IF Archive\n\
        http://www.wurb.com/if",
		"MagicToyShop",
		(void*)toyshop,
		(int)toyshop_size
	}
	// the data for the 3rd game
	,
	{
		"- DS Frotz samples #3 -",
		"- Freefall -",
		"by Andrew Plotkin",
		"- 1995 -",
		"",
		"    An amazing Tetris clone with the Inform engine...",
		"Freefall",
		(void*)freefall,
		(int)freefall_size
	}
};

// ----------------------------------------------------------------------------
// (c) 2006 papafuji - using PAlib
// ----------------------------------------------------------------------------
