// ----------------------------------------------------------------------------
// DS Frotz
// 	
// description	:	DS version of GBA Frotz 
//					made with PAlib - www.palib.com -
//
// ----------------------------------------------------------------------------
// (c) 2006 papafuji - using PAlib
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
// PAlib includes
// ----------------------------------------------------------------------------

#include <PA9.h>
#include <stdio.h> 

// ----------------------------------------------------------------------------
// project includes
// ----------------------------------------------------------------------------

#include "main.h"
#include "draw.h"
#include "sound.h"

// ----------------------------------------------------------------------------
// sound Includes
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
// backgrounds and sprites Includes
// ----------------------------------------------------------------------------

#include "gfx/all_gfx.c"

// ----------------------------------------------------------------------------
// structures
// ----------------------------------------------------------------------------

typedef struct XFSprite
{
	void	*data;
	int		x;
	int 	y;
	int 	frame;
	char*	action1;
	char*	action2;
	char*	action3;
	char*	action4;
} XFSprite;

// ----------------------------------------------------------------------------
// local variables
// ----------------------------------------------------------------------------

char 			theMessage[1024] 	= "";
char 			fatalMessage[1024]	= "";
char 			theOrder[1024]		= "";
int				refreshFlags 		= REFRESH_TOP_SCREEN + REFRESH_BOTTOM_SCREEN;
bool 			deleteTopBG 		= false;
int 			nbSprites 			= 0;
int				graphicMode 		= TEXT_ADVENTURE;
int 			imagesWidth			= 160;
int 			imagesHeight		= 96;

XFSprite		sprites[] = 		{

										{ (void*)empty_Sprite, 		109, 0, 0, 		"GO NORTH"	, "GO UP" ,		"",			"" 		},
										{ (void*)empty_Sprite, 		112, 160, 0, 	"GO SOUTH"	, "GO DOWN" ,	"",			"" 		},
										{ (void*)empty_Sprite, 		0, 80, 0, 		"GO WEST"	, "ENTER " ,	"",			"" 		},
										{ (void*)empty_Sprite, 		224, 80, 0, 	"GO EAST"	, "EXIT " ,		"",			"" 		},
										{ (void*)ok_Sprite, 		224, 160, 0,	"OK"		, "OK",			"",			"" 		},
										
										{ (void*)get_Sprite, 		0, 32, 0, 		"GET "		, "DROP ",		"GIVE ",	"" 		},
										{ (void*)throw_Sprite, 		0, 0, 0, 		"THROW "	, "CAST ",		"",			"" 		},
										{ (void*)wear_Sprite, 		32, 0, 0, 		"WEAR "		, "REMOVE ",	"",			"" 		},

										{ (void*)say_Sprite, 		192, 0, 0, 		"SAY "		, "SHOUT ",		"",			"" 		},
										{ (void*)go_Sprite,			224, 0, 0, 		"GO " 		, "SWIM ",		"CLIMB ",	"" 		},
										{ (void*)look_Sprite, 		224, 32, 0, 	"LOOK " 	, "LOOK AT ", 	"READ ",	"EXAMINE " 		},

										{ (void*)unlock_Sprite, 	0, 128, 0, 		"OPEN "		, "UNLOCK "	, 	"CLOSE " ,	"",		},
										{ (void*)break_Sprite,		0, 160, 0, 		"DIG " 		, "BREAK ",		"CHOP ",	"" 		},
										{ (void*)kill_Sprite,		32, 160, 0, 	"KILL " 	, "SHOOT ",		"KICK ",	"" 		},
										{ (void*)NULL, 				0, 	0, 	0, 		""			, ""		,	""		,	""		}
									};

// ----------------------------------------------------------------------------
// 
// ----------------------------------------------------------------------------

void SetFatalMessage( char* _message )
{
	strcpy( fatalMessage, _message ? _message : "" );
	SetRefreshFlag( REFRESH_BOTTOM_SCREEN );
}

void SetMessage( char* _message )
{
	strcpy( theMessage, _message ? _message : "" );
	SetRefreshFlag( REFRESH_BOTTOM_SCREEN );
}

void SetOrder( char* _order, int _flushRefresh )
{
	strcpy( theOrder, _order ? _order : "" );
	SetRefreshFlag( REFRESH_BOTTOM_SCREEN );
	if ( _flushRefresh  )
	{
		RefreshScreens( 0 );
	}
}

void SetRefreshFlag( int _flags )
{
	refreshFlags |= _flags;
}

void SetGraphicMode( int _mode )
{
	graphicMode = _mode;
}

// ----------------------------------------------------------------------------
// 
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
// 
// ----------------------------------------------------------------------------

void InitSprites( void )
{
	nbSprites = 0;

	PA_LoadSpritePal( BOTTOM_SCREEN, 0, (void*)sprites_Pal );

	while( sprites[nbSprites].data )
	{
		PA_CreateSprite	( BOTTOM_SCREEN, nbSprites, (void*)sprites[nbSprites].data, OBJ_SIZE_32X32, 1, 0, -32, -32 );
		nbSprites ++;
	}
}

// ----------------------------------------------------------------------------
// 
// ----------------------------------------------------------------------------

void HideSprites( void )
{	
	int i;

	for ( i=0; i<nbSprites; i++ )
	{
		PA_SetSpriteXY	( BOTTOM_SCREEN, i, -100, -100 );
	}
}

// ----------------------------------------------------------------------------
// 
// ----------------------------------------------------------------------------

void ShowSprites( void )
{	
	int i;

	for ( i=0; i<nbSprites; i++ )
	{
		PA_SetSpriteXY	( BOTTOM_SCREEN, i, sprites[i].x, sprites[i].y );
	}
}

// ----------------------------------------------------------------------------
//  INIT  SCREENS AND COLOR
/*
		default DOS colors for text drawing
		
	30 	Black foreground
	31 	Red foreground
	32 	Green foreground
	33 	Yellow foreground
	34 	Blue foreground
	35 	Magenta foreground
	36 	Cyan foreground
	37 	White foreground
*/
// ----------------------------------------------------------------------------

void InitScreens( void )
{
	int	i;
	
	PA_Init8bitBg	( TOP_SCREEN, DRAWING_BG_INDEX );

	PA_SetBgPalCol	( TOP_SCREEN, DRAWING_BG_INDEX, PA_RGB( 12, 12, 13 ) );
	for( i=1; i<32; i++ )
	{
		int r = (i==31)?i:(i-1);
		int g = (i==31)?i:(i-1);
		int b = i;
		PA_SetBgPalCol	( TOP_SCREEN, i, PA_RGB(r,g,b) );
	}
	PA_SetBgPalCol	( TOP_SCREEN, 32, PA_RGB(27,27,19) );		// light yellow
	PA_SetBgPalCol	( TOP_SCREEN, 33, PA_RGB(27,19,19) );		// light red

	//frotz colors

	PA_SetBgPalCol	( TOP_SCREEN, TEXT_RED_COLORID, 	PA_RGB(0,0,0) );		//0xFF,0x00,0x00  (black)
	PA_SetBgPalCol	( TOP_SCREEN, TEXT_RED_COLORID, 	PA_RGB(21,15,15) );		//0xFF,0x00,0x00  (red)
	PA_SetBgPalCol	( TOP_SCREEN, TEXT_GREEN_COLORID,	PA_RGB(15,21,15) );		//0x30,0xE8,0x30  (green)
	PA_SetBgPalCol	( TOP_SCREEN, TEXT_YELLOW_COLORID,	PA_RGB(21,21,15) );		//0xFF,0xFF,0x00  (yellow)
	PA_SetBgPalCol	( TOP_SCREEN, TEXT_BLUE_COLORID, 	PA_RGB(15,15,21) );		//0x00,0x00,0xFF  (blue)
	PA_SetBgPalCol	( TOP_SCREEN, TEXT_MAGENTA_COLORID, PA_RGB(21,15,21) );		//0xA0,0x68,0x00  (brown)
	PA_SetBgPalCol	( TOP_SCREEN, TEXT_CYAN_COLORID, 	PA_RGB(15,21,21) );		//0x00,0xFF,0xFF  (cyan)
	PA_SetBgPalCol	( TOP_SCREEN, TEXT_WHITE_COLORID, 	PA_RGB(21,21,21) );		//0xFF,0xFF,0xFF  (white)
	PA_SetBgPalCol	( TOP_SCREEN, TEXT_LIGHTGREY_COLORID, 	PA_RGB(15,15,15) );		// amiga compatibility
	PA_SetBgPalCol	( TOP_SCREEN, TEXT_MEDIUMGREY_COLORID,	PA_RGB(11,11,11) );		// amiga compatibility
	PA_SetBgPalCol	( TOP_SCREEN, TEXT_DARKGREY_COLORID, 	PA_RGB(7,7,7) );		// amiga compatibility
	
		// bold frotz colors
    
	PA_SetBgPalCol	( TOP_SCREEN, BOLD_BLACK_COLORID, 	PA_RGB(0,0,0) );		//0xFF,0x00,0x00  (black)
	PA_SetBgPalCol	( TOP_SCREEN, BOLD_RED_COLORID, 	PA_RGB(27,8,8) );		//0xFF,0x00,0x00  (red)
	PA_SetBgPalCol	( TOP_SCREEN, BOLD_GREEN_COLORID,	PA_RGB(8,27,8) );		//0x30,0xE8,0x30  (green)
	PA_SetBgPalCol	( TOP_SCREEN, BOLD_YELLOW_COLORID,	PA_RGB(27,27,8) );		//0xFF,0xFF,0x00  (yellow)
	PA_SetBgPalCol	( TOP_SCREEN, BOLD_BLUE_COLORID, 	PA_RGB(8,8,27) );		//0x00,0x00,0xFF  (blue)
	PA_SetBgPalCol	( TOP_SCREEN, BOLD_MAGENTA_COLORID, PA_RGB(27,27,8) );		//0xA0,0x68,0x00  (brown)
	PA_SetBgPalCol	( TOP_SCREEN, BOLD_CYAN_COLORID, 	PA_RGB(8,27,27) );		//0x00,0xFF,0xFF  (cyan)
	PA_SetBgPalCol	( TOP_SCREEN, BOLD_WHITE_COLORID, 	PA_RGB(31,31,31) );		//0xFF,0xFF,0xFF  (white

	PA_SetBgPalCol	( TOP_SCREEN, NEW_BACKGROUND_COLOR, 	PA_RGB(29,27,16) );	//0xFF,0xFF,0xFF  (white
	PA_SetBgPalCol	( TOP_SCREEN, NEW_TEXT_COLOR, 			PA_RGB(8,7,0) );			//0xFF,0xFF,0xFF  (white

 
	// Init the BOTTOM SCREEN

	PA_Init8bitBg	( BOTTOM_SCREEN, DRAWING_BG_INDEX );
	PA_SetBgPalCol	( BOTTOM_SCREEN, DRAWING_BG_INDEX, PA_RGB(BOTTOM_BACKGROUND_COLOR-1,BOTTOM_BACKGROUND_COLOR-1, BOTTOM_BACKGROUND_COLOR ) );
	for( i=1; i<32; i++ )
	{
		int r = (i==31)?i:(i-1);
		int g = (i==31)?i:(i-1);
		int b = i;
		PA_SetBgPalCol	( BOTTOM_SCREEN, i, PA_RGB(r,g,b) );
	}
	PA_SetBgPalCol	( BOTTOM_SCREEN, 32, PA_RGB(31,0,0) );		// 32 = red
	PA_SetBgPalCol	( BOTTOM_SCREEN, 33, PA_RGB(31,31,18) );	// 33 = yellow
	
	InitSprites();
}

// ----------------------------------------------------------------------------
//
// ----------------------------------------------------------------------------

void InitGFX( void )
{
	gInputMode 		= INPUT_MODE_GRAFITI;
	refreshFlags 	= REFRESH_TOP_SCREEN + REFRESH_BOTTOM_SCREEN;
	deleteTopBG 	= false;

	PA_LoadTiledBg( BOTTOM_SCREEN, TILED_BG_INDEX, bottom );
	
	ShowSprites();
	
//	GetPictureSize( &imagesWidth, &imagesHeight );
}

// ----------------------------------------------------------------------------
// 
// ----------------------------------------------------------------------------

void FILL_SCREEN( int screen, int color )
{
	u16 col = color  + (color<<8);
	int	n	= 128*192;
	
	while( n-- ) { PA_DrawBg[screen][n] = col; }
}

// ----------------------------------------------------------------------------
// 
// ----------------------------------------------------------------------------

void DRAW_RECT( int screen, int _x0, int _y0, int _x1, int _y1, int color )
{
	if (_y0<0) 		_y0 = 0; 	else if (_y0>191) return;
	if (_y1>191)	_y1 = 191; 	else if (_y1<0) return;

	int 	x0 				= (_x0/2)*2; 		if (x0<0) x0=0; 	else if (x0>255) return;
	int 	x1				= ((_x1/2)*2)+1;	if (x1<0) return;	else if (x1>255) x1=255;
	int 	y;
	u16 	col16 			= color  + (color<<8);
	
	for( y=_y0; y<=_y1; y++ )
	{
		int		n				= (x1-x0+1)/2;
		u16*	adr				= PA_DrawBg[screen] + ((y<<7)+(x0>>1));
		
		while( n-- ) 	{ adr[n] = col16; } 
		
		if ( (_x0%2)==1) { PA_Put8bitPixel( screen, _x0, y, color ); }
		if ( (_x1%2)==0) { PA_Put8bitPixel( screen, _x1, y, color ); }
	}
}

void DRAW_HLINE( int screen, int _x0, int _x1, int y, int color )
{
	if ( y<0 || y>191) return;

	int 	x0 			= (_x0/2)*2; 		if (x0<0) x0=0; 	else if (x0>255) return;
	int 	x1			= ((_x1/2)*2)+1;	if (x1<0) return;	else if (x1>255) x1=255;

	u16 	col16 		= color  + (color<<8);
	int		n			= (x1-x0+1)/2;
	u16*	adr			= PA_DrawBg[screen] + ((y<<7)+(x0>>1));
		
	while( n-- )		{ adr[n] = col16; } 

	if ( (_x0%2)==1) 	{ PA_Put8bitPixel( screen, _x0, y, color ); }
	if ( (_x1%2)==0) 	{ PA_Put8bitPixel( screen, _x1, y, color ); }
}

void DRAW_VLINE( int screen, int x, int y0, int y1, int color )
{
	int y;
	for( y=y0; y<=y1; y++ )
	{
		//PUT_PIXEL( screen, x, y, color );
		PA_Put8bitPixel( screen, x, y, color );
	}
}

void DARKEN_IMAGE( int _screen, int _bg_number )
{
	u16*		palette;
	int			i;
	int			pal_number = 0;
	
	if ( _screen == BOTTOM_SCREEN )
	{
		vramSetBankE(VRAM_E_LCD);  // On passe en mode LCD pour pouvoir ecrire dessus, on reviendre en palette apres
		palette = (u16*)(VRAM_E + (_bg_number << 12) + (pal_number << 8));
	}
	else {
		vramSetBankH(VRAM_H_LCD);  // On passe en mode LCD pour pouvoir ecrire dessus, on reviendre en palette apres
		palette = (u16*)(VRAM_H + (_bg_number << 12) + (pal_number << 8));
	}
	
	for( i=0; i<256; i++, palette ++ )
	{
		u16		col = *palette;
		u16 	r 	= col & 31;
		u16 	g 	= (col>>5) & 31;
		u16 	b 	= (col>>10) & 31;
		r 			/= 7;
		g 			/= 7;
		b 			/= 7;
		*palette 	= PA_RGB(r,g,b);
	}

	if ( _screen == BOTTOM_SCREEN )
	{
		vramSetBankE(VRAM_E_BG_EXT_PALETTE);
	}
	else
	{
		vramSetBankH(VRAM_H_SUB_BG_EXT_PALETTE);
	}
}

// ----------------------------------------------------------------------------
// 
// ----------------------------------------------------------------------------

int PickSprite( int _x, int _y )
{
	int		i;
	int 	pickedSprite 	= -1;
	bool 	ok				= true;
	
	for ( i=0; i<nbSprites; i++ )
	{
		if ( _x > sprites[i].x+4 && _x < sprites[i].x+28 && _y > sprites[i].y+4 && _y < sprites[i].y+28 )
		{
			pickedSprite = i; break;
		}
	}

	if ( pickedSprite < 0 )
		return -1;
	
	SoundPlay( SOUND_CLICK );
	PA_SetSpriteAnim( BOTTOM_SCREEN, pickedSprite, 1 );	
	PA_WaitForVBL();
	
	while( Stylus.Held )
	{ 
		if ( 	Stylus.X > sprites[pickedSprite].x+4 && Stylus.X < sprites[pickedSprite].x+28 && 
				Stylus.Y > sprites[pickedSprite].y+4 && Stylus.Y < sprites[pickedSprite].y+28 )
		{
			PA_SetSpriteAnim( BOTTOM_SCREEN, pickedSprite, 1 );	
			PA_WaitForVBL();
			ok = true;
		}
		else
		{
			PA_SetSpriteAnim( BOTTOM_SCREEN, pickedSprite, 0 );	
			PA_WaitForVBL();
			ok = false;
		}
		
	}
  
	PA_SetSpriteAnim( BOTTOM_SCREEN, pickedSprite, 0 );	

	if ( ok )
	{
		return pickedSprite;
	}

	return -1;
}

// ----------------------------------------------------------------------------
// 
// ----------------------------------------------------------------------------

char* GetSpriteText( int _i )
{
	if ( _i < 0 ) return "";

	if ( !strcmp( theOrder, sprites[_i].action1 ) && sprites[_i].action2[0] )	return sprites[_i].action2;
	if ( !strcmp( theOrder, sprites[_i].action2 ) && sprites[_i].action3[0] )	return sprites[_i].action3;
	if ( !strcmp( theOrder, sprites[_i].action3 ) && sprites[_i].action4[0] )	return sprites[_i].action4;

	return sprites[_i].action1;
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// 
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

bool DrawTopBG( int _roomIndex )
{
#if 0
#if GRAPHIC_ADVENTURE
	//PA_Clear8bitBg( TOP_SCREEN );

	if ( deleteTopBG )
	{
		//PA_DeleteBg( TOP_SCREEN, 1 );
	}
	
	switch( _roomIndex )
	{
		default	: deleteTopBG = false; 
	}

	if ( (BitFlags&(1<<DARKBIT)) && Items[LIGHT_SOURCE].Location!= CARRIED && Items[LIGHT_SOURCE].Location!= MyLoc )
	{
		DARKEN_IMAGE( TOP_SCREEN, 1 );
	}

	DRAW_HLINE		( TOP_SCREEN, 0, 255, 137, 8 );
	DRAW_RECT		( TOP_SCREEN, 0,  138, 255, 191, 18 );

#else
	//PA_Clear8bitBg( TOP_SCREEN );

	DRAW_RECT		( TOP_SCREEN, 0,  0, 255, 94, 16 );
	DRAW_RECT		( TOP_SCREEN, 0,  97, 255, 191, 19 );
	DRAW_HLINE		( TOP_SCREEN, 0, 255, 95, 31 );
	DRAW_HLINE		( TOP_SCREEN, 0, 255, 96, 7 );
	
	if ( theMessage[0] )
	{
		PRINT_STRING	( TOP_SCREEN, theMessage, 12, 100, 31, 7, 192 );
	}

#endif

/*	if ( fatalMessage[0] )
	{
		_roomIndex = GameHeader.NumRooms;
		SoundPlay( SOUND_START );
	}
*/
#endif
	return false;
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
//
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

void RefreshScreens( int _flags )
{
//	int 	j, k;
//	char	letters[4096];
	//int 	currentPageIndex = GameHeader.PlayerRoom;
#if TEXT_ADVENTURE
//	int		topMargin = 0;
#else
//	int		topMargin = 136;
#endif

	SetRefreshFlag( _flags );
	
	if ( refreshFlags & REFRESH_TOP_SCREEN  )
	{
		/*
		if ( GameHeader.PlayerRoom > 0 )
		{
			DrawTopBG( GameHeader.PlayerRoom );
			//PA_Clear8bitBg( TOP_SCREEN );
		}
	
		if((BitFlags&(1<<DARKBIT)) && Items[LIGHT_SOURCE].Location!= CARRIED
					&& Items[LIGHT_SOURCE].Location!= MyLoc)
		{
			strcpy( letters,"I can't see. It is too dark!\n");
		}
		else
		{
			char*	fmt;
			int 	offset = 0;
			if(Rooms[currentPageIndex].Text[0]=='*')
			{
#if TEXT_ADVENTURE
				fmt 	= "%s\n----------------------------------------- [33]exits : [00]%s%s%s%s%s%s ----------------------------------------- ";
#else
				fmt 	= "%s\n[33]exits : [00]%s%s%s%s%s%s\n";
#endif
				offset 	= 1;
			}
			else
			{
#if TEXT_ADVENTURE
				fmt = "I'm in a %s\n----------------------------------------- [33]exits : [00]%s%s%s%s%s%s ----------------------------------------- ";
#else
				fmt = "I'm in a %s\n[33]exits : [00]%s%s%s%s%s%s\n";
#endif
			}

			sprintf( letters, fmt, 		Rooms[currentPageIndex].Text + offset,
										Rooms[currentPageIndex].Exits[0]?"North "	: "" ,
										Rooms[currentPageIndex].Exits[1]?"South "	: "" ,
										Rooms[currentPageIndex].Exits[2]?"East "	: "" ,
										Rooms[currentPageIndex].Exits[3]?"West "	: "" ,
										Rooms[currentPageIndex].Exits[4]?"Up "		: "" ,
										Rooms[currentPageIndex].Exits[5]?"Down "	: "" 
						);
		
			strcat( letters, "[33]I can see : [00]" );

			for ( j = k = 0; j <= GameHeader.NumItems; j++)
			{
				if (Items[j].Location == currentPageIndex)
				{
					if ( k > 0 ) strcat( letters, " - " );
					strcat( letters, Items[j].Text );
					k++;
				}
			}
			PRINT_STRING( TOP_SCREEN, letters, 4, 4+topMargin, 30, 10, 0 );
		}
		*/
	}

	if ( REFRESH_BOTTOM_SCREEN  )
	{
		// ------------------------------------------
		// mode grafiti
		// ------------------------------------------
		if ( gInputMode == INPUT_MODE_GRAFITI )
		{
			DRAW_RECT		( BOTTOM_SCREEN, 33,  33, 222, 158, 18 );
	
	#if GRAPHIC_ADVENTURE
			if ( theMessage[0] )
			{
				PRINT_STRING	( BOTTOM_SCREEN, theMessage, 40, 40, 31, 7, 192 );
			}
			else
	#endif
			{
				char	drawntext[256];
				sprintf( drawntext, ">>> %s <<<", theOrder );
				PRINT_CSTRING	( BOTTOM_SCREEN, drawntext, 92, 31, 7, 240 );
			}
			if ( fatalMessage[0] ) 
			{
				DRAW_RECT		( BOTTOM_SCREEN, 62, 62, 198, 134, 12 );
				DRAW_RECT		( BOTTOM_SCREEN, 60, 60, 196, 132, 21 );
				PRINT_STRING	( BOTTOM_SCREEN, fatalMessage, 64, 64, 32, 7, 132 );
				strcpy			( fatalMessage, "" );
			}
		}
		// ------------------------------------------
		// mode keyboard
		// ------------------------------------------
		else
		{
	#if GRAPHIC_ADVENTURE
			if ( theMessage[0] )
			{
				DRAW_RECT		( BOTTOM_SCREEN, 33,  33, 222, 158, 18 );
				PRINT_STRING	( BOTTOM_SCREEN, theMessage, 40, 40, 31, 7, 192 );
			}
			else
	#endif
			{
				char	drawntext[256];
				sprintf( drawntext, ">>> %s <<<", theOrder );
				FILL_SCREEN		( BOTTOM_SCREEN, 12 );
				PRINT_CSTRING	( BOTTOM_SCREEN, drawntext, 48, 31, 7, 240 );
			}
			if ( fatalMessage[0] ) 
			{
				DRAW_RECT		( BOTTOM_SCREEN, 62, 62, 198, 134, 14 );
				DRAW_RECT		( BOTTOM_SCREEN, 60, 60, 196, 132, 21 );
				PRINT_STRING	( BOTTOM_SCREEN, fatalMessage, 64, 64, 32, 7, 132 );
				strcpy			( fatalMessage, "" );
			}
		}
	}

	refreshFlags = 0;
}

// ----------------------------------------------------------------------------
// (c) papafuji - 2006 - using PAlib
// ----------------------------------------------------------------------------
