// ----------------------------------------------------------------------------
// DS Frotz
// 	
// description	:	DS version of GBA Frotz 
//					made with PAlib - www.palib.com -
//
// ----------------------------------------------------------------------------
// (c) 2006 papafuji - using PAlib
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
// SOME CONSTANTS FOR SAVE/LOAD 
// ----------------------------------------------------------------------------

#define NB_FILES_MAX_IN_SRAM				5
#define NB_FILES_MAX_ON_CART				16

#define GAMESAVFILES_PATH					"/inform/"
#define DEFAULTSAVFILES_PATH				"/"

// ----------------------------------------------------------------------------
// special game IDs (for patches)
// ----------------------------------------------------------------------------

#define GAME_ID_FREEFALL					1001

// ----------------------------------------------------------------------------
// DEBUG MACROS
// ----------------------------------------------------------------------------

#define WAIT_MSG( _fmt_, _aaa_ )																			\
	{																										\
		sprintf( gDebugBuffer, _fmt_, _aaa_ );																\
		DRAW_RECT( 0,0,0,255,24,12);																		\
		PRINT_STRING(0,gDebugBuffer,4,0,31,7,240);														\
		PA_WaitForVBL(); while( TRUE ) { if ( Stylus.Newpress || Pad.Newpress.Select ) break; PA_WaitForVBL(); } PA_WaitForVBL();	\
	}
	
#define WAIT_MSG2( _fmt_, _aaa_, _bbb_ )																	\
	{																										\
		sprintf( gDebugBuffer, _fmt_, _aaa_, _bbb_ );														\
		DRAW_RECT( 0,0,0,255,24,12);																		\
		PRINT_STRING(0,gDebugBuffer,4,0,31,7,240);														\
		PA_WaitForVBL(); while( TRUE ) { if ( Stylus.Newpress || Pad.Newpress.Select ) break; PA_WaitForVBL(); } PA_WaitForVBL();	\
	}

#define WAIT_MSG3( _fmt_, _aaa_, _bbb_, _ccc_ )																\
	{																										\
		sprintf( gDebugBuffer, _fmt_, _aaa_, _bbb_, _ccc_ );												\
		DRAW_RECT( 0,0,0,255,24,12);																		\
		PRINT_STRING(0,gDebugBuffer,4,0,31,7,240);														\
		PA_WaitForVBL(); while( TRUE ) { if ( Stylus.Newpress || Pad.Newpress.Select ) break; PA_WaitForVBL(); } PA_WaitForVBL();	\
	}
	
#define DBG_MSG( _fmt_, _aaa_ )																			\
	if ( gDSdebugMode ) {																					\
		sprintf( gDebugBuffer, _fmt_, _aaa_ );																\
		DRAW_RECT( 0,0,0,255,24,12);																		\
		PRINT_STRING(0,gDebugBuffer,4,0,31,7,240);														\
		PA_WaitForVBL(); while( TRUE ) { if ( Stylus.Newpress || Pad.Newpress.Select ) break; PA_WaitForVBL(); } PA_WaitForVBL();	\
	}

#define DBG_MSG2( _fmt_, _aaa_, _bbb_ )																		\
	if ( gDSdebugMode ) {																					\
		sprintf( gDebugBuffer, _fmt_, _aaa_, _bbb_ );														\
		DRAW_RECT( 0,0,0,255,24,12);																		\
		PRINT_STRING(0,gDebugBuffer,4,0,31,7,240);														\
		PA_WaitForVBL(); while( TRUE ) { if ( Stylus.Newpress || Pad.Newpress.Select ) break; PA_WaitForVBL(); } PA_WaitForVBL();	\
	}

#define DBG_MSG3( _fmt_, _aaa_, _bbb_, _ccc_ )																\
	if ( gDSdebugMode ) {																					\
		sprintf( gDebugBuffer, _fmt_, _aaa_, _bbb_, _ccc_ );												\
		DRAW_RECT( 0,0,0,255,24,12);																		\
		PRINT_STRING(0,gDebugBuffer,4,0,31,7,240);														\
		PA_WaitForVBL(); while( TRUE ) { if ( Stylus.Newpress || Pad.Newpress.Select ) break; PA_WaitForVBL(); } PA_WaitForVBL();	\
	}

#define DBG_PRINT( _fmt_, _aaa_ )																			\
	if ( gDSdebugMode ) {																					\
		if ( gDSDebugPosY>100) { gDSDebugPosY = 4; FILL_SCREEN(0,24); };									\
		sprintf( gDebugBuffer, _fmt_, _aaa_ );																\
		PRINT_STRING( 0, gDebugBuffer, 4, gDSDebugPosY, 1, -1, 240); gDSDebugPosY += 7;						\
		PA_WaitForVBL(); while( TRUE ) { if ( Stylus.Newpress || Pad.Newpress.Select ) break; PA_WaitForVBL(); } PA_WaitForVBL();	\
	}


// ----------------------------------------------------------------------------
// GAME DATA DESCRIPTION
// ----------------------------------------------------------------------------

typedef struct AdventureDesc
{
	char*	title1;
	char*	title2;
	char*	authors;
	char*	editor;
	char*	date;
	char*	desc;

	char*	name;
	void*	data;
	int		dataSize;
} AdventureDesc;

// ----------------------------------------------------------------------------
// debug global variables
// ----------------------------------------------------------------------------

extern int						gDSdebugMode;
extern int						gDSDebugPosY;
extern char					gDebugBuffer[1024];

// ----------------------------------------------------------------------------
// global variables
// ----------------------------------------------------------------------------

extern char					gGameSavFileFormat[80];

extern int						gDSdebugMode;
extern int						gDSDebugPosY;
extern char					gDebugBuffer[1024];

extern char					gGameName[40];
extern int						gGameDataSize;
extern int						gGameID;
extern void*					gGameData;
extern int						gInputMode;

extern int						gNbMenuPages;
extern AdventureDesc			gAdventureDescriptions[];

// ----------------------------------------------------------------------------
// fat.c
// ----------------------------------------------------------------------------

extern int 					gUseFat;
extern int 					gFatStatus;
extern char					gSaveDirectory[80];

extern int 					PF_InitFat		( void );
extern int 					PF_DirExists	( char* _dirName );
extern int 					PF_ParseSAVFiles( void );
extern char* 					PF_ReadSAVFile	( int _fileIndex, int* _size );
extern int 					PF_WriteSAVFile	( int _fileIndex, char* _ptr, int _size );

// ----------------------------------------------------------------------------
// defined in saveload.c
// ----------------------------------------------------------------------------

extern int 					Restore	( void );
extern int 					Save	( int nbBytes );

// ----------------------------------------------------------------------------
// defined in textcompletion.c
// ----------------------------------------------------------------------------

extern void 					TextCompletionInit( void );
extern int 					TextCompletion( char* _text, char* _data );

// ----------------------------------------------------------------------------
// defined in data.c
// ----------------------------------------------------------------------------

extern bool 					LoadBackgroundImageFromIndex( int _index );

// ----------------------------------------------------------------------------
// defined in fujiforce.c
// ----------------------------------------------------------------------------

extern void 					LoopPalette( int _screen, int _bg_number, int _offset );

// ----------------------------------------------------------------------------
// (c) papafuji - 2006 - using PAlib
// ----------------------------------------------------------------------------
