#ifndef __FROSTZAPP_H__
#define __FROSTZAPP_H__



#include "StdAfx.h"
#include <aygshell.h>

#include "ZTools/pix2gif.h"



#define ID_UPDATE_TIMER 1

#define SPECIAL_KEY_HOME 223
#define SPECIAL_KEY_END 224
#define SPECIAL_KEY_WORD_LEFT 225
#define SPECIAL_KEY_WORD_RIGHT 226
#define SPECIAL_KEY_DELETE 227
#define SPECIAL_KEY_INSERT 228
#define SPECIAL_KEY_PAGE_UP 229
#define SPECIAL_KEY_PAGE_DOWN 230
#define SPECIAL_KEY_DELETE_WORD 231
#define SPECIAL_KEY_TRANSPOSE 232
#define SPECIAL_KEY_DELETE_LEFT 233

#define UP_ARROW_KEY	129
#define LEFT_ARROW_KEY	131
#define RIGHT_ARROW_KEY 132
#define DOWN_ARROW_KEY	130

#define BACKSPACE_KEY	8
#define TAB_KEY			9
#define ENTER_KEY		13
#define ESC_KEY			27

#define STATE_NONE		0
#define STATE_MOVING	1
#define STATE_LOOKING	2
#define STATE_OPENING	3
#define STATE_TAKING	4
#define STATE_GOING		5
#define STATE_MACRONL	6

#define WM_CREATE_CURSOR	(WM_USER + 1)
#define WM_UPDATE_CURSOR	(WM_USER + 2)
#define WM_SHOW_CURSOR		(WM_USER + 3)
#define WM_TAKE_FOCUS		(WM_USER + 4)
#define WM_UPDATE_MENU		(WM_USER + 5)


#define NUM_COLOURS		19

#define PALETTE_BLACK		0
#define PALETTE_WHITE		1
#define PALETTE_RED			2
#define PALETTE_GREEN		3
#define PALETTE_YELLOW		4
#define PALETTE_BLUE		5
#define PALETTE_MAGENTA		6
#define PALETTE_CYAN		7
#define PALETTE_GREY		8
#define PALETTE_DARKGREY	9
#define PALETTE_DARKRED		10
#define PALETTE_DARKYELLOW	11
#define PALETTE_DARKGREEN	12
#define PALETTE_DARKCYAN	13
#define PALETTE_DARKBLUE	14
#define PALETTE_VIOLET		15
#define PALETTE_USER_COLOR	16
#define PALETTE_USER_FG		17
#define PALETTE_USER_BG		18

#define NUM_STYLE_BITS 4

#define STYLE(x) ((x)&(0xff>>NUM_STYLE_BITS))
#define COLOUR(x) ((x)>>NUM_STYLE_BITS)

#define NORMAL_STYLE	0

#define DEF_TEXT_STYLE NORMAL_STYLE
#define DEF_TEXT_COLOUR ((PALETTE_WHITE << 2) | PALETTE_BLACK)


#define FROSTZ_UPDATE_MS	250

#define KEYBUFFER_SIZE 128



//*** Macro Stuff ***
#define MAX_MACROS	10
//#define BASE_MACRO_ID	41500 Now defined with the resources

typedef struct
{
	unsigned short wName[32];
	unsigned short wAction[32];
	unsigned char nlStyle; // Newline style: 0 = no newline, 1 = immediate, 2 = after input
	bool isDefined;	// If false, the macro is not active and will not appear on the menu
} fsMacro;
//*** *** *** *** ***



class FrostzApp
{
private:
	HWND hWnd;
	HINSTANCE hInstance;
	HWND hMenuBar;

	WORD bkBMP;

	// Screen dimensions
	int Width,
		Height;

	// Character dimensions
	int	CharWidth,
		CharHeight;

	// Cursor position
	int CursorRow,
		CursorCol;

	bool Redraw; // Should redraw the screen?

	bool InstantRefresh; // Should refresh the screen immediately?

	HANDLE hKeyEvent; // Handle to signal keypress event

	// Cursor state
	bool CursorOn,
		 CursorSet;

	CRITICAL_SECTION 
		// Critical section object used to serialize access to keyboard buffer
		KbdCriticalSection,
		// Critical section object used to serialize access to screen
		ScrnCriticalSection;

	TCHAR* pScreen; // Screen buffer

	BYTE* pAttributes; // Attributes buffer

	BYTE* pFonts;	// Font attributes buffer

	HFONT hCurrentFont; // Current font used for screen

	LOGFONT logFont[2]; // Index 0 = text font; 1 = graphics font

	// Default font values
	int	DefaultStyle,
		DefaultFontHeight,
		DefaultFontWidth;

	// Text styles and colour
	BYTE CurrentStyle,
		 CurrentFont,
		 CurrentColour;

	UINT hUpdateTimer; // Handle to update timer
	UINT UpdateTimerMs; // Screen update frequency (milliseconds)

	int State; // Current state

	COLORREF Palette[NUM_COLOURS]; // Color palette
	bool SimulateCBM;	// Simulate CBM Colors?
	bool bUnderline;	// Use underlined text instead of bold text?

	bool ExpectingInput; // Is the Z-Machine expecting an input?

	// Handle to the Z-Machine thread
	HANDLE hZThread;

	int	KeyBuffer[KEYBUFFER_SIZE],	// Keyboard buffer
		*ReadKeyBuffer,		// Current read position in keyboard buffer
		*WriteKeyBuffer;	// Current write position in keyboard buffer

	/* - Experimental -
	UINT numFonts; // Number of installed fonts
	unsigned short FontFace[256]; // Currently selected font face
	*/

	fsMacro	Macros[MAX_MACROS];	// Actual macros

	inline void LoadRegistry ();
	inline void SaveRegistry ();

	void SetColour (HDC hDC, BYTE nColour);
	HFONT SetStyle (HDC hDC, BYTE nStyle, BOOL bForce = FALSE);
	HFONT SetFont (HDC hDC, BYTE nFont, BOOL bForce = FALSE);

	void UpdateScreenArea (HDC hdc, int Top, int Left, int Bottom, int Right);

	void UpdateMenuItems ();

	void UpdateCaretPos () {
		SendMessage (hWnd, WM_UPDATE_CURSOR, 0, 0);
	}

	void UpdateMacros ();

	void StuffKeyboard (const char *pChars, bool bReturn, bool bEsc = false);

	void CycleCBMPalette ();


public:
	FrostzApp ();
	~FrostzApp ();

	HWND GetMainWnd () { return hWnd; }
	HINSTANCE GetAppInstance () { return hInstance; }

	void SetBgImage (WORD BmpId);

	int PeekColor ();
	void DisplayChar (char Ch, bool UpdateCaret = false);
	void DisplayString (const char* Str);
	void SetTextStyle (int Style);
	void GetCursorPos (int* Row, int* Col);
	void SetCursorPos (int Row, int Col, bool Update = false);
	void ScrollScreenArea (int Top, int Left, int Bottom, int Right, int Units);
	void EraseScreenArea (int Top, int Left, int Bottom, int Right);
	int GetLine (char* Buf, int Max, int Timeout);
	int GetKey (int Timeout);
	void SetCursorState (bool newState);
	void SetTextColour (int Fg, int Bg);
	void SetTextFont (int nFont);
	void ResetScreen ();
	void ClearScreen (BOOL Update = TRUE);
	void ClearMRUList ();

	bool GoFullScreen ();

	int GetWidth () { return Width; }
	int GetHeight () { return Height; }
	int GetFontWidth () { return FontWidth; }
	int GetFontHeight () { return FontHeight; }
	int GetCharWidth () { return CharWidth; }
	int GetCharHeight () { return CharHeight; }

	bool Initialize (HINSTANCE newInstance, int nCmdShow);
	void InitializeScreen ();

	// Event handling functions
	void OnPaint ();
	void OnExit ();
	void OnUpdateMenu ();
	void OnStoryOpen ();
	void OnLoadRecent (BYTE MRU_Idx);
	void OnUpdateCursor ();
	void OnTimer ();
	void OnSetFocus ();
	void OnChar (UINT Char, UINT RepCnt, UINT Flags);
	void OnKeyDown (UINT Char, UINT RepCnt, UINT Flags);
	void OnLButtonDown (UINT Flags, int X, int Y);
	/* - Experimental -
	void OnSelectFont (int SelId);
	*/

	void OnUndo ();

	bool isZmachineRunning;
	bool Initialized;
	bool UseEuroChars;
	bool UseSounds;
	bool UseColours;
	bool UseStyles;
	bool ShowCompass;
	bool TandyBit;
	bool bShowSip;
	char sStoryFile[256];
	int FontHeight;
	int FontWidth;

	RECT ClientRect;	// Visible area

	unsigned char InterpreterNumber;

	bool expand_abbreviations;
	bool ignore_errors;

	//*** Picture stuff ***
	HBITMAP hbmpScreen;
	pdirectory_t *imgDir; // V6 image directory entries
	int imgCount;	// Image count
	short imgVersion;	// Image file version
	FILE *imgFile;	// Pointer to an MG1 file
	//*** *** *** *** *** *

	friend LRESULT CALLBACK WndProc(HWND, UINT, WPARAM, LPARAM);
	friend LRESULT CALLBACK DlgMacros (HWND, UINT, WPARAM, LPARAM);
};



#endif	// __FROSTZAPP_H__