/*
	ZThread.cpp: The entry point of the Z-Machine.
	Copyright (C) 2005 William H. Johnson, Fabio Concas

	You can redistribute this file and/or modify it under the terms
	of version 2 of the GNU General Public License as published by
	the Free Software Foundation.  You should have received a copy
	of the license along with this file; see the file COPYING.

	This file is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	license for more details.
*/



#include "stdafx.h"
#include "Frostz.h"
//#include "FrotzCEDoc.h"
#include "ZThread.h"

extern "C"
{
	#include "Frotz\Frotz.h"

	// Z machine values
	extern int locked;
	extern int finished;//z_finished;

	// Default file names
	extern char script_name[];
	extern char command_name[];
	extern char save_name[];
	extern char auxilary_name[];
}

DWORD WINAPI ZMachineThreadFunction (LPVOID pParam)
{
	__try{
		// Flag that Z machine is running
	Application.isZmachineRunning = true;

	// Initialise Frotz globals
	FrotzGlobalInit ();

	// Set name of story file
	story_name = Application.sStoryFile;

	// Create temp file name and make sure it's got a '.'
	char *temp_name = new char[strlen (story_name) + 2];
	strcpy (temp_name, story_name);
	if (strchr (temp_name,'.') == NULL)
		strcat (temp_name,".");
	else *(strchr (temp_name,'.') + 1) = '\0';

	// Set up default file names
	strcpy (script_name,temp_name);
	strcat (script_name,"scr");
	strcpy (command_name,temp_name);
	strcat (command_name,"rec");
	strcpy (save_name,temp_name);
	strcat (save_name,"sav");
	strcpy (auxilary_name,temp_name);
	strcat (auxilary_name,"aux");
	
	// Free temp file name
	delete[] temp_name;

	// Initialise Z machine values
	locked = 0;
	finished = 0; //z_finished = 0;

	// Initialise Z machine
    init_memory ();

	// Initialise screen
    os_init_screen ();

	// Initialised OK?
	if (Application.Initialized)
	{
		// Initialise Z machine
		init_undo ();
		z_restart ();

		// Z machine main loop
		interpret ();

		// Reset memory
		reset_memory ();

		// Wait for user
		os_more_prompt ();
	}
	else
	{
		// Reset memory
		reset_memory ();
	}

	// Flag that Z machine is no longer running
	Application.isZmachineRunning = false;

	// Reset display
    os_reset_screen ();

	//*** Reset sound as well ***
	os_finish_with_sample ();

	Application.SetBgImage (IDB_FROSTZBG);
	SendMessage (Application.GetMainWnd (), WM_SHOW_CURSOR, FALSE, 0);
	HideCaret (Application.GetMainWnd ());
	DestroyCaret ();

    return 0;

	
	
}__except( EXCEPTION_EXECUTE_HANDLER )
{
	TCHAR wMsg[256];
	wsprintf (wMsg, L"Error #%d\n(Exception %x)", GetLastError (), _exception_code ());
	MessageBox (Application.GetMainWnd (), wMsg, L"ZThread Fatal", MB_OK | MB_ICONSTOP);
	SendMessage (Application.GetMainWnd (), WM_DESTROY, 0, 0);
}


return 0;
}
