/* This file is part of "ZaxMidlet".
 * Copyright (c) 2008 William H. Johnson
 * 
 * --LICENSE NOTICE--
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * --LICENSE NOTICE--
 *
 */

package zmachine.ui;

import javax.microedition.lcdui.*;

import terminal.Settings;
import zmachine.ui.ZaxSettings;
import java.io.IOException;
import java.util.Enumeration;

public class SettingsForm extends Form implements  CommandListener {
	private ZaxMidlet midlet;
	private Displayable lastDisplayable;
	private Settings settings;
	   
	protected ChoiceGroup cgLCDFontMode = new ChoiceGroup( "LCD Font Mode", ChoiceGroup.EXCLUSIVE );
	protected ChoiceGroup cgFont = new ChoiceGroup( "Font Size", ChoiceGroup.EXCLUSIVE );
	private FileDialog filedialog;    
	 	
	private Command exit = new Command("Exit", Command.EXIT, 3);
	private Command start_browser = new Command("Load Story", Command.ITEM, 1);
	private ZaxSettings zaxsettings = new ZaxSettings();
	 	

	public SettingsForm(
		ZaxMidlet midlet, 
		//Displayable lastDisplayable, 
		Settings settings) 
	{
		super("Settings");
		this.midlet = midlet;
		this.lastDisplayable = lastDisplayable;
		// load the settings...
			zaxsettings.readSettings();

		this.settings = settings;
		settings.fontMode = zaxsettings.fontmode;
		append(new String("ZaxMidlet V"+this.midlet.getAppProperty("MIDlet-Version")));
    	append(new String("\nUse the menu key to Load a Story File"));
    	append(new String("\n"));

		cgFont.append( "Tiny", null );
        cgFont.append( "LCD 3x6", null );
        cgFont.append( "LCD 4x6", null );
        cgFont.append( "LCD 4x7", null );
        cgFont.append( "LCD 5x9", null );
        cgFont.append( "LCD 8x16", null );
        append( cgFont );
        cgFont.setSelectedIndex(settings.fontMode,true);
		
		setCommandListener(this);
		addCommand(start_browser);
		addCommand(exit);
	}

    public void commandAction(Command c, Displayable d) {
    	
    if (c == start_browser) {
        settings.fontMode = cgFont.getSelectedIndex();
        zaxsettings.fontmode = cgFont.getSelectedIndex();
        zaxsettings.writeSettings();
        new Thread(new Runnable() {
            public void run() {
            	filedialog = new FileDialog(midlet,settings);
            	filedialog.OpenBrowser(0);            
            }
        }).start();
     } else if (c == exit) {
        	midlet.notifyDestroyed();
        } 
    }

}
