package zpplet.data;

import zpplet.machine.ZMachine;

public class ZDictionary4
		extends ZDictionary
	{
	public ZDictionary4(ZMachine zm) 
		{
		super(zm);
		}

	protected ZDictionary4() {}
	
	protected boolean addToken(int textaddr, int wordaddr, int wordlength, int parseaddr, boolean parseUnknown)
		{
		if (zm.getByte(parseaddr) == zm.getByte(parseaddr + 1))
			return true;

		int[] encword = zm.zc.encode(wordaddr, wordlength, 3);
		long enclong = ((long)encword[0] << 32)	| ((long)encword[1] << 16) | encword[2];
		int first = 0;
		int last = nentries - 1;
		int middle = (last + first) / 2;

		int dictloc;
		long dictlong;
		
		while (true)
			{
			dictloc = wtable_addr + (middle * entry_length);
			 dictlong = ((long)zm.getWord(dictloc) << 32) | ((long)zm.getWord(dictloc + 2) << 16) |
				zm.getWord(dictloc + 4);
			if (enclong < dictlong)
				{
				if (first == middle)
					break;
				last = middle - 1;
				middle = (first + middle) / 2;
				}
			else if (enclong > dictlong)
				{
				if (last == middle)
					break;
				first = middle + 1;
				middle = (middle + last + 1) / 2;
				}
			else
				break;
			}

		if (enclong != dictlong)
			dictloc = 0;

		if ((dictloc != 0) || parseUnknown)
			{
			int parseentry = parseaddr + zm.getByte(parseaddr + 1) * 4 + 2;
			zm.setWord(parseentry, dictloc);
			zm.setByte(parseentry + 2, wordlength);
			if (zm.hd.getVersion() < 5)
				zm.setByte(parseentry + 3, wordaddr - textaddr + 1);
			else
				zm.setByte(parseentry + 3, wordaddr - textaddr + 2); 
			zm.setByte(parseaddr + 1, zm.getByte(parseaddr + 1) + 1);
			}
		return (zm.getByte(parseaddr) == zm.getByte(parseaddr + 1));
		}
	}