package zpplet.machine;

import zpplet.misc.*;
import zpplet.ops.ZInstruction3;
import zpplet.system.*;
import zpplet.data.ZDictionary;
import zpplet.data.ZObjectTree;
import zpplet.header.ZHeader3;
import zpplet.ZUserConfig;

public class ZMachine3
		extends ZMachine2
	{
	public ZMachine3(byte[] mem, ZScreen screen)
		{
		super(mem, screen);
		}

	protected void initStructures() 
		{
		hd = new ZHeader3(m);
		objs = new ZObjectTree(this);
		zd = new ZDictionary(this);
		zi = new ZInstruction3(this);
		}

	public void setHeaderFlags()
		{
		ZHeader3 header = (ZHeader3)this.hd;
		header.setRevision(STANDARDS_VERSION_MAJOR, STANDARDS_VERSION_MINOR);
		header.setStatusUnavailable(false);
		header.setSplittingAvailable(false); // used to provide status instead
		if (header.isFixedForced())
			ZUserConfig.normalfont = ZUserConfig.fixedfont;
		header.setVariableDefault(ZUserConfig.normalfont == ZUserConfig.variablefont);
		header.setSoundAvailable(media != null);
		}
	
	public String getStringAt(int addr)
			throws ZError
		{
		StringBuilder result = new StringBuilder();

		int build_ascii = 0;
		int built_ascii = 0;
		int alphabet = 0;
		int abbrev_mode = 0;

		int[] zchars = new int[3];
		int zseq;

		do
			{
			zseq = getWord(addr);
			addr += 2;
			zchars[0] = (zseq >> 10) & 0x1F;
			zchars[1] = (zseq >> 5) & 0x1F;
			zchars[2] = zseq & 0x1F;
			for (int i = 0; i < 3; i++)
				{
				if (build_ascii > 0)
					{
					built_ascii = (built_ascii << 5) + zchars[i];
					if (++build_ascii == 3)
						{
						result.append((char)built_ascii);
						built_ascii = 0;
						build_ascii = 0;
						}
					}
				else if (abbrev_mode > 0)
					{
					int anum = 32 * (abbrev_mode - 1) + zchars[i];
					int aindex = hd.getAbbrevTableAddr() + anum * 2;
					int aaddr = getWord(aindex) * 2;
					result.append(getStringAt(aaddr));
					abbrev_mode = 0;
					}
				else
					{
					switch (zchars[i])
						{
						case 0:
							result.append(' ');
							break;
						case 1:
						case 2:
						case 3:
							if (abbrev_mode != 0)
								throw new ZError("Abbreviation in abbreviation");
							abbrev_mode = zchars[i];
							alphabet = 0;
							break;
						case 4:
						case 5:
							alphabet = (alphabet + zchars[i] - 3) % 3;
							break;
						default:
							if ((zchars[i] == 6) && (alphabet == 2))
								build_ascii = 1;
							else
								result.append(zc.fromTable(zchars[i], alphabet));
							alphabet = 0;
							break;
						}
					}
				}
			}
		while ((zseq & 0x8000) == 0);
		return result.toString();
		}
	}