package zpplet.misc;

public class ScrollBuffer
	{
	/*
	 * Append lines to it;
	 * reference lines from 0 (most current) back
	 */
	private String[] lines;
	public StringBuilder buffer;
	private int head;
	
	public ScrollBuffer(int capacity)
		{
		lines = new String[capacity];
		buffer = new StringBuilder();
		head = 0;
		}
	
	public void append(char ch)
		{
		buffer.append(ch);
		}
	
	public void append(String s)
		{
		buffer.append(s);
		}
	
	public void nextLine()
		{
		lines[head++] = buffer.toString();
		if (head == lines.length)
			head = 0;
		buffer.setLength(0);
		}
	
	public String get(int index)
		{
		if ((index < 0) || (index >= lines.length))
			return null;
		if (index == 0)
			return buffer.toString();
		index = head - index;
		if (index < 0)
			index += lines.length;
		return lines[index];
		}
	
	public void clear()
		{
		for (int i = 0; i < lines.length; i++)
			lines[i] = null;
		head = 0;
		}
	}
