//---------------------------------------------------------------------------
#include <vcl.h>
#include <algorithm.h>
#include <time.h>
#include <sys/timeb.h>
#pragma hdrstop

#include "globals.h"                        
#include "glkthread.h"
#include "zclass.h"
#include "gclass.h"
#include "Main.h"
#pragma package(smart_init)
//---------------------------------------------------------------------------

//   Important: Methods and properties of objects in VCL can only be
//   used in a method called using Synchronize, for example:
//
//      Synchronize(UpdateCaption);
//
//   where UpdateCaption could look like:                                  f
//
//      void __fastcall GLK::UpdateCaption()
//      {
//        Form1->Caption = "Updated in a thread";
//      }
//---------------------------------------------------------------------------

#define BOOL 1
#define INT 4

#define UNCHANGED -1
extern GLK *glk;

extern ZMACHINE *zmachine;
extern GMACHINE *gmachine;

const STYLE def_style[11]=
  {{0,0,STYLEHINT_JUST_LEFTFLUSH,0,0,false,true,clBlack,clWhite,false},
   {0,0,STYLEHINT_JUST_LEFTFLUSH,0,1,false,true,clBlack,clWhite,false},
   {0,0,STYLEHINT_JUST_LEFTFLUSH,0,0,false,false,clBlack,clWhite,false},
   {0,0,STYLEHINT_JUST_LEFTFLUSH,2,1,false,true,clBlack,clWhite,false},
   {0,0,STYLEHINT_JUST_LEFTFLUSH,1,1,false,true,clBlack,clWhite,false},
   {0,0,STYLEHINT_JUST_LEFTFLUSH,1,1,false,true,clBlack,clWhite,false},
   {0,0,STYLEHINT_JUST_LEFTFLUSH,0,0,true,true,clBlack,clWhite,false},
   {2,0,STYLEHINT_JUST_LEFTFLUSH,0,0,false,true,clBlack,clWhite,false},
   {0,0,STYLEHINT_JUST_LEFTFLUSH,0,1,false,true,clBlack,clWhite,false},
   {0,0,STYLEHINT_JUST_LEFTFLUSH,0,0,false,true,clBlack,clWhite,false},
   {0,0,STYLEHINT_JUST_LEFTFLUSH,0,0,false,true,clBlack,clWhite,false}};

const CHARRANGE set_range={246913579,246913579};
const wchar_t lf[2]={'\n',0};
const wchar_t blank[1]={0};

const bool allowed_keys[255]={true,false,false,false,false,true,true,true,
true,false,true,true,false,true,true,true,false,false,false,false,false,
true,true,true,true,true,true,true,true,true,true,true,true,true,
true,false,false,true,true,true,true,false,true,false,false,false,true,
false,true,true,true,true,true,true,true,true,true,true,true,true,true,true,
true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,
true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,
false,false,false,true,true,true,true,true,true,true,true,true,true,true,true,
true,true,true,true,true,true,true,true,true,true,true,true,true,true,
true,true,true,false,false,false,false,false,false,false,false,false,false,
false,false,true,true,true,true,true,true,true,true,false,false,true,
true,true,true,true,true,true,true,true,true,true,true,true,true,
true,true,true,true,true,true,true,true,true,true,true,true,true,
true,true,true,true,true,true,true,true,true,true,true,true,true,
true,true,true,true,true,true,true,true,true,true,true,true,true,
true,true,true,true,true,true,true,true,true,true,true,true,true,
true,true,true,true,true,true,true,true,true,true,true,true,true,
true,true,true,true,true,true,true,true,true,true,true,true,true,
true,true,true,true,true,true,true,true,false,false,false,false,false,
false,false,false,false};

__fastcall GLK::GLK(bool CreateSuspended)
  : TThread(CreateSuspended)
{
done=new TEvent(NULL,false,false,"");

prop_font=new TFont();
//prop_font->Name="Times New Roman";
//prop_font->Size=12;
//prop_font->Color=clBlack;                 
fixed_font=new TFont();
//fixed_font->Name="Courier New";
//fixed_font->Size=12;
//fixed_font->Color=clBlack;
char_graphics=false;

clipboard=new TClipboard();

timer=new TTimer(MainForm);
timer->Enabled=false;
timer->OnTimer=signal_timer;

left_margin=5;
right_margin=5;

double_click=false;

win_version.dwOSVersionInfoSize=sizeof(win_version);
GetVersionEx(&win_version);
                                     
unicode_text.flags=ST_SELECTION;
unicode_text.codepage=1200;
uni_conv=NULL;
uni_conv_multi=NULL;
uni_norm=NULL;

sound_avail=BASS_Init(-1,44100,0,0,0);

win_count=0;                 
cleanup();

Application->OnMessage=AppMessage;
}
//---------------------------------------------------------------------------

__fastcall GLK::~GLK()
{
do_window_close(0);
BASS_Free();
delete prop_font;
delete fixed_font;
delete clipboard;
delete done;
delete timer;
delete uni_conv;
delete uni_conv_multi;
delete uni_norm;
};

//---------------------------------------------------------------------------
void __fastcall GLK::Execute()
{
hard_quit=false;

while (1){
  if (version<71)
    zmachine->run_story();
  else
    gmachine->run_story();
  saved=true;
  if (hard_quit)
    hard_quit=false;
  else
    Synchronize (FinalOutput);
  suspend_me();};
}
//---------------------------------------------------------------------------

int GLK::window_open(int split,int method,int size,int wintype,int rock)
{
if (win_count>47||stream_count>19||wintype<WINTYPE_BLANK||wintype>WINTYPE_GRAPHICS)
  return (false);

int start_count=win_count;
plant_args(&split,&method,&size,&wintype,&rock);
Synchronize(WindowOpen);
if (win_count!=start_count)
  return (win_count);
else
  return (false);
};
//---------------------------------------------------------------------------

void __fastcall GLK::WindowOpen()
{
int split,method,size,wintype,rock;
dig_args(&split,INT,&method,INT,&size,INT,&wintype,INT,&rock,INT);

int pair_win;                                      
if (win_count==0){
  if (split!=0){
    return;};
  if (method&WINMETHOD_NOBORDER)
    pair_win=create_win(-1,wintype,rock,false,false);
  else
    pair_win=create_win(-1,wintype,rock,borders,scrollbar);}
else{
  pair_win=create_pair(split-1,method,size);
  if (method&WINMETHOD_NOBORDER)
    window[pair_win].child2=create_win(pair_win,wintype,rock,false,false)+1;
  else
    window[pair_win].child2=create_win(pair_win,wintype,rock,borders,scrollbar)+1;
  window[pair_win].key=window[pair_win].child2;};

if (root_win==split)
  root_win=pair_win+1;
arrange_windows(root_win-1);
};
//---------------------------------------------------------------------------

void GLK::plant_args(void *argv0,void *argv1,void *argv2,void *argv3,void *argv4,void *argv5)
{
args[0]=argv0;
args[1]=argv1;
args[2]=argv2;
args[3]=argv3;
args[4]=argv4;
args[5]=argv5;
};
//----------------------------------------------------------------------------
void GLK::dig_args(void *argv0,int size0,void *argv1,int size1,void *argv2,int size2,void *argv3,int size3,void *argv4,int size4,void *argv5,int size5)
{
memcpy(argv0,args[0],size0);
if (argv1!=NULL){
  memcpy(argv1,args[1],size1);
  if (argv2!=NULL){
    memcpy(argv2,args[2],size2);
    if (argv3!=NULL){
      memcpy(argv3,args[3],size3);
      if (argv4!=NULL){
        memcpy(argv4,args[4],size4);
        if (argv5!=NULL){
          memcpy(argv5,args[5],size5);};};};};};
};
//----------------------------------------------------------------------------
                                                    
int GLK::font_width(TFont *font)
{
MainForm->Canvas->Lock();
MainForm->Canvas->Font->Assign(font);
int width=MainForm->Canvas->TextWidth("0");
MainForm->Canvas->Unlock();
return (width);
};
//----------------------------------------------------------------------------

int GLK::font_height(TFont *font)
{
MainForm->Canvas->Lock();
MainForm->Canvas->Font->Assign(font);
int height=MainForm->Canvas->TextHeight("0");
MainForm->Canvas->Unlock();
return (height);
};
//----------------------------------------------------------------------------

void __fastcall GLK::resize_redraw()
{
arrange_windows(root_win-1);
if (active_win!=0&&window[active_win-1].wintype==WINTYPE_TEXTBUFFER){
  window[active_win-1].textbuffer->SetFocus();};
};
//----------------------------------------------------------------------------

void GLK::window_get_size(int win,int &width,int &height)
{
if (win<1||win>49||!window[win-1].in_use||window[win-1].wintype<WINTYPE_TEXTBUFFER){
  width=0;
  height=0;
  return;};
int target=win-1;

width=window[target].width/window[target].font_width;
height=window[target].height/window[target].font_height;
};
//----------------------------------------------------------------------------

void GLK::window_set_arrangement(int win,int method,int size,int keywin)
{
if (win<1||win>49||!window[win-1].in_use||window[win-1].wintype!=WINTYPE_PAIR)
  return;
int target=win-1;

if (keywin){
  if (!descendent(keywin-1,target)){
    return;}
  else{
    window[target].key=keywin;
    window[target].font_width=window[keywin-1].font_width;
    window[target].font_height=window[keywin-1].font_height;};};

window[target].method=(method&240)|(window[target].method&15);
window[target].size=size;

Synchronize(resize_redraw);
};
//----------------------------------------------------------------------------

void GLK::window_get_arrangement(int win,int &method,int &size,int &keywin)
{
if (win<1||win>49||!window[win-1].in_use||window[win-1].wintype!=WINTYPE_PAIR)
  return;
int target=win-1;

method=window[target].method;
size=window[target].size;
keywin=window[target].key;
};
//----------------------------------------------------------------------------

void GLK::do_window_close(int target)
{
plant_args(&target);
Synchronize(WindowClose);
};
//----------------------------------------------------------------------------

void GLK::window_close(int win,STREAM_RESULT &result)
{
if (win<1||win>49||!window[win-1].in_use)
  return;
int target=win-1;

if (window[target].wintype==WINTYPE_TEXTBUFFER||window[target].wintype==WINTYPE_TEXTGRID){
  result.readcount=stream[window[target].stream-1].readcount;
  result.writecount=stream[window[target].stream-1].writecount;}
else{
  result.readcount=0;
  result.writecount=0;};

do_window_close(target);
};
//----------------------------------------------------------------------------

void __fastcall GLK::WindowClose()
{
MainForm->Perform(WM_SETREDRAW,false,NULL);
repaint=true;

int target;
dig_args(&target,INT);

int parent=window[target].parent-1;
window_close_loop(target);

if (parent>=0){
  int child;
  if (window[parent].child1==target+1)
    child=window[parent].child2-1;
  else
    child=window[parent].child1-1;
  int gparent=window[parent].parent-1;
  do_close_win(parent);
  if (gparent>=0){
    if (window[gparent].child1==parent+1){
      if (window[gparent].key==window[gparent].child1){
        window[gparent].key=child+1;
        window[gparent].font_width=window[child].font_width;
        window[gparent].font_height=window[child].font_height;};
      window[gparent].child1=child+1;
      window[child].parent=gparent+1;}
    else{
      if (window[gparent].key==window[gparent].child2){
        window[gparent].key=child+1;
        window[gparent].font_width=window[child].font_width;
        window[gparent].font_height=window[child].font_height;};
      window[gparent].child2=child+1;
      window[child].parent=gparent+1;};}
  else{
    window[child].parent=0;
    root_win=child+1;};}
else{
  root_win=0;};

arrange_windows(root_win-1);
};
//----------------------------------------------------------------------------

void GLK::window_close_loop(int target)
{
if (window[target].child1)
  window_close_loop(window[target].child1-1);
if (window[target].child2)
  window_close_loop(window[target].child2-1);

do_close_win(target);
};
//----------------------------------------------------------------------------

void GLK::cleanup()
{
for (int i=0;i<49;i++){
  window[i].in_use=false;
  delete window[i].textbuffer;
  window[i].textbuffer=NULL;
  delete window[i].textgrid;
  window[i].textgrid=NULL;
  delete window[i].font;
  window[i].font=NULL;
  window[i].char_event=false;
  window[i].line_event=false;};

for (int i=1;i<=10;i++)
  schannel_destroy(i);

for (int i=0;i<20;i++){
  stream[i].in_use=false;
  delete stream[i].file;
  stream[i].file=NULL;};

for (int i=0;i<10;i++){
  fileref[i].in_use=false;};

prop_font->Assign(MainForm->prop_font);
fixed_font->Assign(MainForm->fixed_font);

memcpy(textbuffer_style,def_style,sizeof(STYLE)*11);
memcpy(textgrid_style,def_style,sizeof(STYLE)*11);

for (int i=0;i<11;i++){
  textbuffer_style[i].text_color=MainForm->prop_font->Color;
  textgrid_style[i].text_color=MainForm->fixed_font->Color;
  textbuffer_style[i].back_color=MainForm->Color;
  textgrid_style[i].back_color=MainForm->Color;};

insert=true;
char_input=false;
scripted=false;
recorded=false;
key_pressed[1]=0;
mored=false;
win_count=0;
stream_count=0;
file_count=0;
active_stream=0;
active_win=0;
resize_pending=false;
timer_pending=false;
mouse_pending=false;
hyper_pending=false;
char_graphics=false;
more_clear=false;
repaint=false;
root_win=0;
pending_loc=0;
processed_loc=0;
catching_up=false;
borders=true;
scrollbar=true;
saved=true;
input_style=true;
more_cancel=false;
need_paint=false;
};
//----------------------------------------------------------------------------

void GLK::stream_set_current(int new_stream)
{
if (new_stream<1||new_stream>20||!stream[new_stream-1].in_use)
  return;

active_stream=new_stream;
};
//----------------------------------------------------------------------------

void GLK::put_string(wchar_t *s)
{
put_string_stream(active_stream,s);
};
//----------------------------------------------------------------------------

void GLK::put_char(wchar_t ch)
{                 
put_char_stream(active_stream,ch);
};
//----------------------------------------------------------------------------

void GLK::put_char_stream(int str,wchar_t ch)
{
wchar_t tmp[2];
tmp[0]=ch;
tmp[1]=0;
put_string_stream(str,tmp);
};
//----------------------------------------------------------------------------

void GLK::put_string_stream(int str,wchar_t *s)
{
if (str<1||str>20||!stream[str-1].in_use||s==NULL)
  return;
int target=str-1;

if (stream[target].type==STREAM_WINDOW){
  if (window[stream[target].win-1].echo_stream){
    put_string_stream(window[stream[target].win-1].echo_stream,s);};
  plant_args(&target,s);
  Synchronize(PutString);
  return;};

if (stream[target].type==STREAM_MEMORY){
  if (stream[target].fmode==FILEMODE_READ)
    return;
  int space=(stream[target].buflen-stream[target].loc);
  if (stream[target].unicode){
    int len=wcslen(s);                  
    stream[target].writecount+=len;
    if (len>space/4){
      s[space/4]=0;};
    unsigned int *str_write=flip_string(s);
    memcpy((stream[target].buf+stream[target].loc),str_write,wcslen(s)*4);
    stream[target].loc+=wcslen(s)*4;
    delete str_write;}
  else{
    String output=s;
    stream[target].writecount+=output.Length();
    output.SetLength(min(output.Length(),space));
    memcpy((stream[target].buf+stream[target].loc),output.c_str(),output.Length());
    stream[target].loc+=output.Length();};
  stream[target].highest_point=max(stream[target].loc,stream[target].highest_point);
  return;};

if (stream[target].type==STREAM_FILE&&stream[target].file!=NULL){
  if (stream[target].fmode==FILEMODE_READ)
    return;
  WideString wide_text(s);
  if (stream[target].text||stream[target].script)
    wide_text=StringReplace(s,"\n","\r\n",TReplaceFlags()<<rfReplaceAll);
  if (stream[target].unicode){
    unsigned int *str_write=flip_string(wide_text.c_bstr());
    stream[target].file->Write(str_write,wide_text.Length()*4);
    delete str_write;}
  else{
    char *write_text=(char *)malloc(wide_text.Length());
    WideCharToMultiByte(CP_UTF8,NULL,wide_text.c_bstr(),-1,write_text,wide_text.Length(),NULL,NULL);
    stream[target].file->Write(write_text,wide_text.Length());
    free(write_text);};};
};                                            
//---------------------------------------------------------------------------

void __fastcall GLK::PutString()
{
int str;
dig_args(&str,INT);
wchar_t *s=(wchar_t *)args[1];
int target=stream[str].win-1;

if (window[target].wintype==WINTYPE_TEXTBUFFER){
  window[target].textbuffer->had_output=true;
  window[target].textbuffer->Perform(WM_SETREDRAW,false,NULL);
  window[target].textbuffer->SelAttributes2->Assign(window[target].font);
  if (window[target].reverse){
    window[target].textbuffer->SelAttributes2->Color=window[target].color;
    window[target].textbuffer->SelAttributes2->BackColor=window[target].font->Color;}
  else{
    window[target].textbuffer->SelAttributes2->Color=window[target].font->Color;
    window[target].textbuffer->SelAttributes2->BackColor=window[target].color;};
  if (window[target].hyper_linking){
    window[target].textbuffer->SelAttributes2->Link=tsYes;
    window[target].textbuffer->hypertext[window[target].textbuffer->hyper_count-1].end+=wcslen(s);};
  window[target].textbuffer->Perform(EM_EXSETSEL,NULL,(LONG)&set_range);
  window[target].textbuffer->Perform(EM_SETPARAFORMAT,NULL,(LONG)&window[target].para_format);
                                        
  if (window[target].para_format.wAlignment==PFA_CENTER){
    int len=wcslen(s);
    int pos1=0;
    while (pos1<len&&s[pos1]<33){
      if (s[pos1]==' '){
        s[pos1]='_';};
      pos1++;};
    int pos2=len-1;
    while (pos2>=0&&s[pos2]<33){
      if (s[pos2]==' '){
        s[pos2]='_';};
      pos2--;};
    pos2++;
    wchar_t tmp[2];
    tmp[1]=0;
    TColor prev_color=window[target].textbuffer->SelAttributes2->Color;
    TColor prev_back=window[target].textbuffer->SelAttributes2->BackColor;
    for (int i=0;i<len;i++){
      tmp[0]=s[i];
      window[target].textbuffer->SelAttributes2->Assign(window[target].font);
      if (tmp[0]=='_'){
        window[target].textbuffer->SelAttributes2->Color=prev_back;
        window[target].textbuffer->SelAttributes2->BackColor=prev_back;}
      else{
        window[target].textbuffer->SelAttributes2->Color=prev_color;
        window[target].textbuffer->SelAttributes2->BackColor=prev_back;};
      window[target].textbuffer->Perform(EM_SETTEXTEX,(LONG)&unicode_text,(LONG)tmp);};}

  else{
    window[target].textbuffer->Perform(EM_SETTEXTEX,(LONG)&unicode_text,(LONG)s);};}

else{

  WideString wide_text=s;
  window[target].textgrid->changed=true;
  window[target].textgrid->bitmap->Canvas->Lock();
  if (window[target].reverse){
    window[target].textgrid->bitmap->Canvas->Font->Color=window[target].color;
    window[target].textgrid->bitmap->Canvas->Brush->Color=window[target].font->Color;}
  else{
    window[target].textgrid->bitmap->Canvas->Font->Color=window[target].font->Color;
    window[target].textgrid->bitmap->Canvas->Brush->Color=window[target].color;};
  if (window[target].hyper_linking){
    window[target].textgrid->bitmap->Canvas->Font->Color=clBlue;};
  int pos;
  while((pos=wide_text.Pos("\n"))!=0){
    WideString line=wide_text.SubString(1,pos-1);              
    wide_text.Delete(1,pos);
    TextOutW(window[target].textgrid->bitmap->Canvas->Handle,window[target].textgrid->cursor.x,window[target].textgrid->cursor.y,line.c_bstr(),line.Length());
    if (window[target].hyper_linking){
      window[target].textgrid->hyperlink[window[target].textgrid->hyper_count-1].coords.right+=(line.Length()*window[target].font_width);
      if (window[target].reverse){
        window[target].textgrid->bitmap->Canvas->Font->Color=window[target].color;}
      else{
        window[target].textgrid->bitmap->Canvas->Font->Color=window[target].font->Color;};
      window[target].hyper_linking=false;};
    window[target].textgrid->cursor.x=0;
    window[target].textgrid->cursor.y+=window[target].font_height;};
  TextOutW(window[target].textgrid->bitmap->Canvas->Handle,window[target].textgrid->cursor.x,window[target].textgrid->cursor.y,wide_text.c_bstr(),wide_text.Length());
  window[target].textgrid->cursor.x+=(wide_text.Length()*window[target].font_width);
  window[target].textgrid->bitmap->Canvas->Brush->Color=window[target].color;
  if (window[target].hyper_linking){
    window[target].textgrid->hyperlink[window[target].textgrid->hyper_count-1].coords.right+=(wide_text.Length()*window[target].font_width);};
  window[target].textgrid->bitmap->Canvas->Unlock();};

stream[str].writecount+=wcslen(s);
};
//----------------------------------------------------------------------------

void GLK::request_line_event(int win,wchar_t *buf,int maxlen,int initlen)
{
if (win<1||win>49||!window[win-1].in_use||window[win-1].wintype<WINTYPE_TEXTBUFFER||window[win-1].wintype==WINTYPE_GRAPHICS||window[win-1].char_event)
  return;
int target=win-1;          

window[target].line_event=true;
window[target].buf=buf;
window[target].maxlen=maxlen-1;
window[target].initlen=initlen;
window[target].cursor_pos=initlen+1;
window[target].input_text.SetLength(initlen);
if (initlen){
  for (int i=0;i<initlen;i++)
    window[target].input_text[i+1]=buf[i];
  if (input_style){
    int prev_style=window[target].curr_style;
    do_set_style(target,STYLE_INPUT);
    put_string_stream(window_get_stream(win),window[target].input_text.c_bstr());
    do_set_style(target,prev_style);};};
active_win=win;
};
//----------------------------------------------------------------------------

int GLK::window_get_stream(int win)
{
if (win<1||win>49||!window[win-1].in_use||window[win-1].wintype<WINTYPE_TEXTBUFFER||window[win-1].wintype==WINTYPE_GRAPHICS)
  return (false);
int target=win-1;

return (window[target].stream);
};
//----------------------------------------------------------------------------

void GLK::cancel_line_event(int win,EVENT *event)
{
event->type=EVTYPE_NONE;
event->win=0;
event->val1=0;
event->val2=0;

if (win<1||win>49||!window[win-1].in_use||(window[win-1].wintype!=WINTYPE_TEXTBUFFER&&window[win-1].wintype!=WINTYPE_TEXTGRID))
  return;
int target=win-1;

event->win=win;
if (!window[target].line_event)
  return;

wchar_t tmp[2];
tmp[0]='\n';
tmp[1]=0;
put_string_stream(window_get_stream(win),tmp);
process_line_input(target,13,event,false);
};
//----------------------------------------------------------------------------

void __fastcall GLK::AppMessage(tagMSG &Msg, bool &Handled)
{
if (MainForm->dialogue_up||double_click)
  return;

if (GetKeyState(VK_CONTROL)<0){
  if ((GetKeyState(VK_LEFT)<0||GetKeyState(VK_UP)<0)&&Msg.message==WM_KEYDOWN){
    Msg.wParam=VK_HOME;}
  else{
    if ((GetKeyState(VK_RIGHT)<0||GetKeyState(VK_DOWN)<0)&&Msg.message==WM_KEYDOWN){
      Msg.wParam=VK_END;}
    else{
      return;};};};

if (active_win){

  if (!Suspended&&!catching_up){
    if (Msg.message==WM_LBUTTONDBLCLK||Msg.message==WM_MBUTTONDOWN||Msg.message==WM_KEYDOWN){
      pending_msg[pending_loc]=Msg;
      pending_loc++;
      if (pending_loc>99)
        pending_loc=0;
      Handled=true;
      return;};};
                
  int target=active_win-1;

  if (window[target].line_event){

    if (Msg.message==WM_LBUTTONDBLCLK&&window[target].wintype==WINTYPE_TEXTBUFFER){
       double_click=true;
       return;};
   
    if (Msg.message==WM_MBUTTONDOWN&&window[target].wintype==WINTYPE_TEXTBUFFER){
       window[target].textbuffer->Perform(EM_EXSETSEL,NULL,(LONG)&set_range);
       window[target].textbuffer->Perform(EM_SETTEXTEX,(LONG)&unicode_text,(LONG)lf);
       process_line_input(target,13,done_event);
       Handled=true;
       return;};

   if (need_paint && Msg.message==WM_KEYUP){
     window[target].textbuffer->Perform(WM_VSCROLL,SB_BOTTOM,NULL);
     window[target].textbuffer->Perform(WM_SETREDRAW,true,NULL);
     window[target].textbuffer->Repaint();
     need_paint = false;};


    if (Msg.message==WM_KEYDOWN){
      Handled=true;
      if (MainForm->FindDialog->Tag&&window[target].wintype==WINTYPE_TEXTBUFFER&&!window[target].textbuffer->Focused())
        return;
        
      if (window[target].term_chars[Msg.wParam]){
          if (window[target].wintype==WINTYPE_TEXTBUFFER){
            if ((input_style&&window[target].line_input_echo)||(!input_style&&Msg.wParam==VK_RETURN)){
              window[target].textbuffer->Perform(EM_EXSETSEL,NULL,(LONG)&set_range);
              window[target].textbuffer->Perform(EM_SETTEXTEX,(LONG)&unicode_text,(LONG)lf);}
            else{
              if (input_style){
                window[target].textbuffer->input_pos.cpMin-=(window[target].cursor_pos-1);
                window[target].textbuffer->input_pos.cpMax=window[target].textbuffer->input_pos.cpMin+window[target].input_text.Length();
                window[target].textbuffer->Perform(EM_EXSETSEL,NULL,(LONG)&window[target].textbuffer->input_pos);
                window[target].textbuffer->Perform(EM_SETTEXTEX,(LONG)&unicode_text,(LONG)blank);};};
            window[target].textbuffer->Perform(WM_VSCROLL,SB_BOTTOM,NULL);};
//            Handled=false;};
          process_line_input(target,Msg.wParam,done_event);
          return;};

      unsigned char key_state[256];
      HKL keyboard;
      int movement;
      switch (Msg.wParam){
        case VK_BACK:
          if (window[target].cursor_pos>1){
            window[target].cursor_pos--;
            window[target].input_text.Delete(window[target].cursor_pos,1);
            if (window[target].wintype==WINTYPE_TEXTGRID){
              erase_cursor(target);
              window[target].textgrid->cursor.x-=window[target].font_width;
              WideString tmp=window[target].input_text.SubString(window[target].cursor_pos,window[target].input_text.Length());
              tmp+=" ";
              window[target].textgrid->bitmap->Canvas->Lock();
              TextOutW(window[target].textgrid->bitmap->Canvas->Handle,window[target].textgrid->cursor.x,window[target].textgrid->cursor.y,tmp.c_bstr(),tmp.Length());
              window[target].textgrid->bitmap->Canvas->Unlock();
              draw_cursor(target);}
            else{
              window[target].textbuffer->input_pos.cpMin--;
              if (window[target].textbuffer->sel_change||catching_up){
                window[target].textbuffer->Perform(EM_EXSETSEL,NULL,(LONG)&window[target].textbuffer->input_pos);
                window[target].textbuffer->Perform(EM_SETTEXTEX,(LONG)&unicode_text,(LONG)blank);}
              else{
                Handled=false;};
              window[target].textbuffer->input_pos.cpMax=window[target].textbuffer->input_pos.cpMin;};};
          return;
        case VK_DELETE:
          if (window[target].cursor_pos<=window[target].input_text.Length()){
            window[target].input_text.Delete(window[target].cursor_pos,1);
            if (window[target].wintype==WINTYPE_TEXTGRID){
              WideString tmp=window[target].input_text.SubString(window[target].cursor_pos,window[target].input_text.Length());
              tmp+=" ";
              window[target].textgrid->bitmap->Canvas->Lock();
              TextOutW(window[target].textgrid->bitmap->Canvas->Handle,window[target].textgrid->cursor.x,window[target].textgrid->cursor.y,tmp.c_bstr(),tmp.Length());
              window[target].textgrid->bitmap->Canvas->Unlock();
              window[target].textgrid->Repaint();}
            else{
              window[target].textbuffer->input_pos.cpMax++;
              if (window[target].textbuffer->sel_change||catching_up){
                window[target].textbuffer->Perform(EM_EXSETSEL,NULL,(LONG)&window[target].textbuffer->input_pos);
                window[target].textbuffer->Perform(EM_SETTEXTEX,(LONG)&unicode_text,(LONG)blank);}
              else{
                Handled=false;};
              window[target].textbuffer->input_pos.cpMax=window[target].textbuffer->input_pos.cpMin;};};
          return;
        case VK_HOME:
          if (window[target].cursor_pos>1){
            if (window[target].wintype==WINTYPE_TEXTGRID){
              erase_cursor(target);
              window[target].textgrid->cursor.x-=window[target].font_width*(window[target].cursor_pos-1);
              draw_cursor(target);}
            else{
              window[target].textbuffer->input_pos.cpMin-=(window[target].cursor_pos-1);
              window[target].textbuffer->input_pos.cpMax-=(window[target].cursor_pos-1);
              window[target].textbuffer->Perform(EM_EXSETSEL,NULL,(LONG)&window[target].textbuffer->input_pos);};
            window[target].cursor_pos=1;};
          break;
        case VK_END:
          if (window[target].cursor_pos<=window[target].input_text.Length()){
            movement=window[target].input_text.Length()+1-window[target].cursor_pos;
            window[target].cursor_pos=window[target].input_text.Length()+1;
            if (window[target].wintype==WINTYPE_TEXTGRID){
              erase_cursor(target);
              window[target].textgrid->cursor.x+=movement*window[target].font_width;
              draw_cursor(target);}
            else{
              if (window[target].textbuffer->sel_change||catching_up)
                window[target].textbuffer->Perform(EM_EXSETSEL,NULL,(LONG)&window[target].textbuffer->input_pos);
              window[target].textbuffer->input_pos.cpMin+=movement;
              window[target].textbuffer->input_pos.cpMax+=movement;
              Handled=false;};};
            return;
        case VK_LEFT:
          if (window[target].cursor_pos>1){
            window[target].cursor_pos--;
            if (window[target].wintype==WINTYPE_TEXTGRID){
              erase_cursor(target);
              window[target].textgrid->cursor.x-=window[target].font_width;
              draw_cursor(target);}
            else{
              if (window[target].textbuffer->sel_change||catching_up)
                window[target].textbuffer->Perform(EM_EXSETSEL,NULL,(LONG)&window[target].textbuffer->input_pos);
              window[target].textbuffer->input_pos.cpMin--;
              window[target].textbuffer->input_pos.cpMax--;
              Handled=false;};};
          return;
        case VK_UP:
          if (window[target].wintype==WINTYPE_TEXTBUFFER){
            window[target].textbuffer->hist_pos++;
            if (window[target].textbuffer->hist_pos==window[target].textbuffer->history->Count)
              window[target].textbuffer->hist_pos=-1;
            window[target].textbuffer->retrieve_hist(window[target].textbuffer->hist_pos);};
          return;
        case VK_DOWN:
          if (window[target].wintype==WINTYPE_TEXTBUFFER){
            window[target].textbuffer->hist_pos--;
            if (window[target].textbuffer->hist_pos<-1)
              window[target].textbuffer->hist_pos=-1;
            window[target].textbuffer->retrieve_hist(window[target].textbuffer->hist_pos);};
          return;
        case VK_RIGHT:
          if (window[target].cursor_pos<=window[target].input_text.Length()){
            window[target].cursor_pos++;
            if (window[target].wintype==WINTYPE_TEXTGRID){
              erase_cursor(target);
              window[target].textgrid->cursor.x+=window[target].font_width;
              draw_cursor(target);}
            else{
              if (window[target].textbuffer->sel_change||catching_up)
                window[target].textbuffer->Perform(EM_EXSETSEL,NULL,(LONG)&window[target].textbuffer->input_pos);
              window[target].textbuffer->input_pos.cpMin++;
              window[target].textbuffer->input_pos.cpMax++;
              Handled=false;};};
//              window[target].textbuffer->Perform(WM_VSCROLL,SB_BOTTOM,NULL);};};
            return;
        case VK_INSERT:
          set_insert(!insert);
          return;
        case VK_TAB:
          if (window[target].wintype==WINTYPE_TEXTBUFFER)
            tab_complete(target,window[target].input_text);
          return;
        default:
          GetKeyboardState(key_state);
          key_state[161]=129;
          key_state[222]=129;
          if ((key_state[162]>127)||(key_state[163]>127)){
            Handled=false;
            return;};
          wchar_t buffer[2];
          keyboard=GetKeyboardLayout(NULL);
          int result;
          if (win_version.dwMajorVersion>4)
            result=ToUnicodeEx(Msg.wParam,NULL,key_state,buffer,2,NULL,keyboard);
          else
            result=ToAsciiEx(Msg.wParam,NULL,key_state,(unsigned short *)buffer,NULL,keyboard);
          if (result==1&&buffer[0]>31){
            buffer[1]=0;
//            update_input(buffer,false);
            if (update_input(buffer,false)&&window[target].wintype==WINTYPE_TEXTBUFFER){
              if (catching_up){
                put_char(buffer[0]);
                window[target].textbuffer->post_output();}
              else{
                Handled=false;};};};
          return;};};};

  if (window[target].char_event){

    if (Msg.message==WM_KEYDOWN){
      Handled=true;
      if (!allowed_keys[Msg.wParam])
        return;
      window[target].char_event=false;
      done_event->type=EVTYPE_CHARINPUT;
      done_event->win=active_win;
      unsigned char key_state[256];
      HKL keyboard;
      switch (Msg.wParam){
        case VK_DELETE:
          done_event->val1=KEYCODE_DELETE;
          break;
        case VK_RETURN:
          done_event->val1=KEYCODE_RETURN;
          break;
        case VK_ESCAPE:
          done_event->val1=KEYCODE_ESCAPE;
          break;
        case VK_TAB:
          done_event->val1=KEYCODE_TAB;
          break;
        case VK_PRIOR:
          done_event->val1=KEYCODE_PAGEUP;
          break;
        case VK_NEXT:
          done_event->val1=KEYCODE_PAGEDOWN;
          break;
        case VK_HOME:
          done_event->val1=KEYCODE_HOME;
          break;
        case VK_END:
          done_event->val1=KEYCODE_END;
          break;
        case VK_UP:                     
          done_event->val1=KEYCODE_UP;
          break;
        case VK_DOWN:
          done_event->val1=KEYCODE_DOWN;
          break;
        case VK_LEFT:
          done_event->val1=KEYCODE_LEFT;
          break;
        case VK_RIGHT:
          done_event->val1=KEYCODE_RIGHT;
          break;
        case VK_F1:
          done_event->val1=KEYCODE_FUNC1;
          break;
        case VK_F2:
          done_event->val1=KEYCODE_FUNC2;
          break;
        case VK_F3:
          done_event->val1=KEYCODE_FUNC3;
          break;
        case VK_F4:
          done_event->val1=KEYCODE_FUNC4;
          break;
        case VK_F5:
          done_event->val1=KEYCODE_FUNC5;
          break;
        case VK_F6:
          done_event->val1=KEYCODE_FUNC6;
          break;
        case VK_F7:
          done_event->val1=KEYCODE_FUNC7;
          break;
        case VK_F8:
          done_event->val1=KEYCODE_FUNC8;
          break;
        case VK_F9:
          done_event->val1=KEYCODE_FUNC9;
          break;
        case VK_F10:
          done_event->val1=KEYCODE_FUNC10;
          break;
        case VK_F11:
          done_event->val1=KEYCODE_FUNC11;
          break;
        case VK_F12:
          done_event->val1=KEYCODE_FUNC12;
          break;
        case VK_NUMPAD0:
          done_event->val1='0';
          break;
        case VK_NUMPAD1:
          done_event->val1='1';
          break;
        case VK_NUMPAD2:
          done_event->val1='2';
          break;
        case VK_NUMPAD3:
          done_event->val1='3';
          break;
        case VK_NUMPAD4:
          done_event->val1='4';
          break;
        case VK_NUMPAD5:
          done_event->val1='5';
          break;
        case VK_NUMPAD6:
          done_event->val1='6';
          break;
        case VK_NUMPAD7:
          done_event->val1='7';
          break;
        case VK_NUMPAD8:
          done_event->val1='8';
          break;
        case VK_NUMPAD9:
          done_event->val1='9';
          break;
        default:
          GetKeyboardState(key_state);
          keyboard=GetKeyboardLayout(NULL);
          int result;
          if (win_version.dwMajorVersion>4)
            result=ToUnicodeEx(Msg.wParam,NULL,key_state,key_pressed,2,NULL,keyboard);
          else
            result=ToAsciiEx(Msg.wParam,NULL,key_state,(unsigned short *)key_pressed,NULL,keyboard);
          done_event->val1=key_pressed[0];
          if (result!=1){
            window[target].char_event=true;};};
      if (!window[target].char_event){
        if (window[target].wintype==WINTYPE_TEXTGRID)
          erase_cursor(target);
        for (int i=0;i<49;i++){
          if (window[i].in_use&&window[i].wintype==WINTYPE_TEXTGRID&&(window[i].char_event||window[i].line_event)){
            erase_cursor(i);};};
        clear_input_lines();
        MainForm->WaitTimer->Enabled=true;
        Resume();};};}

  else{
    if (Msg.message==WM_KEYDOWN){
      Handled=true;};};};
};
//----------------------------------------------------------------------------

bool GLK::update_input(WideString letters,bool on_screen)
{                                                  
int target=active_win-1;           
CHARRANGE tmp_pos;

if (insert||window[target].cursor_pos==window[target].input_text.Length()+1){
  if (window[target].input_text.Length()>=window[target].maxlen)
    return (false);
  window[target].input_text.Insert(letters,window[target].cursor_pos);
  if (window[target].wintype==WINTYPE_TEXTBUFFER&&window[target].textbuffer->sel_change)
   window[target].textbuffer->Perform(EM_EXSETSEL,NULL,(LONG)&window[target].textbuffer->input_pos);}
else{
  window[target].input_text=StuffString(window[target].input_text,window[target].cursor_pos,letters.Length(),letters);
  if (window[target].wintype==WINTYPE_TEXTBUFFER){
    window[target].textbuffer->input_pos.cpMax+=letters.Length();
    if (window[target].textbuffer->sel_change)
      window[target].textbuffer->Perform(EM_EXSETSEL,NULL,(LONG)&window[target].textbuffer->input_pos);
    window[target].textbuffer->input_pos.cpMax=window[target].textbuffer->input_pos.cpMin;};};
if (window[target].cursor_pos==1&&window[target].wintype==WINTYPE_TEXTBUFFER) {
 window[target].textbuffer->Perform(WM_SETREDRAW,false,NULL);
 need_paint = true;
 window[target].textbuffer->SelAttributes->Assign(window[target].font);
};
if (window[target].wintype==WINTYPE_TEXTGRID){
  erase_cursor(target);
  WideString out_text=window[target].input_text.SubString(window[target].cursor_pos,window[target].input_text.Length());
  window[target].textgrid->bitmap->Canvas->Lock();
  TextOutW(window[target].textgrid->bitmap->Canvas->Handle,window[target].textgrid->cursor.x,window[target].textgrid->cursor.y,out_text.c_bstr(),out_text.Length());
  window[target].textgrid->bitmap->Canvas->Unlock();
  window[target].textgrid->cursor.x+=window[target].font_width*letters.Length();
  draw_cursor(target);}
else{
  if (on_screen)
    window[target].textbuffer->Perform(EM_SETTEXTEX,(LONG)&unicode_text,(LONG)letters.c_bstr());
  window[target].textbuffer->input_pos.cpMin+=letters.Length();
  window[target].textbuffer->input_pos.cpMax+=letters.Length();};
window[target].cursor_pos+=letters.Length();
return (true);
};
//----------------------------------------------------------------------------

void GLK::select(EVENT *event)
{
do_select(event,true);
};
//----------------------------------------------------------------------------

void GLK::select_poll(EVENT *event)
{
do_select(event,false);
};
//----------------------------------------------------------------------------

void GLK::do_select(EVENT *event,bool suspend)
{
int prev_style[49];

if (suspend){
  Synchronize(setup_screen);
  flush_output();};
  
done_event=event;
done_event->type=EVTYPE_NONE;
done_event->win=0;
done_event->val1=0;
done_event->val2=0;

if (resize_pending){
  resize_pending=false;
  done_event->type=EVTYPE_ARRANGE;
  done_event->win=0;
  return;};

if (processed_loc!=pending_loc){
  catching_up=true;
  for (int i=0;i<49;i++){
    prev_style[i]=window[i].curr_style;
    if (window[i].line_event){
      do_set_style(i,STYLE_INPUT);};};
  do{
    Synchronize(CatchUp);
    processed_loc++;
    if (processed_loc>99)
      processed_loc=0;}
  while (processed_loc!=pending_loc);
  catching_up=false;
  for (int i=0;i<49;i++){
    if (prev_style[i]!=window[i].curr_style){
      do_set_style(i,prev_style[i]);};};
  if (done_event->type!=EVTYPE_NONE)
    return;};

if (hyper_pending){
  ProcessHyper(pending_htarget,pending_linkval);
  hyper_pending=false;
  return;};

if (mouse_pending){
  ProcessMouse(pending_target,pending_pos);
  mouse_pending=false;
  return;};

if (timer_pending){
  timer_pending=false;
  done_event->type=EVTYPE_TIMER;
  done_event->win=0;
  return;};
  
for (int i=0;i<10;i++){
  if (schannel[i].notify_pending){
    schannel[i].notify_pending=false;
    done_event->type=EVTYPE_SOUNDNOTIFY;
    done_event->win=0;
    done_event->val1=schannel[i].sound;
    done_event->val2=schannel[i].notify_val;
    schannel[i].notify_val=0;
    return;};};

if (suspend){
  if (input_style){
    for (int i=0;i<49;i++){
      prev_style[i]=window[i].curr_style;
      if (window[i].line_event){
        do_set_style(i,STYLE_INPUT);};};};
  Synchronize(setup_input);
  Synchronize(MainForm->toggle_waittimer);
  Suspend();
  saved=false;
  if (input_style&&!hard_quit){
    for (int i=0;i<49;i++){
      if (prev_style[i]!=window[i].curr_style){
        do_set_style(i,prev_style[i]);};};};};
};
//----------------------------------------------------------------------------

void __fastcall GLK::CatchUp()
{
AppMessage(pending_msg[processed_loc],NULL);
};
//----------------------------------------------------------------------------

bool GLK::save_file_dialog(char *name_buffer)
{
bool result;
plant_args(name_buffer,&result);
Synchronize (SaveFileDialog);
return (result);
};
//----------------------------------------------------------------------------

void __fastcall GLK::SaveFileDialog()
{
MainForm->toggle_waittimer();
if (MainForm->SaveGame->Execute()){
  if (MainForm->WarningMenu->Checked&&FileExists(MainForm->SaveGame->FileName)&&(Application->MessageBox("Overwrite this save game file?","File Exists!",MB_YESNO)==ID_NO))
    memset(args[1],0,1);
  else{
    memset(args[1],1,1);
    strcpy((char *)args[0],MainForm->SaveGame->FileName.c_str());
    MainForm->RestoreGame->FileName=MainForm->SaveGame->FileName;};}
else
  memset(args[1],0,1);
MainForm->WaitTimer->Enabled=true;
};
//----------------------------------------------------------------------------

bool GLK::save_data_file_dialog(char *name_buffer)
{
bool result;
plant_args(name_buffer,&result);
Synchronize (SaveDataFileDialog);
return (result);
};
//----------------------------------------------------------------------------

void __fastcall GLK::SaveDataFileDialog()
{
MainForm->toggle_waittimer();
if (MainForm->SaveData->Execute()){
  if (MainForm->WarningMenu->Checked&&FileExists(MainForm->SaveData->FileName)&&(Application->MessageBox("Overwrite this file?","File Exists!",MB_YESNO)==ID_NO))
    memset(args[1],0,1);
  else{
    memset(args[1],1,1);
    strcpy((char *)args[0],MainForm->SaveData->FileName.c_str());};}
else
  memset(args[1],0,1);
MainForm->WaitTimer->Enabled=true;
};
//----------------------------------------------------------------------------

bool GLK::restore_file_dialog(char *name_buffer)
{
bool result;
plant_args(name_buffer,&result);
Synchronize (RestoreFileDialog);
return (result);
};
//----------------------------------------------------------------------------

void __fastcall GLK::RestoreFileDialog()
{
MainForm->toggle_waittimer();
if (MainForm->RestoreGame->Execute()){
  memset(args[1],1,1);
  strcpy((char *)args[0],MainForm->RestoreGame->FileName.c_str());}
else
  memset(args[1],0,1);
MainForm->WaitTimer->Enabled=true;
};
//----------------------------------------------------------------------------

bool GLK::open_data_file_dialog(char *name_buffer)
{
bool result;
plant_args(name_buffer,&result);
Synchronize (OpenDataFileDialog);
return (result);
};
//----------------------------------------------------------------------------

void __fastcall GLK::OpenDataFileDialog()
{
MainForm->toggle_waittimer();
if (MainForm->OpenData->Execute()){
  memset(args[1],1,1);
  strcpy((char *)args[0],MainForm->OpenData->FileName.c_str());}
else
  memset(args[1],0,1);
MainForm->WaitTimer->Enabled=true;
};
//----------------------------------------------------------------------------

void GLK::do_set_style(int target,int val)
{
if (window[target].font->Name!="Zork"){
  if (window[target].wintype==WINTYPE_TEXTBUFFER)
    window[target].font->Assign(prop_font);
  else{
    window[target].font->Assign(fixed_font);
    if (char_graphics)
      window[target].font->Name="Courier";};};

if (window[target].style[val].weight>0)
  window[target].font->Style=window[target].font->Style<<fsBold;
if (window[target].style[val].oblique)
  window[target].font->Style=window[target].font->Style<<fsItalic;
if (!window[target].style[val].proportional){
  if (char_graphics)
    window[target].font->Name="Courier";
  else
    window[target].font->Name=fixed_font->Name;
  window[target].font->Size=fixed_font->Size;};
window[target].font->Size=window[target].font->Size+window[target].style[val].size;
window[target].font->Color=window[target].style[val].text_color;
window[target].color=window[target].style[val].back_color;
window[target].reverse=window[target].style[val].reverse_color;

window[target].para_format.dxStartIndent=(window[target].style[val].indentation*50);
window[target].para_format.dxOffset=(-window[target].style[val].para_indentation*50);
switch (window[target].style[val].justification){
  case STYLEHINT_JUST_LEFTRIGHT:
    window[target].para_format.wAlignment=PFA_JUSTIFY;     
    break;
  case STYLEHINT_JUST_CENTERED:
    window[target].para_format.wAlignment=PFA_CENTER;
    break;
  case STYLEHINT_JUST_RIGHTFLUSH:
    window[target].para_format.wAlignment=PFA_RIGHT;
    break;
  default:
    window[target].para_format.wAlignment=PFA_LEFT;};
window[target].font_width=font_width(window[target].font);
window[target].font_height=font_height(window[target].font);

if (window[target].wintype==WINTYPE_TEXTGRID){
  plant_args(&target);
  Synchronize(SetStyle);};
window[target].curr_style=val;  
};
//----------------------------------------------------------------------------

void __fastcall GLK::SetStyle()
{
int target;
dig_args(&target,INT);

window[target].textgrid->bitmap->Canvas->Lock();
window[target].textgrid->bitmap->Canvas->Font->Assign(window[target].font);
window[target].textgrid->bitmap->Canvas->Brush->Color=window[target].color;
window[target].textgrid->bitmap->Canvas->Unlock();
};
//----------------------------------------------------------------------------

void GLK::stylehint_set(int wintype,int styl,int hint,int val)
{
if (styl<0||styl>10)
  return;

STYLE *style;
switch(wintype){
  case WINTYPE_ALLTYPES:
    do_stylehint(textbuffer_style,styl,hint,val);
    do_stylehint(textgrid_style,styl,hint,val);
    return;
  case WINTYPE_TEXTBUFFER:
    style=textbuffer_style;
    break;
  case WINTYPE_TEXTGRID:
    style=textgrid_style;  
    break;
  default:
    return;};
do_stylehint(style,styl,hint,val);
};
//----------------------------------------------------------------------------

void GLK::stylehint_clear(int wintype,int styl,int hint)
{
if (styl<0||styl>10)
  return;

STYLE *style;
switch(wintype){
  case WINTYPE_ALLTYPES:
    stylehint_clear(WINTYPE_TEXTBUFFER,styl,hint);
    stylehint_clear(WINTYPE_TEXTGRID,styl,hint);
    return;
  case WINTYPE_TEXTBUFFER:
    style=&textbuffer_style[styl];
    break;
  case WINTYPE_TEXTGRID:
    style=&textgrid_style[styl];
    break;
  default:
    return;};

switch (hint){
  case STYLEHINT_INDENTATION:
    style->indentation=def_style[styl].indentation;
    return;
  case STYLEHINT_PARAINDENTATION:
    style->para_indentation=def_style[styl].para_indentation;
    return;
  case STYLEHINT_JUSTIFICATION:
    style->justification=def_style[styl].justification;
    return;
  case STYLEHINT_SIZE:
    style->size=def_style[styl].size;
    return;
  case STYLEHINT_OBLIQUE:
    style->oblique=def_style[styl].oblique;
    return;
  case STYLEHINT_PROPORTIONAL:
    style->proportional=def_style[styl].proportional;
    break;
  case STYLEHINT_TEXTCOLOR:
    style->text_color=prop_font->Color;
    break;
  case STYLEHINT_BACKCOLOR:
    plant_args(&style->back_color);
    Synchronize(DefaultBackgroundColor);
    break;
  case STYLEHINT_REVERSECOLOR:
    style->reverse_color=def_style[styl].reverse_color;};
};
//----------------------------------------------------------------------------

bool GLK::style_distinguish(int win,int style1,int style2)
{
if (win<1||win>49||!window[win-1].in_use||window[win-1].wintype<WINTYPE_TEXTBUFFER||window[win-1].wintype>WINTYPE_TEXTGRID)
  return (false);
int target=win-1;

if (window[target].style[style1].indentation!=window[target].style[style1].indentation)
  return (true);
if (window[target].style[style1].para_indentation!=window[target].style[style1].para_indentation)
  return (true);
if (window[target].style[style1].justification!=window[target].style[style1].justification)
  return (true);
if (window[target].style[style1].size!=window[target].style[style1].size)
  return (true);
if (window[target].style[style1].weight!=window[target].style[style1].weight)
  return (true);
if (window[target].style[style1].oblique!=window[target].style[style1].oblique)
  return (true);
if (window[target].style[style1].proportional!=window[target].style[style1].proportional)
  return (true);
if (window[target].style[style1].text_color!=window[target].style[style1].text_color)
  return (true);
if (window[target].style[style1].back_color!=window[target].style[style1].back_color)
  return (true);
if (window[target].style[style1].reverse_color!=window[target].style[style1].reverse_color)
  return (true);

return (false);
};
//---------------------------------------------------------------------------

void __fastcall GLK::DefaultBackgroundColor()
{
TColor color;
color=MainForm->Color;
memcpy(args[0],&color,4);
};
//----------------------------------------------------------------------------

void GLK::suspend_me()
{
done->SetEvent();
Suspend();
};
//----------------------------------------------------------------------------
                                   
void GLK::do_command(String command,bool resume)
{
int target=active_win-1;

if (target>=0&&window[target].wintype==WINTYPE_TEXTBUFFER&&window[target].line_event){
  window[target].textbuffer->input_pos.cpMin-=(window[target].cursor_pos-1);
  window[target].textbuffer->input_pos.cpMax=window[target].textbuffer->input_pos.cpMin+window[target].input_text.Length();
  window[target].cursor_pos=1;
  window[target].input_text="";
  window[target].textbuffer->Perform(EM_EXSETSEL,NULL,(LONG)&window[target].textbuffer->input_pos);
  window[target].textbuffer->Perform(EM_SETTEXTEX,(LONG)&unicode_text,(LONG)blank);
  window[target].textbuffer->input_pos.cpMax=window[target].textbuffer->input_pos.cpMin;
  update_input(command);
  if (resume){
    if (window[target].line_input_echo){
      window[target].textbuffer->Perform(EM_EXSETSEL,NULL,(LONG)&set_range);
      window[target].textbuffer->Perform(EM_SETTEXTEX,(LONG)&unicode_text,(LONG)lf);}
    else{
      window[target].textbuffer->input_pos.cpMin-=(window[target].cursor_pos-1);
      window[target].textbuffer->input_pos.cpMax=window[target].textbuffer->input_pos.cpMin+window[target].input_text.Length();
      window[target].textbuffer->Perform(EM_EXSETSEL,NULL,(LONG)&window[target].textbuffer->input_pos);
      window[target].textbuffer->Perform(EM_SETTEXTEX,(LONG)&unicode_text,(LONG)blank);};
    memcpy(window[target].buf,window[target].input_text.c_bstr(),4*window[target].input_text.Length());
    window[target].textbuffer->add_to_hist(window[target].input_text);
    window[target].line_event=false;
    done_event->type=EVTYPE_LINEINPUT;
    done_event->win=active_win;
    process_line_input(target,13,done_event);};};
};
//---------------------------------------------------------------------------

void __fastcall GLK::ScriptFileDialog()
{
MainForm->toggle_waittimer();
if (scripted)
  memset(args[1],FILEMODE_WRITEAPPEND,1);

else{
  if (MainForm->ScriptDialog->Execute()){
    if (FileExists(MainForm->ScriptDialog->FileName)){
      int answer=Application->MessageBox("The requested script file already exists.  Would you like to append text to this file rather than overwrite its contents? (YES to append, NO to overwrite!)","File Exists",MB_YESNOCANCEL);
      if (answer==IDCANCEL){
        memset(args[1],false,1);
        return;}
      else{
        scripted=true;
        if (answer==IDYES)
          memset(args[1],FILEMODE_WRITEAPPEND,1);
        else{
          DeleteFile(MainForm->ScriptDialog->FileName);
          int handle = FileCreate(MainForm->ScriptDialog->FileName);
          FileClose(handle);
          memset(args[1],FILEMODE_WRITEAPPEND,1);};};}
    else{
      int handle = FileCreate(MainForm->ScriptDialog->FileName);
      FileClose(handle);
      memset(args[1],FILEMODE_WRITEAPPEND,1);
      scripted=true;};}
  else{
    memset(args[1],false,1);
    return;};};
      
strcpy((char *)args[0],MainForm->ScriptDialog->FileName.c_str());
MainForm->ScriptDialog->FileName="";
MainForm->WaitTimer->Enabled=true;
};
//----------------------------------------------------------------------------

unsigned char GLK::script_file_dialog(char *name_buffer)
{
unsigned char result;
plant_args(name_buffer,&result);
Synchronize (ScriptFileDialog);
return (result);
};
//----------------------------------------------------------------------------

void GLK::transcript_menu(bool check)
{
plant_args(&check);
Synchronize(TranscriptMenu);
};
//----------------------------------------------------------------------------

void __fastcall GLK::TranscriptMenu()
{
bool check;
dig_args(&check,BOOL);
MainForm->TranscriptMenu->Checked=check;
};
//----------------------------------------------------------------------------

void GLK::copy_text()
{
int target=active_win-1;
if (window[target].wintype==WINTYPE_TEXTBUFFER)
  window[target].textbuffer->CopyToClipboard();
};
//----------------------------------------------------------------------------

void GLK::paste_text()
{
int target=active_win-1;
if (window[target].wintype==WINTYPE_TEXTBUFFER&&clipboard->HasFormat(CF_TEXT)){
  if (clipboard->AsText.Length()>(window[target].maxlen-window[target].input_text.Length()))
    clipboard->AsText=clipboard->AsText.SetLength(window[target].maxlen-window[target].input_text.Length());
  int cr=clipboard->AsText.Pos("\n");
  if (cr)
    clipboard->AsText=clipboard->AsText.SetLength(cr-2);
  OpenClipboard(NULL);
  HANDLE lock=GetClipboardData(CF_UNICODETEXT);
  wchar_t *tmp;            
  (void *)tmp=GlobalLock(lock);
  update_input(tmp);                                                
  GlobalUnlock(lock);
  CloseClipboard();};
};
//----------------------------------------------------------------------------

void GLK::select_all()
{
int target=active_win-1;
if (window[target].wintype==WINTYPE_TEXTBUFFER)
  window[target].textbuffer->SelectAll();
};
//----------------------------------------------------------------------------

void GLK::find_text()
{
int target=active_win-1;
if (window[target].wintype==WINTYPE_TEXTBUFFER){
  int find_pos;
  int length;
  if (window[target].textbuffer->FindTextEx(MainForm->FindDialog->FindText,window[target].textbuffer->SelStart+1,MainForm->FindDialog->Options,find_pos,length)){
    window[target].textbuffer->SelStart=find_pos;
    window[target].textbuffer->SelLength=length;
    POINT text_point;
    window[target].textbuffer->Perform(EM_POSFROMCHAR,(LONG)&text_point,find_pos);}
  else{
    Application->MessageBox("The text you entered was not found.","Not found.",MB_OK);};};
};
//----------------------------------------------------------------------------

void GLK::set_insert(bool mode)
{
insert=mode;
if (insert)
  MainForm->StatusBar->Panels->Items[1]->Text="INS";
else
  MainForm->StatusBar->Panels->Items[1]->Text="OVR";
};
//---------------------------------------------------------------------------

void GLK::window_move_cursor(int win,int xpos,int ypos)
{
if (win<1||win>49||!window[win-1].in_use||window[win-1].wintype!=WINTYPE_TEXTGRID)
  return;
int target=win-1;

window[target].textgrid->cursor.x=xpos*window[target].font_width;
window[target].textgrid->cursor.y=ypos*window[target].font_height;
};
//---------------------------------------------------------------------------

void GLK::window_clear(int win)
{
if (win<1||win>49||!window[win-1].in_use||window[win-1].wintype<WINTYPE_TEXTBUFFER)
  return;
int target=win-1;

plant_args(&target);
Synchronize(WindowClear);
};
//---------------------------------------------------------------------------

void __fastcall GLK::WindowClear()
{
int target;
dig_args(&target,INT);

if (window[target].wintype==WINTYPE_TEXTBUFFER){
  if (window[target].style[0].reverse_color){
    window[target].textbuffer->clear(window[target].style[0].text_color);}
  else{
    window[target].textbuffer->clear(window[target].style[0].back_color);};
  return;};

if (window[target].wintype==WINTYPE_TEXTGRID){
  if (blank_reverse&&window[target].style[0].reverse_color){
    window[target].textgrid->bitmap->Canvas->Brush->Color=window[target].font->Color;
    window[target].textgrid->clear();
    window[target].textgrid->bitmap->Canvas->Brush->Color=window[target].color;
    return;};};

window[target].textgrid->clear();
};
//----------------------------------------------------------------------------

void GLK::window_stylehint_set(int win,int styl,int hint,int val)
{
if (win<1||win>49||!window[win-1].in_use||window[win-1].wintype<WINTYPE_TEXTBUFFER||window[win-1].wintype==WINTYPE_GRAPHICS)
  return;
int target=win-1;

STYLE *style;
style=window[target].style;
do_stylehint(style,styl,hint,val);
if (window[target].curr_style==styl)
  do_set_style(target,styl);
};
//----------------------------------------------------------------------------

void GLK::do_stylehint(STYLE *style,int styl,int hint,int val)
{
switch (hint){
  case STYLEHINT_INDENTATION:
    style[styl].indentation=val;
    break;
  case STYLEHINT_PARAINDENTATION:
    style[styl].para_indentation=val;
    break;
  case STYLEHINT_JUSTIFICATION:
    style[styl].justification=val;
    break;
  case STYLEHINT_SIZE:
    style[styl].size=val;
    break;
  case STYLEHINT_WEIGHT:
    style[styl].weight=val;
    break;
  case STYLEHINT_OBLIQUE:
    style[styl].oblique=(val==1);
    break;
  case STYLEHINT_PROPORTIONAL:
    style[styl].proportional=(val==1);
    break;
  case STYLEHINT_TEXTCOLOR:
    style[styl].text_color=val;
    break;
  case STYLEHINT_BACKCOLOR:
    style[styl].back_color=val;
    break;
  case STYLEHINT_REVERSECOLOR:
    style[styl].reverse_color=(val==1);
    break;};
};
//----------------------------------------------------------------------------

void GLK::set_style(int val)
{
set_style_stream(active_stream,val);
};
//----------------------------------------------------------------------------

void GLK::set_style_stream(int str,int val)
{
if (str<1||str>20||!stream[str-1].in_use||stream[str-1].type!=STREAM_WINDOW)
  return;
int target=stream[str-1].win-1;

do_set_style(target,val);
};
//----------------------------------------------------------------------------

void GLK::request_char_event(int win)
{
if (win<1||win>49||!window[win-1].in_use||window[win-1].wintype<WINTYPE_TEXTBUFFER||window[win-1].wintype==WINTYPE_GRAPHICS||window[win-1].line_event)
  return;
int target=win-1;

if (!window[target].line_event){
  window[target].char_event=true;
  active_win=win;};
};
//----------------------------------------------------------------------------

void __fastcall GLK::RecordFileDialog()
{
if (recorded)
  memset(args[1],2,1);

else{
  if (MainForm->RecordDialog->Execute()){
    if (FileExists(MainForm->RecordDialog->FileName)){
      int answer=Application->MessageBox("The requested recording already exists.  Would you like to append to this recording?","File Exists",MB_YESNOCANCEL);
      if (answer==IDCANCEL){
        memset(args[1],0,1);
        return;}
      else{
        recorded=true;
        if (answer==IDYES)
          memset(args[1],2,1);
        else
          memset(args[1],1,1);};}
    else
      memset(args[1],1,1);};};
      
strcpy((char *)args[0],MainForm->RecordDialog->FileName.c_str());
};
//----------------------------------------------------------------------------

unsigned char GLK::record_file_dialog(char *name_buffer)
{
unsigned char result;
plant_args(name_buffer,&result);
Synchronize (RecordFileDialog);
return (result);
};
//----------------------------------------------------------------------------

bool GLK::play_file_dialog(char *name_buffer)
{
bool result;
plant_args(name_buffer,&result);
Synchronize (PlayFileDialog);
return (result);
};
//----------------------------------------------------------------------------

void __fastcall GLK::PlayFileDialog()
{
if (MainForm->PlayDialog->Execute()){
  memset(args[1],1,1);
  strcpy((char *)args[0],MainForm->PlayDialog->FileName.c_str());}
else
  memset(args[1],0,1);                    
};
///----------------------------------------------------------------------------

void GLK::flush_output()
{
for (int i=0;i<49;i++)
  if (window[i].in_use&&window[i].wintype>WINTYPE_TEXTBUFFER&&window[i].textgrid->changed)
    Synchronize(window[i].textgrid->post_output);
for (int i=0;i<49;i++)
  if (window[i].in_use&&window[i].wintype==WINTYPE_TEXTBUFFER)
    Synchronize(window[i].textbuffer->post_output);
};
//----------------------------------------------------------------------------

void GLK::signal_resize()
{
if (Suspended){
  done_event->type=EVTYPE_ARRANGE;
  done_event->win=0;
  MainForm->WaitTimer->Enabled=true;
  clear_input_lines();
  Resume();}
else{
  resize_pending=true;};
};
//----------------------------------------------------------------------------

void GLK::draw_cursor(int target)
{
window[target].textgrid->bitmap->Canvas->Lock();
if (window[target].reverse)
  window[target].textgrid->bitmap->Canvas->Pen->Color=window[target].color;
else
  window[target].textgrid->bitmap->Canvas->Pen->Color=window[target].font->Color;
window[target].textgrid->bitmap->Canvas->MoveTo(window[target].textgrid->cursor.x,window[target].textgrid->cursor.y+window[target].font_height-2);
window[target].textgrid->bitmap->Canvas->LineTo(window[target].textgrid->cursor.x+window[target].font_width,window[target].textgrid->cursor.y+window[target].font_height-2);
window[target].textgrid->bitmap->Canvas->Unlock();
window[target].textgrid->Repaint();
};
//----------------------------------------------------------------------------

int GLK::stream_get_current()
{
return (active_stream);
};
//----------------------------------------------------------------------------

void GLK::erase_cursor(int target)
{
window[target].textgrid->bitmap->Canvas->Lock();
if (window[target].reverse)
  window[target].textgrid->bitmap->Canvas->Pen->Color=window[target].font->Color;
else
  window[target].textgrid->bitmap->Canvas->Pen->Color=window[target].color;
window[target].textgrid->bitmap->Canvas->MoveTo(window[target].textgrid->cursor.x,window[target].textgrid->cursor.y+window[target].font_height-2);
window[target].textgrid->bitmap->Canvas->LineTo(window[target].textgrid->cursor.x+window[target].font_width,window[target].textgrid->cursor.y+window[target].font_height-2);
window[target].textgrid->bitmap->Canvas->Unlock();
window[target].textgrid->Repaint();
};
//----------------------------------------------------------------------------

void __fastcall GLK::setup_input()
{
for (int i=0;i<49;i++){
  if (window[i].in_use){
    if (window[i].wintype==WINTYPE_TEXTBUFFER){
      if (window[i].line_event){
         window[i].textbuffer->SelAttributes->Assign(window[i].font);


        if (window[i].reverse){
          window[i].textbuffer->SelAttributes2->Color=window[i].color;
          window[i].textbuffer->SelAttributes2->BackColor=window[i].font->Color;}
        else{
          window[i].textbuffer->SelAttributes2->Color=window[i].font->Color;
          window[i].textbuffer->SelAttributes2->BackColor=window[i].color;};};
        continue;};
    if (window[i].wintype==WINTYPE_TEXTGRID){
      if (window[i].line_event){
        if (window[i].reverse){
          window[i].textgrid->bitmap->Canvas->Font->Color=window[i].color;
          window[i].textgrid->bitmap->Canvas->Brush->Color=window[i].font->Color;}
        else{
          window[i].textgrid->bitmap->Canvas->Font->Color=window[i].font->Color;
          window[i].textgrid->bitmap->Canvas->Brush->Color=window[i].color;};
        draw_cursor(i);}
      else{
        if (window[i].char_event&&char_cursor){
          draw_cursor(i);};};};};};
};
//----------------------------------------------------------------------------

int GLK::schannel_create(int rock)
{
if (!sound_avail)
  return (false);

int target=-1;
for (int i=0;i<10;i++)
  if (!schannel[i].in_use){
    schannel[i].in_use=true;
    schannel[i].rock=rock;
    schannel[i].volume=100;
    target=i;
    break;};

if (target==-1)
  return (false);
else
  return (target+1);
};
//----------------------------------------------------------------------------

void GLK::check_focus(int win)
{
if (win<1||win>49||!window[win-1].in_use||window[win-1].wintype<WINTYPE_TEXTBUFFER||window[win-1].wintype==WINTYPE_GRAPHICS)
  return;
int target=win-1;         

if (window[target].char_event||window[target].line_event){
  active_win=win;}
else{
  if (window[active_win-1].wintype==WINTYPE_TEXTBUFFER)
    window[active_win-1].textbuffer->SetFocus();};
};
//----------------------------------------------------------------------------

bool GLK::schannel_play_ext(int chan,int snd,int repeats,int notify)
{
if (chan<1||chan>10||!schannel[chan-1].in_use)
  return (false);
int target=chan-1;

schannel_stop(chan);
         
int type,len;

type=find_resource(SND,snd,story_file);
if (type>=FORM){
  len=restore_long(story_file)+8;
  if (type==FORM)
    story_file->Position-=8;
  schannel[target].buffer=malloc(len);
  story_file->Read(schannel[target].buffer,len);}
else{
  String base="SND";
  base+=snd;
  String filename=base+".aif";
  if (FileExists(filename)){
    type=FORM;}
  else{
    filename=base+".aiff";
    if (FileExists(filename)){
      type=FORM;}
    else{
      base="MUS";
      base+=snd;
      filename=base+".ogg";
      if (FileExists(filename)){
        type=OGGV;}
      else{
        filename=base+".mod";
        if (FileExists(filename)){
          type=MOD_MUSIC;}
        else{
          return (false);};};};};
  TFileStream *file=new TFileStream(filename,fmOpenRead|fmShareDenyWrite);
  len=file->Size;
  schannel[target].buffer=malloc(len);
  file->Read(schannel[target].buffer,len);
  delete file;};
  
schannel[target].type=type;
schannel[target].playing=true;
int playflags=0;
if (repeats==-1)
  playflags=BASS_SAMPLE_LOOP;
if (type==MOD_MUSIC)
  schannel[target].hmusic=BASS_MusicLoad(true,schannel[target].buffer,0,len,playflags,0);
else
  schannel[target].hstream=BASS_StreamCreateFile(true,schannel[target].buffer,0,len,playflags);
if (BASS_ErrorGetCode())
  return (false);
if (type==MOD_MUSIC)
  BASS_ChannelSetAttributes(schannel[target].hmusic,-1,schannel[target].volume,-1);
else
  BASS_ChannelSetAttributes(schannel[target].hstream,-1,schannel[target].volume,-1);
schannel[target].repeats=repeats;
schannel[target].notify_val=notify;
if (repeats>1||notify){
  if (type==MOD_MUSIC)
    BASS_ChannelSetSync(schannel[target].hmusic,BASS_SYNC_END,0,&sound_sync,target);
  else
    BASS_ChannelSetSync(schannel[target].hstream,BASS_SYNC_END,0,&sound_sync,target);};
if (type==MOD_MUSIC)
  BASS_ChannelPlay(schannel[target].hmusic,true);
else
  BASS_ChannelPlay(schannel[target].hstream,true);
if (BASS_ErrorGetCode())
  return (false);

return (true);
};
//----------------------------------------------------------------------------

void CALLBACK GLK::sound_sync(HSYNC handle,unsigned long channel,unsigned long data,unsigned long target)
{
glk->schannel[target].repeats--;
if (glk->schannel[target].repeats>0){
  if (glk->schannel[target].type==MOD_MUSIC)
    BASS_ChannelPlay(glk->schannel[target].hmusic,true);
  else
    BASS_ChannelPlay(glk->schannel[target].hstream,true);
  return;};

if (glk->schannel[target].notify_val){
  if (!glk->Suspended&&!glk->schannel[target].notify_pending){
    glk->schannel[target].notify_pending=true;
    return;};};

glk->done_event->type=EVTYPE_SOUNDNOTIFY;
glk->done_event->win=0;
glk->done_event->val1=target+1;
glk->done_event->val2=glk->schannel[target].notify_val;
MainForm->WaitTimer->Enabled=true;
glk->clear_input_lines();
glk->Resume();
};
//----------------------------------------------------------------------------

bool GLK::schannel_play(int chan,int snd)
{
return (schannel_play_ext(chan,snd,1,false));
};
//----------------------------------------------------------------------------

void GLK::schannel_stop(int chan)
{
if (chan<1||chan>10||!schannel[chan-1].in_use)
  return;

int target=chan-1;

if (schannel[target].notify_val)
  schannel[target].notify_val=0;

if (schannel[target].playing){
  if (schannel[target].type==MOD_MUSIC){
    BASS_ChannelStop(schannel[target].hmusic);
    BASS_MusicFree(schannel[target].hmusic);}
  else{
    BASS_ChannelStop(schannel[target].hstream);
    BASS_StreamFree(schannel[target].hstream);};
  schannel[target].playing=false;
  free(schannel[target].buffer);};
};
//----------------------------------------------------------------------------

void GLK::schannel_destroy(int chan)
{
if (chan<1||chan>10||!sound_avail)
  return;

schannel_stop(chan);

int target=chan-1;
schannel[target].in_use=false;
schannel[target].notify_pending=false;
};
//----------------------------------------------------------------------------

void GLK::schannel_set_volume(int chan,int vol)
{
if (chan<1||chan>10||!schannel[chan-1].in_use||vol<0)
  return;
if (vol>65536)
  vol=65536;

int target=chan-1;

if (vol==0)
  schannel[target].volume=0;
else
  schannel[target].volume=vol/655.36;
  
if (schannel[target].playing){
  if (schannel[target].type==MOD_MUSIC){
    BASS_ChannelSetAttributes(schannel[target].hmusic,-1,schannel[target].volume,-1);}
  else{
    BASS_ChannelSetAttributes(schannel[target].hstream,-1,schannel[target].volume,-1);};};
};
//----------------------------------------------------------------------------

void GLK::window_get_cursor(int win,int &xpos,int &ypos)
{
xpos=0;
ypos=0;
if (win<1||win>49||!window[win-1].in_use||window[win-1].wintype!=WINTYPE_TEXTGRID)
  return;
int target=win-1;

xpos=window[target].textgrid->cursor.x/window[target].font_width;
ypos=window[target].textgrid->cursor.y/window[target].font_height;
};
//----------------------------------------------------------------------------

void GLK::sound_load_hint(int snd,bool flag)
{
};
//----------------------------------------------------------------------------

void __fastcall GLK::signal_timer(TObject *Sender)
{
if (Suspended){
  done_event->win=0;
  done_event->type=EVTYPE_TIMER;
  clear_input_lines();
  MainForm->WaitTimer->Enabled=true;
  Resume();}
else{
  timer_pending=true;};
};
//----------------------------------------------------------------------------

void GLK::request_timer_events(unsigned int millisecs)
{
if (millisecs==0){
  timer->Enabled=false;
  timer_pending=false;
  return;};

timer->Interval=millisecs;
timer->Enabled=true;
};
//----------------------------------------------------------------------------

WideString GLK::window_get_input(int win)
{
if (win<1||win>49||!window[win-1].in_use||window[win-1].wintype<WINTYPE_TEXTBUFFER||window[win-1].wintype==WINTYPE_GRAPHICS)
  return ("");
int target=win-1;

if (!(window[target].line_event||window[target].char_event))
  return ("");

return (window[target].input_text);
};
//----------------------------------------------------------------------------

void GLK::window_char_graphics(int win,bool enable)
{
static String normal_font[10];
static TFontCharset normal_charset[10];

if (win<1||win>49||!window[win-1].in_use||window[win-1].wintype<WINTYPE_TEXTBUFFER||window[win-1].wintype==WINTYPE_GRAPHICS)
  return;
int target=win-1;

if (enable&&window[target].font->Name!="Zork"){
  normal_font[target]=window[target].font->Name;
  normal_charset[target]=window[target].font->Charset;
  window[target].font->Name="Zork";
  window[target].font->Charset=SYMBOL_CHARSET;
  window[target].font_width=font_width(window[target].font);
  window[target].font_height=font_height(window[target].font);
  if (window[target].wintype==WINTYPE_TEXTGRID){
    plant_args(&target);
    Synchronize(SetStyle);};
  return;};

if (!enable&&window[target].font->Name=="Zork"){
  window[target].font->Name=normal_font[target];
  window[target].font->Charset=normal_charset[target];
  window[target].font_width=font_width(window[target].font);
  window[target].font_height=font_height(window[target].font);
  if (window[target].wintype==WINTYPE_TEXTGRID){
    plant_args(&target);
    Synchronize(SetStyle);};};
};
//---------------------------------------------------------------------------

void GLK::window_set_background_color(int win,TColor color)
{
if (win<1||win>49||!window[win-1].in_use||window[win-1].wintype!=WINTYPE_GRAPHICS)
  return;
int target=win-1;

window[target].color=color;
plant_args(&target,&color);
Synchronize(WindowSetBackgroundColor);
};
//---------------------------------------------------------------------------

void __fastcall GLK::WindowSetBackgroundColor()
{
int target;
TColor color;
dig_args(&target,INT,&color,INT);

window[target].textgrid->bitmap->Canvas->Brush->Color=color;
};
//---------------------------------------------------------------------------

void GLK::size_win(int target,int left,int top,int width,int height)
{
if (left!=UNCHANGED)
  window[target].left=left;
if (top!=UNCHANGED)
  window[target].top=top;
if (width!=UNCHANGED){
  window[target].width=width;
  if (window[target].wintype==WINTYPE_TEXTGRID||window[target].wintype==WINTYPE_GRAPHICS){
    window[target].textgrid->changed=true;
    window[target].textgrid->bitmap->Width=width;
    window[target].textgrid->fill_rect.right=width;};};
if (height!=UNCHANGED){
  window[target].height=height;
  if (window[target].wintype==WINTYPE_TEXTGRID||window[target].wintype==WINTYPE_GRAPHICS){
    window[target].textgrid->changed=true;
    window[target].textgrid->bitmap->Height=height;
    window[target].textgrid->fill_rect.bottom=height;};};
};
//---------------------------------------------------------------------------

void __fastcall GLK::setup_screen()
{
for (int i=0;i<49;i++){
  if (window[i].in_use&&window[i].wintype!=WINTYPE_PAIR){
    bool updated=false;
    if (window[i].window->Left!=window[i].left){
      window[i].window->Left=window[i].left;
      updated=true;};
    if (window[i].window->Top!=window[i].top){
      window[i].window->Top=window[i].top;
      updated=true;};
    if (window[i].window->Width!=window[i].width){
      window[i].window->Width=window[i].width;
      updated=true;};                              
    if (window[i].window->Height!=window[i].height){
      window[i].window->Height=window[i].height;
      updated=true;};
    if (updated&&window[i].wintype==WINTYPE_TEXTBUFFER){
      window[i].textbuffer->Visible=false;
      window[i].textbuffer->Visible=true;};}; };

if (repaint){
  MainForm->Perform(WM_SETREDRAW,true,NULL);
  for (int i=0;i<49;i++){
    if (window[i].in_use&&window[i].wintype==WINTYPE_TEXTBUFFER){
      window[i].textbuffer->Visible=false;
      window[i].textbuffer->Visible=true;};};
  MainForm->Repaint();
  repaint=false;};
};
//----------------------------------------------------------------------------

void GLK::MouseDownTextBuffer(int target)
{
CHARRANGE new_pos;
window[target].textbuffer->Perform(EM_EXGETSEL,0,(LONG)&new_pos);
if (new_pos.cpMin>(window[target].textbuffer->input_pos.cpMin-window[target].cursor_pos)){
  window[target].cursor_pos+=new_pos.cpMin-window[target].textbuffer->input_pos.cpMin;
  window[target].textbuffer->input_pos=new_pos;};
};
//----------------------------------------------------------------------------

void GLK::process_line_input(int target,unsigned char term_char,EVENT *event,bool to_hist)
{
if (window[target].wintype==WINTYPE_TEXTBUFFER&&to_hist){
  window[target].textbuffer->add_to_hist(window[target].input_text);};

memcpy(window[target].buf,window[target].input_text.c_bstr(),2*window[target].input_text.Length());
window[target].buf[window[target].input_text.Length()]=0;
window[target].line_event=false;                        
event->type=EVTYPE_LINEINPUT;
event->win=target+1;
event->val1=window[target].input_text.Length();
event->val2=translate_keycode(term_char);
stream[window[target].stream-1].readcount+=event->val1;

if (window[target].echo_stream){
  window[target].input_text+="\n";
  put_string_stream(window[target].echo_stream,window[target].input_text.c_bstr());};

MainForm->WaitTimer->Enabled=true;
Resume();
};
//----------------------------------------------------------------------------

void GLK::request_mouse_event(int win)
{
if (win<1||win>49||!window[win-1].in_use||window[win-1].wintype<WINTYPE_TEXTGRID)
  return;
int target=win-1;

window[target].textgrid->mouse_event=true;
};
//----------------------------------------------------------------------------

void GLK::cancel_mouse_event(int win)
{
if (win<1||win>49||!window[win-1].in_use||window[win-1].wintype<WINTYPE_TEXTGRID)
  return;
int target=win-1;

window[target].textgrid->mouse_event=false;
};
//----------------------------------------------------------------------------

void GLK::cancel_char_event(int win)
{
if (win<1||win>49||!window[win-1].in_use||window[win-1].wintype<WINTYPE_TEXTBUFFER||window[win-1].wintype==WINTYPE_GRAPHICS)
  return;
int target=win-1;

window[target].char_event=false;
};
//----------------------------------------------------------------------------

void GLK::ProcessMouse(int target,TPoint pos)
{
if (!Suspended&&!mouse_pending){
  mouse_pending=true;
  pending_target=target;
  pending_pos.x=pos.x;
  pending_pos.y=pos.y;
  return;};

done_event->type=EVTYPE_MOUSEINPUT;
done_event->win=target+1;
if (window[target].wintype==WINTYPE_TEXTGRID){
  done_event->val1=(pos.x/window[target].font_width);
  done_event->val2=(pos.y/window[target].font_height);}
else{
  done_event->val1=pos.x;
  done_event->val2=pos.y;};
clear_input_lines();
MainForm->WaitTimer->Enabled=true;
Resume();
};
//----------------------------------------------------------------------------

void GLK::ProcessHyper(int target,int linkval)
{
if (!Suspended&&!hyper_pending){
  hyper_pending=true;
  pending_htarget=target;
  pending_linkval=linkval;
  return;};

done_event->type=EVTYPE_HYPERLINK;
done_event->win=target+1;
done_event->val1=linkval;
done_event->val2=0;
clear_input_lines();
MainForm->WaitTimer->Enabled=true;
Resume();
};
//----------------------------------------------------------------------------

bool GLK::check_unicode(int win,wchar_t char_number)
{
if (win<1||win>49||!window[win-1].in_use||window[win-1].wintype<WINTYPE_TEXTBUFFER||window[win-1].wintype==WINTYPE_GRAPHICS)
  return (false);
int target=win-1;

static LOGFONT font_info;
static HFONT font;
static GCP_RESULTSW results;
const unsigned short space=32;
String cmp;

if (win_version.dwMajorVersion>=5){
  cmp=window[target].font->Name;
  if (strcmp(cmp.c_str(),font_info.lfFaceName)){
    font_info.lfHeight=0;
    font_info.lfWidth=0;
    font_info.lfEscapement=0;
    font_info.lfOrientation=0;
    font_info.lfWeight=0;
    font_info.lfItalic=0;
    font_info.lfUnderline=0;
    font_info.lfStrikeOut=0;
    font_info.lfCharSet=1200;
    font_info.lfOutPrecision=OUT_DEFAULT_PRECIS;
    font_info.lfClipPrecision=CLIP_DEFAULT_PRECIS;
    font_info.lfQuality=DEFAULT_QUALITY;
    font_info.lfPitchAndFamily=DEFAULT_PITCH|FF_DONTCARE;
    strcpy(font_info.lfFaceName,cmp.c_str());
    font=CreateFontIndirect(&font_info);
    results.lpOutString=NULL;
    results.lpOrder=NULL;
    results.lpDx=NULL;
    results.lpCaretPos=NULL;
    results.lpClass=NULL;
    results.nGlyphs=1;
    results.nMaxFit=1;
    results.lStructSize=sizeof(results);};

  HDC dc=GetDC(NULL);
  SelectObject(dc,font);
  unsigned short space_glyph;
  unsigned short glyph;
  results.lpGlyphs=(wchar_t *)&space_glyph;
  GetCharacterPlacementW(dc,(wchar_t *)&space,1,1,&results,NULL);
  results.lpGlyphs=(wchar_t *)&glyph;
  GetCharacterPlacementW(dc,(wchar_t *)&char_number,1,1,&results,NULL);
  ReleaseDC(NULL,dc);

  if ((glyph==space_glyph)&&(char_number!=32))
    return (false);
  else
    return (true);}

else{
  return (char_number<256);};
};
//-----------------------------------------------------------------------------

int GLK::stream_iterate(unsigned int str,int &rockptr)
{
for (int i=str;i<20;i++){
  if (stream[i].in_use){
    rockptr=stream[i].rock;
    return (i+1);};};

rockptr=0;
return (0);
};
//-----------------------------------------------------------------------------

int GLK::schannel_iterate(unsigned int chan,int &rockptr)
{
for (int i=chan;i<10;i++){
  if (schannel[i].in_use){
    rockptr=schannel[i].rock;
    return (i+1);};};

rockptr=0;
return (0);
};
//-----------------------------------------------------------------------------

int GLK::window_iterate(int win,int &rockptr)
{
for (int i=win;i<49;i++){
  if (window[i].in_use){
    rockptr=window[i].rock;
    return (i+1);};};

rockptr=0;
return (0);
};
//-----------------------------------------------------------------------------

int GLK::fileref_iterate(int ref,int &rockptr)
{
for (int i=ref;i<10;i++){
  if (fileref[i].in_use){
    rockptr=fileref[i].rock;
    return (i+1);};};
    
rockptr=0;
return (0);
};
//----------------------------------------------------------------------------

void GLK::set_window(int win)
{
if (win<1||win>49||!window[win-1].in_use||window[win-1].wintype<WINTYPE_TEXTBUFFER||window[win-1].wintype==WINTYPE_GRAPHICS)
  return;
int target=win-1;

stream_set_current(window[target].stream);
};
//----------------------------------------------------------------------------

int GLK::stream_open_memory(char *buf,int buflen,int fmode,int rock,bool unicode)
{
for (int i=0;i<20;i++){
  if (!stream[i].in_use){
    stream[i].in_use=true;
    stream[i].type=STREAM_MEMORY;
    stream[i].buf=buf;
    stream[i].buflen=buflen;
    if (unicode)
      stream[i].buflen*=4;
    stream[i].fmode=fmode;
    stream[i].loc=0;
    stream[i].highest_point=0;
    stream[i].readcount=0;
    stream[i].writecount=0;
    stream[i].rock=rock;
    stream[i].echo=0;
    stream[i].unicode=unicode;
    stream[i].script=false;
    stream_count++;
    return (i+1);};};

return (0);
};
//---------------------------------------------------------------------------

void GLK::stream_close(int close,STREAM_RESULT &result)
{
if (close<1||close>20||!stream[close-1].in_use||(stream[close-1].type==STREAM_WINDOW&&window[stream[close-1].win-1].in_use)){
  result.readcount=0;
  result.writecount=0;
  return;};
if (active_stream==close)
  active_stream=0;
int target=close-1;

if (stream[target].echo){
  window[stream[target].echo-1].echo_stream=0;};

result.readcount=stream[target].readcount;
result.writecount=stream[target].writecount;
stream[target].in_use=false;
stream_count--;
if (stream[target].type==STREAM_FILE){
  delete stream[target].file;
  stream[target].file=NULL;
  if (stream[target].script)
    transcript_menu(false);};
};
//---------------------------------------------------------------------------

unsigned char GLK::char_to_lower(unsigned char ch)
{
if ((ch>=65&&ch<=90)||(ch>=192&&ch<=214)||(ch>=216&&ch<=222))
  return (ch+32);

return (ch);
};
//---------------------------------------------------------------------------

int GLK::create_pair(int child1,int method,int size)
{
int target;
for (int i=0;i<49;i++){
  if (!window[i].in_use){
    target=i;
    break;};};

window[target].method=method;
window[target].size=size;
window[target].wintype=WINTYPE_PAIR;
window[target].rock=0;
window[target].left=window[child1].left;
window[target].top=window[child1].top;
window[target].width=window[child1].width;
window[target].height=window[child1].height;
window[target].font_width=window[child1].font_width;
window[target].font_height=window[child1].font_height;
window[target].in_use=true;
window[target].parent=window[child1].parent;
if (window[target].parent!=0){
  if (window[window[target].parent-1].child1==child1+1){
    window[window[target].parent-1].child1=target+1;}
  else{
    window[window[target].parent-1].child2=target+1;};
  if (window[window[target].parent-1].key==child1+1){
    window[window[target].parent-1].key=target+1;};};
window[target].child1=child1+1;
window[child1].parent=target+1;
win_count++;
return (target);
};
//---------------------------------------------------------------------------

int GLK::create_win(int parent,int wintype,int rock,bool borderStyle,bool scrollStyle)
{
int target;
for (int i=0;i<49;i++){
  if (!window[i].in_use){
    target=i;
    break;};};

if (wintype==WINTYPE_TEXTBUFFER){
  window[target].textbuffer=new TRichEdit20(MainForm,target+1,left_margin,right_margin,borderStyle,scrollStyle);
  window[target].window=(TControl *)window[target].textbuffer;
  memcpy(window[target].style,textbuffer_style,sizeof(STYLE)*11);
  window[target].para_format.cbSize=sizeof(window[target].para_format);
  window[target].para_format.dwMask=(PFM_OFFSET|PFM_STARTINDENT|PFM_ALIGNMENT);}
else{
  window[target].textgrid=new TEXTGRID(MainForm,target+1);
  window[target].window=(TControl *)window[target].textgrid;
  if (wintype==WINTYPE_TEXTGRID){
    memcpy(window[target].style,textgrid_style,sizeof(STYLE)*11);}
  else{
    window[target].textgrid->bitmap->Canvas->Brush->Color=clWhite;};};

if (wintype==WINTYPE_TEXTBUFFER||wintype==WINTYPE_TEXTGRID){
  window[target].term_chars=new bool[256];
  memset(window[target].term_chars,false,256);
  window[target].term_chars[VK_RETURN]=true;};

window[target].wintype=wintype;
window[target].rock=rock;
window[target].line_event=false;
window[target].char_event=false;
window[target].line_input_echo=true;
window[target].hyper_linking=false;
window[target].echo_stream=0;
window[target].in_use=true;
window[target].parent=parent+1;
window[target].child1=0;
window[target].child2=0;
if (wintype!=WINTYPE_GRAPHICS){
  window[target].font=new TFont();
  do_set_style(target,STYLE_NORMAL);
  window_clear(target+1);}
else{
  window[target].font_width=1;
  window[target].font_height=1;};

int str_target;
for (int i=0;i<20;i++){
  if (!stream[i].in_use){
    str_target=i;
    break;};};

if (wintype!=WINTYPE_BLANK&&wintype!=WINTYPE_GRAPHICS){
  stream[str_target].in_use=true;
  stream[str_target].type=STREAM_WINDOW;
  stream[str_target].rock=0;
  stream[str_target].win=target+1;
  stream[str_target].echo=0;
  stream[str_target].script=false;
  stream[str_target].readcount=0;
  stream[str_target].writecount=0;
  window[target].stream=str_target+1;
  stream_count++;};

win_count++;
return (target);
};
//---------------------------------------------------------------------------

void GLK::arrange_windows(int top)
{
if (win_count==0)
  return;
                                    
if (win_count==1){
  window[0].left=0;
  window[0].top=0;
  window[0].width=MainForm->client_width;
  window[0].height=MainForm->client_height;
  if (window[0].wintype>WINTYPE_TEXTBUFFER){
    window[0].textgrid->changed=true;
    window[0].textgrid->bitmap->Width=window[0].width;
    window[0].textgrid->bitmap->Height=window[0].height;};

  return;};

if (top==(root_win-1)){
  window[top].left=0;
  window[top].top=0;
  window[top].width=MainForm->client_width;
  window[top].height=MainForm->client_height;};

int size=window[top].size;
int key=window[top].key-1;
int nonkey;
if (window[top].child1==window[top].key)
  nonkey=window[top].child2-1;
else
  nonkey=window[top].child1-1;
//int child1=window[top].child1-1;
//int child2=window[top].child2-1;
window[nonkey].left=window[top].left;
window[nonkey].top=window[top].top;
window[nonkey].width=window[top].width;
window[nonkey].height=window[top].height;

if (window[top].method&WINMETHOD_FIXED){
  switch (window[top].method&15){
    case WINMETHOD_ABOVE:
      size*=window[key].font_height;
      window[key].left=window[nonkey].left;
      window[key].top=window[nonkey].top;
      window[key].width=window[nonkey].width;
      window[key].height=min(size,window[nonkey].height);
      window[nonkey].top+=window[key].height;
      window[nonkey].height-=window[key].height;
      break;
    case WINMETHOD_BELOW:
      size*=window[key].font_height;
      window[key].left=window[nonkey].left;
      window[key].top=(window[nonkey].top+window[nonkey].height-size);
      window[key].width=window[nonkey].width;
      window[key].height=min(size,window[nonkey].height);
      window[nonkey].height-=window[key].height;
      break;
    case WINMETHOD_LEFT:
      size*=window[key].font_width;
      window[key].left=window[nonkey].left;
      window[key].top=window[nonkey].top;
      window[key].width=min(size,window[nonkey].width);
      window[key].height=window[nonkey].height;
      window[nonkey].left+=window[key].width;
      window[nonkey].width-=window[key].width;
      break;
    case WINMETHOD_RIGHT:
      size*=window[key].font_width;
      window[key].left=max(window[nonkey].left+window[nonkey].width-size,window[nonkey].left);
      window[key].top=window[nonkey].top;
      window[key].width=min(size,window[nonkey].width);
      window[key].height=window[nonkey].height;
      window[nonkey].width-=window[key].width;};}
else{
  float percent=(float)window[top].size/100;
  switch (window[top].method&15){
    case WINMETHOD_ABOVE:
      window[key].left=window[nonkey].left;
      window[key].top=window[nonkey].top;
      window[key].width=window[nonkey].width;
      window[key].height=window[nonkey].height*percent;
      window[nonkey].top+=window[key].height;
      window[nonkey].height-=window[key].height;
      break;
    case WINMETHOD_BELOW:
      window[key].left=window[nonkey].left;
      window[key].top=(window[nonkey].top+window[nonkey].height)-(window[nonkey].height*percent);
      window[key].width=window[nonkey].width;
      window[key].height=window[nonkey].height*percent;
      window[nonkey].height-=window[key].height;
      break;
    case WINMETHOD_LEFT:
      window[key].left=window[nonkey].left;
      window[key].top=window[nonkey].top;
      window[key].width=window[nonkey].width*percent;
      window[key].height=window[nonkey].height;
      window[nonkey].left+=window[key].width;
      window[nonkey].width-=window[key].width;
      break;
    case WINMETHOD_RIGHT:
      window[key].left=(window[nonkey].left+window[nonkey].width)-(window[nonkey].width*percent);
      window[key].top=window[nonkey].top;
      window[key].width=window[nonkey].width*percent;
      window[key].height=window[nonkey].height;
      window[nonkey].width-=window[key].width;};};

if (window[nonkey].wintype==WINTYPE_TEXTGRID||window[nonkey].wintype==WINTYPE_GRAPHICS){
  window[nonkey].textgrid->changed=true;
  window[nonkey].textgrid->bitmap->Width=window[nonkey].width;
  window[nonkey].textgrid->bitmap->Height=window[nonkey].height;
  window[nonkey].textgrid->fill_rect.right=window[nonkey].width;
  window[nonkey].textgrid->fill_rect.bottom=window[nonkey].height;}
else{
  if (window[nonkey].wintype==WINTYPE_PAIR){
    arrange_windows(nonkey);};};

if (window[key].wintype==WINTYPE_TEXTGRID||window[key].wintype==WINTYPE_GRAPHICS){
  window[key].textgrid->changed=true;
  window[key].textgrid->bitmap->Width=window[key].width;
  window[key].textgrid->bitmap->Height=window[key].height;
  window[key].textgrid->fill_rect.right=window[key].width;
  window[key].textgrid->fill_rect.bottom=window[key].height;
  if (window[key].wintype==WINTYPE_TEXTGRID&&blank_reverse&&window[key].reverse){
    window[key].textgrid->bitmap->Canvas->Brush->Color=window[key].font->Color;
    window[key].textgrid->clear();
    window[key].textgrid->bitmap->Canvas->Brush->Color=window[key].color;};}
else{
  if (window[key].wintype==WINTYPE_PAIR){
    arrange_windows(key);};};
};
//---------------------------------------------------------------------------

bool GLK::descendent(int win,int ancestor)
{
int target=win;
do{
  target=window[target].parent-1;
  if (target==ancestor){
    return (true);};}
while (target!=-1);

return (false);
};
//---------------------------------------------------------------------------

void GLK::do_close_win(int target)
{
delete (window[target].textbuffer);
window[target].textbuffer=NULL;
delete window[target].textgrid;
window[target].textgrid=NULL;
delete (window[target].font);
window[target].font=NULL;
win_count--;
delete window[target].term_chars;
window[target].in_use=false;

if (window[target].wintype==WINTYPE_TEXTBUFFER||window[target].wintype==WINTYPE_TEXTGRID){
  STREAM_RESULT result;
  stream_close(window[target].stream,result);
  if (window[target].echo_stream){
    stream[window[target].echo_stream-1].echo=0;};};
};
//----------------------------------------------------------------------------

int GLK::window_get_current()
{
if (stream[active_stream-1].type==STREAM_WINDOW)
  return (stream[active_stream-1].win);

return (0);
};
//----------------------------------------------------------------------------

int GLK::window_get_parent(int win)
{
if (win<1||win>49||!window[win-1].in_use)
  return (0);
int target=win-1;

return (window[target].parent);
};
//----------------------------------------------------------------------------

int GLK::window_get_sibling(int win)
{
if (win<1||win>49||!window[win-1].in_use||!window[win-1].parent)
  return (0);
int target=window[win-1].parent-1;

if (window[target].child1==win)
  return (window[target].child2);
else
  return (window[target].child1);
};
//----------------------------------------------------------------------------

int GLK::window_get_rock(int win)
{
if (win<1||win>49||!window[win-1].in_use)
  return (false);
int target=win-1;

return (window[target].rock);
};
//----------------------------------------------------------------------------

int GLK::stream_get_rock(int str)
{
if (str<1||str>20||!stream[str-1].in_use)
  return (false);
int target=str-1;

return (stream[target].rock);
};
//----------------------------------------------------------------------------

int GLK::schannel_get_rock(int chan)
{
if (chan<1||chan>10||!schannel[chan-1].in_use)
  return (false);
int target=chan-1;

return (schannel[target].rock);
};
//----------------------------------------------------------------------------

int GLK::fileref_get_rock(int ref)
{
if (ref<1||ref>10||!fileref[ref-1].in_use)
  return (false);
int target=ref-1;

return (fileref[target].rock);
};
//----------------------------------------------------------------------------

int GLK::window_get_type(int win)
{
if (win<1||win>49||!window[win-1].in_use)
  return (0);
int target=win-1;

return (window[target].wintype);
};
//----------------------------------------------------------------------------

int GLK::fileref_create_by_prompt(int usage,int fmode,int rock)
{
int target=-1;
for (int i=0;i<10;i++){
  if (!fileref[i].in_use){
    target=i;
    break;};};
if (target==-1)
  return (0);

char filename[256];
int result=false;
if (usage&FILEUSAGE_SAVEGAME){
  if (fmode==FILEMODE_WRITE){
    result=save_file_dialog(filename);}
  else{
    if (fmode==FILEMODE_READ){
      result=restore_file_dialog(filename);};};}
else{
  if (usage&FILEUSAGE_TRANSCRIPT){
    if (fmode==FILEMODE_WRITE||fmode==FILEMODE_WRITEAPPEND){
      result=script_file_dialog(filename);
      fmode=result;};}
  else{
    if (fmode==FILEMODE_WRITE){
      result=save_data_file_dialog(filename);}
    else{
      result=open_data_file_dialog(filename);};};};

if (!result)
  return (0);


fileref[target].in_use=true;
fileref[target].usage=usage;
fileref[target].rock=rock;
fileref[target].filename=filename;
file_count++;

return (target+1);
};
//---------------------------------------------------------------------------

int GLK::fileref_create_by_name(int usage,char *name,int rock)
{
int target=-1;
for (int i=0;i<10;i++){
  if (!fileref[i].in_use){
    target=i;
    break;};};
if (target==-1)
  return (false);

fileref[target].in_use=true;
fileref[target].usage=usage;
fileref[target].rock=rock;
fileref[target].filename=name;
file_count++;

return (target+1);
};
//---------------------------------------------------------------------------

int GLK::fileref_create_temp(int usage,int rock)
{
int target=-1;
for (int i=0;i<10;i++){
  if (!fileref[i].in_use){
    target=i;
    break;};};
if (target==-1)
  return (false);

fileref[target].in_use=true;
fileref[target].usage=usage;
fileref[target].rock=rock;
fileref[target].filename="%TEMP%\\filfre.tmp";
file_count++;

return (target+1);
};
//---------------------------------------------------------------------------

int GLK::fileref_create_from_fileref(int usage,int ref,int rock)
{
if (ref<1||ref>10||!fileref[ref-1].in_use)
  return (false);

int target=-1;
for (int i=0;i<5;i++){
  if (!fileref[i].in_use){
    target=i;
    break;};};
if (target==-1)
  return (false);

fileref[target].in_use=true;
fileref[target].usage=usage;
fileref[target].rock=rock;
fileref[target].filename=fileref[ref-1].filename;
file_count++;

return (target+1);
};
//---------------------------------------------------------------------------

int GLK::stream_open_file(int ref,int fmode,int rock,bool unicode)
{
int target=-1;
for (int i=0;i<20;i++){
  if (!stream[i].in_use){
    target=i;
    break;};};
if (target==-1)
  return (false);

if (ref<1||ref>10||!fileref[ref-1].in_use)
  return (0);
int rtarget=ref-1;

int mode;
if (!FileExists(fileref[rtarget].filename)){
  mode=fmCreate|fmShareExclusive;}
else{
  switch (fmode){
    case FILEMODE_WRITE:
      mode=fmCreate|fmShareExclusive;
      break;
    case FILEMODE_READ:
      mode=fmOpenRead|fmShareExclusive;
      break;
    case FILEMODE_READWRITE:
    case FILEMODE_WRITEAPPEND:
      mode=fmOpenReadWrite|fmShareDenyNone;};};

try{
  stream[target].file=new TFileStream(fileref[rtarget].filename,mode);}
catch (TObject *EFCreateError){
  return (0);};

if (fmode==FILEMODE_WRITEAPPEND)
  stream[target].file->Seek(0,soFromEnd);

stream[target].fmode=fmode;
stream[target].rock=rock;
stream[target].type=STREAM_FILE;
stream[target].in_use=true;
stream[target].echo=0;
stream[target].unicode=unicode;
stream[target].script=(fileref[rtarget].usage&FILEUSAGE_TRANSCRIPT);
stream[target].text=(fileref[rtarget].usage<256);
stream[target].readcount=0;
stream[target].writecount=0;
stream_count++;


if (fmode==FILEMODE_WRITE){
  stream[target].file->Size=0;}
else{
  if (fmode==FILEMODE_WRITEAPPEND){
    stream[target].file->Seek(0,soFromEnd);};};

if (stream[target].script)
  transcript_menu(true);

return (target+1);
};
//---------------------------------------------------------------------------

void GLK::fileref_destroy(int ref)
{
if (ref<1||ref>10||!fileref[ref-1].in_use)
  return;
int target=ref-1;

fileref[target].in_use=false;
file_count--;
};
//---------------------------------------------------------------------------

void GLK::fileref_delete_file(int ref)
{
if (ref<1||ref>10||!fileref[ref-1].in_use)
  return;
int target=ref-1;

DeleteFile(fileref[target].filename);
};
//---------------------------------------------------------------------------

bool GLK::fileref_does_file_exist(int ref)
{
if (ref<1||ref>10||!fileref[ref-1].in_use)
  return (false);
int target=ref-1;

return (FileExists(fileref[target].filename));
};
//---------------------------------------------------------------------------

void GLK::put_buffer(char *buf,int len,bool unicode)
{
put_buffer_stream(active_stream,buf,len,unicode);
};

//---------------------------------------------------------------------------

void GLK::put_buffer_stream(int str,char *buf,int len,bool unicode)
{
if (str<1||str>20||!stream[str-1].in_use)
  return;
int target=str-1;

if (stream[target].type==STREAM_WINDOW){
  wchar_t *tmp=new wchar_t[len+1];
  tmp[len]=0;
  if (unicode){
    int buf_pos=0;
    for (int i=0;i<len;i++){
      tmp[i]=0;
      for (int j=24;j>=0;j-=8){
        tmp[i]+=(unsigned char)buf[buf_pos];
        buf_pos++;
        tmp[i]=tmp[i]<<j;};};}
  else{
    for (int i=0;i<len;i++)
      tmp[i]=(unsigned char)buf[i];};
  put_string_stream(str,tmp);
  stream[target].writecount+=len;
  delete tmp;
  return;};                                    

if (stream[target].type==STREAM_MEMORY){
  if (stream[target].fmode!=FILEMODE_READ){
    if (unicode){
       if (stream[target].unicode){
          int space=min((stream[target].buflen-stream[target].loc),len*4);
          stream[target].writecount+=(space/4);
          memcpy((stream[target].buf+stream[target].loc),buf,space);
          stream[target].loc+=space;}
       else{
         int space=min((stream[target].buflen-stream[target].loc),len);
          for (int i=0;i<space;i+=4){
             stream[target].buf[stream[target].loc]=buf[i+3];
             stream[target].loc++;
             stream[target].writecount++;};};}
     else{
       if (stream[target].unicode){
          int space=min((stream[target].buflen-stream[target].loc)/4,len);
          for (int i=0;i<space;i++){
             stream[target].buf[stream[target].loc]=0;
             stream[target].buf[stream[target].loc+1]=0;
             stream[target].buf[stream[target].loc+2]=0;
             stream[target].buf[stream[target].loc+3]=buf[i];
             stream[target].loc+=4;
             stream[target].writecount++;};}
       else{
          int space=min(stream[target].buflen-stream[target].loc,len);
          stream[target].writecount+=space;
          memcpy((stream[target].buf+stream[target].loc),buf,space);
          stream[target].loc+=space;};};};
  stream[target].highest_point=max(stream[target].loc,stream[target].highest_point);
  return;};

if (stream[target].type==STREAM_FILE&&stream[target].file!=NULL){
  if (stream[target].fmode!=FILEMODE_READ){
    stream[target].writecount+=len;
    if (stream[target].unicode)
      len*=4;
    stream[target].file->Write(buf,len);};};
};
//---------------------------------------------------------------------------

int GLK::get_buffer_stream(int str,char *buf,int len,bool unicode)
{
if (str<1||str>20||!stream[str-1].in_use||stream[str-1].type==STREAM_WINDOW)
  return (false);
int target=str-1;

if (stream[target].fmode==FILEMODE_WRITE||stream[target].fmode==FILEMODE_WRITEAPPEND)
  return (false);

int count=0;
                                               
if (stream[target].unicode){
  unsigned int *next;
  int limit;
  if (stream[target].type==STREAM_MEMORY)
    limit=(min(stream[target].buflen-stream[target].loc,len*4)/4);
  else
    limit=(min(stream[target].file->Size-stream[target].file->Position,len*4)/4);
  for (int i=0;i<limit;i++){
    if (stream[target].type==STREAM_MEMORY){
      next=(unsigned int *)&stream[target].buf[stream[target].loc];}
    else{
      next=new unsigned int[4];
      stream[target].file->Read(next,4);};
    if (unicode)
      memcpy(&buf[i*4],next,4);
    else
      if (*next&0x00ffffff)
        buf[i]=0x3f;
      else
        buf[i]=(*next>>24);
    stream[target].loc+=4;
    count++;
    if (stream[target].type==STREAM_FILE)
      delete next;};}
else{
  unsigned char *next;
  int limit;
  if (stream[target].type==STREAM_MEMORY)
    limit=min(stream[target].buflen-stream[target].loc,len);
  else
    limit=min(stream[target].file->Size-stream[target].file->Position,len);
  for (int i=0;i<limit;i++){
    if (stream[target].type==STREAM_MEMORY){
      next=(unsigned char *)&stream[target].buf[stream[target].loc];}
    else{
      next=new unsigned char[1];
      stream[target].file->Read(next,1);};
    buf[i]=*next;
    if (unicode){
      buf[i*4]=*next;
      buf[i*4+1]=0;
      buf[i*4+2]=0;};
    stream[target].loc++;
    count++;
    if (stream[target].type==STREAM_FILE)
      delete next;};};

stream[target].highest_point=max(stream[target].loc,stream[target].highest_point);
stream[target].readcount+=count;
return (count);
};
//---------------------------------------------------------------------------

void GLK::stream_set_position(int str,int pos,int seekmode)
{
if (str<1||str>20||!stream[str-1].in_use||stream[str-1].type==STREAM_WINDOW)
  return;
int target=str-1;

if (stream[target].unicode)
  pos*=4;

if (stream[target].type==STREAM_MEMORY){
  switch (seekmode){
    case SEEKMODE_START:
      if (pos>=0&&pos<stream[target].buflen){
        stream[target].loc=pos;
        stream[target].highest_point=max(stream[target].loc,stream[target].highest_point);};
      return;
    case SEEKMODE_CURRENT:
      if ((stream[target].loc+pos)>=0&&(stream[target].loc+pos)<stream[target].buflen){
        stream[target].loc+=pos;
        stream[target].highest_point=max(stream[target].loc,stream[target].highest_point);};
      return;
    case SEEKMODE_END:
      if (pos<=0&&pos>=-stream[target].highest_point){
        stream[target].loc=stream[target].highest_point+pos;};
      return;
    default:
      return;};}

else{
  switch (seekmode){
    case SEEKMODE_START:
      stream[target].file->Seek(pos,soFromBeginning);
      return;
    case SEEKMODE_CURRENT:
      stream[target].file->Seek(pos,soFromCurrent);
      return;
    case SEEKMODE_END:
      stream[target].file->Seek(pos,soFromEnd);
      return;
    default:
      return;};};
};
//---------------------------------------------------------------------------

int GLK::stream_get_position(int str)
{
if (str<1||str>20||!stream[str-1].in_use||stream[str-1].type==STREAM_WINDOW)
  return (false);
int target=str-1;

int divider;
if (stream[target].unicode)
  divider=4;
else
  divider=1;                       

if (stream[target].type==STREAM_MEMORY){
  return (stream[target].loc/divider);}

else{
  return (stream[target].file->Position/divider);};
};
//----------------------------------------------------------------------------

int GLK::get_line_stream(int str,char *buf,int len,bool unicode)
{
if (str<1||str>20||!stream[str-1].in_use||stream[str-1].type==STREAM_WINDOW)
  return (false);
int target=str-1;

if (stream[target].fmode==FILEMODE_WRITE||stream[target].fmode==FILEMODE_WRITEAPPEND)
  return (false);

int limit=len-1;
int count=0;

if (stream[target].unicode){
  unsigned int *next;
  int limit;
  if (stream[target].type==STREAM_MEMORY)
    limit=(min(stream[target].buflen-stream[target].loc,len*4)/4);
  else
    limit=(min(stream[target].file->Size-stream[target].file->Position,len*4)/4);
  for (int i=0;i<limit;i++){
    if (stream[target].type==STREAM_MEMORY){
      next=(unsigned int *)&stream[target].buf[stream[target].loc];}
    else{
      next=new unsigned int[1];
      stream[target].file->Read(next,4);};
    if (unicode)
      memcpy(&buf[i*4],next,4);
    else
      if (*next&0x00ffffff)
        buf[i]=0x3f;
      else
        buf[i]=(*next>>24);
    stream[target].loc+=4;
    count++;
    if (stream[target].type==STREAM_FILE)
      delete next;
    if (*next==0x0A000000)
      break;};
  if (unicode)
    memset(&buf[count*4],0,4);
  else
    buf[count]=0;}
else{
  unsigned char *next;
  int limit;
  if (stream[target].type==STREAM_MEMORY)
    limit=min(stream[target].buflen-stream[target].loc,len);
  else
    limit=min(stream[target].file->Size-stream[target].file->Position,len);
  for (int i=0;i<limit;i++){
    if (stream[target].type==STREAM_MEMORY){
      next=(unsigned char *)&stream[target].buf[stream[target].loc];}
    else{
      next=new unsigned char[1];
      stream[target].file->Read(next,1);};
    buf[i]=*next;
    if (unicode){
      buf[i*4]=*next;
      buf[i*4+1]=0;
      buf[i*4+2]=0;};
    stream[target].loc++;
    count++;
    if (stream[target].type==STREAM_FILE)
      delete next;
    if (*next==0x0A)
      break;};
  if (unicode)
    memset(&buf[count*4],0,4);
  else
    buf[count]=0;};

stream[target].highest_point=max(stream[target].loc,stream[target].highest_point);
stream[target].readcount+=count;
return (count);
};
//----------------------------------------------------------------------------

int GLK::get_char_stream(int str,bool unicode)
{
if (str<1||str>20||!stream[str-1].in_use||stream[str-1].type==STREAM_WINDOW)
  return (false);
int target=str-1;

int result=0;

if (stream[target].type==STREAM_MEMORY){
  if (stream[target].loc>=stream[target].buflen)
    return (-1);
  if (stream[target].fmode==FILEMODE_READ||stream[target].fmode==FILEMODE_READWRITE){
    stream[target].readcount++;
    if (stream[target].loc<stream[target].buflen){
      if (stream[target].unicode){
        result=(stream[target].buf[stream[target].loc]<<24)|(stream[target].buf[stream[target].loc+1]<<16)|(stream[target].buf[stream[target].loc+2]<<8)|(stream[target].buf[stream[target].loc+3]);
        if (!unicode&&result>255)
          result=0x3F;
        stream[target].loc+=4;}
      else{
        result=stream[target].buf[stream[target].loc];
        stream[target].loc++;};};};
  stream[target].highest_point=max(stream[target].loc,stream[target].highest_point);
  return (result);};

if (stream[target].fmode==FILEMODE_READ||stream[target].fmode==FILEMODE_READWRITE){
  stream[target].readcount++;
  if (stream[target].unicode){
    stream[target].file->Read(&result,4);
    result=((result>>24)|((result>8)&0xff00)|((result<<8)&0xff0000)|(result<<24));}
  else{
    if (!(stream[target].file->Read(&result,1)))
      result=-1;};};
return (result);
};
//---------------------------------------------------------------------------

bool GLK::image_draw(int win,int image,int x,int y)
{
if (win<1||win>49||!window[win-1].in_use||window[win-1].wintype<WINTYPE_TEXTBUFFER||window[win-1].wintype==WINTYPE_TEXTGRID)
  return (false);
int target=win-1;

int tmp=0;
plant_args(&target,&image,&x,&y,&tmp,&tmp);
Synchronize(ImageDraw);
bool result;
dig_args(&result,BOOL);
return (result);
};
//---------------------------------------------------------------------------

bool GLK::image_draw_scaled(int win,int image,int x,int y,int width,int height)
{
if (win<1||win>49||!window[win-1].in_use||window[win-1].wintype<WINTYPE_TEXTBUFFER||window[win-1].wintype==WINTYPE_TEXTGRID)
  return (false);
int target=win-1;

plant_args(&target,&image,&x,&y,&width,&height);
Synchronize(ImageDraw);
bool result;
dig_args(&result,BOOL);
return (result);
};                                         
//---------------------------------------------------------------------------

void GLK::window_flow_break(int win)
{
if (win<1||win>49||!window[win-1].in_use||window[win-1].wintype!=WINTYPE_TEXTBUFFER)
  return;
int target=win-1;

put_char_stream(window[target].stream,'\n');
};
//---------------------------------------------------------------------------

void __fastcall GLK::ImageDraw()
{
int target,image,x,y,width,height;
bool success=false;
dig_args(&target,INT,&image,INT,&x,INT,&y,INT,&width,INT,&height,INT);

int pic_type=find_resource(PICT,image,story_file);
TGraphic *picture;
if (pic_type==JPEG){
  picture=new TJPEGImage();
  picture->LoadFromStream(story_file);}
else{
  if (pic_type==PNG){
    picture=new TPNGObject();
    picture->LoadFromStream(story_file);}
  else{
    String base="PIC";
    base+=image;
    String filename=base+".jpg";
    if (FileExists(filename)){
      picture=new TJPEGImage();
      picture->LoadFromFile(filename);}
    else{
      filename=base+".png";
      if (FileExists(filename)){
        picture=new TPNGObject();
        picture->LoadFromFile(filename);}
      else{
        plant_args(&success);
        return;};};};};

if (width==0){
  width=picture->Width;
  height=picture->Height;};

if (window[target].wintype==WINTYPE_TEXTBUFFER){
  short old_align;
  bool below_baseline=false;
  if (x>IMAGEALIGN_INLINEUP){
    below_baseline=true;};
  if (x>IMAGEALIGN_INLINECENTER){
    old_align=window[target].para_format.wAlignment;
    if (x==IMAGEALIGN_MARGINLEFT)
      window[target].para_format.wAlignment=PFA_LEFT;
    else
      window[target].para_format.wAlignment=PFA_RIGHT;
    window[target].textbuffer->Perform(EM_SETPARAFORMAT,0,(LONG)&window[target].para_format);};
  window[target].textbuffer->Perform(WM_SETREDRAW,false,NULL);
  repaint=true;
  success=window[target].textbuffer->insert_picture(picture,width,height,below_baseline);
  if (x>IMAGEALIGN_INLINECENTER){
    if (window[target].hyper_linking){
      window[target].textbuffer->hypertext[window[target].textbuffer->hyper_count-1].end++;};
    put_char_stream(window[target].stream,'\n');
    window[target].para_format.wAlignment=old_align;
    window[target].textbuffer->Perform(EM_SETPARAFORMAT,0,(LONG)&window[target].para_format);};
  if (success&&window[target].hyper_linking){
    window[target].textbuffer->hypertext[window[target].textbuffer->hyper_count-1].end++;};}
else{
  window[target].textgrid->changed=true;
  TRect rect;
  rect.left=x;
  rect.top=y;
  rect.right=(x+width)-1;
  rect.bottom=(y+height)-1;
  window[target].textgrid->bitmap->Canvas->Lock();
  window[target].textgrid->bitmap->Canvas->StretchDraw(rect,picture);
  window[target].textgrid->bitmap->Canvas->Unlock();
  success=true;
  plant_args(&success);
  if (window[target].hyper_linking){
    HYPERLINK *hyperlink=&window[target].textgrid->hyperlink[window[target].textgrid->hyper_count-1];
    if (hyperlink->coords.left!=hyperlink->coords.right){
      if (window[target].textgrid->hyper_count<20){
        window[target].textgrid->hyper_count++;
        HYPERLINK *hyperlink=&window[target].textgrid->hyperlink[window[target].textgrid->hyper_count-1];
        hyperlink->linkval=window[target].textgrid->hyperlink[window[target].textgrid->hyper_count-2].linkval;}
      else{
        delete (picture);
        window[target].hyper_linking=false;
        return;};};
    hyperlink->coords=rect;
    if (window[target].textgrid->hyper_count<20){
      window[target].textgrid->hyper_count++;
      HYPERLINK *hyperlink=&window[target].textgrid->hyperlink[window[target].textgrid->hyper_count-1];
      hyperlink->linkval=window[target].textgrid->hyperlink[window[target].textgrid->hyper_count-2].linkval;}
    else{
      window[target].hyper_linking=false;};};};

delete picture;
};
//---------------------------------------------------------------------------

unsigned char GLK::char_to_upper(unsigned char ch)
{
if ((ch>=97&&ch<=122)||(ch>=224&&ch<=246)||(ch>=248&&ch<=254))
  return (ch-32);

return (ch);
};
//---------------------------------------------------------------------------

int GLK::gestalt(int sel,int val)
{
return (gestalt_ext(sel,val,NULL,0));
};
//---------------------------------------------------------------------------

int GLK::gestalt_ext(int sel,int val,int *arr,int arrlen)
{
switch (sel){
  case GESTALT_VERSION:
    return (0x700);
  case GESTALT_CHARINPUT:
    if (val>=0&&val<256)
      return (allowed_keys[val]);
    return (false);
  case GESTALT_LINEINPUT:
    if (val<32||(val>126&&val<160)||val>255)
      return (false);
    return (true);
  case GESTALT_CHAROUTPUT:
    if (check_unicode(1,val)){
      if (arrlen)
        arr[0]=1;
      return (GESTALT_CHAROUTPUT_EXACTPRINT);};
    if (arrlen)
      arr[0]=0;
    return (GESTALT_CHAROUTPUT_CANNOTPRINT);
  case GESTALT_MOUSEINPUT:
    if (val==WINTYPE_TEXTGRID||val==WINTYPE_GRAPHICS)
      return (true);
    return (false);
  case GESTALT_TIMER:
    return (true);                      
  case GESTALT_GRAPHICS:
    return (true);
  case GESTALT_DRAWIMAGE:
    if (val==WINTYPE_TEXTBUFFER||val==WINTYPE_GRAPHICS)
      return (true);
    return (false);
  case GESTALT_SOUND:
    return (true);
  case GESTALT_SOUNDVOLUME:
    return (true);
  case GESTALT_SOUNDNOTIFY:
    return (true);
  case GESTALT_HYPERLINKS:
    return (true);
  case GESTALT_HYPERLINKINPUT:
    if (val==WINTYPE_TEXTBUFFER||val==WINTYPE_TEXTGRID)
      return (true);
    return (false);
  case GESTALT_SOUNDMUSIC:
    return (true);
  case GESTALT_GRAPHICSTRANSPARENCY:
    return (true);
  case GESTALT_UNICODE:
    return (true);
  case GESTALT_UNICODENORM:
    return (true);
  case GESTALT_LINEINPUTECHO:
    return (true);
  case GESTALT_LINETERMINATORS:
    return (true);
  case GESTALT_LINETERMINATORKEY:
    if (((unsigned int)val>=0xffffffd6&&(unsigned int)val<=0xffffffdf)||((unsigned int)val>=0xffffffe4&&(unsigned int)val<=0xffffffef)||((unsigned int)val>=0xfffffff3&&(unsigned int)val<=0xfffffffe))
      return (true);
    return (false);
  case GESTALT_DATETIME:
    return (true);};

return (false);
};
//--------------------------------------------------------------------------

bool GLK::image_get_info(int image,int &width,int &height)
{
int pic_type=find_resource(PICT,image,story_file);
TGraphic *picture;
if (pic_type==JPEG){
  picture=new TJPEGImage();
  picture->LoadFromStream(story_file);}
else{
  if (pic_type==PNG){
    picture=new TPNGObject();
    picture->LoadFromStream(story_file);}
  else{
    String base="PIC";
    base+=image;
    String filename=base+".jpg";
    if (FileExists(filename)){
      picture=new TJPEGImage();
      picture->LoadFromFile(filename);}
    else{
      filename=base+".png";
      if (FileExists(filename)){
        picture=new TPNGObject();
        picture->LoadFromFile(filename);}
      else{
        return (false);};};};};

width=picture->Width;
height=picture->Height;
delete picture;
return (true);
};
//---------------------------------------------------------------------------

bool GLK::style_measure(int win,int style,int hint, int &result)
{
if (win<1||win>49||!window[win-1].in_use||window[win-1].wintype<WINTYPE_TEXTBUFFER||window[win-1].wintype==WINTYPE_GRAPHICS||
  style<STYLE_NORMAL||style>STYLE_USER2){
  result=0;
  return (false);};
int target=win-1;

switch (hint){
  case STYLEHINT_INDENTATION:
    result=window[target].style[style].indentation;
    return (true);
  case STYLEHINT_PARAINDENTATION:
    result=window[target].style[style].para_indentation;
    return (true);
  case STYLEHINT_JUSTIFICATION:
    result=window[target].style[style].justification;
    return (true);
  case STYLEHINT_SIZE:
    result=window[target].style[style].size;
    return (true);
  case STYLEHINT_WEIGHT:
    result=window[target].style[style].weight;
    return (true);
  case STYLEHINT_OBLIQUE:
    result=window[target].style[style].oblique;
    return (true);
  case STYLEHINT_PROPORTIONAL:
    result=window[target].style[style].proportional;
    return (true);
  case STYLEHINT_TEXTCOLOR:
    result=window[target].style[style].text_color;
    return (true);
  case STYLEHINT_BACKCOLOR:
    result=window[target].style[style].back_color;
    return (true);
  case STYLEHINT_REVERSECOLOR:
    result=window[target].style[style].reverse_color;
    return (true);};

return (false);
};
//---------------------------------------------------------------------------

void GLK::window_fill_rect(int win,TColor color,int left,int top,int width,int height)
{
if (win<1||win>49||!window[win-1].in_use||window[win-1].wintype!=WINTYPE_GRAPHICS)
  return;
int target=win-1;

window[target].textgrid->fill_rect.left=left;
window[target].textgrid->fill_rect.top=top;
window[target].textgrid->fill_rect.right=(left+width);
window[target].textgrid->fill_rect.bottom=(top+height);

plant_args(&target,&color);
Synchronize(WindowFillRect);

window[target].textgrid->fill_rect.left=0;
window[target].textgrid->fill_rect.top=0;
window[target].textgrid->fill_rect.right=window[target].width;
window[target].textgrid->fill_rect.bottom=window[target].height;
};
//---------------------------------------------------------------------------

void GLK::window_erase_rect(int win,int left,int top,int width,int height)
{
if (win<1||win>49)
  return;
window_fill_rect(win,window[win-1].color,left,top,width,height);
};
//---------------------------------------------------------------------------

void __fastcall GLK::WindowFillRect()
{
int target;
TColor color;
dig_args(&target,INT,&color,INT);

window[target].textgrid->changed=true;
window[target].textgrid->bitmap->Canvas->Lock();
window[target].textgrid->bitmap->Canvas->Brush->Color=color;
window[target].textgrid->bitmap->Canvas->FillRect(window[target].textgrid->fill_rect);
window[target].textgrid->bitmap->Canvas->Brush->Color=window[target].color;
window[target].textgrid->bitmap->Canvas->Unlock();
};
//---------------------------------------------------------------------------

int GLK::window_get_root()
{
return (root_win);
};
//---------------------------------------------------------------------------

void GLK::set_hyperlink(int linkval)
{
set_hyperlink_stream(active_stream,linkval);
};
//---------------------------------------------------------------------------

void GLK::set_hyperlink_stream(int str,int linkval)
{
if (str<1||str>20||!stream[str-1].in_use||stream[str-1].type!=STREAM_WINDOW)
  return;
int target=stream[str-1].win-1;

if (linkval==0){
  window[target].hyper_linking=false;
  if (window[target].wintype==WINTYPE_TEXTBUFFER)
    window[target].textbuffer->SelAttributes2->Link=tsNo;
  return;};

if (window[target].wintype==WINTYPE_TEXTBUFFER){
  window[target].textbuffer->hypertext[window[target].textbuffer->hyper_count].linkval=linkval;
  plant_args(&target);
  Synchronize(TextSetHyper);
  return;};

if (window[target].wintype==WINTYPE_TEXTGRID){
  if (window[target].textgrid->hyper_count<20){
    window[target].hyper_linking=true;
    window[target].textgrid->hyperlink[window[target].textgrid->hyper_count].coords.left=window[target].textgrid->cursor.x;
    window[target].textgrid->hyperlink[window[target].textgrid->hyper_count].coords.top=window[target].textgrid->cursor.y;
    window[target].textgrid->hyperlink[window[target].textgrid->hyper_count].coords.right=window[target].textgrid->cursor.x;
    window[target].textgrid->hyperlink[window[target].textgrid->hyper_count].coords.bottom=window[target].textgrid->cursor.y+window[target].font_height;
    window[target].textgrid->hyperlink[window[target].textgrid->hyper_count].linkval=linkval;
    window[target].textgrid->hyper_count++;}
  else{
    window[target].hyper_linking=false;};};
};
//----------------------------------------------------------------------------

void __fastcall GLK::TextSetHyper()
{
int target;
dig_args(&target,INT);

if (window[target].textbuffer->hyper_count<100){
  window[target].hyper_linking=true;
  CHARRANGE pos;
  window[target].textbuffer->Perform(EM_EXSETSEL,NULL,(LONG)&set_range);
  window[target].textbuffer->Perform(EM_EXGETSEL,NULL,(LONG)&pos);
  window[target].textbuffer->hypertext[window[target].textbuffer->hyper_count].start=pos.cpMin;
  window[target].textbuffer->hypertext[window[target].textbuffer->hyper_count].end=pos.cpMin;
  window[target].textbuffer->hyper_count++;}
else{
  window[target].hyper_linking=false;};
};

//----------------------------------------------------------------------------

void GLK::window_set_echo_stream(int win,int str)
{
if (win<1||win>49||!window[win-1].in_use||window[win-1].wintype<WINTYPE_TEXTBUFFER||window[win-1].wintype>WINTYPE_TEXTGRID)
  return;
int target=win-1;

if (window[target].echo_stream){
  stream[window[target].echo_stream-1].echo=0;};

window[target].echo_stream=str;
stream[str-1].echo=win;
};
//----------------------------------------------------------------------------

int GLK::window_get_echo_stream(int win)
{
if (win<1||win>49||!window[win-1].in_use||window[win-1].wintype<WINTYPE_TEXTBUFFER||window[win-1].wintype>WINTYPE_TEXTGRID)
  return (false);
int target=win-1;

return (window[target].echo_stream);
};
//---------------------------------------------------------------------------

void GLK::request_hyperlink_event(int win)
{
if (win<1||win>49||!window[win-1].in_use||window[win-1].wintype<WINTYPE_TEXTBUFFER||window[win-1].wintype>WINTYPE_TEXTGRID)
  return;
int target=win-1;

if (window[target].wintype==WINTYPE_TEXTBUFFER){
  window[target].textbuffer->hyper_active=true;
  return;};

if (window[target].wintype==WINTYPE_TEXTGRID){
  window[target].textgrid->hyper_active=true;
  return;};
};
//---------------------------------------------------------------------------

void GLK::cancel_hyperlink_event(int win)
{
if (win<1||win>49||!window[win-1].in_use||window[win-1].wintype<WINTYPE_TEXTBUFFER||window[win-1].wintype>WINTYPE_TEXTGRID)
  return;
int target=win-1;

if (window[target].wintype==WINTYPE_TEXTBUFFER){
  window[target].textbuffer->hyper_active=false;
  return;};

if (window[target].wintype==WINTYPE_TEXTGRID){
  window[target].textgrid->hyper_active=false;
  return;};
};
//---------------------------------------------------------------------------

bool GLK::is_hyperlinking(int target)
{
return (window[target].hyper_linking);
};
//---------------------------------------------------------------------------

void GLK::tick()
{
};
//---------------------------------------------------------------------------

void __fastcall GLK::ErrorMessage()
{
char *msg=(char *)args[0];
Application->MessageBox(msg,"FATAL ERROR",MB_OK);
};
//---------------------------------------------------------------------------

void GLK::error_message(char *msg)
{
args[0]=msg;
Synchronize(ErrorMessage);
};
//---------------------------------------------------------------------------

void __fastcall GLK::FinalOutput()
{
setup_screen();
MainForm->toggle_waittimer();
MainForm->StatusBar->Panels->Items[0]->Text="Select a story using the File menu.";
};
//---------------------------------------------------------------------------

int GLK::buffer_to_upper_case_uni(unsigned int *buf,int len,int numchars)
{
int end=numchars;

if (check_uni_conv()){
  unsigned int *tmp=new unsigned int[len];
  int read_loc=0;
  for (int i=0;i<end;i++){
     bool found=false;
     tmp[i]=((buf[read_loc]>>24)|((buf[read_loc]>>8)&0xff00)|((buf[read_loc]<<8)&0xff0000)|(buf[read_loc]<<24));
    for (int j=0;uni_conv_multi[j].code!=0xffffffff;j++){
      if (uni_conv_multi[j].code==tmp[i]){
        if (uni_conv_multi[j].upper[0]){
          if (i<len)
            tmp[i]=uni_conv_multi[j].upper[0];
          if (uni_conv_multi[j].upper[1]){
            i++;
            end++;
            if (i<len)
              tmp[i]=uni_conv_multi[j].upper[1];
            if (uni_conv_multi[j].upper[2]){
              i++;
              end++;
              if (i<len)
                tmp[i]=uni_conv_multi[j].upper[2];};};};
        found=true;
        break;};};
    if (!found){
      for (int j=0;uni_conv[j].code!=0xffffffff;j++){
        if (uni_conv[j].code==tmp[i]){
          if (uni_conv[j].upper){
            if (i<len)
              tmp[i]=uni_conv[j].upper;};
          break;};};};
    read_loc++;};
  int limit=min(end,len);
  for (int i=0;i<limit;i++){
    buf[i]=((tmp[i]>>24)|((tmp[i]>>8)&0xff00)|((tmp[i]<<8)&0xff0000)|(tmp[i]<<24));};
  delete tmp;};

return (end);
};
//---------------------------------------------------------------------------

int GLK::buffer_to_lower_case_uni(unsigned int *buf,int len,int numchars)
{
int end=numchars;

if (check_uni_conv()){
  unsigned int *tmp=new unsigned int[len];
  int read_loc=0;
  for (int i=0;i<end;i++){
     bool found=false;
     tmp[i]=((buf[read_loc]>>24)|((buf[read_loc]>>8)&0xff00)|((buf[read_loc]<<8)&0xff0000)|(buf[read_loc]<<24));
    for (int j=0;uni_conv_multi[j].code!=0xffffffff;j++){
      if (uni_conv_multi[j].code==tmp[i]){
        if (uni_conv_multi[j].lower[0]){
          if (i<len)
            tmp[i]=uni_conv_multi[j].lower[0];
          if (uni_conv_multi[j].lower[1]){
            i++;
            end++;
            if (i<len)
              tmp[i]=uni_conv_multi[j].lower[1];
            if (uni_conv_multi[j].lower[2]){
              i++;
              end++;
              if (i<len)
                tmp[i]=uni_conv_multi[j].lower[2];};};};
        found=true;
        break;};};
    if (!found){
      for (int j=0;uni_conv[j].code!=0xffffffff;j++){
        if (uni_conv[j].code==tmp[i]){
          if (uni_conv[j].lower){
            if (i<len)
              tmp[i]=uni_conv[j].lower;};
          break;};};};
    read_loc++;};
  int limit=min(end,len);
  for (int i=0;i<limit;i++){
    buf[i]=((tmp[i]>>24)|((tmp[i]>>8)&0xff00)|((tmp[i]<<8)&0xff0000)|(tmp[i]<<24));};
  delete tmp;};

return (end);
};
//---------------------------------------------------------------------------

int GLK::buffer_to_title_case_uni(unsigned int *buf,int len,int numchars,bool lowerrest)
{
int end=numchars;

if (check_uni_conv()){
  unsigned int *tmp=new unsigned int[len];
  bool found=false;
  int i=0;
  tmp[0]=((buf[0]>>24)|((buf[0]>>8)&0xff00)|((buf[0]<<8)&0xff0000)|(buf[0]<<24));
    for (int j=0;uni_conv_multi[j].code!=0xffffffff;j++){
      if (uni_conv_multi[j].code==tmp[0]){
        if (uni_conv_multi[j].title[0]){
          if (0<len)
            tmp[0]=uni_conv_multi[j].title[0];
          if (uni_conv_multi[j].title[1]){
            i++;
            end++;
            if (1<len)
              tmp[1]=uni_conv_multi[j].title[1];
            if (uni_conv_multi[j].title[2]){
              i++;
              end++;
              if (2<len)
                tmp[2]=uni_conv_multi[j].title[2];};};};
        found=true;
        break;};};
    if (!found){
      for (int j=0;uni_conv[j].code!=0xffffffff;j++){
        if (uni_conv[j].code==tmp[0]){
          if (uni_conv[j].title){
            if (0<len)
              tmp[0]=uni_conv[j].title;};
          break;};};};
    i++;
    int limit=min(end,len);
    int read_loc=1;
    for (int j=i;j<limit;j++){
      tmp[j]=((buf[read_loc]>>24)|((buf[read_loc]>>8)&0xff00)|((buf[read_loc]<<8)&0xff0000)|(buf[read_loc]<<24));
      read_loc++;};
    for (int j=0;j<limit;j++){
      buf[j]=((tmp[j]>>24)|((tmp[j]>>8)&0xff00)|((tmp[j]<<8)&0xff0000)|(tmp[j]<<24));};
  delete (tmp);

  if (lowerrest){
    return (i+buffer_to_lower_case_uni(&buf[i],len-i,numchars-1));};};

return (end);
};
//----------------------------------------------------------------------------

bool GLK::check_uni_conv()
{
  if (uni_conv!=NULL)
    return (true);

  TFileStream *file;
  try{

  file=new TFileStream(ExtractFilePath(Application->ExeName)+"\\unicode1.dat", fmOpenRead);}

  catch (...){
    glk->error_message("Could not open the needed file unicode1.dat for unicode character conversion. Please ensure that this file is in the same directory as the Filfre interpreter itself.");
    return (false);};

  uni_conv=new UNI_CONV[file->Size/16];
  file->Read(uni_conv,file->Size);
  delete file;

  try{

  file=new TFileStream(ExtractFilePath(Application->ExeName)+"\\unicode2.dat", fmOpenRead);}

  catch (...){
    glk->error_message("Could not open the needed file unicode2.dat for unicode character conversion. Please ensure that this file is in the same directory as the Filfre interpreter itself.");
    delete uni_conv;
    return (false);};

  uni_conv_multi=new UNI_CONV_MULTI[file->Size/40];
  file->Read(uni_conv_multi,file->Size);
  delete file;

  return (true);
}
//---------------------------------------------------------------------------

int GLK::buffer_canon_decompose_uni(unsigned int *buf,int len,int numchars)
{
int end=numchars;

if (check_uni_norm()){
  unsigned int *tmp=new unsigned int[len];
  int read_loc=0;
  for (int i=0;i<end;i++){
    tmp[i]=((buf[read_loc]>>24)|((buf[read_loc]>>8)&0xff00)|((buf[read_loc]<<8)&0xff0000)|(buf[read_loc]<<24));
    end+=max(0,decompose_char(tmp[i],tmp,len,&i)-1);
    read_loc++;};
  int limit=min(end,len);
  sort_normalize(tmp,limit);
  for (int i=0;i<limit;i++){
    buf[i]=((tmp[i]>>24)|((tmp[i]>>8)&0xff00)|((tmp[i]<<8)&0xff0000)|(tmp[i]<<24));};
  delete tmp;};

return (end);
};
//---------------------------------------------------------------------------

int GLK::decompose_char(unsigned int code,unsigned int *tmp,int len,int *pos)
{
int result=0;

for (int j=0;uni_norm[j].code!=0xffffffff;j++){
  if (uni_norm[j].code==code){
    int subsplit=decompose_char(uni_norm[j].part1,tmp,len,pos);
    if (subsplit){
      result+=subsplit;}
    else{
      result+=1;
      if (*pos<len)
        tmp[*pos]=uni_norm[j].part1;};
    if (uni_norm[j].part2){
      subsplit=decompose_char(uni_norm[j].part2,tmp,len,pos);
      if (subsplit){
        result+=subsplit;}
      else{
        *pos=*pos+1;
        result+=1;
        if (*pos<len)
          tmp[*pos]=uni_norm[j].part2;};};
     break;};};

return (result);
}
//---------------------------------------------------------------------------

void GLK::sort_normalize(unsigned int *tmp, int limit)
{
  bool found=false;
  bool moved;
  do{
    moved=false;
    UNI_ORDER prev_order;
    for (int i=0;i<limit;i++){
      if (!found)
        prev_order.code=0;
      else
        found=false;
      for (int j=0;uni_order[j].code!=0xffffffff;j++){
        if (tmp[i]==uni_order[j].code){
          found=true;
          if (prev_order.code&&uni_order[j].order<prev_order.order){
            moved=true;
            tmp[i-1]=tmp[i];
            tmp[i]=prev_order.code;
            break;}
          else{
            prev_order=uni_order[j];};
          break;};};};
    found=false;}
  while (moved);
};                          
//---------------------------------------------------------------------------

int GLK::buffer_canon_normalize_uni(unsigned int *buf,int len,int numchars)
{
unsigned int *newbuf=new unsigned int[numchars*10];
memcpy(newbuf,buf,numchars*4);
int end=buffer_canon_decompose_uni(newbuf,numchars*10,numchars);
                           
unsigned int *tmp=new unsigned int[end];
int read_loc=0;
int last_real=0;
for (int i=0;i<end;i++){
  bool conv=false;
  tmp[i]=((newbuf[read_loc]>>24)|((newbuf[read_loc]>>8)&0xff00)|((newbuf[read_loc]<<8)&0xff0000)|(newbuf[read_loc]<<24));
  for (int j=0;i>0&&uni_order[j].code!=0xffffffff;j++){
    if (uni_order[j].code==tmp[i]){
      conv=true;
      for (int k=0;uni_norm[k].code!=0xffffffff;k++){
        if ((uni_norm[k].part1==tmp[last_real])&&(uni_norm[k].part2==tmp[i])){
          i--;
          end--;
          tmp[last_real]=uni_norm[k].code;
          break;};};
      break;};};
  if (!conv)
    last_real=i;
  read_loc++;};
int limit=min(end,len);
for (int i=0;i<limit;i++){
  buf[i]=((tmp[i]>>24)|((tmp[i]>>8)&0xff00)|((tmp[i]<<8)&0xff0000)|(tmp[i]<<24));};
delete tmp;
delete newbuf;

return (end);
}
//----------------------------------------------------------------------------

bool GLK::check_uni_norm()
{
  if (uni_norm!=NULL)
    return (true);

  TFileStream *file;
  try{

  file=new TFileStream(ExtractFilePath(Application->ExeName)+"\\unicode3.dat", fmOpenRead);}

  catch (...){
    glk->error_message("Could not open the needed file unicode3.dat for unicode character conversion. Please ensure that this file is in the same directory as the Filfre interpreter itself.");
    return (false);};

  uni_norm=new UNI_NORM[file->Size/12];
  file->Read(uni_norm,file->Size);
  delete file;

  try{

  file=new TFileStream(ExtractFilePath(Application->ExeName)+"\\unicode4.dat", fmOpenRead);}

  catch (...){
    glk->error_message("Could not open the needed file unicode4.dat for unicode character conversion. Please ensure that this file is in the same directory as the Filfre interpreter itself.");
    delete uni_norm;
    return (false);};

  uni_order=new UNI_ORDER[file->Size/8];
  file->Read(uni_order,file->Size);
  delete file;

  return (true);
}
//----------------------------------------------------------------------------

unsigned int *GLK::flip_string(wchar_t *str)
{
unsigned int *str_ptr=new unsigned int [wcslen(str)];
int count=0;
while (str[count]){
  str_ptr[count]=str[count];
  str_ptr[count]=((str_ptr[count]>>24)|((str_ptr[count]>>8)&0xff00)|((str_ptr[count]<<8)&0xff0000)|(str_ptr[count]<<24));
  count++;};
return str_ptr;
};
//----------------------------------------------------------------------------

void GLK::tab_complete(int target,String compare)
{
for (int i=0;i<window[target].textbuffer->history->Count;i++){
  if (compare==window[target].textbuffer->history->Strings[i].SubString(1,compare.Length())){
    window[target].textbuffer->retrieve_hist(i);
    return;};};
};
//----------------------------------------------------------------------------

void GLK::current_time(TIME_STRUCT *time_struct)
{
timeb time_tmp;
ftime(&time_tmp);

time_struct->high_sec=0;
time_struct->low_sec=time_tmp.time;
time_struct->microsec=time_tmp.millitm*1000;
};
//----------------------------------------------------------------------------

int GLK::current_simple_time(unsigned int factor)
{
return (time(NULL)/factor);
}
//----------------------------------------------------------------------------

void GLK::time_to_date_local(TIME_STRUCT *time_struct,DATE_STRUCT *date_struct)
{
time_to_date(time_struct,date_struct,_timezone);
}
//----------------------------------------------------------------------------

void GLK::time_to_date_utc(TIME_STRUCT *time_struct,DATE_STRUCT *date_struct)
{
time_to_date(time_struct,date_struct);
}
//----------------------------------------------------------------------------

void GLK::time_to_date(TIME_STRUCT *time_struct,DATE_STRUCT *date_struct,int time_zone_adjust)
{
LARGE_INTEGER tmp_large;
tmp_large.LowPart=time_struct->low_sec;
tmp_large.HighPart=time_struct->high_sec;
tmp_large.QuadPart-=time_zone_adjust;
tmp_large.QuadPart=(tmp_large.QuadPart*10000000)+116444736000000000;
FILETIME file_time;
file_time.dwLowDateTime=tmp_large.LowPart;
file_time.dwHighDateTime=tmp_large.HighPart;

SYSTEMTIME system_time;
FileTimeToSystemTime(&file_time,&system_time);

date_struct->year=system_time.wYear;
date_struct->month=system_time.wMonth;
date_struct->day=system_time.wDay;
date_struct->weekday=system_time.wDayOfWeek;
date_struct->hour=system_time.wHour;
date_struct->minute=system_time.wMinute;
date_struct->second=system_time.wSecond;
date_struct->microsec=time_struct->microsec;
};
//----------------------------------------------------------------------------

void GLK::simple_time_to_date_local(unsigned int time,unsigned int factor,DATE_STRUCT *date_struct)
{
  simple_time_to_date(time,factor,date_struct,_timezone);
}
//----------------------------------------------------------------------------

void GLK::simple_time_to_date_utc(unsigned int time,unsigned int factor,DATE_STRUCT *date_struct)
{
  simple_time_to_date(time,factor,date_struct);
}
//----------------------------------------------------------------------------

void GLK::simple_time_to_date(unsigned int time,unsigned int factor,DATE_STRUCT *date_struct,int time_zone_adjust)
{
LARGE_INTEGER tmp_large;
tmp_large.QuadPart=time*factor;
tmp_large.QuadPart-=time_zone_adjust;
tmp_large.QuadPart=(tmp_large.QuadPart*10000000)+116444736000000000;
FILETIME file_time;
file_time.dwLowDateTime=tmp_large.LowPart;
file_time.dwHighDateTime=tmp_large.HighPart;

SYSTEMTIME system_time;
FileTimeToSystemTime(&file_time,&system_time);

date_struct->year=system_time.wYear;
date_struct->month=system_time.wMonth;
date_struct->day=system_time.wDay;
date_struct->weekday=system_time.wDayOfWeek;
date_struct->hour=system_time.wHour;
date_struct->minute=system_time.wMinute;
date_struct->second=system_time.wSecond;
date_struct->microsec=0;
};
//----------------------------------------------------------------------------

void GLK::date_to_time_utc(DATE_STRUCT *date_struct,TIME_STRUCT *time_struct)
{
date_to_time(date_struct,time_struct);
}
//----------------------------------------------------------------------------

void GLK::date_to_time_local(DATE_STRUCT *date_struct,TIME_STRUCT *time_struct)
{
date_to_time(date_struct,time_struct,_timezone);
}
//----------------------------------------------------------------------------

void GLK::date_to_time(DATE_STRUCT *date_struct,TIME_STRUCT *time_struct,int time_zone_adjust)
{
__int64 norm_adjust=0;
date_struct->year=abs(date_struct->year);
if (date_struct->year<1601)
  date_struct->year=1970;                  
date_struct->month=abs(date_struct->month);
if (date_struct->month<1||date_struct->month>12)
  date_struct->month=1;
date_struct->weekday=abs(date_struct->weekday);
if (date_struct->weekday>6)
  date_struct->weekday=0;
if (date_struct->day<1||date_struct->day>31){
  norm_adjust+=(date_struct->day*86400-86400);
  date_struct->day=1;};
if (date_struct->hour<0||date_struct->hour>23){
  norm_adjust+=(date_struct->hour*3600);
  date_struct->hour=0;};
if (date_struct->minute<0||date_struct->minute>59){
  norm_adjust+=(date_struct->minute*60);
  date_struct->minute=0;};
if (date_struct->second<0||date_struct->second>59){
  norm_adjust+=date_struct->second;
  date_struct->second=0;};
date_struct->microsec=abs(date_struct->microsec);
if (date_struct->microsec>999999)
  date_struct->microsec=0;

SYSTEMTIME system_time;
system_time.wYear=date_struct->year;
system_time.wMonth=date_struct->month;
system_time.wDayOfWeek=date_struct->weekday;
system_time.wDay=date_struct->day;
system_time.wHour=date_struct->hour;
system_time.wMinute=date_struct->minute;
system_time.wSecond=date_struct->second;                 
system_time.wMilliseconds=date_struct->microsec/1000;

FILETIME file_time;
SystemTimeToFileTime(&system_time,&file_time);

LARGE_INTEGER tmp_large;      
tmp_large.LowPart=file_time.dwLowDateTime;
tmp_large.HighPart=file_time.dwHighDateTime;
tmp_large.QuadPart=(tmp_large.QuadPart-116444736000000000)/10000000;
tmp_large.QuadPart+=norm_adjust;
tmp_large.QuadPart-=time_zone_adjust;

time_struct->high_sec=tmp_large.HighPart;
time_struct->low_sec=tmp_large.LowPart;
time_struct->microsec=date_struct->microsec;
}
//----------------------------------------------------------------------------

int GLK::date_to_simple_time_utc(DATE_STRUCT *date_struct,unsigned int factor)
{
return (date_to_simple_time(date_struct,factor));
}
//----------------------------------------------------------------------------

int GLK::date_to_simple_time_local(DATE_STRUCT *date_struct,unsigned int factor)
{
return (date_to_simple_time(date_struct,factor,_timezone));
}
//----------------------------------------------------------------------------

int GLK::date_to_simple_time(DATE_STRUCT *date_struct,unsigned int factor,int time_zone_adjust)
{
__int64 norm_adjust=0;
date_struct->year=abs(date_struct->year);
if (date_struct->year<1601)
  date_struct->year=1970;
date_struct->month=abs(date_struct->month);
if (date_struct->month<1||date_struct->month>12)
  date_struct->month=1;
date_struct->weekday=abs(date_struct->weekday);
if (date_struct->weekday>6)
  date_struct->weekday=0;
if (date_struct->day<1||date_struct->day>31){
  norm_adjust+=(date_struct->day*86400-86400);
  date_struct->day=1;};
if (date_struct->hour<0||date_struct->hour>23){
  norm_adjust+=(date_struct->hour*3600);
  date_struct->hour=0;};
if (date_struct->minute<0||date_struct->minute>59){
  norm_adjust+=(date_struct->minute*60);
  date_struct->minute=0;};
if (date_struct->second<0||date_struct->second>59){
  norm_adjust+=date_struct->second;
  date_struct->second=0;};
date_struct->microsec=abs(date_struct->microsec);
if (date_struct->microsec>999999)
  date_struct->microsec=0;

SYSTEMTIME system_time;                
system_time.wYear=date_struct->year;
system_time.wMonth=date_struct->month;
system_time.wDayOfWeek=date_struct->weekday;
system_time.wDay=date_struct->day;
system_time.wHour=date_struct->hour;
system_time.wMinute=date_struct->minute;
system_time.wSecond=date_struct->second;
system_time.wMilliseconds=date_struct->microsec/1000;

FILETIME file_time;
SystemTimeToFileTime(&system_time,&file_time);

LARGE_INTEGER tmp_large;
tmp_large.LowPart=file_time.dwLowDateTime;
tmp_large.HighPart=file_time.dwHighDateTime;
tmp_large.QuadPart=(tmp_large.QuadPart-116444736000000000)/10000000;
tmp_large.QuadPart+=norm_adjust;
tmp_large.QuadPart-=time_zone_adjust;

int result=tmp_large.QuadPart/factor;
if ((result<0)&&(tmp_large.QuadPart%factor))
  result--;
return (result);
}
//----------------------------------------------------------------------------

void GLK::set_echo_line_event(int win,bool val)
{
if (win<1||win>49||!window[win-1].in_use||window[win-1].wintype!=WINTYPE_TEXTBUFFER)
  return;
int target=win-1;

window[target].line_input_echo=val;
}
//----------------------------------------------------------------------------

void GLK::clear_input_lines()
{
for (int i=0;i<49;i++){
  if (window[i].in_use&&window[i].wintype==WINTYPE_TEXTBUFFER&&!window[i].line_input_echo&&window[i].line_event){
    window[i].textbuffer->input_pos.cpMin-=(window[i].cursor_pos-1);
    window[i].textbuffer->input_pos.cpMax=window[i].textbuffer->input_pos.cpMin+window[i].input_text.Length();
    window[i].textbuffer->Perform(EM_EXSETSEL,NULL,(LONG)&window[i].textbuffer->input_pos);
    window[i].textbuffer->Perform(EM_SETTEXTEX,(LONG)&unicode_text,(LONG)blank);};};
}
//----------------------------------------------------------------------------

void GLK::set_terminators_line_event(int win,unsigned int *keycodes,int count)
{
if (win<1||win>49||!window[win-1].in_use||(window[win-1].wintype!=WINTYPE_TEXTBUFFER&&window[win-1].wintype!=WINTYPE_TEXTGRID))
  return;
int target=win-1;

if (count==0){
  memset(window[target].term_chars,0,256);
  window[target].term_chars[VK_RETURN]=true;};
  
for (int i=0;i<count;i++){
  switch (keycodes[i]){
    case KEYCODE_LEFT:
      window[target].term_chars[VK_LEFT]=true;
      break;
    case KEYCODE_RIGHT:
      window[target].term_chars[VK_RIGHT]=true;
      break;
    case KEYCODE_UP:
      window[target].term_chars[VK_UP]=true;
      break;
    case KEYCODE_DOWN:
      window[target].term_chars[VK_DOWN]=true;
      break;
    case KEYCODE_DELETE:
      window[target].term_chars[VK_DELETE]=true;
      break;
    case KEYCODE_ESCAPE:
      window[target].term_chars[VK_ESCAPE]=true;
      break;
    case KEYCODE_TAB:
      window[target].term_chars[VK_TAB]=true;
      break;
    case KEYCODE_PAGEUP:
      window[target].term_chars[VK_PRIOR]=true;
      break;
    case KEYCODE_PAGEDOWN:
      window[target].term_chars[VK_NEXT]=true;
      break;
    case KEYCODE_HOME:
      window[target].term_chars[VK_HOME]=true;
      break;
    case KEYCODE_END:
      window[target].term_chars[VK_END]=true;
      break;
    case KEYCODE_FUNC1:
      window[target].term_chars[VK_F1]=true;
      break;
    case KEYCODE_FUNC2:
      window[target].term_chars[VK_F2]=true;
      break;
    case KEYCODE_FUNC3:
      window[target].term_chars[VK_F3]=true;
      break;
    case KEYCODE_FUNC4:
      window[target].term_chars[VK_F4]=true;
      break;
    case KEYCODE_FUNC5:
      window[target].term_chars[VK_F5]=true;
      break;
    case KEYCODE_FUNC6:
      window[target].term_chars[VK_F6]=true;
      break;
    case KEYCODE_FUNC7:
      window[target].term_chars[VK_F7]=true;
      break;
    case KEYCODE_FUNC8:
      window[target].term_chars[VK_F8]=true;
      break;
    case KEYCODE_FUNC9:
      window[target].term_chars[VK_F9]=true;
      break;
    case KEYCODE_FUNC10:
      window[target].term_chars[VK_F10]=true;
      break;
    case KEYCODE_FUNC11:
      window[target].term_chars[VK_F11]=true;
      break;
    case KEYCODE_FUNC12:
      window[target].term_chars[VK_F12]=true;
      break;
    case KEYCODE_NUMPAD0:
      window[target].term_chars[VK_NUMPAD0]=true;
      break;
    case KEYCODE_NUMPAD1:
      window[target].term_chars[VK_NUMPAD1]=true;
      break;
    case KEYCODE_NUMPAD2:
      window[target].term_chars[VK_NUMPAD2]=true;
      break;
    case KEYCODE_NUMPAD3:
      window[target].term_chars[VK_NUMPAD3]=true;
      break;
    case KEYCODE_NUMPAD4:
      window[target].term_chars[VK_NUMPAD4]=true;
      break;
    case KEYCODE_NUMPAD5:
      window[target].term_chars[VK_NUMPAD5]=true;
      break;
    case KEYCODE_NUMPAD6:
      window[target].term_chars[VK_NUMPAD6]=true;
      break;
    case KEYCODE_NUMPAD7:
      window[target].term_chars[VK_NUMPAD7]=true;
      break;
    case KEYCODE_NUMPAD8:
      window[target].term_chars[VK_NUMPAD8]=true;
      break;
    case KEYCODE_NUMPAD9:
      window[target].term_chars[VK_NUMPAD9]=true;
      break;};};
}
//----------------------------------------------------------------------------

unsigned int GLK::translate_keycode(unsigned char keycode)
{
switch (keycode){
  case VK_LEFT:
    return (KEYCODE_LEFT);
  case VK_RIGHT:
    return (KEYCODE_RIGHT);
  case VK_UP:
    return (KEYCODE_UP);
  case VK_DOWN:
    return (KEYCODE_DOWN);
  case VK_DELETE:
    return (KEYCODE_DELETE);
  case VK_ESCAPE:
    return (KEYCODE_ESCAPE);
  case VK_TAB:
    return (KEYCODE_TAB);
  case VK_PRIOR:
    return (KEYCODE_PAGEUP);
  case VK_NEXT:
    return (KEYCODE_PAGEDOWN);
  case VK_HOME:
    return (KEYCODE_HOME);
  case VK_END:
    return (KEYCODE_END);
  case VK_F1:
    return (KEYCODE_FUNC1);
  case VK_F2:
    return (KEYCODE_FUNC2);
  case VK_F3:
    return (KEYCODE_FUNC3);
  case VK_F4:
    return (KEYCODE_FUNC4);
  case VK_F5:
    return (KEYCODE_FUNC5);
  case VK_F6:
    return (KEYCODE_FUNC6);
  case VK_F7:
    return (KEYCODE_FUNC7);
  case VK_F8:
    return (KEYCODE_FUNC8);
  case VK_F9:
    return (KEYCODE_FUNC9);
  case VK_F10:
    return (KEYCODE_FUNC10);
  case VK_F11:
    return (KEYCODE_FUNC11);
  case VK_F12:
    return (KEYCODE_FUNC12);
  case VK_NUMPAD0:
    return (KEYCODE_NUMPAD0);
  case VK_NUMPAD1:
    return (KEYCODE_NUMPAD1);
  case VK_NUMPAD2:
    return (KEYCODE_NUMPAD2);
  case VK_NUMPAD3:
    return (KEYCODE_NUMPAD3);
  case VK_NUMPAD4:
    return (KEYCODE_NUMPAD4);
  case VK_NUMPAD5:
    return (KEYCODE_NUMPAD5);
  case VK_NUMPAD6:
    return (KEYCODE_NUMPAD6);
  case VK_NUMPAD7:
    return (KEYCODE_NUMPAD7);
  case VK_NUMPAD8:
    return (KEYCODE_NUMPAD8);
  case VK_NUMPAD9:
    return (KEYCODE_NUMPAD9);
  default:
    return (0);};
}



