
#include <iostream>
#include <stdlib.h>
#include "ScreenInterface.h"
#include "Interpreter.h"

ScreenInterface::~ScreenInterface()
{ }

char *ScreenInterface::get_interface_name()
{ return NULL; }

bool ScreenInterface::is_status_line_available()
{ return false; }

bool ScreenInterface::is_split_screen_available()
{ return false; }

bool ScreenInterface::is_variable_pitch_font_default()
{ return false; }

bool ScreenInterface::is_color_available()
{ return false; }

bool ScreenInterface::is_picture_displaying_available()
{ return false; }

bool ScreenInterface::is_bold_face_available()
{ return false; }

bool ScreenInterface::is_italic_available()
{ return false; }

bool ScreenInterface::is_fixed_space_font_available()
{ return false; }

bool ScreenInterface::is_timed_keyboard_available()
{ return false; }

bool ScreenInterface::is_preloaded_input_available()
{ return false; }

bool ScreenInterface::is_character_graphics_font_availiable()
{ return false; }

bool ScreenInterface::is_picture_font_availiable()
{ return false; }

uint8_t ScreenInterface::get_screen_height()
{ return 0; }

uint8_t ScreenInterface::get_screen_width()
{ return 0; }

uint8_t ScreenInterface::get_screen_width_in_units()
{ return 0; }

uint8_t ScreenInterface::get_screen_height_in_units()
{ return 0; }

uint8_t ScreenInterface::get_font_width_in_units()
{ return 0; }

uint8_t ScreenInterface::get_font_height_in_units()
{ return 0; }

z_colour ScreenInterface::get_default_foreground_colour()
{ return Z_COLOUR_BLACK; }

z_colour ScreenInterface::get_default_background_colour()
{ return Z_COLOUR_WHITE; }

uint8_t ScreenInterface::get_total_width_in_pixels_of_text_sent_to_output_stream_3()
{ return 0; }

int ScreenInterface::parse_config_parameter(char *key, char *value)
{ return 1; }

void ScreenInterface::link_interface_to_story(struct z_story *story)
{ }

void ScreenInterface::reset_interface()
{ }

int ScreenInterface::close_interface(z_ucs *error_message)
{ return 0; }

void ScreenInterface::set_buffer_mode(uint8_t new_buffer_mode)
{ }

void ScreenInterface::z_ucs_output(z_ucs *z_ucs_output)
{
  while (*z_ucs_output != 0)
  {
    if ((*z_ucs_output & 0xffffff80) != 0)
      fputc('?', stdout);
    else
      fputc(*z_ucs_output & 0x7f, stdout);

    z_ucs_output++;
  }
}

int16_t ScreenInterface::read_line(zscii *dest, uint16_t maximum_length,
    uint16_t tenth_seconds, uint32_t verification_routine,
    uint8_t preloaded_input, int *tenth_seconds_elapsed,
    bool disable_command_history, bool return_on_escape)
{
  int input;
  int current_length = 0;
  uint8_t input_size = 0;
  zscii input_zscii;

  if ((input = fgetc(stdin)) == EOF)
  {
    exit(-1);
  }

  while ((input != 10) && (input != 13))
  {
    if (current_length < maximum_length)
    {
      input_zscii = Interpreter::unicode_char_to_zscii_input_char(input & 0xff);

      if ((input_zscii == 0xff) || (input_zscii == 27))
        input_zscii = '?';

      *(dest++) = input_zscii;

      input_size++;
    }

    if ((input = fgetc(stdin)) == EOF)
      exit(-1);
  }

  return input_size;
}

int ScreenInterface::read_char(uint16_t tenth_seconds,
    uint32_t verification_routine, int *tenth_seconds_elapsed)
{ return 0; }

void ScreenInterface::show_status(z_ucs *room_description, int status_line_mode,
    int16_t parameter1, int16_t parameter2)
{ }

void ScreenInterface::set_text_style(z_style text_style)
{ }

void ScreenInterface::set_colour(z_colour foreground, z_colour background,
    int16_t window)
{ }

void ScreenInterface::set_font(z_font font_type)
{ }

void ScreenInterface::split_window(int16_t nof_lines)
{ }

void ScreenInterface::set_window(int16_t window_number)
{ }

void ScreenInterface::erase_window(int16_t window_number)
{ }

void ScreenInterface::set_cursor(int16_t line, int16_t column, int16_t window)
{ }

uint16_t ScreenInterface::get_cursor_row()
{ return 0; }

uint16_t ScreenInterface::get_cursor_column()
{ return 0; }

void ScreenInterface::erase_line_value(uint16_t start_position)
{ }

void ScreenInterface::erase_line_pixels(uint16_t start_position)
{ }

void ScreenInterface::output_interface_info()
{ }

bool ScreenInterface::input_must_be_repeated_by_story()
{ return false; }

