
#ifndef i18n_h_INCLUDED
#define i18n_h_INCLUDED

#include "../locales-fizmo/i18n_codes.h"
#include "types.h"
#include "locales.h"

// 2^64 results in a number containing 20 digits.
#define MAXIMUM_FORMATTED_PARAMTER_LENGTH 20

#define i18n_OUTPUT_MODE_DEV_NULL 0
#define i18n_OUTPUT_MODE_STREAMS 1
#define i18n_OUTPUT_MODE_STRING 2

#include <stdarg.h>

#ifndef i18n_c_INCLUDED
/*@null@*/ /*@external@*/ extern struct locale *active_locale;
#endif /* i18n_c_INCLUDED */

/*
int i18n_locale_exists(char *locale_name, char *module_name);
void i18n_set_locale(char *locale_name, char *module_name);
*/
size_t _i18n_va_translate(int string_code, va_list ap);
size_t i18n_translate(int string_code, ...);
//int i18n_translate_padded(int string_code, ...); -> unused
/*@noreturn@*/ void i18n_translate_and_exit(int string_code,
    int exit_code, ...);
size_t i18n_message_length(int string_code, ...);
/*@null@*/ z_ucs *i18n_translate_to_string(int string_code, ...);

#ifdef STRICT_Z
void i18n_translate_warning(int string_code, char *opcode_name, ...);
#endif // STRICT_Z

#endif /* i18n_h_INCLUDED */

