
#include "sound.h"
#include "fizmo.h"
#include "i18n.h"
#include "tracelog.h"
#include "zpu.h"
#include "splint.h"


void opcode_sound_effect(void)
{
  int effect_number=1, effect=2, volume=8, repeats=255;
  uint16_t routine = 0;

  // VAR:245 15 5/3 sound_effect number effect volume routine
  TRACE_LOG("Opcode: SOUND_EFFECT\n");

  if (active_sound_interface != NULL)
  {
    if (number_of_operands >= 1)
    {
      effect_number = (int16_t)op[0];
      if (effect_number < 1)
        effect_number = 1;

      if (number_of_operands >= 2)
      {
        effect = (int16_t)op[1];
        if ( (effect < 1) || (effect > 4) )
          return;

        if (number_of_operands >= 3)
        {
          TRACE_LOG("op[2]: %d.\n", op[2]);

          volume = op[2] & 0xff;
          repeats = op[2] >> 8;

          if ( (volume < 1) || (volume > 8) )
            volume = 8;

          if (ver >= 5)
          {
            if (repeats < 1)
              // 255 loop forever.
              repeats = 255;
            else if (repeats > 255)
              repeats = 254;
          }
          else
            // -1 means take from file (repeat is also stored there).
            repeats = -1;

          if (number_of_operands >= 4)
            routine = op[3];
        }
      }
    }

    TRACE_LOG("Nr: %d, Effect: %d, Volume: %d, Repeats: %d, Routine: %d.\n",
        effect_number, effect, volume, repeats, routine);

    if (effect == 1)
      active_sound_interface->prepare_sound(effect_number, volume, repeats);
    else if (effect == 2)
      active_sound_interface->play_sound(effect_number,volume,repeats,routine);
    else if (effect == 3)
      active_sound_interface->stop_sound(effect_number);
    else if (effect == 4)
      active_sound_interface->finish_sound(effect_number);
  }
}

