/* init.c
 *
 *  foblub -- a Z-machine for TI calculators
 *  by Nils Gesbert, 2003
 *  based on `pinfocom' by InfoTaskForce.
 *  This program is free software; you can redistribute it and modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; see the file COPYING.  If not, write to the
 *  Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "infocom.h"


Bool
init (int largeur, int hauteur)
{
    unsigned long   i;
    word            num;
    byte            *p, *q;
    word resident_bytes;
    byte premier_bloc[BLOCK_SIZE];

    load_page (0, premier_bloc);
    /* Pas besoin de s'embter puisque l'ordre des octets sur le 68000 est le bon. */

    resident_bytes = ((header_t*)premier_bloc)->resident_bytes;

    base_ptr = (byte *)malloc(resident_bytes);
    if (!base_ptr) return FALSE;
    /*
     * Load resident memory
     */
    memcpy (base_ptr, premier_bloc, BLOCK_SIZE);
    for (i = 1; i < resident_bytes / BLOCK_SIZE; i++)
      load_page (i, base_ptr + i * BLOCK_SIZE);

    if (resident_bytes % BLOCK_SIZE) {
      load_page (i, premier_bloc);
      memcpy (base_ptr + i * BLOCK_SIZE, premier_bloc, resident_bytes % BLOCK_SIZE);
    }

    /* Comme la mmoire rsidente peut faire presque 64k, j'alloue la pile dans un bloc  part */

    stack_base = (word *)malloc(STACK_SIZE + 100);
    if (!stack_base) return FALSE;
    stack_base += STACK_SIZE / 2;

    /********** Cas particuliers **********/
    {
      typedef struct {
	enum stories id;
	word release;
	char serial_no[6];
      } story_identifier;
      
      unsigned int i;
      story_identifier story_list[] = {{AMFV, 77, "850814"}, {AMFV, 79, "851122"},
				       {BUREAUCRACY, 86, "870212"}, {BUREAUCRACY, 116, "870602"},
				       {TRINITY, 11, "860509"}, {TRINITY, 12, "860926"}};
      story = AUTRE;
      for (i = 0; i < sizeof(story_list) / sizeof(story_identifier); i++)
	if (data_head.release == story_list[i].release
	    && !strncmp (story_list[i].serial_no, data_head.serial_no, 6)) {
	  story = story_list[i].id;
	  break;
	}
    }

    /*
     * Set up pointers into resident storage, and information related
     * to it.
     */
    /* Tout a je l'ai transform en macros, cf. infocom.h */
    /*
     * Set up the vocabulary information: first read in the
     * end-of-sentence punctuation marks, then get the size of each
     * vocabulary entry and the number of words in it, and mark the
     * start and end of the vocab table.
     */

    /*     vocab = base_ptr + data_head.vocab_o; */ /* macro*/
    p = vocab;
    num = Z_TO_BYTE_I(p);
    q = wsbf_strt;
    while (num-- > 0)
        *q++ = *p++;
    end_of_sentence = q;

    /*     vocab_entry_size = Z_TO_BYTE_I(p); */ /* macro */
    /*     num_vocab_words = Z_TO_WORD_I(p); */ /* macro */

    strt_vocab_table = p + 3;
    /*     end_vocab_table = strt_vocab_table +
	   (vocab_entry_size * (num_vocab_words-1)); */ /* macro */

    p = (byte *)ws_table;
    while (*p != 0)
    {
        *q++ = *p++;
    }
    *q = 0;

    /* J'ajoute a au cas o : enchanter ne semble pas penser  passer en chasse fixe
     avant d'afficher la carte donc je signale que par dfaut j'utilise une police  chasse
     variable (a ne marche pas mais a ne peut pas vraiment faire de mal...) */

    F1_RESETB (B_ALT_PROMPT); /* On a une barre de statuts */
    F1_SETB (B_STATUS_WIN); /* et mme une fentre */
    F1_SETB (B_VARIABLE_FONT); /* Par dfaut on utilise la petite police  chasse variable */

    if (ENHANCED) {
      F1_RESETB (B_BOLD);
      F1_RESETB (B_ITALIC);
      F1_RESETB (B_TIMED_INPUT);
      if (story == TRINITY) largeur = 80;
      if (story == BUREAUCRACY && hauteur < 18) hauteur = 18;
      data_head.screen_rows = hauteur;
      data_head.screen_cols = largeur;
      if (ADVANCED) {
	/*
	 * If we have alternate alphabets, then load them in.
	 */
	/* a n'existe qu'en version 5 */
	if (data_head.alphabet_o != 0)
	  {
	    word    offset = data_head.alphabet_o;
	    
	    for (i = 0; i < 3 * 26; ++i)
	      table[i] = get_byte(offset++);
	  }
	
	data_head.screen_width = LCD_WIDTH;
	data_head.screen_height = LCD_HEIGHT;
	data_head.font_width = 4;
	data_head.font_height = 6;
	data_head.default_bg_colour = 9; /* white */
	data_head.default_fg_colour = 2; /* black */
	F1_RESETB (B_COLOUR);
	F2_RESETB (B_PICTURES);
	F2_RESETB (B_UNDO);
	F2_RESETB (B_MOUSE);
	F2_RESETB (B_SOUND);
      }
    }
    return (pg_init() && print_init());
}
