// ----------------------------------------------------------------------------
// DS Frotz
// 	
// description	:	DS version of GBA Frotz 
//					made with PAlib - www.palib.com -
//
// ----------------------------------------------------------------------------
// (c) 2006 papafuji - using PAlib
// ----------------------------------------------------------------------------

#include "font.h"

// ----------------------------------------------------------------------------
//  
// ----------------------------------------------------------------------------

#define TEXT_ADVENTURE									0
#define GRAPHIC_ADVENTURE								1
#define BITMAP_ADVENTURE								2

// ----------------------------------------------------------------------------
// constants
// ----------------------------------------------------------------------------

#define TOP_SCREEN										1
#define BOTTOM_SCREEN									0
#define DEBUG_SCREEN									TOP_SCREEN

// ----------------------------------------------------------------------------
// background indices & priorities
// ----------------------------------------------------------------------------

#define DRAWING_BG_INDEX								1
#define TILED_BG_INDEX									0

// ----------------------------------------------------------------------------
// official FROTZ COLORS
/*
#define BLACK_COLOUR 2
#define RED_COLOUR 3
#define GREEN_COLOUR 4
#define YELLOW_COLOUR 5
#define BLUE_COLOUR 6
#define MAGENTA_COLOUR 7
#define CYAN_COLOUR 8
#define WHITE_COLOUR 9
#define LIGHTGREY_COLOUR 10 	// INTERP_AMIGA only
#define MEDIUMGREY_COLOUR 11 	// INTERP_AMIGA only
#define DARKGREY_COLOUR 12 		// INTERP_AMIGA only
*/
// ----------------------------------------------------------------------------

// les gris
#define GRAY_COLORID(i)									(1+(i))
#define BLACK_COLORID									1
#define WHITE_COLORID									31
#define YELLOW_COLORID									32
#define RED_COLORID										33
// les couleurs FROTZ
#define FROTZ_COLORS_BASE								64
// les couleurs par defaut
#define TEXT_BLACK_COLORID								66
#define TEXT_RED_COLORID								67
#define TEXT_GREEN_COLORID								68
#define TEXT_YELLOW_COLORID								69
#define TEXT_BLUE_COLORID								70
#define TEXT_MAGENTA_COLORID							71
#define TEXT_CYAN_COLORID								72
#define TEXT_WHITE_COLORID								73
#define TEXT_LIGHTGREY_COLORID							74 		// INTERP_AMIGA only
#define TEXT_MEDIUMGREY_COLORID							75 		// INTERP_AMIGA only
#define TEXT_DARKGREY_COLORID							76 		// INTERP_AMIGA only
// les couleurs 'bold'
#define FROTZ_BOLD_COLORS_BASE							80
#define BOLD_BLACK_COLORID								82
#define BOLD_RED_COLORID								83
#define BOLD_GREEN_COLORID								84
#define BOLD_YELLOW_COLORID								85
#define BOLD_BLUE_COLORID								86
#define BOLD_MAGENTA_COLORID							87
#define BOLD_CYAN_COLORID								88
#define BOLD_WHITE_COLORID								89

#define NEW_BACKGROUND_COLOR							90
#define NEW_TEXT_COLOR									91

#define BOTTOM_BACKGROUND_COLOR							18

//#define TOP_BACKGROUND_COLORID							GRAY_COLORID(8)
#define TOP_BACKGROUND_COLORID							GRAY_COLORID(25)

#define DEFAULT_TEXT_BG_COLOR							TOP_BACKGROUND_COLORID
//#define DEFAULT_TEXT_COLOR								TEXT_WHITE_COLORID
#define DEFAULT_TEXT_COLOR								GRAY_COLORID(8)
#define DEFAULT_TEXT_SHADOW_COLOR						-1
/* 
#define INVERSE_TEXT_BG_COLOR							GRAY_COLORID(12)
#define INVERSE_TEXT_COLOR								GRAY_COLORID(4)
#define INVERSE_TEXT_SHADOW_COLOR						-1
#define BOLD_TEXT_COLOR									WHITE_COLORID
#define BOLD_TEXT_SHADOW_COLOR							BLACK_COLORID
*/

// ----------------------------------------------------------------------------
// char size and screen size
// ----------------------------------------------------------------------------

#define 		HMARGIN										5
#define 		VMARGIN										0

#define			NUM_COLS									41
#define			NUM_ROWS									20

#define 		REFRESH_TOP_SCREEN							1
#define 		REFRESH_BOTTOM_SCREEN						2

#define 		PRINT_CSTRING(_s_,_t_,_y_,_c1_,_c2_,_n_)	PRINT_STRING( _s_, _t_, 128-(6*(strlen(_t_)))/2,  	_y_, _c1_, _c2_, _n_ )

// ----------------------------------------------------------------------------
// input modes
// ----------------------------------------------------------------------------

#define 		INPUT_MODE_GRAFITI							0
#define 		INPUT_MODE_KEYBOARD							1
#define 		INPUT_MODE_NUMPAD							2

// ----------------------------------------------------------------------------
// 
// ----------------------------------------------------------------------------

extern char 	fatalMessage[1024];
extern int		graphicMode;
extern int 		imagesWidth;
extern int 		imagesHeight;

// ----------------------------------------------------------------------------
// drawing functions
// ----------------------------------------------------------------------------

extern void 	InitGFX				( void );
extern void 	InitScreens			( void );

extern void 	SetRefreshFlag		( int _flags );
extern void 	RefreshScreens		( int _flags );

extern void		SetMessage			( char* _message );
extern void		SetFatalMessage		( char* _message );
extern void 	SetOrder			( char* _order, int _flushRefresh );

extern char* 	GetSpriteText		( int _i );
extern int 		PickSprite			( int _x, int _y );
extern void 	ShowSprites			( void );
extern void 	HideSprites			( void );

extern void 	ChangeInputMode		( void );
extern int 		ProcessInputString	( char* _text, int timeout );
extern char 	ProcessInputChar	( int timeout );
extern void 	Wait( void );

// ----------------------------------------------------------------------------
// drawing functions
// ----------------------------------------------------------------------------

extern void 	DRAW_PROMPT			( int _screen, int _x, int _y, int _w, int _color );

extern void 	DRAW_RECT			( int _screen, int x0, int y0, int x1, int y1, int color );
extern void 	DRAW_HLINE			( int _screen, int x0, int x1, int y1, int color );
extern void 	DRAW_VLINE			( int _screen, int x0, int y0, int y1, int color );
extern void 	FILL_SCREEN			( int _screen, int color );

extern int		GetTextInverseFlag	( void );
extern int 		GetTextBoldFlag		( void );
//extern void 	SetTextStyle		( int _inverse, int _bold );
extern void 	SetTextStyle		( int _inverse, int _bold, int _fixed );
extern void 	SetTextColor		( int _clr 	);
extern void 	SetTextShadowColor	( int _clr 	);
extern void 	SetTextBGColor		( int _clr 	);

extern void 	SkipLines			( int _lines );
extern void 	PRINT_CHAR			( int _screen, char _char, int _x, int _y  );
extern void 	PRINT_STRING		( int _screen, char* _text, int x, int y, int letterCol, int shadowsCol, int _widthmax );

// ----------------------------------------------------------------------------
// (c) papafuji - 2006 - using PAlib
// ----------------------------------------------------------------------------

