// ----------------------------------------------------------------------------
// DS Magnetic
// 	
// description	:	DS version of Magnetic v2.2
//					made with PAlib - www.palib.com -
//
// ----------------------------------------------------------------------------
// (c) 2006 papafuji - using PAlib
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
// PAlib / system includes
// ----------------------------------------------------------------------------

#include <PA9.h>

#include <ctype.h> 
#include <unistd.h>

#include <fat.h> 
#include <sys/dir.h>
#include <fcntl.h>

// ----------------------------------------------------------------------------
// project includes
// ----------------------------------------------------------------------------

#include "main.h"
#include "draw.h"

// ----------------------------------------------------------------------------
// global variables
// ----------------------------------------------------------------------------

int						gUseFat						= 1;
int 					gFatStatus					= 0;
char					gSaveDirectory[80]			= "/";

bool 					lFatInitialized				= false;
char					lTmpFileName[256]			= "";

char*					lFNames[NB_FILES_MAX_ON_CART];
int						lFStates[NB_FILES_MAX_ON_CART];
int						lFSizes[NB_FILES_MAX_ON_CART];

// ----------------------------------------------------------------------------
// PF_DirExists : returns TRUE if a directory exists - 
// ----------------------------------------------------------------------------

int PF_DirExists( char* _dirName )
{
	DIR_ITER* 		dir;
	
	if ( (dir = diropen ( _dirName )) )
	{
		dirclose ( dir );
		return true;
	}
	return false;
}

// ----------------------------------------------------------------------------
// PF_FileExists : returns TRUE if a files exists - 
// ----------------------------------------------------------------------------

int PF_FileExists( char* _fileName )
{
	int		fp;

	if ( (fp = open ( _fileName, O_RDONLY )) > -1 )
	{
		close ( fp );
		return true;
	}
	return false;
}

// ----------------------------------------------------------------------------
// FAT initialisation
// ----------------------------------------------------------------------------

int PF_InitFat( void )
{
	int				i;
	
	if ( !gUseFat ) 
	{		
		PRINT_CSTRING	( BOTTOM_SCREEN, "- NO FAT - USE SRAM - ", 96, 31, 7, 240);
		gFatStatus = 0;
	}
	
	else if ( !lFatInitialized )
	{
		lFatInitialized = 1;
			
		for( i=0; i<NB_FILES_MAX_ON_CART; i++ )
		{
			lFNames[i] 	= NULL;
			lFStates[i] 	= 0;
			lFSizes[i] 	= 0;
		}

		if ( !(gFatStatus = fatInitDefault()) )
		{
			PRINT_CSTRING	( BOTTOM_SCREEN, "- unable to init FAT - ", 			96, 31, 7, 240);
			PRINT_CSTRING	( BOTTOM_SCREEN, "- games will be saved in SRAM - ",  	104, 31, 7, 240 );
			PRINT_CSTRING	( BOTTOM_SCREEN, "- click to continue - ",  			122, 31, 7, 240);
			Wait()	;
			return 0;
		}
	
		if ( !PF_DirExists( GAMESAVFILES_PATH ) )
		{
			PRINT_CSTRING	( BOTTOM_SCREEN, "- WARNING - ", 							64, 31, 7, 240);
			PRINT_CSTRING	( BOTTOM_SCREEN, "can't find a '/inform'/ folder", 			80, 31, 7, 240);
			PRINT_CSTRING	( BOTTOM_SCREEN, "on your cart... ", 						88, 31, 7, 240);
			PRINT_CSTRING	( BOTTOM_SCREEN, "-> games data will be saved in",			114, 31, 7, 240 );
			PRINT_CSTRING	( BOTTOM_SCREEN, "the ROOT folder!",  						122, 31, 7, 240);
			PRINT_CSTRING	( BOTTOM_SCREEN, "- click to continue - ",  				138, 31, 7, 240);
			Wait()	;
			strcpy( gSaveDirectory, DEFAULTSAVFILES_PATH );
		}
		else
		{
			strcpy( gSaveDirectory, GAMESAVFILES_PATH );
		}
		//DBG_PRINT( "FAT INIT. OK (sav dir : %s)", gSaveDirectory );
	}

	return gFatStatus;
}




// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// SAV files management
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

void StrToUpper( char* _outStr, char* _inStr )
{
	while( *_inStr )
	{
		*_outStr = islower( *_inStr ) ? toupper( *_inStr ) : *_inStr;
		_outStr ++;
		_inStr ++;
	}
	*_outStr = '\0';
}

// ----------------------------------------------------------------------------
// FAT : returns the file index of a .sav file (if it matches the gGameSavFileFormat)
// ----------------------------------------------------------------------------

int GetFileIndexFromFileName( char* _fileName )
{
	int		fileIndex = -1;
	
	if ( (sscanf( lTmpFileName, gGameSavFileFormat, &fileIndex ) != 1 ) || (fileIndex < 0) || (fileIndex >= NB_FILES_MAX_ON_CART) )
	{
		char	upperFileFormat[80];
		StrToUpper( upperFileFormat, gGameSavFileFormat );
		fileIndex = -1;
		if ( (sscanf( lTmpFileName, upperFileFormat, &fileIndex ) != 1 ) || (fileIndex < 0) || (fileIndex >= NB_FILES_MAX_ON_CART) )
		{
			fileIndex = -1;
			// file is not compatible
		}
	}

	return fileIndex;
}

// ----------------------------------------------------------------------------
// FAT : read .sav files from directory
// ----------------------------------------------------------------------------

int PF_ParseSAVFiles( void )
{
	int				i;
	int				fileIndex 		= -1;
	int				nbFilesFound 	= 0;
	DIR_ITER* 		dir				= NULL;
	struct stat	st;

	for( i=0; i<NB_FILES_MAX_ON_CART; i++ )
	{
		if ( lFNames[i] ) free( lFNames[i] );
		lFNames[i] 	= NULL;
		lFStates[i] 	= 0;
		lFSizes[i] 	= 0;
	}

	if ( gUseFat && gFatStatus ) 
	{
		if ( (dir = diropen ( gSaveDirectory )) )
		{
			while ( dirnext( dir, lTmpFileName, &st ) == 0 )
			{
//DBG_PRINT2( "PARSDIR : %s (sz %d)", lTmpFileName, (int)st.st_size );
				if( st.st_mode & S_IFDIR )
					continue;
	
				if ( ( fileIndex = GetFileIndexFromFileName( lTmpFileName ) ) < 0 )
					continue;

				lFNames[fileIndex] 	= strdup( lTmpFileName );
				lFStates[fileIndex] 	= st.st_mode;
				lFSizes[fileIndex] 	= st.st_size;
	
DBG_MSG3( "PARSDIR %d >>> %s (sz %d)", fileIndex, lFNames[fileIndex], lFSizes[fileIndex] );
	
				//strcpy( _filesNames[numFilesFound], tmp );
	//sprintf( tmp, "ReadDir %2d : %s (%d)", nbFilesFound, lFNames[nbFilesFound], lFSizes[nbFilesFound] );
	//PRINT(tmp);
	
				nbFilesFound ++;
			}
			
			dirclose ( dir );
		}
		else
		{
			DBG_PRINT( "ERROR OPENING DIR %s", gSaveDirectory );
		}
	}
//PRINT_CSTRING( "Start READ DIR /fattest/...", NULL );  

	return nbFilesFound;
}


// ----------------------------------------------------------------------------
// FAT : 	read a file as binary data 
//			the returned buffer must be freed by the caller
// ----------------------------------------------------------------------------

char* PF_ReadSAVFile( int _fileIndex, int* _size )
{
	int			fd		= 0;
	char*		buffer 	= NULL;
	int			size	= lFSizes[_fileIndex];
	int			s;
	
	DBG_MSG3( "PF_ReadSAVFile %d : %d %s ", _fileIndex, lFSizes[_fileIndex], lFNames[_fileIndex] );

	if ( 	gUseFat 												&&
			gFatStatus 												&& 
			(_fileIndex >= 0) 										&&
			(_fileIndex < NB_FILES_MAX_ON_CART)						&&
			(lFSizes[_fileIndex] > 0)								&&
			(lFNames[_fileIndex] != NULL)						
		)
	{
		sprintf( lTmpFileName, "%s%s", gSaveDirectory, lFNames[_fileIndex] );
		if ( (fd = open( lTmpFileName, O_RDONLY )) > -1 )
		{
		DBG_MSG2( "OPEN F#%d %s for READING", _fileIndex, lTmpFileName );
			buffer = (char*) malloc( size * sizeof(char) );
			if ( (s=read( fd, buffer, size )) != size )
			{
				DBG_MSG3( "ERROR READING F#%d (s%d r%d)", _fileIndex, size, s );
			}
			else
			{
				DBG_MSG2( "OK READ F#%d (s%d bytes)", _fileIndex, size );
			}
			close( fd );
		}
		else
		{
			DBG_MSG2( "ERROR OPENING F#%d %s", _fileIndex, lFNames[_fileIndex] );
		}
	}
	
	return buffer;
}

// ----------------------------------------------------------------------------
// FAT : 	open a file for writing
// ----------------------------------------------------------------------------

int PF_WriteSAVFile( int _fileIndex, char* _ptr, int _size )
{
	int		fd;

	if ( 	gUseFat 												&&
			gFatStatus 												&& 
			(_fileIndex >= 0) 										&&
			(_fileIndex < NB_FILES_MAX_ON_CART)						&&
			(_size > 0)												&&
			(_ptr != NULL)						
		)
	{
		sprintf( lTmpFileName, "%s%s", gSaveDirectory, gGameSavFileFormat );
		sprintf( lTmpFileName, lTmpFileName, _fileIndex );

		int		flags = (PF_FileExists( lTmpFileName )) ? O_WRONLY : (O_WRONLY|O_CREAT);
		
DBG_MSG2( "WriteSAVFile %d : OPEN %s", _fileIndex, lTmpFileName );

		if ( (fd = open( lTmpFileName, flags )) > -1 )
		{
		DBG_MSG2( "WriteSAVFile %d : WRITE %d bytes OK", _fileIndex, _size );
			write( fd, _ptr, _size );
			close( fd );
			
			
			if ( lFNames[_fileIndex] ) free( lFNames[_fileIndex] );
	
			lFNames[_fileIndex] 	= strdup( lTmpFileName );
			lFSizes[_fileIndex] 	= _size;
			lFStates[_fileIndex] = S_IFREG;
			return _size;
		}
		else
		{
			DBG_MSG2( "ERROR WRITING F#%d %s", _fileIndex, lTmpFileName );
		}
	}

	return 0;
}


// ----------------------------------------------------------------------------
// (c) papafuji - 2006 - using PAlib
// ----------------------------------------------------------------------------
