// FROTZS5.CPP
//
//
// (C) Copyright Frederic Bouvry 1997
//
//


#define NBFONTS 4

// * 20 on the S5 :-)
const static fontstwips[NBFONTS] =
{140, 160, 180, 220};

#include <eikfnlab.h>
#include <coeutils.h>
#include <eikcfdlg.h>
#include <eikdoc.h>
#include <eikon.rsg>
#include <eikfutil.h>
#include "frotzs5.h"
#include "s5api.h"
#include "s5inter.h"

void CKeyTimer::Start(CFrotzAppUi *ptr, int delay)
{
  papp = ptr;
  ConstructL();
  CActiveScheduler::Add(this);
  After(delay);
}

void CKeyTimer::RunL(void)
{
	if(papp->waitingkey)
	{
		papp->waitingkey = 0;
		papp->SemaKey.Signal();
	}
}

int DlgOpen(char *pathsrc, char *file)
{
TFileName fileName = _L(pathsrc);
if(!EikFileUtils::PathExists(fileName))
  fileName = _L("C:\\Documents\\");
fileName += _L(file);
CEikFileOpenDialog* dialog=new(ELeave) CEikFileOpenDialog(&fileName);
if (dialog->ExecuteLD(R_EIK_DIALOG_FILE_OPEN))
    {
    int len = fileName.Length();
    Srvmemcpy(file, (void *)fileName.Ptr(), len);
    file[len] = '\0';
    return 1;
    }
return 0;
}

int DlgSave(char *pathsrc, char *file)
{
TFileName fileName = _L(pathsrc);
if(!EikFileUtils::PathExists(fileName))
  fileName = _L("C:\\Documents\\");
fileName += _L(file);
CEikFileSaveAsDialog* dialog=new(ELeave) CEikFileSaveAsDialog(&fileName);
if (dialog->ExecuteLD(R_EIK_DIALOG_FILE_SAVEAS))
    {
    int len = fileName.Length();
    Srvmemcpy(file, (void *)fileName.Ptr(), len);
    file[len] = '\0';
    return 1;
    }
return 0;
}

//**********************************
//CMainServServer
//**********************************

CMainServServer::CMainServServer(TInt aPriority)
    : CServer(aPriority)
    {
    __DECLARE_NAME(_S("FrotzServer"));
    }


// Create and start a new Main server.
CMainServServer* CMainServServer::New(CFrotzAppUi *ptr)
    {
    ptr->pS = new CMainServServer(EPriority);
    ptr->pS->papp = ptr;
    __ASSERT_ALWAYS(ptr->pS!=NULL,PanicServer(ESvrCreateServer));

	TBuf<64> tempsrv;

	//Create a unique name for the server based on random number
	//This added in v1.8 allows multiple instances of FrotzS5
	tempsrv.Format(_L("FrotzS%d"),ptr->threadrand);

    HBufC *pN=tempsrv.Alloc();
    __ASSERT_ALWAYS(pN!=NULL,PanicServer(ESvrCreateServer));
    ptr->pS->iName=pN;
    TInt r=ptr->pS->Start();
    __ASSERT_ALWAYS(r==KErrNone,PanicServer(ESvrStartServer));
    return ptr->pS;
    }


// Create a new server session.
CSession *CMainServServer::NewSessionL(RThread aClient, const TVersion &aVersion) const
    {
    // check we're the right version
    TVersion v(KMainServMajorVersionNumber,KMainServMinorVersionNumber,KMainServBuildVersionNumber);
    if (!User::QueryVersionSupported(v,aVersion))
        User::Leave(KErrNotSupported);
    // make new session
    CMainServSession *pss = CMainServSession::NewL(aClient, (CMainServServer*)this);
    pss->papp = papp;
    return pss;
    }


//**********************************
//CMainServSession
//**********************************


// constructor - must pass client to CSession
CMainServSession::CMainServSession(RThread &aClient, CMainServServer * aServer)
    : CSession(aClient)
    {
    __DECLARE_NAME(_S("FrotzServer"));
    aServer = aServer;
    }

CMainServSession* CMainServSession::NewL(RThread &aClient, CMainServServer * aServer)
    {
    return new(ELeave) CMainServSession(aClient,aServer);
    }


void CMainServSession::ServiceL(const RMessage& aMessage)
    {
    DispatchMessageL(aMessage);
    aMessage.Complete(err);
    }



// service a client request; test the opcode and then do appropriate servicing
void CMainServSession::DispatchMessageL(const RMessage &aMessage)
    {
    switch (aMessage.Function())
      {
      case EMainServPrintf:
           papp->iCons->Printf(_L(aMessage.Ptr0()));
           return;
      case EMainServGetCh:
           {
           TKeyEvent iKeyEvent;
           if(!papp->keyready)
             {
             err = 0;
             return;
             }
           if(papp->iKeyEventQ->Count() == 0)
             {
             papp->keyready = 0;
             err = 0;
             return;
             }
           papp->iKeyEventQ->Remove(&iKeyEvent);
           if(papp->iKeyEventQ->Count() == 0)
             papp->keyready = 0;
           err = iKeyEvent.iCode;
           return;
           }

      case EMainServKeyTimer:
           {
           int delay;
           delay = *((int *)aMessage.Ptr0());
           if(papp->keytimer)
              {
              papp->keytimer->Cancel();
              delete papp->keytimer;
              papp->keytimer = NULL;
              }
           papp->keytimer = new CKeyTimer();
           papp->keytimer->Start(papp, delay);
           return;
           }
      case EMainServEraseRect:
          {
          TRect r;
          int inv, attr;
          r = *((TRect *)aMessage.Ptr0());
          if(r.iTl.iX >= papp->cscreenwidth)
              return;
          if(r.iBr.iX > papp->cscreenwidth)
            r.iBr.iX = papp->cscreenwidth;
          if(r.iBr.iY > papp->cscreenheight)
            r.iBr.iY = papp->cscreenheight;
          inv = *((int *)aMessage.Ptr1());
          attr = (inv & 1 ? ATT_INVERSE : 0);
          papp->iCons->ClearChars(r, attr);
          return;
          }
      case EMainServScroll:
          {
          TRect r;
          TPoint p;
          r = *((TRect *)aMessage.Ptr0());
          if(r.iTl.iX >= papp->cscreenwidth)
              return;
          if(r.iBr.iX > papp->cscreenwidth)
            r.iBr.iX = papp->cscreenwidth;
          if(r.iBr.iY > papp->cscreenheight)
            r.iBr.iY = papp->cscreenheight;
          p = *((TPoint *)aMessage.Ptr1());
          papp->iCons->ScrollChars(r, p);
          return;
          }
      case EMainServCursor:
           {
           int curon;
           curon = *((int *)aMessage.Ptr0());
           if(curon)
               papp->iCons->DrawCursor();
           else
               papp->iCons->HideCursor();
           return;
           }
      case EMainServTextAttr:
           {
           int attr;
           papp->boldtoggled = 0;
           attr = *((int *)aMessage.Ptr0());
           papp->cattr = (attr & 1 ? ATT_INVERSE : 0);
           if(papp->cboldmode)
             {
             papp->cattr |= ATT_BOLD;
             papp->cattr |= (attr & 2 ? ATT_UNDERLINE : 0);
             papp->cattr |= (attr & 4 ? ATT_ITALIC : 0);
               papp->iCons->SetAtt(papp->cattr);
             }
           else
             {
             papp->cattr |= (attr & 2 ? ATT_ITALIC : 0);
             papp->cattr |= (attr & 4 ? ATT_BOLD : 0);
               papp->iCons->SetAtt(papp->cattr);
             }
           return;
           }
      case EMainServPutChar:
           {
           int attr;
           TPoint pt;
		   TPtrC8 p((unsigned char *)aMessage.Ptr2(), 1);
           pt.iX = *((int *)aMessage.Ptr0());
           pt.iY = *((int *)aMessage.Ptr1());
           if(pt.iX >= papp->cscreenwidth)
             return;
           if(pt.iY >= papp->cscreenheight)
             return;
           papp->iCons->SetCursorPosAbs(pt);
           if(papp->cattr & ATT_INVERSE)
             papp->iCons->ClearChars(TRect(pt, pt), ATT_INVERSE);
           
           if(papp->boldtoggled)
           {
               papp->boldtoggled = 0;
               if(papp->cboldmode)
                 {
                 attr = ATT_BOLD;
                 if(papp->cattr & ATT_ITALIC)
                   attr |= ATT_UNDERLINE;
                 if(papp->cattr & ATT_BOLD)
                   attr |= ATT_ITALIC;
                 }
               else
                 {
                      attr = 0;
                 if(papp->cattr & ATT_UNDERLINE)
                   attr |= ATT_ITALIC;
                 if(papp->cattr & ATT_ITALIC)
                   attr |= ATT_BOLD;
                 }
               if(papp->cattr & ATT_INVERSE)
                 attr |= ATT_INVERSE;
               papp->cattr = attr;
               papp->iCons->SetAtt(attr);
           }
           papp->iCons->Write(p);
           return;
           }
	  case EMainServPutString:
		  // Displays a string at the specified cursor location
		{
		   TPoint pt;
		   int attr, i;
		   pt.iX = *((int *)aMessage.Ptr0());
           pt.iY = *((int *)aMessage.Ptr1());
           if(pt.iX >= papp->cscreenwidth) return;
           if(pt.iY >= papp->cscreenheight) return;
		   papp->iCons->SetCursorPosAbs(pt);
		   // If we're writing an inverse block then erase the area
		   // just incase there already was an inverse block. Must clear first one
		   // before overwriting.
		   if(papp->cattr & ATT_INVERSE)
			{
				i = _L(aMessage.Ptr2()).Length();
           		papp->iCons->ClearChars(TRect(pt.iX, pt.iY, (pt.iX + i), 1), ATT_INVERSE);
			}

           if(papp->boldtoggled)
           {
               papp->boldtoggled = 0;
               if(papp->cboldmode)
                 {
                 attr = ATT_BOLD;
                 if(papp->cattr & ATT_ITALIC)
                   attr |= ATT_UNDERLINE;
                 if(papp->cattr & ATT_BOLD)
                   attr |= ATT_ITALIC;
                 }
               else
                 {
                      attr = 0;
                 if(papp->cattr & ATT_UNDERLINE)
                   attr |= ATT_ITALIC;
                 if(papp->cattr & ATT_ITALIC)
                   attr |= ATT_BOLD;
                 }
               if(papp->cattr & ATT_INVERSE)
                 attr |= ATT_INVERSE;
               papp->cattr = attr;
               papp->iCons->SetAtt(attr);
           }
 
		   papp->iCons->Write(_L(aMessage.Ptr2())); 
			return;
		  }
      case EMainServSetCursor:
          {
          TPoint pt;
          pt = *((TPoint *)aMessage.Ptr0());
          if(pt.iX >= papp->cscreenwidth)
            return;
          if(pt.iY >= papp->cscreenheight)
            return;
          papp->iCons->SetCursorPosAbs(pt);
          return;
          }
      case EMainServDlgOpen:
        {
         int len;
        TFileName fpath;
        err = DlgOpen((char *)aMessage.Ptr0(), (char *)aMessage.Ptr1());
        if(err)
          {
          fpath = EikFileUtils::DriveAndPathFromFullName(_L((char *)aMessage.Ptr1()));
          len = fpath.Length();
          Srvmemcpy(papp->savepath, (void *)fpath.Ptr(), len);
		  *(papp->savepath + len) = '\0';
          }
           papp->iControl->SetFocus(ETrue,EDrawNow);
        return;
        }
      case EMainServDlgSave:
        {
         int len;
        TFileName fpath;
        err = DlgSave((char *)aMessage.Ptr0(), (char *)aMessage.Ptr1());
        if(err)
          {
          fpath = EikFileUtils::DriveAndPathFromFullName(_L((char *)aMessage.Ptr1()));
          len = fpath.Length();
          Srvmemcpy(papp->savepath, (void *)fpath.Ptr(), len);
		   *(papp->savepath + len) = '\0';
          }
           papp->iControl->SetFocus(ETrue,EDrawNow);
        return;
        }
      case EMainServGetApp:
        {
        CFrotzAppUi **perr = (CFrotzAppUi **)&err;
        *perr = papp;
        return;
        }
      case EMainServGetStoryName:
        {
        Srvstrcpy((char *)aMessage.Ptr0(), papp->thestoryname);
        return;
        }
      case EMainServTerminate:
        {
        papp->storyrunning = 0;
         papp->iCons->HideCursor();
        papp->DrawUserScreen();
        err = 0;
        return;
        }
        // requests we don't understand at all are a different thing,
        // so panic the client here, this function also completes the message
    default:
          PanicClient(EBadRequest);
          return;
      }
    }


// panic the client
void CMainServSession::PanicClient(TInt aPanic) const
    {
    Panic(_L("MainServ server"),aPanic);
    }


// write to the client thread; if unsuccessful, panic the client
void CMainServSession::Write(const TAny* aPtr,const TDesC8& aDes,TInt anOffset)
    {
    TRAPD(ret,WriteL(aPtr,aDes,anOffset);)
    if (ret!=KErrNone)
        PanicClient(EBadDescriptor);
    }

//**********************************
//Global functions
//**********************************

// Panic the server
GLDEF_C void PanicServer(TMainServPanic aPanic)
    {
    User::Panic(_L("Main server panic"),aPanic);
    }
////////////////////////////////////////////////////////////////////////////////////////
//                            CFrotzAppUi
////////////////////////////////////////////////////////////////////////////////////////



//////////////////////////////////////////////////////

void CFrotzAppUi::HandleCommandL(TInt aCommand)
    {
      // Handle the command generated by:
      //   1. menu item selection
      //   2. short-cut key press
switch (aCommand)
        {
        // Copy command
    case EEikCmdEditCut:            // <---Pre-defined command id
    case EEikCmdEditCopy:           // <---Pre-defined command id
    case EEikCmdEditPaste:          // <---Pre-defined command id
    case EEikCmdEditSelectAll:      // <---Pre-defined command id
        iEikonEnv->InfoMsg(_L("Not used by Frotz"));
        return;
        // Infrared command
    case EEikCmdIrdaSend:
    case EEikCmdIrdaReceive:
        iEikonEnv->InfoMsg(_L("Deathmatch mode not implemented :-)"));
        break;
        // Help
        // Zoom in command
    case EEikCmdZoomIn:             // <---Pre-defined command id
        {
         if(storyrunning)
          {
          iEikonEnv->InfoMsg(_L("Terminate active story first"));
          return;
          }
        cfontsize++;
        if(cfontsize == NBFONTS)
            cfontsize = 0;
        iCons->ClearScreen();
        iCons->SetFontL(TFontSpec(_L("Courier"), fontstwips[cfontsize]));
        cscreenwidth = (iControl->Size().iWidth/iControl->CharSize().iWidth) - 1;
        cscreenheight = iControl->Size().iHeight/iControl->CharSize().iHeight;
        DrawUserScreen();
        break;
        }
        // Zoom out command
    case EEikCmdZoomOut:            // <---Pre-defined command id       
        {
         if(storyrunning)
          {
          iEikonEnv->InfoMsg(_L("Terminate active story first"));
          return;
          }
        if(cfontsize == 0)
            cfontsize = NBFONTS - 1;
        else
            --cfontsize;
        iCons->ClearScreen();
        iCons->SetFontL(TFontSpec(_L("Courier"), fontstwips[cfontsize]));
        cscreenwidth = (iControl->Size().iWidth/iControl->CharSize().iWidth) - 1;
        cscreenheight = iControl->Size().iHeight/iControl->CharSize().iHeight;
        DrawUserScreen();
        break;
        }
        // Show toolbar command
    case EEikCmdShowToolbar:
		// Screen too small for a Toolbar
		if (consolepixelwidth < 600) break;
        {
         if(storyrunning)
          {
          iEikonEnv->InfoMsg(_L("Terminate active story first"));
          return;
          }
        ctoolbar = (ctoolbar ? 0 : 1);
        delete iCons;
        iCons = new(ELeave) CEikConsoleScreen;
		if(ctoolbar)
			MakeToolBarVisible(ETrue);
		else {
			MakeToolBarVisible(EFalse);
		}
        iCons->ConstructL(_L("FrotzConsole"), TSize((ctoolbar ? (consolepixelwidth-70): consolepixelwidth),consolepixelheight), 0, EEikConsWinInPixels);
		iControl=iCons->ConsoleControl();
        iControl->SetFocus(ETrue,EDrawNow);
        iCons->HideCursor();
        iCons->SetFontL(TFontSpec(_L("Courier"), fontstwips[cfontsize]));
        cscreenwidth = (iControl->Size().iWidth/iControl->CharSize().iWidth) - 1;
        cscreenheight = iControl->Size().iHeight/iControl->CharSize().iHeight;
        DrawUserScreen();
        break;
        }
    case EEikCmdTerminate:
          {
          TKeyEvent iKeyEvent;
          if(!storyrunning)
            {
            iEikonEnv->InfoMsg(_L("No active story"));
            return;
            }
          CEikDialog* dialog = new (ELeave) CExampleAboutDialog();
          if(!dialog->ExecuteLD(R_EXAMPLE_KILL_DIALOG))
            return;
          if(keytimer)
            {
            keytimer->Cancel();
            delete keytimer;
            keytimer = NULL;
            }
          waitingkey = 0;
          FrotzThread.Terminate(0);
          while(iKeyEventQ->Count() > 0)
              iKeyEventQ->Remove(&iKeyEvent);
          keyready = 0;
          waitingkey = 0;
          storyrunning = 0;
            cattr = 0;
          iCons->HideCursor();
          iCons->SetAtt(cattr);
          DrawUserScreen();
        
          break;
          }
    case EEikCmdOpenStory:
        {
        TKeyEvent iKeyEvent;
        if(storyrunning)
          {
          CEikDialog* dialog = new (ELeave) CExampleAboutDialog();
          if(!dialog->ExecuteLD(R_EXAMPLE_KILL_DIALOG))
            return;
          if(keytimer)
            {
            keytimer->Cancel();
            delete keytimer;
            keytimer = NULL;
            }
          waitingkey = 0;
            FrotzThread.Terminate(0);
          while(iKeyEventQ->Count() > 0)
              iKeyEventQ->Remove(&iKeyEvent);
          keyready = 0;
          waitingkey = 0;
          storyrunning = 0;
          cattr = 0;
          iCons->HideCursor();
          iCons->SetAtt(cattr);
          DrawUserScreen();
          }
        cattr = 0;
        iCons->HideCursor();
        iCons->SetAtt(cattr);
        thestoryname[0] = '\0';
        if(DlgOpen(storypath, thestoryname))
            {
            TInt err;
            TBuf<20> threadName;
            TInt num=0;
             int len;
            TFileName fpath;
            fpath = EikFileUtils::DriveAndPathFromFullName(_L(thestoryname));
            len = fpath.Length();
            Srvmemcpy(storypath, (void *)fpath.Ptr(), len);
			*(storypath + len) = '\0';

			//Display story name in Task list
			Document()->Process()->SetMainDocFileName(_L(thestoryname));
			iEikonEnv->UpdateTaskNameL();

            iControl->SetFocus(ETrue,EDrawNow);
            do
                {
                threadName.Format(_L("FR%02d"),num++); // !! review the title

				//Pass thread id and the random number used to generate the Server name
				iparampass.iVar1 = (TInt)&FrotzThread;
				iparampass.iVar2 = threadrand;
                err=FrotzThread.Create(threadName,FrotzStartFunction, 70000,1000, 2000000, &iparampass, EOwnerProcess);
                } while(err==KErrAlreadyExists);
            if (!err)
                {
                FrotzThread.Resume();
                }
            }
        break;
        }
    case EEikCmdExit:
        {
        if(storyrunning)
          {
          TKeyEvent iKeyEvent;
          CEikDialog* dialog = new (ELeave) CExampleAboutDialog();
          if(!dialog->ExecuteLD(R_EXAMPLE_KILL_DIALOG))
            return;
          waitingkey = 0;
          FrotzThread.Terminate(0);
          waitingkey = 0;
          while(iKeyEventQ->Count() > 0)
              iKeyEventQ->Remove(&iKeyEvent);
          storyrunning = 0;
          }
        UpdateProfile();
        CBaActiveScheduler::Exit();
        break;
        }
    case EEikCmdBoldMode:
        {
        cboldmode = (cboldmode ? 0 : 1);
        if(storyrunning)
          boldtoggled = 1;
        else
          DrawUserScreen();
        break;
        }
    case EEikCmdAbout:
        {
        CEikDialog* dialog = new (ELeave) CExampleAboutDialog();
        dialog->ExecuteLD(R_EXAMPLE_ABOUT_DIALOG);
        }
        break;
    default :
        break;
        }
    }

void CFrotzAppUi::ConstructL()
        {
    Srvstrcpy(storypath, "C:\\Frotz\\Story\\");
    Srvstrcpy(savepath, "C:\\Frotz\\Save\\");
    cfontsize = 1;
    ctoolbar = 1;
    cboldmode = 1;
	// Screen size in pixels 
    consolepixelwidth = iCoeEnv->ScreenDevice()->SizeInPixels().iWidth;
	consolepixelheight = iCoeEnv->ScreenDevice()->SizeInPixels().iHeight;
    ReadProfile();
    cattr = 0;
    storyrunning = 0;
    keyready = 0;
    keytimer = NULL;
    waitingkey = 0;
    BaseConstructL();
    SemaKey.CreateLocal(0);

	TTime time;
	time.HomeTime();
	TInt64 aSeed=time.Int64();
	threadrand = Math::Rand(aSeed);		//Generate random number for Thread server name

    iMainSvr = CMainServServer::New(this);
    // notify the kernel that a server has started.
    #if defined (__WINS__)
    UserSvr::ServerStarted();
    #endif
    // all well
    iCons = new(ELeave) CEikConsoleScreen;
    if(ctoolbar && consolepixelwidth >= 600)
        MakeToolBarVisible(ETrue);
    else {
        MakeToolBarVisible(EFalse);
		ctoolbar = 0;
	}

	CEikFileNameLabel* filenameLabel=STATIC_CAST(CEikFileNameLabel*, iToolBar->ControlById(EFrotzCmdFileName));
	filenameLabel->UpdateL();
	filenameLabel->DrawNow(); 



    iKeyEventQ=new(ELeave) CCirBuf<TKeyEvent>;
    iKeyEventQ->SetLengthL(40);     // buffer length, too high? too low?
    iCons->ConstructL(_L("FrotzConsole"), TSize((ctoolbar ? (consolepixelwidth-70): consolepixelwidth),consolepixelheight), 0, EEikConsWinInPixels);
    iControl=iCons->ConsoleControl();
    iControl->SetFocus(ETrue,EDrawNow);
    iCons->HideCursor();
    iCons->SetFontL(TFontSpec(_L("Courier"), fontstwips[cfontsize]));
    cscreenwidth = (iControl->Size().iWidth/iControl->CharSize().iWidth) - 1;
    cscreenheight = iControl->Size().iHeight/iControl->CharSize().iHeight;
    DrawUserScreen();
    }


CFrotzAppUi::~CFrotzAppUi()
    {
    if(keytimer)
      {
      keytimer->Cancel();
      delete keytimer;
      }
    delete iCons;
    delete iMainSvr;
    delete iKeyEventQ;
    }


void CFrotzAppUi::MakeToolBarVisible(TBool aVisible)
    {
    iToolBar->MakeVisible(aVisible);
    }


// needed for setting radio button in menu pane
void CFrotzAppUi::DynInitMenuPaneL(TInt aMenuId,CEikMenuPane* aMenuPane)
    {
	switch (aMenuId)
		{
	case R_EXAMPLE_VIEW_MENU: // Identify the menu pane using its ID
		{
		if (consolepixelwidth < 600) 
			aMenuPane->SetItemDimmed(EEikCmdShowToolbar,ETrue);
		break;
		}

	default:
		break;
	
		} //End of switch
    }

void CFrotzAppUi::HandleKeyEventL(const TKeyEvent& aKeyEvent,TEventCode aType)
    {
    TKeyEvent keyev = aKeyEvent;
    if(aType != EEventKey)
      return;
    if((keyev.iCode == 8) && (keyev.iModifiers & EModifierShift))
        keyev.iCode = 0x1006;
    if(keyev.iModifiers & EModifierCtrl)
	{
		if(keyev.iScanCode == EStdKeyRightArrow)
			keyev.iCode = 0x1000;
		else
		if(keyev.iScanCode == EStdKeyLeftArrow)
			keyev.iCode = 0x1001;
	}

	if(iKeyEventQ->Add(&keyev) == 0)
		CEikonEnv::Beep();
	keyready = 1;

	// Clear timer if it is running
	if(keytimer)
    {
            keytimer->Cancel();
            delete keytimer;
            keytimer = NULL;
    }
	// client may be waiting on this key event
	if(waitingkey) 
	{
		waitingkey = 0; 
		SemaKey.Signal();
	}
	}

////////////////////////////////////////////////////////////////////////////////////////
//                            CFrotzDocument
////////////////////////////////////////////////////////////////////////////////////////


class CFrotzDocument : public CEikDocument
    {
public:
    CFrotzDocument(CEikApplication& aApp): CEikDocument(aApp) { }
private: // from CApaDocument
    CEikAppUi* CreateAppUiL();
    };


CEikAppUi* CFrotzDocument::CreateAppUiL()
    {
        return(new(ELeave) CFrotzAppUi);
    }



////////////////////////////////////////////////////////////////////////////////////////
//                            CFrotzApplication
////////////////////////////////////////////////////////////////////////////////////////


class CFrotzApplication : public CEikApplication
    {
private: // from CApaApplication
    CApaDocument* CreateDocumentL();
    TUid AppDllUid() const;
    };


const TUid KUidTstApp={0x1000055B};


TUid CFrotzApplication::AppDllUid() const
    {
    return(KUidTstApp);
    }


CApaDocument* CFrotzApplication::CreateDocumentL()
    {
    return(new(ELeave) CFrotzDocument(*this));
    }
//
// EXPORTed functions
//

EXPORT_C CApaApplication* NewApplication()
        {
    return(new CFrotzApplication);
    }


GLDEF_C TInt E32Dll(TDllReason)
    {
    return(KErrNone);
    }

/////////////////////////////////////////////////////////
// FrotzThread

TInt FrotzStartFunction(TAny* aParam)
    {
    struct sg *pg = new (struct sg);

	TPassParameters* parameters = (TPassParameters*) aParam ;

    pg->ss= new RMainServ(parameters->iVar2);
    SrvConnect(pg,  (void*)parameters->iVar1);

    char *argv[] = {"frotzs5", "123456789.123"};
    frotzmain(2, argv, pg);
    SrvDisconnect(pg);
    return(0);
    }

const TUid PROFILE_UID={0x1000055C};

void CFrotzAppUi::UpdateProfile()
    {
    int cflags1 = 0,cflags2 = 0;
    int cflags3 = 0,cflags4 = 0;
      // Open the "ini" file. Application architecture creates the "ini" file
      // if it does not exist
    CDictionaryStore* iniFile = Application()->OpenIniFileLC(iCoeEnv->FsSession());

      // The stream containing the background preference will be associated
      // with a Uid. AssignL() creates the stream if it does not exist
    RDictionaryWriteStream writeStream;
    writeStream.AssignLC(*iniFile,PROFILE_UID);
    writeStream.WriteInt32L(cfontsize);
    writeStream.WriteInt32L(ctoolbar);
    if(cboldmode)
      cflags1 |= 1;
    writeStream.WriteInt32L(cflags1);
    writeStream.WriteInt32L(cflags2);
    writeStream.WriteInt32L(cflags3);
    writeStream.WriteInt32L(cflags4);
    writeStream.WriteL((TUint8 *)storypath, 128);
    writeStream.WriteL((TUint8 *)savepath, 128);
    writeStream.CommitL();
    CleanupStack::PopAndDestroy();
     
    // Commit changes to the store
    if (iniFile->Commit()!=KErrNone)
        iniFile->RevertL(); 

      // Destroys the "ini" file store object and closes
      // the "ini" file
    CleanupStack::PopAndDestroy(); // iniFile
    }

void CFrotzAppUi::ReadProfile()
    {
    char storyp[128];
    char savep[128];
    int cf, ct;
    int cflags1,cflags2;
    int cflags3,cflags4;
      // Open the "ini" file. Application architecture creates the "ini" file
      // if it does not exist
    CDictionaryStore* iniFile = Application()->OpenIniFileLC(iCoeEnv->FsSession());
    
      // The stream containing the background preference will be associated
      // with a Uid.
      // Open the stream associted with the Uid; it will be created
      // if it does not exist.
    RDictionaryReadStream readStream;
    readStream.OpenL(*iniFile,PROFILE_UID);

      // If the stream has just been created (because the "ini" file has just
      // been created), it will be "empty" and attempting to read from 
      // the stream will leave with a KErrEof.
      // If the stream is not "empty", background now contains the
      // value stored.
    TRAPD(err, cf = readStream.ReadInt32L());
    if (!err)
      TRAP(err, ct = readStream.ReadInt32L());
    if (!err)
      {
        cfontsize = cf;
        ctoolbar = ct;
      }
    if (!err)
      TRAP(err, cflags1 = readStream.ReadInt32L());
    cboldmode = cflags1 & 1;
      
    if (!err)
      TRAP(err, cflags2 = readStream.ReadInt32L());
    if (!err)
      TRAP(err, cflags3 = readStream.ReadInt32L());
    if (!err)
      TRAP(err, cflags4 = readStream.ReadInt32L());
    if (!err)
      TRAP(err, readStream.ReadL((TUint8 *)storyp, 128));
    if (!err)
      TRAP(err, readStream.ReadL((TUint8 *)savep, 128));
    readStream.Close();

      // Can now delete the "ini" file object (i.e. close the "ini" file)
    CleanupStack::PopAndDestroy();
     
    if (!err)
      {
        Srvstrcpy(storypath, storyp);
        Srvstrcpy(savepath, savep);
      }
      // Return the value retrieved from the "ini" file
    }

void CFrotzAppUi::DrawUserScreen()
{
    int msw = cscreenwidth /2;
    int msh = cscreenheight /2;
    iCons->ClearScreen();
    iCons->SetCursorPosAbs(TPoint(msw - 16, msh - 5));
    if(cboldmode)
      iCons->SetAtt(ATT_BOLD | ATT_UNDERLINE);
    else
      iCons->SetAtt(ATT_ITALIC);
    iCons->Write(_L("FrotzS5 v1.8 by Frdric Bouvry"));
    iCons->SetCursorPosAbs(TPoint(msw - 21, msh - 3));
    if(cboldmode)
      iCons->SetAtt(ATT_BOLD);
    else
      iCons->SetAtt(0);
    iCons->Write(_L("Please select font size and toggle toolbar"));
    iCons->SetCursorPosAbs(TPoint(msw - 17, msh - 2));
    iCons->Write(_L("using zoom buttons, Ctrl-t & Ctrl-b"));
    iCons->SetCursorPosAbs(TPoint(msw - 12, msh));
    iCons->Write(_L("Open Story using Ctrl-o"));
    iCons->SetCursorPosAbs(TPoint(msw - 7, msh + 2));
    if(cboldmode)
      {
      iCons->SetAtt(ATT_BOLD | ATT_ITALIC);
      iCons->Write(_L("Bold mode On"));
      }
    else
      {
      iCons->SetAtt(ATT_BOLD);
      iCons->Write(_L("Bold mode Off"));
      }
    iCons->SetCursorPosAbs(TPoint(msw - 18, msh + 4));
    if(cboldmode)
      iCons->SetAtt(ATT_BOLD);
    else
      iCons->SetAtt(0);
    iCons->Printf(_L("Current console width/height: %dx%d"), cscreenwidth, cscreenheight);
    iCons->SetAtt(0);
}
