#pragma once
#include <Windows.h>

#include <string>

HANDLE Util_OpenFile(LPCTSTR filename, DWORD accessMode, DWORD ifExists);
BOOL Util_WriteBufferToFile(HANDLE hFile, LPCVOID lpBuffer, DWORD nNumberOfBytesToWrite);
HBITMAP Util_ResizeImage(HBITMAP src, int newX, int newY);

#define REPORT_ERROR(msg) ReportErrorEx((msg), __FILE__, __LINE__)

void ReportError(wchar_t *message);
void ReportErrorEx(wchar_t *message, char *sourceFile, int lineno);
void Util_NormalizeString(std::wstring& s);
std::string& Util_ReplaceSubstring(std::string& s, const std::string& sub, const std::string& other);
