/*
  Arith
*/

#include "arith.h"

#include "jump.h"
#include "var.h"


void logical_shift(word param1, word param2)
{
  signed_word bits_to_shift = (signed_word) param2;
  if(bits_to_shift < 0)
    store((word) (param1 >> (-bits_to_shift)));
  else
    store((word) (param1 << bits_to_shift));
}

void arithmetic_shift(word param1, word param2)
{
  signed_word bits_to_shift = (signed_word) param2;
  if(bits_to_shift < 0)
    if(((signed_word) param1) < 0)
      store((word) (~((signed_word) (~param1) >> (-bits_to_shift))));
    else
      store((word) ((signed_word) param1 >> (-bits_to_shift)));
  else
    store((word) (param1 << bits_to_shift));
}
