/*
  Head
  Encapsulate the header
  JBS 15 June 1994
*/

#ifndef _HEAD_

#define _HEAD_

#include "config.h"
#include "types.h"

typedef enum
{
#if EARLY
  VERSION_1 = 1,
  VERSION_2 = 2,
#endif
  VERSION_3 = 3,
  VERSION_4 = 4,
  VERSION_5 = 5,
  VERSION_6 = 6,
  VERSION_7 = 7,
  VERSION_8 = 8
} version;

void hd_no_colour(void);

int hd_open(char *);
void hd_close(void);
void hd_load(word, word, byte *);
void hd_flip(word, byte *);

void hd_init(void);
void hd_set_size(int, int);
int hd_width(void);
int hd_height(void);
word hd_resident_blocks(void);
word hd_verify(void);
word hd_save_blocks(void);
word hd_start(void);
byte hd_mode(void);
void hd_set_screen(void);
word hd_check(void);
void hd_set_script(int);
void hd_set_fixed(int);
bool hd_get_script(void);
bool hd_get_fixed(void);
void hd_err_script(void);
word hd_object(void);
word hd_global(void);
word hd_common(void);
word hd_vocab(void);

version hd_version(void);

int hd_plus(void);
int hd_five(void);

word hd_code_offset(void);
word hd_text_offset(void);

void hd_request_status(void);

#endif
