/*
  Page
  Handle paging of the story to and from disk
  JBS 15 June 1994
*/

#ifndef _PAGE_

#define _PAGE_

#include "config.h"
#include "types.h"

extern byte *base_ptr;          /* Points to the first page */

int pg_head(void);              /* Load in the first page */
int pg_init(word, word);        /* Load in the rest       */

byte *pg_fetch(word); /* Give a pointer to the start of the page */

/*
  General utilities for converting between addresses
  and page/offset pairs
*/

#include "mem.h"

#define pg_page(a)              (word) ((a) >> BLOCK_SHIFT)
#define pg_offset(a)            (word) ((a) & (BLOCK_SIZE - 1))
#define pg_blocks(a)            pg_page((a) + BLOCK_SIZE - 1)

void pg_save_undo(void);
void pg_restore_undo(void);

#endif
