/*
  Random
*/

#include "random.h"

#include "os.h"
#include "var.h"

static word random1, random2, random3, random4;

void seed_random(void)
{
  long_word clock = os_time();
  random1 = (word) (clock >> 16);
  random2 = (word) clock;
}

void std_random(word param1)
{
  word temp = random1 >> 1;
  if(random2 & 0x0001)
    temp |= 0x8000;
  random1 = random2;
  random2 ^= temp;
  store(((int) (random2 & 0x7FFF) % (int) param1) + 1);
}

void plus_random(word param1)
{
  if((signed_word) param1 <= 0)
  {
    random3 = 0;
    random4 = -((signed_word) param1);
  }
  if(random4 != 0)
  /* Random values will cycle according to number set by #rand */
  {
    ++random3;
    if(random3 == random4)
      random3 = 0;
    store((random3 & 0x7FFF) % param1 + 1);
  }
  else
  {
    std_random(param1);
  }
}
