/*
  Stack
  Fully hide the stack behind access procedures
  JBS 15 June 1994
*/

#ifndef _STACK_

#define _STACK_

#include "types.h"

#define STACK_SIZE 1024

extern word stack_space[STACK_SIZE];
extern word *stack_ptr;
extern word *var_ptr;

#define stack_base (&stack_space[STACK_SIZE])

void stk_link(void);
void stk_throw(word);
void stk_unlink(void);
void stk_init(void);

word stk_encode_stk(void);
word stk_encode_var(void);
void stk_decode_stk(word);
void stk_decode_var(word);


#define stk_push(v)             *--stack_ptr = (v)
#define stk_pop()               *stack_ptr++

#define stk_get_var(i)          var_ptr[-i]
#define stk_set_var(i,v)        var_ptr[-i] = (v)

#define stk_get_top()           *stack_ptr
#define stk_set_top(v)          *stack_ptr = (v)

#define stk_get_abs(i)          stack_space[i]
#define stk_set_abs(i,v)        stack_space[i] = (v)

#endif
