/*
  Types
  Basic types for the infocom interpreter
  JBS 15 June 1994
*/

#ifndef _TYPES_

#define _TYPES_

/*
  Universal Type Definitions.
  'byte'          -  8 bits       ; unsigned.
  'word'          - 16 bits       ; unsigned.
  'long_word'     - 32 bits       ; unsigned.
  'signed_word'   - 16 bits       ; signed.
  'signed_long'   - 32 bits       ; signed.
  'bool'          - simple 0/1 truth value

  These should be minimum requirements, so the following
  definitions ought to be portable across all machines,
  even those where int is naturally 64 bit.
*/

typedef unsigned char byte;
typedef unsigned short word;
typedef unsigned long long_word;
typedef short signed_word;
typedef long signed_long;

typedef byte bool;

#define USE(v)  (v=v); /* Suppress warnings */

#include <stdlib.h> /* Get size_t */

#ifndef min
#define min(a,b) ((a)<(b)?(a):(b))
#endif
#ifndef max
#define max(a,b) ((a)>(b)?(a):(b))
#endif

#endif
