/*
  Code common to the X11/Windows windowing modules
  JBS 28 Feb 1996
*/

static char *text_of(int y)
{
  int i;
  static char buff[MAX_SLACK+1];
  for(i = 0; i < MAX_SLACK; ++i)
    buff[i] = con.row[y].slack[i].text;
  /* buff[i] = '\0'; */
  return buff;
}

static int after(console_cell *slack, int current, int held)
{
  int z = current + 1;
  while(z < held
     && slack[z].attr.font == slack[current].attr.font
     && slack[z].attr.fore == slack[current].attr.fore
     && slack[z].attr.back == slack[current].attr.back
    )
    ++z;
  return z;
}

static int after_space(console_cell *slack, int current, int held)
{
  int z = current + 1;
  while(z < held
     && !is_a_space(slack[z])
     && slack[z].attr.font == slack[current].attr.font
     && slack[z].attr.fore == slack[current].attr.fore
     && slack[z].attr.back == slack[current].attr.back
    )
    ++z;
  return z;
}

void more(void)
{
  char c;
  int fixed = hd_get_fixed();
  console_context cell = con.cursor;
  con.cursor.align = 0;
  con.cursor.attr.font = FONT_EMPH;
  con.cursor.attr.fore = 2;
  con.cursor.attr.back = 9;
  hd_set_fixed(0);
  raw_display("More ...");
  c = get_ch();
  if(c > ' ') unget_ch(c);
  put_char('\r');
  con.cursor = cell;
  hd_set_fixed(fixed);
  erase_to_eoln();
}

