/* file.c -- entirely rewritten for tigcc by Nils Gesbert, January 2003
 *
 *  ``pinfocom'' -- a portable Infocom Inc. data file interpreter.
 *  Copyright (C) 1987-1992  InfoTaskForce
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; see the file COPYING.  If not, write to the
 *  Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * $Header: RCS/file.c,v 3.0 1992/10/21 16:56:19 pds Stab $
 */


#include "infocom.h"

#include <string.h>
#include <vat.h>
#include <alloc.h>
#include <args.h>
#include <statline.h>
#include "ttarchive.h"
#include "ttunpack.h"

#define REPERTOIRE_JEUX "zcode"
#define TITRES_JEUX {"jeu", "game", "routard", "enchanter", "sorcerer", "spellbreaker", "zork", "zork2", "zork3"} /* Si on change changer aussi NB_TITRES !!*/
#define NB_TITRES 9
#define REP_SAUVEGARDES "zsvg"
#define MAX_CAR_NOM_FIC 19 /* \0 + 8 car. nom du rpertoire + \ + 8 car. nom fichier + \0 */

static HANDLE game_file1;
static HANDLE game_file2;

static HANDLE ouvre_fichier (const char *format,
			     const char *repertoire,
			     const char *nom_fichier) {
  char nom_complet[MAX_CAR_NOM_FIC];
  int lg_nom_complet;
  SYM_ENTRY *se;

  nom_complet[0] = 0;
  lg_nom_complet = sprintf (nom_complet + 1, format, repertoire, nom_fichier);
  se = SymFindPtr (nom_complet + lg_nom_complet + 1, 0);
  return (se ? se -> handle : H_NULL);
}

inline const char *
open_file A1(const char*, filename)
{
  int j;
  const char *titres_jeux[] = TITRES_JEUX;
  int n = NB_TITRES;
  if (filename) {titres_jeux[0] = filename; n = 1;} /* si on m'a donn un nom je ne cherche
						       pas dans la liste...*/
  for (j = 0; j < n; j++)
    if ((game_file1 = ouvre_fichier ("%.8s\\%.6s", REPERTOIRE_JEUX, titres_jeux[j])) &&
	(game_file2 = ouvre_fichier ("%.8s\\%.6s_2", REPERTOIRE_JEUX, titres_jeux[j])))
      return titres_jeux[j]; /* J'exige la prsence des deux fichiers
			        (m'tonnerait qu'il y ait des jeux < 64k...) */  
  ST_helpMsg ("jeu non trouv");
  return NULL;
}

void
load_page A2(word, block, byte*, ptr)
{
  byte *archive;
  if (block < 16) archive = HLock (game_file1) + 2;
  else {
    archive = HLock (game_file2) +2;
    block -= 16;
  }
  if (ttarchive_entries (archive) <= block ||     /* Qques vrifs pour pas tout planter */
      (archive = ttarchive_data(archive, block),  /* si le fichier n'est pas bon... */
       ttunpack_size (archive) > BLOCK_SIZE) ||
      ttunpack_decompress (archive, ptr)) {
    if (gflags.game_state == NOT_INIT)
      gflags.game_state = QUIT_GAME;
    else error ("impossible de dcompresser le bloc %hu", block);
  }
  HeapUnlock (game_file1);
  HeapUnlock (game_file2); /* Je ne sais pas lequel des deux a t lock... */
}

inline void
save()
{
  HANDLE hdl;
  HSym sym;
  byte *ptr;
  word i;
  byte j;
  byte b;
  int k;
  word l;
  byte orig[BLOCK_SIZE];
  word *wptr;
  int taille_pile = (stack_base - stack) * 2;
  char nom_complet[MAX_CAR_NOM_FIC];

  /* J'alloue la mmoire ncessaire pour la sauvegarde */
  /* Je ne sais pas combien il en faut mais je peux limiter a priori  la taille non compresse
     (en partant du principe que la compression rduit effectivement la taille,
     ce qui devrait TOUJOURS tre le cas dans la ralit...)
     S'il n'y en a pas autant de disponible j'alloue tout et j'espre que a va tenir. */
  long max = HeapMax() - 17;
  long max2 = data_head.save_bytes + taille_pile;
  if (max < 0 ||
      (max = max > max2 ? max2 : max,
       !(hdl = HeapAlloc (max + 17)))) {
    scr_putline ("[Dsol, pas assez de mmoire pour sauvegarder...]");
    ret_value (0);
    return;
  }
  
  /* Et maintenant je sauve... */
  wptr = (word*) HLock (hdl);
  wptr[1] = pc_page;
  wptr[2] = pc_offset;
  wptr[3] = stack_base - stack_var_ptr; /* frame pointer */
  wptr[4] = taille_pile;
  
  ptr = (byte*) (wptr + 5);
  memcpy (ptr, stack, taille_pile);
  
  /* Alors on va utiliser la super techniqe de compression de la mort */
  for (i = 0, j = 0, k = BLOCK_SIZE, l = taille_pile;
       i < data_head.save_bytes; i++, k++) { /* k == i % BLOCK_SIZE */
    
    if (k == BLOCK_SIZE) {
      load_page (i / BLOCK_SIZE, orig);
      k = 0;
    }

    b = base_ptr[i] ^ orig[k];
    if (b) {
      if (j) { /* S'il y a eu une squence de zros j'cris sa longueur */
	ptr[l++] = j;
	j = 0;
      }
      ptr[l++] = b;
    }
    else if (!j++ || !j) ptr[l++] = 0; /* Si c'est le premier ou le 256e zro je l'cris */

    if (max < l) /* On est foutu... */ {
      HeapFree (hdl);
      scr_putline ("[Dsol, pas assez de mmoire pour sauvegarder...]");
      ret_value (0);
      return;
    }
  }
  if (j) ptr[l++] = j; /* Pour complter */
  
  /* Et l faut mettre le type du fichier */
  ptr[l++] = 0;
  ptr[l++] = 'S';
  ptr[l++] = 'V';
  ptr[l++] = 'G';
  ptr[l++] = 0;
  ptr[l++] = OTH_TAG;
  
  /* Voyons la place que a a pris finalement... */
  *wptr = l + 8; /* Le mot o est stocke la taille ne compte pas dans celle-ci */
  HeapUnlock (hdl);
  HeapRealloc (hdl, l + 10); /* Mais je suppose qu'ici il compte ! */

  /* Je cre un  fichier  */
  gflags.game_state = LOAD_GAME; /* Je sais c'est idiot... */
  nom_complet[0] = 0;
  do {
    char nom_fichier[9];
    int machin;
    SCR_STATE ss;
    machin = scr_getline ("Entrez un nom de fichier (dfaut nom du jeu)  >", 9, nom_fichier);
    if (machin == -1) { /* On a appuy sur Esc pour annuler */
      HeapFree (hdl);
      gflags.game_state = PLAY_GAME;
      ret_value (0);
      return;
    }
    machin = sprintf
      (nom_complet + 1, "%.8s\\%.8s", REP_SAUVEGARDES, machin ? nom_fichier : nom_jeu);
    SaveScrState (&ss); /* Si une bote de dialogue apparat elle casse tout... */
    sym = SymAdd (nom_complet + machin + 1);
    RestoreScrState (&ss);
  } while (!sym.folder);
  /* Je l'associe  la mmoire alloue */
  DerefSym (sym) -> handle = hdl;
  /* Archivage */
#ifndef PAS_ARCHIVER_SVG
  if (!EM_moveSymToExtMem (NULL, sym))
    scr_putline ("[Impossible d'archiver la sauvegarde]"); /* On n'insiste pas... */
#endif
  /* Fini ! */
  gflags.game_state = PLAY_GAME;
  ret_value (1);
}

void rextore (const char *nom_fic) {  
  HANDLE fichier;
  word dhsb = data_head.save_bytes;
  word *wptr;
  byte *ptr;
  int taille_pile;
  word i, j;
  byte b;

  debut :
  fichier = H_NULL;
  gflags.game_state = LOAD_GAME;
  if (nom_fic) /* si un nom de fichier a t donn sur la ligne de commande, on l'essaye */
    fichier = ouvre_fichier ("%.8s\\%.8s", REP_SAUVEGARDES, nom_fic);
  while (!fichier) {
    char nom_fichier[9];
    int machin;
    machin = scr_getline ("Entrez un nom de fichier (dfaut nom du jeu)  >", 9, nom_fichier);
    if (machin == -1) { /* On a appuy sur Esc pour annuler */
      if (!prog_block_ptr) change_status(); /* Cas o le jeu n'a pas encore t dmarr */
      else {
	ret_value (0);
	gflags.game_state = PLAY_GAME;
      }
      return;
    }
    fichier = ouvre_fichier ("%.8s\\%.8s", REP_SAUVEGARDES, machin ? nom_fichier : nom_jeu);
  }
  wptr = (word*) HLock (fichier);

  /* Bon en gros c'est la mme chose  l'envers... */

  ptr = (byte*) (wptr + 5);
  pc_page = wptr[1];
  pc_offset = wptr[2];
  stack_var_ptr = stack_base - wptr[3];
  taille_pile = wptr[4];
  stack = stack_base - (taille_pile >> 1);
  memcpy (stack, ptr, taille_pile);

  /* Je recharge la mm.dynamique SAUF si on m'a spcifi un nom de fichier
   (ce qui signifie qu'on vient de lancer le jeu) */
  if (!nom_fic)
    for (i = 0; i < dhsb / BLOCK_SIZE + 1; i++)
      load_page (i, base_ptr + i * BLOCK_SIZE);

  /* Et c'est parti ! */
  for (i = taille_pile, j = 0; i < *wptr - 14 && j < dhsb; j++) {
    b = ptr[i++];
    if (b) base_ptr[j] ^= b;
    else j += (byte) (ptr[i++] - 1);
  }
  HeapUnlock (fichier); /* Je m'en sers encore mais il n'aura pas le temps de bouger */
  /* Logiquement les deux conditions de sortie devraient se raliser simultanment
     sinon y a un blme... */
  if (i != *wptr - 14 || j != dhsb) {
    scr_putline ("[Il semble qu'il y ait un petit problme... appuyez sur ESC pour redmarrer le"
		 " jeu, sur entre pour charger une autre sauvegarde ou sur n'importe quelle "
		 "autre touche pour continuer comme si de rien n'tait.]");
    switch (ngetchx()) {
    case KEY_ESC : data_head.save_bytes = dhsb; restart(); return;
      /* data_head.save_bytes a pu tre cras par la mauvaise sauvegarde
         -> on le remet  l'ancienne valeur sinon restart() ne fonctionnera pas correctement. */
    case KEY_ENTER : nom_fic = NULL; goto debut; /* Oh le beau goto :-) */
    }
  }

  /* Bon ben normalement c'est fini... */
  gflags.game_state = PLAY_GAME;
  fix_pc();
  ret_value (1);
}
inline void restore() {rextore (NULL);}
