PROGRAM InfocomInteractiveFictionDebugger;
 
 USES ZIP_Ext;
 
 LABEL 999 (* Abort current command *);
 
 CONST
       
       InterpreterNumber=6;
       InterpreterChar='o';  
       Date='19-Mar-94';
       Debugging=false;
       
       MaxSpecTxtAdrsPageNo=1;
       MaxSpecTxtPageNo=3;
       MaxEntryPointCnt=1999;
       
       MaxStack=511;
       
       MaxMaxNumWords=70;
       MaxScreenWidth=256;
       MaxLineIndex=255;
  
       HighByteMask=65280;
       
       IntToCardConst=0;
       
       MaxPageNo=2047;
       MaxSubPageNo=0;
       MinMemSpace=4096;
       
       MaxWindow = 7;
       
       PrinterName='ZIPDebug:Listing';

 TYPE
      
      anAddrString=String[79];

      InternalErrors=(NoError,IllMultiOpdOp,IllNoOpdOp,IllTwoOpdOp,
       IllOneOpdOp,StackUnderflow,StackOverflow,IllObjDataLoad,
       DivideByZero,MissingOpd,MissingObjProp,IllObjPropertyStore,
       IllZCodeType,NotImplemented,KeyboardBreak,BreakPoint,
       OutputBufferUndefined,PC_Overflow,PC_Underflow,
       TooManySeparators, TooManyLocalVariables, TooManyParameters,
       IllNumOperands, IllOutputChar, IllScreenMode, NoPrinter,
       IllOutputMode, IllOperand, IllMSP, IllColour, IllObj);
      CharSet=SET OF Char;
      Commands=(Nothing,Quit,NewAdv,Info,Help,VerifyCode,ScanCode,
       DumpOption,
       List,TextList,GoSub,cDumpBytes,DumpWords,
       ListEntryPoints,ListObject,ListVocabulary,
       ListZState,ListReg,Step,Run,Trace,Break,ModifyWords,ModifyBytes,
       BPT_Cmd,SwitchToStep,SwitchToTrace,ListCalls);
      DumpStates=(SuppressDump,NoDump,CodeDump,TextDump,UnpackedDump);
      
      CallEvents=(CallNever, CallKeyPress, CallTimeOut);

      tMiscInfo=PACKED RECORD
       CodeType:Byte;                   (* $00 *)
       ConfigFlags:Byte;                (* $01 *)
       ReleaseHigh:Byte;                (* $02 *)
       ReleaseLow:Byte;                 (* $03 *)
       NumReadWriteBytesHigh:Byte;      (* $04 *)
       NumReadWriteBytesLow:Byte;       (* $05 *)
       StartPageNo:Byte;                (* $06 *)
       StartIndex:Byte;                 (* $07 *)
       VocabPageNo:Byte;                (* $08 *)
       VocabPageIndex:Byte;             (* $09 *)
       ObjPageNo:Byte;                  (* $0A *)
       ObjPageIndex:Byte;               (* $0B *)
       DataPageNo:Byte;                 (* $0C *)
       DataPageIndex:Byte;              (* $0D *)
       SaveStateSizeHigh:Byte;          (* $0E *)
       SaveStateSizeLow:Byte;           (* $0F *)
       ScriptStatusHigh:Byte;           (* $10 *)
       ScriptStatusLow:Byte;            (* $11 *)
       SerialNumber:PACKED ARRAY [0..5] OF Char;
       SpecialPageNo:Byte;              (* $18 *)
       SpecialIndex:Byte;               (* $19 *)
       EndPageNo:Byte;                  (* $1A *)
       EndPageIndex:Byte;               (* $1B *)
       ChkSumHigh:Byte;                 (* $1C *)
       ChkSumLow:Byte;                  (* $1D *)
       mInterpreterNumber:Byte;         (* $1E *)
       mInterpreterVersion:Byte;        (* $1F *)
       ScreenHeight:Byte;               (* $20 *)
       ScreenWidth:Byte;                (* $21 *)
       Left:Byte;                       (* $22 *)
       Right:Byte;                      (* $23 *)
       Top:Byte;                        (* $24 *)
       Bottom:Byte;                     (* $25 *)
       Unknown1:Byte;                   (* $26 *)
       Unknown2:Byte;                   (* $27 *)
       CodeBasePageNo:Byte;             (* $28 *)
       CodeBaseIndex:Byte;              (* $29 *)
       Unused13:Byte;                   (* $2A *)
       Unused14:Byte;                   (* $2B *)
       Unknown3:Byte;                   (* $2C *)
       Unknown4:Byte;                   (* $2D *)
       Unknown5:Byte;                   (* $2E *)
       Unused21:Byte;                   (* $2F *)
       Unused22:Byte;                   (* $30 *)
       Unused23:Byte;                   (* $31 *)
       Unused24:Byte;                   (* $32 *)
       Unused25:Byte;                   (* $33 *)
       Unused26:Byte;                   (* $34 *)
       Unknown6:Byte;                   (* $35 *)
       Unused3:PACKED ARRAY [$36..$FF] OF Byte
      END;
      
      OutputTypes=(OntoScreen,IntoBuffer,ToStoryOutput,IntoSink);
      SourceTypes=(FromDC,FromIPC);
      
      BPT_Types=(UndefinedBPT,UserBPT,RunBPT,TraceBPT);
      PtrBPT=^aBPT;
      aBPT=RECORD
       BPT_PageNo,BPT_PageIndex,HitCnt:Integer;
       BPT_No,OrgByte1,OrgByte2,OrgByte3:Integer;
       NextBPT:PtrBPT;
       BPT_Type:BPT_Types
      END;
      
      Registers=RECORD CASE Boolean OF
       false:(
        a:ARRAY [0..15] OF Integer);
       true:(
        r0:Integer;
        r1:Integer;
        r2:Integer;
        r3:Integer;
        r4:Integer;
        r5:Integer;
        r6:Integer;
        r7:Integer;
        r8:Integer;
        r9:Integer;
        r10:Integer;
        r11:Integer;
        r12:Integer;
        r13:Integer;
        r14:Integer;
        r15:Integer)
      END;
      Operands=RECORD CASE Boolean OF
       false:(
        a:ARRAY [0..7] OF Integer);
       true:(
        s0:Integer;
        s1:Integer;
        s2:Integer;
        s3:Integer;
        s4:Integer;
        s5:Integer;
        s6:Integer;
        s7:Integer)
      END;
      CountArray=ARRAY [0..255] OF Integer;
      StoryFileBuffer=ARRAY [0..MaxSubPageNo] OF aPage;

      aWord=PACKED ARRAY [0..8] OF Char;
      aPackedWord=ARRAY [0..2] OF ShortInteger;

      aWindow=RECORD
        yPos:Integer;
        xPos:Integer;
        Height:Integer;
        Width:Integer;
        Flags:Integer;
        CursorY:Integer;
        CursorX:Integer;
      END;

 VAR
     
     CodeVersion:Char;
     StoryName:aMaxString;
     MiscInfo:tMiscInfo;
     WordNumChars:Integer;
     ObjRecSize:Integer;
     ObjOffset:Integer;
     ReleaseNo:Integer;
     
     PageCnt:Integer;
     PagePtrs:ARRAY [0..MaxPageNo] OF PtrPage;
     DataPagePtrs:ARRAY [0..MaxPageNo] OF PtrPage;
     
     DC_PageNo,DC_PageIndex:Integer;
     OldPageNo,OldIndex:Integer;
     BackPageNo,BackIndex:Integer;
     EndPageNo,EndPageIndex:Integer;
     TextPageNo,TextPageIndex:Integer;
     OldTextPageNo,OldTextPageIndex:Integer;
     BackTxtPageNo,BackTxtIndex:Integer;
     CodeBegPageIndex,CodeBegPageNo:Integer;
     CodeEndPageIndex,CodeEndPageNo:Integer;
     InstPageNo,InstPageIndex:Integer;
     NewInstPageNo,NewInstPageIndex:Integer;
     EndIPC_PageNo,EndIPC_PageIndex:Integer;
     BackIPC_PageNo,BackIPC_PageIndex:Integer;
     OldIPC_PageNo,OldIPC_PageIndex:Integer;
     BPT_PageNo,BPT_PageIndex:Integer;
     FirstInstPageNo,FirstInstPageIndex:Integer;
     
     DisWithNames:Boolean;
     DisBPTs:Boolean;
     Statistics:Boolean;
     ChkAddresses:Boolean;
     RestartOperations:Boolean;
     ChkLineChars:Boolean;
     
     WriteDump:Boolean;
     GlobalDumpState:DumpStates;
     DumpCnt,LineCnt:Integer;
     Dump:aMaxString;

     BreakKey:Char;
     ExitKey:Char;
     WaitKey:Char;
     
     HexChars:PACKED ARRAY [1..16] OF Char;
     Char1Table: PACKED ARRAY [1..25] OF Char;
     Char23Table:PACKED ARRAY [1..24] OF Char;
     Char1Set,Char23Set:CharSet;
     GlobalTextBuffer:aMaxString;
     
     KeyBuffer:PACKED ARRAY [0..79] OF Char;
     ReadIndex,WriteIndex:Integer;
     
     PrintListing:Boolean;
     Printer:Text;
     
     SaveEntryPoints,TryRegList:Boolean;
     EntryIndex:Integer;
     EntryPoints:ARRAY [0..MaxEntryPointCnt] OF Integer;
     
     CmdCode:Integer;
     IPC_PageNo,IPC_PageIndex:Integer;
     SP,MSP:Integer;
     NumCallParams:Integer;
     AccA,AccB,AccC,AccD:Integer;
     OpdCnt:Integer;
     Opd:Operands;
     R:Registers;
     Stack:ARRAY [0..MaxStack] OF Integer;
     
     Running,Tracing,Stepping,CrashInternal,DebugVocab,InStory,
     FaultNotImplemented:Boolean;
     
     CursorX,CursorY:Integer;
     StoryCursorX,StoryCursorY:Integer;
     NonWindowCursorX,NonWindowCursorY:Integer;
     WindowCursorX,WindowCursorY:Integer;
     Windows:ARRAY [0..MaxWindow] OF aWindow;

     ScreenMode:Integer;
     StoryScreenMode:Integer;
     FormatMode:Integer;
     Playback:Boolean;
     Recording:Boolean;
     OutputMode:Integer;
     Font:Integer;
     ScreenEnabled:Boolean;
     BufferEnabled:Boolean;
     DirectEnabled:Boolean;
     ActiveWindow:Boolean;
     WritingInWindow:Boolean;
     PrinterTried:Boolean;
     PrinterOpen:Boolean;
     BufferPageNo,BufferPageIndex:Integer;
     BufferIndex:Integer;
     LineIndex,LineNo,ScrollTop,StoryScrollTop:Integer;
     LineBuffer:PACKED ARRAY [0..MaxLineIndex] OF Char;
     Spaces:aMaxString;
     
     TerminatorSet:CharSet;
     
     Cmd:Commands;
     CmdLine:aMaxString;
     FirstObj,LastObj,FirstHigh,LastHigh,RegNo:Integer;
     
     BPT_No,BPT_IdCnt:Integer;
     BPT_List:PtrBPT;
     
     ExecCnt:CountArray;
     BreakOnOpcode:PACKED ARRAY [0..255] OF Boolean;

     CmpShift:Integer;


 PROCEDURE HandleError(WriteLastInst:Boolean; Message:aMaxString;
                       Crash:Boolean); FORWARD;
 PROCEDURE InternalError(Error:InternalErrors); FORWARD;

 PROCEDURE SetLength(VAR S:String; Length:Integer);
  BEGIN
   S[0]:=Length;
  END; (* SetLength *)

 PROCEDURE OpenPrinter;
  BEGIN
   IF NOT PrinterTried AND NOT PrinterOpen THEN BEGIN
    (*$I-*)
    Rewrite(Printer,PrinterName);
    PrinterTried:=true;
    PrinterOpen:=(IOResult=0);
    (*$I+*)
    IF NOT PrinterOpen THEN BEGIN
     InternalError(NoPrinter);
    END;
   END;
  END; (* OpenPrinter *)
 
 FUNCTION PrinterEnabled:Boolean;
  VAR ScriptLow:Byte;
      Enabled:Boolean;
  BEGIN
   PrinterEnabled:=false;
   IF PagePtrs[0]<>Nil THEN BEGIN
    ScriptLow:=PagePtrs[0]^[17];
    Enabled:=TstBit(ScriptLow,0);
    IF Enabled THEN BEGIN
     IF NOT PrinterOpen THEN BEGIN
      OpenPrinter;
     END;
     IF PrinterOpen THEN BEGIN
      PrinterEnabled:=true;
     END;
    END;
   END;
  END; (* PrinterEnabled *)

 PROCEDURE PositionCursor;
  BEGIN
   GotoXY(CursorX,CursorY)
  END; (* PositionCursor *)
 
 PROCEDURE MoveCursorUp;
  BEGIN
   IF CursorY>0 THEN BEGIN
    CursorY:=Pred(CursorY); PositionCursor
   END
  END; (* MoveCursorUp *)
 
 PROCEDURE MoveCursorDown;
  BEGIN
   IF CursorY<Pred(ScreenHeight) THEN BEGIN
    CursorY:=Succ(CursorY); PositionCursor
   END
  END; (* MoveCursorDown *)
 
 PROCEDURE MoveCursorRight;
  BEGIN
   IF CursorX<Pred(ScreenWidth) THEN BEGIN
    CursorX:=Succ(CursorX); PositionCursor
   END
  END; (* MoveCursorRight *)
 
 PROCEDURE MoveCursorLeft(Count:Integer);
  BEGIN
   IF CursorX>=Count THEN BEGIN
    CursorX:=CursorX-Count; PositionCursor
   END
  END; (* MoveCursorLeft *)
 
 PROCEDURE ClearCh;
  BEGIN
   PositionCursor; WriteRawChOnScreen(' '); PositionCursor
  END; (* ClearCh *)
 
 PROCEDURE EraseCh;
  BEGIN
   IF CursorX>0 THEN BEGIN
    MoveCursorLeft(1);
    WriteRawChOnScreen(' ');
    PositionCursor
   END
  END; (* EraseCh *)
 
 PROCEDURE ZM_GotoXY(x,y:Integer);
  BEGIN
   CursorX:=Pred(x); CursorY:=Pred(y);
   PositionCursor
  END; (* ZM_GotoXY *)
 
 PROCEDURE SetScreenMode;
  BEGIN
   CASE ScreenMode OF
    0(* Normal *):
     NormalOn;
    1(* Inverse *):
     InverseOn;
    2(* Bold *):
     BoldOn;
    4(* Italic *):
     ItalicOn;
    8(* Title/Subtitle? *):
     ExtraOn;
    OTHERWISE
     InternalError(IllScreenMode);
   END
  END; (* SetScreenMode *)
 
 PROCEDURE ClearLines(FirstLine,LastLine:Integer);
  VAR LineCnt:Integer;
  BEGIN
   SaveTextAttributes;
   ScreenMode:=0; SetScreenMode;
   FOR LineCnt:=FirstLine TO LastLine DO BEGIN
    GotoXY(0,LineCnt); ClearToEOL
   END;
   RestoreTextAttributes;
   PositionCursor
  END; (* ClearLines *)
 
 PROCEDURE NewLine;
  BEGIN
   CursorX:=0;
   CursorY:=Succ(CursorY);
   IF CursorY>=ScreenHeight THEN BEGIN
    ScrollLinesUp(Pred(ScrollTop));
    CursorY:=Pred(ScreenHeight)
   END;
   PositionCursor; ClearToEOL
  END; (* NewLine *)
 
 PROCEDURE InitScreen;
  BEGIN
   SetupTerminal(ScreenWidth,ScreenHeight);
   ScrollTop:=1; LineCnt:=0;
   ClearScreen;
   CursorOff;
   CursorX:=0;
   CursorY:=0;
   Font:=1;
   ScreenMode:=0;
   SetScreenMode;
  END; (* InitSCreen *)
 
 PROCEDURE ResetScreen;
  BEGIN
   ScreenMode:=0;
   SetScreenMode;
   CursorOff;
   ResetTerminal;
  END; (* ResetSCreen *)
 
 PROCEDURE ScreenCh(Ch:Char);
  BEGIN
   WriteRawChOnScreen(Ch);
   CursorX:=Succ(CursorX);
(*
   IF CursorX>=Pred(ScreenWidth) THEN BEGIN
     CursorX:=0;
     PositionCursor;
   END;
*)
  END; (* ScreenCh *)

 PROCEDURE PrintCh(Ch:Char);
  BEGIN
   ScreenCh(Ch);
   IF PrintListing THEN BEGIN
    Write(Printer,Ch);
   END;
  END; (* PrintCh *)
 
 PROCEDURE ZM_ScreenCh(Ch:Char);
  BEGIN
   IF Ch<' ' THEN BEGIN
    InternalError(IllOutputChar);
   END;
   WriteChOnScreen(Ch);
   CursorX:=Succ(CursorX);
(*
   IF CursorX>=Pred(ScreenWidth) THEN BEGIN
     CursorX:=0;
     PositionCursor;
   END;
*)
  END; (* ZM_ScreenCh *)

 PROCEDURE ZM_PrintCh(Ch:Char);
  BEGIN
   ZM_ScreenCh(Ch);
   IF PrintListing THEN BEGIN
    Write(Printer,Ch);
   END;
  END; (* ZM_PrintCh *)
 
 PROCEDURE InitExecCnt;
  VAR Cnt:Integer;
  BEGIN
   FOR Cnt:=0 TO 255 DO BEGIN
    ExecCnt[Cnt]:=0;
   END;
  END; (* InitExecCnt *)
 
 PROCEDURE InitBreakOnOpcode;
  VAR Cnt:Integer;
  BEGIN
   FOR Cnt:=0 TO 255 DO BEGIN
    BreakOnOpcode[Cnt]:=false;
   END;
  END; (* InitBreakOnOpcode *)
 
 PROCEDURE Push(Value:Integer);
  BEGIN
   IF SP>MaxStack THEN BEGIN
    InternalError(StackOverflow);
   END ELSE BEGIN
    Stack[SP]:=Value;
    SP:=Succ(SP);
   END;
  END; (* Push *)
 
 FUNCTION Pop:Integer;
  BEGIN
   IF SP<=0 THEN BEGIN
    InternalError(StackUnderflow);
   END ELSE BEGIN
    SP:=Pred(SP);
    Pop:=Stack[SP];
   END;
  END; (* Pop *)
 
 FUNCTION ValidAddress(VAR PageNo, PageIndex:Integer):InternalErrors;
  VAR Error:InternalErrors;
  BEGIN
   WHILE PageIndex>255 DO BEGIN
    PageIndex:=PageIndex-256;
    PageNo:=Succ(PageNo);
   END;
   WHILE PageIndex<0 DO BEGIN
    PageIndex:=PageIndex+256;
    PageNo:=Pred(PageNo);
   END;
   Error:=NoError;
   IF CodeVersion>='3' THEN BEGIN
    IF PageNo>CodeEndPageNo THEN BEGIN
     Error:=PC_Overflow;
    END ELSE IF PageNo<0 THEN BEGIN
     Error:=PC_Underflow;
    END;
   END;
   ValidAddress:=Error;
  END; (* ValidAddress *)
 
 FUNCTION IsCodeAddress(PageNo,PageIndex:Integer):Boolean;
  BEGIN
   IsCodeAddress:=false;
   IF ValidAddress(PageNo, PageIndex)=NoError THEN BEGIN
    IF ((PageNo>CodeBegPageNo) OR
        (PageNo=CodeBegPageNo) AND (PageIndex>=CodeBegPageIndex)) AND
       ((PageNo<CodeEndPageNo) OR
        (PageNo=CodeEndPageNo) AND (PageIndex<=CodeEndPageIndex)) THEN BEGIN
     IsCodeAddress:=true;
    END;
   END;
  END; (* IsCodeAddress *)

 PROCEDURE ChkAddress(VAR PageNo,PageIndex:Integer);
  VAR Error:InternalErrors;
  BEGIN
   Error:=ValidAddress(PageNo, PageIndex);
   IF ChkAddresses AND (Error<>NoError) THEN BEGIN
     InternalError(Error);
   END;
  END; (* ChkAddress *)
 
 PROCEDURE Inc(VAR PageNo,PageIndex:Integer; Increment:Integer);
  BEGIN
   PageIndex:=PageIndex+Increment;
   ChkAddress(PageNo,PageIndex);
  END; (* Inc *)
 
 PROCEDURE Dec(VAR PageNo,PageIndex:Integer; Increment:Integer);
  BEGIN
   PageIndex:=PageIndex-Increment;
   ChkAddress(PageNo,PageIndex);
  END; (* Inc *)
 
 PROCEDURE ExpandAddress(AddressHigh,AddressLow:Integer;
                         VAR PageNo,PageIndex:Integer);
  VAR LowByte,HighByte:Integer;
  BEGIN
   PageNo:=AddressHigh;
   PageIndex:=AddressLow;
   ShiftLeft(PageNo,PageIndex);
   IF CodeVersion>='4' THEN BEGIN
    ShiftLeft(PageNo,PageIndex);
    IF CodeVersion>='6' THEN BEGIN
     ShiftLeft(PageNo,PageIndex);
    END;
   END;
   ChkAddress(PageNo,PageIndex);
  END; (* ExpandAddress *)
 
 PROCEDURE PrintByte(Value:Integer; Format:Integer);
  VAR SpaceCnt,Expanded:Integer;
  BEGIN
   Expanded:=ExpandByte(Value);
   IF Format>=2 THEN BEGIN
    FOR SpaceCnt:=3 TO Format DO
     PrintCh(' ');
    PrintCh(HexChars[Succ(Nibble(Expanded,1))])
   END;
   PrintCh(HexChars[Succ(Nibble(Expanded,0))])
  END; (* PrintByte *)
 
 PROCEDURE PrintWord(Value:Integer; Format:Integer);
  VAR LowByte,HighByte:Integer;
  BEGIN
   SplitWord(Value,LowByte,HighByte);
   PrintByte(HighByte,Format-2);
   PrintByte(LowByte,2)
  END; (* PrintWord *)
 
 PROCEDURE PrintInteger(Value:Integer);
  VAR DigitCnt,Digit,WriteCnt:Integer;
  BEGIN
   IF Value<0 THEN BEGIN
    PrintCh('-'); Value:=-Value
   END;
   DigitCnt:=0;
   WHILE Value>0 DO BEGIN
    Push(Value MOD 10); DigitCnt:=Succ(DigitCnt);
    Value:=Value DIV 10
   END;
   IF DigitCnt=0 THEN
    PrintCh('0')
   ELSE
    FOR WriteCnt:=1 TO DigitCnt DO BEGIN
     Digit:=Pop; PrintCh(Chr(Digit+Ord('0')))
    END
  END; (* PrintInteger *)
 
 PROCEDURE PrintString(S:aMaxString);
  VAR ChrCnt:Integer;
  BEGIN
   FOR ChrCnt:=1 TO Length(S) DO
    PrintCh(S[ChrCnt]);
  END; (* PrintString *)
 
 PROCEDURE LineInterpreter(VAR Cmd:Commands; VAR CmdLine:aMaxString); FORWARD;
 
 PROCEDURE PrintStatusLine; FORWARD;
 
 PROCEDURE WriteLineBuffer;
  VAR ChrCnt:Integer;
  BEGIN
   IF ScreenEnabled THEN BEGIN
    FOR ChrCnt:=0 TO Pred(LineIndex) DO
     ZM_ScreenCh(LineBuffer[ChrCnt]);
   END;
   IF PrinterEnabled AND NOT WritingInWindow THEN
    FOR ChrCnt:=0 TO Pred(LineIndex) DO
     Write(Printer,LineBuffer[ChrCnt]);
   LineIndex:=0
  END; (* WriteLineBuffer *)
 
 PROCEDURE PutChInStoryBuffer(Ch:Char);
  VAR IndexPageNo,IndexPageIndex:Integer;
  BEGIN
   IF BufferPageNo<0 THEN
    InternalError(OutputBufferUndefined);
   IndexPageNo:=BufferPageNo; IndexPageIndex:=BufferPageIndex;
   Inc(IndexPageNo,IndexPageIndex,BufferIndex);
   PagePtrs[IndexPageNo]^[IndexPageIndex]:=Ord(Ch);
   BufferIndex:=Succ(BufferIndex)
  END; (* PutChInStoryBuffer *)
 
 PROCEDURE ZM_NewLine;
  VAR WaitKey:Char;
      OldCursorX,OldCursorY:Integer;
      OldPrintListing:Boolean;
  BEGIN
   IF BufferEnabled THEN BEGIN
    PutChInStoryBuffer(Chr(13));
   END ELSE BEGIN
    OldPrintListing:=PrintListing; PrintListing:=false;
    IF ScreenEnabled AND NOT WritingInWindow THEN BEGIN
     IF LineNo>=ScreenHeight THEN BEGIN
      PrintStatusLine;
      PositionCursor; OldCursorX:=CursorX; OldCursorY:=CursorY;
      LineNo:=ScrollTop;
      CursorOn;
      PrintString('[MORE]');
      WaitKey:=ReadKeyWithNoEcho(-1);
      CursorOff;
      CursorX:=OldCursorX;
      CursorY:=OldCursorY;
      PositionCursor;
      ClearToEOL;
     END;
     LineNo:=Succ(LineNo)
    END;
    WriteLineBuffer;
    IF ScreenEnabled THEN
     NewLine;
    IF PrinterEnabled THEN
     WriteLn(Printer);
    PrintListing:=OldPrintListing;
   END;
  END; (* ZM_NewLine *)
 
 PROCEDURE PutChInLineBuffer(Ch:Char);
  LABEL 1, 2;
  VAR LastIndex,CutIndex,PutIndex:Integer;
  BEGIN
   IF Ch < ' ' THEN BEGIN
    IF ChkLineChars THEN BEGIN
     InternalError(IllOutputChar);
    END;
    GOTO 2;
   END;
   LineBuffer[LineIndex]:=Ch;
   IF LineIndex+CursorX<ScreenWidth THEN BEGIN
    LineIndex:=Succ(LineIndex)
(*
   END ELSE IF WritingInWindow AND (CursorY + 1>=ScrollTop - 1) THEN BEGIN
    WriteLineBuffer;
*)
   END ELSE BEGIN
    LastIndex:=LineIndex;
    CutIndex:=LineIndex;
    WHILE CutIndex>0 DO BEGIN
     IF (CutIndex+CursorX<ScreenWidth) AND
        (LineBuffer[CutIndex]=' ') THEN
      GOTO 1;
     CutIndex:=Pred(CutIndex)
    END;
    CutIndex:=LineIndex;
1:
    LineIndex:=CutIndex;
    ZM_NewLine;
    IF LineBuffer[CutIndex]=' ' THEN BEGIN
     CutIndex:=Succ(CutIndex);
    END;
    PutIndex:=0;
    WHILE CutIndex<=LastIndex DO BEGIN
     LineBuffer[PutIndex]:=LineBuffer[CutIndex];
     CutIndex:=Succ(CutIndex); PutIndex:=Succ(PutIndex)
    END;
    LineIndex:=PutIndex
   END;
2:
  END; (* PutChInLineBuffer *)
 
 PROCEDURE PutChToStoryOutput(Ch:Char);
  VAR OldPrintListing:Boolean;
  BEGIN
   IF Ch=EOL THEN BEGIN
    ZM_NewLine;
   END ELSE IF BufferEnabled THEN BEGIN
    PutChInStoryBuffer(Ch);
   END ELSE IF ScreenEnabled OR PrinterEnabled THEN BEGIN
    IF DirectEnabled THEN BEGIN
     IF ScreenEnabled THEN BEGIN
      ZM_ScreenCh(Ch);
     END;
(*
     IF PrinterEnabled THEN BEGIN
      Write(Printer,Ch);
     END;
*)
    END ELSE BEGIN
     PutChInLineBuffer(Ch);
    END
   END
  END; (* PutChToStoryOutput *)
 
 PROCEDURE PutIntToStoryOutput(Int:Integer);
  VAR DigitCnt,Digit,WriteCnt:Integer;
  BEGIN
   IF Int<0 THEN BEGIN
    PutChToStoryOutput('-'); Int:=-Int
   END;
   DigitCnt:=0;
   WHILE Int>0 DO BEGIN
    Push(Int MOD 10); DigitCnt:=Succ(DigitCnt);
    Int:=Int DIV 10
   END;
   IF DigitCnt=0 THEN
    PutChToStoryOutput('0')
   ELSE
    FOR WriteCnt:=1 TO DigitCnt DO BEGIN
     Digit:=Pop; PutChToStoryOutput(Chr(Digit+Ord('0')))
    END
  END; (* PutIntToStoryOutput *)
 
 PROCEDURE ChkWait;
  VAR Key:Char;
  BEGIN
   IF KeyPressed THEN BEGIN
    Key:=ReadKeyWithNoEcho(-1);
    IF Ord(Key)=ExitKey THEN BEGIN
     IF PrintListing THEN BEGIN
      WriteLn(Printer); WriteLn(Printer)
     END;
     NewLine;
     WriteDump:=GlobalDumpState>NoDump;
     GOTO 999
    END ELSE IF Ord(Key)=WaitKey THEN BEGIN
     REPEAT
      Key:=ReadKeyWithNoEcho(-1);
     UNTIL Key=WaitKey;
    END ELSE BEGIN
     KeyBuffer[WriteIndex]:=Key; WriteIndex:=Succ(WriteIndex);
     IF WriteIndex>79 THEN
      WriteIndex:=0
    END
   END;
   NewLine;
   IF PrintListing THEN BEGIN
    WriteLn(Printer);
   END;
   LineCnt:=Succ(LineCnt)
  END; (* ChkWait *)
 
 PROCEDURE DisposePages;
  VAR DisposeCnt:Integer;
  BEGIN
   FOR DisposeCnt:=Pred(PageCnt) DOWNTO 0 DO BEGIN
    IF PagePtrs[DisposeCnt]<>Nil THEN BEGIN
     Dispose(PagePtrs[DisposeCnt]);
    END;
    IF DataPagePtrs[DisposeCnt]<>Nil THEN BEGIN
     Dispose(DataPagePtrs[DisposeCnt]);
    END;
   END;
   PageCnt:=0
  END; (* DisposePages *)
 
 PROCEDURE ListMiscInfo; FORWARD;

 PROCEDURE ReadPages;
  VAR SubPageCnt,EndPageNo,EndPageIndex:Integer;
      DataEndPageNo:Integer;
      SwapPage:RECORD CASE Boolean OF
       true:(
        M:tMiscInfo);
       false:(
        P:aPage)
      END;
      FileName:aMaxString;
      StoryData:FILE OF StoryFileBuffer;
  BEGIN
   IF PageCnt>0 THEN BEGIN
    DisposePages;
   END;
   FileName:=StoryName;
   IF NOT FileExists(StoryName) THEN BEGIN
    HandleError(false,'Story file not found.',false);
   END;
   Reset(StoryData,FileName);
   SwapPage.P:=StoryData^[0]; MiscInfo:=SwapPage.M;
   CodeVersion:=Chr(ExpandByte(MiscInfo.CodeType)+Ord('0'));
   ReleaseNo:=JoinBytes(MiscInfo.ReleaseLow,MiscInfo.ReleaseHigh);
   DataEndPageNo:=ExpandByte(MiscInfo.NumReadWriteBytesHigh);
   IF CodeVersion<='2' THEN BEGIN
    CodeEndPageNo:=MaxPageNo - 1;
    CodeEndPageIndex:=255;
   END ELSE BEGIN
    ExpandAddress(ExpandByte(MiscInfo.EndPageNo),
     ExpandByte(MiscInfo.EndPageIndex),
     EndPageNo,EndPageIndex);
    CodeEndPageNo:=EndPageNo;
    CodeEndPageIndex:=EndPageIndex;
    IF CodeEndPageNo>MaxPageNo THEN BEGIN
     HandleError(false,'Story too large.',false);
    END;
   END;
   IF CodeVersion>='4' THEN BEGIN
    ObjRecSize:=14;
    ObjOffset:=112;
    WordNumChars:=9;
   END ELSE BEGIN
    ObjRecSize:=9;
    ObjOffset:=53;
    WordNumChars:=6;
   END;
   WHILE (PageCnt<=CodeEndPageNo) AND NOT EOF(StoryData) DO BEGIN
    FOR SubPageCnt:=0 TO MaxSubPageNo DO BEGIN
     IF (* MemAvail<SizeOf(aPage)+MinMemSpace *) false THEN BEGIN
      DisposePages;
      HandleError(false,'Not enough memory to load story.',false)
     END;
     IF PageCnt<=CodeEndPageNo THEN BEGIN
      New(PagePtrs[PageCnt]);
      PagePtrs[PageCnt]^:=StoryData^[SubPageCnt];
      IF PageCnt<=DataEndPageNo THEN BEGIN
       New(DataPagePtrs[PageCnt]);
       DataPagePtrs[PageCnt]^:=StoryData^[SubPageCnt];
      END;
      IF PageCnt=0 THEN BEGIN
       ListMiscInfo;
      END;
      PageCnt:=Succ(PageCnt)
     END
    END;
    Get(StoryData)
   END;
   CodeBegPageNo:=0;
   CodeBegPageIndex:=0;
   IF (CodeVersion<='2') THEN BEGIN
    CodeEndPageNo:=PageCnt;
    CodeEndPageIndex:=255;
   END ELSE BEGIN
    IF (PageCnt<CodeEndPageNo) THEN BEGIN
     DisposePages; HandleError(false,'Story file incomplete.',false)
    END;
   END;
   IF NOT EOF(StoryData) THEN BEGIN
    PrintString('Story file too long. Story only requires');
    PrintWord(Succ(CodeEndPageNo),5); PrintString('00 bytes on disk.');
    ChkWait
   END;
   PrintString('Loaded'); PrintWord(PageCnt,5);
   PrintString(' pages.'); ChkWait; ChkWait
  END; (* ReadPages *)
 
 PROCEDURE ReloadData;
  VAR DataPageCnt,NumDataPages:Integer;
  BEGIN
   DataPageCnt:=0;
   NumDataPages:=ExpandByte(MiscInfo.NumReadWriteBytesHigh);
   WHILE DataPageCnt<NumDataPages DO BEGIN
    PagePtrs[DataPageCnt]^:=DataPagePtrs[DataPageCnt];
    DataPageCnt:=Succ(DataPageCnt);
   END;
  END; (* ReloadData *)
 
 PROCEDURE ExecuteSubRoutine(Address:Integer); FORWARD;

 FUNCTION ReadKey(ZMachineOp:Boolean; VAR Key:Char;
                  TimeOut:Integer;
                  CallEvent:CallEvents; CallAddress:Integer):Boolean;
  VAR SpecialKey:Char;
  BEGIN
   SpecialKey:=Chr(0);
   Key:=Chr(0);
   ReadKey:=true;
   PositionCursor;
   IF ReadIndex<>WriteIndex THEN BEGIN
    Key:=KeyBuffer[ReadIndex]; ReadIndex:=Succ(ReadIndex);
    IF ReadIndex>79 THEN
     ReadIndex:=0
   END
   ELSE BEGIN
    REPEAT
     Key:=ReadKeyWithNoEcho(TimeOut);
     IF ZMachineOp AND (Key=Chr(0)) THEN BEGIN
      IF (CallEvent=CallTimeOut) AND (CallAddress>0) THEN BEGIN
       ExecuteSubRoutine(CallAddress);
      END;
     END;
    UNTIL (Key<>Chr(0)) OR (CallEvent=CallKeyPress);
   END;
   IF ZMachineOp AND (Key<>Chr(0)) THEN BEGIN
    SpecialKey:=Chr(0);
    IF Key=UpArrow THEN BEGIN
     SpecialKey:=Chr(128 + 1);
    END ELSE IF Key=DownArrow THEN BEGIN
     SpecialKey:=Chr(128 + 2);
    END ELSE IF Key=LeftArrow THEN BEGIN
     SpecialKey:=Chr(128 + 3);
    END ELSE IF Key=RightArrow THEN BEGIN
     SpecialKey:=Chr(128 + 4);
    END ELSE IF Key=NumericSW THEN BEGIN
     SpecialKey:=Chr(146);
    END ELSE IF Key=NumericS THEN BEGIN
     SpecialKey:=Chr(147);
    END ELSE IF Key=NumericSE THEN BEGIN
     SpecialKey:=Chr(148);
    END ELSE IF Key=NumericW THEN BEGIN
     SpecialKey:=Chr(149);
    END ELSE IF Key=NumericCentre THEN BEGIN
     SpecialKey:=Chr(150);
    END ELSE IF Key=NumericE THEN BEGIN
     SpecialKey:=Chr(151);
    END ELSE IF Key=NumericNW THEN BEGIN
     SpecialKey:=Chr(152);
    END ELSE IF Key=NumericN THEN BEGIN
     SpecialKey:=Chr(153);
    END ELSE IF Key=NumericNE THEN BEGIN
     SpecialKey:=Chr(154);
    END ELSE IF IsFuncKey(Key) THEN BEGIN
     SpecialKey:=Chr(132+FuncKeyNo(Key));
    END;
    IF SpecialKey<>Chr(0) THEN BEGIN
     ReadKey:=false;
     Key:=SpecialKey;
    END
   END;
   IF CallEvent=CallKeyPress THEN BEGIN
    IF CallAddress>0 THEN BEGIN
     ExecuteSubRoutine(CallAddress);
    END    
   END;
  END; (* ReadKey *)
 
 FUNCTION ReadLine(ZMachineOp:Boolean;
                   VAR Line:aMaxString; MaxLineLength:Integer;
                   TimeOut:Integer; TimeOutCallAddress:Integer):Boolean;
  VAR Index:Integer;
      Key:Char;
      Finished:Boolean;
      GotLine:Boolean;
  BEGIN
   SaveTextAttributes;
   ScreenMode:=0; SetScreenMode;
   IF ZMachineOp THEN BEGIN
    WriteLineBuffer; PrintStatusLine; LineNo:=ScrollTop
   END;
   Index:=Length(Line); CursorOn;
   Finished:=false;
   GotLine:=true;
   IF TimeOut>=0 THEN BEGIN
    EnableTimer;
   END;
   REPEAT
    IF NOT ReadKey(ZMachineOp, Key,
                   TimeOut, CallTimeOut, TimeOutCallAddress) THEN BEGIN
     Index:=1;
     Line[1]:=Key;
     GotLine:=false;
     Finished:=true;
    END;
    IF NOT Finished THEN BEGIN
     IF (Key>=' ') AND (Key<='~') THEN BEGIN
      IF Index>=MaxLineLength THEN BEGIN
       RingBell
      END ELSE BEGIN
       ScreenCh(Key);
       Index:=Succ(Index);
       IF ZMachineOp AND (Key>='A') AND (Key<='Z') THEN BEGIN
        Key:=Chr(Ord(Key) + (Ord('a') - Ord('A')));
       END;
       Line[Index]:=Key
      END
     END
     ELSE IF (Key=Backspace) OR (Key=DeleteChar) THEN BEGIN
      IF Index>0 THEN BEGIN
       Index:=Pred(Index); EraseCh
      END ELSE BEGIN
       RingBell;
      END
     END
     ELSE IF Key=KeyToDeleteLine THEN BEGIN
      FOR Index:=Index DOWNTO 1 DO
       EraseCh;
      Index:=0
     END
     ELSE IF (Key=BreakKey) AND ZMachineOp THEN BEGIN
      RestoreTextAttributes; CursorOff;
      InternalError(KeyboardBreak)
     END
     ELSE IF Key=EOL THEN BEGIN
      Finished:=true;
     END ELSE BEGIN
      RingBell;
     END
    END
   UNTIL Finished;
   IF TimeOut>=0 THEN BEGIN
    DisableTimer;
   END;
   SetLength(Line,Index);
   IF GotLine THEN BEGIN
    NewLine;
   END;
   RestoreTextAttributes;
   CursorOff;
   IF ZMachineOp THEN BEGIN
    IF GotLine THEN BEGIN
     IF PrinterEnabled THEN BEGIN
      FOR Index:=1 TO Length(Line) DO BEGIN
       Write(Printer,Line[Index]);
      END;
      WriteLn(Printer);
     END;
    END;
   END;
   ReadLine:=GotLine;
  END; (* ReadLine *)
 
 PROCEDURE WriteCh(VAR Line:aMaxString; Ch:Char);
  VAR Pos:Integer;
  BEGIN
   Pos:=Succ(Length(Line)); SetLength(Line,Pos); Line[Pos]:=Ch
  END; (* WriteCh *)
 
 PROCEDURE DumpByte(VAR Line:aMaxString; Value:Integer);
  VAR Expanded:Integer;
  BEGIN
   Expanded:=ExpandByte(Value); WriteCh(Line,' ');
   WriteCh(Line,HexChars[Succ(Nibble(Expanded,1))]);
   WriteCh(Line,HexChars[Succ(Nibble(Expanded,0))])
  END; (* DumpByte *)
 
 PROCEDURE AddByte(VAR Line:aMaxString; Value:Integer);
  VAR Expanded:Integer;
  BEGIN
   Expanded:=ExpandByte(Value);
   WriteCh(Line,HexChars[Succ(Nibble(Expanded,1))]);
   WriteCh(Line,HexChars[Succ(Nibble(Expanded,0))])
  END; (* AddByte *)
 
 PROCEDURE AddWord(VAR Line:aMaxString; Value:Integer);
  VAR LowByte,HighByte:Integer;
  BEGIN
   SplitWord(Value,LowByte,HighByte);
   AddByte(Line,HighByte); AddByte(Line,LowByte)
  END; (* AddWord *)
 
 FUNCTION GetByteDC:Integer;
  VAR Value:Integer;
  BEGIN
   ChkAddress(DC_PageNo, DC_PageIndex);
   Value:=ExpandByte(PagePtrs[DC_PageNo]^[DC_PageIndex]);
   GetByteDC:=Value;
   Inc(DC_PageNo, DC_PageIndex, 1);
   IF WriteDump THEN BEGIN
    DumpByte(Dump,Value); DumpCnt:=Succ(DumpCnt);
   END ELSE IF GlobalDumpState<>UnpackedDump THEN BEGIN
    DumpCnt:=11;
   END
  END; (* GetByteDC *)
 
 FUNCTION GetByteIPC:Integer;
  BEGIN
   ChkAddress(IPC_PageNo, IPC_PageIndex);
   GetByteIPC:=ExpandByte(PagePtrs[IPC_PageNo]^[IPC_PageIndex]);
   Inc(IPC_PageNo, IPC_PageIndex, 1);
  END; (* GetByteIPC *)
 
 FUNCTION GetWordDC:Integer;
  VAR LowByte,HighByte:Integer;
  BEGIN
   HighByte:=GetByteDC; LowByte:=GetByteDC;
   GetWordDC:=JoinBytes(LowByte,HighByte)
  END; (* GetWordDC *)
 
 FUNCTION GetWordIPC:Integer;
  VAR LowByte,HighByte:Integer;
  BEGIN
   HighByte:=GetByteIPC; LowByte:=GetByteIPC;
   GetWordIPC:=JoinBytes(LowByte,HighByte)
  END; (* GetWordIPC *)
 
 PROCEDURE CalcCodeBase(VAR CodeBasePageNo:Integer;
                        VAR CodeBasePageIndex:Integer);
  BEGIN
   IF CodeVersion<='5' THEN BEGIN
    CodeBasePageNo:=0;
    CodeBasePageIndex:=0;
   END ELSE BEGIN
    CodeBasePageNo:=MiscInfo.CodeBasePageNo;
    CodeBasePageIndex:=MiscInfo.CodeBaseIndex;
    ShiftLeft(CodeBasePageNo,CodeBasePageIndex);
    ShiftLeft(CodeBasePageNo,CodeBasePageIndex);
    ShiftLeft(CodeBasePageNo,CodeBasePageIndex);
   END;
  END; (* CalcCodeBase *)

 PROCEDURE CalcCallAddress(Address:Integer;
                           VAR CallPageNo:Integer;
                           VAR CallPageIndex:Integer);
  VAR CodeBasePageNo:Integer;
      CodeBasePageIndex:Integer;
  BEGIN
   CallPageNo:=0;
   CallPageIndex:=Address;
   ShiftLeft(CallPageNo, CallPageIndex);
   IF CodeVersion>='4' THEN BEGIN
    ShiftLeft(CallPageNo, CallPageIndex);
    IF CodeVersion>='6' THEN BEGIN
     CalcCodeBase(CodeBasePageNo, CodeBasePageIndex);
     CallPageNo:=CallPageNo+CodeBasePageNo;
     CallPageIndex:=CallPageIndex+CodeBasePageIndex;
    END;
   END;
  END; (* CalcCallAddress *)

 PROCEDURE CalcStartAddress(VAR StartPageNo:Integer;
                            VAR StartPageIndex:Integer);
  BEGIN
   IF CodeVersion<='5' THEN BEGIN
    StartPageNo:=ExpandByte(MiscInfo.StartPageNo);
    StartPageIndex:=ExpandByte(MiscInfo.StartIndex);
   END ELSE BEGIN
    CalcCallAddress(JoinBytes(MiscInfo.StartIndex,MiscInfo.StartPageNo),
      StartPageNo,StartPageIndex);
   END;
  END; (* CalcStartAddress *)

 PROCEDURE StringToNumber(VAR Number:Integer; NumString:anAddrString);
  VAR DigitCnt:Integer;
      HexDigit:Char;
  BEGIN
   Number:=0;
   FOR DigitCnt:=1 TO Length(NumString) DO BEGIN
    HexDigit:=NumString[DigitCnt];
    IF (HexDigit>='a') AND (HexDigit<='z') THEN
     HexDigit:=Chr(Ord(HexDigit)-Ord('a')+Ord('A'));
    IF HexDigit>='A' THEN
     Number:=16*Number+(Ord(HexDigit)-Ord('A')+10)
    ELSE
     Number:=16*Number+(Ord(HexDigit)-Ord('0'))
   END
  END; (* StringToNumber *)
 
 PROCEDURE WriteText(TextType:Char;
                     OutputType:OutputTypes;
                     SourceType:SourceTypes;
                     VAR TextBuffer:aMaxString;
                     MaxLength:Integer);
  LABEL 888;
  VAR ChByte,Buffer,PreviousCh,ChType,ChBuffer,ChCnt:Integer;
      PackIndex,LineIndex,LineLength:Integer;
      TextEnd:Boolean;
      Three,ThreeLow,ThreeHigh:Integer; (* PACKED RECORD CASE Integer OF
       1:(Word:Integer);
       2:(Chars:PACKED ARRAY [0..2] OF 0..31);
       3:(PackedChars:0..32767;
          TextEnd:Boolean)
      END; *)
      TextLine:aMaxString;
      StartIndex,StartPageNo:Integer;
      OldWriteDump,IsVocabulary,Error:Boolean;
  
  PROCEDURE HandleEndOfText; FORWARD;
  
  PROCEDURE GetCh(VAR Ch:Integer; VAR TextEnd:Boolean);
   BEGIN
    IF TextEnd THEN BEGIN
     HandleEndOfText; GOTO 888
    END;
    IF PackIndex=0 THEN BEGIN
     IF SourceType=FromIPC THEN BEGIN
      Three:=GetWordIPC;
     END ELSE BEGIN
      Three:=GetWordDC;
     END;
     SplitWord(Three,ThreeLow,ThreeHigh);
     Ch:=land(lsr(ThreeHigh,2),31);
    END ELSE IF PackIndex=1 THEN BEGIN
     Ch:=lor(land(lsr(ThreeLow,5),7),lsl(land(ThreeHigh,3),3));
    END ELSE BEGIN
     Ch:=land(ThreeLow,31);
     TextEnd:=TstBit(Three,15); PackIndex:=-1
    END;
    PackIndex:=Succ(PackIndex);
    IF IsVocabulary THEN BEGIN
     Error:=NOT TextEnd; ChCnt:=Succ(ChCnt); TextEnd:=ChCnt=WordNumChars
    END;
    IF GlobalDumpState=UnpackedDump THEN BEGIN
     DumpByte(Dump,Ch); DumpCnt:=Succ(DumpCnt)
    END
   END; (* GetCh *)
  
  FUNCTION GetBuffer:Integer;
   BEGIN
    IF ChType>127 THEN BEGIN
     GetBuffer:=ChBuffer;
    END ELSE BEGIN
     GetBuffer:=ChType;
     ChType:=255;
    END;
   END; (* GetCnt *)
  
  PROCEDURE DumpText;
   VAR SpaceCnt,NumSpaces:Integer;
   BEGIN
    SetLength(TextLine,LineIndex);
    IF OutputType=OntoScreen THEN BEGIN
     PrintCh(TextType);
     PrintWord(StartPageNo,5);
     PrintByte(StartIndex,2);
     PrintCh(':');
     PrintString(Dump);
     IF LineIndex>0 THEN BEGIN
      IF GlobalDumpState>CodeDump THEN BEGIN
       NumSpaces:=(12-DumpCnt)*3
      END ELSE BEGIN
       NumSpaces:=3;
      END;
      FOR SpaceCnt:=1 TO NumSpaces DO BEGIN
       PrintCh(' ');
      END;
      PrintCh('|'); PrintString(TextLine); PrintCh('|')
     END;
     IF SourceType=FromDC THEN BEGIN
      StartPageNo:=DC_PageNo;
      StartIndex:=DC_PageIndex
     END ELSE BEGIN
      StartPageNo:=IPC_PageNo;
      StartIndex:=IPC_PageIndex
     END;
     ChkWait;
    END ELSE IF OutputType<>IntoSink THEN BEGIN
     IF Length(TextBuffer)+LineIndex>MaxLength THEN BEGIN
      LineIndex:=MaxLength-Length(TextBuffer);
      IF LineIndex<0 THEN BEGIN
       LineIndex:=0;
      END;
      SetLength(TextLine,LineIndex);
     END;
     TextBuffer:=Concat(TextBuffer,TextLine);
    END;
    LineIndex:=0;
    IF GlobalDumpState>SuppressDump THEN BEGIN
     Dump:=''; DumpCnt:=0;
    END;
   END; (* DumpText *)
  
  PROCEDURE PutCh(Ch:Char);
   VAR ChrCnt:Integer;
       ByteString:aMaxString;
   BEGIN
    IF OutputType=ToStoryOutput THEN BEGIN
     PutChToStoryOutput(Ch);
    END ELSE IF Ch=EOL THEN BEGIN
     DumpText;
    END ELSE BEGIN
     IF (DumpCnt>11) OR (LineIndex>LineLength) THEN BEGIN
      DumpText;
     END;
     IF (Ch>=' ') AND (Ch<='~') THEN BEGIN
      LineIndex:=Succ(LineIndex);
      TextLine[LineIndex]:=Ch;
     END ELSE BEGIN
      PutCh('['); ByteString:=''; AddByte(ByteString,Ord(Ch));
      FOR ChrCnt:=1 TO Length(ByteString) DO BEGIN
       PutCh(ByteString[ChrCnt]);
      END;
      PutCh(']');
     END;
    END;
   END; (* PutCh *)
  
  PROCEDURE HandleEndOfText;
   BEGIN
    IF (LineIndex>0) OR
       (Length(Dump)>0) AND (GlobalDumpState=UnpackedDump) THEN BEGIN
     DumpText;
    END;
    IF IsVocabulary THEN BEGIN
     IF Error THEN BEGIN
      TextBuffer:=Concat(TextBuffer,'E');
     END;
    END;
    WriteDump:=OldWriteDump;
   END; (* HandleEndOfText *)
  
  PROCEDURE WriteSpecialText;
   VAR SpecialNo:Integer;
       AdrsPageNo,AdrsIndex,ChrCnt:Integer;
       SpecialBuffer:aMaxString;
   BEGIN
    GetCh(SpecialNo,TextEnd);
    AdrsIndex:=
     Pred(Succ(2*SpecialNo)+64*Pred(ChByte)+ExpandByte(MiscInfo.SpecialIndex));
    AdrsPageNo:=ExpandByte(MiscInfo.SpecialPageNo);
    ChkAddress(AdrsPageNo,AdrsIndex);
    IF GlobalDumpState>CodeDump THEN BEGIN
     IF (LineIndex>0) OR (Length(Dump)>0) THEN BEGIN
      DumpText;
     END;
    END;
    Push(DC_PageNo); Push(DC_PageIndex);
    DC_PageNo:=AdrsPageNo; DC_PageIndex:=AdrsIndex;
    AdrsPageNo:=2*GetByteDC; AdrsIndex:=2*GetByteDC;
    ChkAddress(AdrsPageNo,AdrsIndex);
    DC_PageNo:=AdrsPageNo; DC_PageIndex:=AdrsIndex;
    IF OutputType=ToStoryOutput THEN BEGIN
     WriteText('S',ToStoryOutput,FromDC,SpecialBuffer,0);
    END ELSE BEGIN
     WriteText('S',IntoBuffer,FromDC,SpecialBuffer,SizeOf(SpecialBuffer)-1);
     FOR ChrCnt:=1 TO Length(SpecialBuffer) DO BEGIN
      PutCh(SpecialBuffer[ChrCnt]);
     END;
    END;
    ChType:=255;
    IF GlobalDumpState>CodeDump THEN BEGIN
     Dump:=''; DumpCnt:=0;
     StartPageNo:=AdrsPageNo; StartIndex:=AdrsIndex
    END;
    DC_PageIndex:=Pop; DC_PageNo:=Pop;
   END; (* WriteSpecialText *)
  
  BEGIN (* WriteText *)
   TextBuffer:='';
   OldWriteDump:=WriteDump;
   WriteDump:=
    (GlobalDumpState=TextDump) AND
    (OutputType<>ToStoryOutput) AND
    (OutputType<>IntoSink);
   PackIndex:=0;
   LineIndex:=0;
   IF GlobalDumpState>SuppressDump THEN BEGIN
    Dump:=''; DumpCnt:=0;
   END;
   TextEnd:=false;
   ChCnt:=0;
   IF SourceType=FromDC THEN BEGIN
    StartPageNo:=DC_PageNo; StartIndex:=DC_PageIndex
   END ELSE BEGIN
    StartPageNo:=IPC_PageNo; StartIndex:=IPC_PageIndex
   END;
   ChBuffer:=0; ChType:=255;
   IsVocabulary:=TextType='V'; Error:=false;
   IF GlobalDumpState>CodeDump THEN BEGIN
    LineLength:=20
   END ELSE BEGIN
    LineLength:=64;
   END;
   REPEAT
    GetCh(ChByte,TextEnd);
    IF ChByte=0 THEN BEGIN
     PutCh(' ')
    END ELSE IF CodeVersion<='2' THEN BEGIN
     IF ChByte=1 THEN
      IF CodeVersion='1' THEN BEGIN
       PutCh(EOL)
      END
      ELSE
       WriteSpecialText
     ELSE IF ChByte<4 THEN BEGIN
      Buffer:=GetBuffer+2+ChByte;
      WHILE Buffer>=3 DO
       Buffer:=Buffer-3;
      ChType:=Buffer
     END
     ELSE IF ChByte<6 THEN BEGIN
      Buffer:=GetBuffer+ChByte;
      WHILE Buffer>=3 DO
       Buffer:=Buffer-3;
      ChBuffer:=Buffer
     END
     ELSE BEGIN
      Buffer:=GetBuffer;
      IF Buffer=0 THEN
       PutCh(Chr(ChByte+91))
      ELSE IF Buffer=1 THEN
       PutCh(Chr(ChByte+59))
      ELSE BEGIN
       Buffer:=ChByte-7;
       IF (Buffer=0) AND (CodeVersion='2') THEN BEGIN
        PutCh(EOL)
       END
       ELSE IF Buffer<0 THEN BEGIN
        GetCh(ChByte,TextEnd); GetCh(Buffer,TextEnd);
        Buffer:=lor(land((32*ChByte),255),Buffer);
        IF (Buffer=9) AND (CodeVersion='1') THEN
         PutCh(' ')
        ELSE
         PutCh(Chr(Buffer))
       END
       ELSE IF CodeVersion='1' THEN
        PutCh(Char1Table[Succ(Buffer)])
       ELSE
        PutCh(Char23Table[Buffer])
      END
     END
    END ELSE IF CodeVersion>='3' THEN BEGIN
     IF ChByte<4 THEN
      WriteSpecialText
     ELSE IF ChByte<6 THEN BEGIN
      Buffer:=ChByte-3; PreviousCh:=GetBuffer;
      IF (PreviousCh=0) AND ((Buffer=0) OR (ChType>127)) THEN
       ChType:=Buffer
      ELSE BEGIN
       ChBuffer:=Buffer;
       IF PreviousCh<>ChBuffer THEN
        ChBuffer:=0
      END
     END
     ELSE BEGIN
      PreviousCh:=GetBuffer;
      IF PreviousCh=0 THEN
       PutCh(Chr(ChByte+91))
      ELSE IF PreviousCh=1 THEN
       PutCh(Chr(ChByte+59))
      ELSE BEGIN
       Buffer:=ChByte-7;
       IF Buffer<0 THEN BEGIN
        GetCh(ChByte,TextEnd); GetCh(Buffer,TextEnd);
        PutCh(Chr(lor(land((32*ChByte),255),Buffer)))
       END
       ELSE IF Buffer=0 THEN BEGIN
        PutCh(EOL)
       END
       ELSE
        PutCh(Char23Table[Buffer])
      END
     END
    END;
   UNTIL TextEnd;
   HandleEndOfText;
888:
  END; (* WriteText *)
 
 PROCEDURE CalcObjAdrs(ObjNo:Integer; VAR ObjPageNo,ObjPageIndex:Integer;
                       FieldOffset:Integer; FlagError:Boolean);
  BEGIN
   IF (ObjNo<=0) OR (ObjNo>=1024) THEN BEGIN
    ObjPageNo:=0;
    ObjPageIndex:=0;
    IF FlagError THEN BEGIN
     InternalError(IllObj);
    END;
   END ELSE BEGIN
    ObjPageNo:=ExpandByte(MiscInfo.ObjPageNo);
    ObjPageIndex:=ExpandByte(MiscInfo.ObjPageIndex);
    Inc(ObjPageNo, ObjPageIndex,
     ObjNo*ObjRecSize+ObjOffset+FieldOffset)
   END;
  END; (* CalcObjAdrs *)
 
 PROCEDURE CalcObjNameAdrs(ObjNo:Integer;
                           VAR NamePageNo,NamePageIndex:Integer;
                           VAR NameLength:Integer);
  VAR ObjPageNo,ObjPageIndex:Integer;
  BEGIN
   IF CodeVersion<'4' THEN BEGIN
    CalcObjAdrs(ObjNo, ObjPageNo, ObjPageIndex, 7, false);
   END ELSE BEGIN
    CalcObjAdrs(ObjNo, ObjPageNo, ObjPageIndex, 12, false);
   END;
   IF (ObjPageNo=0) THEN BEGIN
    NamePageNo:=0;
    NamePageIndex:=0;
    NameLength:=0;
   END ELSE BEGIN
    NamePageNo:=ExpandByte(PagePtrs[ObjPageNo]^[ObjPageIndex]);
    Inc(ObjPageNo,ObjPageIndex,1);
    NamePageIndex:=ExpandByte(PagePtrs[ObjPageNo]^[ObjPageIndex]);
    NameLength:=PagePtrs[NamePageNo]^[NamePageIndex];
    Inc(NamePageNo,NamePageIndex,1); (* skip length byte *)
    IF (ValidAddress(NamePageNo,NamePageIndex)<>NoError) OR
       (ValidAddress(NamePageNo,NamePageIndex+NameLength)<>NoError) THEN BEGIN
     NamePageNo:=0;
     NamePageIndex:=0;
     NameLength:=0;
    END;
   END;
  END; (* CalcObjNameAdrs *)

 PROCEDURE AddObjName(VAR Line:aMaxString; ObjNo:Integer);
  VAR NamePageNo, NamePageIndex:Integer;
      NameLength:Integer;
      OldDumpState:DumpStates;
      ObjName:aMaxString;
  BEGIN
   CalcObjNameAdrs(ObjNo, NamePageNo, NamePageIndex, NameLength);
   IF NameLength>0 THEN BEGIN
    OldDumpState:=GlobalDumpState;
    GlobalDumpState:=SuppressDump;
    Push(DumpCnt);
    Push(DC_PageNo);
    Push(DC_PageIndex);
    DC_PageNo:=NamePageNo; DC_PageIndex:=NamePageIndex;
    WriteText('N',IntoBuffer,FromDC,ObjName,SizeOf(ObjName)-1);
    DC_PageIndex:=Pop;
    DC_PageNo:=Pop;
    DumpCnt:=Pop;
    GlobalDumpState:=OldDumpState;
    NameLength:=Length(ObjName);
   END;
   IF NameLength=0 THEN BEGIN
    ObjName:='<no name $';
    IF ObjNo>256 THEN BEGIN
     AddWord(ObjName, ObjNo);
    END ELSE BEGIN
     AddByte(ObjName, ObjNo);
    END;
    WriteCh(ObjName, '>');
   END;
   WriteCh(Line, '"');
   Line:=Concat(Line, ObjName);
   WriteCh(Line, '"');
  END; (* AddObjName *)

 FUNCTION CodeCorrect(VAR CodeChkSum:ShortInteger):Boolean;
  VAR ChkSum:ShortInteger;
      NumDataPages,PageCnt,ByteCnt,ChkSumLow,ChkSumHigh:Integer;
      ChkPagePtr:PtrPage;
  BEGIN
   ChkSum:=0;
   NumDataPages:=ExpandByte(MiscInfo.NumReadWriteBytesHigh);
   ChkPagePtr:=DataPagePtrs[0];
   ByteCnt:=64;
   WHILE ByteCnt<256 DO BEGIN   
    ChkSum:=ChkSum+ExpandByte(ChkPagePtr^[ByteCnt]);
    ByteCnt:=Succ(ByteCnt)
   END;
   PageCnt:=1;
   WHILE PageCnt<CodeEndPageNo DO BEGIN
    IF PageCnt<=NumDataPages THEN BEGIN
     ChkPagePtr:=DataPagePtrs[PageCnt];
    END ELSE BEGIN
     ChkPagePtr:=PagePtrs[PageCnt];
    END;
    ByteCnt:=0;
    WHILE ByteCnt<256 DO BEGIN
     ChkSum:=ChkSum+ExpandByte(ChkPagePtr^[ByteCnt]);
     ByteCnt:=Succ(ByteCnt)
    END;
    PageCnt:=Succ(PageCnt)
   END;
   ByteCnt:=0; ChkPagePtr:=PagePtrs[CodeEndPageNo];
   WHILE ByteCnt<CodeEndPageIndex DO BEGIN
    ChkSum:=ChkSum+ExpandByte(ChkPagePtr^[ByteCnt]);
    ByteCnt:=Succ(ByteCnt)
   END;
   CodeChkSum:=ChkSum;
   SplitWord(ChkSum,ChkSumLow,ChkSumHigh);
   CodeCorrect:=(ChkSumLow =ExpandByte(MiscInfo.ChkSumLow)) AND
                (ChkSumHigh=ExpandByte(MiscInfo.ChkSumHigh))
  END; (* CodeCorrect *)
 
 PROCEDURE SaveEntryPoint(EntryAddress:Integer);
  VAR EntryCnt:Integer;
  BEGIN
   IF SaveEntryPoints THEN BEGIN
    EntryAddress:=land(EntryAddress,65535);
    EntryCnt:=Pred(EntryIndex);
    WHILE (EntryCnt>=0) AND (EntryPoints[EntryCnt]<>EntryAddress) DO BEGIN
     EntryCnt:=Pred(EntryCnt);
    END;
    IF EntryCnt<0 THEN BEGIN
     IF EntryIndex<=MaxEntryPointCnt THEN BEGIN
      EntryPoints[EntryIndex]:=EntryAddress;
      EntryIndex:=Succ(EntryIndex)
     END ELSE BEGIN
      PrintString('Warning: No more room to save entry points');
      RingBell;
      NewLine;
     END;
    END;
   END;
  END; (* SaveEntryPoint *)
 
 PROCEDURE RemoveEntry(EntryPageNo,EntryPageIndex:Integer);
  VAR EntryCnt,PageNo,PageIndex:Integer;
      Found:Boolean;
      Error:InternalErrors;
  BEGIN
   EntryCnt:=Pred(EntryIndex);
   Found:=false;
   WHILE NOT Found AND (EntryCnt>=0) DO BEGIN
    CalcCallAddress(EntryPoints[EntryCnt],PageNo,PageIndex);
    Error:=ValidAddress(PageNo,PageIndex);
    IF (Error=NoError) AND
       (PageNo=EntryPageNo) AND (PageIndex=EntryPageIndex) THEN BEGIN
     Found:=true;
    END ELSE BEGIN
     EntryCnt:=Pred(EntryCnt);
    END;
   END;
   IF NOT Found THEN BEGIN
    PrintString('Error: Entry point not found:');
    PrintWord(EntryPageNo,5); PrintByte(EntryPageIndex,2);
    ChkWait;
   END ELSE BEGIN
    EntryCnt:=Succ(EntryCnt);
    WHILE (EntryCnt<EntryIndex) DO BEGIN
     EntryPoints[Pred(EntryCnt)]:=EntryPoints[EntryCnt];
     EntryCnt:=Succ(EntryCnt)
    END;
    EntryIndex:=Pred(EntryIndex)
   END
  END; (* RemoveEntry *)
 
 PROCEDURE DisRegList(NumRegsToInit:Integer; DisplayListing:Boolean);
  VAR OldWriteDump:Boolean;
      RegCnt,RegValue,FirstPage,FirstIndex,AddressPageNo,AddressIndex,
      CodeBasePageNo,CodeBasePageIndex,EntryAddress:Integer;
      RegLine:aMaxString;
  BEGIN
   FirstPage:=DC_PageNo; FirstIndex:=Pred(DC_PageIndex);
   IF FirstIndex<0 THEN BEGIN
    FirstIndex:=FirstIndex+256; FirstPage:=Pred(FirstPage)
   END;
   IF (FirstIndex MOD 2 <> 0) OR
      (CodeVersion>='4') AND (FirstIndex MOD 4 <> 0) THEN BEGIN
    PrintString('Error: Illegal entry point.');
    RingBell;
    NewLine;
    GOTO 999
   END;
   IF NumRegsToInit>15 THEN BEGIN
    PrintString('Error: Too much register data:');
    PrintByte(NumRegsToInit,3); RingBell;
    NewLine; GOTO 999
   END;
   OldWriteDump:=WriteDump; WriteDump:=false;
   AddressPageNo:=FirstPage; AddressIndex:=FirstIndex;
   IF CodeVersion>='6' THEN BEGIN
    CalcCodeBase(CodeBasePageNo, CodeBasePageIndex);
    AddressPageNo:=AddressPageNo-CodeBasePageNo;
    AddressIndex:=AddressIndex-CodeBasePageIndex;
    ChkAddress(AddressPageNo,AddressIndex);
   END;
   ShiftRight(AddressPageNo,AddressIndex);
   IF CodeVersion>='4' THEN BEGIN
    ShiftRight(AddressPageNo,AddressIndex);
   END;
   EntryAddress:=JoinBytes(AddressIndex,AddressPageNo);
   SaveEntryPoint(EntryAddress);
   IF CodeVersion<='4' THEN BEGIN
    RegCnt:=0;
    REPEAT
     RegCnt:=Succ(RegCnt);
     IF (RegCnt=1) OR (Length(RegLine)+5>ScreenWidth) THEN BEGIN
      IF RegCnt>1 THEN BEGIN
       PrintString(RegLine);
       ChkWait;
      END;
      RegLine:='R';
      WriteCh(RegLine, ' ');
      IF RegCnt>1 THEN BEGIN
       AddWord(RegLine, DC_PageNo);
       AddByte(RegLine, DC_PageIndex)
      END ELSE BEGIN
       AddWord(RegLine, FirstPage);
       AddByte(RegLine, FirstIndex)
      END;
      WriteCh(RegLine, ':');
      WriteCh(RegLine, ' ');
      IF RegCnt>1 THEN BEGIN
       IF DisplayListing THEN BEGIN
        WriteCh(RegLine, ' ');
        WriteCh(RegLine, ' ');
       END;
      END ELSE BEGIN
       AddByte(RegLine, NumRegsToInit);
      END;
      IF DisplayListing THEN BEGIN
       WriteCh(RegLine,' ');
      END;
     END;
     IF RegCnt<=NumRegsToInit THEN BEGIN
      RegValue:=GetWordDC;
      IF DisplayListing THEN BEGIN
       AddWord(RegLine,RegValue);
       WriteCh(RegLine,' ');
      END;
     END;
    UNTIL RegCnt>=NumRegsToInit;
   END ELSE BEGIN
    RegLine:='R';
    WriteCh(RegLine, ' ');
    AddWord(RegLine, FirstPage);
    AddByte(RegLine, FirstIndex);
    WriteCh(RegLine, ':');
    WriteCh(RegLine, ' ');
    AddByte(RegLine, NumRegsToInit)
   END;
   PrintString(RegLine);
   ChkWait;
   IF NOT DisplayListing THEN BEGIN
    MoveCursorUp;
   END;
   WriteDump:=OldWriteDump
  END; (* DisRegList *)
 
 PROCEDURE GetJump(SourceType:SourceTypes;
                   VAR TrueJump:Boolean; VAR Distance:Integer);
  VAR Offset,HighByte,LowByte:Integer;
  BEGIN
   IF SourceType=FromDC THEN
    Offset:=GetByteDC
   ELSE
    Offset:=GetByteIPC;
   TrueJump:=cTrueJump(Offset);
   IF cShort(Offset) THEN
    Offset:=cDistance(Offset)
   ELSE BEGIN
    HighByte:=cDistance(Offset);
    IF SourceType=FromDC THEN
     LowByte:=GetByteDC
    ELSE
     LowByte:=GetByteIPC;
    Offset:=JoinBytes(LowByte,HighByte);
    IF TstBit(Offset,13) THEN BEGIN
     Offset:=lor(Offset,-16384)
    END
   END;
   Distance:=Offset
  END; (* GetJump *)
 
 PROCEDURE CalcJump(FromPageNo,FromPageIndex:Integer;
                    VAR ToPageNo,ToPageIndex:Integer; Offset:Integer);
  VAR DestPageNo:Integer;
      DestIndex,HighByte,LowByte:Integer;
  BEGIN
   SplitWord(Offset-2,LowByte,HighByte);
   IF CodeVersion<'4' THEN
    DestPageNo:=lsl(HighByte,1)
   ELSE
    DestPageNo:=lsl(HighByte,2);
   DestPageNo:=lor(land(DestPageNo,HighByteMask),HighByte);
   DestIndex:=FromPageIndex+LowByte;
   WHILE DestIndex>=256 DO BEGIN
    DestIndex:=DestIndex-256; DestPageNo:=Succ(DestPageNo)
   END;
   WHILE DestIndex<0 DO BEGIN
    DestIndex:=DestIndex+256; DestPageNo:=Pred(DestPageNo)
   END;
   DestPageNo:=DestPageNo+FromPageNo;
   IF CodeVersion<'4' THEN
    DestPageNo:=land(DestPageNo,511)
   ELSE
    DestPageNo:=land(DestPageNo,1023);
   ToPageNo:=DestPageNo; ToPageIndex:=DestIndex
  END; (* CalcJump *)
 
 PROCEDURE PutBPTCode(WrkBPT:PtrBPT);
  VAR PageNo,PageIndex:Integer;
  BEGIN
   PageNo:=WrkBPT^.BPT_PageNo; PageIndex:=WrkBPT^.BPT_PageIndex;
   WrkBPT^.OrgByte1:=ExpandByte(PagePtrs[PageNo]^[PageIndex]);
   PagePtrs[PageNo]^[PageIndex]:=0(* BPT #xx #xx *);
   Inc(PageNo,PageIndex,1);
   WrkBPT^.OrgByte2:=ExpandByte(PagePtrs[PageNo]^[PageIndex]);
   PagePtrs[PageNo]^[PageIndex]:=WrkBPT^.BPT_No;
   Inc(PageNo,PageIndex,1);
   WrkBPT^.OrgByte3:=ExpandByte(PagePtrs[PageNo]^[PageIndex]);
   PagePtrs[PageNo]^[PageIndex]:=Ord(WrkBPT^.BPT_Type)
  END; (* PutBPTCode *)
 
 PROCEDURE PutOrgCode(WrkBPT:PtrBPT);
  VAR PageNo,PageIndex:Integer;
  BEGIN
   PageNo:=WrkBPT^.BPT_PageNo; PageIndex:=WrkBPT^.BPT_PageIndex;
   PagePtrs[PageNo]^[PageIndex]:=WrkBPT^.OrgByte1;
   Inc(PageNo,PageIndex,1);
   PagePtrs[PageNo]^[PageIndex]:=WrkBPT^.OrgByte2;
   Inc(PageNo,PageIndex,1);
   PagePtrs[PageNo]^[PageIndex]:=WrkBPT^.OrgByte3
  END; (* PutOrgCode *)
 
 PROCEDURE SetBPT(BPT_No,BPT_PageNo,BPT_PageIndex:Integer; BPT_Type:BPT_Types);
  VAR NewBPT:PtrBPT;
  BEGIN
   BPT_IdCnt:=Succ(BPT_IdCnt);
   New(NewBPT);
   NewBPT^.BPT_No:=BPT_No;
   NewBPT^.HitCnt:=0;
   NewBPT^.BPT_PageNo:=BPT_PageNo;
   NewBPT^.BPT_PageIndex:=BPT_PageIndex;
   NewBPT^.BPT_Type:=BPT_Type;
   NewBPT^.NextBPT:=BPT_List;
   BPT_List:=NewBPT;
   PutBPTCode(NewBPT)
  END; (* SetBPT *)
 
 PROCEDURE ClearBPT(BPT_No:Integer);
  VAR WrkBPT,PredBPT:PtrBPT;
      Cleared:Boolean;
  BEGIN
   Cleared:=false;
   WrkBPT:=BPT_List; PredBPT:=Nil;
   WHILE WrkBPT<>Nil DO BEGIN
    IF WrkBPT^.BPT_No=BPT_No THEN BEGIN
     PutOrgCode(WrkBPT);
     IF PredBPT=Nil THEN
      BPT_List:=WrkBPT^.NextBPT
     ELSE
      PredBPT^.NextBPT:=WrkBPT^.NextBPT;
     Dispose(WrkBPT); WrkBPT:=Nil; Cleared:=true;
    END
    ELSE BEGIN
     PredBPT:=WrkBPT; WrkBPT:=WrkBPT^.NextBPT
    END
   END;
   IF NOT Cleared THEN
    HandleError(false,'Break-point not found.',false)
  END; (* ClearBPT *)
 
 PROCEDURE PrintBPTs;
  VAR WrkBPT:PtrBPT;
      Opcode:Integer;
  BEGIN
   PrintString('Current BPT-Id:');
   PrintByte(BPT_IdCnt,3);
   ChkWait;
   WrkBPT:=BPT_List;
   WHILE WrkBPT<>Nil DO BEGIN
    PrintWord(WrkBPT^.BPT_PageNo,4);
    PrintByte(WrkBPT^.BPT_PageIndex,2);
    PrintString(': BPT #');
    PrintByte(WrkBPT^.BPT_No,2);
    PrintString(' hits=');
    PrintWord(WrkBPT^.HitCnt,4);
    CASE WrkBPT^.BPT_Type OF
     UndefinedBPT:
      PrintString(' undefined');
     UserBPT:
      PrintString(' user');
     RunBPT:
      PrintString(' run');
     TraceBPT:
      PrintString(' trace');
     OTHERWISE
      ;
    END;
    ChkWait;
    WrkBPT:=WrkBPT^.NextBPT
   END;
   FOR Opcode:=0 TO 255 DO BEGIN
    IF BreakOnOpcode[Opcode] THEN BEGIN
     PrintByte(Opcode,6);
     PrintString(': BPT on opcode');
     ChkWait;
    END;
   END;
  END; (* PrintBPTs *)
 
 PROCEDURE Disassemble(NumLines:Integer; GetCmdCode:Boolean;
                       NextShouldBeEntryPoint:Boolean;
                       DisplayListing:Boolean);
  LABEL 1;
  TYPE MnemString=String;
  VAR DumpText,NextCouldBeEntryPoint,InstIsBPT:Boolean;
      WrkBPT:PtrBPT;
      BPT_No,BPT_Type,DisInstPageNo,DisInstPageIndex,SpaceCnt:Integer;
      CmdLine:aMaxString;
      
  PROCEDURE WriteAddressMode(VAR Line:aMaxString; AddressMode:Integer);
   BEGIN
    IF NOT GetCmdCode THEN
     Line:=Concat(Line,'Rx')
    ELSE IF AddressMode=0 THEN
     WriteCh(Line,'S')
    ELSE IF AddressMode<16 THEN BEGIN
     WriteCh(Line,'R');
     WriteCh(Line,HexChars[Succ(Nibble(Pred(AddressMode),0))])
    END
    ELSE BEGIN
     WriteCh(Line,'*'); AddWord(Line,2*(AddressMode-16))
    END
   END; (* WriteAddressMode *)
  
  PROCEDURE DisAddressMode(Load,Indirect:Boolean);
   VAR AddressMode:Integer;
   BEGIN
    IF GetCmdCode THEN
     AddressMode:=GetByteDC;
    IF NOT Load THEN BEGIN
     CmdLine:=Concat(CmdLine,'->'); CmdLine:=Concat(CmdLine,' ')
    END;
    IF Indirect THEN
     WriteCh(CmdLine,'(');
    IF GetCmdCode THEN BEGIN
     IF AddressMode=0 THEN
      IF Load THEN
       WriteCh(CmdLine,'-')
      ELSE
       WriteCh(CmdLine,'+');
     WriteAddressMode(CmdLine,AddressMode)
    END
    ELSE
     CmdLine:=Concat(CmdLine,'Rx');
    IF Indirect THEN
     WriteCh(CmdLine,')')
   END; (* DisAddressMode *)
  
  PROCEDURE WriteJump(Distance:Integer);
   VAR DestPageNo,DestIndex:Integer;
   BEGIN
    IF GetCmdCode THEN BEGIN
     CalcJump(DC_PageNo,DC_PageIndex,DestPageNo,DestIndex,Distance);
     AddWord(CmdLine,DestPageNo); AddByte(CmdLine,DestIndex)
    END
   END; (* WriteJump *)
  
  PROCEDURE DisJump;
   VAR Distance:Integer;
       TrueJump:Boolean;
   BEGIN
    IF GetCmdCode THEN BEGIN
     GetJump(FromDC,TrueJump,Distance);
     IF TrueJump THEN
      CmdLine:=Concat(CmdLine,'TJP')
     ELSE
      CmdLine:=Concat(CmdLine,'FJP');
     CmdLine:=Concat(CmdLine,' ');
     IF Distance=0 THEN
      CmdLine:=Concat(CmdLine,'RTF')
     ELSE IF Distance=1 THEN
      CmdLine:=Concat(CmdLine,'RTT')
     ELSE
      WriteJump(Distance)
    END
   END; (* DisJump *)
  
  PROCEDURE IllegalCmd;
   VAR Mnem:aMaxString;
   BEGIN
    Mnem:='$'; AddByte(Mnem,CmdCode);
    IF Length(CmdLine)=0 THEN
     CmdLine:=' ';
    Insert(Mnem,CmdLine,1);
    NextCouldBeEntryPoint:=true;
    NextShouldBeEntryPoint:=CmdCode=0
   END; (* IllegalCmd *)
  
  PROCEDURE HandleEntryAddress(EntryAddress:Integer);
   VAR PageNo,PageIndex:Integer;
       Error:InternalErrors;
   BEGIN
    WriteCh(CmdLine,'#');
    CalcCallAddress(EntryAddress,PageNo,PageIndex);
    IF IsCodeAddress(PageNo,PageIndex) THEN BEGIN
     SaveEntryPoint(EntryAddress);
    END;
    AddWord(CmdLine,PageNo);
    AddByte(CmdLine,PageIndex);
   END; (* HandleEntryAddress *)
  
  PROCEDURE CheckIfRegList;
   VAR EntryCnt,ListPageNo,ListIndex,
       AddressPageNo,AddressIndex,Value1,Value2,Code:Integer;
       GotRegList,FetchedNext:Boolean;
       Error:InternalErrors;
   BEGIN
    IF IsCodeAddress(DC_PageNo, DC_PageIndex) THEN BEGIN
     GotRegList:=false;
     FetchedNext:=false;
     ListPageNo:=DC_PageNo;
     ListIndex:=DC_PageIndex;
     Code:=GetByteDC;
     IF (Code<16) AND
        (((CodeVersion<='3') AND (ListIndex MOD 2 = 0)) OR
         ((CodeVersion>='4') AND (ListIndex MOD 4 = 0))) THEN BEGIN
      EntryCnt:=Pred(EntryIndex);
      WHILE (EntryCnt>=0) AND NOT GotRegList DO BEGIN
       CalcCallAddress(EntryPoints[EntryCnt],AddressPageNo,AddressIndex);
       Error:=ValidAddress(AddressPageNo,AddressIndex);
       IF (Error=NoError) AND
          (AddressPageNo=ListPageNo) AND (AddressIndex=ListIndex) THEN BEGIN
        GotRegList:=true;
       END ELSE BEGIN
        EntryCnt:=Pred(EntryCnt);
       END;
      END;
      IF NOT GotRegList AND
         (NextCouldBeEntryPoint OR NextShouldBeEntryPoint) THEN BEGIN
       IF CodeVersion<'5' THEN BEGIN
        IF Code=0 THEN BEGIN
         Value1:=GetByteDC; GotRegList:=Value1<>0; FetchedNext:=true
        END ELSE BEGIN
         GotRegList:=NextShouldBeEntryPoint OR
                     (Code IN [1,2,3,7,8,9,20,21,22,23,24,25]);
        END;
        IF NOT GotRegList AND (Code IN [4,5,13,6,14,10,11,12]) THEN BEGIN
         Value1:=GetByteDC; Value2:=GetByteDC; FetchedNext:=true;
         GotRegList:=
          (Code IN [6,14](* OIN,INS *)) AND ((Value1=0) OR (Value2=0)) OR
          (Code IN [4,5,10,11,12,13,17,18,19](* TSF,SEF,CLF,LDP,LPA,LNP *)) AND
           (Value1=0)
        END
       END ELSE BEGIN
        GotRegList:=false;
        IF NextShouldBeEntryPoint THEN BEGIN
          GotRegList:=true;
        END;
       END;
      END
     END;
     IF NOT GotRegList OR FetchedNext THEN BEGIN
      DC_PageIndex:=ListIndex; DC_PageNo:=ListPageNo;
      IF GotRegList THEN BEGIN
       Code:=GetByteDC;
      END;
     END;
     NextCouldBeEntryPoint:=false;
     NextShouldBeEntryPoint:=false;
     IF GotRegList THEN BEGIN
      DisRegList(Code, DisplayListing);
     END;
    END;
   END; (* CheckIfRegList *)
  
  PROCEDURE GetTwoOperands;
   VAR Op5:Integer;
   BEGIN
    Op5:=cOp5(CmdCode);
    IF ((Op5<25) OR (Op5<26) AND (CodeVersion='4') OR
                    (Op5<29) AND (CodeVersion>='5')) AND
       ((Op5<>0) OR InstIsBPT) THEN BEGIN
     WriteCh(CmdLine,' ');
     IF TstBit(CmdCode,6) THEN BEGIN
      DisAddressMode(true,Op5 IN [4,5,13(* DLS,IGT,SEW *)]);
     END ELSE BEGIN
      IF GetCmdCode AND
         (Op5 IN [4,5,13(* DLS,IGT,SEW *)]) THEN BEGIN
       WriteAddressMode(CmdLine, GetByteDC);
      END ELSE IF GetCmdCode AND
                  ((Op5=25(* CFC *)) OR (Op5=26(* CPC *))) THEN BEGIN
       HandleEntryAddress(GetByteDC);
      END ELSE BEGIN
       IF GetCmdCode AND DisWithNames AND
          (Op5 IN [6,10,11,12,14,17,18,19
                   (* OIN,TSF,SEF,CLF,INS,LDP,LPA,LNP *)]) THEN BEGIN
        AddObjName(CmdLine, GetByteDC);
       END ELSE BEGIN
        WriteCh(CmdLine,'#');
        IF GetCmdCode THEN BEGIN
         AddByte(CmdLine, GetByteDC);
        END ELSE BEGIN
         CmdLine:=Concat(CmdLine,'xx');
        END;
       END;
      END;
     END;
     WriteCh(CmdLine,' ');
     IF TstBit(CmdCode,5) THEN BEGIN
      DisAddressMode(true, false);
     END ELSE BEGIN
      IF GetCmdCode AND DisWithNames AND
         (Op5 IN [6,14(* OIN,INS *)]) THEN BEGIN
       AddObjName(CmdLine, GetByteDC);
      END ELSE BEGIN
       WriteCh(CmdLine,'#');
       IF GetCmdCode THEN BEGIN
        AddByte(CmdLine, GetByteDC)
       END ELSE BEGIN
        CmdLine:=Concat(CmdLine,'xx');
       END;
      END;
     END;
     WriteCh(CmdLine,' ')
    END
   END; (* GetTwoOperands *)
  
  PROCEDURE ListTwoOperandOperation;
   VAR Op5:Integer;
       CmdMnem:MnemString;
   BEGIN
    Op5:=cOp5(CmdCode);
    IF (Op5>=29) OR (Op5=0) AND NOT InstIsBPT THEN BEGIN
     IllegalCmd;
    END ELSE BEGIN
     CASE Op5 OF
       8,9,15,16,17,18,19,20,21,22,23,24,25:
       (* LOR,AND,LDW,LDB,LDP,LPA,LNP,ADD,SUB,MUL,DIV,MOD,CFC *)
        DisAddressMode(false,false);
       1,2,3,4,5,6,7,10:
       (* EQU,LES,GRT,DLS,IGT,OIN,TST,LOR,AND,TSF *)
        DisJump;
       OTHERWISE
       ;
     END;
     CASE Op5 OF
       0:CmdMnem:='BPT';
       1:CmdMnem:='EQU';
       2:CmdMnem:='LES';
       3:CmdMnem:='GRT';
       4:CmdMnem:='DLS';
       5:CmdMnem:='IGT';
       6:CmdMnem:='OIN';
       7:CmdMnem:='TST';
       8:CmdMnem:='LOR';
       9:CmdMnem:='AND';
      10:CmdMnem:='TSF';
      11:CmdMnem:='SEF';
      12:CmdMnem:='CLF';
      13:CmdMnem:='SEW';
      14:CmdMnem:='INS';
      15:CmdMnem:='LDW';
      16:CmdMnem:='LDB';
      17:CmdMnem:='LDP';
      18:CmdMnem:='LPA';
      19:CmdMnem:='LNP';
      20:CmdMnem:='ADD';
      21:CmdMnem:='SUB';
      22:CmdMnem:='MUL';
      23:CmdMnem:='DIV';
      24:CmdMnem:='MOD';
      25:CmdMnem:='CFC';
      26:CmdMnem:='CPC';
      27:CmdMnem:='COL';
      28:CmdMnem:='UWI';
      OTHERWISE
       ;
     END;
     IF Length(CmdLine)=0 THEN BEGIN
      CmdLine:=CmdMnem;
     END ELSE BEGIN
      Insert(CmdMnem,CmdLine,1);
     END;
    END;
   END; (* ListTwoOperandOperation *)
  
  PROCEDURE GetOneOperand;
   VAR ImmediateValue,Op4:Integer;
   
   PROCEDURE WriteImmediate(Value,Op4:Integer);
    BEGIN
     IF Op4 IN [5,6,14(* INC,DEC,MVE *)] THEN BEGIN
      WriteAddressMode(CmdLine,Value);
     END ELSE IF (Op4=12(* JMP *)) AND GetCmdCode THEN BEGIN
      WriteJump(Value)
     END ELSE IF GetCmdCode AND
             ((Op4=8(* CFC *)) OR
             (Op4=15(* CPC *)) AND (CodeVersion>='5')) THEN BEGIN
      HandleEntryAddress(Value)
     END ELSE BEGIN
      IF GetCmdCode AND DisWithNames AND
         (Op4 IN [1,2,3,4,9,10(* NXO,FSO,PTO,LPS,RMO,WTO *)]) THEN BEGIN
       AddObjName(CmdLine, Value);
      END ELSE BEGIN
       WriteCh(CmdLine,'#');
       IF GetCmdCode THEN BEGIN
        AddWord(CmdLine,Value)
       END ELSE BEGIN
        CmdLine:=Concat(CmdLine,'xxxx');
       END;
      END;
     END;
    END; (* WriteImmediate *)
   
   BEGIN (* GetOneOperand *)
    Op4:=cOp4(CmdCode); WriteCh(CmdLine,' ');
    CASE cMode(CmdCode) OF
     0:BEGIN
      IF GetCmdCode THEN
       ImmediateValue:=GetWordDC;
      WriteImmediate(ImmediateValue,Op4)
     END;
     1:BEGIN
      IF GetCmdCode THEN
       ImmediateValue:=GetByteDC;
      WriteImmediate(ImmediateValue,Op4)
     END;
     2:
      DisAddressMode(true,Op4 IN [5,6,14(* INC,DEC,MVE *)]);
     OTHERWISE
      ;
    END
   END; (* GetOneOperand *)
  
  PROCEDURE ListOneOperandOperation;
   VAR Op4:Integer;
       CmdMnem:MnemString;
   BEGIN
    Op4:=cOp4(CmdCode); WriteCh(CmdLine,' ');
    IF (Op4 IN [1,2,3,4,8,14] (* NXO,FSO,PTO,LPS,CFC,MVE,NEG *)) OR
       (Op4=15(* NEG *)) AND (CodeVersion<'5') THEN BEGIN
     DisAddressMode(false,false); WriteCh(CmdLine,' ')
    END;
    IF Op4 IN [0,1,2] (* EQN,NXO,FSO *) THEN
     DisJump;
    CASE Op4 OF
      0:CmdMnem:='EQN';
      1:CmdMnem:='NXO';
      2:CmdMnem:='FSO';
      3:CmdMnem:='PTO';
      4:CmdMnem:='LPS';
      5:CmdMnem:='INC';
      6:CmdMnem:='DEC';
      7:CmdMnem:='WSB';
      8:
       IF CodeVersion<'4' THEN BEGIN
        CmdMnem:='$'; AddByte(CmdMnem,CmdCode);
        NextCouldBeEntryPoint:=true
       END ELSE BEGIN
        CmdMnem:='CFC';
       END;
      9:CmdMnem:='RMO';
     10:CmdMnem:='WTO';
     11:BEGIN
      CmdMnem:='RTN';
      NextCouldBeEntryPoint:=true
     END;
     12:BEGIN
      CmdMnem:='JMP';
      NextCouldBeEntryPoint:=true
     END;
     13:CmdMnem:='WT@';
     14:CmdMnem:='MVE';
     15:IF CodeVersion<'5' THEN
         CmdMnem:='NEG'
        ELSE
         CmdMnem:='CPC';
    END;
    Insert(CmdMnem,CmdLine,1)
   END; (* OneOperandOperation *)
  
  PROCEDURE GetMultipleOperands(Extended:Boolean; NewMultiple:Boolean);
   VAR Mode:Integer;
       PureMultiple,ListEnd,Indirect:Boolean;
       MaxOpds,MultiOpdCnt,Value,Op5:Integer;

   PROCEDURE WriteImmediateValueOrCallAddress(IsWord:Boolean);
    BEGIN
     IF Indirect THEN BEGIN
      WriteAddressMode(CmdLine,Value)
     END ELSE IF PureMultiple AND
             ((MultiOpdCnt=3) AND ((Op5=0) OR (Op5=25)) OR
              (MultiOpdCnt=7) AND ((Op5=12) OR (Op5=26)) OR
              (MultiOpdCnt=1) AND (Op5=22)) OR
             NOT PureMultiple AND
             ((MultiOpdCnt=3) AND ((Op5=25) OR (Op5=26))) THEN BEGIN
      HandleEntryAddress(Value)
     END ELSE BEGIN
      IF DisWithNames AND
         ((MultiOpdCnt=MaxOpds-1) AND
          (NOT PureMultiple AND NOT NewMultiple AND
           (Op5 IN [6,14(* OIN,INS *)])) OR
          (MultiOpdCnt=MaxOpds) AND
          (NOT PureMultiple AND NOT NewMultiple AND
           (Op5 IN [6,10,11,12,14,17,18,19
                   (* OIN,TSF,SEF,CLF,INS,LDP,LPA,LNP *)]) OR
           PureMultiple AND NOT NewMultiple AND
           (Op5 IN [3(* STP *)]))) THEN BEGIN
       AddObjName(CmdLine, Value);
      END ELSE BEGIN
       WriteCh(CmdLine,'#');
       IF IsWord THEN BEGIN
        AddWord(CmdLine,Value);
       END ELSE BEGIN
        AddByte(CmdLine,Value);
       END;
      END;
     END;
    END; (* WriteImmediateValueOrCallAddress *)

   BEGIN (* GetMultipleOperands *)
    Op5:=cOp5(CmdCode);
    PureMultiple:=NewMultiple OR (CmdCode>=224(* $E0 *));
    IF Extended THEN BEGIN
     Mode:=GetWordDC; MaxOpds:=7
    END ELSE BEGIN
     Mode:=GetByteDC; MaxOpds:=3
    END;
    MultiOpdCnt:=MaxOpds;
    ListEnd:=false; WriteCh(CmdLine,' ');
    WHILE NOT ListEnd DO BEGIN
     Indirect:=(MultiOpdCnt=MaxOpds) AND
               ((CmdCode=233(* PUL *)) OR
                (NOT PureMultiple AND (Op5 IN [4,5,13(* DLS,IGT,SEW *)])));
     CASE Bittle(Mode,MultiOpdCnt) OF
      0:BEGIN
       Value:=GetWordDC;
       WriteImmediateValueOrCallAddress(true);
      END;
      1:BEGIN
       Value:=GetByteDC;
       WriteImmediateValueOrCallAddress(false);
      END;
      2:
       DisAddressMode(true,Indirect);
      3:
       ListEnd:=true
     END;
     IF NOT ListEnd THEN BEGIN
      WriteCh(CmdLine,' ');
      IF MultiOpdCnt>0 THEN
       MultiOpdCnt:=Pred(MultiOpdCnt)
      ELSE
       ListEnd:=true
     END
    END;
   END; (* GetMultipleOperands *)
  
  PROCEDURE ListMultipleOperandOperation(NewVersion:Boolean);
   VAR Op5:Integer;
       CmdMnem:MnemString;
   BEGIN
    Op5:=cOp5(CmdCode);
    IF (Op5>=12) AND (CodeVersion<'4') OR
       (Op5>=24) AND (CodeVersion<'5') THEN BEGIN
     IllegalCmd;
    END ELSE BEGIN
     IF (Op5 IN [0,7,12,22,23(* CFC,RND,CFC,INK,BEQ *)]) OR
        ((CodeVersion>='5') AND
         ((Op5=4(* INP *)) OR (Op5=24(* NEG *)))) OR
        ((CodeVersion>='6') AND (Op5=9(* PUL *))) THEN BEGIN
      DisAddressMode(false,false);
     END;
     IF Op5=23 THEN BEGIN
      WriteCh(CmdLine,' '); DisJump
     END;
     IF Op5=31 THEN
      DisJump;
     CASE Op5 OF
       0:CmdMnem:='CFC';
       1:CmdMnem:='STW';
       2:CmdMnem:='STB';
       3:CmdMnem:='STP';
       4:CmdMnem:='INP';
       5:CmdMnem:='WTC';
       6:CmdMnem:='WTI';
       7:CmdMnem:='RND';
       8:CmdMnem:='PSH';
       9:CmdMnem:='PUL';
      10:CmdMnem:='SPL';
      11:CmdMnem:='WND';
      12:CmdMnem:='CFC';
      13:CmdMnem:='ERS';
      14:CmdMnem:='ERL';
      15:CmdMnem:='GYX';
      16:CmdMnem:='NO2';
      17:CmdMnem:='SCM';
      18:CmdMnem:='FRM';
      19:CmdMnem:='OUT';
      20:CmdMnem:='PLY';
      21:CmdMnem:='SND';
      22:CmdMnem:='INK';
      23:CmdMnem:='BEQ';
      24:CmdMnem:='NEG';
      25:CmdMnem:='CPC';
      26:CmdMnem:='CPC';
      27:CmdMnem:='PRS';
      28:CmdMnem:='PAK';
      29:CmdMnem:='BCP';
      30:CmdMnem:='WTA';
      31:CmdMnem:='MNP'
     END;
     Insert(CmdMnem,CmdLine,1)
    END
   END; (* ListMultipleOperandOperation *)
  
  PROCEDURE ListNewMultipleOperandOperation;
   VAR CmdMnem:MnemString;
   BEGIN
    IF CmdCode>=29 THEN BEGIN
     IllegalCmd;
    END ELSE BEGIN
     IF CmdCode IN [0,1,2,3,4,9,10,19
                    (* SVE,RSE,LSH,ASH,FNT,UDS,UDR,X19 *)] THEN BEGIN
      DisAddressMode(false,false);
     END;
     IF CmdCode IN [6,24 (* TSB,X24 *)] THEN BEGIN
      DisJump;
     END;
     CASE CmdCode OF
       0:CmdMnem:='SVE';
       1:CmdMnem:='RSE';
       2:CmdMnem:='LSH';
       3:CmdMnem:='ASH';
       4:CmdMnem:='FNT';
       5:CmdMnem:='CLR';
       6:CmdMnem:='TSB';
       7:CmdMnem:='SET';
       8:CmdMnem:='SWD';
       9:CmdMnem:='UDS';
      10:CmdMnem:='UDR';
      11:CmdMnem:='X11';
      12:CmdMnem:='X12';
      13:CmdMnem:='X13';
      14:CmdMnem:='X14';
      15:CmdMnem:='X15';
      16:CmdMnem:='X16';
      17:CmdMnem:='X17';
      18:CmdMnem:='X18';
      19:CmdMnem:='X19';
      20:CmdMnem:='X20';
      21:CmdMnem:='X21';
      22:CmdMnem:='X22';
      23:CmdMnem:='MWD';
      24:CmdMnem:='X24';
      25:CmdMnem:='X25';
      26:CmdMnem:='X26';
      27:CmdMnem:='X27';
      28:CmdMnem:='X28';
      OTHERWISE
       ;
     END;
     IF Length(CmdMnem)>0 THEN
      Insert(CmdMnem,CmdLine,1)
    END
   END; (* ListNewMultipleOperandOperation *)
  
  PROCEDURE ListNoOperandOperation;
   LABEL 0;
   VAR CmdMnem:MnemString;
       Op4:Integer;
   BEGIN
    Op4:=cOp4(CmdCode);
    IF (Op4>=14) AND (CodeVersion<'5') THEN
     IllegalCmd
    ELSE BEGIN
     IF Op4 IN [5,6,13,15 (* SVE,RSO,VFY,jmpop *)] THEN BEGIN
      IF Op4<>15 THEN
       WriteCh(CmdLine,' ');
      IF (CodeVersion<'4') OR
         (Op4=15(* jmpop *)) OR (Op4=13(* VFY *)) THEN BEGIN
       DisJump;
      END ELSE BEGIN
       DisAddressMode(false,false);
      END;
     END;
     DumpText:=(Op4 IN [2,3]) AND GetCmdCode;
     CASE Op4 OF
       0:BEGIN
        CmdMnem:='RTT'; NextCouldBeEntryPoint:=true
       END;
       1:BEGIN
        CmdMnem:='RTF'; NextCouldBeEntryPoint:=true
       END;
       2:CmdMnem:='WTX';
       3:BEGIN
        CmdMnem:='WTR'; NextCouldBeEntryPoint:=true
       END;
       4:CmdMnem:='NOP';
       5:CmdMnem:='SVE';
       6:CmdMnem:='RSO';
       7:CmdMnem:='RST';
       8:BEGIN
        CmdMnem:='RPL'; NextCouldBeEntryPoint:=true
       END;
       9:IF CodeVersion<'5' THEN
          CmdMnem:='DSC'
         ELSE
          CmdMnem:='MSP';
      10:CmdMnem:='END';
      11:CmdMnem:='NWL';
      12:CmdMnem:='PSL';
      13:CmdMnem:='VFY';
      14:BEGIN
       IF GetCmdCode THEN BEGIN
        CmdCode:=GetByteDC;
        GetMultipleOperands(false, true);
        IF CmdCode>=224(* $E0 *) THEN BEGIN
         ListMultipleOperandOperation(true);
        END ELSE IF CmdCode<192(* $C0 *) THEN BEGIN
         ListNewMultipleOperandOperation;
        END ELSE BEGIN
         ListTwoOperandOperation;
        END;
        GOTO 0
       END
       ELSE
        CmdMnem:='EXS'
      END;
      15:BEGIN
       CmdMnem:=''; NextCouldBeEntryPoint:=true
      END;
     END;
     IF Length(CmdLine)=0 THEN
      CmdLine:=' ';
     Insert(CmdMnem,CmdLine,1)
    END;
 0:END; (* ListNoOperandOperation *)
  
  BEGIN (* Disassemble *)
   ChkAddresses:=false;
   IF (DC_PageNo<>OldPageNo) OR (DC_PageIndex<>OldIndex) THEN BEGIN
    BackPageNo:=OldPageNo; BackIndex:=OldIndex;
    OldPageNo:=DC_PageNo; OldIndex:=DC_PageIndex
   END;
   LineCnt:=0;
   InstIsBPT:=false;
   NextCouldBeEntryPoint:=true;
   WHILE (LineCnt<NumLines) AND (EndPageNo<0) OR
         (DC_PageNo<=EndPageNo) AND
         ((DC_PageNo<>EndPageNo) OR (DC_PageIndex<=EndPageIndex)) DO BEGIN
    IF GetCmdCode THEN BEGIN
     DisInstPageNo:=DC_PageNo; DisInstPageIndex:=DC_PageIndex;
     CmdCode:=GetByteDC;
     IF CmdCode=0 THEN BEGIN
      BPT_No:=GetByteDC;
      IF BPT_No>0 THEN BEGIN
       BPT_Type:=GetByteDC;
       IF Ord(BPT_Type) IN [Ord(UserBPT),Ord(RunBPT),Ord(TraceBPT)] THEN BEGIN
        WrkBPT:=BPT_List;
        WHILE WrkBPT<>Nil DO BEGIN
         IF WrkBPT^.BPT_No=BPT_No THEN
          GOTO 1;
         WrkBPT:=WrkBPT^.NextBPT
        END;
1:      InstIsBPT:=WrkBPT<>Nil;
        IF InstIsBPT AND NOT DisBPTs THEN
         PutOrgCode(WrkBPT)
       END
      END
     END;
     DC_PageIndex:=DisInstPageIndex; DC_PageNo:=DisInstPageNo;
     IF TryRegList THEN BEGIN
      CheckIfRegList;
     END;
    END;
    DumpCnt:=0;
    CmdLine:='';
    Dump:='';
    DumpText:=false;
    IF GetCmdCode THEN BEGIN
     Dump:='C'; WriteCh(Dump,' ');
     AddWord(Dump,DC_PageNo);
     AddByte(Dump,DC_PageIndex);
     WriteCh(Dump,':');
     CmdCode:=GetByteDC;
    END;
    IF CmdCode<128(* $80 *) THEN BEGIN
     GetTwoOperands; ListTwoOperandOperation
    END ELSE IF CmdCode<176(* $B0 *) THEN BEGIN
     GetOneOperand; ListOneOperandOperation
    END ELSE IF CmdCode<192(* $C0 *) THEN
     ListNoOperandOperation
    ELSE BEGIN
     IF GetCmdCode THEN BEGIN
      GetMultipleOperands((CmdCode=236(* $EC, extended CFC *)) OR
                          (CmdCode=250(* $FA, extended CPC *)) , false);
     END ELSE BEGIN
      CmdLine:=Concat(CmdLine,' multiple ');
     END;
     IF CmdCode<224(* $E0 *) THEN BEGIN
      ListTwoOperandOperation;
     END ELSE BEGIN
      ListMultipleOperandOperation(false);
     END;
    END;
    IF InstIsBPT AND NOT DisBPTs THEN BEGIN
     PutBPTCode(WrkBPT); Dump[2]:='-'; InstIsBPT:=false
    END;
    IF DisplayListing THEN BEGIN
     IF GetCmdCode THEN BEGIN
      PrintString(Dump);
      FOR SpaceCnt:=1 TO (12-DumpCnt)*3 DO BEGIN
       PrintCh(' ');
      END;
      PrintString(CmdLine)
     END ELSE BEGIN
      PrintString(CmdLine);
      LineCnt:=1;
     END;
     ChkWait;
    END;
    IF DumpText THEN BEGIN
     IF DisplayListing THEN BEGIN
      WriteText('T',OntoScreen,FromDC,GlobalTextBuffer,0);
     END ELSE BEGIN
      WriteText('T',IntoSink,FromDC,GlobalTextBuffer,0);
     END;
    END;
   END;
  END; (* Disassemble *)
 
 PROCEDURE PrintReg(RegNo:Integer);
  VAR RegName:aMaxString;
  BEGIN
   RegName:='R*='; RegName[2]:=HexChars[Succ(RegNo)];
   PrintString(RegName); PrintWord(R.a[RegNo],4)
  END; (* PrintReg *)
 
 PROCEDURE SaveCursorState;
  BEGIN
   IF InStory THEN BEGIN
    StoryCursorX:=CursorX; StoryCursorY:=CursorY;
    SaveTextAttributes;
    ScreenMode:=0; SetScreenMode; StoryScrollTop:=ScrollTop;
    IF ActiveWindow>=0 THEN BEGIN
     IF ScrollTop=ScreenHeight THEN
      ScrollTop:=ScreenHeight-5;
     ZM_GotoXY(1,ScreenHeight)
    END
   END;
   InStory:=false
  END; (* SaveCursorState *)
 
 PROCEDURE RestoreCursorState;
  BEGIN
   InStory:=true;
   RestoreTextAttributes; ScrollTop:=StoryScrollTop;
   IF ActiveWindow>=0 THEN BEGIN
    CursorX:=StoryCursorX; CursorY:=StoryCursorY; PositionCursor
   END;
  END; (* RestoreCursorState *)
 
 PROCEDURE PrintZState;
  VAR RegCnt,StackCnt:Integer;
  BEGIN
   SaveCursorState;
   PrintString('IPC='); PrintWord(IPC_PageNo,4); PrintByte(IPC_PageIndex,2);
   PrintString(' SP='); PrintWord(SP,4);
   PrintString(' MSP='); PrintWord(MSP,4);
   PrintString(' TOS=');
   FOR StackCnt:=1 TO 9 DO BEGIN
    IF SP>=StackCnt THEN
     PrintWord(Stack[SP-StackCnt],4)
    ELSE
     PrintString('----');
    PrintCh(' ')
   END;
   ChkWait;
   FOR RegCnt:=0 TO 15 DO BEGIN
    IF RegCnt=8 THEN
     ChkWait;
    PrintReg(RegCnt); PrintCh(' ')
   END;
   ChkWait
  END; (* PrintZState *)
 
 PROCEDURE SetInterpreterConfiguration;
  VAR Wrk:Integer;
      H:RECORD CASE Boolean OF
       true:(mp:^tMiscInfo);
       false:(pp:PtrPage);
      END;
  BEGIN
   H.pp:=PagePtrs[0];
   H.mp^.mInterpreterNumber:=Ord(CodeVersion)-Ord('0');
   H.mp^.mInterpreterVersion:=Ord(InterpreterChar)-Ord('a')+Ord('A');
   H.mp^.ScreenWidth:=ScreenWidth;
   H.mp^.ScreenHeight:=ScreenHeight - 1;
   H.mp^.Left:=0;
   H.mp^.Right:=ScreenWidth;
   H.mp^.Top:=0;
   H.mp^.Bottom:=ScreenHeight - 1;
   H.mp^.Unknown1:=1;
   H.mp^.Unknown2:=1;
   H.mp^.Unknown3:=9;
   H.mp^.Unknown4:=2;
   Wrk:=ExpandByte(MiscInfo.ConfigFlags);
   SetBit(Wrk,4); SetBit(Wrk,5);
   H.mp^.ConfigFlags:=Wrk;
   MiscInfo.ConfigFlags:=Wrk
  END; (* SetInterpreterConfiguration *)
 
 PROCEDURE RemoveObj(ObjNo:Integer);
  VAR ObjPageNo,ObjPageIndex,ParentObj,FirstObj,WrkObj,ParentPageNo,ParentPageIndex,
      PrevObj,PrevPageNo,PrevPageIndex:Integer;
      LowByte,HighByte:Integer;
  BEGIN
   IF CodeVersion<'4' THEN BEGIN
    CalcObjAdrs(ObjNo, ObjPageNo, ObjPageIndex, 4, true);
    ParentObj:=ExpandByte(PagePtrs[ObjPageNo]^[ObjPageIndex])
   END ELSE BEGIN
    CalcObjAdrs(ObjNo, ObjPageNo, ObjPageIndex, 6, true);
    HighByte:=ExpandByte(PagePtrs[ObjPageNo]^[ObjPageIndex]);
    Inc(ObjPageNo,ObjPageIndex,1);
    LowByte:=ExpandByte(PagePtrs[ObjPageNo]^[ObjPageIndex]);
    ParentObj:=JoinBytes(LowByte,HighByte)
   END;
   IF ParentObj<>0 THEN BEGIN
    IF CodeVersion<'4' THEN BEGIN
     CalcObjAdrs(ParentObj, ParentPageNo, ParentPageIndex, 6, true);
     FirstObj:=
      ExpandByte(PagePtrs[ParentPageNo]^[ParentPageIndex]); (* PTO.FSO *)
    END ELSE BEGIN
     CalcObjAdrs(ParentObj, ParentPageNo, ParentPageIndex, 10, true);
     HighByte:=ExpandByte(PagePtrs[ParentPageNo]^[ParentPageIndex]);
     Inc(ParentPageNo,ParentPageIndex,1);
     LowByte:=ExpandByte(PagePtrs[ParentPageNo]^[ParentPageIndex]);
     FirstObj:=JoinBytes(LowByte,HighByte);
    END;
    IF FirstObj=ObjNo THEN BEGIN
     Inc(ObjPageNo,ObjPageIndex,1);
     (* PTO.FSO:=OBJ.NXO *)
     IF CodeVersion<'4'THEN BEGIN
      PagePtrs[ParentPageNo]^[ParentPageIndex]:=
       PagePtrs[ObjPageNo]^[ObjPageIndex];
     END ELSE BEGIN
      AccB:=PagePtrs[ObjPageNo]^[ObjPageIndex];
      Inc(ObjPageNo,ObjPageIndex,1);
      PagePtrs[ParentPageNo]^[ParentPageIndex]:=
       PagePtrs[ObjPageNo]^[ObjPageIndex];
      Inc(ParentPageNo,ParentPageIndex,-1);
      PagePtrs[ParentPageNo]^[ParentPageIndex]:=AccB;
     END;
    END ELSE BEGIN
     WrkObj:=FirstObj;
     REPEAT
      PrevObj:=WrkObj;
      (* WrkObj:=PrevObj.NXO *)
      IF CodeVersion<'4' THEN BEGIN
       CalcObjAdrs(PrevObj, PrevPageNo, PrevPageIndex, 5, true);
       WrkObj:=ExpandByte(PagePtrs[PrevPageNo]^[PrevPageIndex]);
      END ELSE BEGIN
       CalcObjAdrs(PrevObj, PrevPageNo, PrevPageIndex, 8, true);
       HighByte:=ExpandByte(PagePtrs[PrevPageNo]^[PrevPageIndex]);
       Inc(PrevPageNo,PrevPageIndex,1);
       LowByte:=ExpandByte(PagePtrs[PrevPageNo]^[PrevPageIndex]);
       WrkObj:=JoinBytes(LowByte,HighByte);
      END;
     UNTIL WrkObj=ObjNo;
     Inc(ObjPageNo,ObjPageIndex,1);
     (* PrevObj.NXO:=OBJ.NXO *)
     IF CodeVersion<'4' THEN BEGIN
      PagePtrs[PrevPageNo]^[PrevPageIndex]:=
       PagePtrs[ObjPageNo]^[ObjPageIndex];
     END ELSE BEGIN
      AccB:=PagePtrs[ObjPageNo]^[ObjPageIndex];
      Inc(ObjPageNo,ObjPageIndex,1);
      PagePtrs[PrevPageNo]^[PrevPageIndex]:=
       PagePtrs[ObjPageNo]^[ObjPageIndex];
      Inc(PrevPageNo,PrevPageIndex,-1);
      PagePtrs[PrevPageNo]^[PrevPageIndex]:=AccB;
     END;
    END;
    (* OBJ.NXO:=0 *)
    (* OBJ.PTO:=0 *)
    PagePtrs[ObjPageNo]^[ObjPageIndex]:=0;
    Inc(ObjPageNo,ObjPageIndex,-1);
    PagePtrs[ObjPageNo]^[ObjPageIndex]:=0;
    IF CodeVersion>='4' THEN BEGIN
     Inc(ObjPageNo,ObjPageIndex,-1);
     PagePtrs[ObjPageNo]^[ObjPageIndex]:=0;
     Inc(ObjPageNo,ObjPageIndex,-1);
     PagePtrs[ObjPageNo]^[ObjPageIndex]:=0;
    END;
   END;
  END; (* RemoveObj *)
 
 PROCEDURE InsertObj(ObjNo,IntoObjNo:Integer);
  VAR ObjPageNo,ObjPageIndex,IntoPageNo,IntoPageIndex,Next:Integer;
      LowByte,HighByte:Integer;
  BEGIN
   RemoveObj(ObjNo);
   IF CodeVersion<'4' THEN BEGIN
    CalcObjAdrs(ObjNo, ObjPageNo, ObjPageIndex, 4, true);
    (* ObjNo.PTO:=IntoObjNo *)
    PagePtrs[ObjPageNo]^[ObjPageIndex]:=IntoObjNo;
    CalcObjAdrs(IntoObjNo, IntoPageNo, IntoPageIndex, 6, true);
    (* ObjNo.NXO:=PTO.FSO *)
    (* PTO.FSO:=ObjNo *)
    Inc(ObjPageNo,ObjPageIndex,1);
    Next:=PagePtrs[IntoPageNo]^[IntoPageIndex];
    PagePtrs[IntoPageNo]^[IntoPageIndex]:=ObjNo;
    PagePtrs[ObjPageNo]^[ObjPageIndex]:=Next;
   END ELSE BEGIN
    CalcObjAdrs(ObjNo, ObjPageNo, ObjPageIndex, 6, true);
    SplitWord(IntoObjNo,LowByte,HighByte);
    PagePtrs[ObjPageNo]^[ObjPageIndex]:=HighByte;
    Inc(ObjPageNo,ObjPageIndex,1);
    PagePtrs[ObjPageNo]^[ObjPageIndex]:=LowByte;
    CalcObjAdrs(IntoObjNo, IntoPageNo, IntoPageIndex, 10, true);
    Inc(ObjPageNo,ObjPageIndex,1);
    SplitWord(ObjNo,LowByte,HighByte);
    Next:=PagePtrs[IntoPageNo]^[IntoPageIndex];
    PagePtrs[IntoPageNo]^[IntoPageIndex]:=HighByte;
    PagePtrs[ObjPageNo]^[ObjPageIndex]:=Next;
    Inc(IntoPageNo,IntoPageIndex,1);
    Inc(ObjPageNo,ObjPageIndex,1);
    Next:=PagePtrs[IntoPageNo]^[IntoPageIndex];
    PagePtrs[IntoPageNo]^[IntoPageIndex]:=LowByte;
    PagePtrs[ObjPageNo]^[ObjPageIndex]:=Next;
   END;
  END; (* InsertObj *)
 
 FUNCTION ObjInObj(ObjNo,InObjNo:Integer):Boolean;
  VAR ObjPageNo,ObjPageIndex,ParentObj:Integer;
      LowByte,HighByte:Integer;
  BEGIN
   IF CodeVersion<'4' THEN BEGIN
    CalcObjAdrs(ObjNo, ObjPageNo, ObjPageIndex, 4, true);
    ParentObj:=ExpandByte(PagePtrs[ObjPageNo]^[ObjPageIndex]);
   END ELSE BEGIN
    CalcObjAdrs(ObjNo, ObjPageNo, ObjPageIndex, 6, true);
    HighByte:=ExpandByte(PagePtrs[ObjPageNo]^[ObjPageIndex]);
    Inc(ObjPageNo,ObjPageIndex,1);
    LowByte:=ExpandByte(PagePtrs[ObjPageNo]^[ObjPageIndex]);
    ParentObj:=JoinBytes(LowByte,HighByte);
   END;
   ObjInObj:=ParentObj=InObjNo;
  END; (* ObjInObj *)
 
 FUNCTION TestFlag(ObjNo,FlagNo:Integer):Boolean;
  VAR ObjPageNo,ObjPageIndex:Integer;
      FlagsHigh,FlagsLow:Integer;
  BEGIN
   CalcObjAdrs(ObjNo, ObjPageNo, ObjPageIndex,
    2*(FlagNo DIV 16), true);
   FlagsHigh:=ExpandByte(PagePtrs[ObjPageNo]^[ObjPageIndex]);
   Inc(ObjPageNo,ObjPageIndex,1);
   FlagsLow:=ExpandByte(PagePtrs[ObjPageNo]^[ObjPageIndex]);
   TestFlag:=TstBit(JoinBytes(FlagsLow,FlagsHigh),15-FlagNo MOD 16)
  END; (* TestFlag *)
 
 PROCEDURE SetFlag(ObjNo,FlagNo:Integer; Value:Boolean);
  VAR ObjPageNo,ObjPageIndex,HighPageNo,HighPageIndex:Integer;
      Flags,FlagsLow,FlagsHigh:Integer;
  BEGIN
   CalcObjAdrs(ObjNo, ObjPageNo, ObjPageIndex,
    2*(FlagNo DIV 16), true);
   FlagsHigh:=ExpandByte(PagePtrs[ObjPageNo]^[ObjPageIndex]);
   HighPageNo:=ObjPageNo; HighPageIndex:=ObjPageIndex;
   Inc(ObjPageNo,ObjPageIndex,1);
   FlagsLow:=ExpandByte(PagePtrs[ObjPageNo]^[ObjPageIndex]);
   Flags:=JoinBytes(FlagsLow,FlagsHigh);
   IF Value THEN
    SetBit(Flags,15-FlagNo MOD 16)
   ELSE
    ClrBit(Flags,15-FlagNo MOD 16);
   SplitWord(Flags,FlagsLow,FlagsHigh);
   PagePtrs[ObjPageNo]^[ObjPageIndex]:=FlagsLow;
   PagePtrs[HighPageNo]^[HighPageIndex]:=FlagsHigh
  END; (* SetFlag *)
 
 FUNCTION GetWord(GetMode:Integer):Integer;
  VAR DataPageNo,DataPageIndex:Integer;
      LowByte,HighByte:Integer;
  BEGIN
   IF GetMode=0 THEN BEGIN
    GetWord:=Pop;
   END ELSE IF GetMode<16 THEN BEGIN
    GetWord:=R.a[Pred(GetMode)];
   END ELSE BEGIN
    DataPageIndex:=ExpandByte(MiscInfo.DataPageIndex)+2*(GetMode-16);
    DataPageNo:=ExpandByte(MiscInfo.DataPageNo);
    ChkAddress(DataPageNo,DataPageIndex);
    HighByte:=ExpandByte(PagePtrs[DataPageNo]^[DataPageIndex]);
    DataPageIndex:=Succ(DataPageIndex);
    IF DataPageIndex>=256 THEN BEGIN
     DataPageIndex:=0; DataPageNo:=Succ(DataPageNo)
    END;
    LowByte:=ExpandByte(PagePtrs[DataPageNo]^[DataPageIndex]);
    GetWord:=JoinBytes(LowByte,HighByte)
   END
  END; (* GetWord *)
 
 PROCEDURE PutWord(theWord:Integer; PutMode:Integer);
  VAR DataPageNo,DataPageIndex:Integer;
      LowByte,HighByte:Integer;
  BEGIN
   IF PutMode=0 THEN BEGIN
    Push(theWord);
   END ELSE IF PutMode<16 THEN BEGIN
    R.a[Pred(PutMode)]:=theWord;
   END ELSE BEGIN
    DataPageIndex:=ExpandByte(MiscInfo.DataPageIndex)+2*(PutMode-16);
    DataPageNo:=ExpandByte(MiscInfo.DataPageNo);
    ChkAddress(DataPageNo,DataPageIndex);
    SplitWord(theWord,LowByte,HighByte);
    PagePtrs[DataPageNo]^[DataPageIndex]:=HighByte;
    DataPageIndex:=Succ(DataPageIndex);
    IF DataPageIndex>=256 THEN BEGIN
     DataPageIndex:=0; DataPageNo:=Succ(DataPageNo)
    END;
    PagePtrs[DataPageNo]^[DataPageIndex]:=LowByte
   END
  END; (* PutWord *)
 
 PROCEDURE GetAccA(GetMode:Integer);
  BEGIN
   AccA:=GetWord(GetMode);
   IF GetMode=0 THEN BEGIN
    Push(AccA)
   END;
  END; (* GetAccA *)
 
 PROCEDURE PutAccA(PutMode:Integer);
  VAR Discard:Integer;
  BEGIN
   IF PutMode=0 THEN BEGIN
    Discard:=Pop;
   END;
   PutWord(AccA, PutMode);
  END; (* PutAccA *)
 
 PROCEDURE PrintStatusLine;
  VAR RoomObjNo,ScoreOrHour,TotalOrMinute:Integer;
      NamePageNo,NamePageIndex:Integer;
      NameLength:Integer;
      OldCursorX,OldCursorY:Integer;
      OldPrintListing:Boolean;
      RoomName:aMaxString;
  BEGIN
   IF CodeVersion<'4' THEN BEGIN
    OldPrintListing:=PrintListing; PrintListing:=false;
    SaveTextAttributes; ScreenMode:=1; SetScreenMode;
    OldCursorX:=CursorX; OldCursorY:=CursorY;
    GotoXY(0,0); SetLength(Spaces,ScreenWidth); PrintString(Spaces);
    RoomObjNo:=GetWord(16);
    ScoreOrHour:=GetWord(17);
    TotalOrMinute:=GetWord(18);
    CalcObjNameAdrs(RoomObjNo, NamePageNo, NamePageIndex, NameLength);
    IF (NameLength>0) THEN BEGIN
     Push(DC_PageNo); Push(DC_PageIndex);
     DC_PageNo:=NamePageNo; DC_PageIndex:=NamePageIndex;
     WriteText('N',IntoBuffer,FromDC,RoomName,SizeOf(RoomName)-1);
     DC_PageIndex:=Pop; DC_PageNo:=Pop;
    END ELSE BEGIN
     RoomName:='<illegal>';
    END;
    GotoXY(1,0); PrintString(RoomName); GotoXY(ScreenWidth-20,0);
    IF TstBit(ExpandByte(MiscInfo.ConfigFlags),1) THEN BEGIN
     PrintString('Time:'); PrintCh(' ');
     IF ScoreOrHour=0 THEN
      PrintString('12')
     ELSE IF ScoreOrHour>12 THEN
      PrintInteger(ScoreOrHour-12)
     ELSE
      PrintInteger(ScoreOrHour);
     PrintCh(':');
     IF TotalOrMinute<10 THEN
      PrintCh('0');
     PrintInteger(TotalOrMinute);
     IF ScoreOrHour<12 THEN
      PrintString('am')
     ELSE
      PrintString('pm')
    END ELSE BEGIN
     PrintString('Score:');
     PrintCh(' ');
     PrintInteger(ScoreOrHour);
     PrintCh('/');
     PrintInteger(TotalOrMinute);
    END;
    RestoreTextAttributes; PrintListing:=OldPrintListing;
    CursorX:=OldCursorX; CursorY:=OldCursorY; PositionCursor
   END
  END; (* PrintStatusLine *)
 
 FUNCTION GetPropertyNo(ObjDataPageNo,ObjDataPageIndex:Integer):Integer;
  BEGIN
   IF CodeVersion<'4' THEN
    GetPropertyNo:=land(ExpandByte(PagePtrs[ObjDataPageNo]^[ObjDataPageIndex]),31)
   ELSE
    GetPropertyNo:=land(ExpandByte(PagePtrs[ObjDataPageNo]^[ObjDataPageIndex]),63)
  END; (* GetPropertyNo *)
 
 FUNCTION GetPropertySize(VAR ObjDataPageNo,ObjDataPageIndex:Integer;
                      FetchNext:Boolean):Integer;
  VAR Data:Integer;
  BEGIN
   Data:=ExpandByte(PagePtrs[ObjDataPageNo]^[ObjDataPageIndex]);
   IF CodeVersion<'4' THEN
    GetPropertySize:=Succ(land(lsr(Data,5),7))
   ELSE BEGIN
    IF TstBit(Data,7) THEN BEGIN
     IF FetchNext THEN
      Inc(ObjDataPageNo,ObjDataPageIndex,1);
     GetPropertySize:=
      land(ExpandByte(PagePtrs[ObjDataPageNo]^[ObjDataPageIndex]),63)
    END
    ELSE BEGIN
     IF TstBit(Data,6) THEN
      GetPropertySize:=2
     ELSE
      GetPropertySize:=1
    END
   END
  END; (* GetPropertySize *)
 
 FUNCTION DoGetWord:Integer;
  BEGIN
   DoGetWord:=GetWord(GetByteIPC);
  END; (* DoGetWord *)

 PROCEDURE DoPutWord(theWord:Integer);
  BEGIN
   PutWord(theWord, GetByteIPC);
  END; (* DoPutWord *)

 PROCEDURE Call(Address:Integer; IsFunc:Boolean; NumParams:Integer);
  VAR LowByte,HighByte:Integer;
      CallPageNo,CallPageIndex,NumLocalVariables,RegCnt:Integer;
  BEGIN
   IF Address=0 THEN BEGIN
    IF IsFunc THEN BEGIN
     DoPutWord(0);
    END
   END ELSE BEGIN
    Push(MSP); Push(NewInstPageNo); Push(NewInstPageIndex);
    LowByte:=IPC_PageIndex; HighByte:=Ord(IsFunc);
    Push(JoinBytes(LowByte,HighByte));
    Push(IPC_PageNo);
    CalcCallAddress(Address,CallPageNo,CallPageIndex);
    ChkAddress(CallPageNo,CallPageIndex);
    IPC_PageIndex:=CallPageIndex;
    IPC_PageNo:=CallPageNo;
    NumLocalVariables:=GetByteIPC;
    IF NumLocalVariables>15 THEN BEGIN
      InternalError(TooManyLocalVariables);
    END;
    FOR RegCnt:=0 TO Pred(NumLocalVariables) DO BEGIN
     Push(R.a[RegCnt]);
     IF CodeVersion<='4' THEN BEGIN
      R.a[RegCnt]:=GetWordIPC;
     END ELSE BEGIN
      R.a[RegCnt]:=0;
     END;
    END;
    Push(NumCallParams);
    NumCallParams:=NumParams;
    IF CodeVersion>='4' THEN BEGIN
     IF NumCallParams>NumLocalVariables THEN BEGIN
      InternalError(TooManyParameters);
     END;
    END;
    FOR RegCnt:=0 TO Pred(NumCallParams) DO BEGIN
     R.a[RegCnt]:=Opd.a[Succ(RegCnt)];
    END;
    Push(NumLocalVariables);
    MSP:=SP
   END
  END; (* Call *)
 
 PROCEDURE ResetZMachine;
  VAR RegCnt:Integer;
  BEGIN
   SP:=0; MSP:=0; NumCallParams:=0;
   CalcStartAddress(IPC_PageNo, IPC_PageIndex);
   IF CodeVersion>='6' THEN BEGIN
    Inc(IPC_PageNo, IPC_PageIndex, 1);
   END;
   StoryScreenMode:=0;
   ScreenMode:=0; FormatMode:=0;
   Playback:=false; Recording:=false;
   OutputMode:=0;
   ScreenEnabled:=true; BufferEnabled:=false;
   DirectEnabled:=false; ActiveWindow:=false; WritingInWindow:=false;
   BufferPageNo:=-1; BufferPageIndex:=-1; BufferIndex:=0;
   LineIndex:=0;
   ScrollTop:=1+Ord(CodeVersion<='3');
   StoryScrollTop:=ScrollTop;
   LineNo:=ScrollTop;
   SetInterpreterConfiguration;
   FOR RegCnt:=0 TO 15 DO
    R.a[RegCnt]:=0;
  END; (* ResetZMachine *)
 
 PROCEDURE ExecuteSingleInstruction;
  
  PROCEDURE ExecuteOrgCode(WrkBPT:PtrBPT);
   BEGIN
    PutOrgCode(WrkBPT);
    ExecuteSingleInstruction;
    PutBPTCode(WrkBPT)
   END; (* ExecuteOrgCode *)
  
  PROCEDURE ExecuteBPT(BPT_OpCode:Boolean);
   LABEL 1;
   VAR BPT_No,BPT_Type:Integer;
       WrkBPT:PtrBPT;
   BEGIN
    IF NOT BPT_OpCode THEN BEGIN
     BPT_Type:=Ord(UserBPT);
    END ELSE BEGIN
     BPT_No:=GetByteIPC; BPT_Type:=GetByteIPC;
     IF (BPT_No=0) OR
        NOT (BPT_Type IN [Ord(UserBPT),Ord(RunBPT),Ord(TraceBPT)]) THEN BEGIN
      InternalError(BreakPoint);
     END;
     WrkBPT:=BPT_List;
     WHILE WrkBPT<>Nil DO BEGIN
      IF WrkBPT^.BPT_No=BPT_No THEN BEGIN
       GOTO 1;
      END;
      WrkBPT:=WrkBPT^.NextBPT
     END;
1:   IF WrkBPT=Nil THEN BEGIN
      InternalError(BreakPoint);
     END;
     IF (WrkBPT^.BPT_PageNo<>NewInstPageNo) OR
        (WrkBPT^.BPT_PageIndex<>NewInstPageIndex) THEN BEGIN
      InternalError(BreakPoint);
     END;
    END;
    IPC_PageNo:=NewInstPageNo;
    IPC_PageIndex:=NewInstPageIndex;
    IF BPT_OpCode AND
        ((Stepping AND (BPT_Type=Ord(UserBPT))) OR
         ((FirstInstPageNo=IPC_PageNo) AND
          (FirstInstPageIndex=IPC_PageIndex))) THEN BEGIN
     ExecuteOrgCode(WrkBPT)
    END ELSE BEGIN
     DC_PageNo:=IPC_PageNo;
     DC_PageIndex:=IPC_PageIndex;
     IF BPT_Type=Ord(UserBPT) THEN BEGIN
      ChkWait; RingBell;
      PrintString('Stopped by ');
      IF BPT_OpCode THEN BEGIN
       PrintString('user defined BPT #');
       WrkBPT^.HitCnt:=Succ(WrkBPT^.HitCnt);
       PrintByte(BPT_No,2);
       PrintString(' hit=');
       PrintWord(WrkBPT^.HitCnt,4);
      END ELSE BEGIN
       PrintString('BPT on opcode');
      END;
      ChkWait;
     END ELSE IF (BPT_Type=Ord(RunBPT)) AND Running OR
                 (BPT_Type=Ord(TraceBPT)) AND Tracing THEN BEGIN
      ClearBPT(BPT_No);
     END;
     Running:=false;
     IF Stepping THEN BEGIN
      Cmd:=SwitchToStep;
     END ELSE BEGIN
      PrintZState;
      Disassemble(1, true, false, true);
     END;
     GOTO 999;
    END
   END; (* ExecuteBPT *)
  
  PROCEDURE Return(Value:Integer);
   VAR NumLocalVariables,RegCnt,Discard:Integer;
       HighByte:Integer;
       IsFunc:Boolean;
   BEGIN
    SP:=MSP;
    NumLocalVariables:=Pop;
    NumCallParams:=Pop;
    FOR RegCnt:=Pred(NumLocalVariables) DOWNTO 0 DO
     R.a[RegCnt]:=Pop;
    IPC_PageNo:=Pop;
    SplitWord(Pop,IPC_PageIndex,HighByte);
    IsFunc:=Odd(HighByte);
    Discard:=Pop; Discard:=Pop; MSP:=Pop;
(*
    IF (IPC_PageNo=0) AND (IPC_PageIndex=0) THEN
     InternalError(NotImplemented);
*)
    IF IsFunc THEN BEGIN
     DoPutWord(Value);
    END;
   END; (* Return *)
  
  PROCEDURE HandleTrue;
   VAR TrueJump:Boolean;
       Distance:Integer;
   BEGIN
    GetJump(FromIPC,TrueJump,Distance);
    IF TrueJump THEN
     IF Distance=0 THEN
      Return(0)
     ELSE IF Distance=1 THEN
      Return(1)
     ELSE
      CalcJump(IPC_PageNo,IPC_PageIndex,IPC_PageNo,IPC_PageIndex,Distance)
   END; (* HandleTrue *)
  
  PROCEDURE HandleFalse;
   VAR TrueJump:Boolean;
       Distance:Integer;
   BEGIN
    GetJump(FromIPC,TrueJump,Distance);
    IF NOT TrueJump THEN
     IF Distance=0 THEN
      Return(0)
     ELSE IF Distance=1 THEN
      Return(1)
     ELSE
      CalcJump(IPC_PageNo,IPC_PageIndex,IPC_PageNo,IPC_PageIndex,Distance)
   END; (* HandleFalse *)
  
  PROCEDURE WTX(VAR TextPageNo,TextPageIndex:Integer; IncCnt:Boolean);
   VAR SavePageNo,SavePageIndex:Integer;
   BEGIN
    Push(IPC_PageNo); Push(IPC_PageIndex);
    IPC_PageNo:=TextPageNo; IPC_PageIndex:=TextPageIndex;
    WriteText('T',ToStoryOutput,FromIPC,GlobalTextBuffer,0);
    SavePageNo:=IPC_PageNo; SavePageIndex:=IPC_PageIndex;
    IPC_PageIndex:=Pop; IPC_PageNo:=Pop;
    IF IncCnt THEN BEGIN
     TextPageNo:=SavePageNo; TextPageIndex:=SavePageIndex
    END
   END; (* WTX *)
  
  FUNCTION SavedState:Boolean;
   VAR OldPrintListing:Boolean;
       PageCnt,NumPagesToSave,LowByte,HighByte,RegCnt,SaveIndex:Integer;
       Answer:Char;
       FileName:aMaxString;
       UnixName:aMaxString;
       SaveFile:aPageFile;
   BEGIN
    SavedState:=false;
    ZM_NewLine;
    OldPrintListing:=PrintListing; PrintListing:=false;
    PrintString('Save file name -->'); PrintCh(' ');
    SetLength(FileName, 0);
    ReadLine(true, FileName, 79, -1, 0);
    IF Length(FileName)>0 THEN BEGIN
     FileName:=Concat(StateDirectory,FileName);
     Answer:='y';
     IF FileExists(FileName) THEN BEGIN
      PrintString('File already exists. Overwrite it (y/n)?'); PrintCh(' ');
      CursorOn; Answer:=ReadKeyWithNoEcho(-1); CursorOff;
      IF Answer='Y' THEN
       Answer:='y';
      IF Answer='y' THEN
       PrintString('yes')
      ELSE
       PrintString('no');
      ChkWait
     END;
     IF Answer='y' THEN BEGIN
      UnixName:=FileName;
      Rewrite(SaveFile,UnixName); PageCnt:=0; NumPagesToSave:=ExpandByte(MiscInfo.SaveStateSizeHigh);
      SaveFile^[0]:=MiscInfo.ReleaseHigh; SaveFile^[1]:=MiscInfo.ReleaseLow;
      SplitWord(IPC_PageNo,LowByte,HighByte);
      SaveFile^[2]:=HighByte; SaveFile^[3]:=LowByte; SaveFile^[4]:=IPC_PageIndex;
      SplitWord(SP,LowByte,HighByte);
      SaveFile^[5]:=HighByte; SaveFile^[6]:=LowByte;
      SplitWord(MSP,LowByte,HighByte);
      SaveFile^[7]:=HighByte; SaveFile^[8]:=LowByte;
      SaveFile^[9]:=NumCallParams; SaveIndex:=10;
      FOR RegCnt:=0 TO 14 DO BEGIN
       SplitWord(R.a[RegCnt],LowByte,HighByte);
       SaveFile^[SaveIndex]:=HighByte; SaveFile^[SaveIndex+1]:=LowByte;
       SaveIndex:=SaveIndex+2
      END;
      Put(SaveFile);
      SaveIndex:=0; RegCnt:=0;
      FOR RegCnt:=0 TO MaxStack DO BEGIN
       SplitWord(Stack[RegCnt],LowByte,HighByte);
       IF SaveIndex>255 THEN BEGIN
        Put(SaveFile); SaveIndex:=0
       END;
       SaveFile^[SaveIndex]:=HighByte; SaveFile^[SaveIndex+1]:=LowByte;
       SaveIndex:=SaveIndex+2
      END;
      Put(SaveFile);
      WHILE (PageCnt<NumPagesToSave)  DO BEGIN
       SaveFile^:=PagePtrs[PageCnt]^; Put(SaveFile);
       PageCnt:=Succ(PageCnt)
      END;
      SavedState:=PageCnt=NumPagesToSave
     END
    END;
    ClosePageFile(SaveFile);
    PrintListing:=OldPrintListing
   END; (* SavedState *)
  
  FUNCTION RestoredState:Boolean;
   VAR OldPrintListing,BugVersion:Boolean;
       PageCnt,NumPagesToSave,RegCnt,SaveIndex:Integer;
       FileName:aMaxString;
       UnixName:aMaxString;
       SaveFile:aPageFile;
   BEGIN
    RestoredState:=false;
    ZM_NewLine;
    OldPrintListing:=PrintListing; PrintListing:=false;
    PrintString('Save file name -->'); PrintCh(' ');
    SetLength(FileName, 0);
    ReadLine(true, FileName, 79, -1, 0);
    IF Length(FileName)>0 THEN BEGIN
     FileName:=Concat(StateDirectory,FileName);
     IF NOT FileExists(FileName) THEN BEGIN
      PrintString('File not found.'); ChkWait
     END
     ELSE BEGIN
      UnixName:=FileName;
      NumPagesToSave:=ExpandByte(MiscInfo.SaveStateSizeHigh);
      PageCnt:=0; Reset(SaveFile,UnixName);
      BugVersion:=(SaveFile^[0]=0) AND (SaveFile^[1]=0);
      IF ((MiscInfo.ReleaseHigh<>SaveFile^[0]) OR (MiscInfo.ReleaseLow<>SaveFile^[1])) AND
         NOT BugVersion THEN BEGIN
       PrintString('Save file has wrong release number.'); ChkWait
      END
      ELSE BEGIN
       IF BugVersion THEN BEGIN
        PrintString('IPC, registers and stack will not be restored.'); ChkWait;
        Get(SaveFile)
       END
       ELSE BEGIN
        IPC_PageNo:=JoinBytes(ExpandByte(SaveFile^[3]),ExpandByte(SaveFile^[2]));
        IPC_PageIndex:=ExpandByte(SaveFile^[4]);
        SP:=JoinBytes(ExpandByte(SaveFile^[6]),ExpandByte(SaveFile^[5]));
        MSP:=JoinBytes(ExpandByte(SaveFile^[8]),ExpandByte(SaveFile^[7]));
        NumCallParams:=ExpandByte(SaveFile^[9]); SaveIndex:=10;
        FOR RegCnt:=0 TO 14 DO BEGIN
         R.a[RegCnt]:=JoinBytes(ExpandByte(SaveFile^[SaveIndex+1]),ExpandByte(SaveFile^[SaveIndex]));
         SaveIndex:=SaveIndex+2
        END;
        Get(SaveFile);
        SaveIndex:=0; RegCnt:=0;
        FOR RegCnt:=0 TO MaxStack DO BEGIN
         IF SaveIndex>255 THEN BEGIN
          Get(SaveFile); SaveIndex:=0
         END;
         Stack[RegCnt]:=JoinBytes(ExpandByte(SaveFile^[SaveIndex+1]),ExpandByte(SaveFile^[SaveIndex]));
         SaveIndex:=SaveIndex+2
        END
       END;
       Get(SaveFile);
       WHILE (PageCnt<NumPagesToSave) AND NOT EOF(SaveFile) DO BEGIN
        PagePtrs[PageCnt]^:=SaveFile^; PageCnt:=Succ(PageCnt);
        Get(SaveFile)
       END;
       SetInterpreterConfiguration;
       RestoredState:=PageCnt=NumPagesToSave
      END
     END
    END;
    ClosePageFile(SaveFile);
    PrintListing:=OldPrintListing
   END; (* RestoredState *)
  
  PROCEDURE GetObjPropertyPtr(ObjNo:Integer;
                          VAR ObjDataPageNo,ObjDataPageIndex:Integer);
   VAR ObjPageNo,ObjPageIndex:Integer;
   BEGIN
    IF CodeVersion<'4' THEN BEGIN
     CalcObjAdrs(ObjNo, ObjPageNo, ObjPageIndex, 7, true);
    END ELSE BEGIN
     CalcObjAdrs(ObjNo, ObjPageNo, ObjPageIndex, 12, true);
    END;
    ObjDataPageNo:=ExpandByte(PagePtrs[ObjPageNo]^[ObjPageIndex]);
    Inc(ObjPageNo,ObjPageIndex,1);
    ObjDataPageIndex:=ExpandByte(PagePtrs[ObjPageNo]^[ObjPageIndex]);
    Inc(ObjDataPageNo,ObjDataPageIndex,
        Succ(2*ExpandByte(PagePtrs[ObjDataPageNo]^[ObjDataPageIndex])))
   END; (* GetObjPropertyPtr *)
  
  PROCEDURE GetMultipleOperands(Extended:Boolean);
   VAR Mode:Integer;
       Continue:Boolean;
       MultiOpdCnt:Integer;
   BEGIN
    IF Extended THEN BEGIN
     Mode:=GetWordIPC; MultiOpdCnt:=7
    END
    ELSE BEGIN
     Mode:=GetByteIPC; MultiOpdCnt:=3
    END;
    Continue:=true; OpdCnt:=0;
    WHILE Continue DO BEGIN
     CASE Bittle(Mode,MultiOpdCnt) OF
      0:
       Opd.a[OpdCnt]:=GetWordIPC;
      1:
       Opd.a[OpdCnt]:=GetByteIPC;
      2:
       Opd.a[OpdCnt]:=DoGetWord;
      3:
       Continue:=false
     END;
     IF Continue THEN BEGIN
      OpdCnt:=Succ(OpdCnt);
      IF MultiOpdCnt>0 THEN
       MultiOpdCnt:=Pred(MultiOpdCnt)
      ELSE
       Continue:=false
     END
    END;
   END; (* GetMultipleOperands *)

  PROCEDURE StoreWord;
   VAR DestPageNo,DestIndex:Integer;
       LowByte,HighByte:Integer;
   BEGIN
    IF OpdCnt <> 3 THEN BEGIN
     InternalError(IllNumOperands);
    END;
    SplitWord(Opd.s0,DestIndex,DestPageNo);
    DestIndex:=DestIndex+2*Opd.s1;
    ChkAddress(DestPageNo,DestIndex);
    SplitWord(Opd.s2,LowByte,HighByte);
    PagePtrs[DestPageNo]^[DestIndex]:=HighByte;
    Inc(DestPageNo,DestIndex,1);
    PagePtrs[DestPageNo]^[DestIndex]:=LowByte
   END; (* StoreWord *)

  PROCEDURE StoreByte;
   VAR DestPageNo,DestIndex:Integer;
   BEGIN
    IF OpdCnt <> 3 THEN BEGIN
     InternalError(IllNumOperands);
    END;
    SplitWord(Opd.s0,DestIndex,DestPageNo);
    Inc(DestPageNo,DestIndex,Opd.s1);
    PagePtrs[DestPageNo]^[DestIndex]:=Opd.s2
   END; (* StoreByte *)

  PROCEDURE StoreProperty;
   LABEL 30;
   VAR ObjDataPageNo,ObjDataIndex:Integer;
       LowByte,HighByte:Integer;
   BEGIN
    IF OpdCnt<>3 THEN BEGIN
     InternalError(IllNumOperands);
    END;
    GetObjPropertyPtr(Opd.s0,ObjDataPageNo,ObjDataIndex);
30:
    AccA:=GetPropertyNo(ObjDataPageNo,ObjDataIndex);
    IF AccA=0 THEN BEGIN
     InternalError(MissingObjProp);
    END;
    IF AccA<>Opd.s1 THEN BEGIN
     Inc(ObjDataPageNo,ObjDataIndex,
         Succ(GetPropertySize(ObjDataPageNo,ObjDataIndex,true)));
     GOTO 30
    END;
    AccA:=GetPropertySize(ObjDataPageNo,ObjDataIndex,true);
    Inc(ObjDataPageNo,ObjDataIndex,1);
    SplitWord(Opd.s2,LowByte,HighByte);
    IF AccA=1 THEN
     PagePtrs[ObjDataPageNo]^[ObjDataIndex]:=LowByte
    ELSE IF AccA=2 THEN BEGIN
     PagePtrs[ObjDataPageNo]^[ObjDataIndex]:=HighByte;
     Inc(ObjDataPageNo,ObjDataIndex,1);
     PagePtrs[ObjDataPageNo]^[ObjDataIndex]:=LowByte
    END
    ELSE
     InternalError(IllObjPropertyStore)
   END; (* StoreProperty *)

  PROCEDURE PackWord(VAR Word:aWord; VAR Pkd:aPackedWord);
   VAR PkdCnt,ChrCnt,SmallShift,TableIndex,LowByte,HighByte:Integer;
       WrkCh:Char;
   
   PROCEDURE PutInPkd(Value:Integer);
    VAR WordNo,FieldNo,HighByte,LowByte:Integer;
    BEGIN
     IF PkdCnt < WordNumChars THEN BEGIN
      WordNo:=PkdCnt DIV 3; FieldNo:=PkdCnt MOD 3;
      SplitWord(Pkd[WordNo],LowByte,HighByte);
      CASE FieldNo OF
       0:
        HighByte:=lor(land(HighByte,3),land(lsl(Value,2),124));
       1:BEGIN
        HighByte:=lor(land(HighByte,252),land(lsr(Value,3),3));
        LowByte :=lor(land(LowByte,31),land(lsl(Value,5),224))
       END;
       2:
        LowByte:=lor(land(LowByte,224),land(Value,31))
      END;
      Pkd[WordNo]:=JoinBytes(LowByte,HighByte);
      PkdCnt:=Succ(PkdCnt);
     END;
    END; (* PutInPkd *)
   
   BEGIN (* PackWord *)
    Pkd[0]:=5285; Pkd[1]:=5285; Pkd[2]:=5285; PkdCnt:=0;
    SmallShift:=Ord('a')-6;
    FOR ChrCnt:=0 TO 8 DO BEGIN
     WrkCh:=Word[ChrCnt];
     IF WrkCh=Chr(0) THEN
      PutInPkd(5)
     ELSE IF (WrkCh>='a') AND (WrkCh<='z') THEN
      PutInPkd(Ord(WrkCh)-SmallShift)
     ELSE BEGIN
      PutInPkd(5);
      IF CodeVersion='1' THEN BEGIN
       IF WrkCh IN Char1Set THEN BEGIN
        TableIndex:=1;
        WHILE WrkCh<>Char1Table[TableIndex] DO
         TableIndex:=Succ(TableIndex);
        PutInPkd(TableIndex+6)
       END
       ELSE BEGIN
        PutInPkd(6);
        PutInPkd(land(lsr(Ord(WrkCh),5),3));
        PutInPkd(land(Ord(WrkCh),31))
       END
      END
      ELSE IF WrkCh IN Char23Set THEN BEGIN
       TableIndex:=1;
       WHILE WrkCh<>Char23Table[TableIndex] DO
        TableIndex:=Succ(TableIndex);
       PutInPkd(TableIndex+7)
      END
      ELSE BEGIN
       PutInPkd(6);
       PutInPkd(land(lsr(Ord(WrkCh),5),3));
       PutInPkd(land(Ord(WrkCh),31))
      END
     END
    END;
    IF CodeVersion>='4' THEN BEGIN
     SplitWord(Pkd[2],LowByte,HighByte);
     HighByte:=lor(HighByte,128);
     Pkd[2]:=JoinBytes(LowByte,HighByte)
    END
    ELSE BEGIN
     SplitWord(Pkd[1],LowByte,HighByte);
     HighByte:=lor(HighByte,128);
     Pkd[1]:=JoinBytes(LowByte,HighByte)
    END;
    IF DebugVocab THEN BEGIN
     ChkWait;
     PrintWord(Pkd[2],4); PrintWord(Pkd[1],4);
     PrintWord(Pkd[0],4); ChkWait
    END;
    Pkd[0]:=Pkd[0]+CmpShift;
    Pkd[1]:=Pkd[1]+CmpShift;
    Pkd[2]:=Pkd[2]+CmpShift
   END; (* PackWord *)
  
  PROCEDURE ParseSentence(LinePageNo,LinePageIndex:Integer;
                          ParsedPageNo,ParsedPageIndex:Integer;
                          VocabPageNo,VocabPageIndex:Integer;
                          DiscardNullWordInfoOffset:Integer);
   VAR WrkCh:Char;
       LowByte,HighByte:Integer;
       WordStartIndex:Integer;
       NumVocabWords,EntryLength:Integer;
       VocabStartPageNo,VocabStartPageIndex:Integer;
       ParsedStartPageNo,ParsedStartPageIndex:Integer;
       InputIndex,InputLength,ChrCnt:Integer;
       MaxNumWords,NumWords,WordChCnt:Integer;
       NumSeparators,SeparatorCnt:Integer;
       SeparatorSet:CharSet;
       Word,InitWord:aWord;
       Pkd:aPackedWord;

   PROCEDURE GetCh;
    BEGIN
     IF InputIndex > InputLength THEN
      WrkCh:=EOL
     ELSE BEGIN
      WrkCh:=PagePtrs[LinePageNo]^[LinePageIndex];
      IF (WrkCh>='A') AND (WrkCh<='Z') THEN BEGIN
       WrkCh:=Chr(Ord(WrkCh)-Ord('A')+Ord('a'));
      END;
      Inc(LinePageNo, LinePageIndex, 1);
      InputIndex:=Succ(InputIndex);
     END
    END; (* GetCh *)
   
   PROCEDURE BackCh;
    BEGIN
     Dec(LinePageNo, LinePageIndex, 1);
     InputIndex:=Pred(InputIndex);
    END; (* BackCh *)

   FUNCTION GetVocabByte:Integer;
    BEGIN
     GetVocabByte:=ExpandByte(PagePtrs[VocabPageNo]^[VocabPageIndex]);
     Inc(VocabPageNo, VocabPageIndex, 1);
    END; (* GetVocabByte *)
   
   FUNCTION SearchWord(StartPageNo,StartPageIndex,NumWords:Integer):Integer;
    VAR Wrk:Integer;
        LowerNum,UpperNum,MiddlePageNo,MiddlePageIndex,HighByte,LowByte,
        WordPageNo,WordPageIndex:Integer;
    BEGIN
     VocabPageNo:=StartPageNo; VocabPageIndex:=StartPageIndex;
     WordPageNo:=VocabPageNo; WordPageIndex:=VocabPageIndex;
     IF NumWords=0 THEN
      SearchWord:=0
     ELSE IF NumWords=1 THEN BEGIN
      IF DebugVocab THEN BEGIN
       DC_PageNo:=WordPageNo; DC_PageIndex:=WordPageIndex;
       WriteText('V',OntoScreen,FromDC,GlobalTextBuffer,0);
      END;
      HighByte:=GetVocabByte; LowByte:=GetVocabByte;
      Wrk:=JoinBytes(LowByte,HighByte);
      IF Wrk+CmpShift<>Pkd[0] THEN
       SearchWord:=0
      ELSE BEGIN
       HighByte:=GetVocabByte; LowByte:=GetVocabByte;
       Wrk:=JoinBytes(LowByte,HighByte);
       IF Wrk+CmpShift<>Pkd[1] THEN
        SearchWord:=0
       ELSE IF CodeVersion<'4' THEN
        SearchWord:=JoinBytes(WordPageIndex,WordPageNo)
       ELSE BEGIN
        HighByte:=GetVocabByte; LowByte:=GetVocabByte;
        Wrk:=JoinBytes(LowByte,HighByte);
        IF Wrk+CmpShift<>Pkd[2] THEN
         SearchWord:=0
        ELSE
         SearchWord:=JoinBytes(WordPageIndex,WordPageNo)
       END
      END
     END
     ELSE BEGIN
      LowerNum:=NumWords DIV 2;
      IF Odd(NumWords) THEN
       UpperNum:=LowerNum
      ELSE
       UpperNum:=Pred(LowerNum);
      Inc(VocabPageNo,VocabPageIndex,EntryLength*LowerNum);
      WordPageNo:=VocabPageNo; WordPageIndex:=VocabPageIndex;
      IF DebugVocab THEN BEGIN
       DC_PageNo:=WordPageNo; DC_PageIndex:=WordPageIndex;
       WriteText('V',OntoScreen,FromDC,GlobalTextBuffer,0);
      END;
      MiddlePageNo:=VocabPageNo; MiddlePageIndex:=VocabPageIndex;
      Inc(MiddlePageNo,MiddlePageIndex,EntryLength);
      HighByte:=GetVocabByte; LowByte:=GetVocabByte;
      Wrk:=JoinBytes(LowByte,HighByte)+CmpShift;
      IF Pkd[0]<Wrk THEN
       SearchWord:=SearchWord(StartPageNo,StartPageIndex,LowerNum)
      ELSE IF Pkd[0]>Wrk THEN
       SearchWord:=SearchWord(MiddlePageNo,MiddlePageIndex,UpperNum)
      ELSE BEGIN
       HighByte:=GetVocabByte; LowByte:=GetVocabByte;
       Wrk:=JoinBytes(LowByte,HighByte)+CmpShift;
       IF Pkd[1]<Wrk THEN
        SearchWord:=SearchWord(StartPageNo,StartPageIndex,LowerNum)
       ELSE IF Pkd[1]>Wrk THEN
        SearchWord:=SearchWord(MiddlePageNo,MiddlePageIndex,UpperNum)
       ELSE IF CodeVersion<'4' THEN
        SearchWord:=JoinBytes(WordPageIndex,WordPageNo)
       ELSE BEGIN
        HighByte:=GetVocabByte; LowByte:=GetVocabByte;
        Wrk:=JoinBytes(LowByte,HighByte)+CmpShift;
        IF Pkd[2]<Wrk THEN
         SearchWord:=SearchWord(StartPageNo,StartPageIndex,LowerNum)
        ELSE IF Pkd[2]>Wrk THEN
         SearchWord:=SearchWord(MiddlePageNo,MiddlePageIndex,UpperNum)
        ELSE
         SearchWord:=JoinBytes(WordPageIndex,WordPageNo)
       END
      END
     END
    END; (* SearchWord *)
   
   BEGIN (* ParseSentence *)
    Inc(LinePageNo, LinePageIndex, 1); (* skip max length *)
    InputLength:=ExpandByte(PagePtrs[LinePageNo]^[LinePageIndex]);
    InputIndex:=1;
    Inc(LinePageNo, LinePageIndex, 1); (* skip length *)
    NumSeparators:=GetVocabByte;
    IF NumSeparators>10 THEN BEGIN
     InternalError(TooManySeparators);
    END;
    SeparatorSet:=[];
    FOR SeparatorCnt:=1 TO NumSeparators DO BEGIN
     SeparatorSet:=SeparatorSet+[Chr(GetVocabByte)];
    END;
    EntryLength:=GetVocabByte;
    HighByte:=GetVocabByte; LowByte:=GetVocabByte;
    NumVocabWords:=JoinBytes(LowByte,HighByte);
    VocabStartPageNo:=VocabPageNo;
    VocabStartPageIndex:=VocabPageIndex;
    ParsedStartPageNo:=ParsedPageNo;
    ParsedStartPageIndex:=ParsedPageIndex;
    MaxNumWords:=ExpandByte(PagePtrs[ParsedPageNo]^[ParsedPageIndex]);
    IF (MaxNumWords=0) OR (MaxNumWords>MaxMaxNumWords) THEN BEGIN
     MaxNumWords:=MaxMaxNumWords;
     PagePtrs[ParsedPageNo]^[ParsedPageIndex]:=MaxNumWords
    END;
    Inc(ParsedPageNo,ParsedPageIndex,2);
    FOR ChrCnt:=0 TO 8 DO BEGIN
     InitWord[ChrCnt]:=Chr(0);
    END;
    NumWords:=0;
    GetCh;
    BackCh;
    WHILE (WrkCh<>EOL) AND (NumWords<MaxNumWords) DO BEGIN
     Word:=InitWord; WordStartIndex:=InputIndex; GetCh;
     IF (NOT (WrkCh IN TerminatorSet) OR (WrkCh IN SeparatorSet)) AND
        (WrkCh<>EOL) THEN BEGIN
      Word[0]:=WrkCh; WordChCnt:=1;
      IF NOT (WrkCh IN SeparatorSet) THEN BEGIN
       GetCh;
       WHILE (WrkCh<>EOL) AND
             NOT ((WrkCh IN SeparatorSet) OR
                  (WrkCh IN TerminatorSet)) DO BEGIN
        IF WordChCnt<WordNumChars THEN
         Word[WordChCnt]:=WrkCh;
        GetCh; WordChCnt:=Succ(WordChCnt)
       END;
       BackCh;
      END;
      IF DebugVocab THEN BEGIN
       ChkWait;
       FOR ChrCnt:=0 TO Pred(WordChCnt) DO
        PrintCh(Word[ChrCnt]);
       PrintCh(','); PrintByte(WordChCnt,2)
      END;
      PackWord(Word, Pkd);
      SplitWord(SearchWord(VocabStartPageNo,VocabStartPageIndex,NumVocabWords),LowByte,HighByte);
      IF DebugVocab THEN BEGIN
       PrintByte(HighByte,2); PrintByte(LowByte,2); ChkWait
      END;
      IF (DiscardNullWordInfoOffset=1) AND
         (LowByte=0) AND (HighByte=0) THEN BEGIN
       (* do not store offset to word info *)
       Inc(ParsedPageNo, ParsedPageIndex, 2);
      END ELSE BEGIN
       PagePtrs[ParsedPageNo]^[ParsedPageIndex]:=HighByte;
       Inc(ParsedPageNo, ParsedPageIndex, 1);
       PagePtrs[ParsedPageNo]^[ParsedPageIndex]:=LowByte;
       Inc(ParsedPageNo, ParsedPageIndex, 1);
      END;
      PagePtrs[ParsedPageNo]^[ParsedPageIndex]:=WordChCnt;
      Inc(ParsedPageNo,ParsedPageIndex,1);
(*      IF CodeVersion>='5' THEN BEGIN *)
       WordStartIndex:=Succ(WordStartIndex);
(*      END; *)
      PagePtrs[ParsedPageNo]^[ParsedPageIndex]:=WordStartIndex;
      Inc(ParsedPageNo,ParsedPageIndex,1);
      NumWords:=Succ(NumWords)
     END
    END;
    ParsedPageNo:=ParsedStartPageNo;
    ParsedPageIndex:=ParsedStartPageIndex;
    Inc(ParsedPageNo,ParsedPageIndex,1);
    PagePtrs[ParsedPageNo]^[ParsedPageIndex]:=NumWords;
   END; (* ParseSentence *)

  PROCEDURE ZMachineInput;
   VAR LinePageNo,LinePageIndex:Integer;
       VocabPageNo,VocabPageIndex:Integer;
       ChPageNo,ChPageIndex:Integer;
       LineLength,MaxLineLength,ChrCnt:Integer;
       ParsedPageNo,ParsedPageIndex:Integer;
       GotLine:Boolean;
       InputLine:aMaxString;   
   BEGIN
    IF OpdCnt < 1 THEN BEGIN
     InternalError(MissingOpd);
    END;
    IF OpdCnt > 4 THEN BEGIN
     InternalError(IllNumOperands);
    END;
    IF OpdCnt < 4 THEN BEGIN
     Opd.s3:=0;
     IF OpdCnt < 3 THEN BEGIN
      Opd.s2:=-1;
      IF OpdCnt < 2 THEN BEGIN
       Opd.s1:=0;
      END;
     END;
    END;
    SplitWord(Opd.s0, LinePageIndex, LinePageNo);
    SplitWord(Opd.s1, ParsedPageIndex, ParsedPageNo);
    MaxLineLength:=ExpandByte(PagePtrs[LinePageNo]^[LinePageIndex]);
    IF MaxLineLength>Pred(ScreenWidth) THEN BEGIN
     MaxLineLength:=Pred(ScreenWidth);
    END;
    ChPageNo:=LinePageNo;
    ChPageIndex:=LinePageIndex;
    IF CodeVersion>='5' THEN BEGIN
     Inc(ChPageNo, ChPageIndex, 1); (* skip max length *)
     LineLength:=ExpandByte(PagePtrs[ChPageNo]^[ChPageIndex]);
     FOR ChrCnt:=1 TO LineLength DO BEGIN
      Inc(ChPageNo, ChPageIndex, 1);
      InputLine[ChrCnt]:=
        Chr(PagePtrs[ChPageNo]^[ChPageIndex]);
     END;
     ChPageNo:=LinePageNo;
     ChPageIndex:=LinePageIndex;
    END ELSE BEGIN
     LineLength:=0;
    END;
    SetLength(InputLine, LineLength);
    GotLine:=ReadLine(true, InputLine, MaxLineLength, Opd.s2, Opd.s3);
    IF NOT GotLine AND (CodeVersion>='5') THEN BEGIN
     DoPutWord(InputLine[1]);
    END ELSE BEGIN
     Inc(ChPageNo, ChPageIndex, 1); (* skip max length *)
     PagePtrs[ChPageNo]^[ChPageIndex]:=Length(InputLine); (* store length *)
     FOR ChrCnt:=1 TO Length(InputLine) DO BEGIN
      Inc(ChPageNo, ChPageIndex, 1);
      PagePtrs[ChPageNo]^[ChPageIndex]:=Ord(InputLine[ChrCnt]);
     END;
     Inc(ChPageNo, ChPageIndex, 1);
     IF (ParsedPageNo <> 0) OR (ParsedPageIndex <> 0) THEN BEGIN
      VocabPageNo:=ExpandByte(MiscInfo.VocabPageNo);
      VocabPageIndex:=ExpandByte(MiscInfo.VocabPageIndex);
      ParseSentence(LinePageNo, LinePageIndex, ParsedPageNo, ParsedPageIndex,
       VocabPageNo, VocabPageIndex, 0);
     END;
     IF CodeVersion>='5' THEN BEGIN
      DoPutWord(10); (* we have an input line *)
     END
    END
   END; (* ZMachineInput *)
  
  PROCEDURE WriteSingleCharacter;
   BEGIN
    IF OpdCnt <> 1 THEN BEGIN
     InternalError(IllNumOperands);
    END;
    PutChToStoryOutput(Chr(Opd.s0));
   END; (* WriteSingleCharacter *)

  PROCEDURE WriteInteger;
   BEGIN
    IF OpdCnt <> 1 THEN BEGIN
     InternalError(IllNumOperands);
    END;
    PutIntToStoryOutput(Opd.s0);
   END; (* WriteInteger *)

  PROCEDURE ZMachineRandom;
   VAR Negative:Boolean;
       RandomNo:Integer;
   BEGIN
    IF OpdCnt<>1 THEN BEGIN
     InternalError(IllNumOperands);
    END;
    IF Opd.s0=0 THEN BEGIN
     DoPutWord(0);
    END ELSE BEGIN
     Negative:=Opd.s0<0;
     IF Negative THEN BEGIN
      Opd.s0:=-Opd.s0;
     END;
     RandomNo:=Random;
     IF RandomNo<0 THEN BEGIN
       RandomNo:=-RandomNo;
     END;
     RandomNo:=Succ(RandomNo MOD Opd.s0);
     IF Negative THEN BEGIN
      DoPutWord(-RandomNo)
     END ELSE BEGIN
      DoPutWord(RandomNo);
     END;
    END
   END; (* ZMachineRandom *)

  PROCEDURE SplitScreen;
   VAR OldScrollTop:Integer;
   BEGIN
    ScreenMode:=0; SetScreenMode;
    IF Opd.s0=0 THEN BEGIN
     ActiveWindow:=false; ScrollTop:=1+Ord(CodeVersion<='3');
     LineNo:=ScrollTop
    END ELSE IF Opd.s0<ScreenHeight THEN BEGIN
     ActiveWindow:=true;
     NonWindowCursorX:=Pred(1);
     NonWindowCursorY:=Pred(ScreenHeight);
     WindowCursorX:=Pred(1);
     WindowCursorY:=Pred(1+Ord(CodeVersion<='3'));
     OldScrollTop:=ScrollTop;
     ScrollTop:=Succ(Opd.s0+Ord(CodeVersion<='3'));
     IF OldScrollTop>ScrollTop THEN BEGIN
      LineNo:=LineNo-(OldScrollTop-ScrollTop);
     END;
     IF ScrollTop>=LineNo THEN BEGIN
      LineNo:=ScrollTop;
     END;
     IF CodeVersion<'4' THEN BEGIN
      ClearLines(1,ScrollTop-2);
     END;
     ZM_GotoXY(1,ScreenHeight)
    END;
   END; (* SplitScreen *)

  PROCEDURE ChooseWindow;
   BEGIN
    IF CodeVersion>='5' THEN BEGIN
      WriteLineBuffer;
    END;
    IF ActiveWindow>=0 THEN BEGIN
     IF Opd.s0=0 THEN BEGIN
      IF WritingInWindow THEN BEGIN
       IF CodeVersion>='4' THEN BEGIN
        WindowCursorX:=CursorX;
        WindowCursorY:=CursorY;
       END;
       WritingInWindow:=false;
       CursorX:=NonWindowCursorX;
       CursorY:=NonWindowCursorY;
       PositionCursor;
      END;
     END ELSE IF Opd.s0=1 THEN BEGIN
      IF NOT WritingInWindow THEN BEGIN
       IF CodeVersion>='4' THEN BEGIN
        NonWindowCursorX:=CursorX;
        NonWindowCursorY:=CursorY;
       END;
       WritingInWindow:=true;
       CursorX:=WindowCursorX;
       CursorY:=WindowCursorY;
       PositionCursor;
      END;
     END;
    END;
   END; (* ChooseWindow *)

  PROCEDURE EraseArea;
   BEGIN
    IF Opd.s0=0 THEN BEGIN
     ClearLines(Pred(ScrollTop),Pred(ScreenHeight));
     ZM_GotoXY(1,ScreenHeight)
    END
    ELSE IF Opd.s0=1 THEN BEGIN
     IF WritingInWindow THEN BEGIN
      ClearLines(0,ScrollTop-2);
      ZM_GotoXY(1,ScrollTop)
     END ELSE BEGIN
      ClearScreen
     END;
    END
    ELSE IF Opd.s0=-1 THEN BEGIN
     ActiveWindow:=false;
     ScrollTop:=1+Ord(CodeVersion<='3');
     LineNo:=ScrollTop;
     ClearScreen
    END;
   END; (* EraseArea *)

  PROCEDURE DoGotoXY;
   BEGIN
    IF CodeVersion>='5' THEN BEGIN
      WriteLineBuffer;
      ZM_GotoXY(Opd.s1,Opd.s0);
    END ELSE BEGIN
      IF DirectEnabled AND WritingInWindow THEN BEGIN
       ZM_GotoXY(Opd.s1,Opd.s0);
      END
    END
   END; (* DoGotoXY *)

  PROCEDURE ChangeSCreenMode;
   BEGIN
    WriteLineBuffer;
    ScreenMode:=Opd.s0;
    SetScreenMode;
   END; (* ChangeScreenMode *)

  PROCEDURE SetFormatMode;
   BEGIN
    FormatMode:=Opd.s0;
    CASE FormatMode OF
     0:BEGIN
      WriteLineBuffer; DirectEnabled:=true
     END;
     1:
      DirectEnabled:=false
    END
   END; (* SetFormatMode *)
  
  PROCEDURE StartRecording;
   BEGIN
    Recording:=True;
   END; (* StartRecording *)

  PROCEDURE StopRecording;
   BEGIN
    Recording:=false;
   END; (* StopRecording *)
  
  PROCEDURE SetOutputMode;
   VAR DestPageNo,DestIndex:Integer;
       LowByte,HighByte:Integer;
   BEGIN
    CASE Opd.s0 OF
     1:
      ScreenEnabled:=true;
     -1:
      ScreenEnabled:=false;
     2:BEGIN
      LowByte:=PagePtrs[0]^[17];
      SetBit(LowByte,0);
      PagePtrs[0]^[17]:=LowByte;
     END;
     -2:BEGIN
      LowByte:=PagePtrs[0]^[17];
      ClrBit(LowByte,0);
      PagePtrs[0]^[17]:=LowByte;
     END;
     3:
      IF OpdCnt>=2 THEN BEGIN
       BufferEnabled:=true;
       SplitWord(Opd.s1,BufferPageIndex,BufferPageNo);
       BufferIndex:=2
      END ELSE BEGIN
       InternalError(MissingOpd);
      END;
     -3:
      IF BufferEnabled THEN BEGIN
       BufferEnabled:=false;
       DestPageNo:=BufferPageNo; DestIndex:=BufferPageIndex;
       Inc(DestPageNo,DestIndex,BufferIndex);
       PagePtrs[DestPageNo]^[DestIndex]:=0;
       SplitWord(BufferIndex-2,LowByte,HighByte);
       PagePtrs[BufferPageNo]^[BufferPageIndex]:=HighByte;
       Inc(BufferPageNo,BufferPageIndex,1);
       PagePtrs[BufferPageNo]^[BufferPageIndex]:=LowByte;
       BufferPageNo:=-1; BufferPageIndex:=-1
      END ELSE BEGIN
       InternalError(OutputBufferUndefined);
      END;
     4:
       StartRecording;
     -4:
       StopRecording;
     OTHERWISE
      InternalError(IllOutputMode)
    END;
   END; (* SetOutputMode *)

  PROCEDURE StartPlayback;
   BEGIN
    Playback:=true;
   END; (* StartPlayback *)

  PROCEDURE Sound;
   BEGIN
    IF OpdCnt<4 THEN BEGIN
     Opd.s3:=0;
    END;
    IF OpdCnt<3 THEN BEGIN
     Opd.s2:=255;
    END;
    IF OpdCnt<2 THEN BEGIN
     Opd.s1:=2;
    END;
    IF (OpdCnt=1) OR (Opd.s1=2) THEN BEGIN
     RingBell;
    END;
   END; (* Sound *)

  PROCEDURE InputKey;
   VAR InpKey:Char;
   BEGIN
    IF CodeVersion>='5' THEN BEGIN
      WriteLineBuffer;
    END;
    IF (OpdCnt<1) OR (OpdCnt>3) THEN BEGIN
     InternalError(IllNumOperands);
    END;
    IF OpdCnt < 3 THEN BEGIN
     Opd.s2:=0;
     IF OpdCnt < 2 THEN BEGIN
      Opd.s1:=-1;
     END;
    END;
    IF Opd.s0=1 THEN BEGIN
     WriteLineBuffer; PrintStatusLine; LineNo:=ScrollTop;
     PositionCursor; CursorOn;
     IF Opd.s1>=0 THEN BEGIN
      EnableTimer;
     END;
     ReadKey(true, InpKey, Opd.s1, CallKeyPress, Opd.s2); CursorOff;
     IF Opd.s1>=0 THEN BEGIN
      DisableTimer;
     END;
     IF InpKey=EOL THEN
      InpKey:=Chr(13);
     DoPutWord(Ord(InpKey));
     IF InpKey=BreakKey THEN BEGIN
      InternalError(KeyboardBreak)
     END
    END
    ELSE
     DoPutWord(0);
   END; (* InputKey *)

  PROCEDURE BlockEqual;
   LABEL 230,231;
   VAR SourcePageNo,SourceIndex:Integer;
       Increment:Integer;
       WordCompare:Boolean;
       LowByte,HighByte:Integer;
   BEGIN
    IF OpdCnt > 4 THEN BEGIN
     InternalError(IllNumOperands);
    END;
    IF OpdCnt < 4 THEN BEGIN
     Opd.s3:=128 + 2; (* default is word compare *)
     IF OpdCnt < 3 THEN BEGIN
      InternalError(MissingOpd);
     END;
    END;
    IF Opd.s3>=128 THEN BEGIN
     WordCompare:=true;
     Increment:=Opd.s3-128;
    END ELSE BEGIN
     WordCompare:=false;
     Increment:=Opd.s3;
    END;
    SplitWord(Opd.s1,SourceIndex,SourcePageNo);
    ChkAddress(SourcePageNo,SourceIndex);
    IF WordCompare THEN BEGIN
     WHILE Opd.s2>0 DO BEGIN
      HighByte:=ExpandByte(PagePtrs[SourcePageNo]^[SourceIndex]);
      Inc(SourcePageNo,SourceIndex,1);
      LowByte:=ExpandByte(PagePtrs[SourcePageNo]^[SourceIndex]);
      Dec(SourcePageNo,SourceIndex,1);
      IF JoinBytes(LowByte,HighByte)=Opd.s0 THEN
       GOTO 231;
      Inc(SourcePageNo, SourceIndex, Increment);
      Opd.s2:=Pred(Opd.s2)
     END;
    END ELSE BEGIN
     WHILE Opd.s2>0 DO BEGIN
      LowByte:=ExpandByte(PagePtrs[SourcePageNo]^[SourceIndex]);
      IF LowByte=Opd.s0 THEN
       GOTO 231;
      Inc(SourcePageNo, SourceIndex, Increment);
      Opd.s2:=Pred(Opd.s2)
     END;
    END;
    DoPutWord(0);
    HandleFalse;
    GOTO 230;
231:
    DoPutWord(JoinBytes(SourceIndex, SourcePageNo));
    HandleTrue;
230:
   END; (* BlockEqual *)

  PROCEDURE Parse;
   VAR LinePageNo,LinePageIndex:Integer;
       ParsedPageNo,ParsedPageIndex:Integer;
       VocabPageNo,VocabPageIndex:Integer;
   BEGIN
    IF OpdCnt > 4 THEN BEGIN
     InternalError(IllNumOperands);
    END;
    IF OpdCnt < 4 THEN BEGIN
     Opd.s3:=0;
     IF OpdCnt < 3 THEN BEGIN
      Opd.s2:=0;
      IF OpdCnt < 2 THEN BEGIN
       InternalError(MissingOpd);
      END;
     END;
    END;
    SplitWord(Opd.s0, LinePageIndex, LinePageNo);
    SplitWord(Opd.s1, ParsedPageIndex, ParsedPageNo);
    IF Opd.s2 <> 0 THEN BEGIN
     SplitWord(Opd.s2, VocabPageIndex, VocabPageNo);
    END ELSE BEGIN
     VocabPageNo:=ExpandByte(MiscInfo.VocabPageNo);
     VocabPageIndex:=ExpandByte(MiscInfo.VocabPageIndex);     
    END;
    ParseSentence(LinePageNo, LinePageIndex,
     ParsedPageNo, ParsedPageIndex,
     VocabPageNo, VocabPageIndex,
     Opd.s3);
   END; (* Parse *)

  PROCEDURE PackCharacters;
   VAR Cnt, NumChars:Integer;
       ChPageNo, ChPageIndex:Integer;
       PkdPageNo, PkdPageIndex:Integer;
       LowByte, HighByte: Integer;
       Pkd:aPackedWord;
       Word:aWord;
   BEGIN
    IF OpdCnt < 4 THEN BEGIN
     InternalError(MissingOpd);
    END;
    IF OpdCnt > 4 THEN BEGIN
     InternalError(IllNumOperands);
    END;
    SplitWord(Opd.s0, ChPageIndex, ChPageNo);
    Inc(ChPageNo, ChPageIndex, Opd.s2);
    SplitWord(Opd.s3, PkdPageIndex, PkdPageNo);
    NumChars:=Opd.s1;
    IF NumChars > WordNumChars THEN BEGIN
      NumChars:=WordNumChars;
    END;
    FOR Cnt:=0 TO NumChars-1 DO BEGIN
     Word[Cnt]:=PagePtrs[ChPageNo]^[ChPageIndex];
     Inc(ChPageNo, ChPageIndex, 1);
    END;
    FOR Cnt:=NumChars TO 8 DO BEGIN
     Word[Cnt]:=0;
     Inc(ChPageNo, ChPageIndex, 1);
    END;
    PackWord(Word, Pkd);
    FOR Cnt:=0 TO 2 DO BEGIN
     SplitWord(Pkd[Cnt], LowByte, HighByte);
     PagePtrs[PkdPageNo]^[PkdPageIndex]:=HighByte;
     Inc(PkdPageNo, PkdPageIndex, 1);
     PagePtrs[PkdPageNo]^[PkdPageIndex]:=LowByte;
     Inc(PkdPageNo, PkdPageIndex, 1);
    END;
   END; (* PackCharacters *)

  PROCEDURE BlockCopy;
   VAR EndPageNo,EndIndex:Integer;
       SourcePageNo,SourceIndex,DestPageNo,DestIndex:Integer;
       Negative:Boolean;
   BEGIN
    IF OpdCnt<>3 THEN BEGIN
     InternalError(IllNumOperands);
    END;
    SplitWord(Opd.s0,SourceIndex,SourcePageNo);
    SplitWord(Opd.s1,DestIndex,DestPageNo);
    IF (DestPageNo<>SourcePageNo) OR (DestIndex<>SourceIndex) THEN BEGIN
      IF (Opd.s2<>0) THEN BEGIN
        IF (Opd.s2<0) THEN BEGIN
          Negative:=True;
          Opd.s2:=-Opd.s2;
        END ELSE BEGIN
          Negative:=false;
        END;
        IF (DestPageNo=0) AND (DestIndex=0) THEN BEGIN
          REPEAT
            PagePtrs[SourcePageNo]^[SourceIndex]:=0;
            Inc(SourcePageNo,SourceIndex,1);
            Opd.s2:=Pred(Opd.s2);
          UNTIL Opd.s2=0;
        END ELSE BEGIN
          EndPageNo:=SourcePageNo;
          EndIndex:=SourceIndex;
          Inc(EndPageNo,EndIndex,Opd.s2);
          IF Negative OR
             ((SourcePageNo>DestPageNo) OR
              (SourcePageNo=DestPageNo) AND (SourceIndex>DestIndex)) OR
             ((EndPageNo<DestPageNo) OR
              (EndPageNo=DestPageNo) AND (EndIndex<DestIndex)) THEN BEGIN
            REPEAT
              PagePtrs[DestPageNo]^[DestIndex]:=PagePtrs[SourcePageNo]^[SourceIndex];
              Inc(DestPageNo,DestIndex,1);
              Inc(SourcePageNo,SourceIndex,1);
              Opd.s2:=Pred(Opd.s2);
            UNTIL Opd.s2=0;
          END ELSE BEGIN
            Inc(SourcePageNo,SourceIndex,Opd.s2);
            Inc(DestPageNo,DestIndex,Opd.s2);
            REPEAT
              Dec(SourcePageNo,SourceIndex,1);
              Dec(DestPageNo,DestIndex,1);
              PagePtrs[DestPageNo]^[DestIndex]:=PagePtrs[SourcePageNo]^[SourceIndex];
              Opd.s2:=Pred(Opd.s2);
            UNTIL Opd.s2=0;
          END
        END
      END
    END
   END; (* BlockCopy *)

  PROCEDURE WriteTextArea;
   VAR SourcePageNo,SourceIndex:Integer;
       Cnt:Integer;
       StartX, StartY:Integer;
       Ch:Char;
   BEGIN
    SplitWord(Opd.s0,SourceIndex,SourcePageNo);
    IF Opd.s1 > 0 THEN BEGIN
      Push(ScreenMode);
      IF (OpdCnt < 2) OR (OpdCnt > 3) THEN BEGIN
        InternalError(IllNumOperands);
      END;
      IF OpdCnt < 3 THEN BEGIN
       Opd.s2:=1;
       OpdCnt:=3;
      END;
      StartX:=CursorX;
      StartY:=CursorY;
      WHILE Opd.s2 > 0 DO BEGIN
       FOR Cnt:=1 TO Opd.s1 DO BEGIN
        Ch:=PagePtrs[SourcePageNo]^[SourceIndex];
        IF Ch < ' ' THEN BEGIN
          InternalError(IllOutputChar);
        END;
        PutChToStoryOutput(Ch);
        Inc(SourcePageNo,SourceIndex,1);
       END;
       Opd.s2:=Pred(Opd.s2);
       IF Opd.s2 > 0 THEN BEGIN
        CursorX:=StartX;
        CursorY:=StartY;
        MoveCursorDown;
        StartX:=CursorX;
        StartY:=CursorY;
       END
      END;
      ScreenMode:=Pop
    END;
   END; (* WriteTextArea *)

  PROCEDURE MinimalNumCallParams;
   BEGIN
    IF OpdCnt <> 1 THEN BEGIN
     InternalError(IllNumOperands);
    END;
    IF Opd.s0<=NumCallParams THEN BEGIN
     HandleTrue;
    END ELSE BEGIN
     HandleFalse;
    END;
   END; (* MinimalNumCallParams *)

  PROCEDURE ExecuteMultipleOperandOperation(NewVersion:Boolean);
   BEGIN
    CASE cOp5(CmdCode) OF
     0(* CFC *):
      Call(Opd.s0, true, Pred(OpdCnt));
     1(* STW *):
      StoreWord;
     2(* STB *):
      StoreByte;
     3(* STP *):
      StoreProperty;
     4(* INP *):
      ZMachineInput;
     5(* WTC *):
      WriteSingleCharacter;
     6(* WTI *):
      WriteInteger;
     7(* RND *):
      ZMachineRandom;
     8(* PSH *):
      Push(Opd.s0);
     9(* PUL *):BEGIN
      AccA:=Pop;
      PutAccA(Opd.s0);
      IF CodeVersion>='6' THEN BEGIN
       DoPutWord(AccA); (* ??? *)
      END;
     END;
     10(* SPL *):
      SplitScreen;
     11(* WND *):
      ChooseWindow;
     12(* CFC *):
      Call(Opd.s0, true, Pred(OpdCnt));
     13(* ERS *):
      EraseArea;
     14(* ERL *):
      IF Opd.s0=1 THEN BEGIN
       ClearToEOL;
      END ELSE BEGIN
       InternalError(IllOperand);
      END;
     15(* GYX *):
      DoGotoXY;
     16(* M16 *):
      InternalError(NotImplemented);
     17(* SCM *):
      ChangeScreenMode;
     18(* FRM *):
      SetFormatMode;
     19(* OUT *):
      SetOutputMode;
     20(* PLY *):
      StartPlayback;
     21(* SND *):
      Sound;
     22(* INK *):
      InputKey;
     23(* BEQ *):
      BlockEqual;
     24(* NEG *):
      DoPutWord(lnot(Opd.s0));
     25(* CPC *):
      Call(Opd.s0, false, Pred(OpdCnt));
     26(* CPC *):
      Call(Opd.s0, false, Pred(OpdCnt));
     27(* PRS *):
      Parse;
     28(* PAK *):
      PackCharacters;
     29(* BCP *):
      BlockCopy;
     30(* WTA *):
      WriteTextArea;
     31(* MNP *):
      MinimalNumCallParams;
    END
   END; (* ExecuteMultipleOperandOperation *)
  
  PROCEDURE ExecuteNewMultipleOperandOperation;

   PROCEDURE LogicalShift;
    BEGIN
     IF OpdCnt <> 2 THEN BEGIN
      InternalError(IllNumOperands);
     END;
     IF Opd.s1>=0 THEN BEGIN
      DoPutWord(lsl(Opd.s0, Opd.s1));
     END ELSE BEGIN
      DoPutWord(lsr(Opd.s0, -Opd.s1));
     END;
    END; (* LogicalShift *)
   
   PROCEDURE ArithmeticShift;
    BEGIN
     IF OpdCnt <> 2 THEN BEGIN
      InternalError(IllNumOperands);
     END;
     IF Opd.s1>=0 THEN BEGIN
      DoPutWord(lsl(Opd.s0, Opd.s1));
     END ELSE BEGIN
      IF Opd.s0>=0 THEN BEGIN
       DoPutWord(lsr(Opd.s0, -Opd.s1));
      END ELSE BEGIN
       DoPutWord(lnot(lsr(lnot(Opd.s0), -Opd.s1)));
      END
     END;
    END; (* ArithmeticShift *)

   PROCEDURE SwitchFont;
    VAR OldFont:Integer;
    BEGIN
     WriteLineBuffer;
     OldFont:=Font;
     IF (Opd.s0<>Font) THEN BEGIN
      IF SwitchToFont(Opd.s0) THEN BEGIN
       Font:=Opd.s0;
      END;
     END;
     DoPutWord(OldFont);
    END; (* SwitchFont *)

   PROCEDURE ClearFlag;
    BEGIN
     InternalError(NotImplemented);
    END; (* ClearFlag *)

   PROCEDURE SetFlag;
    BEGIN
     InternalError(NotImplemented);
    END; (* SetFlag *)

   PROCEDURE TestByteArray;
    BEGIN
     InternalError(NotImplemented);
     HandleFalse;
    END; (* TestByteArray *)

   PROCEDURE SWD;
    BEGIN
     InternalError(NotImplemented);
    END; (* SWD *)

   PROCEDURE UndoSave;
    BEGIN
     DoPutWord(-1);
    END; (* UndoSave *)

   PROCEDURE UndoRestore;
    BEGIN
     DoPutWord(-1);
    END; (* UndoRestore *)

   PROCEDURE X11;
    BEGIN
     InternalError(NotImplemented);
    END; (* X11 *)

   PROCEDURE X12;
    BEGIN
     InternalError(NotImplemented);
    END; (* X12 *)

   PROCEDURE X13;
    BEGIN
     InternalError(NotImplemented);
    END; (* X13 *)

   PROCEDURE X14;
    BEGIN
     InternalError(NotImplemented);
    END; (* X14 *)

   PROCEDURE X15;
    BEGIN
     InternalError(NotImplemented);
    END; (* X15 *)

   PROCEDURE X16;
    BEGIN
     InternalError(NotImplemented);
    END; (* X16 *)

   PROCEDURE X17;
    BEGIN
     InternalError(NotImplemented);
    END; (* X17 *)

   PROCEDURE X18;
    BEGIN
     InternalError(NotImplemented);
    END; (* X18 *)

   PROCEDURE X19;
    BEGIN
     InternalError(NotImplemented);
     DoPutWord(0(* ??? *));
    END; (* X19 *)

   PROCEDURE X20;
    BEGIN
     InternalError(NotImplemented);
    END; (* X20 *)

   PROCEDURE X21;
    BEGIN
     InternalError(NotImplemented);
    END; (* X21 *)

   PROCEDURE X22;
    BEGIN
     InternalError(NotImplemented);
    END; (* X22 *)

   PROCEDURE SetMouseWindow;
    BEGIN
     IF Opd.s0=-1 THEN BEGIN
      (* no restriction *)
     END ELSE BEGIN
      (* restrict mouse to window no. Opd.s0 *)
     END;
    END; (* SetMouseWindow *)

   PROCEDURE X24;
    BEGIN
     InternalError(NotImplemented);
     HandleFalse; (* ??? *)
    END; (* X24 *)

   PROCEDURE X25;
    BEGIN
     InternalError(NotImplemented);
    END; (* X25 *)

   PROCEDURE X26;
    BEGIN
     InternalError(NotImplemented);
    END; (* X26 *)

   PROCEDURE X27;
    BEGIN
     InternalError(NotImplemented);
    END; (* X27 *)

   PROCEDURE X28;
    BEGIN
     InternalError(NotImplemented);
    END; (* X28 *)

   BEGIN (* ExecuteNewMultipleOperandOperation *)
    CASE CmdCode OF
      0(* SVE *):
       IF SavedState THEN BEGIN
        DoPutWord(1);
       END ELSE BEGIN
        DoPutWord(0);
       END;
      1(* RSE *):
       IF RestoredState THEN BEGIN
        DoPutWord(2);
       END ELSE BEGIN
        DoPutWord(0);
       END;
      2(* LSH *):
       LogicalShift;
      3(* ASH *):
       ArithmeticShift;
      4(* FNT *):
       SwitchFont;
      5(* CLR *):
       ClearFlag;
      6(* TSB *):
       TestByteArray;
      7(* SET *):
       SetFlag;
      8(* SWD *):
       SWD;
      9(* X09 *):
       UndoSave;
     10(* X10 *):
       UndoRestore;
     11(* X11 *):
       X11;
     12(* X12 *):
       X12;
     13(* X13 *):
       X13;
     14(* X14 *):
       X14;
     15(* X15 *):
       X15;
     16(* X16 *):
       X16;
     17(* X17 *):
       X17;
     18(* X18 *):
       X18;
     19(* X19 *):
       X19;
     20(* X20 *):
       X20;
     21(* X21 *):
       X21;
     22(* X22 *):
       X22;
     23(* MWD *):
       SetMouseWindow;
     24(* X24 *):
       X24;
     25(* X25 *):
       X25;
     26(* X26 *):
       X26;
     27(* X27 *):
       X27;
     28(* X28 *):
       X28;
     OTHERWISE
       InternalError(NotImplemented);
    END;
   END; (* ExecuteNewMultipleOperandOperations *)
  
  PROCEDURE GetOneOperand;
   BEGIN
    CASE cMode(CmdCode) OF
     0:BEGIN
      Opd.s0:=GetWordIPC
     END;  
     1:BEGIN
      Opd.s0:=GetByteIPC
     END;
     2:
      Opd.s0:=DoGetWord;
    END;
    OpdCnt:=1
   END; (* GetOneOperand *)
  
  PROCEDURE NextObject;
   VAR NextObj:Integer;
       ObjPageNo,ObjPageIndex:Integer;
       LowByte,HighByte:Integer;
   BEGIN
    IF CodeVersion<'4' THEN BEGIN
     CalcObjAdrs(Opd.s0, ObjPageNo, ObjPageIndex, 5, true);
     NextObj:=ExpandByte(PagePtrs[ObjPageNo]^[ObjPageIndex])
    END ELSE BEGIN
     CalcObjAdrs(Opd.s0, ObjPageNo, ObjPageIndex, 8, true);
     HighByte:=ExpandByte(PagePtrs[ObjPageNo]^[ObjPageIndex]);
     Inc(ObjPageNo,ObjPageIndex,1);
     LowByte:=ExpandByte(PagePtrs[ObjPageNo]^[ObjPageIndex]);
     NextObj:=JoinBytes(LowByte,HighByte)
    END;
    DoPutWord(NextObj);
    IF NextObj=0 THEN BEGIN
     HandleFalse;
    END ELSE BEGIN
     HandleTrue;
    END;
   END; (* NextObject *)

  PROCEDURE FirstObject;
   VAR FirstObj:Integer;
       ObjPageNo,ObjPageIndex:Integer;
       LowByte,HighByte:Integer;
   BEGIN
    IF CodeVersion<'4' THEN BEGIN
     CalcObjAdrs(Opd.s0, ObjPageNo, ObjPageIndex, 6, true);
     FirstObj:=ExpandByte(PagePtrs[ObjPageNo]^[ObjPageIndex])
    END ELSE BEGIN
     CalcObjAdrs(Opd.s0, ObjPageNo, ObjPageIndex, 10, true);
     HighByte:=ExpandByte(PagePtrs[ObjPageNo]^[ObjPageIndex]);
     Inc(ObjPageNo,ObjPageIndex,1);
     LowByte:=ExpandByte(PagePtrs[ObjPageNo]^[ObjPageIndex]);
     FirstObj:=JoinBytes(LowByte,HighByte)
    END;
    DoPutWord(FirstObj);
    IF FirstObj=0 THEN BEGIN
     HandleFalse;
    END ELSE BEGIN
     HandleTrue;
    END;
   END; (* FirstObject *)

  PROCEDURE ParentObject;
   VAR ParentObj:Integer;
       ObjPageNo,ObjPageIndex:Integer;
       LowByte,HighByte:Integer;
   BEGIN
    IF CodeVersion<'4' THEN BEGIN
     CalcObjAdrs(Opd.s0, ObjPageNo, ObjPageIndex, 4, true);
     ParentObj:=ExpandByte(PagePtrs[ObjPageNo]^[ObjPageIndex])
    END ELSE BEGIN
     CalcObjAdrs(Opd.s0, ObjPageNo, ObjPageIndex, 6, true);
     HighByte:=ExpandByte(PagePtrs[ObjPageNo]^[ObjPageIndex]);
     Inc(ObjPageNo,ObjPageIndex,1);
     LowByte:=ExpandByte(PagePtrs[ObjPageNo]^[ObjPageIndex]);
     ParentObj:=JoinBytes(LowByte,HighByte)
    END;
    DoPutWord(ParentObj)
   END; (* ParentObject *)

  PROCEDURE LoadPropertySize;
   VAR AddressHigh,AddressIndex:Integer;
   BEGIN
    SplitWord(Pred(Opd.s0),AddressIndex,AddressHigh);
    DoPutWord(GetPropertySize(AddressHigh,AddressIndex,false));
   END; (* LoadPropertySize *)
  
  PROCEDURE WriteObjName;
   VAR NamePageNo,NamePageIndex:Integer;
       NameLength:Integer;
   BEGIN
    CalcObjNameAdrs(Opd.s0, NamePageNo, NamePageIndex, NameLength);
    IF (NameLength>0) THEN BEGIN
     WTX(NamePageNo, NamePageIndex, false);
    END;
   END; (* WriteObjName *)

  PROCEDURE WriteTextIndirect;
   VAR AddressHigh,AddressIndex:Integer;
   BEGIN
    AddressHigh:=0;
    ShiftLeft(AddressHigh,Opd.s0); 
    IF CodeVersion>='4' THEN BEGIN
     ShiftLeft(AddressHigh,Opd.s0);
    END;
    ChkAddress(AddressHigh,Opd.s0);
    WTX(AddressHigh,Opd.s0,false)
   END; (* WriteTextIndirect *)

  PROCEDURE ExecuteOneOperandOperation;
   VAR Op4:Integer;
   BEGIN
    Op4:=cOp4(CmdCode);
    CASE Op4 OF
     0(* EQN *):
      IF Opd.s0=0 THEN BEGIN
       HandleTrue;
      END ELSE BEGIN
       HandleFalse;
      END;
     1(* NXO *):
      NextObject;
     2(* FSO *):
      FirstObject;
     3(* PTO *):
      ParentObject;
     4(* LPS *):
      LoadPropertySize;
     5(* INC *):BEGIN
      GetAccA(Opd.s0); AccA:=Succ(AccA); PutAccA(Opd.s0)
     END;
     6(* DEC *):BEGIN
      GetAccA(Opd.s0); AccA:=Pred(AccA); PutAccA(Opd.s0)
     END;
     7(* WSB *):BEGIN
      SplitWord(Opd.s0,AccC,AccB);
      WTX(AccB,AccC,false)
     END;
     8(* ???/CFC *):
      IF CodeVersion<'4' THEN BEGIN
       InternalError(IllOneOpdOp)
      END ELSE BEGIN
       Call(Opd.s0, true, Pred(OpdCnt));
      END;
     9(* RMO *):
      RemoveObj(Opd.s0);
     10(* WTO *):
      WriteObjName;
     11(* RTN *):
      Return(Opd.s0);
     12(* JMP *):
      CalcJump(IPC_PageNo,IPC_PageIndex,IPC_PageNo,IPC_PageIndex,Opd.s0);
     13(* WT@ *):
      WriteTextIndirect;
     14(* MVE *):BEGIN
      GetAccA(Opd.s0); DoPutWord(AccA)
     END;
     15(* NEG/CPC *):
      IF CodeVersion<'5' THEN BEGIN
       DoPutWord(lnot(Opd.s0));
      END ELSE BEGIN
       Call(Opd.s0, false, Pred(OpdCnt));
      END;
    END (* CASE *)
   END; (* ExecuteOneOperandOperation *)
  
  PROCEDURE GetTwoOperands;
   BEGIN
    IF TstBit(CmdCode,6) THEN BEGIN
     Opd.s0:=DoGetWord;
    END ELSE BEGIN
     Opd.s0:=GetByteIPC;
    END;
    IF TstBit(CmdCode,5) THEN BEGIN
     Opd.s1:=DoGetWord;
    END ELSE BEGIN
     Opd.s1:=GetByteIPC;
    END;
    OpdCnt:=2
   END; (* GetTwoOperands *)
  
  PROCEDURE SetColour;
   BEGIN
    WriteLineBuffer;
    IF (Opd.s0<1) OR (Opd.s0>9) OR (Opd.s1<1) OR (Opd.s0>9) THEN BEGIN
     InternalError(IllColour);
    END;
    SysSetColours(Opd.s0,Opd.s1);
   END; (* SetColour *)
  
  PROCEDURE Unwind;
   BEGIN
    IF Opd.s1>MSP THEN BEGIN
     InternalError(IllMSP);
    END;
    MSP:=Opd.s1;
    Return(Opd.s0)
   END; (* Unwind *)

  PROCEDURE ExecuteTwoOperandOperation;
   LABEL 100,170,180,190;
   VAR EquCnt,AddressHigh,AddressIndex,
       ObjDataPageNo,ObjDataPageIndex:Integer;
       LowByte,HighByte:Integer;
   BEGIN
    CASE cOp5(CmdCode) OF
     0:
      ExecuteBPT(true);
     1(* EQU *):BEGIN
      IF OpdCnt<2 THEN BEGIN
       InternalError(MissingOpd);
      END;
      FOR EquCnt:=1 TO Pred(OpdCnt) DO BEGIN
       IF Opd.s0=Opd.a[EquCnt] THEN BEGIN
        HandleTrue; GOTO 100
       END;
      END;
      HandleFalse;
100: END;
     2(* LES *):
      IF Opd.s0<Opd.s1 THEN BEGIN
       HandleTrue;
      END ELSE BEGIN
       HandleFalse;
      END;
     3(* GRT *):
      IF Opd.s0>Opd.s1 THEN BEGIN
       HandleTrue;
      END ELSE BEGIN
       HandleFalse;
      END;
     4(* DLS *):BEGIN
      GetAccA(Opd.s0);
      AccA:=Pred(AccA);
      PutAccA(Opd.s0);
      IF AccA<Opd.s1 THEN BEGIN
       HandleTrue;
      END ELSE BEGIN
       HandleFalse;
      END;
     END;
     5(* IGT *):BEGIN
      GetAccA(Opd.s0);
      AccA:=Succ(AccA);
      PutAccA(Opd.s0);
      IF AccA>Opd.s1 THEN BEGIN
       HandleTrue;
      END ELSE BEGIN
       HandleFalse;
      END;
     END;
     6(* OIN *):
      IF ObjInObj(Opd.s0,Opd.s1) THEN BEGIN
       HandleTrue;
      END ELSE BEGIN
       HandleFalse;
      END;
     7(* TST *):
      IF land(Opd.s0,Opd.s1)<>Opd.s1 THEN BEGIN
       HandleFalse;
      END ELSE BEGIN
       HandleTrue;
      END;
     8(* LOR *):
      DoPutWord(lor(Opd.s0,Opd.s1));
     9(* AND *):
      DoPutWord(land(Opd.s0,Opd.s1));
     10(* TSF *):
      IF TestFlag(Opd.s0,Opd.s1) THEN BEGIN
       HandleTrue;
      END ELSE BEGIN
       HandleFalse;
      END;
     11(* SEF *):
      SetFlag(Opd.s0,Opd.s1,true);
     12(* CLF *):
      SetFlag(Opd.s0,Opd.s1,false);
     13(* SEW *):BEGIN
      AccA:=Opd.s1; PutAccA(Opd.s0)
     END;
     14(* INS *):
      InsertObj(Opd.s0,Opd.s1);
     15(* LDW *):BEGIN
      SplitWord(Opd.s0,AddressIndex,AddressHigh);
      Inc(AddressHigh,AddressIndex,2*Opd.s1);
      HighByte:=ExpandByte(PagePtrs[AddressHigh]^[AddressIndex]);
      Inc(AddressHigh,AddressIndex,1);
      LowByte:=ExpandByte(PagePtrs[AddressHigh]^[AddressIndex]);
      DoPutWord(JoinBytes(LowByte,HighByte))
     END;
     16(* LDB *):BEGIN
      SplitWord(Opd.s0,AddressIndex,AddressHigh);
      Inc(AddressHigh,AddressIndex,Opd.s1);
      DoPutWord(ExpandByte(PagePtrs[AddressHigh]^[AddressIndex]));
     END;
     17(* LDP *):BEGIN
      GetObjPropertyPtr(Opd.s0,ObjDataPageNo,ObjDataPageIndex);
170:
      AccA:=GetPropertyNo(ObjDataPageNo,ObjDataPageIndex);
      IF AccA>Opd.s1 THEN BEGIN
       Inc(ObjDataPageNo,ObjDataPageIndex,
           Succ(GetPropertySize(ObjDataPageNo,ObjDataPageIndex,true)));
       GOTO 170
      END;
      IF AccA<Opd.s1 THEN BEGIN
       ObjDataPageNo:=ExpandByte(MiscInfo.ObjPageNo);
       ObjDataPageIndex:=ExpandByte(MiscInfo.ObjPageIndex);
       Inc(ObjDataPageNo,ObjDataPageIndex,2*Pred(Opd.s1));
       HighByte:=ExpandByte(PagePtrs[ObjDataPageNo]^[ObjDataPageIndex]);
       Inc(ObjdataPageNo,ObjDataPageIndex,1);
       LowByte:=ExpandByte(PagePtrs[ObjDataPageNo]^[ObjDataPageIndex])
      END
      ELSE BEGIN
       AccA:=GetPropertySize(ObjDataPageNo,ObjDataPageIndex,true);
       Inc(ObjDataPageNo,ObjDataPageIndex,1);
       IF AccA=1 THEN BEGIN
        LowByte:=ExpandByte(PagePtrs[ObjDataPageNo]^[ObjDataPageIndex]);
        HighByte:=0
       END
       ELSE IF AccA=2 THEN BEGIN
        HighByte:=ExpandByte(PagePtrs[ObjDataPageNo]^[ObjDataPageIndex]);
        Inc(ObjDataPageNo,ObjDataPageIndex,1);
        LowByte:=ExpandByte(PagePtrs[ObjDataPageNo]^[ObjDataPageIndex])
       END
       ELSE
        InternalError(IllObjDataLoad)
      END;
      DoPutWord(JoinBytes(LowByte,HighByte))
     END;
     18(* LPA *):BEGIN
      GetObjPropertyPtr(Opd.s0,ObjDataPageNo,ObjDataPageIndex);
180:
      AccA:=GetPropertyNo(ObjDataPageNo,ObjDataPageIndex);
      IF AccA>Opd.s1 THEN BEGIN
       Inc(ObjDataPageNo,ObjDataPageIndex,
           Succ(GetPropertySize(ObjDataPageNo,ObjDataPageIndex,true)));
       GOTO 180
      END;
      IF AccA<Opd.s1 THEN
       DoPutWord(0)
      ELSE BEGIN
       AccA:=GetPropertySize(ObjDataPageNo,ObjDataPageIndex,true);
       DoPutWord(Succ(ObjDataPageNo*256+ObjDataPageIndex))
      END
     END;
     19(* LNP *):BEGIN
      GetObjPropertyPtr(Opd.s0,ObjDataPageNo,ObjDataPageIndex);
      IF Opd.s1=0 THEN
       DoPutWord(GetPropertyNo(ObjDataPageNo,ObjDataPageIndex))
      ELSE BEGIN
190:
       AccA:=GetPropertyNo(ObjDataPageNo,ObjDataPageIndex);
       IF AccA>Opd.s1 THEN BEGIN
        Inc(ObjDataPageNo,ObjDataPageIndex,
            Succ(GetPropertySize(ObjDataPageNo,ObjDataPageIndex,true)));
        GOTO 190
       END;
       IF AccA<Opd.s1 THEN
        DoPutWord(0)
       ELSE BEGIN
        Inc(ObjDataPageNo,ObjDataPageIndex,
            Succ(GetPropertySize(ObjDataPageNo,ObjDataPageIndex,true)));
        DoPutWord(GetPropertyNo(ObjDataPageNo,ObjDataPageIndex))
       END
      END
     END;
     20(* ADD *):
      DoPutWord(Opd.s0+Opd.s1);
     21(* SUB *):
      DoPutWord(Opd.s0-Opd.s1);
     22(* MUL *):
      DoPutWord(Opd.s0*Opd.s1);
     23(* DIV *):
      IF Opd.s1=0 THEN BEGIN
       InternalError(DivideByZero);
      END ELSE BEGIN
       DoPutWord(Opd.s0 DIV Opd.s1);
      END;
     24(* MOD *):
      IF Opd.s1=0 THEN BEGIN
       InternalError(DivideByZero);
      END ELSE BEGIN
       DoPutWord(Opd.s0 MOD Opd.s1);
      END;
     25(* CFC *):
      Call(Opd.s0, true, Pred(OpdCnt));
     26(* CPC *):
      Call(Opd.s0, false, Pred(OpdCnt));
     27(* CLR *):
      SetColour;
     28(* UWI *):
      Unwind;
    END
   END; (* ExecuteTwoOperandOperation *)
  
  PROCEDURE EndOfSession;
   VAR OldPrintListing:Boolean;
   BEGIN
    ZM_NewLine;
    OldPrintListing:=PrintListing;
    PrintListing:=PrinterEnabled;
    PrintString('   *** End of session ***');
    PrintListing:=OldPrintListing;
    ZM_NewLine;
    GOTO 999
   END; (* EndOfSession *)

  PROCEDURE ExecuteNoOperandOperation;
   VAR ChkSum:ShortInteger;
   BEGIN
    CASE cOp4(CmdCode) OF
     0(* RTT *):
      Return(1);
     1(* RTF *):
      Return(0);
     2(* WTX *):
      WTX(IPC_PageNo,IPC_PageIndex,true);
     3(* WTR *):BEGIN
      WTX(IPC_PageNo,IPC_PageIndex,true);
      ZM_NewLine;
      Return(1);
     END;
     4(* NOP *):
      ;
     5(* SVE *):
      IF CodeVersion<'5' THEN BEGIN
       IF SavedState THEN BEGIN
        IF CodeVersion<'4' THEN BEGIN
         HandleTrue;
        END ELSE BEGIN
         DoPutWord(1);
        END;
       END ELSE BEGIN
        IF CodeVersion<'4' THEN BEGIN
         HandleFalse;
        END ELSE BEGIN
         DoPutWord(0);
        END;
       END;
      END;
     6(* RSE *):
      IF CodeVersion<'5' THEN BEGIN
       IF RestoredState THEN BEGIN
        IF CodeVersion<'4' THEN BEGIN
         HandleTrue;
        END ELSE BEGIN
         DoPutWord(2);
        END;
       END ELSE BEGIN
        IF CodeVersion<'4' THEN BEGIN
         HandleFalse;
        END ELSE BEGIN
         DoPutWord(0);
        END;
       END;
      END;
     7(* RST *):BEGIN
      ReloadData;
      ClearScreen;
      ResetZMachine;
      IF CodeVersion<='3' THEN BEGIN
       ScrollTop:=2; ZM_GotoXY(1,ScrollTop);
      END ELSE BEGIN
       ScrollTop:=1;
      END;
      LineNo:=ScrollTop
     END;
     8(* RPL *):BEGIN
      AccA:=Pop; Return(AccA)
     END;
     9(* DSC/MSP *):
      IF CodeVersion<'5' THEN BEGIN
       AccA:=Pop
      END ELSE BEGIN
       DoPutWord(MSP);
      END;
     10(* END *):
      EndOfSession;
     11(* NWL *):
      ZM_NewLine;
     12(* PSL *):
      PrintStatusLine;
     13(* VFY *):
      IF CodeCorrect(Chksum) THEN BEGIN
       HandleTrue;
      END ELSE BEGIN
       HandleFalse;
      END;
     14(* Extensions *):BEGIN
      CmdCode:=GetByteIPC; GetMultipleOperands(false);
      IF CmdCode>=224(* $E0 *) THEN BEGIN
       ExecuteMultipleOperandOperation(true);
      END ELSE IF CmdCode<192(* $C0 *) THEN BEGIN
       ExecuteNewMultipleOperandOperation;
      END ELSE BEGIN
       ExecuteTwoOperandOperation;
      END;
     END;
     15:
    END (* CASE *)
   END; (* ExecuteNoOperandOperation *)
  
  BEGIN (* ExecuteSingleInstruction *)
   ChkAddresses:=true;
   NewInstPageNo:=IPC_PageNo; NewInstPageIndex:=IPC_PageIndex;
   CmdCode:=GetByteIPC;
   IF Statistics THEN BEGIN
    ExecCnt[CmdCode]:=ExecCnt[CmdCode]+1;
   END;
   IF (CmdCode=0) OR NOT Stepping AND (BreakOnOpcode[CmdCode]) THEN BEGIN
    ExecuteBPT(CmdCode=0);
   END ELSE IF CmdCode<128(* $80 *) THEN BEGIN
    GetTwoOperands; ExecuteTwoOperandOperation
   END ELSE IF CmdCode<176(* $B0 *) THEN BEGIN
    GetOneOperand; ExecuteOneOperandOperation
   END ELSE IF CmdCode<192(* $C0 *) THEN BEGIN
    ExecuteNoOperandOperation;
   END ELSE BEGIN
    GetMultipleOperands((CmdCode=236) OR (CmdCode=250));
    IF CmdCode<224(* $E0 *) THEN BEGIN
     ExecuteTwoOperandOperation;
    END ELSE BEGIN
     ExecuteMultipleOperandOperation(false);
    END;
   END;
   InstPageNo:=NewInstPageNo; InstPageIndex:=NewInstPageIndex
  END; (* ExecuteSingleInstruction *)
 
 PROCEDURE ExecuteSubRoutine(Address:Integer);
  VAR Org_PageNo, Org_PageIndex:Integer;
      OrgOpdCnt:Integer;
      OrgOpd:Operands;
      OrgCursorX, OrgCursorY:Integer;
  BEGIN
   OrgCursorX:=CursorX;
   OrgCursorY:=CursorY;
   OrgOpdCnt:=OpdCnt;
   OrgOpd:=Opd;
   Org_PageNo:=IPC_PageNo;
   Org_PageIndex:=IPC_PageIndex;
   IPC_PageNo:=0;
   IPC_PageIndex:=0;
   Call(Address, false, 0);
   REPEAT
    ExecuteSingleInstruction;
   UNTIL (IPC_PageNo=0) AND (IPC_PageIndex=0);
   IPC_PageNo:=Org_PageNo;
   IPC_PageIndex:=Org_PageIndex;
   Opd:=OrgOpd;
   OpdCnt:=OrgOpdCnt;
   CursorY:=OrgCursorY;
   CursorX:=OrgCursorX;
   PositionCursor;
  END; (* ExecuteSubRoutine *)

 PROCEDURE RunCommand(ListState:Boolean; RunCmd:Commands);
  LABEL 0;
  VAR Key:Char;
  BEGIN
   Cmd:=RunCmd;
   FirstInstPageNo:=IPC_PageNo;
   FirstInstPageIndex:=IPC_PageIndex;
   IF EndIPC_PageNo>=0 THEN
    SetBPT(BPT_IdCnt,EndIPC_PageNo,EndIPC_PageIndex,RunBPT);
   IF ListState THEN
    PrintZState;
   RestoreCursorState;
   Running:=true; 0: (*
   LOOP *)
    ExecuteSingleInstruction;
    IF KeyPressed THEN BEGIN
     ReadKey(false, Key, -1, CallNever, 0);
     IF Ord(Key)=BreakKey THEN
      InternalError(KeyboardBreak);
     KeyBuffer[WriteIndex]:=Key; WriteIndex:=Succ(WriteIndex);
     IF WriteIndex>79 THEN
      WriteIndex:=0
    END; GOTO 0 (*
   END *)
  END; (* RunCommand *)
 
 PROCEDURE StepCommand;
  VAR CmdKey:Char;
      InstPageNo,InstPageIndex,LastBPT,OnePageNo,OnePageIndex:Integer;
      Dummy:Integer;
  BEGIN
   LastBPT:=-1; Stepping:=true; Cmd:=Step;
   FirstInstPageNo:=IPC_PageNo; FirstInstPageIndex:=IPC_PageIndex;
   EndIPC_PageNo:=-1; EndIPC_PageIndex:=-1;
   REPEAT
    PrintZState;
    DC_PageNo:=IPC_PageNo; DC_PageIndex:=IPC_PageIndex;
    InstPageNo:=DC_PageNo; InstPageIndex:=DC_PageIndex;
    Disassemble(1, true, false, true);
    OnePageNo:=DC_PageNo; OnePageIndex:=DC_PageIndex;
    REPEAT
     ReadKey(false, CmdKey, -1, CallNever, 0);
     IF (CmdKey>='a') AND (CmdKey<='z') THEN
      CmdKey:=Chr(Ord(CmdKey)-Ord('a')+Ord('A'));
     IF CmdKey='L' THEN BEGIN
      InstPageNo:=DC_PageNo;
      InstPageIndex:=DC_PageIndex;
      Disassemble(1, true, false, true);
     END ELSE IF CmdKey='G' THEN BEGIN
      EndIPC_PageNo:=InstPageNo; EndIPC_PageIndex:=InstPageIndex;
      RunCommand(false, Run)
     END ELSE IF CmdKey='O' THEN BEGIN
      EndIPC_PageNo:=OnePageNo; EndIPC_PageIndex:=OnePageIndex;
      RunCommand(false, Run)
     END ELSE IF CmdKey='T' THEN BEGIN
      Cmd:=SwitchToTrace; GOTO 999
     END ELSE IF CmdKey='X' THEN BEGIN
      Stepping:=false;
      RunCommand(true, Run);
      Stepping:=true;
     END ELSE IF CmdKey='B' THEN BEGIN
      LastBPT:=BPT_IdCnt;
      SetBPT(BPT_IdCnt,InstPageNo,InstPageIndex,UserBPT);
      PrintString('Break-point set at last instruction.'); ChkWait
     END ELSE IF CmdKey='C' THEN BEGIN
      IF LastBPT<0 THEN
       RingBell
      ELSE BEGIN
       ClearBPT(LastBPT); LastBPT:=-1;
       PrintString('Last break-point cleared.'); ChkWait
      END
     END ELSE IF NOT (CmdKey IN [' ',BreakKey,ExitKey]) THEN BEGIN
      RingBell;
      PrintString('sp=step, L=list, T=trace, X=run, G=go last, O=run one, B=set BPT, C=clr BPT');
      ChkWait;
     END
    UNTIL CmdKey IN [' ',BreakKey,ExitKey];
    IF CmdKey=' ' THEN BEGIN
     RestoreCursorState; ExecuteSingleInstruction
    END
   UNTIL CmdKey IN [BreakKey,ExitKey];
   Stepping:=false;
  END; (* StepCommand *)
 
 PROCEDURE TraceCommand;
  LABEL 0;
  VAR Key:Char;
  BEGIN
   Cmd:=Trace;
   FirstInstPageNo:=IPC_PageNo; FirstInstPageIndex:=IPC_PageIndex;
   IF EndIPC_PageNo>=0 THEN
    SetBPT(BPT_IdCnt,EndIPC_PageNo,EndIPC_PageIndex,TraceBPT);
   PrintZState; Tracing:=true; 0: (*
   LOOP *)
    DC_PageNo:=IPC_PageNo; DC_PageIndex:=IPC_PageIndex;
    Disassemble(1, true, false, true);
    RestoreCursorState; ExecuteSingleInstruction;
    PrintZState;
    IF KeyPressed THEN BEGIN
     Key:=ReadKeyWithNoEcho(-1);
     IF (Key>='a') AND (Key<'z') THEN
      Key:=Chr(Ord(Key)-Ord('a')+Ord('A'));
     IF Ord(Key)=BreakKey THEN BEGIN
      ChkWait; GOTO 999
     END;
     IF Key='S' THEN BEGIN
      Cmd:=SwitchToStep; GOTO 999
     END
     ELSE BEGIN
      KeyBuffer[WriteIndex]:=Key; WriteIndex:=Succ(WriteIndex);
      IF WriteIndex>79 THEN
       WriteIndex:=0
     END
    END; GOTO 0; (*
   END; *)
  END; (* TraceCommand *)
 
 PROCEDURE StartZMachine(StartCmd:Commands);
  BEGIN
   ClearScreen;
   IF CodeVersion<='3' THEN BEGIN
    ScrollTop:=2; ZM_GotoXY(1,ScrollTop)
   END ELSE BEGIN
    ScrollTop:=1; ZM_GotoXY(1,ScreenHeight)
   END;
   EndIPC_PageNo:=-1; EndIPC_PageIndex:=-1;
   RunCommand(false, StartCmd)
  END; (* StartZMachine *)

 PROCEDURE CallBacktrace;
  VAR NumLocalVariables,RegCnt,OldSP,WrkMSP,WrkNumCallParams:Integer;
      Discard:Integer;
      WrkRegs:Registers;
  BEGIN
   OldSP:=SP; WrkMSP:=MSP;
   WHILE WrkMSP<>0 DO BEGIN
    SP:=WrkMSP;
    NumLocalVariables:=Pop;
    WrkNumCallParams:=Pop;
    FOR RegCnt:=Pred(NumLocalVariables) DOWNTO 0 DO
     WrkRegs.a[RegCnt]:=Pop;
    Discard:=Pop; Discard:=Pop;
    DC_PageIndex:=Pop; DC_PageNo:=Pop;
    WrkMSP:=Pop;
    Disassemble(1, true, false, true);
   END;
   SP:=OldSP
  END; (* CallBacktrace *)
 
 PROCEDURE EnterSubroutine;
  VAR NumRegsToInit:Integer;
  BEGIN
   NumRegsToInit:=GetByteDC;
   DisRegList(NumRegsToInit, true);
   Disassemble(ScreenHeight-5, true, false, true);
  END; (* EnterSubroutine *)
 
 PROCEDURE DisplayTextData(Alignment:Integer);
  VAR CodePageNo,CodeIndex:Integer;
  BEGIN
   CodePageNo:=DC_PageNo; CodeIndex:=DC_PageIndex;
   BackTxtPageNo:=OldTextPageNo; BackTxtIndex:=OldTextPageIndex;
   DC_PageNo:=TextPageNo; DC_PageIndex:=TextPageIndex;
   OldTextPageNo:=TextPageNo; OldTextPageIndex:=TextPageIndex;
   REPEAT
    IF Alignment>0 THEN BEGIN
     WHILE DC_PageIndex MOD Alignment <> 0 DO BEGIN
      Inc(DC_PageNo,DC_PageIndex,1);
     END;
    END;
    WriteText('T',OntoScreen,FromDC,GlobalTextBuffer,0);
   UNTIL (DC_PageNo>EndPageNo) OR
         (DC_PageNo=EndPageNo) AND (DC_PageIndex>EndPageIndex);
   NewLine;
   TextPageNo:=DC_PageNo; TextPageIndex:=DC_PageIndex;
   DC_PageNo:=CodePageNo; DC_PageIndex:=CodeIndex
  END; (* DisplayTextData *)
 
 PROCEDURE ListMiscInfo;
  VAR ChrCnt:Integer;
      CodeBsePageNo,CodeBsePageIndex:Integer;
      CodeName:aMaxString;
      PageIndex,PageNo:Integer;
      Error:InternalErrors;
  BEGIN
   PrintString('Code type       :'); PrintCh(' ');
   CASE CodeVersion OF
    '1',
    '2',
    '3':CodeName:='Standard';
    '4':CodeName:='Plus';
    '5':CodeName:='X';
    '6':CodeName:='Y';
    OTHERWISE
     CodeName:='Illegal'
   END;
   IF (CodeVersion>='1') AND (CodeVersion<='6') THEN BEGIN
    PrintString(CodeName);
    PrintString(' Development System (');
    PrintCh(CodeVersion);
    PrintCh(')');
   END ELSE BEGIN
    PrintString('Unknown (');
    PrintByte(MiscInfo.CodeType, 2);
    PrintCh(')');
   END;
   ChkWait;
   WITH MiscInfo DO BEGIN
    PrintString('Release         :');
    PrintWord(ReleaseNo, 5);
    ChkWait;
    PrintString('Serialnumber    :');
    PrintCh(' ');
    FOR ChrCnt:=0 TO 5 DO BEGIN
     PrintCh(SerialNumber[ChrCnt]);
    END;
    ChkWait;
    PrintString('Start address   :');
    IF CodeVersion<='5' THEN BEGIN
     PageIndex:=ExpandByte(StartIndex);
     PageNo:=ExpandByte(StartPageNo);
    END ELSE BEGIN
     CalcCallAddress(
      JoinBytes(StartIndex,StartPageNo),
      PageNo, PageIndex);
     Error:=ValidAddress(PageNo,PageIndex);
    END;
    PrintWord(PageNo, 5);
    PrintByte(PageIndex, 2);
    ChkWait;
    PrintString('Vocabulary base :');
    PrintWord(ExpandByte(VocabPageNo), 5);
    PrintByte(ExpandByte(VocabPageIndex), 2);
    ChkWait;
    PrintString('Special base    :');
    PrintWord(ExpandByte(SpecialPageNo), 5);
    PrintByte(ExpandByte(SpecialIndex), 2);
    ChkWait;
    PrintString('Data base       :');
    PrintWord(ExpandByte(DataPageNo), 5);
    PrintByte(ExpandByte(DataPageIndex), 2);
    ChkWait;
    PrintString('Object base     :');
    PrintWord(ExpandByte(ObjPageNo), 5);
    PrintByte(ExpandByte(ObjPageIndex), 2);
    ChkWait;
    CalcCodeBase(CodeBsePageNo, CodeBsePageIndex);
    PrintString('Code base       :');
    PrintWord(ExpandByte(CodeBsePageNo), 5);
    PrintByte(ExpandByte(CodeBsePageIndex), 2);
    ChkWait;
    PrintString('Code end        :');
    PrintWord(CodeEndPageNo, 5);
    PrintByte(CodeEndPageIndex, 2);
    ChkWait;
    PrintString('Code checksum   :');
    PrintByte(ExpandByte(ChkSumHigh), 3);
    PrintByte(ExpandByte(ChkSumLow), 2);
    ChkWait;
    PrintString('Data length     :');
    PrintByte(ExpandByte(NumReadWriteBytesHigh), 3);
    PrintByte(ExpandByte(NumReadWriteBytesLow), 2);
    ChkWait;
    PrintString('Save length     :');
    PrintByte(ExpandByte(SaveStateSizeHigh), 3);
    PrintByte(ExpandByte(SaveStateSizeHigh), 2);
    ChkWait;
   END;
   PrintString('Story file name :');
   PrintCh(' ');
   PrintString(StoryName);
   ChkWait;
  END; (* ListMiscInfo *)
 
 PROCEDURE ClearAllBPTs;
  BEGIN
   BPT_IdCnt:=1; BPT_No:=0;
   WHILE BPT_List<>Nil DO
    ClearBPT(BPT_List^.BPT_No);
   InitBreakOnOpcode;
  END; (* ClearAllBPTs *)

 PROCEDURE LoadStory;
  BEGIN
   ChkWait;
   ClearAllBPTs;
   CodeEndPageNo:=MaxPageNo; ReadPages;
   ResetZMachine; ChkWait;
   EntryIndex:=0;
   FirstObj:=0; LastObj:=0; FirstHigh:=0; LastHigh:=0; RegNo:=0;
   DC_PageNo:=IPC_PageNo; DC_PageIndex:=IPC_PageIndex;
   OldPageNo:=DC_PageNo; OldIndex:=DC_PageIndex;
   BackPageNo:=DC_PageNo; BackIndex:=DC_PageIndex;
   OldIPC_PageNo:=DC_PageNo; OldIPC_PageIndex:=DC_PageIndex;
   BackIPC_PageNo:=DC_PageNo; BackIPC_PageIndex:=DC_PageIndex;
  END; (* LoadStory *)
 
 PROCEDURE VerifyCommand;
  VAR CodeChkSum:ShortInteger;
  BEGIN
   IF CodeCorrect(CodeChkSum) THEN BEGIN
    PrintString('Code ok.')
   END
   ELSE BEGIN
    PrintString('Checksum error:'); PrintWord(CodeChkSum,5)
   END;
   ChkWait
  END; (* VerifyCommand *)
 
 PROCEDURE PreparePrinter;
  BEGIN
   OpenPrinter;
   IF PrinterOpen THEN BEGIN
    PrintListing:=true;
   END;
  END; (* PreparePrinter *)
 
 PROCEDURE DisplayVocabulary(WithPointers:Boolean; DisplayIt:Boolean;
                             VAR VocabEndPageNo:Integer;
                             VAR VocabEndPageIndex:Integer);
  LABEL 777;
  CONST Spacing=4;
  VAR EmptyLine:Boolean;
      OldDC_PageNo,OldDC_PageIndex,WordPageNo,WordIndex,ValuesOffset,
      NumWords,NumSpecial,EntryLength,Cnt,ValueCnt,WordsPerLine:Integer;
      Specs:ARRAY [1..16] OF Integer;
      Values:ARRAY [0..15] OF Integer;
  
  PROCEDURE DisplayHeader;
   VAR SpecialCnt:Integer;
   BEGIN
    PrintString('The vocabulary consists of'); PrintCh(' ');
    PrintInteger(NumWords);
    PrintString(' words and each word requires'); PrintCh(' ');
    PrintInteger(EntryLength); PrintString(' bytes.');
    ChkWait; ChkWait;
    IF NumSpecial=0 THEN
     PrintString('The vocabulary contains no word separators.')
    ELSE BEGIN
     PrintString('Word separators:');
     FOR SpecialCnt:=1 TO NumSpecial DO BEGIN
      PrintCh(' ');
      PrintCh(Chr(Specs[SpecialCnt]))
     END
    END
   END; (* DisplayHeader *)
  
  PROCEDURE DisplayWord;
   VAR ValueCnt,SpaceCnt:Integer;
   BEGIN
    IF WithPointers THEN BEGIN
     PrintByte(WordPageNo,2); PrintByte(WordIndex,2); PrintCh(':'); PrintCh(' ')
    END;
    PrintString(GlobalTextBuffer);
    FOR SpaceCnt:=1 TO Succ(WordNumChars)-Length(GlobalTextBuffer) DO
     PrintCh(' ');
    IF NOT WithPointers THEN
     FOR ValueCnt:=0 TO EntryLength-ValuesOffset DO
      PrintByte(Values[ValueCnt],3);
    FOR SpaceCnt:=1 TO Spacing DO
     PrintCh(' ')
   END; (* DisplayWord *)
  
  BEGIN (* DisplayVocabulary *)
   OldDC_PageNo:=DC_PageNo;
   OldDC_PageIndex:=DC_PageIndex;
   DC_PageNo:=ExpandByte(MiscInfo.VocabPageNo);
   DC_PageIndex:=ExpandByte(MiscInfo.VocabPageIndex);
   NumSpecial:=GetByteDC;
   IF NumSpecial>16 THEN BEGIN
    PrintString('Error: too many word separators'); RingBell; ChkWait;
    GOTO 777
   END;
   FOR Cnt:=1 TO NumSpecial DO BEGIN
    Specs[Cnt]:=GetByteDC;
   END;
   EntryLength:=GetByteDC;
   NumWords:=GetWordDC;
   ValuesOffset:=Succ((WordNumChars DIV 3)*2);
   WordsPerLine:=ScreenWidth DIV
                 (Succ(WordNumChars)+Succ(EntryLength-ValuesOffset)*3
                  +Spacing);
   IF DisplayIt THEN BEGIN
    DisplayHeader;
    ChkWait;
    ChkWait;
   END;
   EmptyLine:=true;
   FOR Cnt:=1 TO NumWords DO BEGIN
    WordPageNo:=DC_PageNo;
    WordIndex:=DC_PageIndex;
    IF DisplayIt THEN BEGIN
     WriteText('V',IntoBuffer,FromDC,GlobalTextBuffer,SizeOf(GlobalTextBuffer)-1);
    END ELSE BEGIN
     WriteText('V',IntoSink,FromDC,GlobalTextBuffer,0);
    END;
    FOR ValueCnt:=0 TO EntryLength-ValuesOffset DO BEGIN
     Values[ValueCnt]:=GetByteDC;
    END;
    IF DisplayIt THEN BEGIN
     DisplayWord;
     EmptyLine:=(Cnt MOD WordsPerLine)=0;
     IF EmptyLine THEN BEGIN
      ChkWait;
     END;
    END;
   END;
   IF DisplayIt THEN BEGIN
    IF NOT EmptyLine THEN BEGIN
     ChkWait;
    END;
    ChkWait;
    PrintString('Vocabulary ends at:');
    PrintWord(DC_PageNo,5);
    PrintByte(DC_PageIndex,2);
    ChkWait;
   END;
   VocabEndPageNo:=DC_PageNo;
   VocabEndPageIndex:=DC_PageIndex;
   DC_PageNo:=OldDC_PageNo;
   DC_PageIndex:=OldDC_PageIndex;
777:
  END; (* DisplayVocabulary *)
 
 FUNCTION FindObject(FirstObj,LastObj:Integer;
                     VAR Name:aMaxString):Integer;
  VAR NamePageNo,NamePageIndex,NameLength:Integer;
      ObjCnt:Integer;
      NotFound:Boolean;
  BEGIN
   ObjCnt:=FirstObj;
   NotFound:=true;
   WHILE NotFound AND (ObjCnt<=LastObj) DO BEGIN
    CalcObjNameAdrs(ObjCnt, NamePageNo, NamePageIndex, NameLength);
    IF (NameLength>0) AND (NameLength<128) THEN BEGIN
     GlobalTextBuffer:='';
     DC_PageNo:=NamePageNo;
     DC_PageIndex:=NamePageIndex;
     WriteText('N', IntoBuffer, FromDC, GlobalTextBuffer,SizeOf(GlobalTextBuffer)-1);
     NameLength:=Length(GlobalTextBuffer);
     IF (NameLength>0) AND (NameLength<128) THEN BEGIN
      NotFound:=(Pos(Name,GlobalTextBuffer)<=0);
     END;
    END;
    ObjCnt:=Succ(ObjCnt)
   END;
   IF NotFound THEN BEGIN
    FindObject:=0;
   END ELSE BEGIN
    FindObject:=Pred(ObjCnt);
   END;
  END; (* FindObject *)
 
 PROCEDURE DispObject(FirstObj,LastObj:Integer; WithProps:Boolean);
  VAR OldDC_PageNo,OldDC_PageIndex,ObjCnt,InsideObj,NextObj,ContainsObj,
      NamePageNo,NameIndex,FlagCnt:Integer;
      NameLength:Integer;
      PropNo,ByteCnt:Integer;
      PropValue,PropCnt,PropSize,Flags1Word,Flags2Word,Flags3Word:Integer;
  BEGIN
   IF (FirstObj<=0) OR (LastObj<=0) THEN BEGIN
    PrintString('No such object.');
    ChkWait;
   END ELSE BEGIN
    OldDC_PageNo:=DC_PageNo; OldDC_PageIndex:=DC_PageIndex;
    FOR ObjCnt:=FirstObj TO LastObj DO BEGIN
     ChkWait;
     CalcObjAdrs(ObjCnt, DC_PageNo, DC_PageIndex, 0, false);
     PrintString( 'ObjNo:');        PrintWord(ObjCnt,4);
     PrintString(' RecAdrs:');      PrintByte(DC_PageNo,2);
                                    PrintByte(DC_PageIndex,2);
     Flags1Word:=GetWordDC; Flags2Word:=GetWordDC;
     IF CodeVersion<'4' THEN BEGIN
      Flags3Word:=0;
      InsideObj:=GetByteDC; NextObj:=GetByteDC; ContainsObj:=GetByteDC;
     END ELSE BEGIN
      Flags3Word:=GetWordDC;
      InsideObj:=GetWordDC; NextObj:=GetWordDC; ContainsObj:=GetWordDC
     END;
     NamePageNo:=GetByteDC; NameIndex:=GetByteDC;
     DC_PageNo:=NamePageNo; DC_PageIndex:=NameIndex;
     NameLength:=GetByteDC;
     PrintString(' PTO:');          PrintWord(InsideObj,4);
     PrintString(' NXO:');          PrintWord(NextObj,4);
     PrintString(' FSO:');          PrintWord(ContainsObj,4);
     PrintString(' NameLen:');      PrintByte(NameLength,2);
     PrintString(' DataPtr:');      PrintByte(NamePageNo,2);
                                         PrintByte(NameIndex,2);
     IF (Flags1Word<>0) OR (Flags2Word<>0) OR (Flags3Word<>0) THEN BEGIN
      ChkWait; PrintString('Flags set:');
      FOR FlagCnt:=0 TO 31+16*Ord(CodeVersion>='4') DO BEGIN
       IF TestFlag(ObjCnt,FlagCnt) THEN BEGIN
        PrintByte(FlagCnt,3);
       END;
      END;
     END;
     ChkWait;
     IF NameLength>0 THEN BEGIN
      WriteText('N',OntoScreen,FromDC,GlobalTextBuffer,0);
     END ELSE BEGIN
      PrintString('<no name>');
      ChkWait;
     END;
     IF WithProps THEN BEGIN
      PropCnt:=0; PropNo:=GetPropertyNo(DC_PageNo,DC_PageIndex);
      WHILE PropNo<>0 DO BEGIN
       IF (PropCnt MOD 6)=0 THEN BEGIN
        IF PropCnt<>0 THEN BEGIN
         ChkWait;
        END;
        PrintCh('D');
        PrintWord(DC_PageNo,5);
        PrintByte(DC_PageIndex,2);
        PrintCh(':');
       END;
       PrintString(' #');
       PrintByte(PropNo,2);
       PropSize:=GetPropertySize(DC_PageNo,DC_PageIndex,true);
       Inc(DC_PageNo,DC_PageIndex,1);
       IF PropSize=1 THEN BEGIN
        PropValue:=GetByteDC;
        PrintByte(PropValue,3)
       END ELSE IF PropSize=2 THEN BEGIN
        PropValue:=GetWordDC;
        PrintWord(PropValue,5)
       END ELSE BEGIN
        PrintCh(' ');
        ByteCnt:=0;
        WHILE ByteCnt<PropSize DO BEGIN
         PropValue:=GetByteDC;
         PrintByte(PropValue,2);
         ByteCnt:=Succ(ByteCnt);
        END;
       END;
       PropCnt:=Succ(PropCnt);
       PropNo:=GetPropertyNo(DC_PageNo,DC_PageIndex)
      END;
      ChkWait;
     END;
    END;
    DC_PageNo:=OldDC_PageNo;
    DC_PageIndex:=OldDC_PageIndex
   END;
  END; (* DispObject *)
 
 PROCEDURE DumpData(DoBytes:Boolean);
  VAR CodePageNo,CodeIndex,ItemCnt,Value:Integer;
      OldWriteDump,FirstLine:Boolean;
  BEGIN
   OldWriteDump:=WriteDump; WriteDump:=false;
   CodePageNo:=DC_PageNo; CodeIndex:=DC_PageIndex;
   BackTxtPageNo:=OldTextPageNo; BackTxtIndex:=OldTextPageIndex;
   DC_PageNo:=TextPageNo; DC_PageIndex:=TextPageIndex;
   OldTextPageNo:=TextPageNo; OldTextPageIndex:=TextPageIndex;
   ItemCnt:=0; Dump:=''; FirstLine:=true;
   REPEAT
    IF ItemCnt MOD 16=0 THEN BEGIN
     IF NOT FirstLine THEN BEGIN
      PrintString(Dump); ChkWait
     END;
     Dump:='D'; WriteCh(Dump,' '); FirstLine:=false; 
     AddWord(Dump,DC_PageNo); AddByte(Dump,DC_PageIndex); WriteCh(Dump,':')
    END;
    IF DoBytes THEN BEGIN
     Value:=GetByteDC; DumpByte(Dump,Value)
    END
    ELSE BEGIN
     Value:=GetWordDC; WriteCh(Dump,' '); AddWord(Dump,Value)
    END;
    ItemCnt:=ItemCnt+(2-Ord(DoBytes))
   UNTIL (DC_PageNo>EndPageNo) OR
         (DC_PageNo=EndPageNo) AND (DC_PageIndex>EndPageIndex);
   PrintString(Dump); ChkWait;
   TextPageNo:=DC_PageNo; TextPageIndex:=DC_PageIndex;
   DC_PageNo:=CodePageNo; DC_PageIndex:=CodeIndex;
   WriteDump:=OldWriteDump
  END; (* DumpData *)
 
 PROCEDURE QuickSort(StartIndex,EndIndex:Integer);
  VAR Left,Right,Pivot,Swap,Shift:Integer;
  BEGIN
   Shift:=IntToCardConst;
   Left:=StartIndex; Right:=EndIndex;
   Pivot:=EntryPoints[(Left+Right) DIV 2]+Shift;
   REPEAT
    WHILE EntryPoints[Left]+Shift<Pivot DO
     Left:=Succ(Left);
    WHILE EntryPoints[Right]+Shift>Pivot DO
     Right:=Pred(Right);
    IF Left<=Right THEN BEGIN
     IF Left<Right THEN BEGIN
      Swap:=EntryPoints[Left];
      EntryPoints[Left]:=EntryPoints[Right];
      EntryPoints[Right]:=Swap
     END;
     Left:=Succ(Left);
     Right:=Pred(Right)
    END
   UNTIL Right<=Left;
   IF StartIndex<Right THEN
    QuickSort(StartIndex,Right);
   IF Left<EndIndex THEN
    QuickSort(Left,EndIndex)
  END; (* QuickSort *)
 
 PROCEDURE DisplayEntryPoints;
  CONST PointsPerLine=10;
  VAR EntryCnt,PageNo,PageIndex,NumOnLine:Integer;
      Error:InternalErrors;
  BEGIN
   IF EntryIndex>1 THEN BEGIN
    QuickSort(0,Pred(EntryIndex));
   END;
   PrintString('Number of entry points:'); PrintWord(EntryIndex,5); ChkWait;
   EntryCnt:=0; NumOnLine:=0;
   WHILE EntryCnt<EntryIndex DO BEGIN
    PageNo:=0; PageIndex:=EntryPoints[EntryCnt];
    CalcCallAddress(EntryPoints[EntryCnt],PageNo,PageIndex);
    Error:=ValidAddress(PageNo,PageIndex);
    PrintWord(PageNo,5);
    PrintByte(PageIndex,2);
    NumOnLine:=Succ(NumOnLine);
    IF NumOnLine=PointsPerLine THEN BEGIN
     ChkWait; NumOnLine:=0;
    END;
    EntryCnt:=Succ(EntryCnt);
   END;
   IF NumOnLine<>0 THEN BEGIN
    ChkWait;
   END;
  END; (* DisplayEntryPoints *)
  
 PROCEDURE ListCommands;
  BEGIN
   ChkWait;
   PrintString('NewCmd        = N <StoryFileName>');
   ChkWait;
   PrintString('ExecutionCmd  = ( S|X|A ) [P] <AddressRange>');
   ChkWait;
   PrintString('BPT_Cmd       = B[P] | B(S|C) <Address> [<Number>] | BO(S|C) <opcode> | B[O]Z');
   ChkWait;
   PrintString('EntryPointCmd = E [C|D|N|Y]');
   ChkWait;
   PrintString('SimpleCmd     = Q | ? | H | $ | I[P][M|S] | V[P|A] | C[P] | R[P] <regno>');
   ChkWait;
   PrintString('              | Z [P] [S|I|R|X]');
   ChkWait;
   PrintString('OptionCmd     = D ( (C|T|U|N) | ( (B|F||I|K|O|R|S|V) (Y|N|T|F) ) )');
   ChkWait;
   PrintString('ObjCmd        = O [P] ( <AddressRange> | "<string>" [, <Address>] ) [#]');
   ChkWait;
   PrintString('ListCmd       = ( L | G | T ) [P] <AddressRange>');
   ChkWait;
   PrintString('MemoryCmd     = ( M | W ) ( W | B ) [P] <AddressRange> {, <Number>}');
   ChkWait;
   PrintString('AddressRange  = [<Address> [. <Address>]]');
   ChkWait;
   PrintString('Address       = [&] [*] <Number> [W|Q|G] | ~ | ^ | @');
   ChkWait;
   PrintString('Number        = <Hexdigit> {<Hexdigit>}'); ChkWait
  END; (* ListCommands *)
 
 PROCEDURE LineInterpreter{VAR Cmd:Commands; VAR CmdLine:aMaxString};
  LABEL 666;
  VAR WrkCh:Char;
      Index,UnusedHigh,UnusedLow,Alignment:Integer;
      NewAdvOk:Boolean;
      HexDigits:SET OF Char;
  
  PROCEDURE GetCh(Capitalize:Boolean);
   BEGIN
    IF Index<Length(CmdLine) THEN BEGIN
     Index:=Succ(Index);
     WrkCh:=CmdLine[Index];
     WHILE (WrkCh=' ') AND Capitalize DO BEGIN
      GetCh(true);
     END;
     IF (WrkCh>='a') AND (WrkCh<='z') AND Capitalize THEN BEGIN
      WrkCh:=Chr(Ord(WrkCh)-Ord('a')+Ord('A'));
     END;
    END ELSE BEGIN
     WrkCh:=EOL;
    END
   END; (* GetCh *)
  
  PROCEDURE GetAddress(VAR PageNo,PageIndex:Integer; 
                       OldPageNo,OldIndex,BackPageNo,BackIndex:Integer);
   VAR ChCnt:Integer;
       DataRelative,Indirect:Boolean;
       Page2No,Page2Index:Integer;
       AddrString,AddrPart:anAddrString;
   BEGIN
    IF (WrkCh='~') OR (WrkCh='/') THEN BEGIN
     PageNo:=OldPageNo; PageIndex:=OldIndex; GetCh(true)
    END ELSE IF (WrkCh='^') OR (WrkCh='<') THEN BEGIN
     PageNo:=BackPageNo; PageIndex:=BackIndex; GetCh(true)
    END ELSE IF WrkCh='@' THEN BEGIN
     CalcStartAddress(PageNo,PageIndex);
     GetCh(true);
    END ELSE IF WrkCh IN HexDigits+['*','&'] THEN BEGIN
     Indirect:=(WrkCh='&');
     IF Indirect THEN
      GetCh(true);
     DataRelative:=(WrkCh='*');
     IF DataRelative THEN
      GetCh(true);
     AddrString:=''; ChCnt:=0;
     WHILE WrkCh IN HexDigits DO BEGIN
      ChCnt:=Succ(ChCnt); AddrString[ChCnt]:=WrkCh; GetCh(true)
     END;
     SetLength(AddrString,ChCnt);
     WHILE Length(AddrString)<6 DO
      Insert('0',AddrString,1);
     AddrPart:=Copy(AddrString,1,4);
     StringToNumber(PageNo,AddrPart);
     AddrPart:=Copy(AddrString,5,2);
     StringToNumber(PageIndex,AddrPart);
     IF DataRelative THEN BEGIN
      PageIndex:=PageIndex+ExpandByte(MiscInfo.DataPageIndex);
      PageNo:=PageNo+ExpandByte(MiscInfo.DataPageNo);
      ChkAddress(PageNo,PageIndex)
     END;
     IF Indirect THEN BEGIN
      Push(DC_PageNo); Push(DC_PageIndex);
      DC_PageNo:=PageNo; DC_PageIndex:=PageIndex;
      PageNo:=GetByteDC; PageIndex:=GetByteDC;
      DC_PageIndex:=Pop; DC_PageNo:=Pop
     END;
     IF WrkCh='W' THEN BEGIN
      GetCh(true); PageNo:=2*PageNo; PageIndex:=2*PageIndex;
      ChkAddress(PageNo,PageIndex);
     END ELSE IF WrkCh='Q' THEN BEGIN
      GetCh(true); PageNo:=4*PageNo; PageIndex:=4*PageIndex;
      ChkAddress(PageNo,PageIndex);
     END ELSE IF WrkCh='G' THEN BEGIN
      GetCh(true);
      CalcCallAddress(JoinBytes(PageIndex,PageNo),PageNo,PageIndex);
      ChkAddress(PageNo,PageIndex);
     END
    END ELSE BEGIN
     PageNo:=OldPageNo; PageIndex:=OldIndex;
    END;
    IF WrkCh='+' THEN BEGIN
     GetCh(true);
     GetAddress(Page2No,Page2Index,OldPageNo,OldIndex,BackPageNo,BackIndex);
     PageNo:=PageNo+Page2No;
     PageIndex:=PageIndex+Page2Index;
     ChkAddress(PageNo,PageIndex);
    END;
   END; (* GetAddress *)
  
  PROCEDURE GetRange(VAR StartPageNo,StartIndex,EndPageNo,EndPageIndex:Integer;
                     OldPageNo,OldIndex,BackPageNo,BackIndex:Integer);
   BEGIN
    IF WrkCh IN HexDigits+['*','&','@','~','^','/','<'] THEN BEGIN
     GetAddress(StartPageNo,StartIndex,
                OldPageNo,OldIndex,BackPageNo,BackIndex);
     IF WrkCh='.' THEN BEGIN
      GetCh(true);
      IF WrkCh='.' THEN
       GetCh(true);
      GetAddress(EndPageNo,EndPageIndex,
                 OldPageNo,OldIndex,BackPageNo,BackIndex)
     END
     ELSE BEGIN
      EndPageNo:=-1; EndPageIndex:=-1
     END
    END
   END; (* GetRange *)
  
  PROCEDURE GetString(VAR theString:aMaxString;
                      SpacesAllowed:Boolean; Terminators:CharSet);
   VAR ChrCnt:Integer;
   BEGIN
    theString:=''; ChrCnt:=0;
    WHILE NOT (WrkCh IN Terminators) DO BEGIN
     IF (WrkCh<>' ') OR SpacesAllowed THEN BEGIN
      ChrCnt:=Succ(ChrCnt);
      SetLength(theString,ChrCnt); theString[ChrCnt]:=WrkCh
     END;
     GetCh(false)
    END;
    GetCh(true)
   END; (* GetString *)
  
  PROCEDURE SetDumpState(DumpChr:Char);
   VAR ToValue:Boolean;
   BEGIN
    IF DumpChr IN ['B','I','K','R','S','V','F','O'] THEN BEGIN
     GetCh(true);
     IF WrkCh IN ['Y','T'] THEN BEGIN
      ToValue:=true;
     END ELSE IF WrkCh IN ['N','F'] THEN BEGIN
      ToValue:=false;
     END ELSE BEGIN
      HandleError(false,
       'Y, N, T or F expected after switch character.', false);
     END;
    END;
    CASE DumpChr OF
     'B':
      DisBPTs:=ToValue;
     'C':
      GlobalDumpState:=CodeDump;
     'F':
      FaultNotImplemented:=ToValue;
     'I':
      DisWithNames:=ToValue;
     'K':
      CrashInternal:=ToValue;
     'N':
      GlobalDumpState:=NoDump;
     'O':
      RestartOperations:=ToValue;
     'R':
      TryRegList:=ToValue;
     'S':BEGIN
      IF NOT Statistics AND ToValue THEN BEGIN
       InitExecCnt;
      END;
      Statistics:=ToValue
     END;
     'T':
      GlobalDumpState:=TextDump;
     'U':
      GlobalDumpState:=UnpackedDump;
     'V':
      DebugVocab:=ToValue;
     OTHERWISE
      RingBell
    END;
    WriteDump:=GlobalDumpState>NoDump;
   END; (* SetDumpState *)
  
  PROCEDURE ModifyData(DoBytes:Boolean; ModPageNo,ModPageIndex:Integer);
   VAR High,Low:Integer;
   BEGIN
    GetCh(true); High:=0; Low:=0;
    WHILE WrkCh IN ['*','&','~','^','0'..'9','A'..'Z',' ',','] DO BEGIN
     IF WrkCh=',' THEN
      GetCh(true);
     GetAddress(High,Low,High,Low,High,Low);
     IF NOT DoBytes THEN BEGIN
      PrintWord(ModPageNo,4); PrintByte(ModPageIndex,2); PrintCh(':');
      PrintByte(High,3); ChkWait;
      PagePtrs[ModPageNo]^[ModPageIndex]:=High;
      Inc(ModPageNo,ModPageIndex,1)
     END;
     PrintWord(ModPageNo,4); PrintByte(ModPageIndex,2); PrintCh(':');
     PrintByte(Low,3); ChkWait;
     PagePtrs[ModPageNo]^[ModPageIndex]:=Low;
     Inc(ModPageNo,ModPageIndex,1)
    END
   END; (* ModifyData *)
  
  PROCEDURE HandleListObject;
   VAR OldHigh,OldLow,BackHigh,BackLow:Integer;
       WithProps:Boolean;
       ObjectName:aMaxString;
   BEGIN
    REPEAT
     IF WrkCh=',' THEN BEGIN
      GetCh(true);
     END;
     OldHigh:=FirstHigh; OldLow:=FirstObj;
     BackHigh:=FirstHigh; BackLow:=FirstObj;
     IF (BackHigh>0) OR (BackLow>0) THEN BEGIN
      Inc(BackHigh,BackLow,-1);
     END;
     Inc(FirstHigh,FirstObj,1);
     IF WrkCh='"' THEN BEGIN
      GetCh(false);
      GetString(ObjectName,true,['"',EOL]);
      IF WrkCh=',' THEN BEGIN
       GetCh(true);
      END;
      GetAddress(LastHigh,LastObj,OldHigh,OldLow,BackHigh,BackLow);
      LastObj:=LastHigh*256+LastObj;
      IF WrkCh='#' THEN BEGIN
       GetCh(true);
       WithProps:=true;
      END ELSE BEGIN
       WithProps:=false;
      END;
      FirstObj:=1;
      IF LastObj<FirstObj THEN BEGIN
       LastObj:=1024;
      END;
      REPEAT
       FirstObj:=FindObject(FirstObj,LastObj,ObjectName);
       IF (FirstObj>0) THEN BEGIN
        DispObject(FirstObj, FirstObj, WithProps);
        FirstObj:=Succ(FirstObj);
       END;
      UNTIL (FirstObj<=0) OR (FirstObj>LastObj);
     END ELSE BEGIN
      GetRange(FirstHigh,FirstObj,LastHigh,LastObj,
               OldHigh,OldLow,BackHigh,BackLow);
      FirstObj:=FirstHigh*256+FirstObj;
      LastObj:=LastHigh*256+LastObj;
      IF LastObj<0 THEN BEGIN
       LastObj:=FirstObj;
      END;
      IF WrkCh='#' THEN BEGIN
       GetCh(true);
       WithProps:=true;
      END ELSE BEGIN
       WithProps:=false;
      END;
      DispObject(FirstObj, LastObj, WithProps);
     END;
    UNTIL WrkCh<>','
   END; (* HandleListObject *)
  
  PROCEDURE HandleListEntryPoints;
   VAR EntryPageNo,EntryIdx:Integer;
   BEGIN
    IF WrkCh='C' THEN BEGIN
     EntryIndex:=0;
    END ELSE IF WrkCh='D' THEN BEGIN
     REPEAT
      GetCh(true);
      GetAddress(EntryPageNo,EntryIdx,EntryPageNo,EntryIdx,
                 EntryPageNo,EntryIdx);
      RemoveEntry(EntryPageNo,EntryIdx);
     UNTIL WrkCh<>',';
    END ELSE IF WrkCh='Y' THEN BEGIN
     SaveEntryPoints:=true;
    END ELSE IF WrkCh='N' THEN BEGIN
     SaveEntryPoints:=false;
    END ELSE BEGIN
     DisplayEntryPoints;
    END
   END; (* HandleListEntryPoints *)
  
  PROCEDURE HandleZState;
   BEGIN
    IF WrkCh='I' THEN BEGIN
     ResetZMachine; PrintZState
    END
    ELSE IF WrkCh='R' THEN BEGIN
     ReloadData; ResetZMachine; PrintZState
    END
    ELSE IF WrkCh='X' THEN BEGIN
     ReloadData; ResetZMachine; StartZMachine(Run);
    END
    ELSE IF WrkCh='S' THEN
     PrintZState
    ELSE
     RingBell
   END; (* HandleZState *)
  
  PROCEDURE ListStatistics;
   VAR Index,SpaceCnt,StartX:Integer;
       Cnts:CountArray;
       Cdes:CountArray;
   
   PROCEDURE QuickSort(StartIndex,EndIndex:Integer);
    VAR Left,Right,Pivot,Swap:Integer;
    BEGIN
     Left:=StartIndex; Right:=EndIndex;
     Pivot:=Cnts[(Left+Right) DIV 2];
     REPEAT
      WHILE Cnts[Left]<Pivot DO
       Left:=Succ(Left);
      WHILE Cnts[Right]>Pivot DO
       Right:=Pred(Right);
      IF Left<=Right THEN BEGIN
       IF Left<Right THEN BEGIN
        Swap:=Cnts[Left]; Cnts[Left]:=Cnts[Right]; Cnts[Right]:=Swap;
        Swap:=Cdes[Left]; Cdes[Left]:=Cdes[Right]; Cdes[Right]:=Swap
       END;
       Left:=Succ(Left);
       Right:=Pred(Right)
      END
     UNTIL Right<=Left;
     IF StartIndex<Right THEN
      QuickSort(StartIndex,Right);
     IF Left<EndIndex THEN
      QuickSort(Left,EndIndex)
    END; (* QuickSort *)
   
   BEGIN
    Cnts:=ExecCnt;
    FOR Index:=0 TO 255 DO
     Cdes[Index]:=Index;
    QuickSort(0,255);
    FOR Index:=255 DOWNTO 0 DO BEGIN
     IF Cnts[Index]>0 THEN BEGIN
      StartX:=CursorX; PrintInteger(Cnts[Index]);
      FOR SpaceCnt:=1 TO 7-(CursorX-StartX) DO
       PrintCh(' ');
      CmdCode:=Cdes[Index];
      Disassemble(1, false, false, true);
     END
    END
   END; (* ListStatistics *)
  
  PROCEDURE ScanCommand;
   BEGIN
    SaveEntryPoints:=true;
    IF CodeVersion<='5' THEN BEGIN
     DisplayVocabulary(false, false,
      CodeBegPageNo, CodeBegPageIndex);
    END ELSE BEGIN
     CalcCodeBase(CodeBegPageNo, CodeBegPageIndex);
    END;
    DC_PageNo:=CodeBegPageNo;
    DC_PageIndex:=CodeBegPageIndex;
    EndPageNo:=CodeEndPageNo;
    EndPageIndex:=CodeEndPageIndex;
    Disassemble(1, true, CodeVersion>='6', false);
    ChkWait;
    IF EntryIndex>0 THEN BEGIN
     CalcCallAddress(EntryPoints[0], DC_PageNo, DC_PageIndex);
     EndPageNo:=CodeEndPageNo;
     EndPageIndex:=CodeEndPageIndex;
     Disassemble(1, true, true, false);
     ChkWait;
    END;
   END; (* ScanCommand *)
  
  BEGIN (* LineInterpreter *)
   HexDigits:=['0'..'9','A'..'F']; Index:=0;
   REPEAT
    Cmd:=Nothing; EndPageNo:=-1; EndPageIndex:=-1;
    EndIPC_PageNo:=-1; EndIPC_PageIndex:=-1; GetCh(true);
    IF WrkCh<>EOL THEN BEGIN
     CASE WrkCh OF
      'W':BEGIN
       GetCh(true);
       IF WrkCh='W' THEN
        Cmd:=DumpWords
       ELSE IF WrkCh='B' THEN
        Cmd:=cDumpBytes
       ELSE
        Cmd:=Nothing
      END;
      'M':BEGIN
       GetCh(true);
       IF WrkCh='W' THEN
        Cmd:=ModifyWords
       ELSE IF WrkCh='B' THEN
        Cmd:=ModifyBytes
      END;
      'A':
       Cmd:=Trace;
      'B':
       Cmd:=BPT_Cmd;
      'C':
       Cmd:=ListCalls;
      'D':
       Cmd:=DumpOption;
      'E':
       Cmd:=ListEntryPoints;
      'G':
       Cmd:=GoSub;
      'H','?':
       Cmd:=Help;
      'I':
       Cmd:=Info;
      'L':
       Cmd:=List;
      'N':
       Cmd:=NewAdv;
      'O':
       Cmd:=ListObject;
      'R':
       Cmd:=ListReg;
      'Q':
       Cmd:=Quit;
      'S':
       Cmd:=Step;
      'T':
       Cmd:=TextList;
      'V':
       Cmd:=ListVocabulary;
      'X':
       Cmd:=Run;
      '$':
       Cmd:=VerifyCode;
      'Y':
       Cmd:=ScanCode;
      'Z':
       Cmd:=ListZState;
      OTHERWISE
       Cmd:=Nothing;
     END;
     GetCh(Cmd<>NewAdv);
     PrintListing:=false;
     IF Cmd IN [List,TextList,GoSub,ListEntryPoints,ListObject,ListVocabulary,
                cDumpBytes,DumpWords,Info,ListZState,ListReg,Step,Trace,Run,
                BPT_Cmd,ModifyBytes,ModifyWords,Help,ListCalls] THEN BEGIN
      IF WrkCh='P' THEN BEGIN
       PreparePrinter; GetCh(true)
      END
     END;
     IF Cmd=Nothing THEN
      RingBell
    END;
    IF PageCnt=0 THEN
     IF NOT (Cmd IN [NewAdv,DumpOption,Help,Quit]) THEN BEGIN
      PrintString('No story loaded.'); RingBell; ChkWait; GOTO 666
     END;
    CASE Cmd OF
     Quit:
      ;
     ListZState:
      HandleZState;
     ListReg:BEGIN
      GetAddress(UnusedHigh,RegNo,UnusedHigh,RegNo,UnusedHigh,Pred(RegNo));
      PrintReg(RegNo); ChkWait
     END;
     ScanCode:
      ScanCommand;
     VerifyCode:
      VerifyCommand;
     NewAdv:BEGIN
      NewAdvOk:=false;
      GetString(StoryName,false,[EOL]);
      IF (Length(StoryName)=0) OR IsDirectory(StoryName) THEN
       StoryName:=Concat(StoryName,'story.dat');
      NewAdvOk:=true; LoadStory
     END;
     Info:
      IF WrkCh='S' THEN
       ListStatistics
      ELSE
       ListMiscInfo;
     ListCalls:
      CallBacktrace;
     ListVocabulary:
      DisplayVocabulary(WrkCh='A', true, UnusedHigh, UnusedLow);
     DumpOption:BEGIN
      REPEAT
       IF WrkCh=',' THEN
        GetCh(true);
       SetDumpState(WrkCh); GetCh(true)
      UNTIL WrkCh<>','
     END;
     Help:
      ListCommands;
     cDumpBytes,DumpWords,ModifyWords,ModifyBytes:BEGIN
      REPEAT
       IF WrkCh=',' THEN
        GetCh(true);
       GetRange(TextPageNo,TextPageIndex,EndPageNo,EndPageIndex,
                OldTextPageNo,OldTextPageIndex,BackTxtPageNo,BackTxtIndex);
       IF Cmd IN [ModifyWords,ModifyBytes] THEN
        ModifyData(Cmd=ModifyBytes,TextPageNo,TextPageIndex)
       ELSE
        DumpData(Cmd=cDumpBytes)
      UNTIL WrkCh<>','
     END;
     List:BEGIN
      REPEAT
       IF WrkCh=',' THEN
        GetCh(true);
       GetRange(DC_PageNo,DC_PageIndex,EndPageNo,EndPageIndex,
                OldPageNo,OldIndex,BackPageNo,BackIndex);
       Disassemble(ScreenHeight-5, true, false, true);
      UNTIL WrkCh<>','
     END;
     Step:BEGIN
      GetRange(IPC_PageNo,IPC_PageIndex,EndIPC_PageNo,EndIPC_PageIndex,
               OldIPC_PageNo,OldIPC_PageIndex,
               BackIPC_PageNo,BackIPC_PageIndex);
      StepCommand
     END;
     Trace:BEGIN
      GetRange(IPC_PageNo,IPC_PageIndex,EndIPC_PageNo,EndIPC_PageIndex,
               OldIPC_PageNo,OldIPC_PageIndex,
               BackIPC_PageNo,BackIPC_PageIndex);
      TraceCommand
     END;
     Run:BEGIN
      GetRange(IPC_PageNo,IPC_PageIndex,EndIPC_PageNo,EndIPC_PageIndex,
               OldIPC_PageNo,OldIPC_PageIndex,
               BackIPC_PageNo,BackIPC_PageIndex);
      RunCommand(true, Run)
     END;
     BPT_Cmd:BEGIN
      IF WrkCh='Z' THEN BEGIN
       GetCh(true);
       ClearAllBPTs;
      END ELSE IF WrkCh='S' THEN BEGIN
       GetCh(true);
       BPT_PageNo:=IPC_PageNo; BPT_PageIndex:=IPC_PageIndex;
       GetAddress(BPT_PageNo,BPT_PageIndex,OldIPC_PageNo,OldIPC_PageIndex,
                  BackIPC_PageNo,BackIPC_PageIndex);
       BPT_No:=BPT_IdCnt;
       GetAddress(UnusedHigh,BPT_No,UnusedHigh,BPT_No,UnusedHigh,BPT_No);
       SetBPT(BPT_No,BPT_PageNo,BPT_PageIndex,UserBPT)
      END ELSE IF WrkCh='C' THEN BEGIN
       GetCh(true);
       GetAddress(UnusedHigh,BPT_No,UnusedHigh,BPT_No,
                  UnusedHigh,Pred(BPT_No));
       ClearBPT(BPT_No);
      END ELSE IF WrkCh='O' THEN BEGIN
       GetCh(true);
       IF WrkCh='Z' THEN BEGIN
        GetCh(true);
        InitBreakOnOpcode;
       END ELSE IF WrkCh='C' THEN BEGIN
        GetCh(true);
        GetAddress(UnusedHigh,BPT_No,0,0,0,0);
        IF (BPT_No>=0) AND (BPT_No<=255) THEN BEGIN
         BreakOnOpcode[BPT_No]:=false;
        END;
       END ELSE IF WrkCh='S' THEN BEGIN
        GetCh(true);
        GetAddress(UnusedHigh,BPT_No,0,0,0,0);
        IF (BPT_No>=0) AND (BPT_No<=255) THEN BEGIN
         BreakOnOpcode[BPT_No]:=true;
        END;
       END ELSE BEGIN
        RingBell;
       END;
      END ELSE BEGIN
       PrintBPTs;
      END;
     END;
     TextList:BEGIN
      REPEAT
       IF WrkCh=',' THEN BEGIN
        GetCh(true);
       END;
       IF WrkCh='W' THEN BEGIN
        Alignment:=2;
        GetCh(true);
       END ELSE IF WrkCh='Q' THEN BEGIN
        Alignment:=4;
        GetCh(true);
       END ELSE IF WrkCh='G' THEN BEGIN
        IF CodeVersion>='4' THEN BEGIN
         Alignment:=4;
        END ELSE BEGIN
         Alignment:=2;
        END;
        GetCh(true);
       END ELSE BEGIN
        Alignment:=0;
       END;
       GetRange(TextPageNo,TextPageIndex,EndPageNo,EndPageIndex,
                OldTextPageNo,OldTextPageIndex,BackTxtPageNo,BackTxtIndex);
       DisplayTextData(Alignment);
      UNTIL WrkCh<>',';
     END;
     GoSub:BEGIN
      REPEAT
       IF WrkCh=',' THEN
        GetCh(true);
       GetRange(DC_PageNo,DC_PageIndex,EndPageNo,EndPageIndex,
                OldPageNo,OldIndex,BackPageNo,BackIndex);
       EnterSubroutine
      UNTIL WrkCh<>','
     END;
     ListEntryPoints:
      HandleListEntryPoints;
     ListObject:
      HandleListObject;
     OTHERWISE
      ;
    END
   UNTIL WrkCh=EOL;
666:
  END; (* LineInterpreter *)
 
 PROCEDURE Initialize;
  VAR Cnt:Integer;
  BEGIN
   InitSystem;
   FOR Cnt:=0 TO MaxPageNo DO BEGIN
    PagePtrs[Cnt]:=Nil;
    DataPagePtrs[Cnt]:=Nil;
   END;
   ExitKey:=ESC;
   WaitKey:=Ctrl_S;
   BreakKey:=Chr(2);
   PrinterTried:=false;
   PrinterOpen:=false;
   PrintListing:=false;
   ChkAddresses:=false;
   InitScreen; InStory:=false;
   SetLength(Spaces,255);
   FOR Cnt:=1 TO 255 DO
    Spaces[Cnt]:=' ';
   HexChars:='0123456789ABCDEF';
   TerminatorSet:=['!','?',',','.',' '];
   WordNumChars:=6;
   Char1Table:= '0123456789.,!?_#''"/\|-:()';
   Char1Set:=['0'..'9','.',',','!','?','_','#','''','"','/','\','|','-',':',
              '(',')'];
   Char23Table:='0123456789.,!?_#''"/\-:()';
   Char23Set:=['0'..'9','.',',','!','?','_','#','''','"','/','\','-',':',
               '(',')'];
   CmpShift:=0 (* Pred(-MaxInt) *);
   Randomize;
   WriteIndex:=0; ReadIndex:=WriteIndex;
   PrintListing:=false;
   PrintString('Infocom Interactive Fiction Debugger       Version [');
   PrintCh(HexChars[Succ(InterpreterNumber DIV 10)]);
   PrintCh('.');
   PrintCh(HexChars[Succ(InterpreterNumber MOD 10)]);
   PrintCh(InterpreterChar);
   PrintCh(']'); PrintCh(' '); PrintCh(' ');
   PrintString(Date);
   ChkWait; ChkWait;
   PrintString('Written by Frank Lancaster during 1984-1994, Bonn, Germany.');
   ChkWait; ChkWait;
   PrintString('This programme is free. You may do anything with it.');
   ChkWait; ChkWait;
   PageCnt:=0;
   GlobalDumpState:=NoDump;
   WriteDump:=false;
   Statistics:=false;
   DisBPTs:=false;
   DisWithNames:=true;
   RestartOperations:=true;
   ChkLineChars:=false;
   Opd.s0:=0; Opd.s1:=0; Opd.s2:=0; Opd.s3:=0;
   Opd.s4:=0; Opd.s5:=0; Opd.s6:=0; Opd.s7:=0;
   R.r0:=0; R.r1:=0; R.r2:=0; R.r3:=0;
   R.r4:=0; R.r5:=0; R.r6:=0; R.r7:=0;
   R.r8:=0; R.r9:=0; R.r10:=0; R.r11:=0;
   R.r12:=0; R.r13:=0; R.r14:=0; R.r15:=0;
   TryRegList:=true; SaveEntryPoints:=true;
   CrashInternal:=false;
   FaultNotImplemented:=true;
   DebugVocab:=false;
   TextPageNo:=-1; TextPageIndex:=-1;
   OldTextPageNo:=-1; OldTextPageIndex:=-1;
   BackTxtPageNo:=-1; BackTxtIndex:=-1;
   EndPageNo:=-1; EndPageIndex:=-1; EntryIndex:=0;
   BPT_List:=Nil; StoryCursorX:=0; StoryCursorY:=0;
   InitExecCnt;
   InitBreakOnOpcode;
  END; (* Initialize *)
 
 PROCEDURE HandleError{WriteLastInst:Boolean; Message:aMaxString;
                       Crash:Boolean};
  VAR NilPtr:^Integer;
  BEGIN
   SaveCursorState;
   RingBell; PrintString('Error:'); PrintCh(' '); PrintString(Message); ChkWait;
   IF Crash THEN BEGIN
    NilPtr:=Nil; NilPtr^:=NilPtr^
   END;
   IF WriteLastInst THEN BEGIN
    IF RestartOperations THEN BEGIN
     IPC_PageNo:=NewInstPageNo; IPC_PageIndex:=NewInstPageIndex;
    END;
    PrintZState;
    DC_PageNo:=NewInstPageNo; DC_PageIndex:=NewInstPageIndex;
    Disassemble(1, true, false, true);
   END;
   Cmd:=Break;
   GOTO 999
  END; (* HandleError *)
 
 PROCEDURE InternalError{Error:InternalErrors};
  VAR Message:aMaxString;
  BEGIN
   Message:='Unknown error #**';
   Message[16]:=HexChars[Ord(Error) DIV 16];
   Message[17]:=HexChars[Ord(Error) MOD 16];
   CASE Error OF
    IllMultiOpdOp:
     Message:='Illegal multiple operand operation';
    IllNoOpdOp:
     Message:='Illegal no operand operation';
    IllTwoOpdOp:
     Message:='Illegal two operand operation';
    IllOneOpdOp:
     Message:='Illegal one operand operation';
    StackUnderflow:
     Message:='Stack underflow';
    StackOverflow:
     Message:='Stack overflow';
    IllObjDataLoad:
     Message:='Illegal object data load';
    DivideByZero:
     Message:='Divide by zero';
    MissingOpd:
     Message:='Missing operand';
    MissingObjProp:
     Message:='Missing object property';
    IllObjPropertyStore:
     Message:='Illegal object property store';
    IllZCodeType:
     Message:='Illegal Z-code type';
    NotImplemented:
     Message:='Not implemented';
    KeyboardBreak:
     Message:='Keyboard break';
    BreakPoint:
     Message:='Unexpected breakpoint';
    OutputBufferUndefined:
     Message:='Output buffer is not defined';
    PC_Overflow:
     Message:='PC overflow';
    PC_Underflow:
     Message:='PC underflow';
    TooManySeparators:
     Message:='Too many separators';
    TooManyLocalVariables:
     Message:='Too many local variables';
    TooManyParameters:
     Message:='Too many parameters';
    IllNumOperands:
     Message:='Illegal number of operands';
    IllOutputChar:
     Message:='Illegal output character';
    IllScreenMode:
     Message:='Illegal screen mode';
    NoPrinter:
     Message:='Unable to open printer';
    IllOutputMode:
     Message:='Illegal output mode';
    IllOperand:
     Message:='Illegal operand';
    IllMSP:
     Message:='Illegal mark stack pointer';
    IllColour:
     Message:='Illegal colour';
    IllObj:
     Message:='Illegal object';
    OTHERWISE
     Message:='Undefined Error';
   END;
   IF FaultNotImplemented OR
      (Error<>NotImplemented) AND (Error<>IllColour) AND
      (Error<>IllOperand) AND (Error<>IllOutputMode) AND
      (Error<>IllNumOperands) THEN BEGIN
     HandleError(true,Message,CrashInternal);
   END;
  END; (* InternalError *)
 
 BEGIN (* InfocomInteractiveFictionDebugger *)
  Initialize;
  IF ParamCount>0 THEN BEGIN
   StoryName:=ParamStr(1);
   LoadStory;
   StartZMachine(Quit);
  END ELSE BEGIN
   ListCommands; CmdLine:='';
   REPEAT
    Tracing:=false; Running:=false; Stepping:=false;
    IF Cmd=SwitchToStep THEN BEGIN
     StepCommand
    END ELSE IF Cmd=SwitchToTrace THEN BEGIN
     TraceCommand
    END ELSE BEGIN
     PrintListing:=false;
     ChkWait; PrintCh(']');
     SetLength(CmdLine, 0);
     ReadLine(false, CmdLine, 79, -1, 0);
     LineInterpreter(Cmd,CmdLine)
    END;
999:
   UNTIL Cmd=Quit;
  END;
  ResetScreen;
  CloseText(Printer)
 END. (* InfocomInteractiveFictionDebugger *)
