
#include <stdio.h>
#include <setjmp.h>
#include <signal.h>
#include <time.h>

#ifdef __riscos
#include "kernel.h"
#include "swis.h"
#endif
#ifdef unix
#include <sgtty.h>
#ifdef sun
#include <sys/filio.h>
#endif
#include <sys/fcntl.h>
#include <sys/ttydev.h>
#include <sys/file.h>
#include <sys/ioctl.h>
#ifdef sun
#include <sys/ttold.h>
#define CBREAK O_CBREAK
#endif
#endif

#include "ZIP_Ext.c"

static int TimeCount = 0;

#ifdef __riscos

#define NumPadOffset 0xC0

static int OldEscapeKeyStatus;
static int OldCursorKeyStatus;
static int OldFuncKeyStatus;
static int OldPadKeyStatus;
static int OldNumPadOffset;

static int ChOffset;

#endif


#ifdef unix

static int TenthOfaSecond = 100000;

#ifdef curses

#include "curses.h"

static chtype CursesTextAttributes;

#else

#define DELETE_LINE 1

extern char *tgoto(char *, int, int);
extern char *tgetstr(char *, char **);

static struct sgttyb *orgterminfo;
static char *term;
static char bp[1024];
static char *bellsequence,*clearsequence,*clreolsequence,*boldsequence,*normalsequence,*inversesequence,*cursormotion,*deletesequence,*scrollupsequence, *scrollareasequence;
static char areabuffer[1024];
static char *area;

static int outc(char c) {
putchar(c);
return 0;
} /* outc */

#endif

#endif


void ClearScreen(void) {
#ifdef __riscos
  _kernel_oswrch(12);
#endif
#ifdef unix
#ifdef curses
  erase();
  refresh();
#else
  tputs(clearsequence, 1, outc);
  fflush(stdout);
#endif
#endif
} /* ClearScreen */


void ClearToEOL(void) {
#ifdef __riscos
  _kernel_oswrch(23);
  _kernel_oswrch(8);
  _kernel_oswrch(5);
  _kernel_oswrch(6);
  _kernel_oswrch(0);
  _kernel_oswrch(0);
  _kernel_oswrch(0);
  _kernel_oswrch(0);
  _kernel_oswrch(0);
  _kernel_oswrch(0);
#endif
#ifdef unix
#ifdef curses
  clrtoeol();
  refresh();
#else
  tputs(clreolsequence, 1, outc);
  fflush(stdout);
#endif
#endif
} /* ClearToEOL */


void GotoXY(int x, int y) {
#ifdef __riscos
  _kernel_oswrch(31);
  _kernel_oswrch(x);
  _kernel_oswrch(y);
#endif
#ifdef unix
#ifdef curses
  move(y,x);
#else
  tputs(tgoto(cursormotion,x,y), 1, outc);
  fflush(stdout);
#endif
#endif
} /* GotoXY */


void WriteRawChOnScreen(Char Ch) {
#ifdef __riscos
  _kernel_oswrch(Ch);
#endif
#ifdef unix
#ifdef curses
  addch(Ch);
#else
  putchar(Ch);
#endif
#endif
} /* WriteRawChOnScreen */


void WriteChOnScreen(Char Ch) {
#ifdef __riscos
  _kernel_oswrch(ChOffset + Ch);
#endif
#ifdef unix
#ifdef curses
  addch(Ch);
#else
  putchar(Ch);
#endif
#endif
} /* WriteChOnScreen */


void ScrollLinesUp(int FirstLine) {
#ifdef __riscos
  _kernel_oswrch(28);
  _kernel_oswrch(0);
  _kernel_oswrch(ScreenHeight - 1);
  _kernel_oswrch(ScreenWidth - 1);
  _kernel_oswrch(FirstLine);
  _kernel_oswrch(23);
  _kernel_oswrch(7);
  _kernel_oswrch(0);
  _kernel_oswrch(3);
  _kernel_oswrch(0);
  _kernel_oswrch(0);
  _kernel_oswrch(0);
  _kernel_oswrch(0);
  _kernel_oswrch(0);
  _kernel_oswrch(0);
  _kernel_oswrch(28);
  _kernel_oswrch(0);
  _kernel_oswrch(ScreenHeight - 1);
  _kernel_oswrch(ScreenWidth - 1);
  _kernel_oswrch(0);
#endif
#ifdef unix
#ifdef curses
  
#else
  int Line, LastLine;
  char *sp, *dp;
  char Buffer[256];
  
#ifdef DELETE_LINE
  GotoXY(0, FirstLine);
  tputs(deletesequence, 1, outc);
#else
  Line = FirstLine;
  LastLine = tgetnum("li") - 1;
  sp = scrollareasequence;
  dp = Buffer;
  while (*sp) {
    if (*sp == '%') {
      ++sp;
      switch (*sp++) {
      case 'd':
	dp += (int)sprintf(dp, "%d", Line);
	Line = LastLine;
	break;
      case 'i':
	break;
      }
    } else {
      *dp++ = *sp++;
    }
  }
  *dp++ = 0;
  tputs(Buffer, 1, outc);
  GotoXY(0, LastLine);
  tputs(scrollupsequence, 1, outc);
#endif
#endif
#endif
} /* ScrollLinesUp */


int Random(void) {
  return rand();
} /* Random */


void Randomize(void) {
  srand((unsigned int)time(NULL));
} /* Randomize */


boolean KeyPressed(void) {
#ifdef __riscos
  int Result;
  
  Result = _kernel_osbyte(128, 255, 0);
  return (Result & 0xFFFF) != 0;
#endif
#ifdef unix
#ifdef curses
  int ch;
  
  nodelay(stdscr,TRUE);
  ch = getch();
  if (ch != ERR) {
    ungetch(ch);
  }
  nodelay(stdscr,FALSE);
  return ch != ERR;
#else
  int NumKeys;
  
  fflush(stdout);
  ioctl(0,FIONREAD,&NumKeys);
  return(NumKeys>0);
#endif
#endif
} /* KeyPressed */


#ifdef __riscos
static int GetTimeInCentiSeconds(void) {
#ifdef __riscos
  _kernel_swi_regs r;
  
  _kernel_swi(OS_ReadMonotonicTime, &r, &r);
  return r.r[0];
#endif
#ifdef unix
  return 0;
#endif
} /* GetTimeInCentiSeconds */
#endif


#ifdef unix
static jmp_buf TimeOutJump;
static int TimeOutJumpEnabled;
static int JumpTime = -1;

static void GotAlarm(void) {
  TimeCount += 1;
  if (TimeOutJumpEnabled && TimeCount >= JumpTime) {
    TimeCount -= JumpTime;
    longjmp(&TimeOutJump, 1);
  }
} /* GotAlarm */
#endif


void EnableTimer(void) {
#ifdef __riscos
  TimeCount = GetTimeInCentiSeconds();
#endif
#ifdef unix
  signal(SIGALRM, GotAlarm);
  ualarm(1, TenthOfaSecond);
  TimeCount = 0;
#endif
} /* EnableTimer */


void DisableTimer(void) {
#ifdef unix
  ualarm(0, 0);
  signal(SIGALRM, SIG_IGN);
#endif
} /* DisableTimer */


Char ReadKeyWithNoEcho(int TimeOut) {
#ifdef __riscos
  if (TimeOut >= 0) {
    TimeOut = TimeCount + TimeOut * 10;
    while (!KeyPressed()) {
      int Now;
      
      Now = GetTimeInCentiSeconds();
      if (Now >= TimeOut) {
	TimeCount = TimeOut;
	return 0;
      }
    }
  }
  return _kernel_osrdch();
#endif
#ifdef unix
  char Ch;
  
#ifdef curses
  refresh();
#else
  fflush(stdout);
#endif
  if (TimeOut >= 0) {
    JumpTime = TimeOut;
    if (setjmp(&TimeOutJump) == 1) {
      TimeOutJumpEnabled = 0;
      return 0;
    }
    TimeOutJumpEnabled = 1;
  }
#ifdef curses
  Ch = getch();
#else
  Ch = getchar();
#endif
  TimeOutJumpEnabled = 0;
  if (Ch < 0) {
    Ch = 0;
  }
  return Ch;
#endif
} /* ReadKeyWithNoEcho */


Char Backspace(void) {
#ifdef curses
  return KEY_BACKSPACE;
#else
  return 8;
#endif
} /* Backspace */

Char EOL(void) {
#ifdef __riscos
  return 13;
#endif
#ifdef unix
#ifdef curses
  return KEY_ENTER;
#else
  return 10;
#endif
#endif
} /* EOL */


Char ESC(void) {
#ifdef curses
  return KEY_CANCEL;
#else
  return 27;
#endif
} /* ESC */


Char Ctrl_S(void) {
#ifdef curses
  return KEY_WAIT;
#else
  return 19;
#endif
} /* Ctrl_S */


Char DeleteChar(void) {
#ifdef curses
  return KEY_DC;
#else
  return 127;
#endif
} /* DeleteChar */


Char KeyToDeleteLine(void) {
#ifdef curses
  return KEY_DL;
#else
  return 24;
#endif
} /* KeyToDeleteLine */


boolean FileExists(aMaxString FileName) {
#ifdef __riscos
  int fd;
  
  fd = _kernel_osfind(64+2, FileName);
  if (fd != 0) {
    _kernel_osfind(0, (char *)fd);
    return true;
  }
  return false;
#endif
#ifdef unix
  if (open(FileName,O_RDONLY)<0) {
    return(0);
  } else {
    return(1);
  }
#endif
} /* FileExists */


boolean IsDirectory(aMaxString Name) {
  return false;
} /* IsDirectory */


Char *StateDirectory(Char StateDirectory_ReturnValue[256]) {
#ifdef __riscos
  strcpy(StateDirectory_ReturnValue, "ZIPDebug:States.");
#endif
#ifdef unix
  char *EnvVar;
  
  EnvVar = getenv("ZIPDEBUGSTATEPATH");
  strcpy(StateDirectory_ReturnValue,
	 EnvVar != NULL ? EnvVar : "");
#endif
  return StateDirectory_ReturnValue;
} /* StateDirectory */


void CloseText(FILE **TextToClose) {
  if (*TextToClose != NULL) {
    fclose(*TextToClose);
    *TextToClose = NULL;
  }
} /* CloseText */


void ClosePageFile(aPageFile *theFile) {
  if (*theFile != NULL) {
    fclose(*theFile);
    *theFile = NULL;
  }
} /* ClosePageFile */


void RingBell(void) {
#ifdef __riscos
  _kernel_oswrch(7);
#endif
#ifdef unix
  if (bellsequence) {
    tputs(bellsequence, 1, outc);
    fflush(stdout);
  }
#endif
} /* RingBell */


void CursorOn(void) {
#ifdef __riscos
  _kernel_oswrch(23);
  _kernel_oswrch(1);
  _kernel_oswrch(1);
  _kernel_oswrch(0);
  _kernel_oswrch(0);
  _kernel_oswrch(0);
  _kernel_oswrch(0);
  _kernel_oswrch(0);
  _kernel_oswrch(0);
  _kernel_oswrch(0);
#endif
#ifdef unix
#ifdef curses
  curs_set(1);
#endif
#endif
} /* CursorOn */


void CursorOff(void) {
#ifdef __riscos
  _kernel_oswrch(23);
  _kernel_oswrch(1);
  _kernel_oswrch(0);
  _kernel_oswrch(0);
  _kernel_oswrch(0);
  _kernel_oswrch(0);
  _kernel_oswrch(0);
  _kernel_oswrch(0);
  _kernel_oswrch(0);
  _kernel_oswrch(0);
#endif
#ifdef unix
#ifdef curses
  curs_set(0);
#endif
#endif
} /* CursorOff */


typedef enum {
  text_NONE = 0,
  text_INVERSE = 1,
  text_BOLD = 2,
  text_ITALIC = 4,
  text_EXTRA = 8
  } tTextAttributes;

static tTextAttributes TextAttributes;


#ifdef __riscos
static int ForegroundColour = 7;
static int BackgroundColour = 0;
#endif


static tTextAttributes SavedTextAttributes;

void SaveTextAttributes(void) {
  SavedTextAttributes = TextAttributes;
} /* SaveTextAttributes */


void RestoreTextAttributes(void) {
  NormalOn();
  if (SavedTextAttributes & text_BOLD) {
    BoldOn();
  }
  if (SavedTextAttributes & text_ITALIC) {
    ItalicOn();
  }
  if (SavedTextAttributes & text_INVERSE) {
    InverseOn();
  }
  if (SavedTextAttributes & text_EXTRA) {
    ExtraOn();
  }
  SavedTextAttributes = 0;
} /* RestoreTextAttributes */


void NormalOn(void) {
  TextAttributes = text_NONE;
#ifdef __riscos
  ForegroundColour = 7;
  BackgroundColour = 0;
  _kernel_oswrch(17);
  _kernel_oswrch(ForegroundColour);
  _kernel_oswrch(17);
  _kernel_oswrch(128 + BackgroundColour);
#endif
#ifdef unix
#ifdef curses
  CursesTextAttributes = 0;
#else
  if (normalsequence) {
    tputs(normalsequence, 1, outc);
  }
#endif
#endif
} /* NormalOn */


void InverseOn(void) {
  TextAttributes |= text_INVERSE;
#ifdef __riscos
  _kernel_oswrch(17);
  _kernel_oswrch(BackgroundColour);
  _kernel_oswrch(17);
  _kernel_oswrch(128 + ForegroundColour);
#endif
#ifdef unix
#ifdef curses
  CursesTextAttributes |= A_REVERSE;
#else
  if (inversesequence) {
    tputs(inversesequence, 1, outc);
  }
#endif
#endif
} /* InverseOn */


void BoldOn(void) {
  TextAttributes |= text_BOLD;
#ifdef __riscos
  ForegroundColour = 5;
  BackgroundColour = 0;
  _kernel_oswrch(17);
  _kernel_oswrch(
		 TextAttributes & text_INVERSE ?
		 BackgroundColour :
		 ForegroundColour);
  _kernel_oswrch(17);
  _kernel_oswrch(128 + (
			TextAttributes & text_INVERSE ?
			ForegroundColour :
			BackgroundColour));
#endif
#ifdef unix
  if (boldsequence) {
    tputs(boldsequence, 1, outc);
  }
#endif
} /* BoldOn */


void ItalicOn(void) {
#ifdef __riscos
  ForegroundColour = 3;
  BackgroundColour = 0;
  _kernel_oswrch(17);
  _kernel_oswrch(
		 TextAttributes & text_INVERSE ?
		 BackgroundColour :
		 ForegroundColour);
  _kernel_oswrch(17);
  _kernel_oswrch(128 + (
			TextAttributes & text_INVERSE ?
			ForegroundColour :
			BackgroundColour));
#endif
} /* ItalicOn */


void ExtraOn(void) {
  TextAttributes = text_EXTRA;
#ifdef __riscos
  ForegroundColour = 1;
  BackgroundColour = 0;
  _kernel_oswrch(17);
  _kernel_oswrch(
		 TextAttributes & text_INVERSE ?
		 BackgroundColour :
		 ForegroundColour);
  _kernel_oswrch(17);
  _kernel_oswrch(128 + (
			TextAttributes & text_INVERSE ?
			ForegroundColour :
			BackgroundColour));
#endif
} /* ExtraOn */


int ExpandByte(int theByte) {
  return theByte;
} /* ExpandByte */


void SplitWord(int theWord, int *LowByte, int *HighByte) {
  *LowByte = theWord & 0xFF;
  *HighByte = (theWord >> 8) & 0xFF;
} /* SplitWord */


int JoinBytes(int LowByte, int HighByte) {
  return (int)((signed short)(LowByte | (HighByte << 8)));
} /* JoinBytes */


void WrapAddress(int *PageNo, int *PageIndex) {
  while (*PageIndex > 255) {
    *PageIndex -= 256;
    *PageNo += 1;
  }
  while (*PageIndex < 0) {
    *PageIndex += 256;
    *PageNo -= 1;
  }
} /* WrapAddress */


void ShiftLeft(int *HighWord, int *LowWord) {
  /* 3 byte shift left */
  unsigned long LongWord;

  LongWord = ((unsigned long)*LowWord & 0xFFFF) +
             (((unsigned long)*HighWord & 0xFFFF) << 8);
  LongWord <<= 1;
  *LowWord = (int)(LongWord & 0xFF);
  *HighWord = (int)((LongWord >> 8) & 0xFFFF);
} /* ShiftLeft */


void ShiftRight(int *HighWord, int *LowWord) {
  /* 4 byte shift right */
  unsigned long LongWord;
  
  LongWord = ((unsigned long)*LowWord & 0xFFFF) +
             (((unsigned long)*HighWord & 0xFFFF) << 8);
  LongWord >>= 1;
  *LowWord = (int)(LongWord & 0xFF);
  *HighWord = (int)((LongWord >> 8) & 0xFFFF);
} /* ShiftRight */


int Nibble(int theByte, int NibbleNo) {
  return ((theByte & (0x0F << (NibbleNo * 4))) >> (NibbleNo * 4));
} /* Nibble */


int Bittle(int theByte, int BittleNo) {
  return ((theByte & (0x03 << (BittleNo * 2))) >> (BittleNo * 2));
} /* Bittle */


boolean TstBit(int theWord, int BitNo) {
  return ((theWord & (1 << BitNo)) != 0);
} /* TstBit */


void SetBit(int *theWord, int BitNo) {
  *theWord |= (1 << BitNo);
} /* SetBit */


void ClrBit(int *theWord, int BitNo) {
  *theWord &= ~(1 << BitNo);
} /* ClrBit */


int cOp4(int Code) {
  return (Code & 15);
} /* cOp4 */


int cMode(int Code) {
  return ((Code & 0x30) >> 4);
} /* cMode */


int cCmd2(int Code) {
  return ((Code & 192) >> 6);
} /* cCmd2 */


int cOp5(int Code) {
  return (Code & 31);
} /* cOp5 */


int cMode3(int Code) {
  return ((Code & 224) >> 5);
} /* cMode3 */


int cDistance(int Code) {
  return (Code & 63);
} /* cDistance */


boolean cShort(int Code) {
  return (Code & 64) != 0;
} /* cShort */


boolean cTrueJump(int Code) {
  return (Code & 128) != 0;
} /* cTrueJump */


int land(int i1, int i2) {
  return i1 & i2;
} /* land */


int lor(int i1, int i2) {
  return i1 | i2;
} /* lor */


int lnot(int i) {
  return ~i;
} /* lnot */


int lsr(int i, int c) {
  return i >> c;
} /* lsr */


int lsl(int i, int c) {
  return i << c;
} /* lsl */


void InitSystem(void) {
} /* InitSystem */


#ifdef unix
void TermError(char *Message) {
  fprintf(stderr, "%s\n", Message);
  ResetTerminal();
  exit(1);
} /* TermError */
#endif


void SetupTerminal(int *Width, int *Height) {
#ifdef __riscos
  int Mode;
  _kernel_swi_regs r;
  
  Mode = (_kernel_osbyte(135, 0, 0) >> 8) & 0xFF;
  r.r[0] = Mode;
  r.r[1] = 1;
  _kernel_swi(OS_ReadModeVariable, &r, &r);
  *Width = r.r[2] + 1;
  r.r[1] = 2;
  _kernel_swi(OS_ReadModeVariable, &r, &r);
  *Height = r.r[2] + 1;
  OldEscapeKeyStatus = _kernel_osbyte(229, 1, 0) & 0xFF;
  OldCursorKeyStatus = _kernel_osbyte(237, 2, 0) & 0xFF;
  OldFuncKeyStatus = _kernel_osbyte(225, 0x80, 0) & 0xFF;
  OldPadKeyStatus = _kernel_osbyte(221, NumPadOffset, 0) & 0xFF;
  OldNumPadOffset = _kernel_osbyte(238, NumPadOffset, 0) & 0xFF;
#endif
#ifdef unix
#ifdef curses
  initscr();
  scrollok(stdscr, FALSE);
  cbreak();
  noecho();
  keypad(stdscr,TRUE);
#else
  struct sgttyb *terminfo;
  
  terminfo = (struct sgttyb*) malloc(sizeof(struct sgttyb));
  orgterminfo = (struct sgttyb*) malloc(sizeof(struct sgttyb));
  ioctl(0,TIOCGETP,terminfo);
  *orgterminfo = *terminfo;
  terminfo->sg_flags = terminfo->sg_flags & ~(ECHO | XTABS);
  terminfo->sg_flags = terminfo->sg_flags | CBREAK;
  ioctl(0,TIOCSETP,terminfo);
  
  term = getenv("TERM");
  
  if (term == NULL) {
    TermError("TERM not set.");
  }
  
  if (tgetent(bp,term) != 1) {
    TermError("Cannot read TERMCAP entry.");
  }
  
  *Width = tgetnum("co");
  if (*Width <= 0) {
    TermError("Terminal has no width.");
  }
  *Width -= 1;
  
  *Height = tgetnum("li");
  if (*Height <= 0) {
    TermError("Terminal has no height.");
  }
  
  area = areabuffer;  
  
  bellsequence    = tgetstr("bl",&area);
  if (bellsequence == NULL) {
    bellsequence = "\07";
  }
  clearsequence   = tgetstr("cl",&area);
  if (clearsequence == NULL) {
    TermError("Terminal has no clear screen capability.");
  }
  clreolsequence  = tgetstr("ce",&area);
  if (clreolsequence == NULL) {
    TermError("Terminal has no clear end of line capability.");
  }
  boldsequence    = tgetstr("md",&area);
  if (boldsequence == NULL) {
    boldsequence = "";
  }
  normalsequence  = tgetstr("me",&area);
  if (normalsequence == NULL) {
    normalsequence = tgetstr("se",&area);
  }
  if (normalsequence == NULL) {
    normalsequence = "";
  }
  inversesequence = tgetstr("mr",&area);
  if (inversesequence == NULL) {
    inversesequence = tgetstr("so",&area);
  }
  if (inversesequence == NULL) {
    inversesequence = "";
  }
  cursormotion    = tgetstr("cm",&area);
  if (cursormotion == NULL) {
    TermError("Terminal has no cursor motion capability.");
  }
#ifdef DELETE_LINE
  deletesequence  = tgetstr("dl",&area);
  if (deletesequence == NULL) {
    TermError("Terminal has no delete line capability.");
  }
#else
  scrollupsequence = tgetstr("sf", &area);
  if (scrollupsequence == NULL) {
    TermError("Terminal has no scroll up capability.");
  }
  scrollareasequence = tgetstr("cs", &area);
  if (scrollareasequence == NULL) {
    TermError("Terminal has no scroll area capability.");
  }
#endif
#endif
#endif
} /* SetupTerminal */


void ResetTerminal(void) {
#ifdef __riscos
  NormalOn();
  CursorOn();
  _kernel_osbyte(229, OldEscapeKeyStatus, 0);
  _kernel_osbyte(237, OldCursorKeyStatus, 0);
  _kernel_osbyte(225, OldFuncKeyStatus, 0);
  _kernel_osbyte(221, OldPadKeyStatus, 0);
  _kernel_osbyte(238, OldNumPadOffset, 0);
#endif
#ifdef unix
#ifdef curses
  endwin();
#else
  ioctl(0,TIOCSETP,orgterminfo);
#endif
#endif
} /* ResetTerminal */


Char UpArrow(void) {
#ifdef __riscos
  return 0x8F;
#endif
#ifdef unix
  return 0;
#endif
} /* UpArrow */


Char DownArrow(void) {
#ifdef __riscos
  return 0x8E;
#endif
#ifdef unix
  return 0;
#endif
} /* DownArrow */


Char LeftArrow(void) {
#ifdef __riscos
  return 0x8C;
#endif
#ifdef unix
  return 0;
#endif
} /* LeftArrow */


Char RightArrow(void) {
#ifdef __riscos
  return 0x8D;
#endif
#ifdef unix
  return 0;
#endif
} /* RightArrow */


boolean IsFuncKey(Char Key) {
#ifdef __riscos
  if (Key >= 0x81 && Key <= 0x8A) {
    return true;
  } else {
    return false;
  }
#endif
#ifdef unix
  return false;
#endif
} /* IsFuncKey */


int FuncKeyNo(Char Key) {
#ifdef __riscos
  return Key - 0x80;
#endif
#ifdef unix
  return 0;
#endif
} /* FuncKeyNo */


Char NumericSW(void) {
#ifdef __riscos
  return NumPadOffset + 1;
#endif
#ifdef unix
  return 0;
#endif
} /* NumericSW */


Char NumericS(void) {
#ifdef __riscos
  return NumPadOffset + 2;
#endif
#ifdef unix
  return 0;
#endif
} /* NumericS */


Char NumericSE(void) {
#ifdef __riscos
  return NumPadOffset + 3;
#endif
#ifdef unix
  return 0;
#endif
} /* NumericSE */


Char NumericW(void) {
#ifdef __riscos
  return NumPadOffset + 4;
#endif
#ifdef unix
  return 0;
#endif
} /* NumericW */


Char NumericCentre(void) {
#ifdef __riscos
  return NumPadOffset + 5;
#endif
#ifdef unix
  return 0;
#endif
} /* NumericCentre */


Char NumericE(void) {
#ifdef __riscos
  return NumPadOffset + 6;
#endif
#ifdef unix
  return 0;
#endif
} /* NumericE */


Char NumericNW(void) {
#ifdef __riscos
  return NumPadOffset + 7;
#endif
#ifdef unix
  return 0;
#endif
} /* NumericNW */


Char NumericN(void) {
#ifdef __riscos
  return NumPadOffset + 8;
#endif
#ifdef unix
  return 0;
#endif
} /* NumericN */


Char NumericNE(void) {
#ifdef __riscos
  return NumPadOffset + 9;
#endif
#ifdef unix
  return 0;
#endif
} /* NumericNE */


/*******************************************************************/
/*                    Handling of Additional Fonts                 */
/*******************************************************************/

typedef struct {
  short NumChars;
  short FirstCh;
  char XSize;
  char YSize;
  char Filler;
  char Filler2;
  char Filler3[24];
} tZIPFont;

static tZIPFont *ZIPFonts[10];


static boolean LoadFont(int FontNo) {
  FILE *fd;
  int NumRead;
  int Length;
  tZIPFont ZIPFont;
  char FontName[256];
  
#ifdef __riscos
  sprintf(FontName, "ZIPDebug:ZIPFont%d", FontNo);
#endif
#ifdef unix
  sprintf(FontName, "ZIPFont%d", FontNo);
#endif
  fd = fopen(FontName, "rb");
  if (fd == NULL) {
    return false;
  }
  NumRead = fread(&ZIPFont, sizeof(tZIPFont), 1, fd);
  if (NumRead != 1) {
    fclose(fd);
    return false;
  }
  ZIPFont.NumChars =
    ((ZIPFont.NumChars >> 8) & 0xFF) | ((ZIPFont.NumChars & 0xFF) << 8);
  ZIPFont.FirstCh =
    ((ZIPFont.FirstCh >> 8) & 0xFF) | ((ZIPFont.FirstCh & 0xFF) << 8);
  Length = ZIPFont.XSize * ZIPFont.YSize * ZIPFont.NumChars / 8;
  ZIPFonts[FontNo] = (tZIPFont *)malloc(sizeof(tZIPFont) + Length);
  *ZIPFonts[FontNo] = ZIPFont;
  NumRead = fread((char *)ZIPFonts[FontNo] + sizeof(tZIPFont), Length, 1, fd);
  if (NumRead != 1) {
    fclose(fd);
    return false;
  }
  fclose(fd);
  return true;
} /* LoadFont */


boolean SwitchToFont(int FontNo) {
#ifdef __riscos
  int Cnt, NumChars, FirstCh, YSize;
  char *SrcPtr;
#endif
  
  if (FontNo == 1) {
#ifdef __riscos
    _kernel_osbyte(25, 0, 0); /* reset characters */
    ChOffset = 0;
#endif
    return true;
  }
  if (ZIPFonts[FontNo] == NULL) {
    if (!LoadFont(FontNo)) {
      return false;
    }
  }
#ifdef __riscos
  SrcPtr = (char *)ZIPFonts[FontNo] + sizeof(tZIPFont);
  NumChars = ZIPFonts[FontNo]->NumChars;
  FirstCh = ZIPFonts[FontNo]->FirstCh;
  YSize = ZIPFonts[FontNo]->YSize;
  ChOffset = 128 + FirstCh;
  for (Cnt = 0; Cnt < NumChars; ++Cnt) {
    int y;
    
    _kernel_oswrch(23);
    _kernel_oswrch(ChOffset + Cnt);
    for (y = 0; y < YSize; ++y) {
      _kernel_oswrch(*SrcPtr++);
    }
  }
  ChOffset = 128;
#endif
#ifdef unix
  return false;
#endif
  return true;
} /* SwitchToFont */


void SysSetColours(int Foreground, int Background) {
} /* SysSetColours */

