/*
**  This file is part of Zterp, and is
**  Copyright 1992, 1993 Charles Hannum
*/

#include <sys/types.h>
#include <curses.h>
#include "main.h"
#include "jump.h"
#include "output.h"

void
quit ()
{
  refresh_screen ();
  endwin ();
  exit (0);
}

int
do_verify (void)
{
  static int summed = 0;
  static uword sum = 0;

  if (! summed)
  {
    zpointer p = near_address (sizeof (zheader));
    int n = game_length - sizeof (zheader);

    while (n--)
    {
      sum += get_byte (p);
      p += 1;
    }
    summed = 1;
  }

  return (sum == game_checksum);
}

void
verify ()
{
  refresh_screen ();
  return_or_jump (do_verify ());
}
