/*
**  This file is part of Zterp, and is
**  Copyright 1992, 1993 Charles Hannum
*/

#include <sys/types.h>
#include <stdlib.h>
#include "main.h"
#include "variable.h"
#include "undo.h"

static int saved = 0;
static zbyte *undo_game;
static uword *undo_stack, *undo_sp, *undo_fp;
static zpointer undo_pc;

void
undo_save ()
{
  if (!saved)
    if (! (undo_game = (zbyte *) malloc (save_length)) ||
	! (undo_stack = (uword *) malloc (sizeof (stack))))
      saved = -1;

  if (saved < 0)
  {
    store_variable_push (0);
    return;
  }

  saved = 1;

  memcpy (undo_game, game, save_length);
  memcpy (undo_stack, stack, (sp - stack) << 1);
  undo_sp = sp;
  undo_fp = fp;
  undo_pc = pc;
  store_variable_push (0);
}

void
undo_restore ()
{
  if (saved <= 0)
  {
    store_variable_push (0);
    return;
  }

  memcpy (game, undo_game, save_length);
  memcpy (stack, undo_stack, sizeof (stack));
  sp = undo_sp;
  fp = undo_fp;
  pc = undo_pc;
  store_variable_push (2);
}
