/*
 * Decompiled with CFR 0.152.
 */
package com.zaxsoft.zmachine;

import com.zaxsoft.zmachine.ZCallFrame;
import com.zaxsoft.zmachine.ZIOCard;
import com.zaxsoft.zmachine.ZMemory;
import com.zaxsoft.zmachine.ZObjectTable;
import com.zaxsoft.zmachine.ZRandom;
import com.zaxsoft.zmachine.ZUserInterface;
import java.awt.Dimension;
import java.awt.Point;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;

public class ZCPU
implements Runnable {
    private final int OPTYPE_0OP = 0;
    private final int OPTYPE_1OP = 1;
    private final int OPTYPE_2OP = 2;
    private final int OPTYPE_VAR = 3;
    private final int OPTYPE_EXT = 4;
    private final int ARGTYPE_BYTE = 0;
    private final int ARGTYPE_WORD = 1;
    private ZMemory memory;
    private ZObjectTable objTable;
    private Stack callStack;
    private ZRandom rndgen;
    private ZIOCard ioCard;
    private ZUserInterface zui;
    private String curStoryFile;
    private int version = 0;
    private int programScale;
    private ZCallFrame curCallFrame;
    private int curInstruction;
    private int curOpcode;
    private int curOpcodeType;
    private int op1;
    private int op2;
    private int op1type;
    private int op2type;
    private int[] vops = new int[8];
    private int[] voptypes = new int[8];
    private int numvops;
    private int curBranch;
    private boolean curBranchReversed;
    private int curResult;
    private String curString;
    private boolean decode_ret_flag = false;
    private int ret_value;
    private int abbrevTable;
    private int globalVars;
    private int dynamicMemorySize;
    private boolean restartFlag;
    private int mainDictionary;
    private byte[] undoState;
    private boolean did_newline = false;
    private boolean altCharSet = false;
    private int alphabetL = 0;
    private int alphabetU = 1;
    private int alphabetP = 2;
    private char[][] alphabet = new char[][]{{' ', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'}, {' ', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'}, {' ', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\n', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '.', ',', '!', '?', '_', '#', '\'', '\"', '/', '\\', '-', ':', '(', ')'}, {' ', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '.', ',', '!', '?', '_', '#', '\'', '\"', '/', '\\', '<', '-', ':', '(', ')'}};

    public ZCPU(ZUserInterface ui) {
        this.zui = ui;
        this.memory = new ZMemory();
        this.callStack = new Stack();
        this.rndgen = new ZRandom();
        this.ioCard = new ZIOCard();
        this.objTable = new ZObjectTable();
    }

    public void initialize(String storyFile) {
        int termChars;
        boolean transcriptOn = false;
        if (this.restartFlag) {
            transcriptOn = (this.memory.fetchWord(16) & 1) == 1;
        }
        this.curStoryFile = storyFile;
        this.memory.initialize(this.zui, storyFile);
        this.version = this.memory.fetchByte(0);
        if (this.version < 1 || this.version > 8 || this.version == 6) {
            this.zui.fatal("Unsupported storyfile version: " + String.valueOf(this.version) + ".");
        }
        this.zui.initialize(this.version);
        this.rndgen.initialize(this.zui);
        this.ioCard.initialize(this.zui, this.memory, this.version, true);
        this.objTable.initialize(this.zui, this.memory, this.version);
        this.programScale = this.version <= 3 ? 2 : (this.version == 4 || this.version == 5 ? 4 : 8);
        if (this.version == 1) {
            this.alphabetP = 3;
        }
        int i = this.memory.fetchByte(1);
        if (this.version <= 3) {
            i &= 0xFFFFFFF7;
            i = this.zui.hasStatusLine() ? (i &= 0xFFFFFFEF) : (i |= 0x10);
            i = this.zui.hasUpperWindow() ? (i |= 0x20) : (i &= 0xFFFFFFDF);
            i = this.zui.defaultFontProportional() ? (i |= 0x40) : (i &= 0xFFFFFFBF);
        } else {
            if (this.version >= 5 && this.zui.hasColors()) {
                i |= 1;
            }
            if (this.zui.hasBoldface()) {
                i |= 4;
            }
            if (this.zui.hasItalic()) {
                i |= 8;
            }
            if (this.zui.hasFixedWidth()) {
                i |= 0x10;
            }
            if (this.zui.hasTimedInput()) {
                i |= 0x80;
            }
        }
        this.memory.putByte(1, i);
        if (this.version >= 4) {
            this.memory.putByte(30, 6);
            this.memory.putByte(31, 65);
            Dimension s = this.zui.getScreenCharacters();
            this.memory.putByte(32, s.height);
            this.memory.putByte(33, s.width);
            if (this.version >= 5) {
                s = this.zui.getScreenUnits();
                this.memory.putWord(34, s.width);
                this.memory.putWord(36, s.height);
                s = this.zui.getFontSize();
                this.memory.putByte(38, s.height);
                this.memory.putByte(39, s.width);
                this.memory.putByte(44, this.zui.getDefaultBackground());
                this.memory.putByte(45, this.zui.getDefaultForeground());
            }
        }
        if (this.restartFlag) {
            i = this.memory.fetchWord(16);
            i = transcriptOn ? (i |= 1) : (i &= 0xFFFFFFFE);
            this.memory.putWord(16, i);
            this.restartFlag = false;
        }
        if (this.version > 1) {
            this.abbrevTable = this.memory.fetchWord(24);
        }
        this.globalVars = this.memory.fetchWord(12);
        this.mainDictionary = this.memory.fetchWord(8);
        this.dynamicMemorySize = this.memory.fetchWord(14);
        if (this.version >= 5 && (termChars = this.memory.fetchWord(46)) != 0) {
            i = 0;
            int tc = this.memory.fetchByte(termChars);
            Vector<Integer> terminators = new Vector<Integer>();
            while (tc != 0) {
                terminators.addElement(new Integer(tc));
                tc = this.memory.fetchByte(termChars + ++i);
            }
            this.zui.setTerminatingCharacters(terminators);
        }
    }

    public Thread start() {
        if (this.version == 0) {
            return null;
        }
        Thread execThread = new Thread((Runnable)this, "ZMachine");
        execThread.start();
        return execThread;
    }

    public void run() {
        do {
            if (this.restartFlag) {
                this.initialize(this.curStoryFile);
                this.restartFlag = false;
            }
            this.curCallFrame = new ZCallFrame();
            this.curCallFrame.pc = this.memory.fetchWord(6);
            this.curCallFrame.routineStack = new Stack();
            this.curCallFrame.numLocalVars = 0;
            this.curCallFrame.callType = 2;
            this.curCallFrame.argCount = 0;
            this.curCallFrame.frameNumber = 0;
            this.callStack = new Stack();
            this.decodeLoop();
        } while (this.restartFlag);
    }

    private void decodeLoop() {
        do {
            int i;
            boolean done;
            int typebyte;
            int v;
            this.curInstruction = this.memory.fetchByte(this.curCallFrame.pc);
            ++this.curCallFrame.pc;
            if (this.curInstruction >= 0 && this.curInstruction <= 127) {
                if ((this.curInstruction & 0x40) == 64) {
                    v = this.memory.fetchByte(this.curCallFrame.pc);
                    this.op1 = this.getVariable(v);
                    this.op1type = 1;
                } else {
                    this.op1 = this.memory.fetchByte(this.curCallFrame.pc);
                    this.op1type = 0;
                }
                ++this.curCallFrame.pc;
                if ((this.curInstruction & 0x20) == 32) {
                    v = this.memory.fetchByte(this.curCallFrame.pc);
                    this.op2 = this.getVariable(v);
                    this.op2type = 1;
                } else {
                    this.op2 = this.memory.fetchByte(this.curCallFrame.pc);
                    this.op2type = 0;
                }
                ++this.curCallFrame.pc;
                this.curOpcodeType = 2;
                this.curOpcode = this.curInstruction & 0x1F;
            } else if (this.curInstruction >= 128 && this.curInstruction <= 175) {
                switch (this.curInstruction & 0x30) {
                    case 0: {
                        this.op1 = this.memory.fetchWord(this.curCallFrame.pc);
                        this.op1type = 1;
                        this.curCallFrame.pc += 2;
                        break;
                    }
                    case 16: {
                        this.op1 = this.memory.fetchByte(this.curCallFrame.pc);
                        this.op1type = 0;
                        ++this.curCallFrame.pc;
                        break;
                    }
                    case 32: {
                        v = this.memory.fetchByte(this.curCallFrame.pc);
                        this.op1 = this.getVariable(v);
                        this.op1type = 1;
                        ++this.curCallFrame.pc;
                    }
                }
                this.curOpcodeType = 1;
                this.curOpcode = this.curInstruction & 0xF;
            } else if (this.curInstruction >= 176 && this.curInstruction <= 191 && this.curInstruction != 190) {
                this.curOpcodeType = 0;
                this.curOpcode = this.curInstruction & 0xF;
            } else if (this.curInstruction >= 192 && this.curInstruction <= 223 && this.curInstruction != 193) {
                typebyte = this.memory.fetchByte(this.curCallFrame.pc);
                ++this.curCallFrame.pc;
                switch (typebyte & 0xC0) {
                    case 0: {
                        this.op1 = this.memory.fetchWord(this.curCallFrame.pc);
                        this.op1type = 1;
                        this.curCallFrame.pc += 2;
                        break;
                    }
                    case 64: {
                        this.op1 = this.memory.fetchByte(this.curCallFrame.pc);
                        this.op1type = 0;
                        ++this.curCallFrame.pc;
                        break;
                    }
                    case 128: {
                        v = this.memory.fetchByte(this.curCallFrame.pc);
                        this.op1 = this.getVariable(v);
                        this.op1type = 1;
                        ++this.curCallFrame.pc;
                        break;
                    }
                    case 192: {
                        this.zui.fatal("Error: Variable 2OP with no ops.");
                    }
                }
                switch (typebyte & 0x30) {
                    case 0: {
                        this.op2 = this.memory.fetchWord(this.curCallFrame.pc);
                        this.op2type = 1;
                        this.curCallFrame.pc += 2;
                        break;
                    }
                    case 16: {
                        this.op2 = this.memory.fetchByte(this.curCallFrame.pc);
                        this.op2type = 0;
                        ++this.curCallFrame.pc;
                        break;
                    }
                    case 32: {
                        v = this.memory.fetchByte(this.curCallFrame.pc);
                        this.op2 = this.getVariable(v);
                        this.op2type = 1;
                        ++this.curCallFrame.pc;
                        break;
                    }
                    case 48: {
                        this.zui.fatal("Error: Variable 2OP with one op.");
                    }
                }
                this.curOpcodeType = 2;
                this.curOpcode = this.curInstruction & 0x1F;
            } else if (this.curInstruction >= 224 && this.curInstruction <= 255 || this.curInstruction == 193) {
                int maxops;
                this.numvops = 0;
                if (this.curInstruction == 236 || this.curInstruction == 250) {
                    typebyte = this.memory.fetchWord(this.curCallFrame.pc);
                    this.curCallFrame.pc += 2;
                    maxops = 8;
                } else {
                    typebyte = this.memory.fetchByte(this.curCallFrame.pc);
                    ++this.curCallFrame.pc;
                    maxops = 4;
                }
                done = false;
                block159: for (i = 0; i < maxops && !done; ++i) {
                    switch (typebyte >> (maxops - 1 - i) * 2 & 3) {
                        case 0: {
                            this.vops[i] = this.memory.fetchWord(this.curCallFrame.pc);
                            this.voptypes[i] = 1;
                            this.curCallFrame.pc += 2;
                            ++this.numvops;
                            continue block159;
                        }
                        case 1: {
                            this.vops[i] = this.memory.fetchByte(this.curCallFrame.pc);
                            this.voptypes[i] = 0;
                            ++this.curCallFrame.pc;
                            ++this.numvops;
                            continue block159;
                        }
                        case 2: {
                            v = this.memory.fetchByte(this.curCallFrame.pc);
                            this.vops[i] = this.getVariable(v);
                            this.voptypes[i] = 1;
                            ++this.curCallFrame.pc;
                            ++this.numvops;
                            continue block159;
                        }
                        case 3: {
                            done = true;
                        }
                    }
                }
                if (this.curInstruction == 193) {
                    this.curOpcodeType = 2;
                    this.curOpcode = 1;
                } else {
                    this.curOpcodeType = 3;
                    this.curOpcode = this.curInstruction & 0x1F;
                }
            } else if (this.curInstruction == 190) {
                this.curOpcodeType = 4;
                this.curOpcode = this.memory.fetchByte(this.curCallFrame.pc);
                ++this.curCallFrame.pc;
                this.numvops = 0;
                typebyte = this.memory.fetchByte(this.curCallFrame.pc);
                ++this.curCallFrame.pc;
                done = false;
                block160: for (i = 0; i < 4 && !done; ++i) {
                    switch (typebyte >> (3 - i) * 2 & 3) {
                        case 0: {
                            this.vops[i] = this.memory.fetchWord(this.curCallFrame.pc);
                            this.voptypes[i] = 1;
                            this.curCallFrame.pc += 2;
                            ++this.numvops;
                            continue block160;
                        }
                        case 1: {
                            this.vops[i] = this.memory.fetchByte(this.curCallFrame.pc);
                            this.voptypes[i] = 0;
                            ++this.curCallFrame.pc;
                            ++this.numvops;
                            continue block160;
                        }
                        case 2: {
                            v = this.memory.fetchByte(this.curCallFrame.pc);
                            this.vops[i] = this.getVariable(v);
                            this.voptypes[i] = 1;
                            ++this.curCallFrame.pc;
                            ++this.numvops;
                            continue block160;
                        }
                        case 3: {
                            done = true;
                        }
                    }
                }
            } else {
                this.zui.fatal("Malformed instruction: " + this.curInstruction);
            }
            if (this.curOpcodeType == 0) {
                switch (this.curOpcode) {
                    case 0: {
                        this.zop_rtrue();
                        break;
                    }
                    case 1: {
                        this.zop_rfalse();
                        break;
                    }
                    case 2: {
                        this.getString();
                        this.zop_print();
                        break;
                    }
                    case 3: {
                        this.getString();
                        this.zop_print_rtrue();
                        break;
                    }
                    case 4: {
                        this.zop_nop();
                        break;
                    }
                    case 5: {
                        if (this.version < 4) {
                            this.getBranch();
                        } else if (this.version == 4) {
                            this.getResult();
                        } else {
                            this.zui.fatal("SAVE 0OP unsupported after version 4.");
                        }
                        this.zop_save();
                        break;
                    }
                    case 6: {
                        if (this.version < 4) {
                            this.getBranch();
                        } else if (this.version == 4) {
                            this.getResult();
                        } else {
                            this.zui.fatal("RESTORE 0OP unsupported after version 4.");
                        }
                        this.zop_restore();
                        break;
                    }
                    case 7: {
                        this.zop_restart();
                        break;
                    }
                    case 8: {
                        this.zop_ret_pulled();
                        break;
                    }
                    case 9: {
                        if (this.version < 5) {
                            this.zop_pop();
                            break;
                        }
                        this.getResult();
                        this.zop_catch();
                        break;
                    }
                    case 10: {
                        this.zop_quit();
                        break;
                    }
                    case 11: {
                        this.zop_new_line();
                        break;
                    }
                    case 12: {
                        this.zop_show_status();
                        break;
                    }
                    case 13: {
                        this.getBranch();
                        this.zop_verify();
                        break;
                    }
                    case 14: {
                        this.zui.fatal("Found opcode 0xBE in 0OP dispatcher");
                    }
                    case 15: {
                        this.getBranch();
                        this.zop_piracy();
                        break;
                    }
                    default: {
                        this.zui.fatal("Unknown 0OP - probably a bug.");
                        break;
                    }
                }
            } else if (this.curOpcodeType == 1) {
                switch (this.curOpcode) {
                    case 0: {
                        this.getBranch();
                        this.zop_jz();
                        break;
                    }
                    case 1: {
                        this.getResult();
                        this.getBranch();
                        this.zop_get_sibling();
                        break;
                    }
                    case 2: {
                        this.getResult();
                        this.getBranch();
                        this.zop_get_child();
                        break;
                    }
                    case 3: {
                        this.getResult();
                        this.zop_get_parent();
                        break;
                    }
                    case 4: {
                        this.getResult();
                        this.zop_get_prop_len();
                        break;
                    }
                    case 5: {
                        this.zop_inc();
                        break;
                    }
                    case 6: {
                        this.zop_dec();
                        break;
                    }
                    case 7: {
                        this.zop_print_addr();
                        break;
                    }
                    case 8: {
                        this.getResult();
                        this.zop_call_f0();
                        break;
                    }
                    case 9: {
                        this.zop_remove_obj();
                        break;
                    }
                    case 10: {
                        this.zop_print_obj();
                        break;
                    }
                    case 11: {
                        this.zop_ret();
                        break;
                    }
                    case 12: {
                        this.zop_jump();
                        break;
                    }
                    case 13: {
                        this.zop_print_paddr();
                        break;
                    }
                    case 14: {
                        this.getResult();
                        this.zop_load();
                        break;
                    }
                    case 15: {
                        if (this.version < 5) {
                            this.getResult();
                            this.zop_not();
                            break;
                        }
                        this.zop_call_p0();
                        break;
                    }
                    default: {
                        this.zui.fatal("Unknown 1OP - probably a bug.");
                        break;
                    }
                }
            } else if (this.curOpcodeType == 2) {
                switch (this.curOpcode) {
                    case 0: {
                        this.zui.fatal("Unspecified instruction: " + this.curInstruction);
                    }
                    case 1: {
                        this.getBranch();
                        this.zop_je();
                        break;
                    }
                    case 2: {
                        this.getBranch();
                        this.zop_jl();
                        break;
                    }
                    case 3: {
                        this.getBranch();
                        this.zop_jg();
                        break;
                    }
                    case 4: {
                        this.getBranch();
                        this.zop_dec_jl();
                        break;
                    }
                    case 5: {
                        this.getBranch();
                        this.zop_inc_jg();
                        break;
                    }
                    case 6: {
                        this.getBranch();
                        this.zop_jin();
                        break;
                    }
                    case 7: {
                        this.getBranch();
                        this.zop_test();
                        break;
                    }
                    case 8: {
                        this.getResult();
                        this.zop_or();
                        break;
                    }
                    case 9: {
                        this.getResult();
                        this.zop_and();
                        break;
                    }
                    case 10: {
                        this.getBranch();
                        this.zop_test_attr();
                        break;
                    }
                    case 11: {
                        this.zop_set_attr();
                        break;
                    }
                    case 12: {
                        this.zop_clear_attr();
                        break;
                    }
                    case 13: {
                        this.zop_store();
                        break;
                    }
                    case 14: {
                        this.zop_insert_obj();
                        break;
                    }
                    case 15: {
                        this.getResult();
                        this.zop_loadw();
                        break;
                    }
                    case 16: {
                        this.getResult();
                        this.zop_loadb();
                        break;
                    }
                    case 17: {
                        this.getResult();
                        this.zop_get_prop();
                        break;
                    }
                    case 18: {
                        this.getResult();
                        this.zop_get_prop_addr();
                        break;
                    }
                    case 19: {
                        this.getResult();
                        this.zop_get_next_prop();
                        break;
                    }
                    case 20: {
                        this.getResult();
                        this.zop_add();
                        break;
                    }
                    case 21: {
                        this.getResult();
                        this.zop_sub();
                        break;
                    }
                    case 22: {
                        this.getResult();
                        this.zop_mul();
                        break;
                    }
                    case 23: {
                        this.getResult();
                        this.zop_div();
                        break;
                    }
                    case 24: {
                        this.getResult();
                        this.zop_mod();
                        break;
                    }
                    case 25: {
                        this.getResult();
                        this.zop_call_f1();
                        break;
                    }
                    case 26: {
                        this.zop_call_p1();
                        break;
                    }
                    case 27: {
                        this.zop_set_colour();
                        break;
                    }
                    case 28: {
                        this.zop_throw();
                        break;
                    }
                    case 29: 
                    case 30: 
                    case 31: {
                        this.zui.fatal("Unspecified instruction: " + this.curInstruction);
                    }
                    default: {
                        this.zui.fatal("Unknown 2OP.  Probably a bug.");
                        break;
                    }
                }
            } else if (this.curOpcodeType == 3) {
                switch (this.curOpcode) {
                    case 0: {
                        this.getResult();
                        this.zop_call_fv();
                        break;
                    }
                    case 1: {
                        this.zop_storew();
                        break;
                    }
                    case 2: {
                        this.zop_storeb();
                        break;
                    }
                    case 3: {
                        this.zop_put_prop();
                        break;
                    }
                    case 4: {
                        if (this.version >= 5) {
                            this.getResult();
                        }
                        this.zop_read();
                        break;
                    }
                    case 5: {
                        this.zop_print_char();
                        break;
                    }
                    case 6: {
                        this.zop_print_num();
                        break;
                    }
                    case 7: {
                        this.getResult();
                        this.zop_random();
                        break;
                    }
                    case 8: {
                        this.zop_push();
                        break;
                    }
                    case 9: {
                        this.zop_pull();
                        break;
                    }
                    case 10: {
                        this.zop_split_screen();
                        break;
                    }
                    case 11: {
                        this.zop_set_window();
                        break;
                    }
                    case 12: {
                        this.getResult();
                        this.zop_call_fd();
                        break;
                    }
                    case 13: {
                        this.zop_erase_window();
                        break;
                    }
                    case 14: {
                        this.zop_erase_line();
                        break;
                    }
                    case 15: {
                        this.zop_set_cursor();
                        break;
                    }
                    case 16: {
                        this.zop_get_cursor();
                        break;
                    }
                    case 17: {
                        this.zop_set_text_style();
                        break;
                    }
                    case 18: {
                        this.zop_buffer_mode();
                        break;
                    }
                    case 19: {
                        this.zop_output_stream();
                        break;
                    }
                    case 20: {
                        this.zop_input_stream();
                        break;
                    }
                    case 21: {
                        this.zop_sound();
                        break;
                    }
                    case 22: {
                        this.getResult();
                        this.zop_read_char();
                        break;
                    }
                    case 23: {
                        this.getResult();
                        this.getBranch();
                        this.zop_scan_table();
                        break;
                    }
                    case 24: {
                        this.getResult();
                        this.op1 = this.vops[0];
                        this.op1type = this.voptypes[0];
                        this.zop_not();
                        break;
                    }
                    case 25: {
                        this.zop_call_pv();
                        break;
                    }
                    case 26: {
                        this.zop_call_pv();
                        break;
                    }
                    case 27: {
                        this.zop_tokenise();
                        break;
                    }
                    case 28: {
                        this.zop_encode_text();
                        break;
                    }
                    case 29: {
                        this.zop_copy_table();
                        break;
                    }
                    case 30: {
                        this.zop_print_table();
                        break;
                    }
                    case 31: {
                        this.getBranch();
                        this.zop_check_arg_count();
                        break;
                    }
                    default: {
                        this.zui.fatal("Unknown VAR - probably a bug.");
                        break;
                    }
                }
            } else if (this.curOpcodeType == 4) {
                switch (this.curOpcode) {
                    case 0: {
                        this.getResult();
                        this.zop_ext_save();
                        break;
                    }
                    case 1: {
                        this.getResult();
                        this.zop_ext_restore();
                        break;
                    }
                    case 2: {
                        this.getResult();
                        this.zop_log_shift();
                        break;
                    }
                    case 3: {
                        this.getResult();
                        this.zop_art_shift();
                        break;
                    }
                    case 4: {
                        this.getResult();
                        this.zop_set_font();
                        break;
                    }
                    case 5: {
                        this.zop_draw_picture();
                        break;
                    }
                    case 6: {
                        this.getBranch();
                        this.zop_picture_data();
                        break;
                    }
                    case 7: {
                        this.zop_erase_picture();
                        break;
                    }
                    case 8: {
                        this.zop_set_margins();
                        break;
                    }
                    case 9: {
                        this.getResult();
                        this.zop_save_undo();
                        break;
                    }
                    case 10: {
                        this.getResult();
                        this.zop_restore_undo();
                        break;
                    }
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: {
                        this.zui.fatal("Unspecified EXT instruction: " + this.curOpcode);
                    }
                    case 16: {
                        this.zop_move_window();
                        break;
                    }
                    case 17: {
                        this.zop_window_size();
                        break;
                    }
                    case 18: {
                        this.zop_window_style();
                        break;
                    }
                    case 19: {
                        this.getResult();
                        this.zop_get_wind_prop();
                        break;
                    }
                    case 20: {
                        this.zop_scroll_window();
                        break;
                    }
                    case 21: {
                        this.zop_pop_stack();
                        break;
                    }
                    case 22: {
                        this.zop_read_mouse();
                        break;
                    }
                    case 23: {
                        this.zop_mouse_window();
                        break;
                    }
                    case 24: {
                        this.getBranch();
                        this.zop_push_stack();
                        break;
                    }
                    case 25: {
                        this.zop_put_wind_prop();
                        break;
                    }
                    case 26: {
                        this.zop_print_form();
                        break;
                    }
                    case 27: {
                        this.getBranch();
                        this.zop_make_menu();
                        break;
                    }
                    case 28: {
                        this.zop_picture_table();
                        break;
                    }
                    default: {
                        this.zui.fatal("Unspecified EXT instruction: " + this.curOpcode);
                        break;
                    }
                }
            } else {
                this.zui.fatal("Unknown instruction: " + this.curInstruction);
            }
            if (!this.decode_ret_flag) continue;
            this.decode_ret_flag = false;
            return;
        } while (!this.restartFlag);
    }

    private void getBranch() {
        int b1 = this.memory.fetchByte(this.curCallFrame.pc);
        ++this.curCallFrame.pc;
        this.curBranchReversed = (b1 & 0x80) != 128;
        if ((b1 & 0x40) == 64) {
            this.curBranch = b1 & 0x3F;
            return;
        }
        int b2 = this.memory.fetchByte(this.curCallFrame.pc);
        ++this.curCallFrame.pc;
        int sval = ((b1 & 0x3F) << 8 & 0x3F00 | b2) & 0x3FFF;
        this.curBranch = (sval & 0x2000) == 8192 ? sval - 16384 : sval;
    }

    private void doBranch() {
        if (this.curBranchReversed) {
            return;
        }
        switch (this.curBranch) {
            case 0: {
                this.zop_rfalse();
                break;
            }
            case 1: {
                this.zop_rtrue();
                break;
            }
            default: {
                this.curCallFrame.pc = this.curCallFrame.pc + this.curBranch - 2;
            }
        }
    }

    private void dontBranch() {
        if (this.curBranchReversed) {
            switch (this.curBranch) {
                case 0: {
                    this.zop_rfalse();
                    break;
                }
                case 1: {
                    this.zop_rtrue();
                    break;
                }
                default: {
                    this.curCallFrame.pc = this.curCallFrame.pc + this.curBranch - 2;
                }
            }
            return;
        }
    }

    private void getResult() {
        this.curResult = this.memory.fetchByte(this.curCallFrame.pc);
        ++this.curCallFrame.pc;
    }

    private void getString() {
        this.curString = this.decodeZString(this.curCallFrame.pc);
        int w = this.memory.fetchWord(this.curCallFrame.pc);
        this.curCallFrame.pc += 2;
        while ((w & 0x8000) == 0) {
            w = this.memory.fetchWord(this.curCallFrame.pc);
            this.curCallFrame.pc += 2;
        }
    }

    private String decodeZString(int addr) {
        int w;
        StringBuffer decodedstr = new StringBuffer();
        int tmpaddr = addr;
        int zlen = 0;
        do {
            w = this.memory.fetchWord(tmpaddr);
            tmpaddr += 2;
            zlen += 3;
        } while ((w & 0x8000) != 32768);
        int[] zchars = new int[zlen];
        int curindex = 0;
        tmpaddr = addr;
        w = this.memory.fetchWord(tmpaddr);
        tmpaddr += 2;
        zchars[curindex] = w >> 10 & 0x1F;
        zchars[curindex + 1] = w >> 5 & 0x1F;
        zchars[curindex + 2] = w & 0x1F;
        curindex += 3;
        while ((w & 0x8000) == 0) {
            w = this.memory.fetchWord(tmpaddr);
            tmpaddr += 2;
            zchars[curindex] = w >> 10 & 0x1F;
            zchars[curindex + 1] = w >> 5 & 0x1F;
            zchars[curindex + 2] = w & 0x1F;
            curindex += 3;
        }
        char c = '\u0000';
        char c2 = '\u0000';
        char c3 = '\u0000';
        int currentAlphabet = this.alphabetL;
        int lockAlphabet = this.alphabetL;
        block10: for (int i = 0; i < zlen; ++i) {
            c = (char)zchars[i];
            switch (c) {
                case '\u0001': {
                    if (this.version == 1) {
                        decodedstr.append("\n");
                        currentAlphabet = lockAlphabet;
                        continue block10;
                    }
                    if (++i >= zlen) continue block10;
                    c2 = (char)zchars[i];
                    int abbrevAddr = this.memory.fetchWord(this.abbrevTable + ((c - '\u0001') * 32 + c2) * 2);
                    decodedstr.append(this.decodeZString(abbrevAddr *= 2));
                    continue block10;
                }
                case '\u0002': {
                    if (this.version <= 2) {
                        if (currentAlphabet == this.alphabetP) {
                            currentAlphabet = this.alphabetL;
                            continue block10;
                        }
                        ++currentAlphabet;
                        continue block10;
                    }
                    if (++i >= zlen) continue block10;
                    c2 = (char)zchars[i];
                    int abbrevAddr = this.memory.fetchWord(this.abbrevTable + ((c - '\u0001') * 32 + c2) * 2);
                    decodedstr.append(this.decodeZString(abbrevAddr *= 2));
                    continue block10;
                }
                case '\u0003': {
                    if (this.version <= 2) {
                        if (currentAlphabet == this.alphabetL) {
                            currentAlphabet = this.alphabetP;
                            continue block10;
                        }
                        if (currentAlphabet == this.alphabetP) {
                            currentAlphabet = this.alphabetU;
                            continue block10;
                        }
                        currentAlphabet = this.alphabetL;
                        continue block10;
                    }
                    if (++i >= zlen) continue block10;
                    c2 = (char)zchars[i];
                    int abbrevAddr = this.memory.fetchWord(this.abbrevTable + ((c - '\u0001') * 32 + c2) * 2);
                    decodedstr.append(this.decodeZString(abbrevAddr *= 2));
                    continue block10;
                }
                case '\u0004': {
                    currentAlphabet = currentAlphabet == this.alphabetP ? this.alphabetL : ++currentAlphabet;
                    if (this.version > 2) continue block10;
                    lockAlphabet = currentAlphabet;
                    continue block10;
                }
                case '\u0005': {
                    currentAlphabet = currentAlphabet == this.alphabetL ? this.alphabetP : (currentAlphabet == this.alphabetP ? this.alphabetU : this.alphabetL);
                    if (this.version > 2) continue block10;
                    lockAlphabet = currentAlphabet;
                    continue block10;
                }
                case '\u0006': {
                    if (currentAlphabet == this.alphabetP) {
                        if (++i >= zlen) continue block10;
                        c2 = (char)zchars[i];
                        if (++i >= zlen) continue block10;
                        c3 = (char)zchars[i];
                        w = c2 << 5 & 0x3E0 | c3 & 0x1F;
                        decodedstr.append(String.valueOf((char)w));
                        currentAlphabet = lockAlphabet;
                        continue block10;
                    }
                    decodedstr.append(String.valueOf(this.alphabet[currentAlphabet][c]));
                    currentAlphabet = lockAlphabet;
                    continue block10;
                }
                default: {
                    decodedstr.append(String.valueOf(this.alphabet[currentAlphabet][c]));
                    currentAlphabet = lockAlphabet;
                }
            }
        }
        return decodedstr.toString();
    }

    private Vector encodeZString(String text) {
        Vector<Integer> outbuf = new Vector<Integer>();
        int curtextindex = 0;
        int textlen = text.length();
        for (curtextindex = 0; curtextindex < textlen; ++curtextindex) {
            char curchar = text.charAt(curtextindex);
            if (!this.altCharSet) {
                if (Character.isLowerCase(curchar)) {
                    outbuf.addElement(new Integer(curchar - 97 + 6));
                    continue;
                }
                if (Character.isUpperCase(curchar)) {
                    if (this.version < 3) {
                        outbuf.addElement(new Integer(2));
                    } else {
                        outbuf.addElement(new Integer(4));
                    }
                    outbuf.addElement(new Integer(curchar - 65 + 6));
                    continue;
                }
            }
            if (curchar == '\r' || curchar == '\n') {
                if (this.version == 1) {
                    outbuf.addElement(new Integer(1));
                    continue;
                }
                if (this.version < 3) {
                    outbuf.addElement(new Integer(3));
                } else {
                    outbuf.addElement(new Integer(5));
                }
                outbuf.addElement(new Integer(7));
                continue;
            }
            boolean found = false;
            for (int i = 6; i < 32; ++i) {
                if (this.alphabet[this.alphabetL][i] == curchar) {
                    outbuf.addElement(new Integer(i));
                    found = true;
                    continue;
                }
                if (this.alphabet[this.alphabetU][i] == curchar) {
                    if (this.version < 3) {
                        outbuf.addElement(new Integer(2));
                    } else {
                        outbuf.addElement(new Integer(4));
                    }
                    outbuf.addElement(new Integer(i));
                    found = true;
                    continue;
                }
                if (this.alphabet[this.alphabetP][i] != curchar) continue;
                if (this.version < 3) {
                    outbuf.addElement(new Integer(3));
                } else {
                    outbuf.addElement(new Integer(5));
                }
                outbuf.addElement(new Integer(i));
                found = true;
            }
            if (found) continue;
            if (this.version < 3) {
                outbuf.addElement(new Integer(3));
            } else {
                outbuf.addElement(new Integer(5));
            }
            outbuf.addElement(new Integer(6));
            outbuf.addElement(new Integer(curchar >> 5 & 0x1F));
            outbuf.addElement(new Integer(curchar & 0x1F));
        }
        return outbuf;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int getVariable(int v) {
        if (v == 0) {
            if (!this.curCallFrame.routineStack.empty()) {
                Integer i = (Integer)this.curCallFrame.routineStack.pop();
                return i;
            }
            this.zui.fatal("Routine stack underflow");
        } else {
            if (v >= 1 && v <= 15) {
                return this.curCallFrame.localVars[v - 1];
            }
            if (v >= 16 && v <= 255) {
                return this.memory.fetchWord(this.globalVars + (v - 16) * 2);
            }
        }
        this.zui.fatal("Unspecified variable referenced");
        return 0;
    }

    private void putVariable(int v, int value) {
        value &= 0xFFFF;
        if (v == 0) {
            Integer i = new Integer(value);
            this.curCallFrame.routineStack.push(i);
        } else if (v >= 1 && v <= 15) {
            this.curCallFrame.localVars[v - 1] = value;
        } else if (v >= 16 && v <= 255) {
            this.memory.putWord(this.globalVars + (v - 16) * 2, value);
        } else {
            this.zui.fatal("Unspecified variable referenced");
        }
    }

    private int unpackAddr(int paddr, boolean raddr) {
        int addr = 0;
        int offset = 0;
        switch (this.version) {
            case 1: 
            case 2: 
            case 3: {
                addr = 2 * paddr;
                break;
            }
            case 4: 
            case 5: {
                addr = 4 * paddr;
                break;
            }
            case 6: 
            case 7: {
                offset = raddr ? this.memory.fetchWord(40) : this.memory.fetchWord(42);
                addr = 4 * addr + 8 * offset;
                break;
            }
            case 8: {
                addr = 8 * paddr;
            }
        }
        return addr;
    }

    private int signedWord(int w) {
        if ((w & 0x8000) == 32768) {
            return w - 65536;
        }
        return w;
    }

    private int unsignedWord(int w) {
        if ((w &= 0xFFFF) < 0) {
            return 65536 - -w;
        }
        return w;
    }

    private int interrupt(int raddr) {
        int addr = this.unpackAddr(raddr, true);
        int numvars = this.memory.fetchByte(addr);
        int newFrameAddr = this.curCallFrame.frameNumber + 1;
        this.callStack.push(this.curCallFrame);
        this.curCallFrame = new ZCallFrame();
        this.curCallFrame.pc = this.version < 5 ? addr + numvars * 2 : ++addr;
        this.curCallFrame.routineStack = new Stack();
        for (int i = 0; i < numvars; ++i) {
            this.curCallFrame.localVars[i] = this.version < 5 ? this.memory.fetchWord(addr + i * 2) : 0;
        }
        this.curCallFrame.callType = 2;
        this.curCallFrame.argCount = 0;
        this.curCallFrame.frameNumber = newFrameAddr;
        this.decodeLoop();
        return this.ret_value;
    }

    private void dumpState(DataOutputStream dos) throws IOException {
        int i;
        int n = 0;
        dos.writeInt(this.curCallFrame.pc);
        for (i = 0; i < 15; ++i) {
            dos.writeInt(this.curCallFrame.localVars[i]);
        }
        dos.writeInt(this.curCallFrame.numLocalVars);
        dos.writeInt(this.curCallFrame.callType);
        dos.writeInt(this.curCallFrame.argCount);
        dos.writeInt(this.curCallFrame.frameNumber);
        this.dumpStack(dos, this.curCallFrame.routineStack);
        Stack tmpstack = new Stack();
        while (!this.callStack.empty()) {
            tmpstack.push(this.callStack.pop());
            ++n;
        }
        dos.writeInt(n);
        while (!tmpstack.empty()) {
            ZCallFrame thisframe = (ZCallFrame)tmpstack.pop();
            dos.writeInt(thisframe.pc);
            for (i = 0; i < 15; ++i) {
                dos.writeInt(thisframe.localVars[i]);
            }
            dos.writeInt(thisframe.numLocalVars);
            dos.writeInt(thisframe.callType);
            dos.writeInt(thisframe.argCount);
            dos.writeInt(thisframe.frameNumber);
            this.dumpStack(dos, thisframe.routineStack);
            this.callStack.push(thisframe);
        }
    }

    private void readState(DataInputStream dis) throws IOException {
        int i;
        this.curCallFrame = new ZCallFrame();
        this.curCallFrame.pc = dis.readInt();
        for (i = 0; i < 15; ++i) {
            this.curCallFrame.localVars[i] = dis.readInt();
        }
        this.curCallFrame.numLocalVars = dis.readInt();
        this.curCallFrame.callType = dis.readInt();
        this.curCallFrame.argCount = dis.readInt();
        this.curCallFrame.frameNumber = dis.readInt();
        this.curCallFrame.routineStack = new Stack();
        this.readStack(dis, this.curCallFrame.routineStack);
        this.callStack = new Stack();
        int nframes = dis.readInt();
        for (int j = 0; j < nframes; ++j) {
            ZCallFrame thisframe = new ZCallFrame();
            thisframe.pc = dis.readInt();
            for (i = 0; i < 15; ++i) {
                thisframe.localVars[i] = dis.readInt();
            }
            thisframe.numLocalVars = dis.readInt();
            thisframe.callType = dis.readInt();
            thisframe.argCount = dis.readInt();
            thisframe.frameNumber = dis.readInt();
            thisframe.routineStack = new Stack();
            this.readStack(dis, thisframe.routineStack);
            this.callStack.push(thisframe);
        }
    }

    private void dumpStack(DataOutputStream dos, Stack st) throws IOException {
        int n = 0;
        Stack tmpstack = new Stack();
        while (!st.empty()) {
            tmpstack.push(st.pop());
            ++n;
        }
        dos.writeInt(n);
        while (!tmpstack.empty()) {
            Integer i = (Integer)tmpstack.pop();
            dos.writeInt(i);
            st.push(i);
        }
    }

    private void readStack(DataInputStream dis, Stack st) throws IOException {
        int nelements = dis.readInt();
        for (int i = 0; i < nelements; ++i) {
            Integer tmp = new Integer(dis.readInt());
            st.push(tmp);
        }
    }

    private void zop_rtrue() {
        this.op1 = 1;
        this.zop_ret();
    }

    private void zop_rfalse() {
        this.op1 = 0;
        this.zop_ret();
    }

    private void zop_print() {
        this.ioCard.printString(this.curString);
    }

    private void zop_print_rtrue() {
        this.zop_print();
        this.zop_new_line();
        this.zop_rtrue();
    }

    private void zop_nop() {
    }

    private void zop_save() {
        String fn = this.zui.getFilename("Save Game", null, true);
        if (fn == null) {
            if (this.version <= 3) {
                this.dontBranch();
            } else {
                this.putVariable(this.curResult, 0);
            }
            return;
        }
        try {
            FileOutputStream fos = new FileOutputStream(fn);
            DataOutputStream dos = new DataOutputStream(fos);
            this.dumpState(dos);
            this.memory.dumpMemory(dos, 0, this.dynamicMemorySize);
            fos.close();
        }
        catch (IOException ex1) {
            if (this.version <= 3) {
                this.dontBranch();
            } else {
                this.putVariable(this.curResult, 0);
            }
            return;
        }
        if (this.version <= 3) {
            this.doBranch();
        } else {
            this.putVariable(this.curResult, 1);
        }
    }

    private void zop_restore() {
        String fn = this.zui.getFilename("Restore Game", null, false);
        if (fn == null) {
            if (this.version >= 4) {
                this.putVariable(this.curResult, 0);
            }
            return;
        }
        int tsBit = this.memory.fetchWord(16) & 1;
        try {
            FileInputStream fis = new FileInputStream(fn);
            DataInputStream dis = new DataInputStream(fis);
            this.readState(dis);
            this.memory.readMemory(dis, 0, this.dynamicMemorySize);
            fis.close();
        }
        catch (IOException ex1) {
            if (this.version >= 4) {
                this.putVariable(this.curResult, 0);
            }
            return;
        }
        this.memory.putWord(16, this.memory.fetchWord(16) | tsBit);
        if (this.version >= 3) {
            this.curResult = this.memory.fetchByte(this.curCallFrame.pc - 1);
            this.putVariable(this.curResult, 2);
        }
    }

    private void zop_restart() {
        this.zui.restart();
        this.restartFlag = true;
    }

    private void zop_ret_pulled() {
        this.op1 = this.getVariable(0);
        this.zop_ret();
    }

    private void zop_pop() {
        this.getVariable(0);
    }

    private void zop_catch() {
        this.putVariable(this.curResult, this.curCallFrame.frameNumber);
    }

    private void zop_quit() {
        this.zui.quit();
    }

    private void zop_new_line() {
        this.did_newline = true;
        this.ioCard.printString("\n");
    }

    private void zop_show_status() {
        if (this.version > 3) {
            return;
        }
        boolean timegame = (this.memory.fetchByte(1) & 2) == 2;
        int name = this.objTable.getObjectName(this.getVariable(16));
        String s = this.decodeZString(name);
        int a = this.signedWord(this.getVariable(17));
        int b = this.signedWord(this.getVariable(18));
        this.zui.showStatusBar(s, a, b, timegame);
    }

    private void zop_verify() {
        this.doBranch();
    }

    private void zop_piracy() {
        this.doBranch();
    }

    private void zop_jz() {
        if (this.op1 == 0) {
            this.doBranch();
        } else {
            this.dontBranch();
        }
    }

    private void zop_get_sibling() {
        int sib = this.objTable.getSibling(this.op1);
        this.putVariable(this.curResult, sib);
        if (sib != 0) {
            this.doBranch();
        } else {
            this.dontBranch();
        }
    }

    private void zop_get_child() {
        int child = this.objTable.getChild(this.op1);
        this.putVariable(this.curResult, child);
        if (child != 0) {
            this.doBranch();
        } else {
            this.dontBranch();
        }
    }

    private void zop_get_parent() {
        int parent = this.objTable.getParent(this.op1);
        this.putVariable(this.curResult, parent);
    }

    private void zop_get_prop_len() {
        int len = this.objTable.getPropertyLength(this.op1);
        this.putVariable(this.curResult, len);
    }

    private void zop_inc() {
        int w = this.signedWord(this.getVariable(this.op1));
        w = (w + 1) % 65536;
        this.putVariable(this.op1, w);
    }

    private void zop_dec() {
        int w = this.signedWord(this.getVariable(this.op1));
        w = (w - 1) % 65536;
        this.putVariable(this.op1, w);
    }

    private void zop_print_addr() {
        String s = this.decodeZString(this.op1);
        this.ioCard.printString(s);
    }

    private void zop_call_f0() {
        this.numvops = 1;
        this.vops[0] = this.op1;
        this.zop_call_fv();
    }

    private void zop_remove_obj() {
        int parent = this.objTable.getParent(this.op1);
        if (this.op1 == 0) {
            return;
        }
        this.objTable.removeObject(parent, this.op1);
    }

    private void zop_print_obj() {
        int addr = this.objTable.getObjectName(this.op1);
        String s = this.decodeZString(addr);
        this.ioCard.printString(s);
    }

    private void zop_ret() {
        if (this.callStack.empty()) {
            this.zui.fatal("Call stack underflow");
        }
        if (this.curCallFrame.callType == 1) {
            this.curCallFrame = (ZCallFrame)this.callStack.pop();
            return;
        }
        if (this.curCallFrame.callType == 0) {
            this.curCallFrame = (ZCallFrame)this.callStack.pop();
            this.curResult = this.memory.fetchByte(this.curCallFrame.pc);
            ++this.curCallFrame.pc;
            this.putVariable(this.curResult, this.op1);
            return;
        }
        if (this.curCallFrame.callType == 2) {
            this.curCallFrame = (ZCallFrame)this.callStack.pop();
            this.decode_ret_flag = true;
            this.ret_value = this.op1;
            return;
        }
        this.zui.fatal("Corrupted call frame");
    }

    private void zop_jump() {
        int sop1 = this.signedWord(this.op1);
        this.curCallFrame.pc = this.curCallFrame.pc + sop1 - 2;
    }

    private void zop_print_paddr() {
        int addr = this.unpackAddr(this.op1, false);
        String s = this.decodeZString(addr);
        this.ioCard.printString(s);
    }

    private void zop_load() {
        int w = this.getVariable(this.op1);
        this.putVariable(this.curResult, w);
    }

    private void zop_not() {
        int val = this.op1type == 1 ? ~this.op1 & 0xFFFF : ~this.op1 & 0xFF;
        this.putVariable(this.curResult, val);
    }

    private void zop_call_p0() {
        this.numvops = 1;
        this.vops[0] = this.op1;
        this.zop_call_pv();
    }

    private void zop_je() {
        if (this.curInstruction == 193) {
            for (int i = 1; i < this.numvops; ++i) {
                if (this.vops[0] != this.vops[i]) continue;
                this.doBranch();
                return;
            }
            this.dontBranch();
            return;
        }
        if (this.op1 == this.op2) {
            this.doBranch();
        } else {
            this.dontBranch();
        }
    }

    private void zop_jl() {
        int sop2;
        int sop1 = this.signedWord(this.op1);
        if (sop1 < (sop2 = this.signedWord(this.op2))) {
            this.doBranch();
        } else {
            this.dontBranch();
        }
    }

    private void zop_jg() {
        int sop2;
        int sop1 = this.signedWord(this.op1);
        if (sop1 > (sop2 = this.signedWord(this.op2))) {
            this.doBranch();
        } else {
            this.dontBranch();
        }
    }

    private void zop_dec_jl() {
        this.zop_dec();
        this.op1 = this.getVariable(this.op1);
        this.op1type = 1;
        this.zop_jl();
    }

    private void zop_inc_jg() {
        this.zop_inc();
        this.op1 = this.getVariable(this.op1);
        this.op1type = 1;
        this.zop_jg();
    }

    private void zop_jin() {
        int parent = this.objTable.getParent(this.op1);
        if (parent == this.op2) {
            this.doBranch();
        } else {
            this.dontBranch();
        }
    }

    private void zop_test() {
        if ((this.op1 & this.op2) == this.op2) {
            this.doBranch();
        } else {
            this.dontBranch();
        }
    }

    private void zop_or() {
        this.putVariable(this.curResult, this.op1 | this.op2);
    }

    private void zop_and() {
        this.putVariable(this.curResult, this.op1 & this.op2);
    }

    private void zop_test_attr() {
        if (this.objTable.hasAttribute(this.op1, this.op2)) {
            this.doBranch();
        } else {
            this.dontBranch();
        }
    }

    private void zop_set_attr() {
        this.objTable.setAttribute(this.op1, this.op2);
    }

    private void zop_clear_attr() {
        this.objTable.clearAttribute(this.op1, this.op2);
    }

    private void zop_store() {
        this.putVariable(this.op1, this.op2);
    }

    private void zop_insert_obj() {
        this.objTable.insertObject(this.op1, this.op2);
    }

    private void zop_loadw() {
        this.putVariable(this.curResult, this.memory.fetchWord(this.op1 + 2 * this.op2));
    }

    private void zop_loadb() {
        this.putVariable(this.curResult, this.memory.fetchByte(this.op1 + this.op2));
    }

    private void zop_get_prop() {
        int prop = this.objTable.getProperty(this.op1, this.op2);
        this.putVariable(this.curResult, prop);
    }

    private void zop_get_prop_addr() {
        int addr = this.objTable.getPropertyAddress(this.op1, this.op2);
        this.putVariable(this.curResult, addr);
    }

    private void zop_get_next_prop() {
        int num = this.objTable.getNextProperty(this.op1, this.op2);
        this.putVariable(this.curResult, num);
    }

    private void zop_add() {
        int sop1 = this.signedWord(this.op1);
        int sop2 = this.signedWord(this.op2);
        this.putVariable(this.curResult, this.unsignedWord(sop1 + sop2));
    }

    private void zop_sub() {
        int sop1 = this.signedWord(this.op1);
        int sop2 = this.signedWord(this.op2);
        this.putVariable(this.curResult, this.unsignedWord(sop1 - sop2));
    }

    private void zop_mul() {
        int sop1 = this.signedWord(this.op1);
        int sop2 = this.signedWord(this.op2);
        this.putVariable(this.curResult, this.unsignedWord(sop1 * sop2));
    }

    private void zop_div() {
        if (this.op2 == 0) {
            this.zui.fatal("Divide by zero");
        }
        int sop1 = this.signedWord(this.op1);
        int sop2 = this.signedWord(this.op2);
        this.putVariable(this.curResult, this.unsignedWord(sop1 / sop2));
    }

    private void zop_mod() {
        if (this.op2 == 0) {
            this.putVariable(this.curResult, this.op1);
            return;
        }
        int sop1 = this.signedWord(this.op1);
        int sop2 = this.signedWord(this.op2);
        this.putVariable(this.curResult, this.unsignedWord(sop1 % sop2));
    }

    private void zop_call_f1() {
        this.numvops = 2;
        this.vops[0] = this.op1;
        this.vops[1] = this.op2;
        this.zop_call_fv();
    }

    private void zop_call_p1() {
        this.numvops = 2;
        this.vops[0] = this.op1;
        this.vops[1] = this.op2;
        this.zop_call_pv();
    }

    private void zop_set_colour() {
        if (this.op1 == 1) {
            this.op1 = this.memory.fetchByte(45);
        }
        if (this.op2 == 1) {
            this.op2 = this.memory.fetchByte(44);
        }
        this.zui.setColor(this.op1, this.op2);
    }

    private void zop_throw() {
        while (this.curCallFrame.frameNumber != this.op2 && !this.callStack.empty()) {
            this.curCallFrame = (ZCallFrame)this.callStack.pop();
        }
        if (this.curCallFrame.frameNumber != this.op2) {
            this.zui.fatal("THROW: Call stack underflow");
        }
        this.zop_ret();
    }

    private void zop_call_fv() {
        if (this.vops[0] == 0) {
            this.putVariable(this.curResult, 0);
            return;
        }
        int numargs = this.numvops - 1;
        int addr = this.unpackAddr(this.vops[0], true);
        int numvars = this.memory.fetchByte(addr);
        ++addr;
        --this.curCallFrame.pc;
        int newFrameNumber = this.curCallFrame.frameNumber + 1;
        this.callStack.push(this.curCallFrame);
        this.curCallFrame = new ZCallFrame();
        this.curCallFrame.pc = this.version < 5 ? addr + numvars * 2 : addr;
        this.curCallFrame.routineStack = new Stack();
        this.curCallFrame.numLocalVars = numvars;
        for (int i = 0; i < numvars; ++i) {
            this.curCallFrame.localVars[i] = i < numargs ? this.vops[i + 1] : (this.version < 5 ? this.memory.fetchWord(addr + i * 2) : 0);
        }
        this.curCallFrame.callType = 0;
        this.curCallFrame.argCount = numargs > numvars ? numvars : numargs;
        this.curCallFrame.frameNumber = newFrameNumber;
    }

    private void zop_storew() {
        this.memory.putWord(this.vops[0] + 2 * this.vops[1], this.vops[2]);
    }

    private void zop_storeb() {
        this.memory.putByte(this.vops[0] + this.vops[1], this.vops[2]);
    }

    private void zop_put_prop() {
        this.objTable.putProperty(this.vops[0], this.vops[1], this.vops[2]);
    }

    private void zop_read() {
        int i;
        int termChar;
        int time = 0;
        int raddr = 0;
        int baddr1 = this.vops[0];
        int baddr2 = this.vops[1];
        if (this.numvops > 2) {
            time = this.vops[2];
            raddr = this.vops[3];
        }
        this.ioCard.outputFlush();
        if (this.version < 4) {
            this.zop_show_status();
        }
        StringBuffer sb = new StringBuffer();
        if (time > 0 && raddr > 0) {
            while ((termChar = this.ioCard.readLine(sb, time)) == -1) {
                for (i = 0; i < sb.length(); ++i) {
                    this.ioCard.printString("\b");
                }
                int rc = this.interrupt(raddr);
                if (rc == 0) {
                    this.ioCard.printString(sb.toString());
                    this.ioCard.outputFlush();
                    continue;
                }
                this.ioCard.outputFlush();
                sb = new StringBuffer();
                termChar = 0;
                break;
            }
        } else {
            termChar = this.ioCard.readLine(sb, 0);
        }
        String s = sb.toString();
        if (this.version <= 4) {
            int curaddr = baddr1 + 1;
            int len = s.length();
            for (i = 0; i < len; ++i) {
                this.memory.putByte(curaddr, Character.toLowerCase(s.charAt(i)));
                ++curaddr;
            }
            this.memory.putByte(curaddr, 0);
        } else {
            int nchars = this.memory.fetchByte(baddr1 + 1);
            int curaddr = baddr1 + 2 + nchars;
            int len = s.length();
            for (int i2 = 0; i2 < len; ++i2) {
                this.memory.putByte(curaddr, Character.toLowerCase(s.charAt(i2)));
                ++curaddr;
            }
            this.memory.putByte(baddr1 + 1, nchars + len);
        }
        if (baddr2 != 0) {
            this.vops[0] = baddr1;
            this.vops[1] = baddr2;
            this.numvops = 2;
            this.zop_tokenise();
        }
        if (this.version >= 5) {
            this.putVariable(this.curResult, termChar);
        }
    }

    private void zop_print_char() {
        String s = new String(String.valueOf((char)this.vops[0]));
        this.ioCard.printString(s);
    }

    private void zop_print_num() {
        int sop1 = this.signedWord(this.vops[0]);
        String s = new String(String.valueOf(sop1));
        this.ioCard.printString(s);
    }

    private void zop_random() {
        if (this.signedWord(this.vops[0]) > 0) {
            this.putVariable(this.curResult, this.rndgen.getRandom(this.signedWord(this.vops[0])));
        } else {
            this.rndgen.seed(this.signedWord(this.vops[0]));
            this.putVariable(this.curResult, 0);
        }
    }

    private void zop_push() {
        this.putVariable(0, this.vops[0]);
    }

    private void zop_pull() {
        this.putVariable(this.vops[0], this.getVariable(0));
    }

    private void zop_split_screen() {
        this.ioCard.outputFlush();
        this.zui.splitScreen(this.vops[0]);
    }

    private void zop_set_window() {
        this.ioCard.outputFlush();
        this.zui.setCurrentWindow(this.vops[0]);
    }

    private void zop_call_fd() {
        this.zop_call_fv();
    }

    private void zop_erase_window() {
        int sop1 = this.signedWord(this.vops[0]);
        if (sop1 == -1) {
            this.zui.eraseWindow(0);
            this.zui.eraseWindow(1);
            this.vops[0] = 0;
            this.numvops = 1;
            this.zop_split_screen();
            return;
        }
        this.zui.eraseWindow(this.vops[0]);
    }

    private void zop_erase_line() {
        this.zui.eraseLine(1);
    }

    private void zop_set_cursor() {
        this.ioCard.outputFlush();
        this.zui.setCursorPosition(this.vops[1], this.vops[0]);
    }

    private void zop_get_cursor() {
        this.ioCard.outputFlush();
        Point p = this.zui.getCursorPosition();
        this.memory.putWord(this.vops[0], p.y);
        this.memory.putWord(this.vops[0] + 2, p.x);
    }

    private void zop_set_text_style() {
        this.ioCard.outputFlush();
        this.zui.setTextStyle(this.vops[0]);
        Dimension s = this.zui.getFontSize();
        this.memory.putByte(38, s.height);
        this.memory.putByte(39, s.width);
    }

    private void zop_buffer_mode() {
        this.ioCard.outputFlush();
    }

    private void zop_output_stream() {
        if (this.numvops == 3) {
            this.ioCard.setOutputStream(this.signedWord(this.vops[0]), this.vops[1], this.vops[2], true);
        } else {
            this.ioCard.setOutputStream(this.signedWord(this.vops[0]), this.vops[1], 0, false);
        }
    }

    private void zop_input_stream() {
        this.ioCard.setInputStream(this.vops[0]);
    }

    private void zop_sound() {
        if (this.numvops == 1) {
            return;
        }
        if (this.vops[1] != 2) {
            return;
        }
        this.op1 = this.vops[3];
        this.op1type = this.voptypes[3];
        this.zop_call_p0();
    }

    private void zop_read_char() {
        this.ioCard.outputFlush();
        if (this.numvops > 1 && this.vops[1] != 0 && this.vops[2] != 0) {
            int c;
            while ((c = this.ioCard.readChar(this.vops[1])) == -1) {
                int rc = this.interrupt(this.vops[2]);
                if (rc == 0) continue;
                this.putVariable(this.curResult, 0);
                return;
            }
            this.putVariable(this.curResult, c);
            return;
        }
        int c = this.ioCard.readChar(0);
        this.putVariable(this.curResult, c);
    }

    private void zop_scan_table() {
        int a = this.vops[0];
        int baddr = this.vops[1];
        int n = this.vops[2];
        int format = this.numvops == 4 ? this.vops[3] : 130;
        boolean searchWord = (format & 0x80) == 128;
        int tableWidth = format & 0x7F;
        if (tableWidth == 2 && this.voptypes[0] == 0) {
            this.putVariable(this.curResult, 0);
            this.dontBranch();
            return;
        }
        for (int i = 0; i < n; ++i) {
            int testAddr = baddr + i * tableWidth;
            int testData = searchWord ? this.memory.fetchWord(testAddr) : this.memory.fetchByte(testAddr);
            if (testData != a) continue;
            this.putVariable(this.curResult, baddr + i * tableWidth);
            this.doBranch();
            return;
        }
        this.putVariable(this.curResult, 0);
        this.dontBranch();
    }

    private void zop_call_pv() {
        if (this.vops[0] == 0) {
            this.putVariable(this.curResult, 0);
            return;
        }
        int numargs = this.numvops - 1;
        int addr = this.unpackAddr(this.vops[0], true);
        int numvars = this.memory.fetchByte(addr);
        int newFrameNumber = this.curCallFrame.frameNumber + 1;
        this.callStack.push(this.curCallFrame);
        this.curCallFrame = new ZCallFrame();
        this.curCallFrame.pc = this.version < 5 ? addr + numvars * 2 : ++addr;
        this.curCallFrame.routineStack = new Stack();
        this.curCallFrame.numLocalVars = numvars;
        for (int i = 0; i < numvars; ++i) {
            this.curCallFrame.localVars[i] = i < numargs ? this.vops[i + 1] : (this.version < 5 ? this.memory.fetchWord(addr + i * 2) : 0);
        }
        this.curCallFrame.callType = 1;
        this.curCallFrame.argCount = numargs > numvars ? numvars : numargs;
        this.curCallFrame.frameNumber = newFrameNumber;
    }

    private void zop_tokenise() {
        int i;
        int curaddr;
        int bit;
        int dictaddr;
        boolean match = true;
        if (this.numvops > 2) {
            dictaddr = this.vops[2];
            bit = this.vops[3];
        } else {
            dictaddr = this.mainDictionary;
            bit = 0;
        }
        int maxtokens = this.memory.fetchByte(this.vops[1]);
        int maxtokenlen = this.version < 4 ? 2 : 3;
        String s = new String();
        if (this.version <= 4) {
            curaddr = this.vops[0] + 1;
            int c = this.memory.fetchByte(curaddr);
            while (c != 0) {
                s = s + String.valueOf((char)c);
                c = this.memory.fetchByte(++curaddr);
            }
        } else {
            int len = this.memory.fetchByte(this.vops[0] + 1);
            curaddr = this.vops[0] + 2;
            for (i = 0; i < len; ++i) {
                s = s + String.valueOf((char)this.memory.fetchByte(curaddr));
                ++curaddr;
            }
        }
        String delimiters = new String(" ");
        int numseparators = this.memory.fetchByte(dictaddr);
        for (i = 1; i <= numseparators; ++i) {
            delimiters = delimiters + String.valueOf((char)this.memory.fetchByte(dictaddr + i));
        }
        curaddr = dictaddr + 1 + numseparators;
        int dictentrysize = this.memory.fetchByte(curaddr);
        int numdictentries = this.signedWord(this.memory.fetchWord(++curaddr));
        curaddr += 2;
        if (numdictentries < 0) {
            numdictentries = Math.abs(numdictentries);
        }
        StringTokenizer tokens = new StringTokenizer(s, delimiters, true);
        int numtokens = 0;
        int strpos = 0;
        while (tokens.hasMoreTokens() && numtokens < maxtokens) {
            String thistoken = tokens.nextToken();
            if (thistoken.equals(" ")) {
                ++strpos;
                continue;
            }
            Vector encodedtoken = this.encodeZString(thistoken);
            for (i = 0; i < numdictentries; ++i) {
                match = true;
                int curindex = 0;
                for (int j = 0; j < maxtokenlen; ++j) {
                    int curword = this.memory.fetchWord(curaddr + i * dictentrysize + j * 2);
                    for (int k = 2; k >= 0; --k) {
                        int curzchar = curword >> k * 5 & 0x1F;
                        if (curindex == encodedtoken.size()) {
                            if (curzchar == 5) continue;
                            match = false;
                            break;
                        }
                        Integer n = (Integer)encodedtoken.elementAt(curindex);
                        ++curindex;
                        if (curzchar == n) continue;
                        match = false;
                        break;
                    }
                    if (!match) break;
                }
                if (match) break;
            }
            if (i >= numdictentries) {
                match = false;
            }
            if (match) {
                this.memory.putWord(this.vops[1] + 2 + numtokens * 4, curaddr + i * dictentrysize);
                this.memory.putByte(this.vops[1] + 2 + numtokens * 4 + 2, thistoken.length());
                this.memory.putByte(this.vops[1] + 2 + numtokens * 4 + 3, strpos + 2);
            } else if (bit == 0) {
                this.memory.putWord(this.vops[1] + 2 + numtokens * 4, 0);
                this.memory.putByte(this.vops[1] + 2 + numtokens * 4 + 2, thistoken.length());
                this.memory.putByte(this.vops[1] + 2 + numtokens * 4 + 3, strpos + 2);
            }
            strpos += thistoken.length();
            ++numtokens;
        }
        this.memory.putByte(this.vops[1] + 1, numtokens);
    }

    private void zop_encode_text() {
        int i;
        String s = new String();
        for (i = 0; i < this.vops[2]; ++i) {
            s = s + String.valueOf((char)this.memory.fetchByte(this.vops[0] + this.vops[1] + i));
        }
        Vector encodedstr = this.encodeZString(s);
        int maxlen = this.version < 4 ? 2 : 3;
        int curindex = 0;
        int encodedlen = encodedstr.size();
        for (i = 0; i < maxlen; ++i) {
            Integer n;
            int w = 0;
            if (curindex < encodedlen) {
                n = (Integer)encodedstr.elementAt(curindex);
                w |= n << 10 & 0x7C00;
                ++curindex;
            } else {
                w |= 0x1400;
            }
            if (curindex < encodedlen) {
                n = (Integer)encodedstr.elementAt(curindex);
                w |= n << 5 & 0x3E0;
                ++curindex;
            } else {
                w |= 0xA0;
            }
            if (curindex < encodedlen) {
                n = (Integer)encodedstr.elementAt(curindex);
                w |= n & 0x1F;
                ++curindex;
            } else {
                w |= 5;
            }
            this.memory.putWord(this.vops[2] + i * 2, w);
        }
    }

    private void zop_copy_table() {
        int s = this.signedWord(this.vops[2]);
        if (this.vops[1] == 0) {
            for (int i = 0; i < s; ++i) {
                this.memory.putByte(this.vops[0] + i, 0);
            }
            return;
        }
        if (s < 0) {
            for (int i = 0; i < -s; ++i) {
                this.memory.putByte(this.vops[1] + i, this.memory.fetchByte(this.vops[0] + i));
            }
            return;
        }
        for (int i = s - 1; i >= 0; --i) {
            this.memory.putByte(this.vops[1] + i, this.memory.fetchByte(this.vops[0] + i));
        }
    }

    private void zop_print_table() {
        int n;
        int y;
        int baddr = this.vops[0];
        int x = this.vops[1];
        if (this.numvops == 4) {
            y = this.vops[2];
            n = this.vops[3];
        } else {
            y = 1;
            n = 0;
        }
        if (y == 0) {
            return;
        }
        Point p = this.zui.getCursorPosition();
        int baseX = p.x;
        int curY = p.y;
        int lineAddr = baddr;
        for (int i = 0; i < y; ++i) {
            for (int j = 0; j < x; ++j) {
                int c = this.memory.fetchByte(lineAddr + j);
                this.ioCard.printString(String.valueOf((char)c));
            }
            lineAddr += x + n;
        }
    }

    private void zop_check_arg_count() {
        if (this.curCallFrame.argCount >= this.vops[0]) {
            this.doBranch();
        } else {
            this.dontBranch();
        }
    }

    private void zop_ext_save() {
        String fn;
        int slen;
        if (this.numvops == 0) {
            this.zop_save();
            return;
        }
        String suggested = null;
        if (this.numvops > 2 && this.vops[2] != 0 && (slen = this.memory.fetchByte(this.vops[2])) > 0) {
            StringBuffer tmp = new StringBuffer();
            for (int i = 1; i <= slen; ++i) {
                tmp.append(String.valueOf((char)this.memory.fetchByte(this.vops[2] + i)));
            }
            suggested = tmp.toString();
        }
        if ((fn = this.zui.getFilename("Save Auxiliary File", suggested, true)) == null) {
            this.putVariable(this.curResult, 0);
            return;
        }
        try {
            FileOutputStream fos = new FileOutputStream(fn);
            DataOutputStream dos = new DataOutputStream(fos);
            this.memory.dumpMemory(dos, this.vops[0], this.vops[1]);
            fos.close();
        }
        catch (IOException ex1) {
            this.putVariable(this.curResult, 0);
            return;
        }
        this.putVariable(this.curResult, 1);
    }

    private void zop_ext_restore() {
        String fn;
        int slen;
        if (this.numvops == 0) {
            this.zop_restore();
            return;
        }
        String suggested = null;
        if (this.numvops > 2 && this.vops[2] != 0 && (slen = this.memory.fetchByte(this.vops[2])) > 0) {
            StringBuffer tmp = new StringBuffer();
            for (int i = 1; i <= slen; ++i) {
                tmp.append(String.valueOf((char)this.memory.fetchByte(this.vops[2] + i)));
            }
            suggested = tmp.toString();
        }
        if ((fn = this.zui.getFilename("Load Auxiliary File", suggested, false)) == null) {
            this.putVariable(this.curResult, 0);
            return;
        }
        try {
            FileInputStream fis = new FileInputStream(fn);
            DataInputStream dis = new DataInputStream(fis);
            this.memory.readMemory(dis, this.vops[0], this.vops[1]);
            fis.close();
        }
        catch (IOException ex1) {
            this.putVariable(this.curResult, 0);
            return;
        }
        if (this.version >= 3) {
            this.putVariable(this.curResult, this.vops[1]);
        }
    }

    private void zop_log_shift() {
        int sop2 = this.signedWord(this.vops[1]);
        int val = sop2 < 0 ? this.vops[0] >>> Math.abs(sop2) : this.vops[0] << sop2;
        this.putVariable(this.curResult, val);
    }

    private void zop_art_shift() {
        int sop2 = this.signedWord(this.vops[1]);
        int val = sop2 < 0 ? (this.voptypes[0] == 1 && (this.vops[0] & 0x8000) == 32768 || this.voptypes[0] == 0 && (this.vops[0] & 0x80) == 128 ? this.vops[0] >> Math.abs(sop2) : this.vops[0] >>> Math.abs(sop2)) : this.vops[0] << sop2;
        this.putVariable(this.curResult, val);
    }

    private void zop_set_font() {
        this.zui.setFont(this.vops[0]);
        Dimension s = this.zui.getFontSize();
        this.memory.putByte(38, s.height);
        this.memory.putByte(39, s.width);
    }

    private void zop_draw_picture() {
        this.zui.fatal("DRAW_PICTURE instruction unimplemented");
    }

    private void zop_picture_data() {
        this.zui.fatal("PICTURE_DATA instruction unimplemented");
    }

    private void zop_erase_picture() {
        this.zui.fatal("ERASE_PICTURE instruction unimplemented");
    }

    private void zop_set_margins() {
        this.zui.fatal("SET_MARGINS instruction unimplemented");
    }

    private void zop_save_undo() {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(65536);
            DataOutputStream dos = new DataOutputStream(bos);
            this.dumpState(dos);
            this.memory.dumpMemory(dos, 0, this.dynamicMemorySize);
            this.undoState = bos.toByteArray();
        }
        catch (IOException ioex) {
            this.zui.fatal("I/O exception during SAVE_UNDO??");
        }
        if (this.version <= 3) {
            this.doBranch();
        } else {
            this.putVariable(this.curResult, 1);
        }
    }

    private void zop_restore_undo() {
        int tsBit = this.memory.fetchWord(16) & 1;
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(this.undoState);
            DataInputStream dis = new DataInputStream(bis);
            this.readState(dis);
            this.memory.readMemory(dis, 0, this.dynamicMemorySize);
        }
        catch (IOException ex1) {
            this.zui.fatal("I/O Exception during RESTORE_UNDO???");
        }
        this.memory.putWord(16, this.memory.fetchWord(16) | tsBit);
        if (this.version >= 3) {
            this.curResult = this.memory.fetchByte(this.curCallFrame.pc - 1);
            this.putVariable(this.curResult, 2);
        }
    }

    private void zop_move_window() {
        this.zui.fatal("MOVE_WINDOW instruction unimplemented");
    }

    private void zop_window_size() {
        this.zui.fatal("WINDOW_SIZE instruction unimplemented");
    }

    private void zop_window_style() {
        this.zui.fatal("WINDOW_STYLE instruction unimplemented");
    }

    private void zop_get_wind_prop() {
        this.zui.fatal("GET_WINDOW_PROP instruction unimplemented");
    }

    private void zop_scroll_window() {
        this.zui.fatal("SCROLL_WINDOW instruction unimplemented");
    }

    private void zop_pop_stack() {
        this.zui.fatal("POP_STACK instruction unimplemented");
    }

    private void zop_read_mouse() {
        this.zui.fatal("READ_MOUSE instruction unimplemented");
    }

    private void zop_mouse_window() {
        this.zui.fatal("MOUSE_WINDOW instruction unimplemented");
    }

    private void zop_push_stack() {
        this.zui.fatal("PUSH_STACK instruction unimplemented");
    }

    private void zop_put_wind_prop() {
        this.zui.fatal("PUT_WIND_PROP instruction unimplemented");
    }

    private void zop_print_form() {
        this.zui.fatal("PRINT_FORM instruction unimplemented");
    }

    private void zop_make_menu() {
        this.zui.fatal("MAKE_MENU instruction unimplemented");
    }

    private void zop_picture_table() {
        this.zui.fatal("PICTURE_TABLE instruction unimplemented");
    }
}

