/*
 * Decompiled with CFR 0.152.
 */
package terminal;

import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class LCDFont {
    public final int fontWidth;
    public final int fontHeight;
    private final int imageWidth;
    private final int imageHeight;
    private int[] bwBuf;
    private int[] colorBuf;
    private int[] currentBuf;
    private long currentColor;
    private long[] cacheColor;
    private int FR;
    private int FG;
    private int FB;
    private int BR;
    private int BG;
    private int BB;

    public LCDFont(String fontImageName, boolean BGR) {
        Image fontImage;
        try {
            fontImage = Image.createImage((String)fontImageName);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot load LCDFont: " + e);
        }
        this.imageWidth = fontImage.getWidth();
        this.imageHeight = fontImage.getHeight();
        this.fontWidth = this.imageWidth / 32;
        this.fontHeight = this.imageHeight / 3;
        this.bwBuf = new int[this.imageWidth * (this.imageHeight + 1)];
        this.colorBuf = new int[this.imageWidth * (this.imageHeight + 1)];
        fontImage.getRGB(this.bwBuf, 0, this.imageWidth, 0, 0, this.imageWidth, this.imageHeight);
        if (BGR) {
            int i = 0;
            while (i < this.bwBuf.length) {
                int c = this.bwBuf[i];
                this.bwBuf[i] = (c >> 16 & 0xFF) + (c & 0xFF00) + ((c & 0xFF) << 16);
                ++i;
            }
        }
        this.cacheColor = new long[96];
        this.currentBuf = this.bwBuf;
        this.currentColor = 0L;
    }

    public void setColor(int fg, int bg) {
        if (((long)fg << 32) + (long)bg != this.currentColor) {
            this.currentColor = ((long)fg << 32) + (long)bg;
            this.currentBuf = this.colorBuf;
            this.FR = fg >> 16 & 0xFF;
            this.FG = fg >> 8 & 0xFF;
            this.FB = fg & 0xFF;
            this.BR = bg >> 16 & 0xFF;
            this.BG = bg >> 8 & 0xFF;
            this.BB = bg & 0xFF;
            if (28 * this.FR + 55 * this.FG + 17 * this.FB >= 28 * this.BR + 55 * this.BG + 17 * this.BB) {
                this.FR = (6 * this.FR + 2550) / 16;
                this.FG = (6 * this.FG + 2550) / 16;
                this.FB = (6 * this.FB + 2550) / 16;
                this.BR = 10 * this.BR / 16;
                this.BG = 10 * this.BG / 16;
                this.BB = 10 * this.BB / 16;
            } else {
                this.FR = 10 * this.FR / 16;
                this.FG = 10 * this.FG / 16;
                this.FB = 10 * this.FB / 16;
                this.BR = (6 * this.BR + 2550) / 16;
                this.BG = (6 * this.BG + 2550) / 16;
                this.BB = (6 * this.BB + 2550) / 16;
            }
            this.FR += this.FR >> 7;
            this.FG += this.FG >> 7;
            this.FB += this.FB >> 7;
            this.BR += this.BR >> 7;
            this.BG += this.BG >> 7;
            this.BB += this.BB >> 7;
        }
    }

    private void renderColorChar(int offset) {
        int y = 0;
        while (y < this.fontHeight) {
            int x = 0;
            while (x < this.fontWidth) {
                int col = this.bwBuf[offset + y * this.imageWidth + x];
                int R = col >> 16 & 0xFF;
                int G = col >> 8 & 0xFF;
                int B = col & 0xFF;
                R = this.FR * R + this.BR * (255 - R) >> 8;
                G = this.FG * G + this.BG * (255 - G) >> 8;
                B = this.FB * B + this.BB * (255 - B) >> 8;
                this.colorBuf[offset + y * this.imageWidth + x] = (R << 16) + (G << 8) + B;
                ++x;
            }
            ++y;
        }
    }

    public void drawChar(Graphics g, char c, int x, int y) {
        if (c <= ' ' || c > '~') {
            return;
        }
        c = (char)(c - 32);
        int offset = (c >> 5) * this.fontHeight * this.imageWidth + (c & 0x1F) * this.fontWidth;
        if (this.currentBuf == this.colorBuf && this.cacheColor[c] != this.currentColor) {
            this.renderColorChar(offset);
            this.cacheColor[c] = this.currentColor;
        }
        g.drawRGB(this.currentBuf, offset, this.imageWidth, x, y, this.fontWidth, this.fontHeight, false);
    }
}

