/*
 * Decompiled with CFR 0.152.
 */
package zmachine.ui;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.io.file.FileSystemRegistry;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextBox;
import javax.microedition.lcdui.TextField;
import terminal.Settings;
import zmachine.ui.ZaxMidlet;

public class FileDialog
implements CommandListener {
    private ZaxMidlet midlet;
    private Displayable lastDisplayable;
    private Settings settings;
    private TextField charWidthTextField;
    private TextField storyFileTextField;
    public String selected_file;
    private static final String[] attrList = new String[]{"Read", "Write", "Hidden"};
    private static final String[] typeList = new String[]{"Regular File", "Directory"};
    private static final String[] monthList = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private static final String UP_DIRECTORY = "..";
    private static final String MEGA_ROOT = "/";
    private static final String SEP_STR = "/";
    private static final char SEP = '/';
    private String currDirName;
    private Command view = new Command("Select", 8, 1);
    private Command creat = new Command("New", 8, 2);
    private Command delete = new Command("Delete", 8, 3);
    private Command creatOK = new Command("OK", 4, 1);
    private Command prop = new Command("Properties", 8, 2);
    private Command back = new Command("Back", 2, 2);
    private Command exit = new Command("Exit", 7, 3);
    private TextField nameInput;
    private ChoiceGroup typeInput;
    private Image dirIcon;
    private Image fileIcon;
    private Image[] iconList;
    private Command start_browser = new Command("Load Story", 8, 1);
    private Command load_story = new Command("Start Story", 8, 1);
    private Command alert_yes;
    private Command alert_no;
    private int mode;
    public int running = 0;

    public FileDialog(ZaxMidlet midlet, Settings settings) {
        this.midlet = midlet;
        this.lastDisplayable = this.lastDisplayable;
        this.settings = settings;
        this.currDirName = "/";
        try {
            this.dirIcon = Image.createImage((String)"/icons/dir.png");
        }
        catch (IOException e) {
            this.dirIcon = null;
        }
        try {
            this.fileIcon = Image.createImage((String)"/icons/file.png");
        }
        catch (IOException e) {
            this.fileIcon = null;
        }
        this.iconList = new Image[]{this.fileIcon, this.dirIcon};
    }

    public void OpenBrowser(int mode) {
        this.mode = mode;
        this.selected_file = null;
        try {
            this.showCurrDir();
        }
        catch (SecurityException e) {
            Alert alert = new Alert("Error", "You are not authorized to access the restricted API", null, AlertType.ERROR);
            alert.setTimeout(-2);
            Form form = new Form("Cannot access FileConnection");
            form.append((Item)new StringItem(null, "You cannot run this MIDlet with the current permissions. Sign the MIDlet suite, or run it in a different security domain"));
            form.addCommand(this.exit);
            form.setCommandListener((CommandListener)this);
            this.midlet.getDisplay().setCurrent(alert, (Displayable)form);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void createFile() {
        System.out.println("Create File");
        Form creator = new Form("New File (select OK from the menu)");
        this.nameInput = new TextField("Enter Name:", null, 40, 0);
        creator.append((Item)this.nameInput);
        creator.addCommand(this.creatOK);
        creator.addCommand(this.back);
        creator.addCommand(this.exit);
        creator.setCommandListener((CommandListener)this);
        this.midlet.getDisplay().setCurrent((Displayable)creator);
    }

    void createFile(String newName, boolean isDirectory) {
        try {
            if (isDirectory) {
                FileConnection fc = (FileConnection)Connector.open((String)("file:///" + this.currDirName + newName));
                fc.mkdir();
                this.showCurrDir();
            } else {
                this.selected_file = "file://localhost/" + this.currDirName + newName;
                FileConnection fc = (FileConnection)Connector.open((String)this.selected_file);
                if (fc.exists()) {
                    fc.close();
                    this.YesNoAlert();
                } else {
                    fc.close();
                    this.midlet.getDisplay().setCurrent((Displayable)this.midlet.terminal);
                    this.running = 0;
                }
            }
        }
        catch (Exception e) {
            String s = "Can not create file '" + newName + "'";
            if (e.getMessage() != null && e.getMessage().length() > 0) {
                s = String.valueOf(s) + "\n" + e;
            }
            Alert alert = new Alert("Error!", s, null, AlertType.ERROR);
            alert.setTimeout(-2);
            this.midlet.getDisplay().setCurrent((Displayable)alert);
            this.midlet.getDisplay().getCurrent().addCommand(this.creatOK);
            this.midlet.getDisplay().getCurrent().addCommand(this.back);
        }
    }

    private void executeCreateFile(final String name, final boolean val) {
        new Thread(new Runnable(){

            public void run() {
                FileDialog.this.createFile(name, val);
            }
        }).start();
    }

    void showCurrDir() {
        FileConnection currDir = null;
        System.out.println("showCurrDir!");
        try {
            List browser;
            Enumeration e;
            System.out.println("1");
            if ("/".equals(this.currDirName)) {
                e = FileSystemRegistry.listRoots();
                browser = new List(this.currDirName, 3);
            } else {
                currDir = (FileConnection)Connector.open((String)("file://localhost/" + this.currDirName));
                System.out.println("Dir: " + this.currDirName);
                e = currDir.list();
                browser = new List(this.currDirName, 3);
                browser.append(UP_DIRECTORY, this.dirIcon);
            }
            while (e.hasMoreElements()) {
                String fileName = (String)e.nextElement();
                System.out.println("File: " + fileName);
                if (fileName.charAt(fileName.length() - 1) == '/') {
                    browser.append(fileName, this.dirIcon);
                    continue;
                }
                browser.append(fileName, this.fileIcon);
            }
            browser.setSelectCommand(this.view);
            if (!"/".equals(this.currDirName) && this.mode == 1) {
                browser.addCommand(this.creat);
            }
            browser.addCommand(this.exit);
            browser.setCommandListener((CommandListener)this);
            if (currDir != null) {
                currDir.close();
            }
            this.midlet.getDisplay().setCurrent((Displayable)browser);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    void traverseDirectory(String fileName) {
        if (this.currDirName.equals("/")) {
            if (fileName.equals(UP_DIRECTORY)) {
                return;
            }
            this.currDirName = fileName;
        } else if (fileName.equals(UP_DIRECTORY)) {
            int i = this.currDirName.lastIndexOf(47, this.currDirName.length() - 2);
            if (i != -1) {
                this.currDirName = this.currDirName.substring(0, i + 1);
                System.out.println(this.currDirName);
            } else {
                this.currDirName = "/";
                System.out.println("MEGAROOT " + this.currDirName);
            }
        } else {
            this.currDirName = String.valueOf(this.currDirName) + fileName;
        }
        this.showCurrDir();
    }

    void showFile(String fileName) {
        try {
            FileConnection fc = (FileConnection)Connector.open((String)("file://localhost/" + this.currDirName + fileName));
            if (!fc.exists()) {
                throw new IOException("File does not exists");
            }
            InputStream fis = fc.openInputStream();
            byte[] b = new byte[1024];
            int length = fis.read(b, 0, 1024);
            fis.close();
            fc.close();
            TextBox viewer = new TextBox("View File: " + fileName, null, 1024, 131072);
            viewer.addCommand(this.exit);
            viewer.setCommandListener((CommandListener)this);
            if (length > 0) {
                viewer.setString(new String(b, 0, length));
            }
            this.midlet.getDisplay().setCurrent((Displayable)viewer);
        }
        catch (Exception e) {
            Alert alert = new Alert("Error!", "Can not access file " + fileName + " in directory " + this.currDirName + "\nException: " + e.getMessage(), null, AlertType.ERROR);
            alert.setTimeout(-2);
            this.midlet.getDisplay().setCurrent((Displayable)alert);
        }
    }

    public void commandAction(Command c, Displayable d) {
        if (c == this.view) {
            List curr = (List)d;
            final String currFile = curr.getString(curr.getSelectedIndex());
            new Thread(new Runnable(){

                public void run() {
                    if (currFile.endsWith("/") || currFile.equals(FileDialog.UP_DIRECTORY)) {
                        FileDialog.this.traverseDirectory(currFile);
                    } else if (FileDialog.this.mode == 0) {
                        ((FileDialog)FileDialog.this).settings.storyfile = "file://localhost/" + FileDialog.this.currDirName + currFile;
                        ((FileDialog)FileDialog.this).settings.storydir = "file://localhost/" + FileDialog.this.currDirName;
                        System.out.println(String.valueOf(FileDialog.this.currDirName) + currFile);
                        FileDialog.this.midlet.startStory(((FileDialog)FileDialog.this).settings.storyfile);
                        FileDialog.this.running = 0;
                    } else if (FileDialog.this.mode == 1) {
                        FileDialog.this.selected_file = "file://localhost/" + FileDialog.this.currDirName + currFile;
                        FileDialog.this.YesNoAlert();
                    } else if (FileDialog.this.mode == 2) {
                        FileDialog.this.selected_file = "file://localhost/" + FileDialog.this.currDirName + currFile;
                        FileDialog.this.midlet.getDisplay().setCurrent((Displayable)((FileDialog)FileDialog.this).midlet.terminal);
                        FileDialog.this.running = 0;
                    }
                }
            }).start();
        } else if (c == this.creat) {
            this.createFile();
        } else if (c == this.creatOK) {
            String newName;
            String tmp = newName = this.nameInput.getString();
            int i = 1;
            while (i < tmp.length()) {
                if (tmp.charAt(i) == '\r' || tmp.charAt(i) == '\n') {
                    newName = tmp.substring(0, i);
                    i = 1000;
                }
                ++i;
            }
            if (newName == null || newName.equals("")) {
                Alert alert = new Alert("Error!", "File Name is empty. Please provide file name", null, AlertType.ERROR);
                alert.setTimeout(-2);
                this.midlet.getDisplay().setCurrent((Displayable)alert);
            } else {
                this.executeCreateFile(newName, false);
                this.midlet.getDisplay().getCurrent().removeCommand(this.creatOK);
                this.midlet.getDisplay().getCurrent().removeCommand(this.back);
            }
        } else if (c == this.back) {
            this.showCurrDir();
        } else if (c == this.exit) {
            this.running = 0;
            if (this.mode == 0) {
                this.midlet.notifyDestroyed();
            } else {
                this.midlet.getDisplay().setCurrent((Displayable)this.midlet.terminal);
            }
        } else if (c == this.alert_no) {
            this.selected_file = null;
            if (this.mode == 0) {
                this.midlet.getDisplay().setCurrent((Displayable)this.midlet.settingsform);
            } else {
                this.midlet.getDisplay().setCurrent((Displayable)this.midlet.terminal);
            }
            this.running = 0;
        } else if (c == this.alert_yes) {
            if (this.mode == 0) {
                this.midlet.getDisplay().setCurrent((Displayable)this.midlet.settingsform);
            } else {
                this.midlet.getDisplay().setCurrent((Displayable)this.midlet.terminal);
            }
            this.running = 0;
        }
    }

    private void YesNoAlert() {
        Form alert = new Form("Overwrite File?");
        alert.append(new String("Overwrite File: " + this.selected_file + "?"));
        alert.append(new String("\n\nUse the menu key to select YES or NO."));
        this.alert_yes = new Command("Yes", 8, 1);
        this.alert_no = new Command("No", 8, 1);
        this.midlet.getDisplay().setCurrent((Displayable)alert);
        alert.addCommand(this.alert_yes);
        alert.addCommand(this.alert_no);
        alert.setCommandListener((CommandListener)this);
    }
}

