#include "giz.ipp"

Constant MEM_MAX_SIZE = 524288;
Constant STACK_SIZE = 1024;

Constant style_Normal = 0;
Constant style_Emphasized = 1;
Constant style_Preformatted = 2;
Constant style_Note = 6;

Constant stylehint_TextColor = 7;
Constant stylehint_BackColor = 8;

Constant winmethod_Left = 0;
Constant winmethod_Right = 1;
Constant winmethod_Above = 2;
Constant winmethod_Below = 3;
Constant winmethod_Fixed = $10;
Constant winmethod_Proportional = $20;

Constant wintype_TextBuffer = 3;
Constant wintype_TextGrid = 4;

Constant fileusage_BinaryMode = 0;
Constant fileusage_TextMode = $0100;

Constant filemode_WriteAppend = 5;
Constant filemode_ReadWrite = 3;
Constant filemode_Read = 2;
Constant filemode_Write = 1;

Constant gestalt_Timer = 5;
Constant gestalt_Sound = 8;

Array ref_args --> 8;
Array event_struct -->4;

Array StreamTables-->16;
Array StreamTablePositions-->16;

Array zmem -> MEM_MAX_SIZE;
Array zstack --> STACK_SIZE;

Global z_ver = 0;
Global numFrames = 0;
Global quit_flag = 0;
Global timer_val = 0;
Global timer_flag = 0;
Global stream_tbl_index = -1;
Global output_one = 1;

Global zglobals;

Global pc = 0;
Global sp = 0;
Global fp = 0;

Array zo_prop_size-->2;

Global zo_tree;
Global zo_len;
Global zo_zero;
Global zo_parent;
Global zo_sibling;
Global zo_child;
Global zo_prop_tbl;
Global zo_prop_num_mask;

Global zio_root;
Global zio_lower;
Global zio_upper;
Global zio_status;
Global zio_width;
Global zio_height;
Global zio_current;
Global zio_x;
Global zio_y;
Global zio_pending_height;
Global zio_changed_height;
Global zio_reset_height;
Global zio_current_style;
Global zio_force_fixed_pitch = false;
Global zio_mouse_x;
Global zio_mouse_y;
Global zio_font = 1;
Global zio_pending_input = false;

Global zio_input = 0;
/* !! "script" file is for input, "transcript" is for output... */
/* !! yeah, whatever. */
Global zio_script_file;
Global zio_script_stream;
Global zio_transcript_file;
Global zio_transcript_stream;
Global zio_command_file;
Global zio_command_stream;


Include "quetzal.inf";
Include "zio.inf";
Include "zop.inf";
Include "zdict.inf";
Include "zstyle.inf";
Include "zscii.inf";
Include "zobject.inf";

[Main win ref;

/* !    types-->0 = times0; */
/* !    types-->1 = times1; */
/* !    types-->2 = times2; */
/* !    types-->3 = times3; */
/* !    types-->4 = times4; */
    
    init_quetzal();
    
    @setiosys 2 0;
    init_styles();
    win = glk($0023, 0, 0, 0, 3, 0);
    glk($002f, win);


    ref = glk($0062, fileusage_BinaryMode, filemode_Read, 0);
    if (~~ ref)
    {
        print "No file selected. Exiting...^";
        @quit;
    }
    
    ZMachine.init(win, ref);
    ZMachine.start();
];

/* ![get_story_file f; */
/* !    print "Please select a story file.^"; */
/* !    f =  */
/* !    if (f == 0) */
/* !    { */
/* !        print "No file selected - exiting.^"; */
/* !        @quit; */
/* !    } */
/* !    return f; */
/* !]; */


[fatalError str;
    @streamstr str;
    @quit;];


Object  ZMachine
 with   ref,
        mainwin,
        init [win fileref;
            
            if (fileref)
                self.ref = fileref;
            if (win)
                self.mainwin = win;

            zmem_init(self.ref);

/* !            if (~~ do_verify()) */
/* !            { */
/* !                print "Not a valid z-code file (checksum */
/* !                    failed). Exiting...^"; */
/* !                @quit; */
/* !            } */
            
            readb(z_ver, 0);
            zmem_init_header(self.mainwin);
            zscii_init();
            zo_init();
            zio_init(self.mainwin);
            zstack_init();
            zdict_init($08);
            
            /* !! Handle PC: different in V6 */
            readw(pc, 6);
        ],

        start [;
           /*  !! begin execution */
            while (timer_flag == 0 && quit_flag == 0)
                execute();
        ];




[zstack_init;
    sp = 0;
    fp = 0;
];

[zstack_push w;
    if (sp < STACK_SIZE) 
        zstack-->sp++ = w;
    else
        fatalError("Stack overflow.");
];

[zstack_pop;
    if (sp == fp)
    {
        zstack_dump();
        fatalError("Stack underflow error.");
    }
    else
    {
        return ($0000ffff & (zstack-->--sp));
    }
];

[zstack_push_frame routine num_args store_var i num_vars tmp;
    readb(num_vars, routine);
    routine++;
    
    if (num_args > num_vars)
        num_args = num_vars;
            
    if (sp + num_vars + 5 < STACK_SIZE)
    {
        zstack-->sp++ = fp;
        zstack-->sp++ = pc;
        zstack-->sp++ = store_var;
        zstack-->sp++ = num_args;
        zstack-->sp++ = num_vars;

        fp = sp;

        if (z_ver < 5)
        {
            for (i = 0 : i < num_vars : i++)
            {
                readw(tmp, routine);
                zstack-->sp++ = tmp;
                routine = routine + 2;
            }
        }
        else
        {
            for (i = 0: i < num_vars: i++)
                zstack-->sp++ = 0;
        }
        
        numFrames++;
        pc = routine;

        return num_vars;
    } 
    else
    {
        fatalError("Stack overflow.");
    }
];

[zstack_pop_frame store_val throw tmp;
    if (fp == 0)
    {
        fatalError("Attempt to return from top level routine.");
    }
    else
    {
        tmp = zstack-->(fp - 3); 
        pc = zstack-->(fp - 4); 
        if (fp >= 5)
            sp = fp - 5;
        fp = zstack-->sp;
        
        numFrames--;
        
        if (tmp == -2)
        {
            timer_val = store_val;
            timer_flag = 1;
        }
        else if (throw == 0 && tmp >= 0)
        {
            store_var(tmp, store_val);
        }
        
    }
];


[zstack_dump i lsp lfp pitch;
    pitch = zio_force_fixed_pitch;
    zio_force_fixed_pitch = true;
    
    i = sp - 1;
    lfp = fp;
    lsp = sp;
    
    print "sp: ", sp,"^";
    print "fp: ", fp,"^";
    print "^";
    print "^";
    
    print "sp -> +-----------+ ", lsp, "^";
    
    while (i >= 0)
    {
        for (i = lsp - 1 : i > lfp : i--)
            print "      |   ", (pad5) zstack-->i, "   |", i, "^";
        
        print "fp -> |   ", (pad5) zstack-->lfp, "   |", lfp, "^";
        print "      |-----------|^";
        
        if (lfp ~= 0)
        {
            print "#vars |   ", (pad5) zstack-->(lfp-1),"   |", lfp - 1, "^";
            print "#args |   ", (pad5) zstack-->(lfp-2),"   |", lfp - 2, "^";
            print "store |   ", (pad5) zstack-->(lfp-3),"   |", lfp - 3, "^";
            print "opc   |   ", (pad5) zstack-->(lfp-4),"   |", lfp - 4, "^";
            print "ofp   |   ", (pad5) zstack-->(lfp-5),"   |", lfp - 5, "^";
        }
        print "      |===========|^";
        
        lsp = lfp - 5;
        if (lsp >= 0)
        {
           lfp = zstack-->(lfp - 5);
           i = i - 5;
        }
        else
        {
           i = -1;
        }
    }
    zio_force_fixed_pitch = false;
];

                

[zmem_init fileref in b;
    /* !! open the file for reading */
    in = glk($0042, fileref, $02, 0); 

    b = glk($0092, in, zmem, MEM_MAX_SIZE);
            
    /* !! close the stream */
    glk($0044, in, 0);
    
    /* !! set up zglobals -- this is an offset from *glulx* memory */
    readw(zglobals, $0c);
    zglobals = zglobals + zmem;
];

        
/* !! Pre: init() has been called */
[zmem_init_header win win2 test flags1 flags2 t1 t2;
    readb(flags1, 1);
    
    if (z_ver > 3) {
       /*  !! no colors */
        flags1 = flags1 & $$11111110;
                
        /* !! assume fixed-pitch font available */
        flags1 = flags1 | 16;  
                
        /* !! kind-of test for italics */
        test = glk($00b2, win, style_Normal, 
                   style_Emphasized);
        if (test == 1)
            flags1 = flags1 | 8;
                
        /* !! Kind-of test for boldface */
        if (test == 1 && glk($00b2, win, style_Emphasized, 
                             style_Note) == 1)
            flags1 = flags1 | 4;
                
        /* !! test for timer */
        if (glk($0004, gestalt_Timer, 0) == 1)
            flags1 = flags1 | 128;
                
        /* !! handle flags2 */
        flags2 = zmem->17;
        if (glk($0004, gestalt_Sound, 0) == 1)
            flags2 = flags2 & $$11110111;
        else
            flags2 = flags2 & $$01110111;
        zmem->17 = flags2;
                
        /* !! no menus */
        zmem->16 = zmem->16 & $$11111110;
    }
    else {
        flags1 = flags1 & $$11110111; /* !! status avail. */
        flags1 = flags1 | 16; /* !! screen splitting assumed */
                
        if (glk($00b2, win, style_Normal, 
                style_Preformatted) == 1)
            flags1 = flags1 | 32;
    }

    zmem->1 = flags1;
    zmem->$1e = 15;
    zmem->$1f = 1;
            
    /* !! open a window for measuring */
    win2 = glk($0023, win, 
               winmethod_Above | winmethod_Proportional, 100,
               wintype_TextGrid, 0);
    glk($0025, win2, ref_args, ref_args + 4); 

    t1 = ref_args-->1;
    t2 = ref_args-->0;
    zmem->$20 = t1;
    zmem->$21 = t2;
    writew($22, t2);
    writew($24, t1);
    
    /* !! close win2 */
    glk($0024, win2, ref_args);
    
    zmem->$27 = 1;
    zmem->$26 = 1;
            
    zmem->$2c = 9;
    zmem->$2d = 2;
    
    zmem->$32 = 1;
    zmem->$33 = 0;

    /* !! find the mouse point locations, if they exist */
    readw(t1, $36);
    if (t1 > 0)
    {
        readw(t2, t1);
        if (t2 > 1)
        {
            zio_mouse_x = t1 + 2;
            zio_mouse_y = t1 + 4;
        }
    }
];



/* !! utility */
[hex x y;
    @ushiftr x 28 y;
    hexdigit(y);
    @ushiftr x 24 y;
    hexdigit(y);
    @ushiftr x 20 y;
    hexdigit(y);
    @ushiftr x 16 y;
    hexdigit(y);
    @ushiftr x 12 y;
    hexdigit(y);
    @ushiftr x 8 y;
    hexdigit(y);
    @ushiftr x 4 y;
    hexdigit(y);
    hexdigit(x);
    

/*     !    y = (x & $7f00) / $100; */
/* !    if (x < 0) y = y + $80; */
/* !    x = x & $ff; */
/* !    print (hexdigit) y/$10, (hexdigit) y, */
/* !        (hexdigit) x/$10, (hexdigit) x; */
];

[hexdigit x;
    x = x % $10;
    switch (x)
    {
     0 to 9: print x;
     10: print "a";
     11: print "b";
     12: print "c";
     13: print "d";
     14: print "e";
     15: print "f";
    }
];


[num_digits n i;
    for (i = 0 : (n = n / 10) ~= 0 : i++)
    {
    }
    return i + 1;
];

[pad5 num d;
    d = num_digits(num);
    while (d++ < 5)
        print "0";
    print num;
];



[do_verify sum word i in len;
    in = glk($0042, ZMachine.ref, $02, 0);
    glk($0045, in, 0, 2);
    len = glk($0046, in);

    glk($0045, in, $1c, 0);
    word = glk($0090, in);
    @shiftl word 8 word;
    word = word | glk($0090, in);

    sum = 0;
    i = $40;
    glk($0045, in, i, 0);

    while (i < len)
    {
        sum = sum + glk($0090, in);
        i++;
    }

    sum = sum % $10000;
    glk($0044, in, 0);

    return (sum == word);
];
