/*
 * Decompiled with CFR 0.152.
 */
package org.zmpp.swingui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.zmpp.io.IOSystem;
import org.zmpp.io.InputStream;
import org.zmpp.media.Resources;
import org.zmpp.media.StoryMetadata;
import org.zmpp.swingui.DisplaySettings;
import org.zmpp.swingui.GameInfoDialog;
import org.zmpp.swingui.GameThread;
import org.zmpp.swingui.LineEditorImpl;
import org.zmpp.swingui.PreferencesDialog;
import org.zmpp.swingui.TextViewport;
import org.zmpp.swingui.Viewport6;
import org.zmpp.vm.Machine;
import org.zmpp.vm.ScreenModel;
import org.zmpp.vm.StatusLine;

public class ZmppFrame
extends JFrame
implements InputStream,
StatusLine,
IOSystem {
    private static final long serialVersionUID = 1L;
    private JLabel global1ObjectLabel;
    private JLabel statusLabel;
    private ScreenModel screen;
    private Machine machine;
    private LineEditorImpl lineEditor;
    private GameThread currentGame;
    private boolean isMacOs;
    private DisplaySettings settings;
    private Preferences preferences;

    public ZmppFrame(Machine machine) {
        super("Z-Machine Preservation Project Version 0.92_02");
        JComponent jComponent;
        JComponent jComponent2;
        JComponent jComponent3;
        this.machine = machine;
        this.lineEditor = new LineEditorImpl(machine.getGameData().getStoryFileHeader(), machine.getGameData().getZsciiEncoding());
        this.isMacOs = System.getProperty("mrj.version") != null;
        this.setDefaultCloseOperation(3);
        this.setResizable(false);
        JComponent jComponent4 = null;
        this.preferences = Preferences.userNodeForPackage(ZmppFrame.class);
        this.settings = this.createDisplaySettings(this.preferences);
        if (machine.getGameData().getStoryFileHeader().getVersion() == 6) {
            jComponent4 = new Viewport6(machine, this.lineEditor, this.settings);
            this.screen = (ScreenModel)((Object)jComponent4);
        } else {
            jComponent4 = new TextViewport(machine, this.lineEditor, this.settings);
            this.screen = (ScreenModel)((Object)jComponent4);
        }
        jComponent4.setPreferredSize(new Dimension(640, 476));
        jComponent4.setMinimumSize(new Dimension(400, 300));
        if (machine.getGameData().getStoryFileHeader().getVersion() <= 3) {
            jComponent3 = new JPanel(new GridLayout(1, 2));
            jComponent2 = new JPanel(new FlowLayout(0));
            jComponent = new JPanel(new FlowLayout(2));
            jComponent3.add(jComponent2);
            jComponent3.add(jComponent);
            this.global1ObjectLabel = new JLabel(" ");
            this.statusLabel = new JLabel(" ");
            jComponent2.add(this.global1ObjectLabel);
            jComponent.add(this.statusLabel);
            this.getContentPane().add((Component)jComponent3, "North");
            this.getContentPane().add((Component)jComponent4, "Center");
        } else {
            this.setContentPane(jComponent4);
        }
        jComponent3 = new JMenuBar();
        this.setJMenuBar((JMenuBar)jComponent3);
        if (!this.isMacOs) {
            jComponent2 = new JMenu("File");
            ((AbstractButton)jComponent2).setMnemonic('F');
            ((JMenuBar)jComponent3).add((JMenu)jComponent2);
            jComponent = new JMenuItem("Exit");
            ((AbstractButton)jComponent).setMnemonic('x');
            ((JMenu)jComponent2).add((JMenuItem)jComponent);
            ((AbstractButton)jComponent).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    System.exit(0);
                }
            });
        }
        jComponent2 = new JMenu("Edit");
        ((JMenuBar)jComponent3).add((JMenu)jComponent2);
        ((AbstractButton)jComponent2).setMnemonic('E');
        jComponent = new JMenuItem("Preferences...");
        ((AbstractButton)jComponent).setMnemonic('P');
        ((JMenu)jComponent2).add((JMenuItem)jComponent);
        ((AbstractButton)jComponent).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ZmppFrame.this.editPreferences();
            }
        });
        JMenu jMenu = new JMenu("Help");
        ((JMenuBar)jComponent3).add(jMenu);
        jMenu.setMnemonic('H');
        JMenuItem jMenuItem = new JMenuItem("About ZMPP...");
        jMenuItem.setMnemonic('A');
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ZmppFrame.this.about();
            }
        });
        jComponent4.addKeyListener(this.lineEditor);
        jComponent4.addMouseListener(this.lineEditor);
        jComponent4.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mouseEvent) {
            }
        });
        Resources resources = machine.getGameData().getResources();
        if (resources != null && resources.getMetadata() != null) {
            StoryMetadata storyMetadata = resources.getMetadata().getStoryInfo();
            this.setTitle("Z-Machine Preservation Project Version 0.92_02 - " + storyMetadata.getTitle() + " (" + storyMetadata.getAuthor() + ")");
            JMenuItem jMenuItem2 = new JMenuItem("About this Game ...");
            jMenu.add(jMenuItem2);
            jMenuItem2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ZmppFrame.this.aboutGame();
                }
            });
        }
    }

    public ScreenModel getScreenModel() {
        return this.screen;
    }

    public void startMachine() {
        this.currentGame = new GameThread(this.machine, this.screen);
        this.currentGame.start();
    }

    public void updateStatusScore(final String string, final int n, final int n2) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ZmppFrame.this.global1ObjectLabel.setText(string);
                ZmppFrame.this.statusLabel.setText(n + "/" + n2);
            }
        });
    }

    public void updateStatusTime(final String string, final int n, final int n2) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ZmppFrame.this.global1ObjectLabel.setText(string);
                ZmppFrame.this.statusLabel.setText(String.format("%02d:%02d", n, n2));
            }
        });
    }

    public Writer getTranscriptWriter() {
        File file = new File(System.getProperty("user.dir"));
        JFileChooser jFileChooser = new JFileChooser(file);
        jFileChooser.setDialogTitle("Set transcript file ...");
        if (jFileChooser.showSaveDialog(this) == 0) {
            try {
                return new FileWriter(jFileChooser.getSelectedFile());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return null;
    }

    public Reader getInputStreamReader() {
        File file = new File(System.getProperty("user.dir"));
        JFileChooser jFileChooser = new JFileChooser(file);
        jFileChooser.setDialogTitle("Set input stream file ...");
        if (jFileChooser.showOpenDialog(this) == 0) {
            try {
                return new FileReader(jFileChooser.getSelectedFile());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return null;
    }

    public void close() {
    }

    public void cancelInput() {
        this.lineEditor.cancelInput();
    }

    public short getZsciiChar(boolean bl) {
        this.enterEditMode(bl);
        short s = this.lineEditor.nextZsciiChar();
        this.leaveEditMode(bl);
        return s;
    }

    private void enterEditMode(boolean bl) {
        if (!this.lineEditor.isInputMode()) {
            this.screen.resetPagers();
            this.lineEditor.setInputMode(true, bl);
        }
    }

    private void leaveEditMode(boolean bl) {
        this.lineEditor.setInputMode(false, bl);
    }

    private void about() {
        JOptionPane.showMessageDialog(this, "Z-Machine Preservation Project Version 0.92_02\n\u00a9 2005-2006 by Wei-ju Wu\nThis software is released under the GNU public license.", "About...", 1);
    }

    private void aboutGame() {
        GameInfoDialog gameInfoDialog = new GameInfoDialog(this, this.machine.getGameData().getResources());
        gameInfoDialog.setVisible(true);
    }

    private void editPreferences() {
        PreferencesDialog preferencesDialog = new PreferencesDialog(this, this.preferences, this.settings);
        preferencesDialog.setLocationRelativeTo(this);
        preferencesDialog.setVisible(true);
    }

    private DisplaySettings createDisplaySettings(Preferences preferences) {
        int n = preferences.getInt("stdfontsize", 12);
        int n2 = preferences.getInt("fixedfontsize", 12);
        int n3 = preferences.getInt("defaultforeground", -1000);
        int n4 = preferences.getInt("defaultbackground", -1000);
        boolean bl = preferences.getBoolean("antialias", true);
        return new DisplaySettings(n, n2, n4, n3, bl);
    }
}

