/*
 * Decompiled with CFR 0.152.
 */
package org.zmpp.blorb;

import java.awt.Dimension;
import java.awt.image.BufferedImage;

public class BlorbImage {
    private BufferedImage image;
    private Resolution resolution;
    private ScaleInfo scaleinfo;

    public BlorbImage(BufferedImage bufferedImage) {
        this.image = bufferedImage;
    }

    public BlorbImage(int n, int n2) {
        this.resolution = new Resolution(n, n2);
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public ScaleInfo getScaleInfo() {
        return this.scaleinfo;
    }

    public Dimension getSize(int n, int n2) {
        if (this.scaleinfo != null) {
            float f = this.scaleinfo.computeScaleRatio(n, n2);
            if (this.image != null) {
                return new Dimension((int)((float)this.image.getWidth() * f), (int)((float)this.image.getHeight() * f));
            }
            return new Dimension((int)((float)this.resolution.getWidth() * f), (int)((float)this.resolution.getHeight() * f));
        }
        if (this.image != null) {
            return new Dimension(this.image.getWidth(), this.image.getHeight());
        }
        return new Dimension(this.resolution.getWidth(), this.resolution.getHeight());
    }

    protected void setScaleInfo(ScaleInfo scaleInfo) {
        this.scaleinfo = scaleInfo;
    }

    protected static class ScaleInfo {
        private ResolutionInfo resolutionInfo;
        private Ratio standard;
        private Ratio minimum;
        private Ratio maximum;

        public ScaleInfo(ResolutionInfo resolutionInfo, Ratio ratio, Ratio ratio2, Ratio ratio3) {
            this.resolutionInfo = resolutionInfo;
            this.standard = ratio;
            this.minimum = ratio2;
            this.maximum = ratio3;
        }

        public ResolutionInfo getResolutionInfo() {
            return this.resolutionInfo;
        }

        public Ratio getStdRatio() {
            return this.standard;
        }

        public Ratio getMinRatio() {
            return this.minimum;
        }

        public Ratio getMaxRatio() {
            return this.maximum;
        }

        public float computeScaleRatio(int n, int n2) {
            float f = this.resolutionInfo.computeERF(n, n2) * this.standard.getValue();
            if (this.minimum.isDefined() && f < this.minimum.getValue()) {
                f = this.minimum.getValue();
            }
            if (this.maximum.isDefined() && f > this.maximum.getValue()) {
                f = this.maximum.getValue();
            }
            return f;
        }

        public String toString() {
            return String.format("std: %s, min: %s, max: %s\n", this.standard.toString(), this.minimum.toString(), this.maximum.toString());
        }
    }

    protected static class ResolutionInfo {
        private Resolution standard;
        private Resolution minimum;
        private Resolution maximum;

        public ResolutionInfo(Resolution resolution, Resolution resolution2, Resolution resolution3) {
            this.standard = resolution;
            this.minimum = resolution2;
            this.maximum = resolution3;
        }

        public Resolution getStandard() {
            return this.standard;
        }

        public Resolution getMinimum() {
            return this.minimum;
        }

        public Resolution getMaximum() {
            return this.maximum;
        }

        public float computeERF(int n, int n2) {
            return Math.min(n / this.standard.getWidth(), n2 / this.standard.getHeight());
        }

        public String toString() {
            return "Std: " + this.standard.toString() + " Min: " + this.minimum.toString() + " Max: " + this.maximum.toString();
        }
    }

    protected static class Resolution {
        private int width;
        private int height;

        public Resolution(int n, int n2) {
            this.width = n;
            this.height = n2;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public String toString() {
            return this.width + "x" + this.height;
        }
    }

    protected static class Ratio {
        private int numerator;
        private int denominator;

        public Ratio(int n, int n2) {
            this.numerator = n;
            this.denominator = n2;
        }

        public int getNumerator() {
            return this.numerator;
        }

        public int getDenominator() {
            return this.denominator;
        }

        public float getValue() {
            return (float)this.numerator / (float)this.denominator;
        }

        public boolean isDefined() {
            return this.numerator != 0 || this.denominator != 0;
        }

        public String toString() {
            return this.numerator + "/" + this.denominator;
        }
    }
}

