/*
 * Decompiled with CFR 0.152.
 */
package org.zmpp.swingui;

import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.StringTokenizer;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import org.zmpp.swingui.ApplicationMachineFactory;
import org.zmpp.swingui.ZmppFrame;

public class Main {
    public static final String APPNAME = "Z-Machine Preservation Project Version 0.92_02";

    public static void main(String[] stringArray) {
        System.setProperty("swing.aatext", "true");
        File file = null;
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (stringArray.length >= 1) {
            file = new File(stringArray[0]);
        } else {
            JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
            jFileChooser.setDialogTitle("Open story file...");
            if (jFileChooser.showOpenDialog(null) == 0) {
                file = jFileChooser.getSelectedFile();
            }
        }
        Main.runStoryFile(file);
    }

    public static void runStoryFile(File file) {
        if (System.getProperty("mrj.version") != null) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.eawt.CocoaComponent.CompatibilityMode", "false");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "ZMPP");
        }
        if (file != null && file.exists() && file.isFile()) {
            Serializable serializable;
            ApplicationMachineFactory applicationMachineFactory;
            if (Main.isZblorbSuffix(file.getName())) {
                applicationMachineFactory = new ApplicationMachineFactory(file);
            } else {
                serializable = Main.searchForResources(file);
                applicationMachineFactory = new ApplicationMachineFactory(file, (File)serializable);
            }
            try {
                applicationMachineFactory.buildMachine();
                serializable = applicationMachineFactory.getUI();
                ((ZmppFrame)serializable).startMachine();
                ((Window)serializable).pack();
                ((Window)serializable).setVisible(true);
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(null, String.format("Could not read game.\nReason: '%s'", iOException.getMessage()), "Story file error", 0);
            }
        } else {
            JOptionPane.showMessageDialog(null, String.format("The selected story file '%s' was not found", file != null ? file.getPath() : ""), "Story file not found", 0);
        }
    }

    private static boolean isZblorbSuffix(String string) {
        return string.endsWith("zblorb") || string.endsWith("zlb");
    }

    private static File searchForResources(File file) {
        StringTokenizer stringTokenizer = new StringTokenizer(file.getName(), ".");
        String string = stringTokenizer.nextToken();
        String string2 = file.getParent();
        String string3 = (string2 != null ? string2 + System.getProperty("file.separator") : "") + string + ".blb";
        String string4 = (string2 != null ? string2 + System.getProperty("file.separator") : "") + string + ".blorb";
        File file2 = new File(string3);
        System.out.printf("does '%s' exist ? -> %b\n", file2.getPath(), file2.exists());
        if (file2.exists()) {
            return file2;
        }
        File file3 = new File(string4);
        System.out.printf("does '%s' exist ? -> %b\n", file3.getPath(), file3.exists());
        if (file3.exists()) {
            return file3;
        }
        return null;
    }
}

