/*
 * Decompiled with CFR 0.152.
 */
package org.zmpp.vm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.zmpp.base.MemoryAccess;
import org.zmpp.encoding.ZCharDecoder;
import org.zmpp.encoding.ZsciiEncoding;
import org.zmpp.encoding.ZsciiString;
import org.zmpp.encoding.ZsciiStringBuilder;
import org.zmpp.encoding.ZsciiStringTokenizer;
import org.zmpp.vm.CommandHistory;
import org.zmpp.vm.Dictionary;
import org.zmpp.vm.InputLine;
import org.zmpp.vm.Machine;
import org.zmpp.vm.Output;
import org.zmpp.vm.StoryFileHeader;
import org.zmpp.vm.UserDictionary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputFunctions
implements InputLine {
    private CommandHistory history;
    private Machine machine;
    private static final ZsciiString WHITESPACE = new ZsciiString(new short[]{32, 10, 9, 13});

    public InputFunctions(Machine machine) {
        this.machine = machine;
        this.history = new CommandHistory(this);
    }

    public short readLine(int n, int n2, int n3) {
        this.machine.getOutput().flushOutput();
        this.displayCursor(true);
        List<Short> list = Collections.synchronizedList(new ArrayList());
        this.history.reset();
        int n4 = this.checkForPreviousInput(n, list);
        InterruptThread interruptThread = this.startInterruptThread(n3, n2, list);
        short s = this.doInputLoop(n, n4, list);
        this.storeInput(list, s);
        this.terminateInterruptThread(interruptThread);
        this.displayCursor(false);
        return this.handleTerminateChar(s);
    }

    @Override
    public int deletePreviousChar(List<Short> list, int n) {
        int n2 = n;
        if (list.size() > 0) {
            short s = list.remove(list.size() - 1);
            --n2;
            this.machine.getOutput().deletePreviousZsciiChar(s);
        }
        return n2;
    }

    @Override
    public int addChar(List<Short> list, int n, int n2, short s) {
        int n3 = n2;
        MemoryAccess memoryAccess = this.machine.getGameData().getMemoryAccess();
        ZsciiEncoding zsciiEncoding = this.machine.getGameData().getZsciiEncoding();
        memoryAccess.writeUnsignedByte(n + n3, zsciiEncoding.toLower(s));
        list.add(s);
        this.machine.getOutput().printZsciiChar(s, true);
        return ++n3;
    }

    public int checkForPreviousInput(int n, List<Short> list) {
        int n2;
        int n3 = this.machine.getGameData().getStoryFileHeader().getVersion();
        int n4 = n2 = this.determineTextBufferStart(n3);
        if (n3 >= 5) {
            MemoryAccess memoryAccess = this.machine.getGameData().getMemoryAccess();
            int n5 = memoryAccess.readByte(n + 1);
            if (n5 < 0) {
                n5 = 0;
            }
            if (n5 > 0) {
                for (int i = 0; i < n5; ++i) {
                    short s = memoryAccess.readUnsignedByte(n + n2 + i);
                    list.add(s);
                }
            }
            n4 += n5;
        }
        return n4;
    }

    public void checkTermination(short s, int n, int n2) {
        int n3 = this.machine.getGameData().getStoryFileHeader().getVersion();
        MemoryAccess memoryAccess = this.machine.getGameData().getMemoryAccess();
        if (n3 >= 5) {
            byte by = s == 0 ? (byte)0 : (byte)(n2 - 2);
            memoryAccess.writeUnsignedByte(n + 1, by);
        } else {
            int n4 = n2;
            if (s == 0) {
                n4 = 0;
            }
            memoryAccess.writeByte(n + n4, (byte)0);
        }
    }

    public InterruptThread startInterruptThread(int n, int n2, List<Short> list) {
        InterruptThread interruptThread = null;
        int n3 = this.machine.getGameData().getStoryFileHeader().getVersion();
        if (n3 >= 4 && n2 > 0 && n != 0) {
            double d = (double)n2 / 10.0 * 1000.0;
            interruptThread = new InterruptThread((int)d, n, list);
            interruptThread.start();
        }
        return interruptThread;
    }

    public void terminateInterruptThread(InterruptThread interruptThread) {
        if (interruptThread != null) {
            interruptThread.terminate();
        }
    }

    public short doInputLoop(int n, int n2, List<Short> list) {
        short s;
        MemoryAccess memoryAccess = this.machine.getGameData().getMemoryAccess();
        short s2 = memoryAccess.readUnsignedByte(n);
        int n3 = n2;
        boolean bl = true;
        do {
            s = this.machine.getInput().getSelectedInputStream().getZsciiChar(bl);
            bl = false;
            this.displayCursor(false);
            if (s == 8) {
                n3 = this.deletePreviousChar(list, n3);
            } else if (!this.isTerminatingCharacter(s)) {
                n3 = this.history.isHistoryChar(s) ? this.history.switchHistoryEntry(list, n, n3, s) : this.addChar(list, n, n3, s);
            }
            this.displayCursor(true);
        } while (!this.isTerminatingCharacter(s) && n3 < s2 - 1);
        this.checkTermination(s, n, n3);
        return s;
    }

    private boolean isTerminatingCharacter(short s) {
        return this.isFileHeaderTerminator(s) || s == 13 || s == 0;
    }

    private boolean isFileHeaderTerminator(short s) {
        StoryFileHeader storyFileHeader = this.machine.getGameData().getStoryFileHeader();
        if (storyFileHeader.getVersion() >= 5) {
            short s2;
            int n = storyFileHeader.getTerminatorsAddress();
            if (n == 0) {
                return false;
            }
            MemoryAccess memoryAccess = this.machine.getGameData().getMemoryAccess();
            int n2 = 0;
            while ((s2 = memoryAccess.readUnsignedByte(n + n2)) != 0) {
                if (s2 == 255) {
                    return ZsciiEncoding.isFunctionKey(s);
                }
                if (s2 == s) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public short handleTerminateChar(short s) {
        if (s == 13) {
            this.machine.getOutput().printZsciiChar((short)13, false);
        }
        return s;
    }

    public short readChar(int n, int n2) {
        this.machine.getOutput().flushOutput();
        this.displayCursor(true);
        InterruptThread interruptThread = this.startInterruptThread(n2, n, null);
        short s = this.machine.getInput().getSelectedInputStream().getZsciiChar(true);
        this.terminateInterruptThread(interruptThread);
        this.displayCursor(false);
        return s;
    }

    public void tokenize(int n, int n2, int n3, boolean bl) {
        MemoryAccess memoryAccess = this.machine.getGameData().getMemoryAccess();
        Dictionary dictionary = this.machine.getGameData().getDictionary();
        if (n3 > 0) {
            dictionary = new UserDictionary(memoryAccess, n3, this.machine.getGameData().getZCharDecoder());
        }
        int n4 = this.machine.getGameData().getStoryFileHeader().getVersion();
        short s = memoryAccess.readUnsignedByte(n);
        int n5 = this.determineTextBufferStart(n4);
        short s2 = n4 >= 5 ? memoryAccess.readUnsignedByte(n + 1) : (short)0;
        ZsciiString zsciiString = this.bufferToZscii(n + n5, s, s2);
        List<ZsciiString> list = this.tokenize(zsciiString);
        HashMap<ZsciiString, Integer> hashMap = new HashMap<ZsciiString, Integer>();
        short s3 = memoryAccess.readUnsignedByte(n2);
        int n6 = Math.min(s3, list.size());
        memoryAccess.writeUnsignedByte(n2 + 1, (short)n6);
        int n7 = n2 + 2;
        for (int i = 0; i < n6; ++i) {
            int n8;
            ZsciiString zsciiString2 = list.get(i);
            int n9 = dictionary.lookup(zsciiString2);
            int n10 = 0;
            if (hashMap.containsKey(zsciiString2)) {
                n8 = (Integer)hashMap.get(zsciiString2);
                hashMap.put(zsciiString2, n8 + 1);
                for (int j = 0; j < n8; ++j) {
                    int n11 = zsciiString.indexOf(zsciiString2, n10);
                    n10 = n11 + zsciiString2.length();
                }
            } else {
                hashMap.put(zsciiString2, 1);
            }
            n8 = zsciiString.indexOf(zsciiString2, n10);
            ++n8;
            if (n4 >= 5) {
                ++n8;
            }
            if (!bl || bl && n9 > 0) {
                memoryAccess.writeUnsignedShort(n7, n9);
                memoryAccess.writeUnsignedByte(n7 + 2, (short)zsciiString2.length());
                memoryAccess.writeUnsignedByte(n7 + 3, (short)n8);
            }
            n7 += 4;
        }
    }

    private ZsciiString bufferToZscii(int n, int n2, int n3) {
        short s;
        MemoryAccess memoryAccess = this.machine.getGameData().getMemoryAccess();
        int n4 = n3 > 0 ? n3 : n2;
        ZsciiStringBuilder zsciiStringBuilder = new ZsciiStringBuilder();
        for (int i = 0; i < n4 && (s = memoryAccess.readUnsignedByte(n + i)) != 0; ++i) {
            zsciiStringBuilder.append(s);
        }
        return zsciiStringBuilder.toZsciiString();
    }

    private List<ZsciiString> tokenize(ZsciiString zsciiString) {
        ArrayList<ZsciiString> arrayList = new ArrayList<ZsciiString>();
        ZsciiStringBuilder zsciiStringBuilder = new ZsciiStringBuilder();
        zsciiStringBuilder.append(WHITESPACE);
        Dictionary dictionary = this.machine.getGameData().getDictionary();
        ZCharDecoder zCharDecoder = this.machine.getGameData().getZCharDecoder();
        int n = dictionary.getNumberOfSeparators();
        for (int i = 0; i < n; ++i) {
            byte by = dictionary.getSeparator(i);
            zsciiStringBuilder.append(zCharDecoder.decodeZChar(by));
        }
        ZsciiString zsciiString2 = zsciiStringBuilder.toZsciiString();
        ZsciiStringTokenizer zsciiStringTokenizer = new ZsciiStringTokenizer(zsciiString, zsciiString2);
        while (zsciiStringTokenizer.hasMoreTokens()) {
            ZsciiString zsciiString3 = zsciiStringTokenizer.nextToken();
            if (Character.isWhitespace(zsciiString3.charAt(0))) continue;
            arrayList.add(zsciiString3);
        }
        return arrayList;
    }

    private int determineTextBufferStart(int n) {
        return n < 5 ? 1 : 2;
    }

    private synchronized void displayCursor(boolean bl) {
        this.machine.getScreen().displayCursor(bl);
        this.machine.getScreen().redraw();
    }

    private void storeInput(List<Short> list, short s) {
        if (s != 0) {
            this.history.addInputLine(list);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class InterruptThread
    extends Thread {
        private int time;
        private int routineAddress;
        private List<Short> inputbuffer;
        public boolean running;

        public InterruptThread(int n, int n2, List<Short> list) {
            this.time = n;
            this.routineAddress = n2;
            this.inputbuffer = list;
            this.running = true;
        }

        public synchronized boolean isRunning() {
            return this.running;
        }

        public synchronized void terminate() {
            this.running = false;
            this.interrupt();
            try {
                this.join();
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }

        @Override
        public void run() {
            Output output = InputFunctions.this.machine.getOutput();
            while (this.isRunning()) {
                try {
                    Thread.sleep(this.time);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.isRunning()) continue;
                InputFunctions.this.displayCursor(false);
                short s = InputFunctions.this.machine.getCpu().callInterrupt(this.routineAddress);
                if (s == 1) {
                    InputFunctions.this.machine.getInput().getSelectedInputStream().cancelInput();
                    break;
                }
                if (this.inputbuffer != null && InputFunctions.this.machine.getCpu().interruptDidOutput()) {
                    for (short s2 : this.inputbuffer) {
                        output.printZsciiChar(s2, false);
                    }
                }
                output.flushOutput();
                InputFunctions.this.displayCursor(true);
            }
        }
    }
}

