/*
 * Decompiled with CFR 0.152.
 */
package org.zmpp.vm;

import java.util.ArrayList;
import java.util.List;
import org.zmpp.base.MemoryAccess;
import org.zmpp.io.OutputStream;
import org.zmpp.vm.Machine;

public class MemoryOutputStream
implements OutputStream {
    private static final int MAX_NESTING_DEPTH = 16;
    private Machine machine;
    private List<TablePosition> tableStack = new ArrayList<TablePosition>();
    private int tableWidth;

    public MemoryOutputStream(Machine machine) {
        this.machine = machine;
    }

    public void print(short s, boolean bl) {
        TablePosition tablePosition = this.tableStack.get(this.tableStack.size() - 1);
        int n = tablePosition.tableAddress + 2 + tablePosition.bytesWritten;
        this.machine.getGameData().getMemoryAccess().writeUnsignedByte(n, s);
        ++tablePosition.bytesWritten;
    }

    public void flush() {
    }

    public void close() {
    }

    public void deletePrevious(short s) {
    }

    public void select(boolean bl) {
        if (!bl && this.tableStack.size() > 0) {
            TablePosition tablePosition = this.tableStack.remove(this.tableStack.size() - 1);
            this.machine.getGameData().getMemoryAccess().writeUnsignedShort(tablePosition.tableAddress, tablePosition.bytesWritten);
            if (this.machine.getGameData().getStoryFileHeader().getVersion() == 6) {
                this.writeTextWidthInUnits(tablePosition);
            }
        }
    }

    private void writeTextWidthInUnits(TablePosition tablePosition) {
        int n = tablePosition.bytesWritten;
        short[] sArray = new short[n];
        MemoryAccess memoryAccess = this.machine.getGameData().getMemoryAccess();
        for (int i = 0; i < n; ++i) {
            sArray[i] = memoryAccess.readUnsignedByte(tablePosition.tableAddress + i + 2);
        }
        this.machine.getScreen6().setTextWidthInUnits(sArray);
    }

    public void select(int n, int n2) {
        this.tableWidth = n2;
        if (this.tableStack.size() < 16) {
            this.tableStack.add(new TablePosition(n));
        } else {
            this.machine.getCpu().halt("maximum nesting depth (16) for stream 3 exceeded");
        }
    }

    public boolean isSelected() {
        return !this.tableStack.isEmpty();
    }

    class TablePosition {
        int tableAddress;
        int bytesWritten;

        TablePosition(int n) {
            this.tableAddress = n;
        }
    }
}

