/*
 * Decompiled with CFR 0.152.
 */
package zpplet.data;

import zpplet.machine.ZMachine;

public class ZDictionary {
    protected ZMachine zm;
    protected int addr;
    protected String separators;
    protected int entry_length;
    protected int nentries;
    protected int wtable_addr;

    public ZDictionary(ZMachine zm) {
        this.zm = zm;
        this.addr = zm.hd.getDictionaryAddr();
        int n = zm.getByte(this.addr);
        char[] separray = new char[n];
        int i = 0;
        while (i < n) {
            separray[i] = (char)zm.getByte(this.addr + i + 1);
            ++i;
        }
        this.separators = new String(separray);
        this.entry_length = zm.getByte(this.addr + n + 1);
        this.nentries = zm.getWord(this.addr + n + 2);
        this.wtable_addr = this.addr + n + 4;
    }

    protected ZDictionary() {
    }

    protected boolean addToken(int textaddr, int wordaddr, int wordlength, int parseaddr, boolean keepUnknown) {
        int dictloc;
        int dictint;
        if (this.zm.getByte(parseaddr) == this.zm.getByte(parseaddr + 1)) {
            return true;
        }
        int[] encword = this.zm.zc.encode(wordaddr, wordlength, 2);
        int encint = encword[0] << 16 | encword[1];
        int first = 0;
        int last = this.nentries - 1;
        int middle = (last + first) / 2;
        while (true) {
            if (encint < (dictint = this.zm.getWord(dictloc = this.wtable_addr + middle * this.entry_length) << 16 | this.zm.getWord(dictloc + 2))) {
                if (first == middle) break;
                last = middle - 1;
                middle = (first + middle) / 2;
                continue;
            }
            if (encint <= dictint || last == middle) break;
            first = middle + 1;
            middle = (middle + last + 1) / 2;
        }
        if (encint != dictint) {
            dictloc = 0;
        }
        if (dictloc != 0 || keepUnknown) {
            int parseentry = parseaddr + this.zm.getByte(parseaddr + 1) * 4 + 2;
            this.zm.setWord(parseentry, dictloc);
            this.zm.setByte(parseentry + 2, wordlength);
            this.zm.setByte(parseentry + 3, wordaddr - textaddr + 1);
            this.zm.setByte(parseaddr + 1, this.zm.getByte(parseaddr + 1) + 1);
        }
        return this.zm.getByte(parseaddr) == this.zm.getByte(parseaddr + 1);
    }

    public void tokenize(int textaddr, int len, int parseaddr, boolean keepUnknown) {
        if (this.zm.getByte(parseaddr) < 6) {
            System.err.println("Parse buffer less than 6 words");
        }
        this.zm.setByte(parseaddr + 1, 0);
        int wstart = textaddr;
        int wlen = 0;
        boolean pbfull = false;
        int i = 0;
        while (i < len && !pbfull) {
            char ch = (char)this.zm.getByte(textaddr + i);
            if (this.separators.indexOf(ch) >= 0) {
                if (wlen > 0) {
                    this.addToken(textaddr, wstart, wlen, parseaddr, keepUnknown);
                }
                pbfull = this.addToken(textaddr, wstart + wlen, 1, parseaddr, keepUnknown);
                wstart += wlen + 1;
                wlen = 0;
            } else if (ch == ' ') {
                if (wlen > 0) {
                    this.addToken(textaddr, wstart, wlen, parseaddr, keepUnknown);
                }
                wstart += wlen + 1;
                wlen = 0;
            } else {
                ++wlen;
            }
            ++i;
        }
        if (!pbfull && wlen > 0) {
            this.addToken(textaddr, wstart, wlen, parseaddr, keepUnknown);
        }
    }
}

