/*
 * Decompiled with CFR 0.152.
 */
package zpplet.data;

import zpplet.data.ZDictionary4;
import zpplet.machine.ZMachine;

public class ZUserDictionary
extends ZDictionary4 {
    private boolean unsorted;

    public ZUserDictionary(ZMachine zm, int addr) {
        this.zm = zm;
        this.addr = addr;
        int n = zm.getByte(addr);
        char[] separray = new char[n];
        int i = 0;
        while (i < n) {
            separray[i] = (char)zm.getByte(addr + i + 1);
            ++i;
        }
        this.separators = new String(separray);
        this.entry_length = zm.getByte(addr + n + 1);
        this.nentries = zm.getWord(addr + n + 2);
        boolean bl = this.unsorted = this.nentries < 0;
        if (this.unsorted) {
            this.nentries = -this.nentries;
        }
        this.wtable_addr = addr + n + 4;
    }

    protected boolean addToken(int textaddr, int wordaddr, int wordlength, int parseaddr, boolean keepUnknown) {
        if (!this.unsorted) {
            return super.addToken(textaddr, wordaddr, wordlength, parseaddr, keepUnknown);
        }
        if (this.zm.getByte(parseaddr) == this.zm.getByte(parseaddr + 1)) {
            return true;
        }
        int[] encword = this.zm.zc.encode(wordaddr, wordlength, 3);
        long enclong = (long)encword[0] << 32 | (long)encword[1] << 16 | (long)encword[2];
        int dictloc = 0;
        long dictlong = 0L;
        int entry = 0;
        while (entry < this.nentries) {
            dictloc = this.wtable_addr + entry * this.entry_length;
            dictlong = (long)this.zm.getWord(dictloc) << 32 | (long)this.zm.getWord(dictloc + 2) << 16 | (long)this.zm.getWord(dictloc + 4);
            if (enclong == dictlong) break;
            ++entry;
        }
        if (enclong != dictlong) {
            dictloc = 0;
        }
        if (dictloc != 0 || keepUnknown) {
            int parseentry = parseaddr + this.zm.getByte(parseaddr + 1) * 4 + 2;
            this.zm.setWord(parseentry, dictloc);
            this.zm.setByte(parseentry + 2, wordlength);
            this.zm.setByte(parseentry + 3, wordaddr - textaddr);
            this.zm.setByte(parseaddr + 1, this.zm.getByte(parseaddr + 1) + 1);
        }
        return this.zm.getByte(parseaddr) == this.zm.getByte(parseaddr + 1);
    }
}

