/*
 * Decompiled with CFR 0.152.
 */
package zpplet.header;

import zpplet.header.ZHeader4;

public class ZHeader5
extends ZHeader4 {
    static final int SCREEN_WIDTH_UNITS = 34;
    static final int SCREEN_HEIGHT_UNITS = 36;
    static final int FONT_WIDTH_UNITS = 38;
    static final int FONT_HEIGHT_UNITS = 39;
    static final int DEFAULT_BACKGROUND_COLOR = 44;
    static final int DEFAULT_FOREGROUND_COLOR = 45;
    static final int TERMINATORS_BASE = 46;
    static final int ALPHABET_CUSTOM_BASE = 52;
    static final int EXTENSION_BASE = 54;
    static final int EXTENSION_LEN = 0;
    static final int EXTENSION_MOUSEX = 1;
    static final int EXTENSION_MOUSEY = 2;
    static final int EXTENSION_UNICODEBASE = 3;

    public ZHeader5(byte[] mem) {
        super(mem);
    }

    public int getAlphaCustomBase() {
        return this.getWord(52);
    }

    public void setColorsAvailable(boolean value) {
        this.m[1] = value ? (byte)(this.m[1] | 1) : (byte)(this.m[1] & 0xFE);
    }

    public void setGraphicsWanted(boolean value) {
        this.m[17] = value ? (byte)(this.m[17] | 8) : (byte)(this.m[17] & 0xF7);
    }

    public boolean getPicturesWanted() {
        return (this.m[17] & 8) != 0;
    }

    public void setPicturesAvailable(boolean value) {
        if (!value) {
            this.m[17] = (byte)(this.m[17] & 0xFFFFFFF7);
        }
    }

    public boolean getUndoWanted() {
        return (this.m[17] & 0x10) != 0;
    }

    public void setUndoAvailable(boolean value) {
        if (!value) {
            this.m[17] = (byte)(this.m[17] & 0xEF);
        }
    }

    public boolean getMouseWanted() {
        return (this.m[17] & 0x20) != 0;
    }

    public void setMouseAvailable(boolean value) {
        if (!value) {
            this.m[17] = (byte)(this.m[17] & 0xDF);
        }
    }

    public boolean getColorsWanted() {
        return (this.m[17] & 0x40) != 0;
    }

    public boolean getSoundWanted() {
        return (this.m[17] & 0x80) != 0;
    }

    public void setScreenHeightUnits(int value) {
        this.m[36] = (byte)(value >> 8);
        this.m[37] = (byte)(value & 0xFF);
    }

    public void setScreenWidthUnits(int value) {
        this.m[34] = (byte)(value >> 8);
        this.m[35] = (byte)(value & 0xFF);
    }

    public void setFontHeightUnits(int value) {
        this.m[39] = (byte)value;
    }

    public void setFontWidthUnits(int value) {
        this.m[38] = (byte)value;
    }

    public int getDefaultBackgroundColor() {
        return this.m[44];
    }

    public void setDefaultBackgroundColor(int value) {
        this.m[44] = (byte)value;
    }

    public int getDefaultForegroundColor() {
        return this.m[45];
    }

    public void setDefaultForegroundColor(int value) {
        this.m[45] = (byte)value;
    }

    public int getTerminatorsBase() {
        return this.getWord(46);
    }

    private int getExtension(int n) {
        int base = this.getWord(54);
        if (base == 0) {
            return 0;
        }
        int len = this.getWord(base + 0);
        if (len < n) {
            return 0;
        }
        return this.getWord(base + n * 2);
    }

    private void setExtension(int n, int value) {
        int base = this.getWord(54);
        if (base == 0) {
            return;
        }
        int len = this.getWord(base + 0);
        if (len < n) {
            return;
        }
        this.m[base + n * 2] = (byte)(value >> 8 & 0xFF);
        this.m[base + n * 2 + 1] = (byte)(value & 0xFF);
    }

    public int getUnicodeBase() {
        return this.getExtension(3);
    }

    public int getMouseClickX() {
        return this.getExtension(1);
    }

    public int getMouseClickY() {
        return this.getExtension(2);
    }

    public int getFileLength() {
        return this.getWord(26) * 4;
    }

    public void setMouseClick(int x, int y) {
        this.setExtension(1, x);
        this.setExtension(2, y);
    }
}

