/*
 * Decompiled with CFR 0.152.
 */
package zpplet.system;

import java.awt.Color;

public class ZColor {
    public static final int Z_UNDERCURSOR = -1;
    public static final int Z_CURRENT = 0;
    public static final int Z_DEFAULT = 1;
    public static final int Z_BLACK = 2;
    public static final int Z_RED = 3;
    public static final int Z_GREEN = 4;
    public static final int Z_YELLOW = 5;
    public static final int Z_BLUE = 6;
    public static final int Z_MAGENTA = 7;
    public static final int Z_CYAN = 8;
    public static final int Z_WHITE = 9;
    public static final int Z_LIGHTGRAY = 10;
    public static final int Z_GRAY = 11;
    public static final int Z_DARKGRAY = 12;
    public static final int Z_TRANSPARENT = 15;
    static final int INITIAL_FG_COLOR = 10;
    static final int INITIAL_BG_COLOR = 2;
    public static ZColor def = new ZColor(10, 2);
    public int zfg;
    public int zbg;
    public Color fg;
    public Color bg;

    public ZColor() {
        this.zfg = ZColor.def.zfg;
        this.zbg = ZColor.def.zbg;
        this.fg = ZColor.def.fg;
        this.bg = ZColor.def.bg;
    }

    public ZColor(int fg, int bg) {
        this.setZColor(fg, bg);
    }

    public static void setDefaultForeground(String name) {
        def.setZColor(ZColor.getZColor(name), 0);
    }

    public static void setDefaultBackground(String name) {
        def.setZColor(0, ZColor.getZColor(name));
    }

    public void setZColor(int fore, int back) {
        if (fore != 0) {
            this.zfg = fore == 1 ? ZColor.def.zfg : fore;
            this.fg = ZColor.getColor(this.zfg);
        }
        if (back != 0) {
            this.zbg = back == 1 ? ZColor.def.zbg : back;
            this.bg = ZColor.getColor(this.zbg);
        }
    }

    private static Color getColor(int number) {
        switch (number) {
            case 2: {
                return Color.black;
            }
            case 3: {
                return Color.red.darker();
            }
            case 4: {
                return Color.green.darker();
            }
            case 5: {
                return Color.yellow;
            }
            case 6: {
                return Color.blue.darker();
            }
            case 7: {
                return Color.magenta;
            }
            case 8: {
                return Color.cyan;
            }
            case 9: {
                return Color.white;
            }
            case 10: {
                return Color.lightGray;
            }
            case 11: {
                return Color.gray;
            }
            case 12: {
                return Color.darkGray;
            }
            case 15: {
                return null;
            }
        }
        System.err.println("getColor(" + number + ") attempted");
        return Color.black;
    }

    private static int getZColor(String name) {
        if (name.equalsIgnoreCase("black")) {
            return 2;
        }
        if (name.equalsIgnoreCase("red")) {
            return 3;
        }
        if (name.equalsIgnoreCase("green")) {
            return 4;
        }
        if (name.equalsIgnoreCase("yellow")) {
            return 5;
        }
        if (name.equalsIgnoreCase("blue")) {
            return 6;
        }
        if (name.equalsIgnoreCase("magenta")) {
            return 7;
        }
        if (name.equalsIgnoreCase("cyan")) {
            return 8;
        }
        if (name.equalsIgnoreCase("white")) {
            return 9;
        }
        if (name.equalsIgnoreCase("lightgray")) {
            return 10;
        }
        if (name.equalsIgnoreCase("gray")) {
            return 11;
        }
        if (name.equalsIgnoreCase("darkgray")) {
            return 12;
        }
        System.err.println("Unknown color name '" + name + "'");
        return 1;
    }
}

