/*
 * Decompiled with CFR 0.152.
 */
package zpplet.system;

import com.sun.media.sound.AiffFileReader;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import zpplet.ZUserConfig;
import zpplet.iff.IFF;
import zpplet.iff.IFFInput;
import zpplet.machine.ZMachine;
import zpplet.system.ZScreen;

public class ZMedia
implements LineListener {
    private IFFInput iff;
    private Object[] pics;
    private byte[][] sounds;
    private int[] loops;
    private Clip clip;
    private short release;
    private byte[] zimage;

    public boolean readBlorbFile(String fname) {
        try {
            this.iff = new IFFInput(fname);
            IFF.ChunkInfo ci = this.iff.openChunk();
            if (!ci.type.equals("FORMIFRS")) {
                throw new IOException("Not a valid Blorb file");
            }
            if (this.iff.skipToChunk("RIdx") == null) {
                throw new IOException("Missing Blorb index chunk");
            }
            int nResources = this.iff.readInt();
            ResourceInfo[] info = new ResourceInfo[nResources];
            int maxpics = 0;
            int maxsounds = 0;
            int i = 0;
            while (i < nResources) {
                String usage = this.iff.read4Chars();
                int index = this.iff.readInt();
                int start = this.iff.readInt();
                info[i] = new ResourceInfo(usage, index, start);
                if (usage.equals("Pict")) {
                    if (maxpics < index) {
                        maxpics = index;
                    }
                } else if (usage.equals("Snd ") && maxsounds < index) {
                    maxsounds = index;
                }
                ++i;
            }
            this.iff.closeChunk();
            this.pics = new Object[maxpics + 1];
            this.sounds = new byte[maxsounds + 1][];
            i = 0;
            while (i < nResources) {
                ResourceInfo ri = info[i];
                if (ri.usage.equals("Pict")) {
                    this.pics[ri.index] = this.loadImage(ri.start);
                } else if (ri.usage.equals("Snd ")) {
                    this.sounds[ri.index] = this.loadSound(ri.start);
                }
                ++i;
            }
            ci = this.iff.skipToChunk("Loop");
            if (ci != null) {
                this.loops = new int[maxsounds + 1];
                i = 0;
                while (i < this.loops.length) {
                    this.loops[i] = 1;
                    ++i;
                }
                i = 0;
                while (i < ci.length / 8) {
                    int n = this.iff.readInt();
                    this.loops[n] = this.iff.readInt();
                    ++i;
                }
                this.iff.closeChunk();
            }
            if ((ci = this.iff.skipToChunk("RelN")) != null) {
                this.release = this.iff.readShort();
                this.iff.closeChunk();
            } else {
                this.release = 0;
            }
            ci = this.iff.skipToChunk("ZCOD");
            if (ci != null) {
                this.zimage = new byte[ci.length];
                this.iff.read(this.zimage, 0, ci.length);
                this.iff.closeChunk();
            } else {
                this.zimage = null;
            }
            this.iff.close();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public ZMachine getZM(ZScreen s) {
        if (this.zimage == null) {
            return null;
        }
        return ZMachine.NewZMachine(this.zimage, s);
    }

    public int getPictureCount() {
        return this.pics.length + 1;
    }

    public short getRelease() {
        return this.release;
    }

    private byte[] loadSound(int start) throws Exception {
        byte[] result;
        this.iff.seek(start);
        IFF.ChunkInfo ci = this.iff.openChunk();
        if (ci.type.equals("FORMAIFF")) {
            result = new byte[ci.length];
            this.iff.seek(start);
            this.iff.read(result);
        } else {
            result = null;
            System.err.println("Unsupported sound type " + ci.type);
        }
        this.iff.closeChunk();
        return result;
    }

    private Object loadImage(int start) throws Exception {
        Object result;
        this.iff.seek(start);
        IFF.ChunkInfo ci = this.iff.openChunk();
        if (ci.type.equals("PNG ")) {
            byte[] image = new byte[ci.length];
            this.iff.read(image);
            ByteArrayInputStream ba = new ByteArrayInputStream(image);
            BufferedImage bi = ImageIO.read(ba);
            result = ZUserConfig.v6scale != 1 ? bi.getScaledInstance(bi.getWidth() * ZUserConfig.v6scale, -1, 4) : bi;
        } else if (ci.type.equals("JPEG")) {
            byte[] image = new byte[ci.length];
            this.iff.read(image);
            ByteArrayInputStream ba = new ByteArrayInputStream(image);
            BufferedImage bi = ImageIO.read(ba);
            result = ZUserConfig.v6scale != 1 ? bi.getScaledInstance(bi.getWidth() * ZUserConfig.v6scale, -1, 4) : bi;
        } else if (ci.type.equals("Rect")) {
            result = new Dimension(this.iff.readInt() * ZUserConfig.v6scale, this.iff.readInt() * ZUserConfig.v6scale);
        } else {
            result = null;
            System.err.println("Invalid image type " + ci.type);
        }
        return result;
    }

    public void update(LineEvent event) {
        if (event.getType() == LineEvent.Type.STOP) {
            this.clip.removeLineListener(this);
            this.clip.close();
            this.clip = null;
        }
    }

    private int getLoops(int index) {
        if (this.loops == null) {
            return 1;
        }
        if (this.loops[index] == 0) {
            return 255;
        }
        return this.loops[index];
    }

    public static void beep(int n) {
        Toolkit.getDefaultToolkit().beep();
    }

    public void playSound(int n, int vol, int loops) {
        this.stopSound();
        if (n < 0 || n >= this.sounds.length || this.sounds[n] == null) {
            System.err.println("Tried to play invalid sound " + n);
            return;
        }
        try {
            ByteArrayInputStream ba = new ByteArrayInputStream(this.sounds[n]);
            AiffFileReader fr = new AiffFileReader();
            AudioInputStream as = fr.getAudioInputStream(ba);
            this.clip = AudioSystem.getClip();
            this.clip.open(as);
            this.clip.addLineListener(this);
            FloatControl gain = (FloatControl)this.clip.getControl(FloatControl.Type.MASTER_GAIN);
            if (vol < 8) {
                gain.setValue(vol - 8);
            }
            if (loops == 0) {
                loops = this.getLoops(n);
            }
            this.clip.loop(loops == 255 ? -1 : loops - 1);
        }
        catch (Exception e) {
            System.err.println("playSound() error: " + e.getMessage());
        }
    }

    public void stopSound() {
        if (this.clip != null) {
            this.clip.stop();
            while (this.clip != null) {
            }
        }
    }

    public Image getImage(int index) {
        return (Image)this.pics[index];
    }

    public Dimension getImageData(int index) {
        Object p = this.pics[index];
        if (p instanceof Image) {
            return new Dimension(((Image)p).getWidth(null), ((Image)p).getHeight(null));
        }
        if (p instanceof Dimension) {
            return (Dimension)p;
        }
        return null;
    }

    public void cacheSound(int index) {
    }

    public void uncacheSound(int index) {
        this.stopSound();
    }

    private class ResourceInfo {
        public String usage;
        public int index;
        public int start;

        public ResourceInfo(String u, int i, int s) {
            this.usage = u;
            this.index = i;
            this.start = s;
        }
    }
}

