/*
 * Decompiled with CFR 0.152.
 */
package zpplet.system;

import java.util.Vector;
import zpplet.ZUserConfig;
import zpplet.machine.ZMachine;
import zpplet.misc.ScrollBuffer;
import zpplet.system.ZFont;
import zpplet.system.ZWindow;

public class ZWindow0
extends ZWindow {
    private ScrollBuffer para = new ScrollBuffer(ZUserConfig.scrollback);

    public ZWindow0(ZMachine zm) {
        super(zm, 0);
    }

    public void newLine() {
        this.para.nextLine();
        this.appendFormatChars();
        super.newLine();
    }

    protected synchronized void bufferChar(int ch) {
        this.para.append((char)ch);
        super.bufferChar(ch);
    }

    public void resize(int width, int height) {
        this.flush();
        int delta = this.getCursorY() - height;
        if (delta > 0 || delta < 0 && this.getCursorY() >= this.getLines()) {
            this.ypos -= delta * this.screen.getLineHeight();
        }
        this.width = width * this.screen.unitx;
        this.height = height * this.screen.unity;
        if (!this.inBounds(this.xpos) || this.ypos >= this.height) {
            this.xpos = this.leftmargin;
            this.ypos = 0;
        }
        this.resetLineCount();
        this.renderLines();
    }

    private Vector splitLine(String s, int maxwidth) {
        Vector<String> result = new Vector<String>();
        int start = 0;
        int end = 0;
        int first = 0;
        int last = 0;
        int wstart = 0;
        int prewidth = 0;
        int format = s.indexOf(65535);
        if (format == -1) {
            format = s.length();
        }
        while (first < s.length()) {
            int space = s.indexOf(32, first);
            if (space == -1) {
                space = s.length();
            }
            last = format < space ? format : space;
            int width = prewidth + this.screen.getStringWidth(s.substring(wstart, last), this.font);
            while (width > maxwidth) {
                if (start < end) {
                    result.add(s.substring(start, end));
                    end = wstart = first;
                    start = wstart;
                    prewidth = 0;
                    width = this.screen.getStringWidth(s.substring(first, last), this.font);
                }
                while (width > maxwidth && last - first > 1) {
                    width = prewidth + this.screen.getStringWidth(s.substring(first, --last), this.font);
                }
                end = last;
            }
            if (format < space) {
                prewidth += this.screen.getStringWidth(s.substring(wstart, format), this.font);
                end = wstart = format + 3;
                first = wstart;
                this.setFormat(s.charAt(format + 1), s.charAt(format + 2));
                format = s.indexOf(65535, first);
                if (format != -1) continue;
                format = s.length();
                continue;
            }
            first = end = space;
            while (first < s.length() && s.charAt(first) == ' ') {
                ++first;
            }
        }
        result.add(s.substring(start, end));
        return result;
    }

    public void renderLines() {
        ZFont curfont = this.font;
        this.clear();
        int line = 0;
        int yline = this.getCursorY();
        while (yline >= 0) {
            String s;
            if ((s = this.para.get(line++)) == null) break;
            Vector split = this.splitLine(s, this.width);
            yline -= split.size();
            int i = 0;
            while (i < split.size()) {
                this.drawFormatText(this.left, this.top + (yline + i) * this.screen.getLineHeight(), (String)split.get(i));
                ++i;
            }
        }
        this.font = curfont;
        if (this.pausing) {
            this.drawMore();
        }
    }

    private void setFormat(int stylechar, int colorchar) {
        this.font.set(stylechar >> 8);
        this.font.setStyle(stylechar & 0xFF);
        this.font.color.setZColor(colorchar & 0xFF, colorchar >> 8);
    }

    private void drawFormatText(int x, int y, String text) {
        int p = 0;
        while (true) {
            int i;
            if ((i = text.indexOf(65535, p)) == -1) {
                this.screen.drawText(x, y, text.substring(p), this);
                return;
            }
            if (i > p) {
                x += this.screen.drawText(x, y, text.substring(p, i), this);
            }
            this.setFormat(text.charAt(i + 1), text.charAt(i + 2));
            p = i + 3;
        }
    }

    public void postInputLine(String s) {
        this.para.append(s);
    }

    private void appendFormatChars() {
        this.para.append('\uffff');
        this.para.append((char)(this.font.getZFont() << 8 | this.font.getZStyle()));
        this.para.append((char)this.font.getColorBytes());
    }

    public void setColor(int fg, int bg) {
        super.setColor(fg, bg);
        this.appendFormatChars();
    }

    public void setStyle(int style) {
        super.setStyle(style);
        this.appendFormatChars();
    }

    public int setFont(int zfont) {
        int result = super.setFont(zfont);
        this.appendFormatChars();
        return result;
    }
}

